/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Adds to z the spherical inversion of z

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_add_spherical_invert.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAddSphericalInvertIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 t = z;
	REAL d = 1.0f / dot(t, t);
	REAL r = 1.0f / aux->r;

	if (!fractal->transformCommon.functionEnabledFalse)
		d = r + (d - r) * fractal->transformCommon.scaleA1;
	else
		d = d + (r - d) * fractal->transformCommon.scaleA1;

	REAL4 g = fractal->transformCommon.scale3D111;
	t *= g * d;
	aux->DE += 1.0f / aux->DE;
	z = (z + t) * fractal->transformCommon.scaleB1;
	aux->DE *= fractal->transformCommon.scaleB1;

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}
	return z;
}