package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// CertificateOrdersClient is the webSite Management Client
type CertificateOrdersClient struct {
	BaseClient
}

// NewCertificateOrdersClient creates an instance of the CertificateOrdersClient client.
func NewCertificateOrdersClient(subscriptionID string) CertificateOrdersClient {
	return NewCertificateOrdersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCertificateOrdersClientWithBaseURI creates an instance of the CertificateOrdersClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) CertificateOrdersClient {
	return CertificateOrdersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateCertificate sends the create or update certificate request.
// Parameters:
// resourceGroupName - azure resource group name
// certificateOrderName - certificate name
// name - certificate name
// keyVaultCertificate - key Vault secret csm Id
func (client CertificateOrdersClient) CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (result CertificateOrderCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.CreateOrUpdateCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateCertificatePreparer prepares the CreateOrUpdateCertificate request.
func (client CertificateOrdersClient) CreateOrUpdateCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateCertificateSender sends the CreateOrUpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) CreateOrUpdateCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateCertificateResponder handles the response to the CreateOrUpdateCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) CreateOrUpdateCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateCertificateOrder sends the create or update certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
// certificateDistinguishedName - distinguished name to be used for purchasing certificate
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrder(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (result CertificateOrder, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.CreateOrUpdateCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateCertificateOrderPreparer(ctx, resourceGroupName, name, certificateDistinguishedName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateCertificateOrderPreparer prepares the CreateOrUpdateCertificateOrder request.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateCertificateOrderSender sends the CreateOrUpdateCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateCertificateOrderResponder handles the response to the CreateOrUpdateCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCertificate sends the delete certificate request.
// Parameters:
// resourceGroupName - azure resource group name
// certificateOrderName - certificate name
// name - certificate name
func (client CertificateOrdersClient) DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.DeleteCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", resp, "Failure responding to request")
	}

	return
}

// DeleteCertificatePreparer prepares the DeleteCertificate request.
func (client CertificateOrdersClient) DeleteCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCertificateSender sends the DeleteCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) DeleteCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteCertificateResponder handles the response to the DeleteCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) DeleteCertificateResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCertificateOrder sends the delete certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
func (client CertificateOrdersClient) DeleteCertificateOrder(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.DeleteCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCertificateOrderPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// DeleteCertificateOrderPreparer prepares the DeleteCertificateOrder request.
func (client CertificateOrdersClient) DeleteCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCertificateOrderSender sends the DeleteCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) DeleteCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteCertificateOrderResponder handles the response to the DeleteCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) DeleteCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificate sends the get certificate request.
// Parameters:
// resourceGroupName - azure resource group name
// certificateOrderName - certificate name
// name - certificate name
func (client CertificateOrdersClient) GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result CertificateOrderCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.GetCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", resp, "Failure responding to request")
	}

	return
}

// GetCertificatePreparer prepares the GetCertificate request.
func (client CertificateOrdersClient) GetCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCertificateSender sends the GetCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCertificateResponder handles the response to the GetCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificateOrder sends the get certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
func (client CertificateOrdersClient) GetCertificateOrder(ctx context.Context, resourceGroupName string, name string) (result CertificateOrder, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCertificateOrderPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.GetCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// GetCertificateOrderPreparer prepares the GetCertificateOrder request.
func (client CertificateOrdersClient) GetCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCertificateOrderSender sends the GetCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCertificateOrderResponder handles the response to the GetCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificateOrders sends the get certificate orders request.
// Parameters:
// resourceGroupName - azure resource group name
func (client CertificateOrdersClient) GetCertificateOrders(ctx context.Context, resourceGroupName string) (result CertificateOrderCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificateOrders")
		defer func() {
			sc := -1
			if result.coc.Response.Response != nil {
				sc = result.coc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getCertificateOrdersNextResults
	req, err := client.GetCertificateOrdersPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCertificateOrdersSender(req)
	if err != nil {
		result.coc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", resp, "Failure sending request")
		return
	}

	result.coc, err = client.GetCertificateOrdersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", resp, "Failure responding to request")
	}
	if result.coc.hasNextLink() && result.coc.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// GetCertificateOrdersPreparer prepares the GetCertificateOrders request.
func (client CertificateOrdersClient) GetCertificateOrdersPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCertificateOrdersSender sends the GetCertificateOrders request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateOrdersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCertificateOrdersResponder handles the response to the GetCertificateOrders request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateOrdersResponder(resp *http.Response) (result CertificateOrderCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getCertificateOrdersNextResults retrieves the next set of results, if any.
func (client CertificateOrdersClient) getCertificateOrdersNextResults(ctx context.Context, lastResults CertificateOrderCollection) (result CertificateOrderCollection, err error) {
	req, err := lastResults.certificateOrderCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificateOrdersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetCertificateOrdersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificateOrdersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetCertificateOrdersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificateOrdersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetCertificateOrdersComplete enumerates all values, automatically crossing page boundaries as required.
func (client CertificateOrdersClient) GetCertificateOrdersComplete(ctx context.Context, resourceGroupName string) (result CertificateOrderCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificateOrders")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetCertificateOrders(ctx, resourceGroupName)
	return
}

// GetCertificates sends the get certificates request.
// Parameters:
// resourceGroupName - azure resource group name
// certificateOrderName - certificate name
func (client CertificateOrdersClient) GetCertificates(ctx context.Context, resourceGroupName string, certificateOrderName string) (result CertificateOrderCertificateCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificates")
		defer func() {
			sc := -1
			if result.cocc.Response.Response != nil {
				sc = result.cocc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getCertificatesNextResults
	req, err := client.GetCertificatesPreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCertificatesSender(req)
	if err != nil {
		result.cocc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", resp, "Failure sending request")
		return
	}

	result.cocc, err = client.GetCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", resp, "Failure responding to request")
	}
	if result.cocc.hasNextLink() && result.cocc.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// GetCertificatesPreparer prepares the GetCertificates request.
func (client CertificateOrdersClient) GetCertificatesPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCertificatesSender sends the GetCertificates request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificatesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCertificatesResponder handles the response to the GetCertificates request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificatesResponder(resp *http.Response) (result CertificateOrderCertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getCertificatesNextResults retrieves the next set of results, if any.
func (client CertificateOrdersClient) getCertificatesNextResults(ctx context.Context, lastResults CertificateOrderCertificateCollection) (result CertificateOrderCertificateCollection, err error) {
	req, err := lastResults.certificateOrderCertificateCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificatesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificatesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "getCertificatesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetCertificatesComplete enumerates all values, automatically crossing page boundaries as required.
func (client CertificateOrdersClient) GetCertificatesComplete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result CertificateOrderCertificateCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.GetCertificates")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetCertificates(ctx, resourceGroupName, certificateOrderName)
	return
}

// ReissueCertificateOrder sends the reissue certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
// reissueCertificateOrderRequest - reissue parameters
func (client CertificateOrdersClient) ReissueCertificateOrder(ctx context.Context, resourceGroupName string, name string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.ReissueCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ReissueCertificateOrderPreparer(ctx, resourceGroupName, name, reissueCertificateOrderRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.ReissueCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.ReissueCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// ReissueCertificateOrderPreparer prepares the ReissueCertificateOrder request.
func (client CertificateOrdersClient) ReissueCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/reissue", pathParameters),
		autorest.WithJSON(reissueCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReissueCertificateOrderSender sends the ReissueCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) ReissueCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ReissueCertificateOrderResponder handles the response to the ReissueCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) ReissueCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RenewCertificateOrder sends the renew certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
// renewCertificateOrderRequest - renew parameters
func (client CertificateOrdersClient) RenewCertificateOrder(ctx context.Context, resourceGroupName string, name string, renewCertificateOrderRequest RenewCertificateOrderRequest) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.RenewCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RenewCertificateOrderPreparer(ctx, resourceGroupName, name, renewCertificateOrderRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.RenewCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.RenewCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// RenewCertificateOrderPreparer prepares the RenewCertificateOrder request.
func (client CertificateOrdersClient) RenewCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string, renewCertificateOrderRequest RenewCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/renew", pathParameters),
		autorest.WithJSON(renewCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RenewCertificateOrderSender sends the RenewCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RenewCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RenewCertificateOrderResponder handles the response to the RenewCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RenewCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResendCertificateEmail sends the resend certificate email request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate order name
func (client CertificateOrdersClient) ResendCertificateEmail(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.ResendCertificateEmail")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ResendCertificateEmailPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResendCertificateEmailSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", resp, "Failure sending request")
		return
	}

	result, err = client.ResendCertificateEmailResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", resp, "Failure responding to request")
	}

	return
}

// ResendCertificateEmailPreparer prepares the ResendCertificateEmail request.
func (client CertificateOrdersClient) ResendCertificateEmailPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/resendEmail", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResendCertificateEmailSender sends the ResendCertificateEmail request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) ResendCertificateEmailSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ResendCertificateEmailResponder handles the response to the ResendCertificateEmail request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) ResendCertificateEmailResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveCertificateActions sends the retrieve certificate actions request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate order name
func (client CertificateOrdersClient) RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string) (result ListCertificateOrderAction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.RetrieveCertificateActions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RetrieveCertificateActionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", nil, "Failure preparing request")
		return
	}

	resp, err := client.RetrieveCertificateActionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure sending request")
		return
	}

	result, err = client.RetrieveCertificateActionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateActionsPreparer prepares the RetrieveCertificateActions request.
func (client CertificateOrdersClient) RetrieveCertificateActionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RetrieveCertificateActionsSender sends the RetrieveCertificateActions request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RetrieveCertificateActionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RetrieveCertificateActionsResponder handles the response to the RetrieveCertificateActions request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RetrieveCertificateActionsResponder(resp *http.Response) (result ListCertificateOrderAction, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveCertificateEmailHistory sends the retrieve certificate email history request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate order name
func (client CertificateOrdersClient) RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string) (result ListCertificateEmail, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.RetrieveCertificateEmailHistory")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RetrieveCertificateEmailHistoryPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.RetrieveCertificateEmailHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure sending request")
		return
	}

	result, err = client.RetrieveCertificateEmailHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateEmailHistoryPreparer prepares the RetrieveCertificateEmailHistory request.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistoryPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RetrieveCertificateEmailHistorySender sends the RetrieveCertificateEmailHistory request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistorySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RetrieveCertificateEmailHistoryResponder handles the response to the RetrieveCertificateEmailHistory request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistoryResponder(resp *http.Response) (result ListCertificateEmail, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCertificate sends the update certificate request.
// Parameters:
// resourceGroupName - azure resource group name
// certificateOrderName - certificate name
// name - certificate name
// keyVaultCertificate - key Vault secret csm Id
func (client CertificateOrdersClient) UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (result CertificateOrderCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.UpdateCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", resp, "Failure responding to request")
	}

	return
}

// UpdateCertificatePreparer prepares the UpdateCertificate request.
func (client CertificateOrdersClient) UpdateCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCertificateSender sends the UpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) UpdateCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateCertificateResponder handles the response to the UpdateCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) UpdateCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCertificateOrder sends the update certificate order request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate name
// certificateDistinguishedName - distinguished name to be used for purchasing certificate
func (client CertificateOrdersClient) UpdateCertificateOrder(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (result CertificateOrder, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.UpdateCertificateOrder")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateCertificateOrderPreparer(ctx, resourceGroupName, name, certificateDistinguishedName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// UpdateCertificateOrderPreparer prepares the UpdateCertificateOrder request.
func (client CertificateOrdersClient) UpdateCertificateOrderPreparer(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCertificateOrderSender sends the UpdateCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) UpdateCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateCertificateOrderResponder handles the response to the UpdateCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) UpdateCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// VerifyDomainOwnership sends the verify domain ownership request.
// Parameters:
// resourceGroupName - azure resource group name
// name - certificate order name
func (client CertificateOrdersClient) VerifyDomainOwnership(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrdersClient.VerifyDomainOwnership")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.VerifyDomainOwnershipPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", nil, "Failure preparing request")
		return
	}

	resp, err := client.VerifyDomainOwnershipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure sending request")
		return
	}

	result, err = client.VerifyDomainOwnershipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure responding to request")
	}

	return
}

// VerifyDomainOwnershipPreparer prepares the VerifyDomainOwnership request.
func (client CertificateOrdersClient) VerifyDomainOwnershipPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/verifyDomainOwnership", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// VerifyDomainOwnershipSender sends the VerifyDomainOwnership request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) VerifyDomainOwnershipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// VerifyDomainOwnershipResponder handles the response to the VerifyDomainOwnership request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) VerifyDomainOwnershipResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
