package synapse

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActualState enumerates the values for actual state.
type ActualState string

const (
	// Disabled ...
	Disabled ActualState = "Disabled"
	// Disabling ...
	Disabling ActualState = "Disabling"
	// Enabled ...
	Enabled ActualState = "Enabled"
	// Enabling ...
	Enabling ActualState = "Enabling"
	// Unknown ...
	Unknown ActualState = "Unknown"
)

// PossibleActualStateValues returns an array of possible values for the ActualState const type.
func PossibleActualStateValues() []ActualState {
	return []ActualState{Disabled, Disabling, Enabled, Enabling, Unknown}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// ColumnDataType enumerates the values for column data type.
type ColumnDataType string

const (
	// Bigint ...
	Bigint ColumnDataType = "bigint"
	// Binary ...
	Binary ColumnDataType = "binary"
	// Bit ...
	Bit ColumnDataType = "bit"
	// Char ...
	Char ColumnDataType = "char"
	// Date ...
	Date ColumnDataType = "date"
	// Datetime ...
	Datetime ColumnDataType = "datetime"
	// Datetime2 ...
	Datetime2 ColumnDataType = "datetime2"
	// Datetimeoffset ...
	Datetimeoffset ColumnDataType = "datetimeoffset"
	// Decimal ...
	Decimal ColumnDataType = "decimal"
	// Float ...
	Float ColumnDataType = "float"
	// Geography ...
	Geography ColumnDataType = "geography"
	// Geometry ...
	Geometry ColumnDataType = "geometry"
	// Hierarchyid ...
	Hierarchyid ColumnDataType = "hierarchyid"
	// Image ...
	Image ColumnDataType = "image"
	// Int ...
	Int ColumnDataType = "int"
	// Money ...
	Money ColumnDataType = "money"
	// Nchar ...
	Nchar ColumnDataType = "nchar"
	// Ntext ...
	Ntext ColumnDataType = "ntext"
	// Numeric ...
	Numeric ColumnDataType = "numeric"
	// Nvarchar ...
	Nvarchar ColumnDataType = "nvarchar"
	// Real ...
	Real ColumnDataType = "real"
	// Smalldatetime ...
	Smalldatetime ColumnDataType = "smalldatetime"
	// Smallint ...
	Smallint ColumnDataType = "smallint"
	// Smallmoney ...
	Smallmoney ColumnDataType = "smallmoney"
	// SQLVariant ...
	SQLVariant ColumnDataType = "sql_variant"
	// Sysname ...
	Sysname ColumnDataType = "sysname"
	// Text ...
	Text ColumnDataType = "text"
	// Time ...
	Time ColumnDataType = "time"
	// Timestamp ...
	Timestamp ColumnDataType = "timestamp"
	// Tinyint ...
	Tinyint ColumnDataType = "tinyint"
	// Uniqueidentifier ...
	Uniqueidentifier ColumnDataType = "uniqueidentifier"
	// Varbinary ...
	Varbinary ColumnDataType = "varbinary"
	// Varchar ...
	Varchar ColumnDataType = "varchar"
	// XML ...
	XML ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns an array of possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{Bigint, Binary, Bit, Char, Date, Datetime, Datetime2, Datetimeoffset, Decimal, Float, Geography, Geometry, Hierarchyid, Image, Int, Money, Nchar, Ntext, Numeric, Nvarchar, Real, Smalldatetime, Smallint, Smallmoney, SQLVariant, Sysname, Text, Time, Timestamp, Tinyint, Uniqueidentifier, Varbinary, Varchar, XML}
}

// DataFlowComputeType enumerates the values for data flow compute type.
type DataFlowComputeType string

const (
	// ComputeOptimized ...
	ComputeOptimized DataFlowComputeType = "ComputeOptimized"
	// General ...
	General DataFlowComputeType = "General"
	// MemoryOptimized ...
	MemoryOptimized DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns an array of possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{ComputeOptimized, General, MemoryOptimized}
}

// DesiredState enumerates the values for desired state.
type DesiredState string

const (
	// DesiredStateDisabled ...
	DesiredStateDisabled DesiredState = "Disabled"
	// DesiredStateEnabled ...
	DesiredStateEnabled DesiredState = "Enabled"
)

// PossibleDesiredStateValues returns an array of possible values for the DesiredState const type.
func PossibleDesiredStateValues() []DesiredState {
	return []DesiredState{DesiredStateDisabled, DesiredStateEnabled}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// AuthKey1 ...
	AuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// AuthKey2 ...
	AuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{AuthKey1, AuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// Off ...
	Off IntegrationRuntimeAutoUpdate = "Off"
	// On ...
	On IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{Off, On}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// Enterprise ...
	Enterprise IntegrationRuntimeEdition = "Enterprise"
	// Standard ...
	Standard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{Enterprise, Standard}
}

// IntegrationRuntimeEntityReferenceType enumerates the values for integration runtime entity reference type.
type IntegrationRuntimeEntityReferenceType string

const (
	// IntegrationRuntimeReference ...
	IntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	// LinkedServiceReference ...
	LinkedServiceReference IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns an array of possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{IntegrationRuntimeReference, LinkedServiceReference}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// NotEncrypted ...
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// NotSet ...
	NotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// SslEncrypted ...
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{NotEncrypted, NotSet, SslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// BasePrice ...
	BasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{BasePrice, LicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// AccessDenied ...
	AccessDenied IntegrationRuntimeState = "AccessDenied"
	// Initial ...
	Initial IntegrationRuntimeState = "Initial"
	// Limited ...
	Limited IntegrationRuntimeState = "Limited"
	// NeedRegistration ...
	NeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// Offline ...
	Offline IntegrationRuntimeState = "Offline"
	// Online ...
	Online IntegrationRuntimeState = "Online"
	// Started ...
	Started IntegrationRuntimeState = "Started"
	// Starting ...
	Starting IntegrationRuntimeState = "Starting"
	// Stopped ...
	Stopped IntegrationRuntimeState = "Stopped"
	// Stopping ...
	Stopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{AccessDenied, Initial, Limited, NeedRegistration, Offline, Online, Started, Starting, Stopped, Stopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// Managed ...
	Managed IntegrationRuntimeType = "Managed"
	// SelfHosted ...
	SelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{Managed, SelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// Fail ...
	Fail IntegrationRuntimeUpdateResult = "Fail"
	// None ...
	None IntegrationRuntimeUpdateResult = "None"
	// Succeed ...
	Succeed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{Fail, None, Succeed}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// ManagedIntegrationRuntimeNodeStatusAvailable ...
	ManagedIntegrationRuntimeNodeStatusAvailable ManagedIntegrationRuntimeNodeStatus = "Available"
	// ManagedIntegrationRuntimeNodeStatusRecycling ...
	ManagedIntegrationRuntimeNodeStatusRecycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// ManagedIntegrationRuntimeNodeStatusStarting ...
	ManagedIntegrationRuntimeNodeStatusStarting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// ManagedIntegrationRuntimeNodeStatusUnavailable ...
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{ManagedIntegrationRuntimeNodeStatusAvailable, ManagedIntegrationRuntimeNodeStatusRecycling, ManagedIntegrationRuntimeNodeStatusStarting, ManagedIntegrationRuntimeNodeStatusUnavailable}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// CancelInProgress ...
	CancelInProgress ManagementOperationState = "CancelInProgress"
	// Cancelled ...
	Cancelled ManagementOperationState = "Cancelled"
	// Failed ...
	Failed ManagementOperationState = "Failed"
	// InProgress ...
	InProgress ManagementOperationState = "InProgress"
	// Pending ...
	Pending ManagementOperationState = "Pending"
	// Succeeded ...
	Succeeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{CancelInProgress, Cancelled, Failed, InProgress, Pending, Succeeded}
}

// NodeSize enumerates the values for node size.
type NodeSize string

const (
	// NodeSizeLarge ...
	NodeSizeLarge NodeSize = "Large"
	// NodeSizeMedium ...
	NodeSizeMedium NodeSize = "Medium"
	// NodeSizeNone ...
	NodeSizeNone NodeSize = "None"
	// NodeSizeSmall ...
	NodeSizeSmall NodeSize = "Small"
)

// PossibleNodeSizeValues returns an array of possible values for the NodeSize const type.
func PossibleNodeSizeValues() []NodeSize {
	return []NodeSize{NodeSizeLarge, NodeSizeMedium, NodeSizeNone, NodeSizeSmall}
}

// NodeSizeFamily enumerates the values for node size family.
type NodeSizeFamily string

const (
	// NodeSizeFamilyMemoryOptimized ...
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = "MemoryOptimized"
	// NodeSizeFamilyNone ...
	NodeSizeFamilyNone NodeSizeFamily = "None"
)

// PossibleNodeSizeFamilyValues returns an array of possible values for the NodeSizeFamily const type.
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return []NodeSizeFamily{NodeSizeFamilyMemoryOptimized, NodeSizeFamilyNone}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCanceled ...
	OperationStatusCanceled OperationStatus = "Canceled"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCanceled, OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleteError ...
	ProvisioningStateDeleteError ProvisioningState = "DeleteError"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleteError, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Failed, ProvisioningState1Succeeded}
}

// QueryAggregationFunction enumerates the values for query aggregation function.
type QueryAggregationFunction string

const (
	// Avg ...
	Avg QueryAggregationFunction = "avg"
	// Max ...
	Max QueryAggregationFunction = "max"
	// Min ...
	Min QueryAggregationFunction = "min"
	// Sum ...
	Sum QueryAggregationFunction = "sum"
)

// PossibleQueryAggregationFunctionValues returns an array of possible values for the QueryAggregationFunction const type.
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return []QueryAggregationFunction{Avg, Max, Min, Sum}
}

// QueryExecutionType enumerates the values for query execution type.
type QueryExecutionType string

const (
	// Aborted ...
	Aborted QueryExecutionType = "aborted"
	// Any ...
	Any QueryExecutionType = "any"
	// Exception ...
	Exception QueryExecutionType = "exception"
	// Irregular ...
	Irregular QueryExecutionType = "irregular"
	// Regular ...
	Regular QueryExecutionType = "regular"
)

// PossibleQueryExecutionTypeValues returns an array of possible values for the QueryExecutionType const type.
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return []QueryExecutionType{Aborted, Any, Exception, Irregular, Regular}
}

// QueryMetricUnit enumerates the values for query metric unit.
type QueryMetricUnit string

const (
	// KB ...
	KB QueryMetricUnit = "KB"
	// Microseconds ...
	Microseconds QueryMetricUnit = "microseconds"
	// Percentage ...
	Percentage QueryMetricUnit = "percentage"
)

// PossibleQueryMetricUnitValues returns an array of possible values for the QueryMetricUnit const type.
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return []QueryMetricUnit{KB, Microseconds, Percentage}
}

// QueryObservedMetricType enumerates the values for query observed metric type.
type QueryObservedMetricType string

const (
	// CPU ...
	CPU QueryObservedMetricType = "cpu"
	// Duration ...
	Duration QueryObservedMetricType = "duration"
	// ExecutionCount ...
	ExecutionCount QueryObservedMetricType = "executionCount"
	// Io ...
	Io QueryObservedMetricType = "io"
	// Logio ...
	Logio QueryObservedMetricType = "logio"
)

// PossibleQueryObservedMetricTypeValues returns an array of possible values for the QueryObservedMetricType const type.
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return []QueryObservedMetricType{CPU, Duration, ExecutionCount, Io, Logio}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// Copy ...
	Copy ReplicationRole = "Copy"
	// NonReadableSecondary ...
	NonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// Primary ...
	Primary ReplicationRole = "Primary"
	// Secondary ...
	Secondary ReplicationRole = "Secondary"
	// Source ...
	Source ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{Copy, NonReadableSecondary, Primary, Secondary, Source}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// Environment ...
	Environment SsisObjectMetadataType = "Environment"
	// Folder ...
	Folder SsisObjectMetadataType = "Folder"
	// Package ...
	Package SsisObjectMetadataType = "Package"
	// Project ...
	Project SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{Environment, Folder, Package, Project}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusApproved ...
	StatusApproved Status = "Approved"
	// StatusDisconnected ...
	StatusDisconnected Status = "Disconnected"
	// StatusPending ...
	StatusPending Status = "Pending"
	// StatusRejected ...
	StatusRejected Status = "Rejected"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusApproved, StatusDisconnected, StatusPending, StatusRejected}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime Type = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged Type = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted Type = "SelfHosted"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeIntegrationRuntime, TypeManaged, TypeSelfHosted}
}

// TypeBasicCustomSetupBase enumerates the values for type basic custom setup base.
type TypeBasicCustomSetupBase string

const (
	// TypeCmdkeySetup ...
	TypeCmdkeySetup TypeBasicCustomSetupBase = "CmdkeySetup"
	// TypeComponentSetup ...
	TypeComponentSetup TypeBasicCustomSetupBase = "ComponentSetup"
	// TypeCustomSetupBase ...
	TypeCustomSetupBase TypeBasicCustomSetupBase = "CustomSetupBase"
	// TypeEnvironmentVariableSetup ...
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = "EnvironmentVariableSetup"
)

// PossibleTypeBasicCustomSetupBaseValues returns an array of possible values for the TypeBasicCustomSetupBase const type.
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return []TypeBasicCustomSetupBase{TypeCmdkeySetup, TypeComponentSetup, TypeCustomSetupBase, TypeEnvironmentVariableSetup}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicSecretBase enumerates the values for type basic secret base.
type TypeBasicSecretBase string

const (
	// TypeSecretBase ...
	TypeSecretBase TypeBasicSecretBase = "SecretBase"
	// TypeSecureString ...
	TypeSecureString TypeBasicSecretBase = "SecureString"
)

// PossibleTypeBasicSecretBaseValues returns an array of possible values for the TypeBasicSecretBase const type.
func PossibleTypeBasicSecretBaseValues() []TypeBasicSecretBase {
	return []TypeBasicSecretBase{TypeSecretBase, TypeSecureString}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeEnvironment ...
	TypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeFolder ...
	TypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypePackage ...
	TypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeProject ...
	TypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeSsisObjectMetadata ...
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeEnvironment, TypeFolder, TypePackage, TypeProject, TypeSsisObjectMetadata}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// Default ...
	Default VulnerabilityAssessmentPolicyBaselineName = "default"
	// Master ...
	Master VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{Default, Master}
}

// VulnerabilityAssessmentScanState enumerates the values for vulnerability assessment scan state.
type VulnerabilityAssessmentScanState string

const (
	// VulnerabilityAssessmentScanStateFailed ...
	VulnerabilityAssessmentScanStateFailed VulnerabilityAssessmentScanState = "Failed"
	// VulnerabilityAssessmentScanStateFailedToRun ...
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	// VulnerabilityAssessmentScanStateInProgress ...
	VulnerabilityAssessmentScanStateInProgress VulnerabilityAssessmentScanState = "InProgress"
	// VulnerabilityAssessmentScanStatePassed ...
	VulnerabilityAssessmentScanStatePassed VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns an array of possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{VulnerabilityAssessmentScanStateFailed, VulnerabilityAssessmentScanStateFailedToRun, VulnerabilityAssessmentScanStateInProgress, VulnerabilityAssessmentScanStatePassed}
}

// VulnerabilityAssessmentScanTriggerType enumerates the values for vulnerability assessment scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	// OnDemand ...
	OnDemand VulnerabilityAssessmentScanTriggerType = "OnDemand"
	// Recurring ...
	Recurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns an array of possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{OnDemand, Recurring}
}
