package sqlvirtualmachine

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// BackupScheduleType enumerates the values for backup schedule type.
type BackupScheduleType string

const (
	// Automated ...
	Automated BackupScheduleType = "Automated"
	// Manual ...
	Manual BackupScheduleType = "Manual"
)

// PossibleBackupScheduleTypeValues returns an array of possible values for the BackupScheduleType const type.
func PossibleBackupScheduleTypeValues() []BackupScheduleType {
	return []BackupScheduleType{Automated, Manual}
}

// ClusterConfiguration enumerates the values for cluster configuration.
type ClusterConfiguration string

const (
	// Domainful ...
	Domainful ClusterConfiguration = "Domainful"
)

// PossibleClusterConfigurationValues returns an array of possible values for the ClusterConfiguration const type.
func PossibleClusterConfigurationValues() []ClusterConfiguration {
	return []ClusterConfiguration{Domainful}
}

// ClusterManagerType enumerates the values for cluster manager type.
type ClusterManagerType string

const (
	// WSFC ...
	WSFC ClusterManagerType = "WSFC"
)

// PossibleClusterManagerTypeValues returns an array of possible values for the ClusterManagerType const type.
func PossibleClusterManagerTypeValues() []ClusterManagerType {
	return []ClusterManagerType{WSFC}
}

// ConnectivityType enumerates the values for connectivity type.
type ConnectivityType string

const (
	// LOCAL ...
	LOCAL ConnectivityType = "LOCAL"
	// PRIVATE ...
	PRIVATE ConnectivityType = "PRIVATE"
	// PUBLIC ...
	PUBLIC ConnectivityType = "PUBLIC"
)

// PossibleConnectivityTypeValues returns an array of possible values for the ConnectivityType const type.
func PossibleConnectivityTypeValues() []ConnectivityType {
	return []ConnectivityType{LOCAL, PRIVATE, PUBLIC}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DiskConfigurationType enumerates the values for disk configuration type.
type DiskConfigurationType string

const (
	// ADD ...
	ADD DiskConfigurationType = "ADD"
	// EXTEND ...
	EXTEND DiskConfigurationType = "EXTEND"
	// NEW ...
	NEW DiskConfigurationType = "NEW"
)

// PossibleDiskConfigurationTypeValues returns an array of possible values for the DiskConfigurationType const type.
func PossibleDiskConfigurationTypeValues() []DiskConfigurationType {
	return []DiskConfigurationType{ADD, EXTEND, NEW}
}

// FullBackupFrequencyType enumerates the values for full backup frequency type.
type FullBackupFrequencyType string

const (
	// Daily ...
	Daily FullBackupFrequencyType = "Daily"
	// Weekly ...
	Weekly FullBackupFrequencyType = "Weekly"
)

// PossibleFullBackupFrequencyTypeValues returns an array of possible values for the FullBackupFrequencyType const type.
func PossibleFullBackupFrequencyTypeValues() []FullBackupFrequencyType {
	return []FullBackupFrequencyType{Daily, Weekly}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// SystemAssigned ...
	SystemAssigned IdentityType = "SystemAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{SystemAssigned}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// System ...
	System OperationOrigin = "system"
	// User ...
	User OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{System, User}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// HA ...
	HA ScaleType = "HA"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{HA}
}

// SQLImageSku enumerates the values for sql image sku.
type SQLImageSku string

const (
	// Developer ...
	Developer SQLImageSku = "Developer"
	// Enterprise ...
	Enterprise SQLImageSku = "Enterprise"
	// Express ...
	Express SQLImageSku = "Express"
	// Standard ...
	Standard SQLImageSku = "Standard"
	// Web ...
	Web SQLImageSku = "Web"
)

// PossibleSQLImageSkuValues returns an array of possible values for the SQLImageSku const type.
func PossibleSQLImageSkuValues() []SQLImageSku {
	return []SQLImageSku{Developer, Enterprise, Express, Standard, Web}
}

// SQLManagementMode enumerates the values for sql management mode.
type SQLManagementMode string

const (
	// Full ...
	Full SQLManagementMode = "Full"
	// LightWeight ...
	LightWeight SQLManagementMode = "LightWeight"
	// NoAgent ...
	NoAgent SQLManagementMode = "NoAgent"
)

// PossibleSQLManagementModeValues returns an array of possible values for the SQLManagementMode const type.
func PossibleSQLManagementModeValues() []SQLManagementMode {
	return []SQLManagementMode{Full, LightWeight, NoAgent}
}

// SQLServerLicenseType enumerates the values for sql server license type.
type SQLServerLicenseType string

const (
	// AHUB ...
	AHUB SQLServerLicenseType = "AHUB"
	// DR ...
	DR SQLServerLicenseType = "DR"
	// PAYG ...
	PAYG SQLServerLicenseType = "PAYG"
)

// PossibleSQLServerLicenseTypeValues returns an array of possible values for the SQLServerLicenseType const type.
func PossibleSQLServerLicenseTypeValues() []SQLServerLicenseType {
	return []SQLServerLicenseType{AHUB, DR, PAYG}
}

// SQLVMGroupImageSku enumerates the values for sqlvm group image sku.
type SQLVMGroupImageSku string

const (
	// SQLVMGroupImageSkuDeveloper ...
	SQLVMGroupImageSkuDeveloper SQLVMGroupImageSku = "Developer"
	// SQLVMGroupImageSkuEnterprise ...
	SQLVMGroupImageSkuEnterprise SQLVMGroupImageSku = "Enterprise"
)

// PossibleSQLVMGroupImageSkuValues returns an array of possible values for the SQLVMGroupImageSku const type.
func PossibleSQLVMGroupImageSkuValues() []SQLVMGroupImageSku {
	return []SQLVMGroupImageSku{SQLVMGroupImageSkuDeveloper, SQLVMGroupImageSkuEnterprise}
}

// SQLWorkloadType enumerates the values for sql workload type.
type SQLWorkloadType string

const (
	// DW ...
	DW SQLWorkloadType = "DW"
	// GENERAL ...
	GENERAL SQLWorkloadType = "GENERAL"
	// OLTP ...
	OLTP SQLWorkloadType = "OLTP"
)

// PossibleSQLWorkloadTypeValues returns an array of possible values for the SQLWorkloadType const type.
func PossibleSQLWorkloadTypeValues() []SQLWorkloadType {
	return []SQLWorkloadType{DW, GENERAL, OLTP}
}

// StorageWorkloadType enumerates the values for storage workload type.
type StorageWorkloadType string

const (
	// StorageWorkloadTypeDW ...
	StorageWorkloadTypeDW StorageWorkloadType = "DW"
	// StorageWorkloadTypeGENERAL ...
	StorageWorkloadTypeGENERAL StorageWorkloadType = "GENERAL"
	// StorageWorkloadTypeOLTP ...
	StorageWorkloadTypeOLTP StorageWorkloadType = "OLTP"
)

// PossibleStorageWorkloadTypeValues returns an array of possible values for the StorageWorkloadType const type.
func PossibleStorageWorkloadTypeValues() []StorageWorkloadType {
	return []StorageWorkloadType{StorageWorkloadTypeDW, StorageWorkloadTypeGENERAL, StorageWorkloadTypeOLTP}
}
