package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/servicebus/mgmt/2018-01-01-preview/servicebus"

// Encryption properties to configure Encryption
type Encryption struct {
	// KeyVaultProperties - Properties of KeyVault
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// KeySource - Enumerates the possible value of keySource for Encryption. Possible values include: 'MicrosoftKeyVault'
	KeySource KeySource `json:"keySource,omitempty"`
}

// ErrorResponse error response indicates ServiceBus service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Identity properties to configure Identity for Bring your Own Keys
type Identity struct {
	// PrincipalID - ObjectId from the KeyVault
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - TenantId from the KeyVault
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Enumerates the possible value Identity type, which currently supports only 'SystemAssigned'. Possible values include: 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
}

// IPFilterRule single item in a List or Get IpFilterRules operation
type IPFilterRule struct {
	autorest.Response `json:"-"`
	// IPFilterRuleProperties - Properties supplied to create or update IpFilterRules
	*IPFilterRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IPFilterRule.
func (ifr IPFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifr.IPFilterRuleProperties != nil {
		objectMap["properties"] = ifr.IPFilterRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPFilterRule struct.
func (ifr *IPFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPFilterRuleProperties IPFilterRuleProperties
				err = json.Unmarshal(*v, &IPFilterRuleProperties)
				if err != nil {
					return err
				}
				ifr.IPFilterRuleProperties = &IPFilterRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifr.Type = &typeVar
			}
		}
	}

	return nil
}

// IPFilterRuleListResult the response from the List namespace operation.
type IPFilterRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List IpFilter Rules operation.
	Value *[]IPFilterRule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains an incomplete list of IpFilter Rules
	NextLink *string `json:"nextLink,omitempty"`
}

// IPFilterRuleListResultIterator provides access to a complete listing of IPFilterRule values.
type IPFilterRuleListResultIterator struct {
	i    int
	page IPFilterRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPFilterRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFilterRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IPFilterRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPFilterRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPFilterRuleListResultIterator) Response() IPFilterRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPFilterRuleListResultIterator) Value() IPFilterRule {
	if !iter.page.NotDone() {
		return IPFilterRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IPFilterRuleListResultIterator type.
func NewIPFilterRuleListResultIterator(page IPFilterRuleListResultPage) IPFilterRuleListResultIterator {
	return IPFilterRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifrlr IPFilterRuleListResult) IsEmpty() bool {
	return ifrlr.Value == nil || len(*ifrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifrlr IPFilterRuleListResult) hasNextLink() bool {
	return ifrlr.NextLink != nil && len(*ifrlr.NextLink) != 0
}

// iPFilterRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifrlr IPFilterRuleListResult) iPFilterRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ifrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifrlr.NextLink)))
}

// IPFilterRuleListResultPage contains a page of IPFilterRule values.
type IPFilterRuleListResultPage struct {
	fn    func(context.Context, IPFilterRuleListResult) (IPFilterRuleListResult, error)
	ifrlr IPFilterRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPFilterRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFilterRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifrlr)
		if err != nil {
			return err
		}
		page.ifrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IPFilterRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPFilterRuleListResultPage) NotDone() bool {
	return !page.ifrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPFilterRuleListResultPage) Response() IPFilterRuleListResult {
	return page.ifrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPFilterRuleListResultPage) Values() []IPFilterRule {
	if page.ifrlr.IsEmpty() {
		return nil
	}
	return *page.ifrlr.Value
}

// Creates a new instance of the IPFilterRuleListResultPage type.
func NewIPFilterRuleListResultPage(getNextPage func(context.Context, IPFilterRuleListResult) (IPFilterRuleListResult, error)) IPFilterRuleListResultPage {
	return IPFilterRuleListResultPage{fn: getNextPage}
}

// IPFilterRuleProperties properties supplied to create or update IpFilterRules
type IPFilterRuleProperties struct {
	// IPMask - IP Mask
	IPMask *string `json:"ipMask,omitempty"`
	// Action - The IP Filter Action. Possible values include: 'Accept', 'Reject'
	Action IPAction `json:"action,omitempty"`
	// FilterName - IP Filter name
	FilterName *string `json:"filterName,omitempty"`
}

// KeyVaultProperties properties to configure keyVault Properties
type KeyVaultProperties struct {
	// KeyName - Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`
	// KeyVaultURI - Uri of KeyVault
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesCreateOrUpdateFuture) Result(client NamespacesClient) (sn SBNamespace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sn.Response.Response, err = future.GetResult(sender); err == nil && sn.Response.Response.StatusCode != http.StatusNoContent {
		sn, err = client.CreateOrUpdateResponder(sn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", sn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NamespacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NetworkRuleSet description of topic resource.
type NetworkRuleSet struct {
	autorest.Response `json:"-"`
	// NetworkRuleSetProperties - NetworkRuleSet properties
	*NetworkRuleSetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkRuleSet.
func (nrs NetworkRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nrs.NetworkRuleSetProperties != nil {
		objectMap["properties"] = nrs.NetworkRuleSetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkRuleSet struct.
func (nrs *NetworkRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkRuleSetProperties NetworkRuleSetProperties
				err = json.Unmarshal(*v, &networkRuleSetProperties)
				if err != nil {
					return err
				}
				nrs.NetworkRuleSetProperties = &networkRuleSetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nrs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nrs.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkRuleSetProperties networkRuleSet properties
type NetworkRuleSetProperties struct {
	// DefaultAction - Default Action for Network Rule Set. Possible values include: 'Allow', 'Deny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
	// VirtualNetworkRules - List VirtualNetwork Rules
	VirtualNetworkRules *[]NWRuleSetVirtualNetworkRules `json:"virtualNetworkRules,omitempty"`
	// IPRules - List of IpRules
	IPRules *[]NWRuleSetIPRules `json:"ipRules,omitempty"`
}

// NWRuleSetIPRules the response from the List namespace operation.
type NWRuleSetIPRules struct {
	// IPMask - IP Mask
	IPMask *string `json:"ipMask,omitempty"`
	// Action - The IP Filter Action. Possible values include: 'NetworkRuleIPActionAllow'
	Action NetworkRuleIPAction `json:"action,omitempty"`
}

// NWRuleSetVirtualNetworkRules the response from the List namespace operation.
type NWRuleSetVirtualNetworkRules struct {
	// Subnet - Subnet properties
	Subnet *Subnet `json:"subnet,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Value that indicates whether to ignore missing Vnet Service Endpoint
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}

// Operation a ServiceBus REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.ServiceBus
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list ServiceBus operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ServiceBus operations supported by the Microsoft.ServiceBus resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// Resource the Resource definition for other than namespace.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// ResourceNamespacePatch the Resource definition.
type ResourceNamespacePatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNamespacePatch.
func (rnp ResourceNamespacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnp.Location != nil {
		objectMap["location"] = rnp.Location
	}
	if rnp.Tags != nil {
		objectMap["tags"] = rnp.Tags
	}
	return json.Marshal(objectMap)
}

// SBNamespace description of a namespace resource.
type SBNamespace struct {
	autorest.Response `json:"-"`
	// Sku - Properties of SKU
	Sku *SBSku `json:"sku,omitempty"`
	// SBNamespaceProperties - Properties of the namespace.
	*SBNamespaceProperties `json:"properties,omitempty"`
	// Location - The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBNamespace.
func (sn SBNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sn.Sku != nil {
		objectMap["sku"] = sn.Sku
	}
	if sn.SBNamespaceProperties != nil {
		objectMap["properties"] = sn.SBNamespaceProperties
	}
	if sn.Location != nil {
		objectMap["location"] = sn.Location
	}
	if sn.Tags != nil {
		objectMap["tags"] = sn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBNamespace struct.
func (sn *SBNamespace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku SBSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sn.Sku = &sku
			}
		case "properties":
			if v != nil {
				var sBNamespaceProperties SBNamespaceProperties
				err = json.Unmarshal(*v, &sBNamespaceProperties)
				if err != nil {
					return err
				}
				sn.SBNamespaceProperties = &sBNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sn.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sn.Type = &typeVar
			}
		}
	}

	return nil
}

// SBNamespaceListResult the response of the List Namespace operation.
type SBNamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]SBNamespace `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBNamespaceListResultIterator provides access to a complete listing of SBNamespace values.
type SBNamespaceListResultIterator struct {
	i    int
	page SBNamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBNamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBNamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBNamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBNamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBNamespaceListResultIterator) Response() SBNamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBNamespaceListResultIterator) Value() SBNamespace {
	if !iter.page.NotDone() {
		return SBNamespace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBNamespaceListResultIterator type.
func NewSBNamespaceListResultIterator(page SBNamespaceListResultPage) SBNamespaceListResultIterator {
	return SBNamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (snlr SBNamespaceListResult) IsEmpty() bool {
	return snlr.Value == nil || len(*snlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (snlr SBNamespaceListResult) hasNextLink() bool {
	return snlr.NextLink != nil && len(*snlr.NextLink) != 0
}

// sBNamespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (snlr SBNamespaceListResult) sBNamespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !snlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(snlr.NextLink)))
}

// SBNamespaceListResultPage contains a page of SBNamespace values.
type SBNamespaceListResultPage struct {
	fn   func(context.Context, SBNamespaceListResult) (SBNamespaceListResult, error)
	snlr SBNamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBNamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBNamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.snlr)
		if err != nil {
			return err
		}
		page.snlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBNamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBNamespaceListResultPage) NotDone() bool {
	return !page.snlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBNamespaceListResultPage) Response() SBNamespaceListResult {
	return page.snlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBNamespaceListResultPage) Values() []SBNamespace {
	if page.snlr.IsEmpty() {
		return nil
	}
	return *page.snlr.Value
}

// Creates a new instance of the SBNamespaceListResultPage type.
func NewSBNamespaceListResultPage(getNextPage func(context.Context, SBNamespaceListResult) (SBNamespaceListResult, error)) SBNamespaceListResultPage {
	return SBNamespaceListResultPage{fn: getNextPage}
}

// SBNamespaceProperties properties of the namespace.
type SBNamespaceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CreatedAt - READ-ONLY; The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// MetricID - READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty"`
	// ZoneRedundant - Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Identity - Properties of BYOK Identity description
	Identity *Identity `json:"identity,omitempty"`
	// Encryption - Properties of BYOK Encryption description
	Encryption *Encryption `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for SBNamespaceProperties.
func (snp SBNamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if snp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = snp.ZoneRedundant
	}
	if snp.Identity != nil {
		objectMap["identity"] = snp.Identity
	}
	if snp.Encryption != nil {
		objectMap["encryption"] = snp.Encryption
	}
	return json.Marshal(objectMap)
}

// SBNamespaceUpdateParameters description of a namespace resource.
type SBNamespaceUpdateParameters struct {
	// Sku - Properties of SKU
	Sku *SBSku `json:"sku,omitempty"`
	// SBNamespaceProperties - Properties of the namespace.
	*SBNamespaceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBNamespaceUpdateParameters.
func (snup SBNamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if snup.Sku != nil {
		objectMap["sku"] = snup.Sku
	}
	if snup.SBNamespaceProperties != nil {
		objectMap["properties"] = snup.SBNamespaceProperties
	}
	if snup.Location != nil {
		objectMap["location"] = snup.Location
	}
	if snup.Tags != nil {
		objectMap["tags"] = snup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBNamespaceUpdateParameters struct.
func (snup *SBNamespaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku SBSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				snup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var sBNamespaceProperties SBNamespaceProperties
				err = json.Unmarshal(*v, &sBNamespaceProperties)
				if err != nil {
					return err
				}
				snup.SBNamespaceProperties = &sBNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				snup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				snup.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				snup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				snup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				snup.Type = &typeVar
			}
		}
	}

	return nil
}

// SBSku SKU of the namespace.
type SBSku struct {
	// Name - Name of this SKU. Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - The billing tier of this particular SKU. Possible values include: 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
	Capacity *int32 `json:"capacity,omitempty"`
}

// Subnet properties supplied for Subnet
type Subnet struct {
	// ID - Resource ID of Virtual Network Subnet
	ID *string `json:"id,omitempty"`
}

// TrackedResource the Resource definition.
type TrackedResource struct {
	// Location - The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkRule single item in a List or Get VirtualNetworkRules operation
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - Properties supplied to create or update VirtualNetworkRules
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnr.VirtualNetworkRuleProperties != nil {
		objectMap["properties"] = vnr.VirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult the response from the List namespace operation.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List VirtualNetwork Rules operation.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains an incomplete list of VirtualNetwork Rules
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnrlr VirtualNetworkRuleListResult) hasNextLink() bool {
	return vnrlr.NextLink != nil && len(*vnrlr.NextLink) != 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnrlr)
		if err != nil {
			return err
		}
		page.vnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{fn: getNextPage}
}

// VirtualNetworkRuleProperties properties supplied to create or update VirtualNetworkRules
type VirtualNetworkRuleProperties struct {
	// VirtualNetworkSubnetID - Resource ID of Virtual Network Subnet
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`
}
