package managementgroups

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// Delete ...
	Delete Permissions = "delete"
	// Edit ...
	Edit Permissions = "edit"
	// Noaccess ...
	Noaccess Permissions = "noaccess"
	// View ...
	View Permissions = "view"
)

// PossiblePermissionsValues returns an array of possible values for the Permissions const type.
func PossiblePermissionsValues() []Permissions {
	return []Permissions{Delete, Edit, Noaccess, View}
}

// Permissions1 enumerates the values for permissions 1.
type Permissions1 string

const (
	// Permissions1Delete ...
	Permissions1Delete Permissions1 = "delete"
	// Permissions1Edit ...
	Permissions1Edit Permissions1 = "edit"
	// Permissions1Noaccess ...
	Permissions1Noaccess Permissions1 = "noaccess"
	// Permissions1View ...
	Permissions1View Permissions1 = "view"
)

// PossiblePermissions1Values returns an array of possible values for the Permissions1 const type.
func PossiblePermissions1Values() []Permissions1 {
	return []Permissions1{Permissions1Delete, Permissions1Edit, Permissions1Noaccess, Permissions1View}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Updating}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
	// Invalid ...
	Invalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AlreadyExists, Invalid}
}

// Type enumerates the values for type.
type Type string

const (
	// ProvidersMicrosoftManagementmanagementGroups ...
	ProvidersMicrosoftManagementmanagementGroups Type = "/providers/Microsoft.Management/managementGroups"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{ProvidersMicrosoftManagementmanagementGroups}
}

// Type1 enumerates the values for type 1.
type Type1 string

const (
	// Type1ProvidersMicrosoftManagementmanagementGroups ...
	Type1ProvidersMicrosoftManagementmanagementGroups Type1 = "/providers/Microsoft.Management/managementGroups"
	// Type1Subscriptions ...
	Type1Subscriptions Type1 = "/subscriptions"
)

// PossibleType1Values returns an array of possible values for the Type1 const type.
func PossibleType1Values() []Type1 {
	return []Type1{Type1ProvidersMicrosoftManagementmanagementGroups, Type1Subscriptions}
}

// Type2 enumerates the values for type 2.
type Type2 string

const (
	// Type2ProvidersMicrosoftManagementmanagementGroups ...
	Type2ProvidersMicrosoftManagementmanagementGroups Type2 = "/providers/Microsoft.Management/managementGroups"
	// Type2Subscriptions ...
	Type2Subscriptions Type2 = "/subscriptions"
)

// PossibleType2Values returns an array of possible values for the Type2 const type.
func PossibleType2Values() []Type2 {
	return []Type2{Type2ProvidersMicrosoftManagementmanagementGroups, Type2Subscriptions}
}
