package hybridnetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VirtualNetworkFunctionVendorsClient is the client for the VirtualNetworkFunctionVendors methods of the Hybridnetwork
// service.
type VirtualNetworkFunctionVendorsClient struct {
	BaseClient
}

// NewVirtualNetworkFunctionVendorsClient creates an instance of the VirtualNetworkFunctionVendorsClient client.
func NewVirtualNetworkFunctionVendorsClient(subscriptionID string) VirtualNetworkFunctionVendorsClient {
	return NewVirtualNetworkFunctionVendorsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVirtualNetworkFunctionVendorsClientWithBaseURI creates an instance of the VirtualNetworkFunctionVendorsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewVirtualNetworkFunctionVendorsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkFunctionVendorsClient {
	return VirtualNetworkFunctionVendorsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List list all the available vendor and sku information in hybrid network.
func (client VirtualNetworkFunctionVendorsClient) List(ctx context.Context) (result VirtualNetworkFunctionVendorListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorsClient.List")
		defer func() {
			sc := -1
			if result.vnfvlr.Response.Response != nil {
				sc = result.vnfvlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vnfvlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "List", resp, "Failure sending request")
		return
	}

	result.vnfvlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "List", resp, "Failure responding to request")
	}
	if result.vnfvlr.hasNextLink() && result.vnfvlr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client VirtualNetworkFunctionVendorsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/virtualNetworkFunctionVendors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualNetworkFunctionVendorsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VirtualNetworkFunctionVendorsClient) ListResponder(resp *http.Response) (result VirtualNetworkFunctionVendorListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VirtualNetworkFunctionVendorsClient) listNextResults(ctx context.Context, lastResults VirtualNetworkFunctionVendorListResult) (result VirtualNetworkFunctionVendorListResult, err error) {
	req, err := lastResults.virtualNetworkFunctionVendorListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualNetworkFunctionVendorsClient) ListComplete(ctx context.Context) (result VirtualNetworkFunctionVendorListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}
