package customimagesearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// PossibleFreshnessValues returns an array of possible values for the Freshness const type.
func PossibleFreshnessValues() []Freshness {
	return []Freshness{Day, Month, Week}
}

// ImageAspect enumerates the values for image aspect.
type ImageAspect string

const (
	// All ...
	All ImageAspect = "All"
	// Square ...
	Square ImageAspect = "Square"
	// Tall ...
	Tall ImageAspect = "Tall"
	// Wide ...
	Wide ImageAspect = "Wide"
)

// PossibleImageAspectValues returns an array of possible values for the ImageAspect const type.
func PossibleImageAspectValues() []ImageAspect {
	return []ImageAspect{All, Square, Tall, Wide}
}

// ImageColor enumerates the values for image color.
type ImageColor string

const (
	// Black ...
	Black ImageColor = "Black"
	// Blue ...
	Blue ImageColor = "Blue"
	// Brown ...
	Brown ImageColor = "Brown"
	// ColorOnly ...
	ColorOnly ImageColor = "ColorOnly"
	// Gray ...
	Gray ImageColor = "Gray"
	// Green ...
	Green ImageColor = "Green"
	// Monochrome ...
	Monochrome ImageColor = "Monochrome"
	// Orange ...
	Orange ImageColor = "Orange"
	// Pink ...
	Pink ImageColor = "Pink"
	// Purple ...
	Purple ImageColor = "Purple"
	// Red ...
	Red ImageColor = "Red"
	// Teal ...
	Teal ImageColor = "Teal"
	// White ...
	White ImageColor = "White"
	// Yellow ...
	Yellow ImageColor = "Yellow"
)

// PossibleImageColorValues returns an array of possible values for the ImageColor const type.
func PossibleImageColorValues() []ImageColor {
	return []ImageColor{Black, Blue, Brown, ColorOnly, Gray, Green, Monochrome, Orange, Pink, Purple, Red, Teal, White, Yellow}
}

// ImageContent enumerates the values for image content.
type ImageContent string

const (
	// Face ...
	Face ImageContent = "Face"
	// Portrait ...
	Portrait ImageContent = "Portrait"
)

// PossibleImageContentValues returns an array of possible values for the ImageContent const type.
func PossibleImageContentValues() []ImageContent {
	return []ImageContent{Face, Portrait}
}

// ImageLicense enumerates the values for image license.
type ImageLicense string

const (
	// ImageLicenseAll ...
	ImageLicenseAll ImageLicense = "All"
	// ImageLicenseAny ...
	ImageLicenseAny ImageLicense = "Any"
	// ImageLicenseModify ...
	ImageLicenseModify ImageLicense = "Modify"
	// ImageLicenseModifyCommercially ...
	ImageLicenseModifyCommercially ImageLicense = "ModifyCommercially"
	// ImageLicensePublic ...
	ImageLicensePublic ImageLicense = "Public"
	// ImageLicenseShare ...
	ImageLicenseShare ImageLicense = "Share"
	// ImageLicenseShareCommercially ...
	ImageLicenseShareCommercially ImageLicense = "ShareCommercially"
)

// PossibleImageLicenseValues returns an array of possible values for the ImageLicense const type.
func PossibleImageLicenseValues() []ImageLicense {
	return []ImageLicense{ImageLicenseAll, ImageLicenseAny, ImageLicenseModify, ImageLicenseModifyCommercially, ImageLicensePublic, ImageLicenseShare, ImageLicenseShareCommercially}
}

// ImageSize enumerates the values for image size.
type ImageSize string

const (
	// ImageSizeAll ...
	ImageSizeAll ImageSize = "All"
	// ImageSizeLarge ...
	ImageSizeLarge ImageSize = "Large"
	// ImageSizeMedium ...
	ImageSizeMedium ImageSize = "Medium"
	// ImageSizeSmall ...
	ImageSizeSmall ImageSize = "Small"
	// ImageSizeWallpaper ...
	ImageSizeWallpaper ImageSize = "Wallpaper"
)

// PossibleImageSizeValues returns an array of possible values for the ImageSize const type.
func PossibleImageSizeValues() []ImageSize {
	return []ImageSize{ImageSizeAll, ImageSizeLarge, ImageSizeMedium, ImageSizeSmall, ImageSizeWallpaper}
}

// ImageType enumerates the values for image type.
type ImageType string

const (
	// AnimatedGif ...
	AnimatedGif ImageType = "AnimatedGif"
	// Clipart ...
	Clipart ImageType = "Clipart"
	// Line ...
	Line ImageType = "Line"
	// Photo ...
	Photo ImageType = "Photo"
	// Shopping ...
	Shopping ImageType = "Shopping"
	// Transparent ...
	Transparent ImageType = "Transparent"
)

// PossibleImageTypeValues returns an array of possible values for the ImageType const type.
func PossibleImageTypeValues() []ImageType {
	return []ImageType{AnimatedGif, Clipart, Line, Photo, Shopping, Transparent}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAnswer ...
	TypeAnswer Type = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeImageObject ...
	TypeImageObject Type = "ImageObject"
	// TypeImages ...
	TypeImages Type = "Images"
	// TypeMediaObject ...
	TypeMediaObject Type = "MediaObject"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer Type = "SearchResultsAnswer"
	// TypeThing ...
	TypeThing Type = "Thing"
	// TypeWebPage ...
	TypeWebPage Type = "WebPage"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAnswer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeImageObject, TypeImages, TypeMediaObject, TypeResponse, TypeResponseBase, TypeSearchResultsAnswer, TypeThing, TypeWebPage}
}
