/*
**  ClanLib SDK
**  Copyright (c) 1997-2020 The ClanLib Team
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
**  Note: Some of the libraries ClanLib may link to may have additional
**  requirements or restrictions.
**
**  File Author(s):
**
**    Mark Page
*/

#pragma once

#include "API/Display/Render/graphic_context.h"

namespace clan
{
	class PBuffer_GL1_Impl;
	class OpenGLWindowProvider;
	class GL1GraphicContextProvider;

	class PBuffer_GL1
	{
	public:
		PBuffer_GL1();
		PBuffer_GL1(GL1GraphicContextProvider *gc_provider);
		~PBuffer_GL1();

		/// \brief Returns true if this object is invalid.
		bool is_null() const { return !impl; }

		/// \brief Throw an exception if this object is invalid.
		void throw_if_null() const;

		void create(OpenGLWindowProvider &window_provider, Size &size);
		void set_active();

	private:
		std::shared_ptr<PBuffer_GL1_Impl> impl;
	};
}
