/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedAbilitySelectionChooseInformation;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.choiceset.CollectionToAbilitySelection;
import pcgen.cdom.content.AbilitySelection;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AbilitySelectionToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
Chooser<AbilitySelection> {
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "CHOOSE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, ReferenceManufacturer<Ability> rm, CDOMSingleRef<AbilityCategory> acRef, CDOMObject obj, String value) {
        String title;
        String activeValue;
        int pipeLoc = value.lastIndexOf(124);
        if (pipeLoc == -1) {
            activeValue = value;
            title = this.getDefaultTitle();
        } else {
            String titleString = value.substring(pipeLoc + 1);
            if (titleString.startsWith("TITLE=")) {
                title = titleString.substring(6);
                if (title.startsWith("\"")) {
                    title = title.substring(1, title.length() - 1);
                }
                if (title == null || title.length() == 0) {
                    return new ParseResult.Fail(this.getParentToken() + ":" + this.getTokenName() + " had TITLE= but no title: " + value, context);
                }
                activeValue = value.substring(0, pipeLoc);
            } else {
                activeValue = value;
                title = this.getDefaultTitle();
            }
        }
        PrimitiveCollection prim = context.getChoiceSet(rm, activeValue);
        if (prim == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        if (!prim.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        CollectionToAbilitySelection pcs = new CollectionToAbilitySelection(acRef, prim);
        CategorizedAbilitySelectionChooseInformation tc = new CategorizedAbilitySelectionChooseInformation(this.getTokenName(), pcs);
        tc.setTitle(title);
        tc.setChoiceActor((Chooser)this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, (Object)tc);
        return ParseResult.SUCCESS;
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation tc = (ChooseInformation)context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (tc == null) {
            return null;
        }
        if (!tc.getName().equals(this.getTokenName())) {
            return null;
        }
        if (!tc.getGroupingState().isValid()) {
            context.addWriteMessage("Invalid combination of objects was used in: " + this.getParentToken() + ":" + this.getTokenName());
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (tc instanceof CategorizedAbilitySelectionChooseInformation) {
            sb.append(((CategorizedAbilitySelectionChooseInformation)tc).getCategory().getLSTformat(false));
        } else {
            sb.append("FEAT");
        }
        sb.append('|');
        sb.append(tc.getLSTformat());
        String title = tc.getTitle();
        if (!title.equals(this.getDefaultTitle())) {
            sb.append("|TITLE=");
            sb.append(title);
        }
        return new String[]{sb.toString()};
    }

    public void applyChoice(ChooseDriver owner, AbilitySelection st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, st);
    }

    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, AbilitySelection choice) {
        pc.removeAssoc((Object)owner, this.getListKey(), (Object)choice);
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                ca.removeChoice(owner, (Object)choice, pc);
            }
        }
    }

    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, AbilitySelection choice) {
        pc.addAssoc((Object)owner, this.getListKey(), (Object)choice);
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                ca.applyChoice(owner, (Object)choice, pc);
            }
        }
    }

    public List<AbilitySelection> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList((Object)owner, this.getListKey());
    }

    public boolean allow(AbilitySelection choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    public String getTokenName() {
        return "ABILITYSELECTION";
    }

    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        int barLoc = value.indexOf(124);
        if (barLoc == -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " requires a CATEGORY and arguments : " + value, context);
        }
        String cat = value.substring(0, barLoc);
        CDOMSingleRef acRef = context.getReferenceContext().getCDOMReference(ABILITY_CATEGORY_CLASS, cat);
        String abilities = value.substring(barLoc + 1);
        ReferenceManufacturer rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, ABILITY_CATEGORY_CLASS, cat);
        if (rm == null) {
            return new ParseResult.Fail("Could not get Reference Manufacturer for Category: " + cat, context);
        }
        return this.parseTokenWithSeparator(context, (ReferenceManufacturer<Ability>)rm, (CDOMSingleRef<AbilityCategory>)acRef, obj, abilities);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected String getDefaultTitle() {
        return "Ability choice";
    }

    protected AssociationListKey<AbilitySelection> getListKey() {
        return AssociationListKey.getKeyFor(AbilitySelection.class, (String)"CHOOSE*ABILITYSELECTION");
    }

    public AbilitySelection decodeChoice(LoadContext context, String s) {
        return AbilitySelection.getAbilitySelectionFromPersistentFormat((LoadContext)context, (String)s);
    }

    public String encodeChoice(AbilitySelection choice) {
        return choice.getPersistentFormat();
    }
}

