/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.util.LogReceiver;
import gmgen.util.LogUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import pcgen.core.SettingsHandler;
import plugin.network.NetworkClient;
import plugin.network.NetworkCombatant;
import plugin.network.NetworkServer;
import plugin.network.gui.NetworkView;

public class NetworkModel {
    private NetworkView view = new NetworkView();
    static List<Color> colorList = new ArrayList<Color>();
    private NetworkServer server;
    private NetworkClient client;
    private InitHolderList combat;
    private HashMap<String, Combatant> sentCombatants = new HashMap();
    private HashMap<String, NetworkCombatant> recievedCombatants = new HashMap();

    public NetworkModel() {
        this.applyPrefs();
        this.initLogging();
        this.initView();
        this.addListeners();
    }

    public NetworkView getView() {
        return this.view;
    }

    public void closeWindow() {
    }

    public void applyPrefs() {
    }

    public void handleServerPcgMessage(String uid, String messagetext, Socket sock) {
        if (this.sentCombatants.containsKey(uid)) {
            Combatant cbt = this.sentCombatants.get(uid);
            NetworkCombatant.recieveServerMessage(messagetext, cbt);
        }
    }

    public void handlePcgMessage(String uid, String messagetext, Socket sock) {
        if (this.recievedCombatants.containsKey(uid)) {
            NetworkCombatant cbt = this.recievedCombatants.get(uid);
            cbt.recieveNetMessage(messagetext);
        } else {
            NetworkCombatant cbt = new NetworkCombatant(uid, sock);
            cbt.recieveNetMessage(messagetext);
            this.recievedCombatants.put(uid, cbt);
            this.combat.add((InitHolder)cbt);
        }
    }

    public void sendCombatant(Combatant cbt) {
        String user = SettingsHandler.getGMGenOption((String)"Network.username", (String)"Player");
        if (this.client != null) {
            this.sentCombatants.put(NetworkCombatant.getCombatantUid(cbt, user), cbt);
            NetworkCombatant.sendCombatant(cbt, this.client);
        }
    }

    public void combatantUpdated(Combatant cbt) {
        if (this.combat != null) {
            for (InitHolder iH : this.combat) {
                if (iH != cbt) continue;
                this.sendCombatant(cbt);
            }
        }
    }

    private void initView() {
        this.view.getClientRadioButton().setSelected(true);
        this.view.getServerAddressTextField().setText(SettingsHandler.getGMGenOption((String)"Network.ipAddress", (String)"0.0.0.0"));
        this.initList();
    }

    private void initList() {
        this.view.getUserList().setModel(new DefaultListModel());
        this.addUser("Broadcast");
    }

    private void addListeners() {
        this.view.getServerRadioButton().addActionListener(new RadioActionListener());
        this.view.getClientRadioButton().addActionListener(new RadioActionListener());
        this.view.getConnectButton().addActionListener(new ConnectionButtonActionListener());
        this.view.getLogPane().addFocusListener(new TabFocusListener());
        this.view.getMessageButton().addActionListener(new MessageButtonActionListener());
    }

    private void displayClientToolbar() {
        this.view.showClientPanel();
        this.view.showConnectionPanel();
    }

    private void displayServerToolbar() {
        this.view.hideClientPanel();
    }

    private void startServer() {
        this.server = new NetworkServer(this);
        this.server.start();
    }

    private void stopServer() {
        if (this.server != null) {
            NetworkServer serverThread = null;
            ThreadGroup tg = this.server.getThreadGroup();
            if (tg != null) {
                Thread[] tl = new Thread[tg.activeCount()];
                tg.enumerate(tl);
                for (Thread t : tl) {
                    if (t instanceof NetworkServer) {
                        serverThread = (NetworkServer)t;
                        continue;
                    }
                    if (!(t instanceof NetworkServer.Handler)) continue;
                    ((NetworkServer.Handler)t).setRun(false);
                }
                if (serverThread != null) {
                    serverThread.setRun(false);
                }
            }
        }
        this.server = null;
        this.log("Local", "Local", "Server Shut Down");
        this.initList();
    }

    private void startClient() {
        this.view.getConnectButton().setText("Disconnect");
        this.client = new NetworkClient(this);
        this.client.startClient();
    }

    private void stopClient() {
        if (this.client != null) {
            this.client.sendExitMessage();
        }
    }

    public void resetClient() {
        this.client = null;
        this.view.getConnectButton().setText("Connect");
        this.getView().setConnectionText("Client Status", "Disconnected from Server");
        this.initList();
    }

    private void initLogging() {
        LogUtilities.inst().addReceiver((LogReceiver)new NetworkLogReciever());
        JTabbedPane logPane = this.view.getLogPane();
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        ExtendedHTMLEditorKit htmlKit = new ExtendedHTMLEditorKit();
        pane.setEditorKit((EditorKit)htmlKit);
        ExtendedHTMLDocument extDoc = (ExtendedHTMLDocument)htmlKit.createDefaultDocument();
        extDoc.putProperty((Object)"number", (Object)0);
        logPane.add("Logs", new JScrollPane(pane));
        JTextPane pane2 = new JTextPane();
        EditorKit kit = pane2.getEditorKit();
        Document doc = kit.createDefaultDocument();
        doc.putProperty("number", 1);
    }

    public void log(String title, String message) {
        JTextPane logsPane = this.getLogPane("Logs");
        SimpleDateFormat dateFmt = new SimpleDateFormat("hh.mm.ss a z");
        ExtendedHTMLDocument logsDoc = (ExtendedHTMLDocument)logsPane.getDocument();
        int i = this.getUserNumber(title);
        Color c = this.getLineColor(i);
        try {
            logsDoc.insertAfterEnd(logsDoc.getCharacterElement(logsDoc.getLength()), "<br>\n<b>" + dateFmt.format(Calendar.getInstance().getTime()) + " <font color='#" + Integer.toHexString(c.getRGB()) + "'>" + title + "</b></font>: " + message);
            this.setPaneIcon();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void log(String title, String owner, String message) {
        JTextPane logsPane = this.getLogPane("Logs");
        SimpleDateFormat dateFmt = new SimpleDateFormat("hh.mm.ss a z");
        ExtendedHTMLDocument logsDoc = (ExtendedHTMLDocument)logsPane.getDocument();
        int i = this.getUserNumber(title);
        Color c = this.getLineColor(i);
        try {
            logsDoc.insertAfterEnd(logsDoc.getCharacterElement(logsDoc.getLength()), "<br>\n<b>" + dateFmt.format(Calendar.getInstance().getTime()) + " <font color='#" + Integer.toHexString(c.getRGB()) + "'>" + title + "</b></font> " + owner + ": " + message);
            this.setPaneIcon();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getUserNumber(String user) {
        JList list = this.view.getUserList();
        DefaultListModel model = (DefaultListModel)list.getModel();
        if (model.contains(user)) {
            return model.indexOf(user);
        }
        return 0;
    }

    public void addUser(String user) {
        JList list = this.view.getUserList();
        DefaultListModel model = (DefaultListModel)list.getModel();
        if (!model.contains(user)) {
            model.addElement(user);
        }
    }

    public void removeUser(String user) {
        JList list = this.view.getUserList();
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.removeElement(user);
    }

    public String getSelectedUser() {
        JList list = this.view.getUserList();
        return list.getSelectedValue().toString();
    }

    private Color getLineColor(int num) {
        return colorList.get(num >= colorList.size() ? num % colorList.size() : num);
    }

    private JTextPane getLogPane(String title) {
        JTabbedPane logPane = this.view.getLogPane();
        for (int i = 0; i < logPane.getTabCount(); ++i) {
            if (!logPane.getTitleAt(i).equals(title)) continue;
            return (JTextPane)((JScrollPane)logPane.getComponent(i)).getViewport().getView();
        }
        JTextPane pane = new JTextPane();
        EditorKit kit = pane.getEditorKit();
        kit.createDefaultDocument();
        logPane.add(title, new JScrollPane(pane));
        return pane;
    }

    public void setPaneIcon() {
        JTabbedPane logPane = this.view.getLogPane();
        JTabbedPane gmgenPane = GMGenSystemView.getTabPane();
        if (gmgenPane.getSelectedComponent() instanceof NetworkView && GMGenSystem.inst.isFocused()) {
            return;
        }
        logPane.setIconAt(logPane.indexOfTab("Logs"), new ImageIcon(this.getClass().getResource("/pcgen/resource/images/NewEnvelope.gif")));
        if (!(gmgenPane.getSelectedComponent() instanceof NetworkView)) {
            int index = gmgenPane.indexOfComponent(this.view);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/pcgen/resource/images/NewEnvelope.gif"));
            gmgenPane.setIconAt(index, icon);
        }
    }

    public void clearIcon() {
        JTabbedPane logPane = this.view.getLogPane();
        logPane.setIconAt(logPane.getSelectedIndex(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() {
        try {
            if (this.server != null) {
                this.server.sendIM("GM", this.getSelectedUser(), this.view.getMessageTextField().getText());
            } else if (this.client != null) {
                if (this.getSelectedUser().equals("Broadcast")) {
                    this.client.sendBroadcast(this.view.getMessageTextField().getText());
                } else {
                    this.client.sendIM(this.getSelectedUser(), this.view.getMessageTextField().getText());
                }
            }
        }
        finally {
            this.view.getMessageTextField().setText("");
        }
    }

    public void setCombat(InitHolderList combat) {
        this.combat = combat;
    }

    public InitHolderList getCombat() {
        return this.combat;
    }

    public void refresh() {
        if (this.combat != null) {
            for (InitHolder iH : this.combat) {
                if (!(iH instanceof Combatant)) continue;
                this.sendCombatant((Combatant)iH);
            }
        }
    }

    static {
        colorList.add(Color.BLACK);
        colorList.add(Color.BLUE);
        colorList.add(Color.RED);
        colorList.add(Color.GREEN);
        colorList.add(Color.DARK_GRAY);
        colorList.add(Color.ORANGE);
        colorList.add(Color.CYAN);
        colorList.add(Color.MAGENTA);
        colorList.add(Color.LIGHT_GRAY);
        colorList.add(Color.YELLOW);
        colorList.add(Color.GRAY);
        colorList.add(Color.PINK);
    }

    private class MessageButtonActionListener
    implements ActionListener {
        private MessageButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NetworkModel.this.sendMessage();
        }
    }

    private class TabFocusListener
    implements FocusListener {
        private TabFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            NetworkModel.this.clearIcon();
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }
    }

    private class ConnectionButtonActionListener
    implements ActionListener {
        private ConnectionButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (NetworkModel.this.client == null) {
                NetworkModel.this.startClient();
            } else {
                NetworkModel.this.stopClient();
            }
        }
    }

    private class RadioActionListener
    implements ActionListener {
        private RadioActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (NetworkModel.this.view.getServerRadioButton().isSelected()) {
                NetworkModel.this.displayServerToolbar();
                NetworkModel.this.startServer();
            } else {
                try {
                    NetworkModel.this.stopServer();
                }
                catch (Exception e) {
                    NetworkModel.this.log("Local", "Local", "Failed to Shutdown Server.");
                }
                try {
                    NetworkModel.this.displayClientToolbar();
                }
                catch (Exception e) {
                    NetworkModel.this.log("Local", "Local", "Failed to Display the client tool bar.");
                }
            }
        }
    }

    private class NetworkLogReciever
    implements LogReceiver {
        public void logMessage(String owner, String message) {
            NetworkModel.this.log("Local", owner, message);
            if (NetworkModel.this.client != null) {
                NetworkModel.this.client.sendLogMessage(owner, message);
            }
        }

        public void logMessage(String message) {
            this.logMessage("Misc", message);
        }
    }
}

