/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import pcgen.system.LanguageBundle;

public class PreferencesExperiencePanel
extends PreferencesPanel {
    public static final int EXPERIENCE_3 = 1;
    public static final int EXPERIENCE_35 = 2;
    private static final String OPTION_NAME_EXP_TYPE = "Experience_Adjuster.ExperienceType";
    private JPanel mainPanel;
    private JPanel expPanel;
    private ButtonGroup experienceGroup;
    private JRadioButton experienceRB1;
    private JRadioButton experienceRB2;

    public PreferencesExperiencePanel() {
        this.initComponents();
        this.initPreferences();
    }

    public void setExperience(int exp) {
        if (exp == 1) {
            this.experienceRB1.setSelected(true);
        } else if (exp == 2) {
            this.experienceRB2.setSelected(true);
        }
    }

    public int getExperience() {
        int returnVal = 0;
        if (this.experienceRB1.isSelected()) {
            returnVal = 1;
        } else if (this.experienceRB2.isSelected()) {
            returnVal = 2;
        }
        return returnVal;
    }

    @Override
    public void applyPreferences() {
        SettingsHandler.setGMGenOption(OPTION_NAME_EXP_TYPE, this.getExperience());
    }

    @Override
    public void initPreferences() {
        this.setExperience(SettingsHandler.getGMGenOption(OPTION_NAME_EXP_TYPE, 2));
    }

    @Override
    public String toString() {
        return LanguageBundle.getString("in_plugin_xp");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.expPanel = new JPanel();
        this.experienceGroup = new ButtonGroup();
        this.experienceRB1 = new JRadioButton();
        this.experienceRB2 = new JRadioButton();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.expPanel.setLayout(new BoxLayout(this.expPanel, 1));
        this.expPanel.setBorder(new TitledBorder(null, LanguageBundle.getString("in_plugin_xp_calc"), 0, 0));
        this.experienceRB1.setSelected(true);
        this.experienceRB1.setText(LanguageBundle.getString("in_plugin_xp_byParty"));
        this.experienceGroup.add(this.experienceRB1);
        this.expPanel.add(this.experienceRB1);
        this.experienceRB2.setText(LanguageBundle.getString("in_plugin_xp_byPC"));
        this.experienceGroup.add(this.experienceRB2);
        this.expPanel.add(this.experienceRB2);
        this.mainPanel.add(this.expPanel);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(this.mainPanel);
        this.add((Component)jScrollPane1, "Center");
    }
}

