/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.EquipSet;

public class EquipSetLoopDirective
implements TemplateDirectiveModel {
    private PlayerCharacter pc;

    public EquipSetLoopDirective(PlayerCharacter pc) {
        this.pc = pc;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (body == null) {
            throw new TemplateModelException("This directive must have content.");
        }
        ArrayList<EquipSet> eqSetList = new ArrayList<EquipSet>();
        EquipSet currSet = null;
        String currIdPath = this.pc.getCalcEquipSetId();
        for (EquipSet es : this.pc.getDisplay().getEquipSet()) {
            if (!es.getParentIdPath().equals("0")) continue;
            eqSetList.add(es);
            if (!es.getIdPath().equals(currIdPath)) continue;
            currSet = es;
        }
        for (EquipSet equipSet : eqSetList) {
            this.pc.setCalcEquipSetId(equipSet.getIdPath());
            body.render(env.getOut());
        }
        if (currSet != null) {
            this.pc.setCalcEquipSetId(currSet.getIdPath());
        }
    }
}

