/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.lang.ArrayUtils;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

final class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class<?> mrjFileUtilsClass;
    private static Class<?> mrjOSTypeClass;
    private static Class<?> aeDescClass;
    private static Constructor<?> aeTargetConstructor;
    private static Constructor<?> appleEventConstructor;
    private static Constructor<?> aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static final String BROWSER_PROPERTY = "BROWSER";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    public static void openURL(URL url) throws IOException {
        BrowserLauncher.openURL(url.toString());
    }

    public static void openURL(String url) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException(LanguageBundle.getFormattedString("in_BLEr3", errorMessage));
        }
        if (BrowserLauncher.isBrowserPathNull(PCGenSettings.OPTIONS_CONTEXT.getProperty("browserPath"))) {
            Object aBrowser = BrowserLauncher.locateBrowser();
            if (BrowserLauncher.isBrowserPathNull(aBrowser)) {
                BrowserLauncher.noBrowserSet();
                return;
            }
            switch (jvm) {
                case 0: {
                    Object aeDesc = null;
                    try {
                        aeDesc = aeDescConstructor.newInstance(url);
                        putParameter.invoke(aBrowser, keyDirectObject, aeDesc);
                        sendNoReply.invoke(aBrowser, ArrayUtils.EMPTY_OBJECT_ARRAY);
                        break;
                    }
                    catch (InvocationTargetException ite) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr6", ite.getMessage()));
                    }
                    catch (IllegalAccessException iae) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr7", iae.getMessage()));
                    }
                    catch (InstantiationException ie) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr8", ie.getMessage()));
                    }
                    finally {
                        aeDesc = null;
                        aBrowser = null;
                    }
                }
                case 1: {
                    Runtime.getRuntime().exec(new String[]{(String)aBrowser, url});
                    break;
                }
                case 3: {
                    int[] instance = new int[1];
                    int result = BrowserLauncher.ICStart(instance, 0);
                    if (result == 0) {
                        int[] selectionEnd;
                        int[] selectionStart = new int[]{0};
                        byte[] urlBytes = url.getBytes();
                        result = BrowserLauncher.ICLaunchURL(instance[0], new byte[]{0}, urlBytes, urlBytes.length, selectionStart, selectionEnd = new int[]{urlBytes.length});
                        if (result == 0) {
                            BrowserLauncher.ICStop(instance);
                            break;
                        }
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr9", String.valueOf(result)));
                    }
                    throw new IOException(LanguageBundle.getFormattedString("in_BLEr10", String.valueOf(result)));
                }
                case 4: {
                    try {
                        Logging.log(Logging.INFO, LanguageBundle.getFormattedString("in_BLEr11", url));
                        openURL.invoke(null, url);
                        break;
                    }
                    catch (InvocationTargetException ite) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr12", ite.getMessage()));
                    }
                    catch (IllegalAccessException iae) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr13", iae.getMessage()));
                    }
                }
                case 5: 
                case 6: {
                    Process process = Runtime.getRuntime().exec(new String[]{(String)aBrowser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, '\"' + url + '\"'});
                    try {
                        process.waitFor();
                        process.exitValue();
                        break;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr14", ie.getMessage()));
                    }
                }
                case -1: {
                    Process process = Runtime.getRuntime().exec(new String[]{(String)aBrowser, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END});
                    try {
                        int exitCode = process.waitFor();
                        if (exitCode != 0) {
                            Runtime.getRuntime().exec(new String[]{(String)aBrowser, url});
                        }
                        break;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(LanguageBundle.getFormattedString("in_BLEr14", ie.getMessage()));
                    }
                }
                default: {
                    Runtime.getRuntime().exec(new String[]{(String)aBrowser, url});
                }
            }
        } else {
            String browserPath = PCGenSettings.OPTIONS_CONTEXT.getProperty("browserPath");
            if (BrowserLauncher.isBrowserPathNull(browserPath)) {
                BrowserLauncher.noBrowserSet();
                return;
            }
            Logging.log(Logging.INFO, LanguageBundle.getFormattedString("in_BLEr15", browserPath));
            if (jvm == 4 && browserPath.toLowerCase().endsWith(".app")) {
                Logging.log(Logging.INFO, LanguageBundle.getFormattedString("in_BLEr16", browserPath, url));
                Runtime.getRuntime().exec(new String[]{"open", "-a", browserPath, url});
            } else {
                Logging.log(Logging.INFO, LanguageBundle.getFormattedString("in_BLEr17", browserPath, url));
                Runtime.getRuntime().exec(new String[]{browserPath, url});
            }
        }
    }

    private static boolean isBrowserPathNull(Object browserPath) {
        return browserPath == null || browserPath.equals("") || browserPath.equals("null");
    }

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", String.class);
                    putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", ArrayUtils.EMPTY_CLASS_ARRAY);
                    Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)keyDirectObjectField.get(null);
                    Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
                    Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = linker.getConstructor(Class.class);
                    constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (InvocationTargetException ite) {
                    errorMessage = ite.getMessage();
                    return false;
                }
                catch (InstantiationException ie) {
                    errorMessage = ie.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer finderCreatorCode = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object aeTarget = aeTargetConstructor.newInstance(finderCreatorCode);
                    Integer gurlType = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object appleEvent = appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, kAutoGenerateReturnID, kAnyTransactionID);
                    return appleEvent;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InstantiationException ie) {
                    browser = null;
                    errorMessage = ie.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getMessage();
                    return browser;
                }
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                for (int i = 0; i < systemFolderFiles.length; ++i) {
                    try {
                        Object fileCreator;
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (!file.isFile() || !FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString()) || !FINDER_CREATOR.equals((fileCreator = getFileCreator.invoke(null, file)).toString())) continue;
                        browser = file.toString();
                        return browser;
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                }
                return null;
            }
            case 3: 
            case 4: {
                browser = "";
                return "";
            }
            case 5: {
                return "cmd.exe";
            }
            case 6: {
                return "command.com";
            }
        }
        browser = System.getProperty(BROWSER_PROPERTY, null);
        if (null != browser) {
            return browser;
        }
        return null;
    }

    private static void noBrowserSet() {
        ShowMessageDelegate.showMessageDialog("Please set your browser in the Preferences", "PCGen", MessageType.ERROR);
    }

    static {
        block11: {
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                String mrjVersion = System.getProperty("mrj.version");
                if (mrjVersion == null) {
                    jvm = 4;
                } else {
                    String majorMRJVersion = mrjVersion.length() < 3 ? mrjVersion : mrjVersion.substring(0, 3);
                    try {
                        double version = Double.valueOf(majorMRJVersion);
                        if (version < 2.1) {
                            jvm = 0;
                            break block11;
                        }
                        if (version >= 2.1 && version < 3.0) {
                            jvm = 1;
                            break block11;
                        }
                        if (version == 3.0) {
                            jvm = 3;
                            break block11;
                        }
                        if (version >= 3.1) {
                            jvm = 4;
                            break block11;
                        }
                        loadedWithoutErrors = false;
                        errorMessage = LanguageBundle.getFormattedString("in_BLEr1", String.valueOf(version));
                    }
                    catch (NumberFormatException nfe) {
                        loadedWithoutErrors = false;
                        errorMessage = LanguageBundle.getFormattedString("in_BLEr2", String.valueOf(mrjVersion));
                    }
                }
            } else {
                jvm = osName.startsWith("Windows") ? (osName.indexOf("9") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

