/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.ArmorProf;
import pcgen.core.Campaign;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.ShieldProf;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.character.CompanionMod;
import pcgen.core.spell.Spell;
import pcgen.gui2.converter.ConversionDecider;
import pcgen.gui2.converter.Loader;
import pcgen.gui2.converter.loader.AbilityLoader;
import pcgen.gui2.converter.loader.BasicLoader;
import pcgen.gui2.converter.loader.ClassLoader;
import pcgen.gui2.converter.loader.CopyLoader;
import pcgen.gui2.converter.loader.EquipmentLoader;
import pcgen.gui2.converter.loader.SelfCopyLoader;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SourceFileLoader;
import pcgen.persistence.lst.AbilityCategoryLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.GenericLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.rules.context.EditorLoadContext;
import pcgen.rules.persistence.CDOMControlLoader;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class LSTConverter
extends Observable {
    private final AbilityCategoryLoader catLoader = new AbilityCategoryLoader();
    private final GenericLoader<PCCheck> savesLoader = new GenericLoader<PCCheck>(PCCheck.class);
    private final GenericLoader<PCAlignment> alignmentLoader = new GenericLoader<PCAlignment>(PCAlignment.class);
    private final GenericLoader<PCStat> statLoader = new GenericLoader<PCStat>(PCStat.class);
    private final CDOMControlLoader dataControlLoader = new CDOMControlLoader();
    private final EditorLoadContext context;
    private List<Loader> loaders;
    private Set<URI> written = new HashSet<URI>();
    private final String outDir;
    private final File rootDir;
    private final DoubleKeyMapToList<Loader, URI, CDOMObject> injected = new DoubleKeyMapToList();
    private final ConversionDecider decider;
    private Writer changeLogWriter;

    public LSTConverter(EditorLoadContext lc, File root, String outputDir, ConversionDecider cd, Writer changeLogWriter) {
        this.context = lc;
        this.rootDir = root;
        this.outDir = outputDir;
        this.decider = cd;
        this.changeLogWriter = changeLogWriter;
        this.loaders = this.setupLoaders(this.context, changeLogWriter);
    }

    public int getNumFilesInCampaign(Campaign campaign) {
        int numFiles = 0;
        for (Loader loader : this.loaders) {
            List<CampaignSourceEntry> files = loader.getFiles(campaign);
            numFiles += files.size();
        }
        return numFiles;
    }

    public void initCampaigns(List<Campaign> campaigns) {
        ArrayList<CampaignSourceEntry> dataDefFileList = new ArrayList<CampaignSourceEntry>();
        for (Campaign campaign : campaigns) {
            try {
                this.catLoader.loadLstFiles(this.context, campaign.getSafeListFor(ListKey.FILE_ABILITY_CATEGORY));
                this.statLoader.loadLstFiles(this.context, campaign.getSafeListFor(ListKey.FILE_STAT));
                this.savesLoader.loadLstFiles(this.context, campaign.getSafeListFor(ListKey.FILE_SAVE));
                this.alignmentLoader.loadLstFiles(this.context, campaign.getSafeListFor(ListKey.FILE_ALIGNMENT));
                this.alignmentLoader.loadLstFiles(Globals.getContext(), campaign.getSafeListFor(ListKey.FILE_ALIGNMENT));
            }
            catch (PersistenceLayerException e) {
                e.printStackTrace();
            }
            dataDefFileList.addAll(campaign.getSafeListFor(ListKey.FILE_DATACTRL));
        }
        try {
            SourceFileLoader.addDefaultDataControlIfNeeded(dataDefFileList);
            this.dataControlLoader.loadLstFiles(this.context, dataDefFileList);
            SourceFileLoader.processFactDefinitions(this.context);
        }
        catch (PersistenceLayerException e) {
            Logging.errorPrint("LSTConverter.initCampaigns failed", e);
        }
    }

    public void processCampaign(Campaign campaign) {
        this.startItem(campaign);
    }

    private void startItem(Campaign campaign) {
        for (Loader loader : this.loaders) {
            List<CampaignSourceEntry> files = loader.getFiles(campaign);
            for (CampaignSourceEntry cse : files) {
                URI canonicalUri;
                URI uri = cse.getURI();
                this.setChanged();
                this.notifyObservers(uri);
                if (!"file".equalsIgnoreCase(uri.getScheme())) {
                    Logging.log(Logging.WARNING, "Skipping campaign " + uri + " from " + campaign.getSourceURI() + " as it is not a local file.");
                    continue;
                }
                File in = new File(uri);
                try {
                    canonicalUri = in.getCanonicalFile().toURI();
                }
                catch (IOException e1) {
                    Logging.log(Logging.WARNING, "Skipping campaign " + uri + " from " + campaign.getSourceURI() + " as it could not be made canonical. " + e1.getMessage());
                    continue;
                }
                if (this.written.contains(canonicalUri)) continue;
                this.written.add(canonicalUri);
                File base = this.findSubRoot(this.rootDir, in);
                if (base == null) {
                    Logging.log(Logging.WARNING, "Skipping campaign " + uri + " from " + campaign.getSourceURI() + " as it is not in the selected source directory.");
                    continue;
                }
                String relative = in.toString().substring(base.toString().length() + 1);
                if (!in.exists()) {
                    Logging.log(Logging.WARNING, "Skipping campaign " + uri + " from " + campaign.getSourceURI() + " as it does not exist. Campaign is " + cse.getCampaign().getSourceURI());
                    continue;
                }
                File outFile = new File(this.outDir, File.separator + relative);
                if (outFile.exists()) {
                    Logging.log(Logging.WARNING, "Won't overwrite: " + outFile);
                    continue;
                }
                this.ensureParents(outFile.getParentFile());
                try {
                    this.changeLogWriter.append("\nProcessing " + in + "\n");
                    String result = this.load(uri, loader);
                    if (result == null) continue;
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    out.write(result);
                    ((Writer)out).close();
                }
                catch (PersistenceLayerException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<Loader> setupLoaders(EditorLoadContext context, Writer changeLogWriter) {
        ArrayList<Loader> loaderList = new ArrayList<Loader>();
        loaderList.add(new BasicLoader<WeaponProf>(context, WeaponProf.class, ListKey.FILE_WEAPON_PROF, changeLogWriter));
        loaderList.add(new BasicLoader<ArmorProf>(context, ArmorProf.class, ListKey.FILE_ARMOR_PROF, changeLogWriter));
        loaderList.add(new BasicLoader<ShieldProf>(context, ShieldProf.class, ListKey.FILE_SHIELD_PROF, changeLogWriter));
        loaderList.add(new BasicLoader<Skill>(context, Skill.class, ListKey.FILE_SKILL, changeLogWriter));
        loaderList.add(new BasicLoader<Language>(context, Language.class, ListKey.FILE_LANGUAGE, changeLogWriter));
        loaderList.add(new BasicLoader<Ability>(context, Ability.class, ListKey.FILE_FEAT, changeLogWriter));
        loaderList.add(new AbilityLoader(context, Ability.class, ListKey.FILE_ABILITY, changeLogWriter));
        loaderList.add(new BasicLoader<Race>(context, Race.class, ListKey.FILE_RACE, changeLogWriter));
        loaderList.add(new BasicLoader<Domain>(context, Domain.class, ListKey.FILE_DOMAIN, changeLogWriter));
        loaderList.add(new BasicLoader<Spell>(context, Spell.class, ListKey.FILE_SPELL, changeLogWriter));
        loaderList.add(new BasicLoader<Deity>(context, Deity.class, ListKey.FILE_DEITY, changeLogWriter));
        loaderList.add(new BasicLoader<PCTemplate>(context, PCTemplate.class, ListKey.FILE_TEMPLATE, changeLogWriter));
        loaderList.add(new EquipmentLoader(context, ListKey.FILE_EQUIP, changeLogWriter));
        loaderList.add(new BasicLoader<EquipmentModifier>(context, EquipmentModifier.class, ListKey.FILE_EQUIP_MOD, changeLogWriter));
        loaderList.add(new BasicLoader<CompanionMod>(context, CompanionMod.class, ListKey.FILE_COMPANION_MOD, changeLogWriter));
        loaderList.add(new ClassLoader(context, changeLogWriter));
        loaderList.add(new CopyLoader(ListKey.FILE_ABILITY_CATEGORY));
        loaderList.add(new CopyLoader(ListKey.LICENSE_FILE));
        loaderList.add(new CopyLoader(ListKey.FILE_KIT));
        loaderList.add(new CopyLoader(ListKey.FILE_BIO_SET));
        loaderList.add(new CopyLoader(ListKey.FILE_DATACTRL));
        loaderList.add(new CopyLoader(ListKey.FILE_STAT));
        loaderList.add(new CopyLoader(ListKey.FILE_SAVE));
        loaderList.add(new CopyLoader(ListKey.FILE_ALIGNMENT));
        loaderList.add(new CopyLoader(ListKey.FILE_PCC));
        loaderList.add(new SelfCopyLoader());
        return loaderList;
    }

    private void ensureParents(File parentFile) {
        if (!parentFile.exists()) {
            this.ensureParents(parentFile.getParentFile());
            parentFile.mkdir();
        }
    }

    private File findSubRoot(File root, File in) {
        File parent = in.getParentFile();
        if (parent == null) {
            return null;
        }
        if (parent.getAbsolutePath().equals(root.getAbsolutePath())) {
            return parent;
        }
        return this.findSubRoot(root, parent);
    }

    private String load(URI uri, Loader loader) throws InterruptedException, PersistenceLayerException {
        StringBuilder dataBuffer;
        this.context.setSourceURI(uri);
        this.context.setExtractURI(uri);
        try {
            dataBuffer = LstFileLoader.readFromURI(uri);
        }
        catch (PersistenceLayerException ple) {
            String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.LoadError", uri, ple.getMessage());
            Logging.errorPrint(message);
            return null;
        }
        StringBuilder resultBuffer = new StringBuilder(dataBuffer.length());
        String aString = dataBuffer.toString();
        String[] fileLines = aString.split("(\r\n?|\n)");
        for (int line = 0; line < fileLines.length; ++line) {
            String lineString = fileLines[line];
            if (lineString.length() == 0 || lineString.charAt(0) == '#' || lineString.startsWith("SOURCE")) {
                resultBuffer.append(lineString);
            } else {
                List<CDOMObject> newObj = loader.process(resultBuffer, line, lineString, this.decider);
                if (newObj != null) {
                    for (CDOMObject cdo : newObj) {
                        this.injected.addToListFor((Object)loader, (Object)uri, (Object)cdo);
                    }
                }
            }
            resultBuffer.append("\n");
        }
        return resultBuffer.toString();
    }

    public Collection<Loader> getInjectedLoaders() {
        return this.injected.getKeySet();
    }

    public Collection<URI> getInjectedURIs(Loader l) {
        return this.injected.getSecondaryKeySet((Object)l);
    }

    public Collection<CDOMObject> getInjectedObjects(Loader l, URI uri) {
        return this.injected.getListFor((Object)l, (Object)uri);
    }
}

