/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.AbilityCategory;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.SortedProperties;
import pcgen.persistence.PersistenceManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public final class SettingsHandler {
    private static boolean autoFeatsRefundable = false;
    private static boolean autogenExoticMaterial = false;
    private static boolean autogenMagic = false;
    private static boolean autogenMasterwork = false;
    private static boolean autogenRacial = false;
    public static boolean validateBonuses = false;
    private static int maxPotionSpellLevel = 3;
    private static int maxWandSpellLevel = 4;
    private static boolean allowMetamagicInCustomizer = false;
    private static boolean spellMarketPriceAdjusted = false;
    private static Map<String, String> ruleCheckMap = new HashMap<String, String>();
    private static String browserPath = null;
    private static int chaTabPlacement = 1;
    private static Dimension customizerDimension = null;
    private static Point customizerLeftUpperCorner = null;
    private static int customizerSplit1 = -1;
    private static int customizerSplit2 = -1;
    private static boolean enforceSpendingBeforeLevelUp = false;
    private static final Properties FILTERSETTINGS = new Properties();
    public static GameMode game = new GameMode("default");
    private static boolean grimHPMode = false;
    private static boolean grittyACMode = false;
    private static Dimension kitSelectorDimension = null;
    private static Point kitSelectorLeftUpperCorner = null;
    private static boolean useWaitCursor = true;
    private static boolean loadURLs = false;
    private static boolean hpMaxAtFirstLevel = true;
    private static boolean hpMaxAtFirstClassLevel = true;
    private static boolean hpMaxAtFirstPCClassLevelOnly = true;
    private static int hpRollMethod = 0;
    private static int hpPercent = 100;
    private static boolean ignoreMonsterHDCap = false;
    private static String invalidDmgText;
    private static String invalidToHitText;
    private static boolean gearTab_IgnoreCost;
    private static boolean gearTab_AutoResize;
    private static boolean gearTab_AllowDebt;
    private static int gearTab_SellRate;
    private static int gearTab_BuyRate;
    private static boolean isROG;
    private static Point leftUpperCorner;
    private static int windowState;
    private static int looknFeel;
    private static final SortedProperties options;
    private static final Properties filepaths;
    private static final String fileLocation;
    private static File pccFilesLocation;
    private static File pcgPath;
    private static File lastUsedPcgPath;
    private static File backupPcgPath;
    private static boolean createPcgBackup;
    private static File portraitsPath;
    private static File pcgenSponsorDir;
    private static File pcgenOutputSheetDir;
    private static File gmgenPluginDir;
    private static int prereqQualifyColor;
    private static int prereqFailColor;
    private static boolean previewTabShown;
    private static File pcgenPreviewDir;
    private static boolean saveCustomInLst;
    private static String selectedCharacterHTMLOutputSheet;
    private static String selectedCharacterPDFOutputSheet;
    private static boolean saveOutputSheetWithPC;
    private static boolean printSpellsWithPC;
    private static String selectedPartyHTMLOutputSheet;
    private static String selectedPartyPDFOutputSheet;
    private static String selectedEqSetTemplate;
    private static String selectedSpellSheet;
    private static boolean showFeatDialogAtLevelUp;
    private static boolean showHPDialogAtLevelUp;
    private static boolean showStatDialogAtLevelUp;
    private static boolean showToolBar;
    private static boolean showSkillModifier;
    private static boolean showSkillRanks;
    private static boolean showWarningAtFirstLevelUp;
    private static String skinLFThemePack;
    private static boolean alwaysOverwrite;
    private static String defaultOSType;
    private static int tabPlacement;
    private static final String tmpPath;
    private static final File tempPath;
    private static boolean useHigherLevelSlotsDefault;
    private static boolean wantToLoadMasterworkAndMagic;
    private static int nameDisplayStyle;
    private static boolean weaponProfPrintout;
    private static String postExportCommandStandard;
    private static String postExportCommandPDF;
    private static boolean hideMonsterClasses;
    private static boolean guiUsesOutputNameEquipment;
    private static boolean guiUsesOutputNameSpells;
    private static int lastTipShown;
    private static boolean showMemoryArea;
    private static boolean showImagePreview;
    private static boolean showTipOfTheDay;
    private static boolean isGMGen;
    private static boolean showSingleBoxPerBundle;
    private static boolean outputDeprecationMessages;
    private static boolean inputUnconstructedMessages;

    public static String getSelectedGenerators(String string) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void setSelectedGenerators(String prop, String generators) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void setAlwaysOverwrite(boolean argAlwaysOverwrite) {
        alwaysOverwrite = argAlwaysOverwrite;
    }

    public static boolean getAlwaysOverwrite() {
        return alwaysOverwrite;
    }

    public static void setDefaultOSType(String argDefaultOSType) {
        defaultOSType = argDefaultOSType;
    }

    public static String getDefaultOSType() {
        return defaultOSType;
    }

    public static void setAutogen(int idx, boolean bFlag) {
        switch (idx) {
            case 1: {
                SettingsHandler.setAutogenRacial(bFlag);
                break;
            }
            case 2: {
                SettingsHandler.setAutogenMasterwork(bFlag);
                break;
            }
            case 3: {
                SettingsHandler.setAutogenMagic(bFlag);
                break;
            }
            case 4: {
                SettingsHandler.setAutogenExoticMaterial(bFlag);
                break;
            }
        }
    }

    public static boolean getAutogen(int idx) {
        if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
            switch (idx) {
                case 1: {
                    return SettingsHandler.isAutogenRacial();
                }
                case 2: {
                    return SettingsHandler.isAutogenMasterwork();
                }
                case 3: {
                    return SettingsHandler.isAutogenMagic();
                }
                case 4: {
                    return SettingsHandler.isAutogenExoticMaterial();
                }
            }
        }
        return false;
    }

    public static void setBackupPcgPath(File path) {
        backupPcgPath = path;
    }

    public static File getBackupPcgPath() {
        return backupPcgPath;
    }

    public static void setBrowserPath(String path) {
        browserPath = path;
    }

    public static String getBrowserPath() {
        return browserPath;
    }

    public static void setChaTabPlacement(int argChaTabPlacement) {
        chaTabPlacement = argChaTabPlacement;
    }

    public static int getChaTabPlacement() {
        return chaTabPlacement;
    }

    public static void setCreatePcgBackup(boolean argCreatePcgBackup) {
        createPcgBackup = argCreatePcgBackup;
    }

    public static boolean getCreatePcgBackup() {
        return createPcgBackup;
    }

    public static void setCustomizerDimension(Dimension d) {
        customizerDimension = d;
    }

    public static Dimension getCustomizerDimension() {
        return customizerDimension;
    }

    public static void setCustomizerLeftUpperCorner(Point argLeftUpperCorner) {
        customizerLeftUpperCorner = argLeftUpperCorner;
    }

    public static Point getCustomizerLeftUpperCorner() {
        return customizerLeftUpperCorner;
    }

    public static void setCustomizerSplit1(int split) {
        customizerSplit1 = split;
    }

    public static int getCustomizerSplit1() {
        return customizerSplit1;
    }

    public static void setCustomizerSplit2(int split) {
        customizerSplit2 = split;
    }

    public static int getCustomizerSplit2() {
        return customizerSplit2;
    }

    public static void setEnforceSpendingBeforeLevelUp(boolean argEnforceSpendingBeforeLevelUp) {
        enforceSpendingBeforeLevelUp = argEnforceSpendingBeforeLevelUp;
    }

    public static boolean getEnforceSpendingBeforeLevelUp() {
        return enforceSpendingBeforeLevelUp;
    }

    public static void setFilePaths(String aString) {
        SettingsHandler.getFilepathProp().setProperty("pcgen.filepaths", aString);
    }

    public static String getFilePaths() {
        String def_type = "user";
        if (Globals.isMacPlatform) {
            def_type = "mac_user";
        }
        return SettingsHandler.getFilepathProp().getProperty("pcgen.filepaths", def_type);
    }

    public static Properties getFilepathProp() {
        return filepaths;
    }

    public static boolean getFirstRun() {
        File aFile = new File(fileLocation);
        return !aFile.exists();
    }

    public static boolean isGMGen() {
        return isGMGen;
    }

    public static void setGMGenOption(String optionName, boolean optionValue) {
        SettingsHandler.setGMGenOption(optionName, optionValue ? "true" : "false");
    }

    public static void setGMGenOption(String optionName, int optionValue) {
        SettingsHandler.setGMGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setGMGenOption(String optionName, double optionValue) {
        SettingsHandler.setGMGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setGMGenOption(String optionName, String optionValue) {
        SettingsHandler.getOptions().setProperty("gmgen.options." + optionName, optionValue);
    }

    public static boolean getGMGenOption(String optionName, boolean defaultValue) {
        String option = SettingsHandler.getGMGenOption(optionName, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(option);
    }

    public static int getGMGenOption(String optionName, int defaultValue) {
        return Integer.decode(SettingsHandler.getGMGenOption(optionName, String.valueOf(defaultValue)));
    }

    public static Double getGMGenOption(String optionName, double defaultValue) {
        return new Double(SettingsHandler.getGMGenOption(optionName, Double.toString(defaultValue)));
    }

    public static String getGMGenOption(String optionName, String defaultValue) {
        return SettingsHandler.getOptions().getProperty("gmgen.options." + optionName, defaultValue);
    }

    public static void setGUIUsesOutputNameEquipment(boolean argUseOutputNameEquipment) {
        guiUsesOutputNameEquipment = argUseOutputNameEquipment;
    }

    public static void setGUIUsesOutputNameSpells(boolean argUseOutputNameSpells) {
        guiUsesOutputNameSpells = argUseOutputNameSpells;
    }

    public static void setGame(String g) {
        GameMode newMode = SystemCollections.getGameModeNamed(g);
        if (newMode != null) {
            game = newMode;
        }
        String key = g;
        String unitSetName = SettingsHandler.getOptions().getProperty("pcgen.options.gameMode." + key + ".unitSetName", SettingsHandler.getOptions().getProperty("pcgen.options.unitSetName." + key, game.getDefaultUnitSet()));
        if (!game.selectUnitSet(unitSetName) && !game.selectDefaultUnitSet()) {
            game.selectUnitSet("Imperial");
        }
        game.setDefaultXPTableName(SettingsHandler.getPCGenOption("gameMode." + key + ".xpTableName", ""));
        game.setDefaultCharacterType(SettingsHandler.getPCGenOption("gameMode." + key + ".characterType", ""));
        AbilityCategory featTemplate = game.getFeatTemplate();
        if (featTemplate != null) {
            AbilityCategory.FEAT.copyFields(featTemplate);
        }
        SettingsHandler.getChosenCampaignFiles(game);
    }

    public static GameMode getGame() {
        return game;
    }

    public static void setGearTab_AllowDebt(boolean allowDebt) {
        gearTab_AllowDebt = allowDebt;
    }

    public static boolean getGearTab_AllowDebt() {
        return gearTab_AllowDebt;
    }

    public static void setGearTab_AutoResize(boolean autoResize) {
        gearTab_AutoResize = autoResize;
    }

    public static boolean getGearTab_AutoResize() {
        return gearTab_AutoResize;
    }

    public static void setGearTab_BuyRate(int argBuyRate) {
        gearTab_BuyRate = argBuyRate;
    }

    public static int getGearTab_BuyRate() {
        return gearTab_BuyRate;
    }

    public static void setGearTab_IgnoreCost(boolean ignoreCost) {
        gearTab_IgnoreCost = ignoreCost;
    }

    public static boolean getGearTab_IgnoreCost() {
        return gearTab_IgnoreCost;
    }

    public static void setGearTab_SellRate(int argSellRate) {
        gearTab_SellRate = argSellRate;
    }

    public static int getGearTab_SellRate() {
        return gearTab_SellRate;
    }

    public static void setGmgenPluginDir(File aFile) {
        gmgenPluginDir = aFile;
    }

    public static File getGmgenPluginDir() {
        return gmgenPluginDir;
    }

    public static void setHPMaxAtFirstLevel(boolean aBool) {
        hpMaxAtFirstLevel = aBool;
    }

    public static boolean isHPMaxAtFirstLevel() {
        return hpMaxAtFirstLevel;
    }

    public static void setHPMaxAtFirstClassLevel(boolean aBool) {
        hpMaxAtFirstClassLevel = aBool;
    }

    public static boolean isHPMaxAtFirstClassLevel() {
        return hpMaxAtFirstClassLevel;
    }

    public static void setHPMaxAtFirstPCClassLevelOnly(boolean aBool) {
        hpMaxAtFirstPCClassLevelOnly = aBool;
    }

    public static boolean isHPMaxAtFirstPCClassLevelOnly() {
        return hpMaxAtFirstPCClassLevelOnly;
    }

    public static void setHPPercent(int argHPPct) {
        hpPercent = argHPPct;
    }

    public static int getHPPercent() {
        return hpPercent;
    }

    public static void setHPRollMethod(int aBool) {
        hpRollMethod = aBool;
    }

    public static int getHPRollMethod() {
        return hpRollMethod;
    }

    public static String getHTMLOutputSheetPath() {
        if ("".equals(selectedCharacterHTMLOutputSheet)) {
            return ConfigurationSettings.getOutputSheetsDir();
        }
        return new File(selectedCharacterHTMLOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setHideMonsterClasses(boolean argHideMonsterClasses) {
        hideMonsterClasses = argHideMonsterClasses;
    }

    public static void setIgnoreMonsterHDCap(boolean argIgoreCap) {
        ignoreMonsterHDCap = argIgoreCap;
    }

    public static boolean isIgnoreMonsterHDCap() {
        return ignoreMonsterHDCap;
    }

    public static void setInvalidDmgText(String string) {
        invalidDmgText = string;
    }

    public static String getInvalidDmgText() {
        return invalidDmgText;
    }

    public static void setInvalidToHitText(String string) {
        invalidToHitText = string;
    }

    public static String getInvalidToHitText() {
        return invalidToHitText;
    }

    public static void setIsGMGen(boolean GMGen) {
        isGMGen = GMGen;
    }

    public static void setKitSelectorDimension(Dimension d) {
        kitSelectorDimension = d;
    }

    public static Dimension getKitSelectorDimension() {
        return kitSelectorDimension;
    }

    public static void setKitSelectorLeftUpperCorner(Point argLeftUpperCorner) {
        kitSelectorLeftUpperCorner = argLeftUpperCorner;
    }

    public static Point getKitSelectorLeftUpperCorner() {
        return kitSelectorLeftUpperCorner;
    }

    public static void setLastTipShown(int argLastTipShown) {
        lastTipShown = argLastTipShown;
    }

    public static int getLastTipShown() {
        return lastTipShown;
    }

    public static void setLeftUpperCorner(Point argLeftUpperCorner) {
        leftUpperCorner = argLeftUpperCorner;
    }

    public static Point getLeftUpperCorner() {
        return leftUpperCorner;
    }

    public static void setLoadURLs(boolean aBool) {
        loadURLs = aBool;
    }

    public static boolean isLoadURLs() {
        return loadURLs;
    }

    public static void setLookAndFeel(int argLookAndFeel) {
        looknFeel = argLookAndFeel;
    }

    public static int getLookAndFeel() {
        return looknFeel;
    }

    public static void setMaxPotionSpellLevel(int anInt) {
        maxPotionSpellLevel = anInt;
    }

    public static int getMaxPotionSpellLevel() {
        return maxPotionSpellLevel;
    }

    public static void setMaxWandSpellLevel(int anInt) {
        maxWandSpellLevel = anInt;
    }

    public static int getMaxWandSpellLevel() {
        return maxWandSpellLevel;
    }

    public static void setMetamagicAllowedInEqBuilder(boolean aBool) {
        allowMetamagicInCustomizer = aBool;
    }

    public static boolean isMetamagicAllowedInEqBuilder() {
        return allowMetamagicInCustomizer;
    }

    public static void setNameDisplayStyle(int style) {
        nameDisplayStyle = style;
    }

    public static int getNameDisplayStyle() {
        return nameDisplayStyle;
    }

    public static SortedProperties getOptions() {
        return options;
    }

    public static Dimension getOptionsFromProperties(PlayerCharacter aPC) {
        Dimension d = new Dimension(0, 0);
        String tempBrowserPath = SettingsHandler.getPCGenOption("browserPath", "");
        if (!"".equals(tempBrowserPath)) {
            SettingsHandler.setBrowserPath(tempBrowserPath);
        } else {
            SettingsHandler.setBrowserPath(null);
        }
        SettingsHandler.setLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("windowLeftUpperCorner.Y", -1.0).intValue()));
        SettingsHandler.setWindowState(SettingsHandler.getPCGenOption("windowState", 0));
        Double dw = SettingsHandler.getPCGenOption("windowWidth", 0.0);
        Double dh = SettingsHandler.getPCGenOption("windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(dw, 0.0) && !CoreUtility.doublesEqual(dh, 0.0)) {
            int width = Integer.parseInt(dw.toString().substring(0, Math.min(dw.toString().length(), dw.toString().lastIndexOf("."))));
            int height = Integer.parseInt(dh.toString().substring(0, Math.min(dh.toString().length(), dh.toString().lastIndexOf("."))));
            d = new Dimension(width, height);
        }
        SettingsHandler.setCustomizerLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.Y", -1.0).intValue()));
        dw = SettingsHandler.getPCGenOption("customizer.windowWidth", 0.0);
        dh = SettingsHandler.getPCGenOption("customizer.windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(dw, 0.0) && !CoreUtility.doublesEqual(dh, 0.0)) {
            SettingsHandler.setCustomizerDimension(new Dimension(dw.intValue(), dh.intValue()));
        }
        SettingsHandler.setKitSelectorLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("kitSelector.windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("kitSelector.windowLeftUpperCorner.Y", -1.0).intValue()));
        dw = SettingsHandler.getPCGenOption("kitSelector.windowWidth", 0.0);
        dh = SettingsHandler.getPCGenOption("kitSelector.windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(dw, 0.0) && !CoreUtility.doublesEqual(dh, 0.0)) {
            SettingsHandler.setKitSelectorDimension(new Dimension(dw.intValue(), dh.intValue()));
        }
        int buyRate = SettingsHandler.getPCGenOption("GearTab.buyRate", -1);
        int sellRate = SettingsHandler.getPCGenOption("GearTab.sellRate", -1);
        if (buyRate < 0 || sellRate < 0) {
            if (SettingsHandler.getPCGenOption("GearTab.ignoreCost", false)) {
                buyRate = 0;
                sellRate = 0;
            } else {
                buyRate = 100;
                sellRate = 50;
            }
        }
        Globals.initCustColumnWidth(CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.options.custColumnWidth", ""), ','));
        loadURLs = SettingsHandler.getPCGenOption("loadURLs", false);
        Globals.setSourceDisplay(SourceFormat.values()[SettingsHandler.getPCGenOption("sourceDisplay", SourceFormat.LONG.ordinal())]);
        SettingsHandler.setAlwaysOverwrite(SettingsHandler.getPCGenOption("alwaysOverwrite", false));
        SettingsHandler.setAutoFeatsRefundable(SettingsHandler.getPCGenOption("autoFeatsRefundable", false));
        SettingsHandler.setAutogenExoticMaterial(SettingsHandler.getPCGenOption("autoGenerateExoticMaterial", false));
        SettingsHandler.setAutogenMagic(SettingsHandler.getPCGenOption("autoGenerateMagic", false));
        SettingsHandler.setAutogenMasterwork(SettingsHandler.getPCGenOption("autoGenerateMasterwork", false));
        SettingsHandler.setAutogenRacial(SettingsHandler.getPCGenOption("autoGenerateRacial", false));
        SettingsHandler.setChaTabPlacement(SettingsHandler.getOptionTabPlacement("chaTabPlacement", 1));
        SettingsHandler.setCreatePcgBackup(SettingsHandler.getPCGenOption("createPcgBackup", true));
        SettingsHandler.setCustomizerSplit1(SettingsHandler.getPCGenOption("customizer.split1", -1));
        SettingsHandler.setCustomizerSplit2(SettingsHandler.getPCGenOption("customizer.split2", -1));
        SettingsHandler.setDefaultOSType(SettingsHandler.getPCGenOption("defaultOSType", null));
        SettingsHandler.setEnforceSpendingBeforeLevelUp(SettingsHandler.getPCGenOption("enforceSpendingBeforeLevelUp", false));
        SettingsHandler.setGearTab_AllowDebt(SettingsHandler.getPCGenOption("GearTab.allowDebt", false));
        SettingsHandler.setGearTab_AutoResize(SettingsHandler.getPCGenOption("GearTab.autoResize", false));
        SettingsHandler.setGearTab_BuyRate(buyRate);
        SettingsHandler.setGearTab_IgnoreCost(SettingsHandler.getPCGenOption("GearTab.ignoreCost", false));
        SettingsHandler.setGearTab_SellRate(sellRate);
        SettingsHandler.setGrimHPMode(SettingsHandler.getPCGenOption("grimHPMode", false));
        SettingsHandler.setGrittyACMode(SettingsHandler.getPCGenOption("grittyACMode", false));
        SettingsHandler.setGUIUsesOutputNameEquipment(SettingsHandler.getPCGenOption("GUIUsesOutputNameEquipment", false));
        SettingsHandler.setGUIUsesOutputNameSpells(SettingsHandler.getPCGenOption("GUIUsesOutputNameSpells", false));
        SettingsHandler.setHideMonsterClasses(SettingsHandler.getPCGenOption("hideMonsterClasses", false));
        SettingsHandler.setHPMaxAtFirstLevel(SettingsHandler.getPCGenOption("hpMaxAtFirstLevel", true));
        SettingsHandler.setHPMaxAtFirstClassLevel(SettingsHandler.getPCGenOption("hpMaxAtFirstClassLevel", false));
        SettingsHandler.setHPMaxAtFirstPCClassLevelOnly(SettingsHandler.getPCGenOption("hpMaxAtFirstPCClassLevelOnly", false));
        SettingsHandler.setHPPercent(SettingsHandler.getPCGenOption("hpPercent", 100));
        SettingsHandler.setHPRollMethod(SettingsHandler.getPCGenOption("hpRollMethod", 0));
        SettingsHandler.setIgnoreMonsterHDCap(SettingsHandler.getPCGenOption("ignoreMonsterHDCap", false));
        SettingsHandler.setInvalidDmgText(SettingsHandler.getPCGenOption("invalidDmgText", LanguageBundle.getString("SettingsHandler.114")));
        SettingsHandler.setInvalidToHitText(SettingsHandler.getPCGenOption("invalidToHitText", LanguageBundle.getString("SettingsHandler.114")));
        SettingsHandler.setLastTipShown(SettingsHandler.getPCGenOption("lastTipOfTheDayTipShown", -1));
        SettingsHandler.setLookAndFeel(SettingsHandler.getPCGenOption("looknFeel", 1));
        SettingsHandler.setMaxPotionSpellLevel(SettingsHandler.getPCGenOption("maxPotionSpellLevel", 3));
        SettingsHandler.setMaxWandSpellLevel(SettingsHandler.getPCGenOption("maxWandSpellLevel", 4));
        SettingsHandler.setMetamagicAllowedInEqBuilder(SettingsHandler.getPCGenOption("allowMetamagicInCustomizer", false));
        SettingsHandler.setPccFilesLocation(new File(SettingsHandler.expandRelativePath(SettingsHandler.getPCGenOption("pccFilesLocation", System.getProperty("user.dir") + File.separator + "data"))));
        SettingsHandler.setPcgenOutputSheetDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenOutputSheetDir", System.getProperty("user.dir") + File.separator + "outputsheets"))));
        SettingsHandler.setPcgenPreviewDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenPreviewDir", System.getProperty("user.dir") + File.separator + "preview"))));
        SettingsHandler.setGmgenPluginDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("gmgen.files.gmgenPluginDir", System.getProperty("user.dir") + File.separator + "plugins"))));
        SettingsHandler.setBackupPcgPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.characters.backup", ""))));
        SettingsHandler.setPortraitsPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.portraits", Globals.getDefaultPcgPath()))));
        SettingsHandler.setPostExportCommandStandard(SettingsHandler.getPCGenOption("postExportCommandStandard", ""));
        SettingsHandler.setPostExportCommandPDF(SettingsHandler.getPCGenOption("postExportCommandPDF", ""));
        SettingsHandler.setPrereqFailColor(SettingsHandler.getPCGenOption("prereqFailColor", Color.red.getRGB()));
        SettingsHandler.setPrereqQualifyColor(SettingsHandler.getPCGenOption("prereqQualifyColor", Color.black.getRGB()));
        SettingsHandler.setPreviewTabShown(SettingsHandler.getPCGenOption("previewTabShown", true));
        SettingsHandler.setROG(SettingsHandler.getPCGenOption("isROG", false));
        SettingsHandler.setSaveCustomInLst(SettingsHandler.getPCGenOption("saveCustomInLst", false));
        SettingsHandler.setSaveOutputSheetWithPC(SettingsHandler.getPCGenOption("saveOutputSheetWithPC", false));
        SettingsHandler.setPrintSpellsWithPC(SettingsHandler.getPCGenOption("printSpellsWithPC", true));
        SettingsHandler.setSelectedSpellSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedSpellOutputSheet", "")));
        SettingsHandler.setSelectedCharacterHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterHTMLOutputSheet", "")), aPC);
        SettingsHandler.setSelectedCharacterPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterPDFOutputSheet", "")), aPC);
        SettingsHandler.setSelectedEqSetTemplate(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedEqSetTemplate", "")));
        SettingsHandler.setSelectedPartyHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyHTMLOutputSheet", "")));
        SettingsHandler.setSelectedPartyPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyPDFOutputSheet", "")));
        SettingsHandler.setShowFeatDialogAtLevelUp(SettingsHandler.getPCGenOption("showFeatDialogAtLevelUp", true));
        SettingsHandler.setShowHPDialogAtLevelUp(SettingsHandler.getPCGenOption("showHPDialogAtLevelUp", true));
        SettingsHandler.setShowImagePreview(SettingsHandler.getPCGenOption("showImagePreview", true));
        SettingsHandler.setShowSingleBoxPerBundle(SettingsHandler.getPCGenOption("showSingleBoxPerBundle", false));
        SettingsHandler.setOutputDeprecationMessages(SettingsHandler.getPCGenOption("outputDeprecationMessages", true));
        SettingsHandler.setInputUnconstructedMessages(SettingsHandler.getPCGenOption("inputUnconstructedMessages", false));
        SettingsHandler.setShowStatDialogAtLevelUp(SettingsHandler.getPCGenOption("showStatDialogAtLevelUp", true));
        SettingsHandler.setShowTipOfTheDay(SettingsHandler.getPCGenOption("showTipOfTheDay", true));
        SettingsHandler.setShowToolBar(SettingsHandler.getPCGenOption("showToolBar", true));
        SettingsHandler.setShowSkillModifier(SettingsHandler.getPCGenOption("showSkillModifier", true));
        SettingsHandler.setShowSkillRanks(SettingsHandler.getPCGenOption("showSkillRanks", true));
        SettingsHandler.setShowWarningAtFirstLevelUp(SettingsHandler.getPCGenOption("showWarningAtFirstLevelUp", true));
        SettingsHandler.setSkinLFThemePack(SettingsHandler.getPCGenOption("skinLFThemePack", ""));
        SettingsHandler.setSpellMarketPriceAdjusted(SettingsHandler.getPCGenOption("spellMarketPriceAdjusted", false));
        SettingsHandler.setTabPlacement(SettingsHandler.getOptionTabPlacement("tabPlacement", 3));
        SettingsHandler.setUseHigherLevelSlotsDefault(SettingsHandler.getPCGenOption("useHigherLevelSlotsDefault", false));
        SettingsHandler.setUseWaitCursor(SettingsHandler.getPCGenOption("useWaitCursor", true));
        SettingsHandler.setWantToLoadMasterworkAndMagic(SettingsHandler.getPCGenOption("loadMasterworkAndMagicFromLst", false));
        SettingsHandler.setWeaponProfPrintout(SettingsHandler.getPCGenOption("weaponProfPrintout", true));
        SettingsHandler.parseRuleChecksFromOptions(SettingsHandler.getPCGenOption("ruleChecks", ""));
        return d;
    }

    private static void getChosenCampaignFiles(GameMode gameMode) {
        List<String> uriStringList = CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.files.chosenCampaignSourcefiles." + gameMode.getName(), ""), ',');
        ArrayList<URI> uriList = new ArrayList<URI>(uriStringList.size());
        for (String str : uriStringList) {
            try {
                uriList.add(new URI(str));
            }
            catch (URISyntaxException e) {
                Logging.errorPrint("Settings error: Unable to convert " + str + " to a URI: " + e.getLocalizedMessage());
            }
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(uriList, gameMode);
    }

    public static void setOptionsProperties(PlayerCharacter aPC) {
        if (SettingsHandler.getBackupPcgPath() != null && !SettingsHandler.getBackupPcgPath().getPath().equals("")) {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters.backup", SettingsHandler.retractRelativePath(SettingsHandler.getBackupPcgPath().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters.backup", "");
        }
        SettingsHandler.getOptions().setProperty("pcgen.files.portraits", SettingsHandler.retractRelativePath(SettingsHandler.getPortraitsPath().getAbsolutePath()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedSpellOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedSpellSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterHTMLOutputSheet(aPC)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterPDFOutputSheet(aPC)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyHTMLOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyPDFOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedEqSetTemplate", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedEqSetTemplate()));
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", StringUtil.join(PersistenceManager.getInstance().getChosenCampaignSourcefiles(), (String)", "));
        SettingsHandler.getOptions().setProperty("pcgen.options.custColumnWidth", StringUtil.join(Globals.getCustColumnWidth(), (String)", "));
        if (SettingsHandler.getGmgenPluginDir() != null) {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", SettingsHandler.retractRelativePath(SettingsHandler.getGmgenPluginDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", "");
        }
        if (SettingsHandler.getBrowserPath() != null) {
            SettingsHandler.setPCGenOption("browserPath", SettingsHandler.getBrowserPath());
        } else {
            SettingsHandler.setPCGenOption("browserPath", "");
        }
        if (SettingsHandler.getGame() != null) {
            SettingsHandler.setPCGenOption("game", SettingsHandler.getGame().getName());
        } else {
            SettingsHandler.setPCGenOption("game", "");
        }
        try {
            SettingsHandler.setPCGenOption("skinLFThemePack", SettingsHandler.getSkinLFThemePack());
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (SettingsHandler.getPccFilesLocation() != null) {
            SettingsHandler.setPCGenOption("pccFilesLocation", SettingsHandler.retractRelativePath(SettingsHandler.getPccFilesLocation().getAbsolutePath()));
        } else {
            SettingsHandler.setPCGenOption("pccFilesLocation", "");
        }
        if (SettingsHandler.getLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.X", SettingsHandler.getLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.Y", SettingsHandler.getLeftUpperCorner().getY());
        }
        SettingsHandler.setPCGenOption("windowState", SettingsHandler.getWindowState());
        if (Globals.getRootFrame() != null) {
            SettingsHandler.setPCGenOption("windowWidth", Globals.getRootFrame().getSize().getWidth());
            SettingsHandler.setPCGenOption("windowHeight", Globals.getRootFrame().getSize().getHeight());
        }
        if (SettingsHandler.getCustomizerLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.X", SettingsHandler.getCustomizerLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.Y", SettingsHandler.getCustomizerLeftUpperCorner().getY());
        }
        if (SettingsHandler.getCustomizerDimension() != null) {
            SettingsHandler.setPCGenOption("customizer.windowWidth", SettingsHandler.getCustomizerDimension().getWidth());
            SettingsHandler.setPCGenOption("customizer.windowHeight", SettingsHandler.getCustomizerDimension().getHeight());
        }
        if (SettingsHandler.getKitSelectorLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("kitSelector.windowLeftUpperCorner.X", SettingsHandler.getKitSelectorLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("kitSelector.windowLeftUpperCorner.Y", SettingsHandler.getKitSelectorLeftUpperCorner().getY());
        }
        if (SettingsHandler.getKitSelectorDimension() != null) {
            SettingsHandler.setPCGenOption("kitSelector.windowWidth", SettingsHandler.getKitSelectorDimension().getWidth());
            SettingsHandler.setPCGenOption("kitSelector.windowHeight", SettingsHandler.getKitSelectorDimension().getHeight());
        }
        SettingsHandler.setPCGenOption("allStatsValue", null);
        SettingsHandler.setPCGenOption("purchaseMethodName", null);
        SettingsHandler.setPCGenOption("rollMethod", null);
        SettingsHandler.setPCGenOption("rollMethodExpression", null);
        for (int idx = 0; idx < SystemCollections.getUnmodifiableGameModeList().size(); ++idx) {
            GameMode gameMode = SystemCollections.getUnmodifiableGameModeList().get(idx);
            String gameModeKey = gameMode.getName();
            if (gameMode.getUnitSet() != null && gameMode.getUnitSet().getDisplayName() != null) {
                SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".unitSetName", gameMode.getUnitSet().getDisplayName());
            }
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".purchaseMethodName", gameMode.getPurchaseModeMethodName());
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".rollMethod", gameMode.getRollMethod());
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".rollMethodExpression", gameMode.getRollMethodExpressionName());
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".allStatsValue", gameMode.getAllStatsValue());
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".xpTableName", gameMode.getDefaultXPTableName());
            SettingsHandler.setPCGenOption("gameMode." + gameModeKey + ".characterType", gameMode.getDefaultCharacterType());
        }
        SettingsHandler.setRuleChecksInOptions("ruleChecks");
        SettingsHandler.setPCGenOption("allowMetamagicInCustomizer", SettingsHandler.isMetamagicAllowedInEqBuilder());
        SettingsHandler.setPCGenOption("alwaysOverwrite", SettingsHandler.getAlwaysOverwrite());
        SettingsHandler.setPCGenOption("autoFeatsRefundable", SettingsHandler.isAutoFeatsRefundable());
        SettingsHandler.setPCGenOption("autoGenerateExoticMaterial", SettingsHandler.isAutogenExoticMaterial());
        SettingsHandler.setPCGenOption("autoGenerateMagic", SettingsHandler.isAutogenMagic());
        SettingsHandler.setPCGenOption("autoGenerateMasterwork", SettingsHandler.isAutogenMasterwork());
        SettingsHandler.setPCGenOption("autoGenerateRacial", SettingsHandler.isAutogenRacial());
        SettingsHandler.setPCGenOption("chaTabPlacement", SettingsHandler.convertTabPlacementToString(chaTabPlacement));
        SettingsHandler.setPCGenOption("createPcgBackup", SettingsHandler.getCreatePcgBackup());
        SettingsHandler.setPCGenOption("customizer.split1", SettingsHandler.getCustomizerSplit1());
        SettingsHandler.setPCGenOption("customizer.split2", SettingsHandler.getCustomizerSplit2());
        SettingsHandler.setPCGenOption("defaultOSType", SettingsHandler.getDefaultOSType());
        SettingsHandler.setPCGenOption("GearTab.allowDebt", SettingsHandler.getGearTab_AllowDebt());
        SettingsHandler.setPCGenOption("GearTab.autoResize", SettingsHandler.getGearTab_AutoResize());
        SettingsHandler.setPCGenOption("GearTab.buyRate", SettingsHandler.getGearTab_BuyRate());
        SettingsHandler.setPCGenOption("GearTab.ignoreCost", SettingsHandler.getGearTab_IgnoreCost());
        SettingsHandler.setPCGenOption("GearTab.sellRate", SettingsHandler.getGearTab_SellRate());
        SettingsHandler.setPCGenOption("grimHPMode", SettingsHandler.isGrimHPMode());
        SettingsHandler.setPCGenOption("grittyACMode", SettingsHandler.isGrittyACMode());
        SettingsHandler.setPCGenOption("GUIUsesOutputNameEquipment", SettingsHandler.guiUsesOutputNameEquipment());
        SettingsHandler.setPCGenOption("GUIUsesOutputNameSpells", SettingsHandler.guiUsesOutputNameSpells());
        SettingsHandler.setPCGenOption("hideMonsterClasses", SettingsHandler.hideMonsterClasses());
        SettingsHandler.setPCGenOption("hpMaxAtFirstLevel", SettingsHandler.isHPMaxAtFirstLevel());
        SettingsHandler.setPCGenOption("hpMaxAtFirstClassLevel", SettingsHandler.isHPMaxAtFirstClassLevel());
        SettingsHandler.setPCGenOption("hpMaxAtFirstPCClassLevelOnly", SettingsHandler.isHPMaxAtFirstPCClassLevelOnly());
        SettingsHandler.setPCGenOption("hpPercent", SettingsHandler.getHPPercent());
        SettingsHandler.setPCGenOption("hpRollMethod", SettingsHandler.getHPRollMethod());
        SettingsHandler.setPCGenOption("ignoreMonsterHDCap", SettingsHandler.isIgnoreMonsterHDCap());
        SettingsHandler.setPCGenOption("invalidDmgText", SettingsHandler.getInvalidDmgText());
        SettingsHandler.setPCGenOption("invalidToHitText", SettingsHandler.getInvalidToHitText());
        SettingsHandler.setPCGenOption("lastTipOfTheDayTipShown", SettingsHandler.getLastTipShown());
        SettingsHandler.setPCGenOption("loadMasterworkAndMagicFromLst", SettingsHandler.wantToLoadMasterworkAndMagic());
        SettingsHandler.setPCGenOption("loadURLs", loadURLs);
        SettingsHandler.setPCGenOption("looknFeel", SettingsHandler.getLookAndFeel());
        SettingsHandler.setPCGenOption("maxPotionSpellLevel", SettingsHandler.getMaxPotionSpellLevel());
        SettingsHandler.setPCGenOption("maxWandSpellLevel", SettingsHandler.getMaxWandSpellLevel());
        SettingsHandler.setPCGenOption("nameDisplayStyle", SettingsHandler.getNameDisplayStyle());
        SettingsHandler.setPCGenOption("postExportCommandStandard", SettingsHandler.getPostExportCommandStandard());
        SettingsHandler.setPCGenOption("postExportCommandPDF", SettingsHandler.getPostExportCommandPDF());
        SettingsHandler.setPCGenOption("prereqFailColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqFailColor()));
        SettingsHandler.setPCGenOption("prereqQualifyColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqQualifyColor()));
        SettingsHandler.setPCGenOption("previewTabShown", SettingsHandler.isPreviewTabShown());
        SettingsHandler.setPCGenOption("saveCustomInLst", SettingsHandler.isSaveCustomInLst());
        SettingsHandler.setPCGenOption("saveOutputSheetWithPC", SettingsHandler.getSaveOutputSheetWithPC());
        SettingsHandler.setPCGenOption("printSpellsWithPC", SettingsHandler.getPrintSpellsWithPC());
        SettingsHandler.setPCGenOption("showFeatDialogAtLevelUp", SettingsHandler.getShowFeatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("enforceSpendingBeforeLevelUp", SettingsHandler.getEnforceSpendingBeforeLevelUp());
        SettingsHandler.setPCGenOption("showHPDialogAtLevelUp", SettingsHandler.getShowHPDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showMemoryArea", SettingsHandler.isShowMemoryArea());
        SettingsHandler.setPCGenOption("showImagePreview", SettingsHandler.isShowImagePreview());
        SettingsHandler.setPCGenOption("showStatDialogAtLevelUp", SettingsHandler.getShowStatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showTipOfTheDay", SettingsHandler.getShowTipOfTheDay());
        SettingsHandler.setPCGenOption("showToolBar", SettingsHandler.isShowToolBar());
        SettingsHandler.setPCGenOption("showSkillModifier", SettingsHandler.getShowSkillModifier());
        SettingsHandler.setPCGenOption("showSkillRanks", SettingsHandler.getShowSkillRanks());
        SettingsHandler.setPCGenOption("showSingleBoxPerBundle", SettingsHandler.getShowSingleBoxPerBundle());
        SettingsHandler.setPCGenOption("showWarningAtFirstLevelUp", SettingsHandler.isShowWarningAtFirstLevelUp());
        SettingsHandler.setPCGenOption("sourceDisplay", Globals.getSourceDisplay().ordinal());
        SettingsHandler.setPCGenOption("spellMarketPriceAdjusted", SettingsHandler.isSpellMarketPriceAdjusted());
        SettingsHandler.setPCGenOption("tabPlacement", SettingsHandler.convertTabPlacementToString(tabPlacement));
        SettingsHandler.setPCGenOption("useHigherLevelSlotsDefault", SettingsHandler.isUseHigherLevelSlotsDefault());
        SettingsHandler.setPCGenOption("useWaitCursor", SettingsHandler.getUseWaitCursor());
        SettingsHandler.setPCGenOption("validateBonuses", validateBonuses);
        SettingsHandler.setPCGenOption("weaponProfPrintout", SettingsHandler.getWeaponProfPrintout());
        SettingsHandler.setPCGenOption("outputDeprecationMessages", SettingsHandler.outputDeprecationMessages());
        SettingsHandler.setPCGenOption("inputUnconstructedMessages", SettingsHandler.inputUnconstructedMessages());
    }

    public static void setPCGenOption(String optionName, int optionValue) {
        SettingsHandler.setPCGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setPCGenOption(String optionName, String optionValue) {
        if (optionValue == null) {
            SettingsHandler.getOptions().remove("pcgen.options." + optionName);
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.options." + optionName, optionValue);
        }
    }

    public static int getPCGenOption(String optionName, int defaultValue) {
        return Integer.decode(SettingsHandler.getPCGenOption(optionName, String.valueOf(defaultValue)));
    }

    public static String getPCGenOption(String optionName, String defaultValue) {
        return SettingsHandler.getOptions().getProperty("pcgen.options." + optionName, defaultValue);
    }

    public static boolean hasPCGenOption(String optionName) {
        return SettingsHandler.getOptions().containsKey("pcgen.options." + optionName);
    }

    public static String getPDFOutputSheetPath() {
        if ("".equals(selectedCharacterPDFOutputSheet)) {
            return ConfigurationSettings.getOutputSheetsDir();
        }
        return new File(selectedCharacterPDFOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setPccFilesLocation(File argPccFilesLocation) {
        pccFilesLocation = argPccFilesLocation;
    }

    public static File getPccFilesLocation() {
        return pccFilesLocation;
    }

    public static void ensurePathExists(File path) {
        if (path != null && !path.exists()) {
            path.mkdirs();
        }
    }

    public static void setLastUsedPcgPath(File path) {
        if (path != null && !path.exists()) {
            path.mkdirs();
        }
        lastUsedPcgPath = path;
    }

    public static File getLastUsedPcgPath() {
        if (lastUsedPcgPath == null) {
            return pcgPath;
        }
        return lastUsedPcgPath;
    }

    public static void setPcgenSponsorDir(File aFile) {
        pcgenSponsorDir = aFile;
    }

    public static File getPcgenSponsorDir() {
        return pcgenSponsorDir;
    }

    public static void setPcgenOutputSheetDir(File aFile) {
        pcgenOutputSheetDir = aFile;
    }

    public static void setPcgenPreviewDir(File aFile) {
        pcgenPreviewDir = aFile;
    }

    public static void setPortraitsPath(File path) {
        portraitsPath = path;
    }

    public static File getPortraitsPath() {
        return portraitsPath;
    }

    public static void setPostExportCommandStandard(String argPreference) {
        postExportCommandStandard = argPreference;
    }

    public static void setPostExportCommandPDF(String argPreference) {
        postExportCommandPDF = argPreference;
    }

    public static String getPostExportCommandStandard() {
        return postExportCommandStandard;
    }

    public static String getPostExportCommandPDF() {
        return postExportCommandPDF;
    }

    public static void setPrereqFailColor(int newColor) {
        prereqFailColor = newColor & 0xFFFFFF;
    }

    public static int getPrereqFailColor() {
        return prereqFailColor;
    }

    public static String getPrereqFailColorAsHtmlStart() {
        StringBuilder rString = new StringBuilder("<font color=");
        if (SettingsHandler.getPrereqFailColor() != 0) {
            rString.append("\"#").append(Integer.toHexString(SettingsHandler.getPrereqFailColor())).append("\"");
        } else {
            rString.append("red");
        }
        rString.append('>');
        return rString.toString();
    }

    public static String getPrereqFailColorAsHtmlEnd() {
        return "</font>";
    }

    public static void setPrereqQualifyColor(int newColor) {
        prereqQualifyColor = newColor & 0xFFFFFF;
    }

    public static int getPrereqQualifyColor() {
        return prereqQualifyColor;
    }

    public static void setPrintSpellsWithPC(boolean arg) {
        printSpellsWithPC = arg;
    }

    public static boolean getPrintSpellsWithPC() {
        return printSpellsWithPC;
    }

    public static boolean isROG() {
        return isROG;
    }

    public static void setRuleCheck(String aKey, boolean aBool) {
        String aVal = "N";
        if (aBool) {
            aVal = "Y";
        }
        ruleCheckMap.put(aKey, aVal);
    }

    public static boolean getRuleCheck(String aKey) {
        String aVal;
        return ruleCheckMap.containsKey(aKey) && (aVal = ruleCheckMap.get(aKey)).equals("Y");
    }

    public static void setSaveCustomEquipment(boolean aBool) {
        SettingsHandler.setSaveCustomInLst(aBool);
    }

    public static void setSaveOutputSheetWithPC(boolean arg) {
        saveOutputSheetWithPC = arg;
    }

    public static boolean getSaveOutputSheetWithPC() {
        return saveOutputSheetWithPC;
    }

    public static void setSelectedCharacterHTMLOutputSheet(String path, PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null) {
            aPC.setSelectedCharacterHTMLOutputSheet(path);
        }
        selectedCharacterHTMLOutputSheet = path;
    }

    public static String getSelectedCharacterHTMLOutputSheet(PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null && aPC.getSelectedCharacterHTMLOutputSheet().length() > 0) {
            return aPC.getSelectedCharacterHTMLOutputSheet();
        }
        return selectedCharacterHTMLOutputSheet;
    }

    public static void setSelectedCharacterPDFOutputSheet(String path, PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null) {
            aPC.setSelectedCharacterPDFOutputSheet(path);
        }
        selectedCharacterPDFOutputSheet = path;
    }

    public static String getSelectedCharacterPDFOutputSheet(PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null && aPC.getSelectedCharacterPDFOutputSheet().length() > 0) {
            return aPC.getSelectedCharacterPDFOutputSheet();
        }
        return selectedCharacterPDFOutputSheet;
    }

    public static void setSelectedEqSetTemplate(String path) {
        selectedEqSetTemplate = path;
    }

    public static String getSelectedEqSetTemplate() {
        return selectedEqSetTemplate;
    }

    public static String getSelectedEqSetTemplateName() {
        if (selectedEqSetTemplate.length() > 0) {
            int i = selectedEqSetTemplate.lastIndexOf("\\");
            return selectedEqSetTemplate.substring(i + 1);
        }
        return selectedEqSetTemplate;
    }

    public static void setSelectedPartyHTMLOutputSheet(String path) {
        selectedPartyHTMLOutputSheet = path;
    }

    public static String getSelectedPartyHTMLOutputSheet() {
        return selectedPartyHTMLOutputSheet;
    }

    public static void setSelectedPartyPDFOutputSheet(String path) {
        selectedPartyPDFOutputSheet = path;
    }

    public static String getSelectedPartyPDFOutputSheet() {
        return selectedPartyPDFOutputSheet;
    }

    public static void setSelectedSpellSheet(String path) {
        selectedSpellSheet = path;
    }

    public static String getSelectedSpellSheet() {
        return selectedSpellSheet;
    }

    public static String getSelectedSpellSheetName() {
        if (selectedSpellSheet.length() > 0) {
            int i = selectedSpellSheet.lastIndexOf("\\");
            return selectedSpellSheet.substring(i + 1);
        }
        return selectedSpellSheet;
    }

    public static void setShowFeatDialogAtLevelUp(boolean argShowFeatDialogAtLevelUp) {
        showFeatDialogAtLevelUp = true;
    }

    public static boolean getShowFeatDialogAtLevelUp() {
        return showFeatDialogAtLevelUp;
    }

    public static void setShowHPDialogAtLevelUp(boolean argShowHPDialogAtLevelUp) {
        showHPDialogAtLevelUp = argShowHPDialogAtLevelUp;
    }

    public static boolean getShowHPDialogAtLevelUp() {
        return showHPDialogAtLevelUp;
    }

    public static void setShowStatDialogAtLevelUp(boolean argShowStatDialogAtLevelUp) {
        showStatDialogAtLevelUp = argShowStatDialogAtLevelUp;
    }

    public static boolean getShowStatDialogAtLevelUp() {
        return showStatDialogAtLevelUp;
    }

    public static void setShowTipOfTheDay(boolean argShowTipOfTheDay) {
        showTipOfTheDay = argShowTipOfTheDay;
    }

    public static boolean getShowTipOfTheDay() {
        return showTipOfTheDay;
    }

    public static void setShowWarningAtFirstLevelUp(boolean argShowWarningAtFirstLevelUp) {
        showWarningAtFirstLevelUp = argShowWarningAtFirstLevelUp;
    }

    public static boolean isShowWarningAtFirstLevelUp() {
        return showWarningAtFirstLevelUp;
    }

    public static void setSkinLFThemePack(String argSkinLFThemePack) {
        skinLFThemePack = argSkinLFThemePack;
    }

    public static String getSkinLFThemePack() {
        return skinLFThemePack;
    }

    public static void setTabPlacement(int anInt) {
        tabPlacement = anInt;
    }

    public static int getTabPlacement() {
        return tabPlacement;
    }

    public static File getTempPath() {
        return tempPath;
    }

    public static void setToolBarShown(boolean argShowToolBar) {
        SettingsHandler.setShowToolBar(argShowToolBar);
    }

    public static boolean isToolBarShown() {
        return SettingsHandler.isShowToolBar();
    }

    public static boolean isUseHigherLevelSlotsDefault() {
        return useHigherLevelSlotsDefault;
    }

    public static void setUseHigherLevelSlotsDefault(boolean useHigherLevelSlotsDefault) {
        SettingsHandler.useHigherLevelSlotsDefault = useHigherLevelSlotsDefault;
    }

    public static void setUseWaitCursor(boolean b) {
        useWaitCursor = b;
    }

    public static boolean getUseWaitCursor() {
        return useWaitCursor;
    }

    public static void setWantToLoadMasterworkAndMagic(boolean bFlag) {
        wantToLoadMasterworkAndMagic = bFlag;
    }

    public static void setWeaponProfPrintout(boolean argPreference) {
        weaponProfPrintout = argPreference;
    }

    public static boolean getWeaponProfPrintout() {
        return weaponProfPrintout;
    }

    public static boolean guiUsesOutputNameEquipment() {
        return guiUsesOutputNameEquipment;
    }

    public static boolean guiUsesOutputNameSpells() {
        return guiUsesOutputNameSpells;
    }

    public static boolean hasRuleCheck(String aKey) {
        return ruleCheckMap.containsKey(aKey);
    }

    public static boolean hideMonsterClasses() {
        return hideMonsterClasses;
    }

    public static void readGUIOptionsProperties() {
        SettingsHandler.setNameDisplayStyle(SettingsHandler.getPCGenOption("nameDisplayStyle", 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readOptionsProperties() {
        SettingsHandler.readFilePaths();
        SettingsHandler.readFilterSettings();
        String optionsLocation = Globals.getOptionsPath();
        FileInputStream in = null;
        try {
            in = new FileInputStream(optionsLocation);
            SettingsHandler.getOptions().load(in);
        }
        catch (IOException e) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint(LanguageBundle.getString("SettingsHandler.no.options.file"));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.options.file"), ex);
            }
        }
    }

    public static String retrieveFilterSettings(String optionName) {
        return SettingsHandler.getFilterSettings().getProperty("pcgen.filters." + optionName, SettingsHandler.getOptions().getProperty("pcgen.filters." + optionName, ""));
    }

    public static boolean wantToLoadMasterworkAndMagic() {
        return wantToLoadMasterworkAndMagic;
    }

    private static String getPropertiesFileHeader(String description) {
        return "# Emacs, this is -*- java-properties-generic -*- mode." + Constants.LINE_SEPARATOR + "#" + Constants.LINE_SEPARATOR + description + Constants.LINE_SEPARATOR + "# Do not edit this file manually." + Constants.LINE_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilePaths() {
        String notDir;
        File aFile;
        String aLoc;
        String fType = SettingsHandler.getFilePaths();
        String header = SettingsHandler.getPropertiesFileHeader("# filepaths.ini -- location of other .ini files set in pcgen");
        if (!(fType.equals("pcgen") || fType.equals("user") || fType.equals("mac_user") || fType == null)) {
            SettingsHandler.setFilePaths(fType);
        }
        if (fType.equals("user")) {
            aLoc = System.getProperty("user.home") + File.separator + ".pcgen";
            aFile = new File(aLoc);
            if (!aFile.exists()) {
                aFile.mkdir();
                Logging.errorPrint(LanguageBundle.getFormattedString("SettingsHandler.dir.does.not.exist", aLoc));
            } else if (!aFile.isDirectory()) {
                notDir = LanguageBundle.getFormattedString("SettingsHandler.is.not.a.directory", aLoc);
                ShowMessageDelegate.showMessageDialog(notDir, "PCGen", MessageType.ERROR);
            }
        }
        if (fType.equals("mac_user")) {
            aLoc = Globals.defaultMacOptionsPath;
            aFile = new File(aLoc);
            if (!aFile.exists()) {
                aFile.mkdir();
                Logging.errorPrint(LanguageBundle.getFormattedString("SettingsHandler.dir.does.not.exist", aLoc));
            } else if (!aFile.isDirectory()) {
                notDir = LanguageBundle.getFormattedString("SettingsHandler.is.not.a.directory", aLoc);
                ShowMessageDelegate.showMessageDialog(notDir, "PCGen", MessageType.ERROR);
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileLocation);
            SettingsHandler.getFilepathProp().store(out, header);
        }
        catch (FileNotFoundException fnfe) {
            File f = new File(fileLocation);
            if (!f.canWrite()) {
                Logging.errorPrint(LanguageBundle.getFormattedString("SettingsHandler.filepaths.readonly", fileLocation));
            } else {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.filepaths.write"), fnfe);
            }
        }
        catch (IOException e) {
            Logging.errorPrint(LanguageBundle.getString("SettingsHandler.filepaths.write"), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.filepaths.ini.write"), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOptionsProperties(PlayerCharacter aPC) {
        SettingsHandler.writeFilePaths();
        SettingsHandler.writeFilterSettings();
        String optionsLocation = Globals.getOptionsPath();
        String header = SettingsHandler.getPropertiesFileHeader("# options.ini -- options set in pcgen");
        SettingsHandler.setOptionsProperties(aPC);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(optionsLocation);
            SettingsHandler.getOptions().mystore(out, header);
        }
        catch (FileNotFoundException fnfe) {
            File f = new File(fileLocation);
            if (!f.canWrite()) {
                Logging.errorPrint(LanguageBundle.getFormattedString("SettingsHandler.options.ini.read.only", optionsLocation));
            } else {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.write.options.ini"), fnfe);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.options.ini.write"), ex);
            }
        }
    }

    static boolean isAutogenExoticMaterial() {
        return autogenExoticMaterial;
    }

    static boolean isAutogenMagic() {
        return autogenMagic;
    }

    static boolean isAutogenMasterwork() {
        return autogenMasterwork;
    }

    static boolean isAutogenRacial() {
        return autogenRacial;
    }

    static void setPreviewTabShown(boolean showPreviewTab) {
        previewTabShown = showPreviewTab;
    }

    static boolean isPreviewTabShown() {
        return previewTabShown;
    }

    private static void setAutoFeatsRefundable(boolean argAutoFeatsRefundable) {
        autoFeatsRefundable = argAutoFeatsRefundable;
    }

    private static boolean isAutoFeatsRefundable() {
        return autoFeatsRefundable;
    }

    private static void setAutogenExoticMaterial(boolean aBool) {
        autogenExoticMaterial = aBool;
    }

    private static void setAutogenMagic(boolean aBool) {
        autogenMagic = aBool;
    }

    private static void setAutogenMasterwork(boolean aBool) {
        autogenMasterwork = aBool;
    }

    private static void setAutogenRacial(boolean aBool) {
        autogenRacial = aBool;
    }

    private static Properties getFilterSettings() {
        return FILTERSETTINGS;
    }

    private static void setGrimHPMode(boolean argGrimHPMode) {
        grimHPMode = argGrimHPMode;
    }

    private static boolean isGrimHPMode() {
        return grimHPMode;
    }

    private static void setGrittyACMode(boolean aBool) {
        grittyACMode = aBool;
    }

    private static boolean isGrittyACMode() {
        return grittyACMode;
    }

    private static int getOptionTabPlacement(String optionName, int defaultValue) {
        int iVal;
        String aString = SettingsHandler.getPCGenOption(optionName, SettingsHandler.convertTabPlacementToString(defaultValue));
        try {
            iVal = Integer.parseInt(aString);
            switch (iVal) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    iVal = defaultValue;
                    break;
                }
            }
        }
        catch (NumberFormatException exc) {
            iVal = "TOP".equals(aString) ? 1 : ("LEFT".equals(aString) ? 2 : ("BOTTOM".equals(aString) ? 3 : ("RIGHT".equals(aString) ? 4 : defaultValue)));
        }
        return iVal;
    }

    public static void setPCGenOption(String optionName, boolean optionValue) {
        SettingsHandler.setPCGenOption(optionName, optionValue ? "true" : "false");
    }

    public static void setPCGenOption(String optionName, double optionValue) {
        SettingsHandler.setPCGenOption(optionName, String.valueOf(optionValue));
    }

    public static boolean getPCGenOption(String optionName, boolean defaultValue) {
        String option = SettingsHandler.getPCGenOption(optionName, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(option);
    }

    private static Double getPCGenOption(String optionName, double defaultValue) {
        return new Double(SettingsHandler.getPCGenOption(optionName, Double.toString(defaultValue)));
    }

    private static void setROG(boolean ROG) {
        isROG = ROG;
    }

    private static void setRuleChecksInOptions(String optionName) {
        String value = "";
        for (String aKey : ruleCheckMap.keySet()) {
            String aVal = ruleCheckMap.get(aKey);
            if (value.length() == 0) {
                value = aKey + "|" + aVal;
                continue;
            }
            value = value + "," + aKey + "|" + aVal;
        }
        SettingsHandler.getOptions().setProperty("pcgen.options." + optionName, value);
    }

    private static void setSaveCustomInLst(boolean aBool) {
        saveCustomInLst = aBool;
    }

    private static boolean isSaveCustomInLst() {
        return saveCustomInLst;
    }

    private static void setShowToolBar(boolean argShowToolBar) {
        showToolBar = argShowToolBar;
    }

    private static boolean isShowToolBar() {
        return showToolBar;
    }

    public static void setShowSkillModifier(boolean argShowSkillMod) {
        showSkillModifier = argShowSkillMod;
    }

    public static boolean getShowSkillModifier() {
        return showSkillModifier;
    }

    public static void setShowSkillRanks(boolean argShowSkillRanks) {
        showSkillRanks = argShowSkillRanks;
    }

    public static boolean getShowSkillRanks() {
        return showSkillRanks;
    }

    private static void setSpellMarketPriceAdjusted(boolean aBool) {
        spellMarketPriceAdjusted = aBool;
    }

    private static boolean isSpellMarketPriceAdjusted() {
        return spellMarketPriceAdjusted;
    }

    private static String getTmpPath() {
        return tmpPath;
    }

    private static String convertTabPlacementToString(int placement) {
        switch (placement) {
            case 3: {
                return "BOTTOM";
            }
            case 2: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
        }
        return "TOP";
    }

    private static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = System.getProperty("user.dir") + path.substring(1);
        }
        return path;
    }

    private static void parseRuleChecksFromOptions(String aString) {
        if (aString.length() <= 0) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            String bs = aTok.nextToken();
            StringTokenizer bTok = new StringTokenizer(bs, "|");
            String aKey = bTok.nextToken();
            String aVal = bTok.nextToken();
            ruleCheckMap.put(aKey, aVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFilePaths() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileLocation);
            SettingsHandler.getFilepathProp().load(in);
            String fType = SettingsHandler.getFilePaths();
            if (fType == null || fType.length() < 1) {
                fType = Globals.isMacPlatform ? "mac_user" : "user";
            }
        }
        catch (IOException e) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint(LanguageBundle.getString("SettingsHandler.will.create.filepaths.ini"));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.filepaths.ini"), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFilterSettings() {
        String filterLocation = Globals.getFilterPath();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filterLocation);
            SettingsHandler.getFilterSettings().load(in);
        }
        catch (IOException e) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint(LanguageBundle.getString("SettingsHandler.will.create.filter.ini"));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.filter.ini"), ex);
            }
        }
    }

    private static String retractRelativePath(String path) {
        File userDir = new File(System.getProperty("user.dir"));
        if (path.startsWith(userDir.getAbsolutePath())) {
            path = "@" + path.substring(userDir.getAbsolutePath().length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFilterSettings() {
        String filterLocation = Globals.getFilterPath();
        String header = SettingsHandler.getPropertiesFileHeader("# filter.ini -- filters set in pcgen");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filterLocation);
            SettingsHandler.getFilterSettings().store(out, header);
        }
        catch (FileNotFoundException fnfe) {
            File f = new File(fileLocation);
            if (!f.canWrite()) {
                Logging.errorPrint(LanguageBundle.getFormattedString("SettingsHandler.filter.ini.readonly", filterLocation));
            } else {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.write.filter.ini"), fnfe);
            }
        }
        catch (IOException e) {
            Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.write.filter.ini"), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint(LanguageBundle.getString("SettingsHandler.can.not.close.filter.ini.write"), ex);
            }
        }
        Iterator<Object> it = SettingsHandler.getOptions().keySet().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).startsWith("pcgen.filters.")) continue;
            it.remove();
        }
    }

    public static int getWindowState() {
        return windowState;
    }

    public static void setWindowState(int argWindowState) {
        windowState = argWindowState;
    }

    public static boolean isShowMemoryArea() {
        return showMemoryArea;
    }

    public static boolean isShowImagePreview() {
        return showImagePreview;
    }

    public static void setShowImagePreview(boolean showImagePreview) {
        SettingsHandler.showImagePreview = showImagePreview;
    }

    public static boolean getShowSingleBoxPerBundle() {
        return showSingleBoxPerBundle;
    }

    public static void setShowSingleBoxPerBundle(boolean b) {
        showSingleBoxPerBundle = b;
    }

    public static boolean outputDeprecationMessages() {
        return outputDeprecationMessages;
    }

    public static void setOutputDeprecationMessages(boolean b) {
        outputDeprecationMessages = b;
    }

    public static boolean inputUnconstructedMessages() {
        return inputUnconstructedMessages;
    }

    public static void setInputUnconstructedMessages(boolean b) {
        inputUnconstructedMessages = b;
    }

    static {
        gearTab_IgnoreCost = false;
        gearTab_AutoResize = false;
        gearTab_AllowDebt = false;
        gearTab_SellRate = 50;
        gearTab_BuyRate = 100;
        isROG = false;
        leftUpperCorner = null;
        windowState = 0;
        looknFeel = 1;
        options = new SortedProperties();
        filepaths = new Properties();
        fileLocation = Globals.getFilepathsPath();
        pccFilesLocation = null;
        pcgPath = new File(Globals.getDefaultPath());
        lastUsedPcgPath = null;
        backupPcgPath = null;
        createPcgBackup = true;
        portraitsPath = new File(Globals.getDefaultPath());
        pcgenSponsorDir = new File(Globals.getDefaultPath() + File.separator + "system" + File.separator + "sponsors");
        pcgenOutputSheetDir = new File(Globals.getDefaultPath() + File.separator + "outputsheets");
        gmgenPluginDir = new File(Globals.getDefaultPath() + File.separator + "plugins");
        prereqQualifyColor = 0;
        prereqFailColor = 0xFF0000;
        previewTabShown = false;
        pcgenPreviewDir = new File(Globals.getDefaultPath() + File.separator + "preview");
        saveCustomInLst = false;
        selectedCharacterHTMLOutputSheet = "";
        selectedCharacterPDFOutputSheet = "";
        saveOutputSheetWithPC = false;
        printSpellsWithPC = true;
        selectedPartyHTMLOutputSheet = "";
        selectedPartyPDFOutputSheet = "";
        selectedEqSetTemplate = "";
        selectedSpellSheet = "";
        showFeatDialogAtLevelUp = true;
        showHPDialogAtLevelUp = true;
        showStatDialogAtLevelUp = true;
        showToolBar = true;
        showSkillModifier = false;
        showSkillRanks = false;
        showWarningAtFirstLevelUp = true;
        skinLFThemePack = null;
        alwaysOverwrite = false;
        defaultOSType = "";
        tabPlacement = 3;
        tmpPath = System.getProperty("java.io.tmpdir");
        tempPath = new File(SettingsHandler.getTmpPath());
        useHigherLevelSlotsDefault = false;
        wantToLoadMasterworkAndMagic = false;
        nameDisplayStyle = 0;
        weaponProfPrintout = true;
        postExportCommandStandard = "";
        postExportCommandPDF = "";
        hideMonsterClasses = false;
        guiUsesOutputNameEquipment = false;
        guiUsesOutputNameSpells = false;
        lastTipShown = -1;
        showMemoryArea = false;
        showImagePreview = true;
        showTipOfTheDay = true;
        isGMGen = false;
        showSingleBoxPerBundle = false;
        outputDeprecationMessages = true;
        inputUnconstructedMessages = true;
    }
}

