/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.BodyStructure;
import pcgen.core.Deity;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.GearBuySellScheme;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSlot;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.AlignmentFacade;
import pcgen.facade.core.BodyStructureFacade;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.GearBuySellFacade;
import pcgen.facade.core.KitFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SizeAdjustmentFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.core.TemplateFacade;
import pcgen.facade.core.generator.StatGenerationFacade;
import pcgen.facade.util.AbstractMapFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.MapFacade;
import pcgen.rules.context.LoadContext;
import pcgen.util.enumeration.View;

public class DataSet
implements DataSetFacade {
    private DefaultListFacade<RaceFacade> races = new DefaultListFacade();
    private DefaultListFacade<ClassFacade> classes = new DefaultListFacade();
    private DefaultListFacade<DeityFacade> deities = new DefaultListFacade();
    private DefaultListFacade<SkillFacade> skills = new DefaultListFacade();
    private DefaultListFacade<TemplateFacade> templates = new DefaultListFacade();
    private DefaultListFacade<AlignmentFacade> alignments = new DefaultListFacade();
    private DefaultListFacade<KitFacade> kits;
    private DefaultListFacade<StatFacade> stats = new DefaultListFacade();
    private AbilityMap abilityMap = new AbilityMap();
    private final LoadContext context;
    private final GameMode gameMode;
    private final ListFacade<CampaignFacade> campaigns;
    private SkillFacade speakLanguageSkill = null;
    private DefaultListFacade<BodyStructureFacade> bodyStructures = new DefaultListFacade();
    private DefaultListFacade<EquipmentFacade> equipment = new DefaultListFacade();
    private DefaultListFacade<String> xpTableNames = new DefaultListFacade();
    private DefaultListFacade<GearBuySellFacade> gearBuySellSchemes;
    private DefaultListFacade<String> characterTypes = new DefaultListFacade();
    private DefaultListFacade<SizeAdjustmentFacade> sizes;

    public DataSet(LoadContext context, GameMode gameMode, ListFacade<CampaignFacade> campaigns) {
        this.kits = new DefaultListFacade();
        this.sizes = new DefaultListFacade();
        this.context = context;
        this.gameMode = gameMode;
        this.campaigns = campaigns;
        this.initLists();
    }

    private void initLists() {
        ArrayList<Race> raceList = new ArrayList<Race>(this.context.getReferenceContext().getConstructedCDOMObjects(Race.class));
        Collections.sort(raceList, new RaceComparator());
        for (Race race : raceList) {
            if (!race.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            this.races.addElement(race);
        }
        ArrayList<PCClass> classList = new ArrayList<PCClass>(this.context.getReferenceContext().getConstructedCDOMObjects(PCClass.class));
        Collections.sort(classList, new PCClassComparator());
        for (PCClass pcClass : classList) {
            if (!pcClass.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            this.classes.addElement(pcClass);
        }
        for (Skill skill : this.context.getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
            if (!skill.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            this.skills.addElement(skill);
        }
        for (Deity deity : this.context.getReferenceContext().getConstructedCDOMObjects(Deity.class)) {
            this.deities.addElement(deity);
        }
        for (PCTemplate template : this.context.getReferenceContext().getConstructedCDOMObjects(PCTemplate.class)) {
            if (!template.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            this.templates.addElement(template);
        }
        for (Kit kit : this.context.getReferenceContext().getConstructedCDOMObjects(Kit.class)) {
            this.kits.addElement(kit);
        }
        for (PCAlignment alignment : this.context.getReferenceContext().getOrderSortedCDOMObjects(PCAlignment.class)) {
            this.alignments.addElement(alignment);
        }
        for (PCStat stat : this.context.getReferenceContext().getOrderSortedCDOMObjects(PCStat.class)) {
            this.stats.addElement(stat);
        }
        for (AbilityCategory category : this.gameMode.getAllAbilityCategories()) {
            if (!category.isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            ArrayList<Ability> abList = new ArrayList<Ability>(Globals.getContext().getReferenceContext().getManufacturer(Ability.class, category).getAllObjects());
            Globals.sortPObjectListByName(abList);
            DefaultListFacade<AbilityFacade> abilityList = new DefaultListFacade<AbilityFacade>(abList);
            Iterator<Ability> iterator = abilityList.iterator();
            while (iterator.hasNext()) {
                Ability ability;
                AbilityFacade facade = iterator.next();
                if (!(facade instanceof Ability) || (ability = (Ability)facade).getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
                iterator.remove();
            }
            this.abilityMap.put(category, abilityList);
        }
        HashMap<String, BodyStructure> structMap = new HashMap<String, BodyStructure>(SystemCollections.getUnmodifiableBodyStructureList().size() + 3);
        for (String name : SystemCollections.getUnmodifiableBodyStructureList()) {
            String displayName = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
            BodyStructure bodyStructure = new BodyStructure(displayName);
            this.bodyStructures.addElement(bodyStructure);
            structMap.put(name, bodyStructure);
        }
        Set<Type> typesWithDesignatedSlots = this.buildSlottedTypeList();
        this.bodyStructures.addElement(new BodyStructure("Equipped", true, typesWithDesignatedSlots));
        this.bodyStructures.addElement(new BodyStructure("Carried", true));
        this.bodyStructures.addElement(new BodyStructure("Not Carried", true));
        for (EquipSlot es : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!structMap.containsKey(es.getBodyStructureName())) continue;
            ((BodyStructure)structMap.get(es.getBodyStructureName())).addEquipSlot(es);
        }
        for (Equipment eq : this.context.getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
            if (!eq.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            this.equipment.addElement(eq);
        }
        for (String xpTableName : this.gameMode.getXPTableNames()) {
            this.xpTableNames.addElement(xpTableName);
        }
        for (String characterType : this.gameMode.getCharacterTypeList()) {
            this.characterTypes.addElement(characterType);
        }
        for (SizeAdjustment size : this.context.getReferenceContext().getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER)) {
            this.sizes.addElement(size);
        }
        this.createGearBuySellSchemes();
    }

    private Set<Type> buildSlottedTypeList() {
        HashSet<Type> typeList = new HashSet<Type>();
        for (EquipSlot es : SystemCollections.getUnmodifiableEquipSlotList()) {
            for (String typeString : es.getContainType()) {
                typeList.add(Type.getConstant(typeString));
            }
        }
        return typeList;
    }

    private void createGearBuySellSchemes() {
        BigDecimal fullPrice = new BigDecimal(100.0);
        BigDecimal halfPrice = new BigDecimal(50.0);
        BigDecimal free = BigDecimal.ZERO;
        this.gearBuySellSchemes = new DefaultListFacade();
        this.gearBuySellSchemes.addElement(new GearBuySellScheme("Market price", fullPrice, halfPrice, fullPrice));
        this.gearBuySellSchemes.addElement(new GearBuySellScheme("Character build", fullPrice, fullPrice, fullPrice));
        this.gearBuySellSchemes.addElement(new GearBuySellScheme("Cashless", free, free, free));
        this.gearBuySellSchemes.addElement(new GearBuySellScheme("Crafting", halfPrice, halfPrice, fullPrice));
    }

    @Override
    public MapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> getAbilities() {
        return this.abilityMap;
    }

    @Override
    public List<AbilityFacade> getPrereqAbilities(AbilityFacade abilityFacade) {
        if (abilityFacade == null || !(abilityFacade instanceof Ability)) {
            return Collections.emptyList();
        }
        Ability ability = (Ability)abilityFacade;
        ArrayList<AbilityFacade> prereqList = new ArrayList<AbilityFacade>();
        for (Prerequisite prereq : ability.getPrerequisiteList()) {
            prereqList.addAll(this.getAbilitiesFromPrereq(prereq, ability.getCDOMCategory()));
        }
        return prereqList;
    }

    private List<AbilityFacade> getAbilitiesFromPrereq(Prerequisite prereq, Category<Ability> cat) {
        Ability ability;
        ArrayList<AbilityFacade> prereqList = new ArrayList<AbilityFacade>();
        if (prereq == null || prereq.getOperator() == PrerequisiteOperator.LT && "1".equals(prereq.getOperand())) {
            return prereqList;
        }
        if (("FEAT" == prereq.getKind() || "FEAT".equalsIgnoreCase(prereq.getKind()) || "ABILITY" == prereq.getKind() || "ABILITY".equalsIgnoreCase(prereq.getKind())) && (ability = Globals.getContext().getReferenceContext().getManufacturer(Ability.class, cat).getObject(prereq.getKey())) != null) {
            prereqList.add(ability);
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            prereqList.addAll(this.getAbilitiesFromPrereq(childPrereq, cat));
        }
        return prereqList;
    }

    @Override
    public ListFacade<SkillFacade> getSkills() {
        return this.skills;
    }

    @Override
    public ListFacade<RaceFacade> getRaces() {
        return this.races;
    }

    @Override
    public ListFacade<ClassFacade> getClasses() {
        return this.classes;
    }

    @Override
    public ListFacade<DeityFacade> getDeities() {
        return this.deities;
    }

    @Override
    public ListFacade<TemplateFacade> getTemplates() {
        return this.templates;
    }

    @Override
    public GameModeFacade getGameMode() {
        return this.gameMode;
    }

    @Override
    public ListFacade<CampaignFacade> getCampaigns() {
        return this.campaigns;
    }

    @Override
    public ListFacade<AlignmentFacade> getAlignments() {
        return this.alignments;
    }

    @Override
    public ListFacade<StatFacade> getStats() {
        return this.stats;
    }

    @Override
    public ListFacade<StatGenerationFacade> getStatGenerators() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SkillFacade getSpeakLanguageSkill() {
        if (this.speakLanguageSkill != null) {
            return this.speakLanguageSkill;
        }
        for (SkillFacade aSkillFacade : this.skills) {
            Skill aSkill = (Skill)aSkillFacade;
            ChooseInformation<?> chooseInfo = aSkill.get(ObjectKey.CHOOSE_INFO);
            if (chooseInfo == null || !"LANG".equals(chooseInfo.getName())) continue;
            this.speakLanguageSkill = aSkillFacade;
        }
        return this.speakLanguageSkill;
    }

    @Override
    public ListFacade<BodyStructureFacade> getEquipmentLocations() {
        return this.bodyStructures;
    }

    @Override
    public ListFacade<EquipmentFacade> getEquipment() {
        return this.equipment;
    }

    @Override
    public void addEquipment(EquipmentFacade equip) {
        this.equipment.addElement(equip);
    }

    @Override
    public void refreshEquipment() {
        this.equipment.updateContents(new ArrayList<Equipment>(this.context.getReferenceContext().getConstructedCDOMObjects(Equipment.class)));
    }

    @Override
    public ListFacade<String> getXPTableNames() {
        return this.xpTableNames;
    }

    @Override
    public ListFacade<String> getCharacterTypes() {
        return this.characterTypes;
    }

    @Override
    public ListFacade<GearBuySellFacade> getGearBuySellSchemes() {
        return this.gearBuySellSchemes;
    }

    @Override
    public ListFacade<KitFacade> getKits() {
        return this.kits;
    }

    @Override
    public ListFacade<SizeAdjustmentFacade> getSizes() {
        return this.sizes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataSet [gameMode=");
        builder.append(this.gameMode);
        builder.append(", campaigns=");
        builder.append(this.campaigns);
        builder.append("]");
        return builder.toString();
    }

    class AbilityCategoryComparator
    implements Comparator<AbilityCategoryFacade> {
        AbilityCategoryComparator() {
        }

        @Override
        public int compare(AbilityCategoryFacade f1, AbilityCategoryFacade f2) {
            AbilityCategory o1 = (AbilityCategory)f1;
            AbilityCategory o2 = (AbilityCategory)f2;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            String[] ORDER = new String[]{"FEATS", "RACIAL ABILITIES", "TRAITS", "CLASS ABILITIES"};
            if (o1 == o2) {
                return 0;
            }
            String ac1Key = o1.getKeyName();
            String ac2Key = o2.getKeyName();
            String ac1Display = o1.getDisplayLocation().toString().toUpperCase();
            String ac2Display = o2.getDisplayLocation().toString().toUpperCase();
            if (ac1Display == null && ac2Display != null) {
                return 1;
            }
            if (ac1Display != null && ac2Display == null) {
                return -1;
            }
            if (ac1Display != null && ac2Display != null && !ac1Display.equals(ac2Display)) {
                for (String displayOrder : ORDER) {
                    if (ac1Display.equals(displayOrder)) {
                        return -1;
                    }
                    if (!ac2Display.equals(displayOrder)) continue;
                    return 1;
                }
                return ac1Display.compareTo(ac2Display);
            }
            if (ac1Key == null && ac2Key != null) {
                return 1;
            }
            if (ac1Key != null && ac2Key == null) {
                return -1;
            }
            if (ac1Key == null && ac2Key == null || ac1Key.equals(ac2Key)) {
                return 0;
            }
            return ac1Key.compareTo(ac2Key);
        }
    }

    class AbilityMap
    extends AbstractMapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> {
        private TreeMap<AbilityCategoryFacade, ListFacade<AbilityFacade>> map;

        public AbilityMap() {
            this.map = new TreeMap(new AbilityCategoryComparator());
        }

        @Override
        public Set<AbilityCategoryFacade> getKeys() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public ListFacade<AbilityFacade> getValue(AbilityCategoryFacade key) {
            return this.map.get(key);
        }

        public void put(AbilityCategoryFacade key, ListFacade<AbilityFacade> value) {
            this.map.put(key, value);
        }
    }

    class PCClassComparator
    implements Comparator<PCClass> {
        PCClassComparator() {
        }

        @Override
        public int compare(PCClass c1, PCClass c2) {
            String key2;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (c1 == c2) {
                return 0;
            }
            String BASE_TYPE = "BASE.PC";
            if (c1.isType("BASE.PC") && !c2.isType("BASE.PC")) {
                return -1;
            }
            if (!c1.isType("BASE.PC") && c2.isType("BASE.PC")) {
                return 1;
            }
            String PRESTIGE_TYPE = "Prestige";
            if (c1.isType("Prestige") && !c2.isType("Prestige")) {
                return -1;
            }
            if (!c1.isType("Prestige") && c2.isType("Prestige")) {
                return 1;
            }
            String NPC_TYPE = "NPC";
            if (c1.isType("NPC") && !c2.isType("NPC")) {
                return -1;
            }
            if (!c1.isType("NPC") && c2.isType("NPC")) {
                return 1;
            }
            String key1 = c1.get(StringKey.SORT_KEY);
            if (key1 == null) {
                key1 = c1.getDisplayName();
            }
            if ((key2 = c2.get(StringKey.SORT_KEY)) == null) {
                key2 = c2.getDisplayName();
            }
            Collator collator = Collator.getInstance();
            return collator.compare(key1, key2);
        }
    }

    class RaceComparator
    implements Comparator<Race> {
        RaceComparator() {
        }

        @Override
        public int compare(Race r1, Race r2) {
            String key2;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (r1 == r2) {
                return 0;
            }
            String NONE_SELECTED = "<none selected>";
            if (r1.getKeyName().equals("<none selected>") && !r2.getKeyName().equals("<none selected>")) {
                return -1;
            }
            if (!r1.getKeyName().equals("<none selected>") && r2.getKeyName().equals("<none selected>")) {
                return 1;
            }
            String PC_TYPE = "PC";
            if (r1.isType("PC") && !r2.isType("PC")) {
                return -1;
            }
            if (!r1.isType("PC") && r2.isType("PC")) {
                return 1;
            }
            String HUMANOID = "Humanoid";
            if (r1.isType("Humanoid") && !r2.isType("Humanoid")) {
                return -1;
            }
            if (!r1.isType("Humanoid") && r2.isType("Humanoid")) {
                return 1;
            }
            String key1 = r1.get(StringKey.SORT_KEY);
            if (key1 == null) {
                key1 = r1.getDisplayName();
            }
            if ((key2 = r2.get(StringKey.SORT_KEY)) == null) {
                key2 = r2.getDisplayName();
            }
            Collator collator = Collator.getInstance();
            return collator.compare(key1, key2);
        }
    }
}

