/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.analysis.ChangeProfFacet;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.WeaponProf;

public class WeaponProfProvider
extends ConcretePrereqObject
implements QualifyingObject {
    private static ChangeProfFacet changeProfFacet = FacetLibrary.getFacet(ChangeProfFacet.class);
    private List<CDOMSingleRef<WeaponProf>> direct;
    private List<CDOMGroupRef<WeaponProf>> type;
    private CDOMGroupRef<WeaponProf> all;

    public void addWeaponProf(CDOMSingleRef<WeaponProf> ref) {
        if (this.direct == null) {
            this.direct = new ArrayList<CDOMSingleRef<WeaponProf>>();
        }
        this.direct.add(ref);
    }

    public void addWeaponProfType(CDOMGroupRef<WeaponProf> ref) {
        if (this.type == null) {
            this.type = new ArrayList<CDOMGroupRef<WeaponProf>>();
        }
        this.type.add(ref);
    }

    public void addWeaponProfAll(CDOMGroupRef<WeaponProf> ref) {
        this.all = ref;
    }

    public Collection<WeaponProf> getContainedProficiencies(CharID id) {
        ArrayList<WeaponProf> list = new ArrayList<WeaponProf>();
        if (this.all == null) {
            if (this.direct != null) {
                for (CDOMSingleRef cDOMSingleRef : this.direct) {
                    list.add((WeaponProf)cDOMSingleRef.resolvesTo());
                }
            }
            if (this.type != null) {
                for (CDOMGroupRef cDOMGroupRef : this.type) {
                    list.addAll(this.getWeaponProfsInTarget(id, cDOMGroupRef));
                }
            }
        } else {
            list.addAll(this.all.getContainedObjects());
        }
        return list;
    }

    public String getLstFormat() {
        boolean typeEmpty;
        if (this.all != null) {
            return "ALL";
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = typeEmpty = this.type == null || this.type.isEmpty();
        if (this.direct != null && !this.direct.isEmpty()) {
            sb.append(ReferenceUtilities.joinLstFormat(this.direct, "|"));
            if (!typeEmpty) {
                sb.append("|");
            }
        }
        if (!typeEmpty) {
            sb.append(ReferenceUtilities.joinLstFormat(this.type, "|"));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WeaponProfProvider) {
            WeaponProfProvider other = (WeaponProfProvider)obj;
            if (this.direct == null ? other.direct != null : !this.direct.equals(other.direct)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (this.all == null ? other.all != null : !this.all.equals(other.all)) {
                return false;
            }
            return this.equalsPrereqObject(other);
        }
        return false;
    }

    public int hashCode() {
        return (this.direct == null ? 0 : this.direct.hashCode() * 29) + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean isEmpty() {
        return !(this.all != null || this.direct != null && !this.direct.isEmpty() || this.type != null && !this.type.isEmpty());
    }

    public boolean isValid() {
        boolean hasDirect = this.direct != null && !this.direct.isEmpty();
        boolean hasType = this.type != null && !this.type.isEmpty();
        boolean hasIndividual = hasDirect || hasType;
        boolean hasAll = this.all != null;
        return hasAll ^ hasIndividual;
    }

    public List<WeaponProf> getWeaponProfsInTarget(CharID id, CDOMGroupRef<WeaponProf> master) {
        return changeProfFacet.getWeaponProfsInTarget(id, master);
    }
}

