/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.input;

import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.DefaultClassSkillListFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.SubClassFacet;
import pcgen.cdom.facet.base.AbstractScopeFacet;
import pcgen.cdom.facet.event.ScopeFacetChangeEvent;
import pcgen.cdom.facet.event.ScopeFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.SkillListFacet;
import pcgen.cdom.list.ClassSkillList;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SubClass;

public class ClassSkillListFacet
extends AbstractScopeFacet<CharID, PCClass, ClassSkillList>
implements ClassFacet.ClassLevelChangeListener,
ScopeFacetChangeListener<CharID, PCClass, String> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private ClassFacet classFacet;
    private DefaultClassSkillListFacet defaultClassSkillListFacet;
    private SubClassFacet subClassFacet;
    private SkillListFacet skillListFacet;

    @Override
    public void levelChanged(ClassFacet.ClassLevelChangeEvent lce) {
        if (lce.getOldLevel() == 0 && lce.getNewLevel() > 0) {
            PCClass cl = lce.getPCClass();
            CharID id = lce.getCharID();
            TransitionChoice<ClassSkillList> csc = cl.get(ObjectKey.SKILLLIST_CHOICE);
            if (csc == null) {
                ClassSkillList l = cl.get(ObjectKey.CLASS_SKILLLIST);
                if (l != null) {
                    this.defaultClassSkillListFacet.add(id, cl, l, cl);
                }
            } else {
                PlayerCharacter pc = this.trackingFacet.getPC(id);
                for (ClassSkillList st : csc.driveChoice(pc)) {
                    this.add(id, cl, st, cl);
                }
            }
        } else if (lce.getOldLevel() > 0 && lce.getNewLevel() == 0) {
            this.removeAllFromSource(lce.getCharID(), lce.getPCClass());
        }
    }

    @Override
    public void levelObjectChanged(ClassFacet.ClassLevelObjectChangeEvent lce) {
    }

    @Override
    public void dataAdded(ScopeFacetChangeEvent<CharID, PCClass, String> dfce) {
        String subClassKey;
        PCClass cl = dfce.getScope();
        SubClass subclass = cl.getSubClassKeyed(subClassKey = dfce.getCDOMObject());
        if (subclass != null) {
            ClassSkillList scl = subclass.get(ObjectKey.CLASS_SKILLLIST);
            this.defaultClassSkillListFacet.add(dfce.getCharID(), cl, scl, subclass);
        }
    }

    @Override
    public void dataRemoved(ScopeFacetChangeEvent<CharID, PCClass, String> dfce) {
        String subClassKey;
        PCClass cl = dfce.getScope();
        SubClass subclass = cl.getSubClassKeyed(subClassKey = dfce.getCDOMObject());
        if (subclass != null) {
            ClassSkillList scl = subclass.get(ObjectKey.CLASS_SKILLLIST);
            this.defaultClassSkillListFacet.add(dfce.getCharID(), cl, scl, subclass);
        }
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setSubClassFacet(SubClassFacet subClassFacet) {
        this.subClassFacet = subClassFacet;
    }

    public void setDefaultClassSkillListFacet(DefaultClassSkillListFacet defaultClassSkillListFacet) {
        this.defaultClassSkillListFacet = defaultClassSkillListFacet;
    }

    public void setSkillListFacet(SkillListFacet skillListFacet) {
        this.skillListFacet = skillListFacet;
    }

    public void init() {
        this.classFacet.addLevelChangeListener(this);
        this.subClassFacet.addScopeFacetChangeListener(this);
        this.addScopeFacetChangeListener(this.skillListFacet);
    }
}

