package io.dagger.codegen.introspection;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class CodeWriter {
  private Charset encoding;
  private Path targetDirectory;

  public CodeWriter(Path targetDirectory, Charset encoding) {
    this.encoding = encoding;
    this.targetDirectory = targetDirectory;
  }

  public void write(TypeSpec typeSpec) throws IOException {
    JavaFile javaFile =
        JavaFile.builder("io.dagger.client", typeSpec)
            .addFileComment("This class has been generated by dagger-java-sdk. DO NOT EDIT.")
            .indent("    ")
            .build();
    javaFile.writeTo(targetDirectory, encoding);
  }
}
