# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.ModuleRef do
  @moduledoc "A reference to a module."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc ""
    @spec as_git_ref(t()) :: {:ok, Dagger.GitModuleRef.t() | nil} | {:error, term()}
    def as_git_ref(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "asGitRef")

      case execute(selection, module_ref.client) do
        {:ok, nil} -> {:ok, nil}
        {:ok, data} -> Nestru.decode_from_map(data, Dagger.GitModuleRef)
        error -> error
      end
    end
  )

  (
    @doc ""
    @spec as_local_ref(t()) :: {:ok, Dagger.LocalModuleRef.t() | nil} | {:error, term()}
    def as_local_ref(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "asLocalRef")

      case execute(selection, module_ref.client) do
        {:ok, nil} -> {:ok, nil}
        {:ok, data} -> Nestru.decode_from_map(data, Dagger.LocalModuleRef)
        error -> error
      end
    end
  )

  (
    @doc "Load the ref as a module. If this is a local ref, the parent directory must have been provided during module ref creation"
    @spec as_module(t()) :: Dagger.Module.t()
    def as_module(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "asModule")
      %Dagger.Module{selection: selection, client: module_ref.client}
    end
  )

  (
    @doc "String representation of the ref."
    @spec as_string(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def as_string(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "asString")
      execute(selection, module_ref.client)
    end
  )

  (
    @doc "A unique identifier for this ModuleRef."
    @spec id(t()) :: {:ok, Dagger.ModuleRefID.t()} | {:error, term()}
    def id(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "id")
      execute(selection, module_ref.client)
    end
  )

  (
    @doc ""
    @spec kind(t()) :: {:ok, Dagger.ModuleRefKind.t()} | {:error, term()}
    def kind(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "kind")
      execute(selection, module_ref.client)
    end
  )

  (
    @doc "The path to the module source code dir specified by this ref."
    @spec module_source_path(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def module_source_path(%__MODULE__{} = module_ref) do
      selection = select(module_ref.selection, "moduleSourcePath")
      execute(selection, module_ref.client)
    end
  )
end
