# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.CurrentModule do
  @moduledoc "Reflective module API provided to functions at runtime."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "A unique identifier for this CurrentModule."
    @spec id(t()) :: {:ok, Dagger.CurrentModuleID.t()} | {:error, term()}
    def id(%__MODULE__{} = current_module) do
      selection = select(current_module.selection, "id")
      execute(selection, current_module.client)
    end
  )

  (
    @doc "The name of the module being executed in"
    @spec name(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def name(%__MODULE__{} = current_module) do
      selection = select(current_module.selection, "name")
      execute(selection, current_module.client)
    end
  )

  (
    @doc "The directory containing the module's source code loaded into the engine (plus any generated code that may have been created)."
    @spec source(t()) :: Dagger.Directory.t()
    def source(%__MODULE__{} = current_module) do
      selection = select(current_module.selection, "source")
      %Dagger.Directory{selection: selection, client: current_module.client}
    end
  )

  (
    @doc "Load a directory from the module's scratch working directory, including any changes that may have been made to it during module function execution.\n\n## Required Arguments\n\n* `path` - Location of the directory to access (e.g., \".\").\n\n## Optional Arguments\n\n* `exclude` - Exclude artifacts that match the given pattern (e.g., [\"node_modules/\", \".git*\"]).\n* `include` - Include only artifacts that match the given pattern (e.g., [\"app/\", \"package.*\"])."
    @spec workdir(t(), Dagger.String.t(), keyword()) :: Dagger.Directory.t()
    def workdir(%__MODULE__{} = current_module, path, optional_args \\ []) do
      selection = select(current_module.selection, "workdir")
      selection = arg(selection, "path", path)

      selection =
        if is_nil(optional_args[:exclude]) do
          selection
        else
          arg(selection, "exclude", optional_args[:exclude])
        end

      selection =
        if is_nil(optional_args[:include]) do
          selection
        else
          arg(selection, "include", optional_args[:include])
        end

      %Dagger.Directory{selection: selection, client: current_module.client}
    end
  )

  (
    @doc "Load a file from the module's scratch working directory, including any changes that may have been made to it during module function execution.Load a file from the module's scratch working directory, including any changes that may have been made to it during module function execution.\n\n## Required Arguments\n\n* `path` - Location of the file to retrieve (e.g., \"README.md\")."
    @spec workdir_file(t(), Dagger.String.t()) :: Dagger.File.t()
    def workdir_file(%__MODULE__{} = current_module, path) do
      selection = select(current_module.selection, "workdirFile")
      selection = arg(selection, "path", path)
      %Dagger.File{selection: selection, client: current_module.client}
    end
  )
end
