// RUN: %parallel-boogie /proverOpt:O:auto_config=false /proverOpt:O:type_check=true /proverOpt:O:smt.qi.eager_threshold=100 /proverOpt:O:smt.delay_units=true "%s" > "%t"
// RUN: %diff "%s.expect" "%t"
// dafny 3.10.0.41215
// Command Line Options: /compile:0 /print:Seq.bpl Collections/Sequences/Seq.dfy

const $$Language$Dafny: bool;

axiom $$Language$Dafny;

type Ty;

type Bv0 = int;

const unique TBool: Ty;

axiom Tag(TBool) == TagBool;

const unique TChar: Ty;

axiom Tag(TChar) == TagChar;

const unique TInt: Ty;

axiom Tag(TInt) == TagInt;

const unique TReal: Ty;

axiom Tag(TReal) == TagReal;

const unique TORDINAL: Ty;

axiom Tag(TORDINAL) == TagORDINAL;

axiom (forall w: int :: { TBitvector(w) } Inv0_TBitvector(TBitvector(w)) == w);

function TBitvector(int) : Ty;

axiom (forall t: Ty :: { TSet(t) } Inv0_TSet(TSet(t)) == t);

axiom (forall t: Ty :: { TSet(t) } Tag(TSet(t)) == TagSet);

function TSet(Ty) : Ty;

axiom (forall t: Ty :: { TISet(t) } Inv0_TISet(TISet(t)) == t);

axiom (forall t: Ty :: { TISet(t) } Tag(TISet(t)) == TagISet);

function TISet(Ty) : Ty;

axiom (forall t: Ty :: { TMultiSet(t) } Inv0_TMultiSet(TMultiSet(t)) == t);

axiom (forall t: Ty :: { TMultiSet(t) } Tag(TMultiSet(t)) == TagMultiSet);

function TMultiSet(Ty) : Ty;

axiom (forall t: Ty :: { TSeq(t) } Inv0_TSeq(TSeq(t)) == t);

axiom (forall t: Ty :: { TSeq(t) } Tag(TSeq(t)) == TagSeq);

function TSeq(Ty) : Ty;

axiom (forall t: Ty, u: Ty :: { TMap(t, u) } Inv0_TMap(TMap(t, u)) == t);

axiom (forall t: Ty, u: Ty :: { TMap(t, u) } Inv1_TMap(TMap(t, u)) == u);

axiom (forall t: Ty, u: Ty :: { TMap(t, u) } Tag(TMap(t, u)) == TagMap);

function TMap(Ty, Ty) : Ty;

axiom (forall t: Ty, u: Ty :: { TIMap(t, u) } Inv0_TIMap(TIMap(t, u)) == t);

axiom (forall t: Ty, u: Ty :: { TIMap(t, u) } Inv1_TIMap(TIMap(t, u)) == u);

axiom (forall t: Ty, u: Ty :: { TIMap(t, u) } Tag(TIMap(t, u)) == TagIMap);

function TIMap(Ty, Ty) : Ty;

function Inv0_TBitvector(Ty) : int;

function Inv0_TSet(Ty) : Ty;

function Inv0_TISet(Ty) : Ty;

function Inv0_TSeq(Ty) : Ty;

function Inv0_TMultiSet(Ty) : Ty;

function Inv0_TMap(Ty) : Ty;

function Inv1_TMap(Ty) : Ty;

function Inv0_TIMap(Ty) : Ty;

function Inv1_TIMap(Ty) : Ty;

type TyTag;

function Tag(Ty) : TyTag;

const unique TagBool: TyTag;

const unique TagChar: TyTag;

const unique TagInt: TyTag;

const unique TagReal: TyTag;

const unique TagORDINAL: TyTag;

const unique TagSet: TyTag;

const unique TagISet: TyTag;

const unique TagMultiSet: TyTag;

const unique TagSeq: TyTag;

const unique TagMap: TyTag;

const unique TagIMap: TyTag;

const unique TagClass: TyTag;

type TyTagFamily;

function TagFamily(Ty) : TyTagFamily;

axiom (forall<T> x: T :: { $Box(Lit(x)) } $Box(Lit(x)) == Lit($Box(x)));

function {:identity} Lit<T>(x: T) : T;

axiom (forall<T> x: T :: {:identity} { Lit(x): T } Lit(x): T == x);

axiom (forall x: int :: { $Box(LitInt(x)) } $Box(LitInt(x)) == Lit($Box(x)));

function {:identity} LitInt(x: int) : int;

axiom (forall x: int :: {:identity} { LitInt(x): int } LitInt(x): int == x);

axiom (forall x: real :: { $Box(LitReal(x)) } $Box(LitReal(x)) == Lit($Box(x)));

function {:identity} LitReal(x: real) : real;

axiom (forall x: real :: {:identity} { LitReal(x): real } LitReal(x): real == x);

function {:inline} char#IsChar(n: int) : bool
{
  0 <= n && n < 65536
}

type char;

axiom (forall n: int :: 
  { char#FromInt(n) } 
  char#IsChar(n) ==> char#ToInt(char#FromInt(n)) == n);

function char#FromInt(int) : char;

axiom (forall ch: char :: 
  { char#ToInt(ch) } 
  char#FromInt(char#ToInt(ch)) == ch && char#IsChar(char#ToInt(ch)));

function char#ToInt(char) : int;

axiom (forall a: char, b: char :: 
  { char#Plus(a, b) } 
  char#Plus(a, b) == char#FromInt(char#ToInt(a) + char#ToInt(b)));

function char#Plus(char, char) : char;

axiom (forall a: char, b: char :: 
  { char#Minus(a, b) } 
  char#Minus(a, b) == char#FromInt(char#ToInt(a) - char#ToInt(b)));

function char#Minus(char, char) : char;

type ref;

const null: ref;

type Box;

const $ArbitraryBoxValue: Box;

axiom (forall<T> x: T :: { $Box(x) } $Unbox($Box(x)) == x);

function $Box<T>(T) : Box;

function $Unbox<T>(Box) : T;

function $IsBox<T>(T, Ty) : bool;

function $IsAllocBox<T>(T, Ty, Heap) : bool;

axiom (forall bx: Box :: 
  { $IsBox(bx, TInt) } 
  $IsBox(bx, TInt) ==> $Box($Unbox(bx): int) == bx && $Is($Unbox(bx): int, TInt));

axiom (forall bx: Box :: 
  { $IsBox(bx, TReal) } 
  $IsBox(bx, TReal)
     ==> $Box($Unbox(bx): real) == bx && $Is($Unbox(bx): real, TReal));

axiom (forall bx: Box :: 
  { $IsBox(bx, TBool) } 
  $IsBox(bx, TBool)
     ==> $Box($Unbox(bx): bool) == bx && $Is($Unbox(bx): bool, TBool));

axiom (forall bx: Box :: 
  { $IsBox(bx, TChar) } 
  $IsBox(bx, TChar)
     ==> $Box($Unbox(bx): char) == bx && $Is($Unbox(bx): char, TChar));

axiom (forall bx: Box :: 
  { $IsBox(bx, TBitvector(0)) } 
  $IsBox(bx, TBitvector(0))
     ==> $Box($Unbox(bx): Bv0) == bx && $Is($Unbox(bx): Set Box, TBitvector(0)));

axiom (forall bx: Box, t: Ty :: 
  { $IsBox(bx, TSet(t)) } 
  $IsBox(bx, TSet(t))
     ==> $Box($Unbox(bx): Set Box) == bx && $Is($Unbox(bx): Set Box, TSet(t)));

axiom (forall bx: Box, t: Ty :: 
  { $IsBox(bx, TISet(t)) } 
  $IsBox(bx, TISet(t))
     ==> $Box($Unbox(bx): ISet Box) == bx && $Is($Unbox(bx): ISet Box, TISet(t)));

axiom (forall bx: Box, t: Ty :: 
  { $IsBox(bx, TMultiSet(t)) } 
  $IsBox(bx, TMultiSet(t))
     ==> $Box($Unbox(bx): MultiSet Box) == bx
       && $Is($Unbox(bx): MultiSet Box, TMultiSet(t)));

axiom (forall bx: Box, t: Ty :: 
  { $IsBox(bx, TSeq(t)) } 
  $IsBox(bx, TSeq(t))
     ==> $Box($Unbox(bx): Seq Box) == bx && $Is($Unbox(bx): Seq Box, TSeq(t)));

axiom (forall bx: Box, s: Ty, t: Ty :: 
  { $IsBox(bx, TMap(s, t)) } 
  $IsBox(bx, TMap(s, t))
     ==> $Box($Unbox(bx): Map Box Box) == bx && $Is($Unbox(bx): Map Box Box, TMap(s, t)));

axiom (forall bx: Box, s: Ty, t: Ty :: 
  { $IsBox(bx, TIMap(s, t)) } 
  $IsBox(bx, TIMap(s, t))
     ==> $Box($Unbox(bx): IMap Box Box) == bx
       && $Is($Unbox(bx): IMap Box Box, TIMap(s, t)));

axiom (forall<T> v: T, t: Ty :: 
  { $IsBox($Box(v), t) } 
  $IsBox($Box(v), t) <==> $Is(v, t));

axiom (forall<T> v: T, t: Ty, h: Heap :: 
  { $IsAllocBox($Box(v), t, h) } 
  $IsAllocBox($Box(v), t, h) <==> $IsAlloc(v, t, h));

axiom (forall v: int :: { $Is(v, TInt) } $Is(v, TInt));

axiom (forall v: real :: { $Is(v, TReal) } $Is(v, TReal));

axiom (forall v: bool :: { $Is(v, TBool) } $Is(v, TBool));

axiom (forall v: char :: { $Is(v, TChar) } $Is(v, TChar));

axiom (forall v: ORDINAL :: { $Is(v, TORDINAL) } $Is(v, TORDINAL));

axiom (forall v: Bv0 :: { $Is(v, TBitvector(0)) } $Is(v, TBitvector(0)));

axiom (forall v: Set Box, t0: Ty :: 
  { $Is(v, TSet(t0)) } 
  $Is(v, TSet(t0)) <==> (forall bx: Box :: { v[bx] } v[bx] ==> $IsBox(bx, t0)));

axiom (forall v: ISet Box, t0: Ty :: 
  { $Is(v, TISet(t0)) } 
  $Is(v, TISet(t0)) <==> (forall bx: Box :: { v[bx] } v[bx] ==> $IsBox(bx, t0)));

axiom (forall v: MultiSet Box, t0: Ty :: 
  { $Is(v, TMultiSet(t0)) } 
  $Is(v, TMultiSet(t0))
     <==> (forall bx: Box :: { v[bx] } 0 < v[bx] ==> $IsBox(bx, t0)));

axiom (forall v: MultiSet Box, t0: Ty :: 
  { $Is(v, TMultiSet(t0)) } 
  $Is(v, TMultiSet(t0)) ==> $IsGoodMultiSet(v));

axiom (forall v: Seq Box, t0: Ty :: 
  { $Is(v, TSeq(t0)) } 
  $Is(v, TSeq(t0))
     <==> (forall i: int :: 
      { Seq#Index(v, i) } 
      0 <= i && i < Seq#Length(v) ==> $IsBox(Seq#Index(v, i), t0)));

axiom (forall v: Map Box Box, t0: Ty, t1: Ty :: 
  { $Is(v, TMap(t0, t1)) } 
  $Is(v, TMap(t0, t1))
     <==> (forall bx: Box :: 
      { Map#Elements(v)[bx] } { Map#Domain(v)[bx] } 
      Map#Domain(v)[bx] ==> $IsBox(Map#Elements(v)[bx], t1) && $IsBox(bx, t0)));

axiom (forall v: Map Box Box, t0: Ty, t1: Ty :: 
  { $Is(v, TMap(t0, t1)) } 
  $Is(v, TMap(t0, t1))
     ==> $Is(Map#Domain(v), TSet(t0))
       && $Is(Map#Values(v), TSet(t1))
       && $Is(Map#Items(v), TSet(Tclass._System.Tuple2(t0, t1))));

axiom (forall v: IMap Box Box, t0: Ty, t1: Ty :: 
  { $Is(v, TIMap(t0, t1)) } 
  $Is(v, TIMap(t0, t1))
     <==> (forall bx: Box :: 
      { IMap#Elements(v)[bx] } { IMap#Domain(v)[bx] } 
      IMap#Domain(v)[bx] ==> $IsBox(IMap#Elements(v)[bx], t1) && $IsBox(bx, t0)));

axiom (forall v: IMap Box Box, t0: Ty, t1: Ty :: 
  { $Is(v, TIMap(t0, t1)) } 
  $Is(v, TIMap(t0, t1))
     ==> $Is(IMap#Domain(v), TISet(t0))
       && $Is(IMap#Values(v), TISet(t1))
       && $Is(IMap#Items(v), TISet(Tclass._System.Tuple2(t0, t1))));

function $Is<T>(T, Ty) : bool;

axiom (forall h: Heap, v: int :: { $IsAlloc(v, TInt, h) } $IsAlloc(v, TInt, h));

axiom (forall h: Heap, v: real :: { $IsAlloc(v, TReal, h) } $IsAlloc(v, TReal, h));

axiom (forall h: Heap, v: bool :: { $IsAlloc(v, TBool, h) } $IsAlloc(v, TBool, h));

axiom (forall h: Heap, v: char :: { $IsAlloc(v, TChar, h) } $IsAlloc(v, TChar, h));

axiom (forall h: Heap, v: ORDINAL :: 
  { $IsAlloc(v, TORDINAL, h) } 
  $IsAlloc(v, TORDINAL, h));

axiom (forall v: Bv0, h: Heap :: 
  { $IsAlloc(v, TBitvector(0), h) } 
  $IsAlloc(v, TBitvector(0), h));

axiom (forall v: Set Box, t0: Ty, h: Heap :: 
  { $IsAlloc(v, TSet(t0), h) } 
  $IsAlloc(v, TSet(t0), h)
     <==> (forall bx: Box :: { v[bx] } v[bx] ==> $IsAllocBox(bx, t0, h)));

axiom (forall v: ISet Box, t0: Ty, h: Heap :: 
  { $IsAlloc(v, TISet(t0), h) } 
  $IsAlloc(v, TISet(t0), h)
     <==> (forall bx: Box :: { v[bx] } v[bx] ==> $IsAllocBox(bx, t0, h)));

axiom (forall v: MultiSet Box, t0: Ty, h: Heap :: 
  { $IsAlloc(v, TMultiSet(t0), h) } 
  $IsAlloc(v, TMultiSet(t0), h)
     <==> (forall bx: Box :: { v[bx] } 0 < v[bx] ==> $IsAllocBox(bx, t0, h)));

axiom (forall v: Seq Box, t0: Ty, h: Heap :: 
  { $IsAlloc(v, TSeq(t0), h) } 
  $IsAlloc(v, TSeq(t0), h)
     <==> (forall i: int :: 
      { Seq#Index(v, i) } 
      0 <= i && i < Seq#Length(v) ==> $IsAllocBox(Seq#Index(v, i), t0, h)));

axiom (forall v: Map Box Box, t0: Ty, t1: Ty, h: Heap :: 
  { $IsAlloc(v, TMap(t0, t1), h) } 
  $IsAlloc(v, TMap(t0, t1), h)
     <==> (forall bx: Box :: 
      { Map#Elements(v)[bx] } { Map#Domain(v)[bx] } 
      Map#Domain(v)[bx]
         ==> $IsAllocBox(Map#Elements(v)[bx], t1, h) && $IsAllocBox(bx, t0, h)));

axiom (forall v: IMap Box Box, t0: Ty, t1: Ty, h: Heap :: 
  { $IsAlloc(v, TIMap(t0, t1), h) } 
  $IsAlloc(v, TIMap(t0, t1), h)
     <==> (forall bx: Box :: 
      { IMap#Elements(v)[bx] } { IMap#Domain(v)[bx] } 
      IMap#Domain(v)[bx]
         ==> $IsAllocBox(IMap#Elements(v)[bx], t1, h) && $IsAllocBox(bx, t0, h)));

function $IsAlloc<T>(T, Ty, Heap) : bool;

axiom (forall ty: Ty :: 
  { $AlwaysAllocated(ty) } 
  $AlwaysAllocated(ty)
     ==> (forall h: Heap, v: Box :: 
      { $IsAllocBox(v, ty, h) } 
      $IsBox(v, ty) ==> $IsAllocBox(v, ty, h)));

function $AlwaysAllocated(Ty) : bool;

function $OlderTag(Heap) : bool;

type ClassName;

const unique class._System.int: ClassName;

const unique class._System.bool: ClassName;

const unique class._System.set: ClassName;

const unique class._System.seq: ClassName;

const unique class._System.multiset: ClassName;

function Tclass._System.object?() : Ty;

function Tclass._System.Tuple2(Ty, Ty) : Ty;

function dtype(ref) : Ty;

function TypeTuple(a: ClassName, b: ClassName) : ClassName;

function TypeTupleCar(ClassName) : ClassName;

function TypeTupleCdr(ClassName) : ClassName;

axiom (forall a: ClassName, b: ClassName :: 
  { TypeTuple(a, b) } 
  TypeTupleCar(TypeTuple(a, b)) == a && TypeTupleCdr(TypeTuple(a, b)) == b);

type HandleType;

function SetRef_to_SetBox(s: [ref]bool) : Set Box;

axiom (forall s: [ref]bool, bx: Box :: 
  { SetRef_to_SetBox(s)[bx] } 
  SetRef_to_SetBox(s)[bx] == s[$Unbox(bx): ref]);

axiom (forall s: [ref]bool :: 
  { SetRef_to_SetBox(s) } 
  $Is(SetRef_to_SetBox(s), TSet(Tclass._System.object?())));

function Apply1(Ty, Ty, Heap, HandleType, Box) : Box;

type DatatypeType;

type DtCtorId;

function DatatypeCtorId(DatatypeType) : DtCtorId;

function DtRank(DatatypeType) : int;

function BoxRank(Box) : int;

axiom (forall d: DatatypeType :: { BoxRank($Box(d)) } BoxRank($Box(d)) == DtRank(d));

type ORDINAL = Box;

function ORD#IsNat(ORDINAL) : bool;

function ORD#Offset(ORDINAL) : int;

axiom (forall o: ORDINAL :: { ORD#Offset(o) } 0 <= ORD#Offset(o));

function {:inline} ORD#IsLimit(o: ORDINAL) : bool
{
  ORD#Offset(o) == 0
}

function {:inline} ORD#IsSucc(o: ORDINAL) : bool
{
  0 < ORD#Offset(o)
}

function ORD#FromNat(int) : ORDINAL;

axiom (forall n: int :: 
  { ORD#FromNat(n) } 
  0 <= n ==> ORD#IsNat(ORD#FromNat(n)) && ORD#Offset(ORD#FromNat(n)) == n);

axiom (forall o: ORDINAL :: 
  { ORD#Offset(o) } { ORD#IsNat(o) } 
  ORD#IsNat(o) ==> o == ORD#FromNat(ORD#Offset(o)));

function ORD#Less(ORDINAL, ORDINAL) : bool;

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Less(o, p) } 
  (ORD#Less(o, p) ==> o != p)
     && (ORD#IsNat(o) && !ORD#IsNat(p) ==> ORD#Less(o, p))
     && (ORD#IsNat(o) && ORD#IsNat(p)
       ==> ORD#Less(o, p) == (ORD#Offset(o) < ORD#Offset(p)))
     && (ORD#Less(o, p) && ORD#IsNat(p) ==> ORD#IsNat(o)));

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Less(o, p), ORD#Less(p, o) } 
  ORD#Less(o, p) || o == p || ORD#Less(p, o));

axiom (forall o: ORDINAL, p: ORDINAL, r: ORDINAL :: 
  { ORD#Less(o, p), ORD#Less(p, r) } { ORD#Less(o, p), ORD#Less(o, r) } 
  ORD#Less(o, p) && ORD#Less(p, r) ==> ORD#Less(o, r));

function ORD#LessThanLimit(ORDINAL, ORDINAL) : bool;

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#LessThanLimit(o, p) } 
  ORD#LessThanLimit(o, p) == ORD#Less(o, p));

function ORD#Plus(ORDINAL, ORDINAL) : ORDINAL;

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Plus(o, p) } 
  (ORD#IsNat(ORD#Plus(o, p)) ==> ORD#IsNat(o) && ORD#IsNat(p))
     && (ORD#IsNat(p)
       ==> ORD#IsNat(ORD#Plus(o, p)) == ORD#IsNat(o)
         && ORD#Offset(ORD#Plus(o, p)) == ORD#Offset(o) + ORD#Offset(p)));

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Plus(o, p) } 
  (o == ORD#Plus(o, p) || ORD#Less(o, ORD#Plus(o, p)))
     && (p == ORD#Plus(o, p) || ORD#Less(p, ORD#Plus(o, p))));

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Plus(o, p) } 
  (o == ORD#FromNat(0) ==> ORD#Plus(o, p) == p)
     && (p == ORD#FromNat(0) ==> ORD#Plus(o, p) == o));

function ORD#Minus(ORDINAL, ORDINAL) : ORDINAL;

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Minus(o, p) } 
  ORD#IsNat(p) && ORD#Offset(p) <= ORD#Offset(o)
     ==> ORD#IsNat(ORD#Minus(o, p)) == ORD#IsNat(o)
       && ORD#Offset(ORD#Minus(o, p)) == ORD#Offset(o) - ORD#Offset(p));

axiom (forall o: ORDINAL, p: ORDINAL :: 
  { ORD#Minus(o, p) } 
  ORD#IsNat(p) && ORD#Offset(p) <= ORD#Offset(o)
     ==> (p == ORD#FromNat(0) && ORD#Minus(o, p) == o)
       || (p != ORD#FromNat(0) && ORD#Less(ORD#Minus(o, p), o)));

axiom (forall o: ORDINAL, m: int, n: int :: 
  { ORD#Plus(ORD#Plus(o, ORD#FromNat(m)), ORD#FromNat(n)) } 
  0 <= m && 0 <= n
     ==> ORD#Plus(ORD#Plus(o, ORD#FromNat(m)), ORD#FromNat(n))
       == ORD#Plus(o, ORD#FromNat(m + n)));

axiom (forall o: ORDINAL, m: int, n: int :: 
  { ORD#Minus(ORD#Minus(o, ORD#FromNat(m)), ORD#FromNat(n)) } 
  0 <= m && 0 <= n && m + n <= ORD#Offset(o)
     ==> ORD#Minus(ORD#Minus(o, ORD#FromNat(m)), ORD#FromNat(n))
       == ORD#Minus(o, ORD#FromNat(m + n)));

axiom (forall o: ORDINAL, m: int, n: int :: 
  { ORD#Minus(ORD#Plus(o, ORD#FromNat(m)), ORD#FromNat(n)) } 
  0 <= m && 0 <= n && n <= ORD#Offset(o) + m
     ==> (0 <= m - n
         ==> ORD#Minus(ORD#Plus(o, ORD#FromNat(m)), ORD#FromNat(n))
           == ORD#Plus(o, ORD#FromNat(m - n)))
       && (m - n <= 0
         ==> ORD#Minus(ORD#Plus(o, ORD#FromNat(m)), ORD#FromNat(n))
           == ORD#Minus(o, ORD#FromNat(n - m))));

axiom (forall o: ORDINAL, m: int, n: int :: 
  { ORD#Plus(ORD#Minus(o, ORD#FromNat(m)), ORD#FromNat(n)) } 
  0 <= m && 0 <= n && n <= ORD#Offset(o) + m
     ==> (0 <= m - n
         ==> ORD#Plus(ORD#Minus(o, ORD#FromNat(m)), ORD#FromNat(n))
           == ORD#Minus(o, ORD#FromNat(m - n)))
       && (m - n <= 0
         ==> ORD#Plus(ORD#Minus(o, ORD#FromNat(m)), ORD#FromNat(n))
           == ORD#Plus(o, ORD#FromNat(n - m))));

const $ModuleContextHeight: int;

const $FunctionContextHeight: int;

type LayerType;

const $LZ: LayerType;

function $LS(LayerType) : LayerType;

function AsFuelBottom(LayerType) : LayerType;

function AtLayer<A>([LayerType]A, LayerType) : A;

axiom (forall<A> f: [LayerType]A, ly: LayerType :: 
  { AtLayer(f, ly) } 
  AtLayer(f, ly) == f[ly]);

axiom (forall<A> f: [LayerType]A, ly: LayerType :: 
  { AtLayer(f, $LS(ly)) } 
  AtLayer(f, $LS(ly)) == AtLayer(f, ly));

type Field _;

axiom FDim(alloc) == 0;

function FDim<T>(Field T) : int;

function IndexField(int) : Field Box;

axiom (forall i: int :: { IndexField(i) } FDim(IndexField(i)) == 1);

function IndexField_Inverse<T>(Field T) : int;

axiom (forall i: int :: { IndexField(i) } IndexField_Inverse(IndexField(i)) == i);

function MultiIndexField(Field Box, int) : Field Box;

axiom (forall f: Field Box, i: int :: 
  { MultiIndexField(f, i) } 
  FDim(MultiIndexField(f, i)) == FDim(f) + 1);

function MultiIndexField_Inverse0<T>(Field T) : Field T;

function MultiIndexField_Inverse1<T>(Field T) : int;

axiom (forall f: Field Box, i: int :: 
  { MultiIndexField(f, i) } 
  MultiIndexField_Inverse0(MultiIndexField(f, i)) == f
     && MultiIndexField_Inverse1(MultiIndexField(f, i)) == i);

function DeclType<T>(Field T) : ClassName;

type NameFamily;

axiom DeclName(alloc) == allocName;

function DeclName<T>(Field T) : NameFamily;

function FieldOfDecl<alpha>(ClassName, NameFamily) : Field alpha;

axiom (forall<T> cl: ClassName, nm: NameFamily :: 
  { FieldOfDecl(cl, nm): Field T } 
  DeclType(FieldOfDecl(cl, nm): Field T) == cl
     && DeclName(FieldOfDecl(cl, nm): Field T) == nm);

axiom $IsGhostField(alloc);

axiom (forall h: Heap, k: Heap :: 
  { $HeapSuccGhost(h, k) } 
  $HeapSuccGhost(h, k)
     ==> $HeapSucc(h, k)
       && (forall<alpha> o: ref, f: Field alpha :: 
        { read(k, o, f) } 
        !$IsGhostField(f) ==> read(h, o, f) == read(k, o, f)));

function $IsGhostField<T>(Field T) : bool;

axiom (forall<T> h: Heap, k: Heap, v: T, t: Ty :: 
  { $HeapSucc(h, k), $IsAlloc(v, t, h) } 
  $HeapSucc(h, k) ==> $IsAlloc(v, t, h) ==> $IsAlloc(v, t, k));

axiom (forall h: Heap, k: Heap, bx: Box, t: Ty :: 
  { $HeapSucc(h, k), $IsAllocBox(bx, t, h) } 
  $HeapSucc(h, k) ==> $IsAllocBox(bx, t, h) ==> $IsAllocBox(bx, t, k));

const unique alloc: Field bool;

const unique allocName: NameFamily;

axiom (forall o: ref :: 0 <= _System.array.Length(o));

function _System.array.Length(a: ref) : int;

function Int(x: real) : int;

axiom (forall x: real :: { Int(x): int } Int(x): int == int(x));

function Real(x: int) : real;

axiom (forall x: int :: { Real(x): real } Real(x): real == real(x));

axiom (forall i: int :: { Int(Real(i)) } Int(Real(i)) == i);

function {:inline} _System.real.Floor(x: real) : int
{
  Int(x)
}

type Heap = [ref]<alpha>[Field alpha]alpha;

function {:inline} read<alpha>(H: Heap, r: ref, f: Field alpha) : alpha
{
  H[r][f]
}

function {:inline} update<alpha>(H: Heap, r: ref, f: Field alpha, v: alpha) : Heap
{
  H[r := H[r][f := v]]
}

function $IsGoodHeap(Heap) : bool;

function $IsHeapAnchor(Heap) : bool;

var $Heap: Heap where $IsGoodHeap($Heap) && $IsHeapAnchor($Heap);

const $OneHeap: Heap;

axiom $IsGoodHeap($OneHeap);

function $HeapSucc(Heap, Heap) : bool;

axiom (forall<alpha> h: Heap, r: ref, f: Field alpha, x: alpha :: 
  { update(h, r, f, x) } 
  $IsGoodHeap(update(h, r, f, x)) ==> $HeapSucc(h, update(h, r, f, x)));

axiom (forall a: Heap, b: Heap, c: Heap :: 
  { $HeapSucc(a, b), $HeapSucc(b, c) } 
  a != c ==> $HeapSucc(a, b) && $HeapSucc(b, c) ==> $HeapSucc(a, c));

axiom (forall h: Heap, k: Heap :: 
  { $HeapSucc(h, k) } 
  $HeapSucc(h, k)
     ==> (forall o: ref :: { read(k, o, alloc) } read(h, o, alloc) ==> read(k, o, alloc)));

function $HeapSuccGhost(Heap, Heap) : bool;

type TickType;

var $Tick: TickType;

procedure $YieldHavoc(this: ref, rds: Set Box, nw: Set Box);
  modifies $Heap;
  ensures (forall<alpha> $o: ref, $f: Field alpha :: 
    { read($Heap, $o, $f) } 
    $o != null && read(old($Heap), $o, alloc)
       ==> 
      $o == this || rds[$Box($o)] || nw[$Box($o)]
       ==> read($Heap, $o, $f) == read(old($Heap), $o, $f));
  ensures $HeapSucc(old($Heap), $Heap);



procedure $IterHavoc0(this: ref, rds: Set Box, modi: Set Box);
  modifies $Heap;
  ensures (forall<alpha> $o: ref, $f: Field alpha :: 
    { read($Heap, $o, $f) } 
    $o != null && read(old($Heap), $o, alloc)
       ==> 
      rds[$Box($o)] && !modi[$Box($o)] && $o != this
       ==> read($Heap, $o, $f) == read(old($Heap), $o, $f));
  ensures $HeapSucc(old($Heap), $Heap);



procedure $IterHavoc1(this: ref, modi: Set Box, nw: Set Box);
  modifies $Heap;
  ensures (forall<alpha> $o: ref, $f: Field alpha :: 
    { read($Heap, $o, $f) } 
    $o != null && read(old($Heap), $o, alloc)
       ==> read($Heap, $o, $f) == read(old($Heap), $o, $f)
         || $o == this
         || modi[$Box($o)]
         || nw[$Box($o)]);
  ensures $HeapSucc(old($Heap), $Heap);



procedure $IterCollectNewObjects(prevHeap: Heap, newHeap: Heap, this: ref, NW: Field (Set Box))
   returns (s: Set Box);
  ensures (forall bx: Box :: 
    { s[bx] } 
    s[bx]
       <==> read(newHeap, this, NW)[bx]
         || (
          $Unbox(bx) != null
           && !read(prevHeap, $Unbox(bx): ref, alloc)
           && read(newHeap, $Unbox(bx): ref, alloc)));



type Set T = [T]bool;

function Set#Card<T>(Set T) : int;

axiom (forall<T> s: Set T :: { Set#Card(s) } 0 <= Set#Card(s));

function Set#Empty<T>() : Set T;

axiom (forall<T> o: T :: { Set#Empty()[o] } !Set#Empty()[o]);

axiom (forall<T> s: Set T :: 
  { Set#Card(s) } 
  (Set#Card(s) == 0 <==> s == Set#Empty())
     && (Set#Card(s) != 0 ==> (exists x: T :: s[x])));

function Set#Singleton<T>(T) : Set T;

axiom (forall<T> r: T :: { Set#Singleton(r) } Set#Singleton(r)[r]);

axiom (forall<T> r: T, o: T :: 
  { Set#Singleton(r)[o] } 
  Set#Singleton(r)[o] <==> r == o);

axiom (forall<T> r: T :: 
  { Set#Card(Set#Singleton(r)) } 
  Set#Card(Set#Singleton(r)) == 1);

function Set#UnionOne<T>(Set T, T) : Set T;

axiom (forall<T> a: Set T, x: T, o: T :: 
  { Set#UnionOne(a, x)[o] } 
  Set#UnionOne(a, x)[o] <==> o == x || a[o]);

axiom (forall<T> a: Set T, x: T :: { Set#UnionOne(a, x) } Set#UnionOne(a, x)[x]);

axiom (forall<T> a: Set T, x: T, y: T :: 
  { Set#UnionOne(a, x), a[y] } 
  a[y] ==> Set#UnionOne(a, x)[y]);

axiom (forall<T> a: Set T, x: T :: 
  { Set#Card(Set#UnionOne(a, x)) } 
  a[x] ==> Set#Card(Set#UnionOne(a, x)) == Set#Card(a));

axiom (forall<T> a: Set T, x: T :: 
  { Set#Card(Set#UnionOne(a, x)) } 
  !a[x] ==> Set#Card(Set#UnionOne(a, x)) == Set#Card(a) + 1);

function Set#Union<T>(Set T, Set T) : Set T;

axiom (forall<T> a: Set T, b: Set T, o: T :: 
  { Set#Union(a, b)[o] } 
  Set#Union(a, b)[o] <==> a[o] || b[o]);

axiom (forall<T> a: Set T, b: Set T, y: T :: 
  { Set#Union(a, b), a[y] } 
  a[y] ==> Set#Union(a, b)[y]);

axiom (forall<T> a: Set T, b: Set T, y: T :: 
  { Set#Union(a, b), b[y] } 
  b[y] ==> Set#Union(a, b)[y]);

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Union(a, b) } 
  Set#Disjoint(a, b)
     ==> Set#Difference(Set#Union(a, b), a) == b
       && Set#Difference(Set#Union(a, b), b) == a);

function Set#Intersection<T>(Set T, Set T) : Set T;

axiom (forall<T> a: Set T, b: Set T, o: T :: 
  { Set#Intersection(a, b)[o] } 
  Set#Intersection(a, b)[o] <==> a[o] && b[o]);

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Union(Set#Union(a, b), b) } 
  Set#Union(Set#Union(a, b), b) == Set#Union(a, b));

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Union(a, Set#Union(a, b)) } 
  Set#Union(a, Set#Union(a, b)) == Set#Union(a, b));

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Intersection(Set#Intersection(a, b), b) } 
  Set#Intersection(Set#Intersection(a, b), b) == Set#Intersection(a, b));

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Intersection(a, Set#Intersection(a, b)) } 
  Set#Intersection(a, Set#Intersection(a, b)) == Set#Intersection(a, b));

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Card(Set#Union(a, b)) } { Set#Card(Set#Intersection(a, b)) } 
  Set#Card(Set#Union(a, b)) + Set#Card(Set#Intersection(a, b))
     == Set#Card(a) + Set#Card(b));

function Set#Difference<T>(Set T, Set T) : Set T;

axiom (forall<T> a: Set T, b: Set T, o: T :: 
  { Set#Difference(a, b)[o] } 
  Set#Difference(a, b)[o] <==> a[o] && !b[o]);

axiom (forall<T> a: Set T, b: Set T, y: T :: 
  { Set#Difference(a, b), b[y] } 
  b[y] ==> !Set#Difference(a, b)[y]);

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Card(Set#Difference(a, b)) } 
  Set#Card(Set#Difference(a, b))
         + Set#Card(Set#Difference(b, a))
         + Set#Card(Set#Intersection(a, b))
       == Set#Card(Set#Union(a, b))
     && Set#Card(Set#Difference(a, b)) == Set#Card(a) - Set#Card(Set#Intersection(a, b)));

function Set#Subset<T>(Set T, Set T) : bool;

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Subset(a, b) } 
  Set#Subset(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] ==> b[o]));

function Set#Equal<T>(Set T, Set T) : bool;

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Equal(a, b) } 
  Set#Equal(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] <==> b[o]));

axiom (forall<T> a: Set T, b: Set T :: { Set#Equal(a, b) } Set#Equal(a, b) ==> a == b);

function Set#Disjoint<T>(Set T, Set T) : bool;

axiom (forall<T> a: Set T, b: Set T :: 
  { Set#Disjoint(a, b) } 
  Set#Disjoint(a, b) <==> (forall o: T :: { a[o] } { b[o] } !a[o] || !b[o]));

type ISet T = [T]bool;

function ISet#Empty<T>() : Set T;

axiom (forall<T> o: T :: { ISet#Empty()[o] } !ISet#Empty()[o]);

function ISet#UnionOne<T>(ISet T, T) : ISet T;

axiom (forall<T> a: ISet T, x: T, o: T :: 
  { ISet#UnionOne(a, x)[o] } 
  ISet#UnionOne(a, x)[o] <==> o == x || a[o]);

axiom (forall<T> a: ISet T, x: T :: { ISet#UnionOne(a, x) } ISet#UnionOne(a, x)[x]);

axiom (forall<T> a: ISet T, x: T, y: T :: 
  { ISet#UnionOne(a, x), a[y] } 
  a[y] ==> ISet#UnionOne(a, x)[y]);

function ISet#Union<T>(ISet T, ISet T) : ISet T;

axiom (forall<T> a: ISet T, b: ISet T, o: T :: 
  { ISet#Union(a, b)[o] } 
  ISet#Union(a, b)[o] <==> a[o] || b[o]);

axiom (forall<T> a: ISet T, b: ISet T, y: T :: 
  { ISet#Union(a, b), a[y] } 
  a[y] ==> ISet#Union(a, b)[y]);

axiom (forall<T> a: Set T, b: Set T, y: T :: 
  { ISet#Union(a, b), b[y] } 
  b[y] ==> ISet#Union(a, b)[y]);

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Union(a, b) } 
  ISet#Disjoint(a, b)
     ==> ISet#Difference(ISet#Union(a, b), a) == b
       && ISet#Difference(ISet#Union(a, b), b) == a);

function ISet#Intersection<T>(ISet T, ISet T) : ISet T;

axiom (forall<T> a: ISet T, b: ISet T, o: T :: 
  { ISet#Intersection(a, b)[o] } 
  ISet#Intersection(a, b)[o] <==> a[o] && b[o]);

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Union(ISet#Union(a, b), b) } 
  ISet#Union(ISet#Union(a, b), b) == ISet#Union(a, b));

axiom (forall<T> a: Set T, b: Set T :: 
  { ISet#Union(a, ISet#Union(a, b)) } 
  ISet#Union(a, ISet#Union(a, b)) == ISet#Union(a, b));

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Intersection(ISet#Intersection(a, b), b) } 
  ISet#Intersection(ISet#Intersection(a, b), b) == ISet#Intersection(a, b));

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Intersection(a, ISet#Intersection(a, b)) } 
  ISet#Intersection(a, ISet#Intersection(a, b)) == ISet#Intersection(a, b));

function ISet#Difference<T>(ISet T, ISet T) : ISet T;

axiom (forall<T> a: ISet T, b: ISet T, o: T :: 
  { ISet#Difference(a, b)[o] } 
  ISet#Difference(a, b)[o] <==> a[o] && !b[o]);

axiom (forall<T> a: ISet T, b: ISet T, y: T :: 
  { ISet#Difference(a, b), b[y] } 
  b[y] ==> !ISet#Difference(a, b)[y]);

function ISet#Subset<T>(ISet T, ISet T) : bool;

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Subset(a, b) } 
  ISet#Subset(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] ==> b[o]));

function ISet#Equal<T>(ISet T, ISet T) : bool;

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Equal(a, b) } 
  ISet#Equal(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] <==> b[o]));

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Equal(a, b) } 
  ISet#Equal(a, b) ==> a == b);

function ISet#Disjoint<T>(ISet T, ISet T) : bool;

axiom (forall<T> a: ISet T, b: ISet T :: 
  { ISet#Disjoint(a, b) } 
  ISet#Disjoint(a, b) <==> (forall o: T :: { a[o] } { b[o] } !a[o] || !b[o]));

function Math#min(a: int, b: int) : int;

axiom (forall a: int, b: int :: { Math#min(a, b) } a <= b <==> Math#min(a, b) == a);

axiom (forall a: int, b: int :: { Math#min(a, b) } b <= a <==> Math#min(a, b) == b);

axiom (forall a: int, b: int :: 
  { Math#min(a, b) } 
  Math#min(a, b) == a || Math#min(a, b) == b);

function Math#clip(a: int) : int;

axiom (forall a: int :: { Math#clip(a) } 0 <= a ==> Math#clip(a) == a);

axiom (forall a: int :: { Math#clip(a) } a < 0 ==> Math#clip(a) == 0);

type MultiSet T = [T]int;

function $IsGoodMultiSet<T>(ms: MultiSet T) : bool;

axiom (forall<T> ms: MultiSet T :: 
  { $IsGoodMultiSet(ms) } 
  $IsGoodMultiSet(ms)
     <==> (forall bx: T :: { ms[bx] } 0 <= ms[bx] && ms[bx] <= MultiSet#Card(ms)));

function MultiSet#Card<T>(MultiSet T) : int;

axiom (forall<T> s: MultiSet T :: { MultiSet#Card(s) } 0 <= MultiSet#Card(s));

axiom (forall<T> s: MultiSet T, x: T, n: int :: 
  { MultiSet#Card(s[x := n]) } 
  0 <= n ==> MultiSet#Card(s[x := n]) == MultiSet#Card(s) - s[x] + n);

function MultiSet#Empty<T>() : MultiSet T;

axiom (forall<T> o: T :: { MultiSet#Empty()[o] } MultiSet#Empty()[o] == 0);

axiom (forall<T> s: MultiSet T :: 
  { MultiSet#Card(s) } 
  (MultiSet#Card(s) == 0 <==> s == MultiSet#Empty())
     && (MultiSet#Card(s) != 0 ==> (exists x: T :: 0 < s[x])));

function MultiSet#Singleton<T>(T) : MultiSet T;

axiom (forall<T> r: T, o: T :: 
  { MultiSet#Singleton(r)[o] } 
  (MultiSet#Singleton(r)[o] == 1 <==> r == o)
     && (MultiSet#Singleton(r)[o] == 0 <==> r != o));

axiom (forall<T> r: T :: 
  { MultiSet#Singleton(r) } 
  MultiSet#Singleton(r) == MultiSet#UnionOne(MultiSet#Empty(), r));

function MultiSet#UnionOne<T>(MultiSet T, T) : MultiSet T;

axiom (forall<T> a: MultiSet T, x: T, o: T :: 
  { MultiSet#UnionOne(a, x)[o] } 
  0 < MultiSet#UnionOne(a, x)[o] <==> o == x || 0 < a[o]);

axiom (forall<T> a: MultiSet T, x: T :: 
  { MultiSet#UnionOne(a, x) } 
  MultiSet#UnionOne(a, x)[x] == a[x] + 1);

axiom (forall<T> a: MultiSet T, x: T, y: T :: 
  { MultiSet#UnionOne(a, x), a[y] } 
  0 < a[y] ==> 0 < MultiSet#UnionOne(a, x)[y]);

axiom (forall<T> a: MultiSet T, x: T, y: T :: 
  { MultiSet#UnionOne(a, x), a[y] } 
  x != y ==> a[y] == MultiSet#UnionOne(a, x)[y]);

axiom (forall<T> a: MultiSet T, x: T :: 
  { MultiSet#Card(MultiSet#UnionOne(a, x)) } 
  MultiSet#Card(MultiSet#UnionOne(a, x)) == MultiSet#Card(a) + 1);

function MultiSet#Union<T>(MultiSet T, MultiSet T) : MultiSet T;

axiom (forall<T> a: MultiSet T, b: MultiSet T, o: T :: 
  { MultiSet#Union(a, b)[o] } 
  MultiSet#Union(a, b)[o] == a[o] + b[o]);

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Card(MultiSet#Union(a, b)) } 
  MultiSet#Card(MultiSet#Union(a, b)) == MultiSet#Card(a) + MultiSet#Card(b));

function MultiSet#Intersection<T>(MultiSet T, MultiSet T) : MultiSet T;

axiom (forall<T> a: MultiSet T, b: MultiSet T, o: T :: 
  { MultiSet#Intersection(a, b)[o] } 
  MultiSet#Intersection(a, b)[o] == Math#min(a[o], b[o]));

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Intersection(MultiSet#Intersection(a, b), b) } 
  MultiSet#Intersection(MultiSet#Intersection(a, b), b)
     == MultiSet#Intersection(a, b));

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Intersection(a, MultiSet#Intersection(a, b)) } 
  MultiSet#Intersection(a, MultiSet#Intersection(a, b))
     == MultiSet#Intersection(a, b));

function MultiSet#Difference<T>(MultiSet T, MultiSet T) : MultiSet T;

axiom (forall<T> a: MultiSet T, b: MultiSet T, o: T :: 
  { MultiSet#Difference(a, b)[o] } 
  MultiSet#Difference(a, b)[o] == Math#clip(a[o] - b[o]));

axiom (forall<T> a: MultiSet T, b: MultiSet T, y: T :: 
  { MultiSet#Difference(a, b), b[y], a[y] } 
  a[y] <= b[y] ==> MultiSet#Difference(a, b)[y] == 0);

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Card(MultiSet#Difference(a, b)) } 
  MultiSet#Card(MultiSet#Difference(a, b))
         + MultiSet#Card(MultiSet#Difference(b, a))
         + 2 * MultiSet#Card(MultiSet#Intersection(a, b))
       == MultiSet#Card(MultiSet#Union(a, b))
     && MultiSet#Card(MultiSet#Difference(a, b))
       == MultiSet#Card(a) - MultiSet#Card(MultiSet#Intersection(a, b)));

function MultiSet#Subset<T>(MultiSet T, MultiSet T) : bool;

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Subset(a, b) } 
  MultiSet#Subset(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] <= b[o]));

function MultiSet#Equal<T>(MultiSet T, MultiSet T) : bool;

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Equal(a, b) } 
  MultiSet#Equal(a, b) <==> (forall o: T :: { a[o] } { b[o] } a[o] == b[o]));

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Equal(a, b) } 
  MultiSet#Equal(a, b) ==> a == b);

function MultiSet#Disjoint<T>(MultiSet T, MultiSet T) : bool;

axiom (forall<T> a: MultiSet T, b: MultiSet T :: 
  { MultiSet#Disjoint(a, b) } 
  MultiSet#Disjoint(a, b)
     <==> (forall o: T :: { a[o] } { b[o] } a[o] == 0 || b[o] == 0));

function MultiSet#FromSet<T>(Set T) : MultiSet T;

axiom (forall<T> s: Set T, a: T :: 
  { MultiSet#FromSet(s)[a] } 
  (MultiSet#FromSet(s)[a] == 0 <==> !s[a])
     && (MultiSet#FromSet(s)[a] == 1 <==> s[a]));

axiom (forall<T> s: Set T :: 
  { MultiSet#Card(MultiSet#FromSet(s)) } 
  MultiSet#Card(MultiSet#FromSet(s)) == Set#Card(s));

axiom (forall<T>  :: 
  MultiSet#FromSeq(Seq#Empty(): Seq T) == MultiSet#Empty(): MultiSet T);

function MultiSet#FromSeq<T>(Seq T) : MultiSet T;

axiom (forall<T> s: Seq T :: 
  { MultiSet#FromSeq(s) } 
  $IsGoodMultiSet(MultiSet#FromSeq(s)));

axiom (forall<T> s: Seq T :: 
  { MultiSet#Card(MultiSet#FromSeq(s)) } 
  MultiSet#Card(MultiSet#FromSeq(s)) == Seq#Length(s));

axiom (forall<T> s: Seq T, v: T :: 
  { MultiSet#FromSeq(Seq#Build(s, v)) } 
  MultiSet#FromSeq(Seq#Build(s, v)) == MultiSet#UnionOne(MultiSet#FromSeq(s), v));

axiom (forall<T> a: Seq T, b: Seq T :: 
  { MultiSet#FromSeq(Seq#Append(a, b)) } 
  MultiSet#FromSeq(Seq#Append(a, b))
     == MultiSet#Union(MultiSet#FromSeq(a), MultiSet#FromSeq(b)));

axiom (forall<T> s: Seq T, i: int, v: T, x: T :: 
  { MultiSet#FromSeq(Seq#Update(s, i, v))[x] } 
  0 <= i && i < Seq#Length(s)
     ==> MultiSet#FromSeq(Seq#Update(s, i, v))[x]
       == MultiSet#Union(MultiSet#Difference(MultiSet#FromSeq(s), MultiSet#Singleton(Seq#Index(s, i))), 
        MultiSet#Singleton(v))[x]);

axiom (forall<T> s: Seq T, x: T :: 
  { MultiSet#FromSeq(s)[x] } 
  (exists i: int :: 
      { Seq#Index(s, i) } 
      0 <= i && i < Seq#Length(s) && x == Seq#Index(s, i))
     <==> 0 < MultiSet#FromSeq(s)[x]);

type Seq _;

function Seq#Length<T>(Seq T) : int;

axiom (forall<T> s: Seq T :: { Seq#Length(s) } 0 <= Seq#Length(s));

function Seq#Empty<T>() : Seq T;

axiom (forall<T>  :: { Seq#Empty(): Seq T } Seq#Length(Seq#Empty(): Seq T) == 0);

axiom (forall<T> s: Seq T :: 
  { Seq#Length(s) } 
  Seq#Length(s) == 0 ==> s == Seq#Empty());

function Seq#Singleton<T>(T) : Seq T;

axiom (forall<T> t: T :: 
  { Seq#Length(Seq#Singleton(t)) } 
  Seq#Length(Seq#Singleton(t)) == 1);

function Seq#Build<T>(s: Seq T, val: T) : Seq T;

function Seq#Build_inv0<T>(s: Seq T) : Seq T;

function Seq#Build_inv1<T>(s: Seq T) : T;

axiom (forall<T> s: Seq T, val: T :: 
  { Seq#Build(s, val) } 
  Seq#Build_inv0(Seq#Build(s, val)) == s
     && Seq#Build_inv1(Seq#Build(s, val)) == val);

axiom (forall<T> s: Seq T, v: T :: 
  { Seq#Build(s, v) } 
  Seq#Length(Seq#Build(s, v)) == 1 + Seq#Length(s));

axiom (forall<T> s: Seq T, i: int, v: T :: 
  { Seq#Index(Seq#Build(s, v), i) } 
  (i == Seq#Length(s) ==> Seq#Index(Seq#Build(s, v), i) == v)
     && (i != Seq#Length(s) ==> Seq#Index(Seq#Build(s, v), i) == Seq#Index(s, i)));

axiom (forall s: Seq Box, bx: Box, t: Ty :: 
  { $Is(Seq#Build(s, bx), TSeq(t)) } 
  $Is(s, TSeq(t)) && $IsBox(bx, t) ==> $Is(Seq#Build(s, bx), TSeq(t)));

function Seq#Create(ty: Ty, heap: Heap, len: int, init: HandleType) : Seq Box;

axiom (forall ty: Ty, heap: Heap, len: int, init: HandleType :: 
  { Seq#Length(Seq#Create(ty, heap, len, init): Seq Box) } 
  $IsGoodHeap(heap) && 0 <= len
     ==> Seq#Length(Seq#Create(ty, heap, len, init): Seq Box) == len);

axiom (forall ty: Ty, heap: Heap, len: int, init: HandleType, i: int :: 
  { Seq#Index(Seq#Create(ty, heap, len, init), i) } 
  $IsGoodHeap(heap) && 0 <= i && i < len
     ==> Seq#Index(Seq#Create(ty, heap, len, init), i)
       == Apply1(TInt, TSeq(ty), heap, init, $Box(i)));

function Seq#Append<T>(Seq T, Seq T) : Seq T;

axiom (forall<T> s0: Seq T, s1: Seq T :: 
  { Seq#Length(Seq#Append(s0, s1)) } 
  Seq#Length(Seq#Append(s0, s1)) == Seq#Length(s0) + Seq#Length(s1));

function Seq#Index<T>(Seq T, int) : T;

axiom (forall<T> t: T :: 
  { Seq#Index(Seq#Singleton(t), 0) } 
  Seq#Index(Seq#Singleton(t), 0) == t);

axiom (forall<T> s0: Seq T, s1: Seq T, n: int :: 
  { Seq#Index(Seq#Append(s0, s1), n) } 
  (n < Seq#Length(s0) ==> Seq#Index(Seq#Append(s0, s1), n) == Seq#Index(s0, n))
     && (Seq#Length(s0) <= n
       ==> Seq#Index(Seq#Append(s0, s1), n) == Seq#Index(s1, n - Seq#Length(s0))));

function Seq#Update<T>(Seq T, int, T) : Seq T;

axiom (forall<T> s: Seq T, i: int, v: T :: 
  { Seq#Length(Seq#Update(s, i, v)) } 
  0 <= i && i < Seq#Length(s) ==> Seq#Length(Seq#Update(s, i, v)) == Seq#Length(s));

axiom (forall<T> s: Seq T, i: int, v: T, n: int :: 
  { Seq#Index(Seq#Update(s, i, v), n) } 
  0 <= n && n < Seq#Length(s)
     ==> (i == n ==> Seq#Index(Seq#Update(s, i, v), n) == v)
       && (i != n ==> Seq#Index(Seq#Update(s, i, v), n) == Seq#Index(s, n)));

function Seq#Contains<T>(Seq T, T) : bool;

axiom (forall<T> s: Seq T, x: T :: 
  { Seq#Contains(s, x) } 
  Seq#Contains(s, x)
     <==> (exists i: int :: 
      { Seq#Index(s, i) } 
      0 <= i && i < Seq#Length(s) && Seq#Index(s, i) == x));

axiom (forall<T> x: T :: 
  { Seq#Contains(Seq#Empty(), x) } 
  !Seq#Contains(Seq#Empty(), x));

axiom (forall<T> s0: Seq T, s1: Seq T, x: T :: 
  { Seq#Contains(Seq#Append(s0, s1), x) } 
  Seq#Contains(Seq#Append(s0, s1), x)
     <==> Seq#Contains(s0, x) || Seq#Contains(s1, x));

axiom (forall<T> s: Seq T, v: T, x: T :: 
  { Seq#Contains(Seq#Build(s, v), x) } 
  Seq#Contains(Seq#Build(s, v), x) <==> v == x || Seq#Contains(s, x));

axiom (forall<T> s: Seq T, n: int, x: T :: 
  { Seq#Contains(Seq#Take(s, n), x) } 
  Seq#Contains(Seq#Take(s, n), x)
     <==> (exists i: int :: 
      { Seq#Index(s, i) } 
      0 <= i && i < n && i < Seq#Length(s) && Seq#Index(s, i) == x));

axiom (forall<T> s: Seq T, n: int, x: T :: 
  { Seq#Contains(Seq#Drop(s, n), x) } 
  Seq#Contains(Seq#Drop(s, n), x)
     <==> (exists i: int :: 
      { Seq#Index(s, i) } 
      0 <= n && n <= i && i < Seq#Length(s) && Seq#Index(s, i) == x));

function Seq#Equal<T>(Seq T, Seq T) : bool;

axiom (forall<T> s0: Seq T, s1: Seq T :: 
  { Seq#Equal(s0, s1) } 
  Seq#Equal(s0, s1)
     <==> Seq#Length(s0) == Seq#Length(s1)
       && (forall j: int :: 
        { Seq#Index(s0, j) } { Seq#Index(s1, j) } 
        0 <= j && j < Seq#Length(s0) ==> Seq#Index(s0, j) == Seq#Index(s1, j)));

axiom (forall<T> a: Seq T, b: Seq T :: { Seq#Equal(a, b) } Seq#Equal(a, b) ==> a == b);

function Seq#SameUntil<T>(Seq T, Seq T, int) : bool;

axiom (forall<T> s0: Seq T, s1: Seq T, n: int :: 
  { Seq#SameUntil(s0, s1, n) } 
  Seq#SameUntil(s0, s1, n)
     <==> (forall j: int :: 
      { Seq#Index(s0, j) } { Seq#Index(s1, j) } 
      0 <= j && j < n ==> Seq#Index(s0, j) == Seq#Index(s1, j)));

function Seq#Take<T>(s: Seq T, howMany: int) : Seq T;

axiom (forall<T> s: Seq T, n: int :: 
  { Seq#Length(Seq#Take(s, n)) } 
  0 <= n && n <= Seq#Length(s) ==> Seq#Length(Seq#Take(s, n)) == n);

axiom (forall<T> s: Seq T, n: int, j: int :: 
  {:weight 25} { Seq#Index(Seq#Take(s, n), j) } { Seq#Index(s, j), Seq#Take(s, n) } 
  0 <= j && j < n && j < Seq#Length(s)
     ==> Seq#Index(Seq#Take(s, n), j) == Seq#Index(s, j));

function Seq#Drop<T>(s: Seq T, howMany: int) : Seq T;

axiom (forall<T> s: Seq T, n: int :: 
  { Seq#Length(Seq#Drop(s, n)) } 
  0 <= n && n <= Seq#Length(s) ==> Seq#Length(Seq#Drop(s, n)) == Seq#Length(s) - n);

axiom (forall<T> s: Seq T, n: int, j: int :: 
  {:weight 25} { Seq#Index(Seq#Drop(s, n), j) } 
  0 <= n && 0 <= j && j < Seq#Length(s) - n
     ==> Seq#Index(Seq#Drop(s, n), j) == Seq#Index(s, j + n));

axiom (forall<T> s: Seq T, n: int, k: int :: 
  {:weight 25} { Seq#Index(s, k), Seq#Drop(s, n) } 
  0 <= n && n <= k && k < Seq#Length(s)
     ==> Seq#Index(Seq#Drop(s, n), k - n) == Seq#Index(s, k));

axiom (forall<T> s: Seq T, t: Seq T, n: int :: 
  { Seq#Take(Seq#Append(s, t), n) } { Seq#Drop(Seq#Append(s, t), n) } 
  n == Seq#Length(s)
     ==> Seq#Take(Seq#Append(s, t), n) == s && Seq#Drop(Seq#Append(s, t), n) == t);

function Seq#FromArray(h: Heap, a: ref) : Seq Box;

axiom (forall h: Heap, a: ref :: 
  { Seq#Length(Seq#FromArray(h, a)) } 
  Seq#Length(Seq#FromArray(h, a)) == _System.array.Length(a));

axiom (forall h: Heap, a: ref :: 
  { Seq#FromArray(h, a) } 
  (forall i: int :: 
    { read(h, a, IndexField(i)) } { Seq#Index(Seq#FromArray(h, a): Seq Box, i) } 
    0 <= i && i < Seq#Length(Seq#FromArray(h, a))
       ==> Seq#Index(Seq#FromArray(h, a), i) == read(h, a, IndexField(i))));

axiom (forall h0: Heap, h1: Heap, a: ref :: 
  { Seq#FromArray(h1, a), $HeapSucc(h0, h1) } 
  $IsGoodHeap(h0) && $IsGoodHeap(h1) && $HeapSucc(h0, h1) && h0[a] == h1[a]
     ==> Seq#FromArray(h0, a) == Seq#FromArray(h1, a));

axiom (forall h: Heap, i: int, v: Box, a: ref :: 
  { Seq#FromArray(update(h, a, IndexField(i), v), a) } 
  0 <= i && i < _System.array.Length(a)
     ==> Seq#FromArray(update(h, a, IndexField(i), v), a)
       == Seq#Update(Seq#FromArray(h, a), i, v));

axiom (forall<T> s: Seq T, i: int, v: T, n: int :: 
  { Seq#Take(Seq#Update(s, i, v), n) } 
  0 <= i && i < n && n <= Seq#Length(s)
     ==> Seq#Take(Seq#Update(s, i, v), n) == Seq#Update(Seq#Take(s, n), i, v));

axiom (forall<T> s: Seq T, i: int, v: T, n: int :: 
  { Seq#Take(Seq#Update(s, i, v), n) } 
  n <= i && i < Seq#Length(s)
     ==> Seq#Take(Seq#Update(s, i, v), n) == Seq#Take(s, n));

axiom (forall<T> s: Seq T, i: int, v: T, n: int :: 
  { Seq#Drop(Seq#Update(s, i, v), n) } 
  0 <= n && n <= i && i < Seq#Length(s)
     ==> Seq#Drop(Seq#Update(s, i, v), n) == Seq#Update(Seq#Drop(s, n), i - n, v));

axiom (forall<T> s: Seq T, i: int, v: T, n: int :: 
  { Seq#Drop(Seq#Update(s, i, v), n) } 
  0 <= i && i < n && n <= Seq#Length(s)
     ==> Seq#Drop(Seq#Update(s, i, v), n) == Seq#Drop(s, n));

axiom (forall h: Heap, a: ref, n0: int, n1: int :: 
  { Seq#Take(Seq#FromArray(h, a), n0), Seq#Take(Seq#FromArray(h, a), n1) } 
  n0 + 1 == n1 && 0 <= n0 && n1 <= _System.array.Length(a)
     ==> Seq#Take(Seq#FromArray(h, a), n1)
       == Seq#Build(Seq#Take(Seq#FromArray(h, a), n0), read(h, a, IndexField(n0): Field Box)));

axiom (forall<T> s: Seq T, v: T, n: int :: 
  { Seq#Drop(Seq#Build(s, v), n) } 
  0 <= n && n <= Seq#Length(s)
     ==> Seq#Drop(Seq#Build(s, v), n) == Seq#Build(Seq#Drop(s, n), v));

function Seq#Rank<T>(Seq T) : int;

axiom (forall s: Seq Box, i: int :: 
  { DtRank($Unbox(Seq#Index(s, i)): DatatypeType) } 
  0 <= i && i < Seq#Length(s)
     ==> DtRank($Unbox(Seq#Index(s, i)): DatatypeType) < Seq#Rank(s));

axiom (forall<T> s: Seq T, i: int :: 
  { Seq#Rank(Seq#Drop(s, i)) } 
  0 < i && i <= Seq#Length(s) ==> Seq#Rank(Seq#Drop(s, i)) < Seq#Rank(s));

axiom (forall<T> s: Seq T, i: int :: 
  { Seq#Rank(Seq#Take(s, i)) } 
  0 <= i && i < Seq#Length(s) ==> Seq#Rank(Seq#Take(s, i)) < Seq#Rank(s));

axiom (forall<T> s: Seq T, i: int, j: int :: 
  { Seq#Rank(Seq#Append(Seq#Take(s, i), Seq#Drop(s, j))) } 
  0 <= i && i < j && j <= Seq#Length(s)
     ==> Seq#Rank(Seq#Append(Seq#Take(s, i), Seq#Drop(s, j))) < Seq#Rank(s));

axiom (forall<T> s: Seq T, n: int :: 
  { Seq#Drop(s, n) } 
  n == 0 ==> Seq#Drop(s, n) == s);

axiom (forall<T> s: Seq T, n: int :: 
  { Seq#Take(s, n) } 
  n == 0 ==> Seq#Take(s, n) == Seq#Empty());

axiom (forall<T> s: Seq T, m: int, n: int :: 
  { Seq#Drop(Seq#Drop(s, m), n) } 
  0 <= m && 0 <= n && m + n <= Seq#Length(s)
     ==> Seq#Drop(Seq#Drop(s, m), n) == Seq#Drop(s, m + n));

type Map _ _;

function Map#Domain<U,V>(Map U V) : Set U;

function Map#Elements<U,V>(Map U V) : [U]V;

function Map#Card<U,V>(Map U V) : int;

axiom (forall<U,V> m: Map U V :: { Map#Card(m) } 0 <= Map#Card(m));

axiom (forall<U,V> m: Map U V :: 
  { Map#Card(m) } 
  Map#Card(m) == 0 <==> m == Map#Empty());

axiom (forall<U,V> m: Map U V :: 
  { Map#Domain(m) } 
  m == Map#Empty() || (exists k: U :: Map#Domain(m)[k]));

axiom (forall<U,V> m: Map U V :: 
  { Map#Values(m) } 
  m == Map#Empty() || (exists v: V :: Map#Values(m)[v]));

axiom (forall<U,V> m: Map U V :: 
  { Map#Items(m) } 
  m == Map#Empty()
     || (exists k: Box, v: Box :: Map#Items(m)[$Box(#_System._tuple#2._#Make2(k, v))]));

axiom (forall<U,V> m: Map U V :: 
  { Set#Card(Map#Domain(m)) } 
  Set#Card(Map#Domain(m)) == Map#Card(m));

axiom (forall<U,V> m: Map U V :: 
  { Set#Card(Map#Values(m)) } 
  Set#Card(Map#Values(m)) <= Map#Card(m));

axiom (forall<U,V> m: Map U V :: 
  { Set#Card(Map#Items(m)) } 
  Set#Card(Map#Items(m)) == Map#Card(m));

function Map#Values<U,V>(Map U V) : Set V;

axiom (forall<U,V> m: Map U V, v: V :: 
  { Map#Values(m)[v] } 
  Map#Values(m)[v]
     == (exists u: U :: 
      { Map#Domain(m)[u] } { Map#Elements(m)[u] } 
      Map#Domain(m)[u] && v == Map#Elements(m)[u]));

function Map#Items<U,V>(Map U V) : Set Box;

function #_System._tuple#2._#Make2(Box, Box) : DatatypeType;

function _System.Tuple2._0(DatatypeType) : Box;

function _System.Tuple2._1(DatatypeType) : Box;

axiom (forall m: Map Box Box, item: Box :: 
  { Map#Items(m)[item] } 
  Map#Items(m)[item]
     <==> Map#Domain(m)[_System.Tuple2._0($Unbox(item))]
       && Map#Elements(m)[_System.Tuple2._0($Unbox(item))]
         == _System.Tuple2._1($Unbox(item)));

function Map#Empty<U,V>() : Map U V;

axiom (forall<U,V> u: U :: 
  { Map#Domain(Map#Empty(): Map U V)[u] } 
  !Map#Domain(Map#Empty(): Map U V)[u]);

function Map#Glue<U,V>([U]bool, [U]V, Ty) : Map U V;

axiom (forall<U,V> a: [U]bool, b: [U]V, t: Ty :: 
  { Map#Domain(Map#Glue(a, b, t)) } 
  Map#Domain(Map#Glue(a, b, t)) == a);

axiom (forall<U,V> a: [U]bool, b: [U]V, t: Ty :: 
  { Map#Elements(Map#Glue(a, b, t)) } 
  Map#Elements(Map#Glue(a, b, t)) == b);

axiom (forall a: [Box]bool, b: [Box]Box, t0: Ty, t1: Ty :: 
  { Map#Glue(a, b, TMap(t0, t1)) } 
  (forall bx: Box :: a[bx] ==> $IsBox(bx, t0) && $IsBox(b[bx], t1))
     ==> $Is(Map#Glue(a, b, TMap(t0, t1)), TMap(t0, t1)));

function Map#Build<U,V>(Map U V, U, V) : Map U V;

axiom (forall<U,V> m: Map U V, u: U, u': U, v: V :: 
  { Map#Domain(Map#Build(m, u, v))[u'] } { Map#Elements(Map#Build(m, u, v))[u'] } 
  (u' == u
       ==> Map#Domain(Map#Build(m, u, v))[u'] && Map#Elements(Map#Build(m, u, v))[u'] == v)
     && (u' != u
       ==> Map#Domain(Map#Build(m, u, v))[u'] == Map#Domain(m)[u']
         && Map#Elements(Map#Build(m, u, v))[u'] == Map#Elements(m)[u']));

axiom (forall<U,V> m: Map U V, u: U, v: V :: 
  { Map#Card(Map#Build(m, u, v)) } 
  Map#Domain(m)[u] ==> Map#Card(Map#Build(m, u, v)) == Map#Card(m));

axiom (forall<U,V> m: Map U V, u: U, v: V :: 
  { Map#Card(Map#Build(m, u, v)) } 
  !Map#Domain(m)[u] ==> Map#Card(Map#Build(m, u, v)) == Map#Card(m) + 1);

function Map#Merge<U,V>(Map U V, Map U V) : Map U V;

axiom (forall<U,V> m: Map U V, n: Map U V :: 
  { Map#Domain(Map#Merge(m, n)) } 
  Map#Domain(Map#Merge(m, n)) == Set#Union(Map#Domain(m), Map#Domain(n)));

axiom (forall<U,V> m: Map U V, n: Map U V, u: U :: 
  { Map#Elements(Map#Merge(m, n))[u] } 
  Map#Domain(Map#Merge(m, n))[u]
     ==> (!Map#Domain(n)[u] ==> Map#Elements(Map#Merge(m, n))[u] == Map#Elements(m)[u])
       && (Map#Domain(n)[u] ==> Map#Elements(Map#Merge(m, n))[u] == Map#Elements(n)[u]));

function Map#Subtract<U,V>(Map U V, Set U) : Map U V;

axiom (forall<U,V> m: Map U V, s: Set U :: 
  { Map#Domain(Map#Subtract(m, s)) } 
  Map#Domain(Map#Subtract(m, s)) == Set#Difference(Map#Domain(m), s));

axiom (forall<U,V> m: Map U V, s: Set U, u: U :: 
  { Map#Elements(Map#Subtract(m, s))[u] } 
  Map#Domain(Map#Subtract(m, s))[u]
     ==> Map#Elements(Map#Subtract(m, s))[u] == Map#Elements(m)[u]);

function Map#Equal<U,V>(Map U V, Map U V) : bool;

axiom (forall<U,V> m: Map U V, m': Map U V :: 
  { Map#Equal(m, m') } 
  Map#Equal(m, m')
     <==> (forall u: U :: Map#Domain(m)[u] == Map#Domain(m')[u])
       && (forall u: U :: Map#Domain(m)[u] ==> Map#Elements(m)[u] == Map#Elements(m')[u]));

axiom (forall<U,V> m: Map U V, m': Map U V :: 
  { Map#Equal(m, m') } 
  Map#Equal(m, m') ==> m == m');

function Map#Disjoint<U,V>(Map U V, Map U V) : bool;

axiom (forall<U,V> m: Map U V, m': Map U V :: 
  { Map#Disjoint(m, m') } 
  Map#Disjoint(m, m')
     <==> (forall o: U :: 
      { Map#Domain(m)[o] } { Map#Domain(m')[o] } 
      !Map#Domain(m)[o] || !Map#Domain(m')[o]));

type IMap _ _;

function IMap#Domain<U,V>(IMap U V) : Set U;

function IMap#Elements<U,V>(IMap U V) : [U]V;

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Domain(m) } 
  m == IMap#Empty() || (exists k: U :: IMap#Domain(m)[k]));

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Values(m) } 
  m == IMap#Empty() || (exists v: V :: IMap#Values(m)[v]));

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Items(m) } 
  m == IMap#Empty()
     || (exists k: Box, v: Box :: IMap#Items(m)[$Box(#_System._tuple#2._#Make2(k, v))]));

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Domain(m) } 
  m == IMap#Empty() <==> IMap#Domain(m) == ISet#Empty());

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Values(m) } 
  m == IMap#Empty() <==> IMap#Values(m) == ISet#Empty());

axiom (forall<U,V> m: IMap U V :: 
  { IMap#Items(m) } 
  m == IMap#Empty() <==> IMap#Items(m) == ISet#Empty());

function IMap#Values<U,V>(IMap U V) : Set V;

axiom (forall<U,V> m: IMap U V, v: V :: 
  { IMap#Values(m)[v] } 
  IMap#Values(m)[v]
     == (exists u: U :: 
      { IMap#Domain(m)[u] } { IMap#Elements(m)[u] } 
      IMap#Domain(m)[u] && v == IMap#Elements(m)[u]));

function IMap#Items<U,V>(IMap U V) : Set Box;

axiom (forall m: IMap Box Box, item: Box :: 
  { IMap#Items(m)[item] } 
  IMap#Items(m)[item]
     <==> IMap#Domain(m)[_System.Tuple2._0($Unbox(item))]
       && IMap#Elements(m)[_System.Tuple2._0($Unbox(item))]
         == _System.Tuple2._1($Unbox(item)));

function IMap#Empty<U,V>() : IMap U V;

axiom (forall<U,V> u: U :: 
  { IMap#Domain(IMap#Empty(): IMap U V)[u] } 
  !IMap#Domain(IMap#Empty(): IMap U V)[u]);

function IMap#Glue<U,V>([U]bool, [U]V, Ty) : IMap U V;

axiom (forall<U,V> a: [U]bool, b: [U]V, t: Ty :: 
  { IMap#Domain(IMap#Glue(a, b, t)) } 
  IMap#Domain(IMap#Glue(a, b, t)) == a);

axiom (forall<U,V> a: [U]bool, b: [U]V, t: Ty :: 
  { IMap#Elements(IMap#Glue(a, b, t)) } 
  IMap#Elements(IMap#Glue(a, b, t)) == b);

axiom (forall a: [Box]bool, b: [Box]Box, t0: Ty, t1: Ty :: 
  { IMap#Glue(a, b, TIMap(t0, t1)) } 
  (forall bx: Box :: a[bx] ==> $IsBox(bx, t0) && $IsBox(b[bx], t1))
     ==> $Is(Map#Glue(a, b, TIMap(t0, t1)), TIMap(t0, t1)));

function IMap#Build<U,V>(IMap U V, U, V) : IMap U V;

axiom (forall<U,V> m: IMap U V, u: U, u': U, v: V :: 
  { IMap#Domain(IMap#Build(m, u, v))[u'] } 
    { IMap#Elements(IMap#Build(m, u, v))[u'] } 
  (u' == u
       ==> IMap#Domain(IMap#Build(m, u, v))[u']
         && IMap#Elements(IMap#Build(m, u, v))[u'] == v)
     && (u' != u
       ==> IMap#Domain(IMap#Build(m, u, v))[u'] == IMap#Domain(m)[u']
         && IMap#Elements(IMap#Build(m, u, v))[u'] == IMap#Elements(m)[u']));

function IMap#Equal<U,V>(IMap U V, IMap U V) : bool;

axiom (forall<U,V> m: IMap U V, m': IMap U V :: 
  { IMap#Equal(m, m') } 
  IMap#Equal(m, m')
     <==> (forall u: U :: IMap#Domain(m)[u] == IMap#Domain(m')[u])
       && (forall u: U :: 
        IMap#Domain(m)[u] ==> IMap#Elements(m)[u] == IMap#Elements(m')[u]));

axiom (forall<U,V> m: IMap U V, m': IMap U V :: 
  { IMap#Equal(m, m') } 
  IMap#Equal(m, m') ==> m == m');

function IMap#Merge<U,V>(IMap U V, IMap U V) : IMap U V;

axiom (forall<U,V> m: IMap U V, n: IMap U V :: 
  { IMap#Domain(IMap#Merge(m, n)) } 
  IMap#Domain(IMap#Merge(m, n)) == Set#Union(IMap#Domain(m), IMap#Domain(n)));

axiom (forall<U,V> m: IMap U V, n: IMap U V, u: U :: 
  { IMap#Elements(IMap#Merge(m, n))[u] } 
  IMap#Domain(IMap#Merge(m, n))[u]
     ==> (!IMap#Domain(n)[u]
         ==> IMap#Elements(IMap#Merge(m, n))[u] == IMap#Elements(m)[u])
       && (IMap#Domain(n)[u]
         ==> IMap#Elements(IMap#Merge(m, n))[u] == IMap#Elements(n)[u]));

function IMap#Subtract<U,V>(IMap U V, Set U) : IMap U V;

axiom (forall<U,V> m: IMap U V, s: Set U :: 
  { IMap#Domain(IMap#Subtract(m, s)) } 
  IMap#Domain(IMap#Subtract(m, s)) == Set#Difference(IMap#Domain(m), s));

axiom (forall<U,V> m: IMap U V, s: Set U, u: U :: 
  { IMap#Elements(IMap#Subtract(m, s))[u] } 
  IMap#Domain(IMap#Subtract(m, s))[u]
     ==> IMap#Elements(IMap#Subtract(m, s))[u] == IMap#Elements(m)[u]);

function INTERNAL_add_boogie(x: int, y: int) : int;

axiom (forall x: int, y: int :: 
  { INTERNAL_add_boogie(x, y): int } 
  INTERNAL_add_boogie(x, y): int == x + y);

function INTERNAL_sub_boogie(x: int, y: int) : int;

axiom (forall x: int, y: int :: 
  { INTERNAL_sub_boogie(x, y): int } 
  INTERNAL_sub_boogie(x, y): int == x - y);

function INTERNAL_mul_boogie(x: int, y: int) : int;

axiom (forall x: int, y: int :: 
  { INTERNAL_mul_boogie(x, y): int } 
  INTERNAL_mul_boogie(x, y): int == x * y);

function INTERNAL_div_boogie(x: int, y: int) : int;

axiom (forall x: int, y: int :: 
  { INTERNAL_div_boogie(x, y): int } 
  INTERNAL_div_boogie(x, y): int == x div y);

function INTERNAL_mod_boogie(x: int, y: int) : int;

axiom (forall x: int, y: int :: 
  { INTERNAL_mod_boogie(x, y): int } 
  INTERNAL_mod_boogie(x, y): int == x mod y);

function {:never_pattern true} INTERNAL_lt_boogie(x: int, y: int) : bool;

axiom (forall x: int, y: int :: 
  {:never_pattern true} { INTERNAL_lt_boogie(x, y): bool } 
  INTERNAL_lt_boogie(x, y): bool == (x < y));

function {:never_pattern true} INTERNAL_le_boogie(x: int, y: int) : bool;

axiom (forall x: int, y: int :: 
  {:never_pattern true} { INTERNAL_le_boogie(x, y): bool } 
  INTERNAL_le_boogie(x, y): bool == (x <= y));

function {:never_pattern true} INTERNAL_gt_boogie(x: int, y: int) : bool;

axiom (forall x: int, y: int :: 
  {:never_pattern true} { INTERNAL_gt_boogie(x, y): bool } 
  INTERNAL_gt_boogie(x, y): bool == (x > y));

function {:never_pattern true} INTERNAL_ge_boogie(x: int, y: int) : bool;

axiom (forall x: int, y: int :: 
  {:never_pattern true} { INTERNAL_ge_boogie(x, y): bool } 
  INTERNAL_ge_boogie(x, y): bool == (x >= y));

function Mul(x: int, y: int) : int;

axiom (forall x: int, y: int :: { Mul(x, y): int } Mul(x, y): int == x * y);

function Div(x: int, y: int) : int;

axiom (forall x: int, y: int :: { Div(x, y): int } Div(x, y): int == x div y);

function Mod(x: int, y: int) : int;

axiom (forall x: int, y: int :: { Mod(x, y): int } Mod(x, y): int == x mod y);

function Add(x: int, y: int) : int;

axiom (forall x: int, y: int :: { Add(x, y): int } Add(x, y): int == x + y);

function Sub(x: int, y: int) : int;

axiom (forall x: int, y: int :: { Sub(x, y): int } Sub(x, y): int == x - y);

function Tclass._System.nat() : Ty;

const unique Tagclass._System.nat: TyTag;

// Tclass._System.nat Tag
axiom Tag(Tclass._System.nat()) == Tagclass._System.nat
   && TagFamily(Tclass._System.nat()) == tytagFamily$nat;

// Box/unbox axiom for Tclass._System.nat
axiom (forall bx: Box :: 
  { $IsBox(bx, Tclass._System.nat()) } 
  $IsBox(bx, Tclass._System.nat())
     ==> $Box($Unbox(bx): int) == bx && $Is($Unbox(bx): int, Tclass._System.nat()));

// _System.nat: subset type $Is
axiom (forall x#0: int :: 
  { $Is(x#0, Tclass._System.nat()) } 
  $Is(x#0, Tclass._System.nat()) <==> LitInt(0) <= x#0);

// _System.nat: subset type $IsAlloc
axiom (forall x#0: int, $h: Heap :: 
  { $IsAlloc(x#0, Tclass._System.nat(), $h) } 
  $IsAlloc(x#0, Tclass._System.nat(), $h));

const unique class._System.object?: ClassName;

const unique Tagclass._System.object?: TyTag;

// Tclass._System.object? Tag
axiom Tag(Tclass._System.object?()) == Tagclass._System.object?
   && TagFamily(Tclass._System.object?()) == tytagFamily$object;

// Box/unbox axiom for Tclass._System.object?
axiom (forall bx: Box :: 
  { $IsBox(bx, Tclass._System.object?()) } 
  $IsBox(bx, Tclass._System.object?())
     ==> $Box($Unbox(bx): ref) == bx && $Is($Unbox(bx): ref, Tclass._System.object?()));

// object: Class $Is
axiom (forall $o: ref :: 
  { $Is($o, Tclass._System.object?()) } 
  $Is($o, Tclass._System.object?()));

// object: Class $IsAlloc
axiom (forall $o: ref, $h: Heap :: 
  { $IsAlloc($o, Tclass._System.object?(), $h) } 
  $IsAlloc($o, Tclass._System.object?(), $h)
     <==> $o == null || read($h, $o, alloc));

function implements$_System.object(ty: Ty) : bool;

function Tclass._System.object() : Ty;

const unique Tagclass._System.object: TyTag;

// Tclass._System.object Tag
axiom Tag(Tclass._System.object()) == Tagclass._System.object
   && TagFamily(Tclass._System.object()) == tytagFamily$object;

// Box/unbox axiom for Tclass._System.object
axiom (forall bx: Box :: 
  { $IsBox(bx, Tclass._System.object()) } 
  $IsBox(bx, Tclass._System.object())
     ==> $Box($Unbox(bx): ref) == bx && $Is($Unbox(bx): ref, Tclass._System.object()));

// _System.object: non-null type $Is
axiom (forall c#0: ref :: 
  { $Is(c#0, Tclass._System.object()) } 
  $Is(c#0, Tclass._System.object())
     <==> $Is(c#0, Tclass._System.object?()) && c#0 != null);

// _System.object: non-null type $IsAlloc
axiom (forall c#0: ref, $h: Heap :: 
  { $IsAlloc(c#0, Tclass._System.object(), $h) } 
  $IsAlloc(c#0, Tclass._System.object(), $h)
     <==> $IsAlloc(c#0, Tclass._System.object?(), $h));

const unique class._System.array?: ClassName;

function Tclass._System.array?(Ty) : Ty;

const unique Tagclass._System.array?: TyTag;

// Tclass._System.array? Tag
axiom (forall _System.array$arg: Ty :: 
  { Tclass._System.array?(_System.array$arg) } 
  Tag(Tclass._System.array?(_System.array$arg)) == Tagclass._System.array?
     && TagFamily(Tclass._System.array?(_System.array$arg)) == tytagFamily$array);

function Tclass._System.array?_0(Ty) : Ty;

// Tclass._System.array? injectivity 0
axiom (forall _System.array$arg: Ty :: 
  { Tclass._System.array?(_System.array$arg) } 
  Tclass._System.array?_0(Tclass._System.array?(_System.array$arg))
     == _System.array$arg);

// Box/unbox axiom for Tclass._System.array?
axiom (forall _System.array$arg: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.array?(_System.array$arg)) } 
  $IsBox(bx, Tclass._System.array?(_System.array$arg))
     ==> $Box($Unbox(bx): ref) == bx
       && $Is($Unbox(bx): ref, Tclass._System.array?(_System.array$arg)));

// array.: Type axiom
axiom (forall _System.array$arg: Ty, $h: Heap, $o: ref, $i0: int :: 
  { read($h, $o, IndexField($i0)), Tclass._System.array?(_System.array$arg) } 
  $IsGoodHeap($h)
       && 
      $o != null
       && dtype($o) == Tclass._System.array?(_System.array$arg)
       && 
      0 <= $i0
       && $i0 < _System.array.Length($o)
     ==> $IsBox(read($h, $o, IndexField($i0)), _System.array$arg));

// array.: Allocation axiom
axiom (forall _System.array$arg: Ty, $h: Heap, $o: ref, $i0: int :: 
  { read($h, $o, IndexField($i0)), Tclass._System.array?(_System.array$arg) } 
  $IsGoodHeap($h)
       && 
      $o != null
       && dtype($o) == Tclass._System.array?(_System.array$arg)
       && 
      0 <= $i0
       && $i0 < _System.array.Length($o)
       && read($h, $o, alloc)
     ==> $IsAllocBox(read($h, $o, IndexField($i0)), _System.array$arg, $h));

// array: Class $Is
axiom (forall _System.array$arg: Ty, $o: ref :: 
  { $Is($o, Tclass._System.array?(_System.array$arg)) } 
  $Is($o, Tclass._System.array?(_System.array$arg))
     <==> $o == null || dtype($o) == Tclass._System.array?(_System.array$arg));

// array: Class $IsAlloc
axiom (forall _System.array$arg: Ty, $o: ref, $h: Heap :: 
  { $IsAlloc($o, Tclass._System.array?(_System.array$arg), $h) } 
  $IsAlloc($o, Tclass._System.array?(_System.array$arg), $h)
     <==> $o == null || read($h, $o, alloc));

// array.Length: Type axiom
axiom (forall _System.array$arg: Ty, $o: ref :: 
  { _System.array.Length($o), Tclass._System.array?(_System.array$arg) } 
  $o != null && dtype($o) == Tclass._System.array?(_System.array$arg)
     ==> $Is(_System.array.Length($o), TInt));

// array.Length: Allocation axiom
axiom (forall _System.array$arg: Ty, $h: Heap, $o: ref :: 
  { _System.array.Length($o), read($h, $o, alloc), Tclass._System.array?(_System.array$arg) } 
  $IsGoodHeap($h)
       && 
      $o != null
       && dtype($o) == Tclass._System.array?(_System.array$arg)
       && read($h, $o, alloc)
     ==> $IsAlloc(_System.array.Length($o), TInt, $h));

function Tclass._System.array(Ty) : Ty;

const unique Tagclass._System.array: TyTag;

// Tclass._System.array Tag
axiom (forall _System.array$arg: Ty :: 
  { Tclass._System.array(_System.array$arg) } 
  Tag(Tclass._System.array(_System.array$arg)) == Tagclass._System.array
     && TagFamily(Tclass._System.array(_System.array$arg)) == tytagFamily$array);

function Tclass._System.array_0(Ty) : Ty;

// Tclass._System.array injectivity 0
axiom (forall _System.array$arg: Ty :: 
  { Tclass._System.array(_System.array$arg) } 
  Tclass._System.array_0(Tclass._System.array(_System.array$arg))
     == _System.array$arg);

// Box/unbox axiom for Tclass._System.array
axiom (forall _System.array$arg: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.array(_System.array$arg)) } 
  $IsBox(bx, Tclass._System.array(_System.array$arg))
     ==> $Box($Unbox(bx): ref) == bx
       && $Is($Unbox(bx): ref, Tclass._System.array(_System.array$arg)));

// _System.array: non-null type $Is
axiom (forall _System.array$arg: Ty, c#0: ref :: 
  { $Is(c#0, Tclass._System.array(_System.array$arg)) } 
  $Is(c#0, Tclass._System.array(_System.array$arg))
     <==> $Is(c#0, Tclass._System.array?(_System.array$arg)) && c#0 != null);

// _System.array: non-null type $IsAlloc
axiom (forall _System.array$arg: Ty, c#0: ref, $h: Heap :: 
  { $IsAlloc(c#0, Tclass._System.array(_System.array$arg), $h) } 
  $IsAlloc(c#0, Tclass._System.array(_System.array$arg), $h)
     <==> $IsAlloc(c#0, Tclass._System.array?(_System.array$arg), $h));

function Tclass._System.___hFunc1(Ty, Ty) : Ty;

const unique Tagclass._System.___hFunc1: TyTag;

// Tclass._System.___hFunc1 Tag
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc1(#$T0, #$R) } 
  Tag(Tclass._System.___hFunc1(#$T0, #$R)) == Tagclass._System.___hFunc1
     && TagFamily(Tclass._System.___hFunc1(#$T0, #$R)) == tytagFamily$_#Func1);

function Tclass._System.___hFunc1_0(Ty) : Ty;

// Tclass._System.___hFunc1 injectivity 0
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc1(#$T0, #$R) } 
  Tclass._System.___hFunc1_0(Tclass._System.___hFunc1(#$T0, #$R)) == #$T0);

function Tclass._System.___hFunc1_1(Ty) : Ty;

// Tclass._System.___hFunc1 injectivity 1
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc1(#$T0, #$R) } 
  Tclass._System.___hFunc1_1(Tclass._System.___hFunc1(#$T0, #$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hFunc1
axiom (forall #$T0: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hFunc1(#$T0, #$R)) } 
  $IsBox(bx, Tclass._System.___hFunc1(#$T0, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hFunc1(#$T0, #$R)));

function Handle1([Heap,Box]Box, [Heap,Box]bool, [Heap,Box]Set Box) : HandleType;

function Requires1(Ty, Ty, Heap, HandleType, Box) : bool;

function Reads1(Ty, Ty, Heap, HandleType, Box) : Set Box;

axiom (forall t0: Ty, 
    t1: Ty, 
    heap: Heap, 
    h: [Heap,Box]Box, 
    r: [Heap,Box]bool, 
    rd: [Heap,Box]Set Box, 
    bx0: Box :: 
  { Apply1(t0, t1, heap, Handle1(h, r, rd), bx0) } 
  Apply1(t0, t1, heap, Handle1(h, r, rd), bx0) == h[heap, bx0]);

axiom (forall t0: Ty, 
    t1: Ty, 
    heap: Heap, 
    h: [Heap,Box]Box, 
    r: [Heap,Box]bool, 
    rd: [Heap,Box]Set Box, 
    bx0: Box :: 
  { Requires1(t0, t1, heap, Handle1(h, r, rd), bx0) } 
  r[heap, bx0] ==> Requires1(t0, t1, heap, Handle1(h, r, rd), bx0));

axiom (forall t0: Ty, 
    t1: Ty, 
    heap: Heap, 
    h: [Heap,Box]Box, 
    r: [Heap,Box]bool, 
    rd: [Heap,Box]Set Box, 
    bx0: Box, 
    bx: Box :: 
  { Reads1(t0, t1, heap, Handle1(h, r, rd), bx0)[bx] } 
  Reads1(t0, t1, heap, Handle1(h, r, rd), bx0)[bx] == rd[heap, bx0][bx]);

function {:inline} Requires1#canCall(t0: Ty, t1: Ty, heap: Heap, f: HandleType, bx0: Box) : bool
{
  true
}

function {:inline} Reads1#canCall(t0: Ty, t1: Ty, heap: Heap, f: HandleType, bx0: Box) : bool
{
  true
}

// frame axiom for Reads1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Reads1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h0, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads1(t0, t1, h0, f, bx0) == Reads1(t0, t1, h1, f, bx0));

// frame axiom for Reads1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Reads1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h1, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads1(t0, t1, h0, f, bx0) == Reads1(t0, t1, h1, f, bx0));

// frame axiom for Requires1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Requires1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h0, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires1(t0, t1, h0, f, bx0) == Requires1(t0, t1, h1, f, bx0));

// frame axiom for Requires1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Requires1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h1, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires1(t0, t1, h0, f, bx0) == Requires1(t0, t1, h1, f, bx0));

// frame axiom for Apply1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Apply1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h0, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply1(t0, t1, h0, f, bx0) == Apply1(t0, t1, h1, f, bx0));

// frame axiom for Apply1
axiom (forall t0: Ty, t1: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box :: 
  { $HeapSucc(h0, h1), Apply1(t0, t1, h1, f, bx0) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads1(t0, t1, h1, f, bx0)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply1(t0, t1, h0, f, bx0) == Apply1(t0, t1, h1, f, bx0));

// empty-reads property for Reads1 
axiom (forall t0: Ty, t1: Ty, heap: Heap, f: HandleType, bx0: Box :: 
  { Reads1(t0, t1, $OneHeap, f, bx0), $IsGoodHeap(heap) } 
    { Reads1(t0, t1, heap, f, bx0) } 
  $IsGoodHeap(heap) && $IsBox(bx0, t0) && $Is(f, Tclass._System.___hFunc1(t0, t1))
     ==> (Set#Equal(Reads1(t0, t1, $OneHeap, f, bx0), Set#Empty(): Set Box)
       <==> Set#Equal(Reads1(t0, t1, heap, f, bx0), Set#Empty(): Set Box)));

// empty-reads property for Requires1
axiom (forall t0: Ty, t1: Ty, heap: Heap, f: HandleType, bx0: Box :: 
  { Requires1(t0, t1, $OneHeap, f, bx0), $IsGoodHeap(heap) } 
    { Requires1(t0, t1, heap, f, bx0) } 
  $IsGoodHeap(heap)
       && 
      $IsBox(bx0, t0)
       && $Is(f, Tclass._System.___hFunc1(t0, t1))
       && Set#Equal(Reads1(t0, t1, $OneHeap, f, bx0), Set#Empty(): Set Box)
     ==> Requires1(t0, t1, $OneHeap, f, bx0) == Requires1(t0, t1, heap, f, bx0));

axiom (forall f: HandleType, t0: Ty, t1: Ty :: 
  { $Is(f, Tclass._System.___hFunc1(t0, t1)) } 
  $Is(f, Tclass._System.___hFunc1(t0, t1))
     <==> (forall h: Heap, bx0: Box :: 
      { Apply1(t0, t1, h, f, bx0) } 
      $IsGoodHeap(h) && $IsBox(bx0, t0) && Requires1(t0, t1, h, f, bx0)
         ==> $IsBox(Apply1(t0, t1, h, f, bx0), t1)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, u0: Ty, u1: Ty :: 
  { $Is(f, Tclass._System.___hFunc1(t0, t1)), $Is(f, Tclass._System.___hFunc1(u0, u1)) } 
  $Is(f, Tclass._System.___hFunc1(t0, t1))
       && (forall bx: Box :: 
        { $IsBox(bx, u0) } { $IsBox(bx, t0) } 
        $IsBox(bx, u0) ==> $IsBox(bx, t0))
       && (forall bx: Box :: 
        { $IsBox(bx, t1) } { $IsBox(bx, u1) } 
        $IsBox(bx, t1) ==> $IsBox(bx, u1))
     ==> $Is(f, Tclass._System.___hFunc1(u0, u1)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc1(t0, t1), h) } 
  $IsGoodHeap(h)
     ==> ($IsAlloc(f, Tclass._System.___hFunc1(t0, t1), h)
       <==> (forall bx0: Box :: 
        { Apply1(t0, t1, h, f, bx0) } { Reads1(t0, t1, h, f, bx0) } 
        $IsBox(bx0, t0) && $IsAllocBox(bx0, t0, h) && Requires1(t0, t1, h, f, bx0)
           ==> (forall r: ref :: 
            { Reads1(t0, t1, h, f, bx0)[$Box(r)] } 
            r != null && Reads1(t0, t1, h, f, bx0)[$Box(r)] ==> read(h, r, alloc)))));

axiom (forall f: HandleType, t0: Ty, t1: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc1(t0, t1), h) } 
  $IsGoodHeap(h) && $IsAlloc(f, Tclass._System.___hFunc1(t0, t1), h)
     ==> (forall bx0: Box :: 
      { Apply1(t0, t1, h, f, bx0) } 
      $IsAllocBox(bx0, t0, h) && Requires1(t0, t1, h, f, bx0)
         ==> $IsAllocBox(Apply1(t0, t1, h, f, bx0), t1, h)));

function Tclass._System.___hPartialFunc1(Ty, Ty) : Ty;

const unique Tagclass._System.___hPartialFunc1: TyTag;

// Tclass._System.___hPartialFunc1 Tag
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc1(#$T0, #$R) } 
  Tag(Tclass._System.___hPartialFunc1(#$T0, #$R))
       == Tagclass._System.___hPartialFunc1
     && TagFamily(Tclass._System.___hPartialFunc1(#$T0, #$R))
       == tytagFamily$_#PartialFunc1);

function Tclass._System.___hPartialFunc1_0(Ty) : Ty;

// Tclass._System.___hPartialFunc1 injectivity 0
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc1(#$T0, #$R) } 
  Tclass._System.___hPartialFunc1_0(Tclass._System.___hPartialFunc1(#$T0, #$R))
     == #$T0);

function Tclass._System.___hPartialFunc1_1(Ty) : Ty;

// Tclass._System.___hPartialFunc1 injectivity 1
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc1(#$T0, #$R) } 
  Tclass._System.___hPartialFunc1_1(Tclass._System.___hPartialFunc1(#$T0, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hPartialFunc1
axiom (forall #$T0: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hPartialFunc1(#$T0, #$R)) } 
  $IsBox(bx, Tclass._System.___hPartialFunc1(#$T0, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hPartialFunc1(#$T0, #$R)));

// _System._#PartialFunc1: subset type $Is
axiom (forall #$T0: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R)) } 
  $Is(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R))
     <==> $Is(f#0, Tclass._System.___hFunc1(#$T0, #$R))
       && (forall x0#0: Box :: 
        $IsBox(x0#0, #$T0)
           ==> Set#Equal(Reads1(#$T0, #$R, $OneHeap, f#0, x0#0), Set#Empty(): Set Box)));

// _System._#PartialFunc1: subset type $IsAlloc
axiom (forall #$T0: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hFunc1(#$T0, #$R), $h));

function Tclass._System.___hTotalFunc1(Ty, Ty) : Ty;

const unique Tagclass._System.___hTotalFunc1: TyTag;

// Tclass._System.___hTotalFunc1 Tag
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc1(#$T0, #$R) } 
  Tag(Tclass._System.___hTotalFunc1(#$T0, #$R)) == Tagclass._System.___hTotalFunc1
     && TagFamily(Tclass._System.___hTotalFunc1(#$T0, #$R)) == tytagFamily$_#TotalFunc1);

function Tclass._System.___hTotalFunc1_0(Ty) : Ty;

// Tclass._System.___hTotalFunc1 injectivity 0
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc1(#$T0, #$R) } 
  Tclass._System.___hTotalFunc1_0(Tclass._System.___hTotalFunc1(#$T0, #$R))
     == #$T0);

function Tclass._System.___hTotalFunc1_1(Ty) : Ty;

// Tclass._System.___hTotalFunc1 injectivity 1
axiom (forall #$T0: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc1(#$T0, #$R) } 
  Tclass._System.___hTotalFunc1_1(Tclass._System.___hTotalFunc1(#$T0, #$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hTotalFunc1
axiom (forall #$T0: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hTotalFunc1(#$T0, #$R)) } 
  $IsBox(bx, Tclass._System.___hTotalFunc1(#$T0, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hTotalFunc1(#$T0, #$R)));

// _System._#TotalFunc1: subset type $Is
axiom (forall #$T0: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hTotalFunc1(#$T0, #$R)) } 
  $Is(f#0, Tclass._System.___hTotalFunc1(#$T0, #$R))
     <==> $Is(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R))
       && (forall x0#0: Box :: 
        $IsBox(x0#0, #$T0) ==> Requires1(#$T0, #$R, $OneHeap, f#0, x0#0)));

// _System._#TotalFunc1: subset type $IsAlloc
axiom (forall #$T0: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hTotalFunc1(#$T0, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hTotalFunc1(#$T0, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hPartialFunc1(#$T0, #$R), $h));

function Tclass._System.___hFunc0(Ty) : Ty;

const unique Tagclass._System.___hFunc0: TyTag;

// Tclass._System.___hFunc0 Tag
axiom (forall #$R: Ty :: 
  { Tclass._System.___hFunc0(#$R) } 
  Tag(Tclass._System.___hFunc0(#$R)) == Tagclass._System.___hFunc0
     && TagFamily(Tclass._System.___hFunc0(#$R)) == tytagFamily$_#Func0);

function Tclass._System.___hFunc0_0(Ty) : Ty;

// Tclass._System.___hFunc0 injectivity 0
axiom (forall #$R: Ty :: 
  { Tclass._System.___hFunc0(#$R) } 
  Tclass._System.___hFunc0_0(Tclass._System.___hFunc0(#$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hFunc0
axiom (forall #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hFunc0(#$R)) } 
  $IsBox(bx, Tclass._System.___hFunc0(#$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hFunc0(#$R)));

function Handle0([Heap]Box, [Heap]bool, [Heap]Set Box) : HandleType;

function Apply0(Ty, Heap, HandleType) : Box;

function Requires0(Ty, Heap, HandleType) : bool;

function Reads0(Ty, Heap, HandleType) : Set Box;

axiom (forall t0: Ty, heap: Heap, h: [Heap]Box, r: [Heap]bool, rd: [Heap]Set Box :: 
  { Apply0(t0, heap, Handle0(h, r, rd)) } 
  Apply0(t0, heap, Handle0(h, r, rd)) == h[heap]);

axiom (forall t0: Ty, heap: Heap, h: [Heap]Box, r: [Heap]bool, rd: [Heap]Set Box :: 
  { Requires0(t0, heap, Handle0(h, r, rd)) } 
  r[heap] ==> Requires0(t0, heap, Handle0(h, r, rd)));

axiom (forall t0: Ty, heap: Heap, h: [Heap]Box, r: [Heap]bool, rd: [Heap]Set Box, bx: Box :: 
  { Reads0(t0, heap, Handle0(h, r, rd))[bx] } 
  Reads0(t0, heap, Handle0(h, r, rd))[bx] == rd[heap][bx]);

function {:inline} Requires0#canCall(t0: Ty, heap: Heap, f: HandleType) : bool
{
  true
}

function {:inline} Reads0#canCall(t0: Ty, heap: Heap, f: HandleType) : bool
{
  true
}

// frame axiom for Reads0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Reads0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h0, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads0(t0, h0, f) == Reads0(t0, h1, f));

// frame axiom for Reads0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Reads0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h1, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads0(t0, h0, f) == Reads0(t0, h1, f));

// frame axiom for Requires0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Requires0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h0, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires0(t0, h0, f) == Requires0(t0, h1, f));

// frame axiom for Requires0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Requires0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h1, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires0(t0, h0, f) == Requires0(t0, h1, f));

// frame axiom for Apply0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Apply0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h0, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply0(t0, h0, f) == Apply0(t0, h1, f));

// frame axiom for Apply0
axiom (forall t0: Ty, h0: Heap, h1: Heap, f: HandleType :: 
  { $HeapSucc(h0, h1), Apply0(t0, h1, f) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads0(t0, h1, f)[$Box(o)] ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply0(t0, h0, f) == Apply0(t0, h1, f));

// empty-reads property for Reads0 
axiom (forall t0: Ty, heap: Heap, f: HandleType :: 
  { Reads0(t0, $OneHeap, f), $IsGoodHeap(heap) } { Reads0(t0, heap, f) } 
  $IsGoodHeap(heap) && $Is(f, Tclass._System.___hFunc0(t0))
     ==> (Set#Equal(Reads0(t0, $OneHeap, f), Set#Empty(): Set Box)
       <==> Set#Equal(Reads0(t0, heap, f), Set#Empty(): Set Box)));

// empty-reads property for Requires0
axiom (forall t0: Ty, heap: Heap, f: HandleType :: 
  { Requires0(t0, $OneHeap, f), $IsGoodHeap(heap) } { Requires0(t0, heap, f) } 
  $IsGoodHeap(heap)
       && $Is(f, Tclass._System.___hFunc0(t0))
       && Set#Equal(Reads0(t0, $OneHeap, f), Set#Empty(): Set Box)
     ==> Requires0(t0, $OneHeap, f) == Requires0(t0, heap, f));

axiom (forall f: HandleType, t0: Ty :: 
  { $Is(f, Tclass._System.___hFunc0(t0)) } 
  $Is(f, Tclass._System.___hFunc0(t0))
     <==> (forall h: Heap :: 
      { Apply0(t0, h, f) } 
      $IsGoodHeap(h) && Requires0(t0, h, f) ==> $IsBox(Apply0(t0, h, f), t0)));

axiom (forall f: HandleType, t0: Ty, u0: Ty :: 
  { $Is(f, Tclass._System.___hFunc0(t0)), $Is(f, Tclass._System.___hFunc0(u0)) } 
  $Is(f, Tclass._System.___hFunc0(t0))
       && (forall bx: Box :: 
        { $IsBox(bx, t0) } { $IsBox(bx, u0) } 
        $IsBox(bx, t0) ==> $IsBox(bx, u0))
     ==> $Is(f, Tclass._System.___hFunc0(u0)));

axiom (forall f: HandleType, t0: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc0(t0), h) } 
  $IsGoodHeap(h)
     ==> ($IsAlloc(f, Tclass._System.___hFunc0(t0), h)
       <==> Requires0(t0, h, f)
         ==> (forall r: ref :: 
          { Reads0(t0, h, f)[$Box(r)] } 
          r != null && Reads0(t0, h, f)[$Box(r)] ==> read(h, r, alloc))));

axiom (forall f: HandleType, t0: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc0(t0), h) } 
  $IsGoodHeap(h) && $IsAlloc(f, Tclass._System.___hFunc0(t0), h)
     ==> 
    Requires0(t0, h, f)
     ==> $IsAllocBox(Apply0(t0, h, f), t0, h));

function Tclass._System.___hPartialFunc0(Ty) : Ty;

const unique Tagclass._System.___hPartialFunc0: TyTag;

// Tclass._System.___hPartialFunc0 Tag
axiom (forall #$R: Ty :: 
  { Tclass._System.___hPartialFunc0(#$R) } 
  Tag(Tclass._System.___hPartialFunc0(#$R)) == Tagclass._System.___hPartialFunc0
     && TagFamily(Tclass._System.___hPartialFunc0(#$R)) == tytagFamily$_#PartialFunc0);

function Tclass._System.___hPartialFunc0_0(Ty) : Ty;

// Tclass._System.___hPartialFunc0 injectivity 0
axiom (forall #$R: Ty :: 
  { Tclass._System.___hPartialFunc0(#$R) } 
  Tclass._System.___hPartialFunc0_0(Tclass._System.___hPartialFunc0(#$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hPartialFunc0
axiom (forall #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hPartialFunc0(#$R)) } 
  $IsBox(bx, Tclass._System.___hPartialFunc0(#$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hPartialFunc0(#$R)));

// _System._#PartialFunc0: subset type $Is
axiom (forall #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hPartialFunc0(#$R)) } 
  $Is(f#0, Tclass._System.___hPartialFunc0(#$R))
     <==> $Is(f#0, Tclass._System.___hFunc0(#$R))
       && Set#Equal(Reads0(#$R, $OneHeap, f#0), Set#Empty(): Set Box));

// _System._#PartialFunc0: subset type $IsAlloc
axiom (forall #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hPartialFunc0(#$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hPartialFunc0(#$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hFunc0(#$R), $h));

function Tclass._System.___hTotalFunc0(Ty) : Ty;

const unique Tagclass._System.___hTotalFunc0: TyTag;

// Tclass._System.___hTotalFunc0 Tag
axiom (forall #$R: Ty :: 
  { Tclass._System.___hTotalFunc0(#$R) } 
  Tag(Tclass._System.___hTotalFunc0(#$R)) == Tagclass._System.___hTotalFunc0
     && TagFamily(Tclass._System.___hTotalFunc0(#$R)) == tytagFamily$_#TotalFunc0);

function Tclass._System.___hTotalFunc0_0(Ty) : Ty;

// Tclass._System.___hTotalFunc0 injectivity 0
axiom (forall #$R: Ty :: 
  { Tclass._System.___hTotalFunc0(#$R) } 
  Tclass._System.___hTotalFunc0_0(Tclass._System.___hTotalFunc0(#$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hTotalFunc0
axiom (forall #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hTotalFunc0(#$R)) } 
  $IsBox(bx, Tclass._System.___hTotalFunc0(#$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hTotalFunc0(#$R)));

// _System._#TotalFunc0: subset type $Is
axiom (forall #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hTotalFunc0(#$R)) } 
  $Is(f#0, Tclass._System.___hTotalFunc0(#$R))
     <==> $Is(f#0, Tclass._System.___hPartialFunc0(#$R)) && Requires0(#$R, $OneHeap, f#0));

// _System._#TotalFunc0: subset type $IsAlloc
axiom (forall #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hTotalFunc0(#$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hTotalFunc0(#$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hPartialFunc0(#$R), $h));

function Tclass._System.___hFunc2(Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hFunc2: TyTag;

// Tclass._System.___hFunc2 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc2(#$T0, #$T1, #$R) } 
  Tag(Tclass._System.___hFunc2(#$T0, #$T1, #$R)) == Tagclass._System.___hFunc2
     && TagFamily(Tclass._System.___hFunc2(#$T0, #$T1, #$R)) == tytagFamily$_#Func2);

function Tclass._System.___hFunc2_0(Ty) : Ty;

// Tclass._System.___hFunc2 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hFunc2_0(Tclass._System.___hFunc2(#$T0, #$T1, #$R)) == #$T0);

function Tclass._System.___hFunc2_1(Ty) : Ty;

// Tclass._System.___hFunc2 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hFunc2_1(Tclass._System.___hFunc2(#$T0, #$T1, #$R)) == #$T1);

function Tclass._System.___hFunc2_2(Ty) : Ty;

// Tclass._System.___hFunc2 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hFunc2_2(Tclass._System.___hFunc2(#$T0, #$T1, #$R)) == #$R);

// Box/unbox axiom for Tclass._System.___hFunc2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hFunc2(#$T0, #$T1, #$R)) } 
  $IsBox(bx, Tclass._System.___hFunc2(#$T0, #$T1, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hFunc2(#$T0, #$T1, #$R)));

function Handle2([Heap,Box,Box]Box, [Heap,Box,Box]bool, [Heap,Box,Box]Set Box) : HandleType;

function Apply2(Ty, Ty, Ty, Heap, HandleType, Box, Box) : Box;

function Requires2(Ty, Ty, Ty, Heap, HandleType, Box, Box) : bool;

function Reads2(Ty, Ty, Ty, Heap, HandleType, Box, Box) : Set Box;

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box]Box, 
    r: [Heap,Box,Box]bool, 
    rd: [Heap,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box :: 
  { Apply2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1) } 
  Apply2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1) == h[heap, bx0, bx1]);

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box]Box, 
    r: [Heap,Box,Box]bool, 
    rd: [Heap,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box :: 
  { Requires2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1) } 
  r[heap, bx0, bx1] ==> Requires2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1));

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box]Box, 
    r: [Heap,Box,Box]bool, 
    rd: [Heap,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box, 
    bx: Box :: 
  { Reads2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1)[bx] } 
  Reads2(t0, t1, t2, heap, Handle2(h, r, rd), bx0, bx1)[bx]
     == rd[heap, bx0, bx1][bx]);

function {:inline} Requires2#canCall(t0: Ty, t1: Ty, t2: Ty, heap: Heap, f: HandleType, bx0: Box, bx1: Box) : bool
{
  true
}

function {:inline} Reads2#canCall(t0: Ty, t1: Ty, t2: Ty, heap: Heap, f: HandleType, bx0: Box, bx1: Box) : bool
{
  true
}

// frame axiom for Reads2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Reads2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h0, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads2(t0, t1, t2, h0, f, bx0, bx1) == Reads2(t0, t1, t2, h1, f, bx0, bx1));

// frame axiom for Reads2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Reads2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h1, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads2(t0, t1, t2, h0, f, bx0, bx1) == Reads2(t0, t1, t2, h1, f, bx0, bx1));

// frame axiom for Requires2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Requires2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h0, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires2(t0, t1, t2, h0, f, bx0, bx1) == Requires2(t0, t1, t2, h1, f, bx0, bx1));

// frame axiom for Requires2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Requires2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h1, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires2(t0, t1, t2, h0, f, bx0, bx1) == Requires2(t0, t1, t2, h1, f, bx0, bx1));

// frame axiom for Apply2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Apply2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h0, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply2(t0, t1, t2, h0, f, bx0, bx1) == Apply2(t0, t1, t2, h1, f, bx0, bx1));

// frame axiom for Apply2
axiom (forall t0: Ty, t1: Ty, t2: Ty, h0: Heap, h1: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { $HeapSucc(h0, h1), Apply2(t0, t1, t2, h1, f, bx0, bx1) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads2(t0, t1, t2, h1, f, bx0, bx1)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply2(t0, t1, t2, h0, f, bx0, bx1) == Apply2(t0, t1, t2, h1, f, bx0, bx1));

// empty-reads property for Reads2 
axiom (forall t0: Ty, t1: Ty, t2: Ty, heap: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { Reads2(t0, t1, t2, $OneHeap, f, bx0, bx1), $IsGoodHeap(heap) } 
    { Reads2(t0, t1, t2, heap, f, bx0, bx1) } 
  $IsGoodHeap(heap)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
     ==> (Set#Equal(Reads2(t0, t1, t2, $OneHeap, f, bx0, bx1), Set#Empty(): Set Box)
       <==> Set#Equal(Reads2(t0, t1, t2, heap, f, bx0, bx1), Set#Empty(): Set Box)));

// empty-reads property for Requires2
axiom (forall t0: Ty, t1: Ty, t2: Ty, heap: Heap, f: HandleType, bx0: Box, bx1: Box :: 
  { Requires2(t0, t1, t2, $OneHeap, f, bx0, bx1), $IsGoodHeap(heap) } 
    { Requires2(t0, t1, t2, heap, f, bx0, bx1) } 
  $IsGoodHeap(heap)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && Set#Equal(Reads2(t0, t1, t2, $OneHeap, f, bx0, bx1), Set#Empty(): Set Box)
     ==> Requires2(t0, t1, t2, $OneHeap, f, bx0, bx1)
       == Requires2(t0, t1, t2, heap, f, bx0, bx1));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty :: 
  { $Is(f, Tclass._System.___hFunc2(t0, t1, t2)) } 
  $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
     <==> (forall h: Heap, bx0: Box, bx1: Box :: 
      { Apply2(t0, t1, t2, h, f, bx0, bx1) } 
      $IsGoodHeap(h)
           && 
          $IsBox(bx0, t0)
           && $IsBox(bx1, t1)
           && Requires2(t0, t1, t2, h, f, bx0, bx1)
         ==> $IsBox(Apply2(t0, t1, t2, h, f, bx0, bx1), t2)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, u0: Ty, u1: Ty, u2: Ty :: 
  { $Is(f, Tclass._System.___hFunc2(t0, t1, t2)), $Is(f, Tclass._System.___hFunc2(u0, u1, u2)) } 
  $Is(f, Tclass._System.___hFunc2(t0, t1, t2))
       && (forall bx: Box :: 
        { $IsBox(bx, u0) } { $IsBox(bx, t0) } 
        $IsBox(bx, u0) ==> $IsBox(bx, t0))
       && (forall bx: Box :: 
        { $IsBox(bx, u1) } { $IsBox(bx, t1) } 
        $IsBox(bx, u1) ==> $IsBox(bx, t1))
       && (forall bx: Box :: 
        { $IsBox(bx, t2) } { $IsBox(bx, u2) } 
        $IsBox(bx, t2) ==> $IsBox(bx, u2))
     ==> $Is(f, Tclass._System.___hFunc2(u0, u1, u2)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc2(t0, t1, t2), h) } 
  $IsGoodHeap(h)
     ==> ($IsAlloc(f, Tclass._System.___hFunc2(t0, t1, t2), h)
       <==> (forall bx0: Box, bx1: Box :: 
        { Apply2(t0, t1, t2, h, f, bx0, bx1) } { Reads2(t0, t1, t2, h, f, bx0, bx1) } 
        $IsBox(bx0, t0)
             && $IsAllocBox(bx0, t0, h)
             && 
            $IsBox(bx1, t1)
             && $IsAllocBox(bx1, t1, h)
             && Requires2(t0, t1, t2, h, f, bx0, bx1)
           ==> (forall r: ref :: 
            { Reads2(t0, t1, t2, h, f, bx0, bx1)[$Box(r)] } 
            r != null && Reads2(t0, t1, t2, h, f, bx0, bx1)[$Box(r)] ==> read(h, r, alloc)))));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc2(t0, t1, t2), h) } 
  $IsGoodHeap(h) && $IsAlloc(f, Tclass._System.___hFunc2(t0, t1, t2), h)
     ==> (forall bx0: Box, bx1: Box :: 
      { Apply2(t0, t1, t2, h, f, bx0, bx1) } 
      $IsAllocBox(bx0, t0, h)
           && $IsAllocBox(bx1, t1, h)
           && Requires2(t0, t1, t2, h, f, bx0, bx1)
         ==> $IsAllocBox(Apply2(t0, t1, t2, h, f, bx0, bx1), t2, h)));

function Tclass._System.___hPartialFunc2(Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hPartialFunc2: TyTag;

// Tclass._System.___hPartialFunc2 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R) } 
  Tag(Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
       == Tagclass._System.___hPartialFunc2
     && TagFamily(Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
       == tytagFamily$_#PartialFunc2);

function Tclass._System.___hPartialFunc2_0(Ty) : Ty;

// Tclass._System.___hPartialFunc2 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hPartialFunc2_0(Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
     == #$T0);

function Tclass._System.___hPartialFunc2_1(Ty) : Ty;

// Tclass._System.___hPartialFunc2 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hPartialFunc2_1(Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
     == #$T1);

function Tclass._System.___hPartialFunc2_2(Ty) : Ty;

// Tclass._System.___hPartialFunc2 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hPartialFunc2_2(Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hPartialFunc2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R)) } 
  $IsBox(bx, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R)));

// _System._#PartialFunc2: subset type $Is
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R)) } 
  $Is(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
     <==> $Is(f#0, Tclass._System.___hFunc2(#$T0, #$T1, #$R))
       && (forall x0#0: Box, x1#0: Box :: 
        $IsBox(x0#0, #$T0) && $IsBox(x1#0, #$T1)
           ==> Set#Equal(Reads2(#$T0, #$T1, #$R, $OneHeap, f#0, x0#0, x1#0), Set#Empty(): Set Box)));

// _System._#PartialFunc2: subset type $IsAlloc
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hFunc2(#$T0, #$T1, #$R), $h));

function Tclass._System.___hTotalFunc2(Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hTotalFunc2: TyTag;

// Tclass._System.___hTotalFunc2 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R) } 
  Tag(Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
       == Tagclass._System.___hTotalFunc2
     && TagFamily(Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
       == tytagFamily$_#TotalFunc2);

function Tclass._System.___hTotalFunc2_0(Ty) : Ty;

// Tclass._System.___hTotalFunc2 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hTotalFunc2_0(Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
     == #$T0);

function Tclass._System.___hTotalFunc2_1(Ty) : Ty;

// Tclass._System.___hTotalFunc2 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hTotalFunc2_1(Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
     == #$T1);

function Tclass._System.___hTotalFunc2_2(Ty) : Ty;

// Tclass._System.___hTotalFunc2 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R) } 
  Tclass._System.___hTotalFunc2_2(Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hTotalFunc2
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R)) } 
  $IsBox(bx, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R)));

// _System._#TotalFunc2: subset type $Is
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R)) } 
  $Is(f#0, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R))
     <==> $Is(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R))
       && (forall x0#0: Box, x1#0: Box :: 
        $IsBox(x0#0, #$T0) && $IsBox(x1#0, #$T1)
           ==> Requires2(#$T0, #$T1, #$R, $OneHeap, f#0, x0#0, x1#0)));

// _System._#TotalFunc2: subset type $IsAlloc
axiom (forall #$T0: Ty, #$T1: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hTotalFunc2(#$T0, #$T1, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hPartialFunc2(#$T0, #$T1, #$R), $h));

function Tclass._System.___hFunc3(Ty, Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hFunc3: TyTag;

// Tclass._System.___hFunc3 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tag(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
       == Tagclass._System.___hFunc3
     && TagFamily(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
       == tytagFamily$_#Func3);

function Tclass._System.___hFunc3_0(Ty) : Ty;

// Tclass._System.___hFunc3 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hFunc3_0(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T0);

function Tclass._System.___hFunc3_1(Ty) : Ty;

// Tclass._System.___hFunc3 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hFunc3_1(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T1);

function Tclass._System.___hFunc3_2(Ty) : Ty;

// Tclass._System.___hFunc3 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hFunc3_2(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T2);

function Tclass._System.___hFunc3_3(Ty) : Ty;

// Tclass._System.___hFunc3 injectivity 3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hFunc3_3(Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hFunc3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R)) } 
  $IsBox(bx, Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R)));

function Handle3([Heap,Box,Box,Box]Box, [Heap,Box,Box,Box]bool, [Heap,Box,Box,Box]Set Box)
   : HandleType;

function Apply3(Ty, Ty, Ty, Ty, Heap, HandleType, Box, Box, Box) : Box;

function Requires3(Ty, Ty, Ty, Ty, Heap, HandleType, Box, Box, Box) : bool;

function Reads3(Ty, Ty, Ty, Ty, Heap, HandleType, Box, Box, Box) : Set Box;

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box,Box]Box, 
    r: [Heap,Box,Box,Box]bool, 
    rd: [Heap,Box,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { Apply3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2) } 
  Apply3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2)
     == h[heap, bx0, bx1, bx2]);

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box,Box]Box, 
    r: [Heap,Box,Box,Box]bool, 
    rd: [Heap,Box,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { Requires3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2) } 
  r[heap, bx0, bx1, bx2]
     ==> Requires3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2));

axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    h: [Heap,Box,Box,Box]Box, 
    r: [Heap,Box,Box,Box]bool, 
    rd: [Heap,Box,Box,Box]Set Box, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box, 
    bx: Box :: 
  { Reads3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2)[bx] } 
  Reads3(t0, t1, t2, t3, heap, Handle3(h, r, rd), bx0, bx1, bx2)[bx]
     == rd[heap, bx0, bx1, bx2][bx]);

function {:inline} Requires3#canCall(t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box)
   : bool
{
  true
}

function {:inline} Reads3#canCall(t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box)
   : bool
{
  true
}

// frame axiom for Reads3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// frame axiom for Reads3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Reads3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// frame axiom for Requires3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Requires3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Requires3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// frame axiom for Requires3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Requires3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Requires3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Requires3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// frame axiom for Apply3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Apply3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Apply3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// frame axiom for Apply3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    h0: Heap, 
    h1: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { $HeapSucc(h0, h1), Apply3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2) } 
  $HeapSucc(h0, h1)
       && 
      $IsGoodHeap(h0)
       && $IsGoodHeap(h1)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall<a> o: ref, fld: Field a :: 
        o != null && Reads3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2)[$Box(o)]
           ==> read(h0, o, fld) == read(h1, o, fld))
     ==> Apply3(t0, t1, t2, t3, h0, f, bx0, bx1, bx2)
       == Apply3(t0, t1, t2, t3, h1, f, bx0, bx1, bx2));

// empty-reads property for Reads3 
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { Reads3(t0, t1, t2, t3, $OneHeap, f, bx0, bx1, bx2), $IsGoodHeap(heap) } 
    { Reads3(t0, t1, t2, t3, heap, f, bx0, bx1, bx2) } 
  $IsGoodHeap(heap)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
     ==> (Set#Equal(Reads3(t0, t1, t2, t3, $OneHeap, f, bx0, bx1, bx2), Set#Empty(): Set Box)
       <==> Set#Equal(Reads3(t0, t1, t2, t3, heap, f, bx0, bx1, bx2), Set#Empty(): Set Box)));

// empty-reads property for Requires3
axiom (forall t0: Ty, 
    t1: Ty, 
    t2: Ty, 
    t3: Ty, 
    heap: Heap, 
    f: HandleType, 
    bx0: Box, 
    bx1: Box, 
    bx2: Box :: 
  { Requires3(t0, t1, t2, t3, $OneHeap, f, bx0, bx1, bx2), $IsGoodHeap(heap) } 
    { Requires3(t0, t1, t2, t3, heap, f, bx0, bx1, bx2) } 
  $IsGoodHeap(heap)
       && 
      $IsBox(bx0, t0)
       && $IsBox(bx1, t1)
       && $IsBox(bx2, t2)
       && $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && Set#Equal(Reads3(t0, t1, t2, t3, $OneHeap, f, bx0, bx1, bx2), Set#Empty(): Set Box)
     ==> Requires3(t0, t1, t2, t3, $OneHeap, f, bx0, bx1, bx2)
       == Requires3(t0, t1, t2, t3, heap, f, bx0, bx1, bx2));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, t3: Ty :: 
  { $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3)) } 
  $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
     <==> (forall h: Heap, bx0: Box, bx1: Box, bx2: Box :: 
      { Apply3(t0, t1, t2, t3, h, f, bx0, bx1, bx2) } 
      $IsGoodHeap(h)
           && 
          $IsBox(bx0, t0)
           && $IsBox(bx1, t1)
           && $IsBox(bx2, t2)
           && Requires3(t0, t1, t2, t3, h, f, bx0, bx1, bx2)
         ==> $IsBox(Apply3(t0, t1, t2, t3, h, f, bx0, bx1, bx2), t3)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, t3: Ty, u0: Ty, u1: Ty, u2: Ty, u3: Ty :: 
  { $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3)), $Is(f, Tclass._System.___hFunc3(u0, u1, u2, u3)) } 
  $Is(f, Tclass._System.___hFunc3(t0, t1, t2, t3))
       && (forall bx: Box :: 
        { $IsBox(bx, u0) } { $IsBox(bx, t0) } 
        $IsBox(bx, u0) ==> $IsBox(bx, t0))
       && (forall bx: Box :: 
        { $IsBox(bx, u1) } { $IsBox(bx, t1) } 
        $IsBox(bx, u1) ==> $IsBox(bx, t1))
       && (forall bx: Box :: 
        { $IsBox(bx, u2) } { $IsBox(bx, t2) } 
        $IsBox(bx, u2) ==> $IsBox(bx, t2))
       && (forall bx: Box :: 
        { $IsBox(bx, t3) } { $IsBox(bx, u3) } 
        $IsBox(bx, t3) ==> $IsBox(bx, u3))
     ==> $Is(f, Tclass._System.___hFunc3(u0, u1, u2, u3)));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, t3: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc3(t0, t1, t2, t3), h) } 
  $IsGoodHeap(h)
     ==> ($IsAlloc(f, Tclass._System.___hFunc3(t0, t1, t2, t3), h)
       <==> (forall bx0: Box, bx1: Box, bx2: Box :: 
        { Apply3(t0, t1, t2, t3, h, f, bx0, bx1, bx2) } 
          { Reads3(t0, t1, t2, t3, h, f, bx0, bx1, bx2) } 
        $IsBox(bx0, t0)
             && $IsAllocBox(bx0, t0, h)
             && 
            $IsBox(bx1, t1)
             && $IsAllocBox(bx1, t1, h)
             && 
            $IsBox(bx2, t2)
             && $IsAllocBox(bx2, t2, h)
             && Requires3(t0, t1, t2, t3, h, f, bx0, bx1, bx2)
           ==> (forall r: ref :: 
            { Reads3(t0, t1, t2, t3, h, f, bx0, bx1, bx2)[$Box(r)] } 
            r != null && Reads3(t0, t1, t2, t3, h, f, bx0, bx1, bx2)[$Box(r)]
               ==> read(h, r, alloc)))));

axiom (forall f: HandleType, t0: Ty, t1: Ty, t2: Ty, t3: Ty, h: Heap :: 
  { $IsAlloc(f, Tclass._System.___hFunc3(t0, t1, t2, t3), h) } 
  $IsGoodHeap(h) && $IsAlloc(f, Tclass._System.___hFunc3(t0, t1, t2, t3), h)
     ==> (forall bx0: Box, bx1: Box, bx2: Box :: 
      { Apply3(t0, t1, t2, t3, h, f, bx0, bx1, bx2) } 
      $IsAllocBox(bx0, t0, h)
           && $IsAllocBox(bx1, t1, h)
           && $IsAllocBox(bx2, t2, h)
           && Requires3(t0, t1, t2, t3, h, f, bx0, bx1, bx2)
         ==> $IsAllocBox(Apply3(t0, t1, t2, t3, h, f, bx0, bx1, bx2), t3, h)));

function Tclass._System.___hPartialFunc3(Ty, Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hPartialFunc3: TyTag;

// Tclass._System.___hPartialFunc3 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tag(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
       == Tagclass._System.___hPartialFunc3
     && TagFamily(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
       == tytagFamily$_#PartialFunc3);

function Tclass._System.___hPartialFunc3_0(Ty) : Ty;

// Tclass._System.___hPartialFunc3 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hPartialFunc3_0(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T0);

function Tclass._System.___hPartialFunc3_1(Ty) : Ty;

// Tclass._System.___hPartialFunc3 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hPartialFunc3_1(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T1);

function Tclass._System.___hPartialFunc3_2(Ty) : Ty;

// Tclass._System.___hPartialFunc3 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hPartialFunc3_2(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T2);

function Tclass._System.___hPartialFunc3_3(Ty) : Ty;

// Tclass._System.___hPartialFunc3 injectivity 3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hPartialFunc3_3(Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hPartialFunc3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R)) } 
  $IsBox(bx, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R)));

// _System._#PartialFunc3: subset type $Is
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R)) } 
  $Is(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
     <==> $Is(f#0, Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R))
       && (forall x0#0: Box, x1#0: Box, x2#0: Box :: 
        $IsBox(x0#0, #$T0) && $IsBox(x1#0, #$T1) && $IsBox(x2#0, #$T2)
           ==> Set#Equal(Reads3(#$T0, #$T1, #$T2, #$R, $OneHeap, f#0, x0#0, x1#0, x2#0), 
            Set#Empty(): Set Box)));

// _System._#PartialFunc3: subset type $IsAlloc
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hFunc3(#$T0, #$T1, #$T2, #$R), $h));

function Tclass._System.___hTotalFunc3(Ty, Ty, Ty, Ty) : Ty;

const unique Tagclass._System.___hTotalFunc3: TyTag;

// Tclass._System.___hTotalFunc3 Tag
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tag(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
       == Tagclass._System.___hTotalFunc3
     && TagFamily(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
       == tytagFamily$_#TotalFunc3);

function Tclass._System.___hTotalFunc3_0(Ty) : Ty;

// Tclass._System.___hTotalFunc3 injectivity 0
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hTotalFunc3_0(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T0);

function Tclass._System.___hTotalFunc3_1(Ty) : Ty;

// Tclass._System.___hTotalFunc3 injectivity 1
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hTotalFunc3_1(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T1);

function Tclass._System.___hTotalFunc3_2(Ty) : Ty;

// Tclass._System.___hTotalFunc3 injectivity 2
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hTotalFunc3_2(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     == #$T2);

function Tclass._System.___hTotalFunc3_3(Ty) : Ty;

// Tclass._System.___hTotalFunc3 injectivity 3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty :: 
  { Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R) } 
  Tclass._System.___hTotalFunc3_3(Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     == #$R);

// Box/unbox axiom for Tclass._System.___hTotalFunc3
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R)) } 
  $IsBox(bx, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     ==> $Box($Unbox(bx): HandleType) == bx
       && $Is($Unbox(bx): HandleType, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R)));

// _System._#TotalFunc3: subset type $Is
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, f#0: HandleType :: 
  { $Is(f#0, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R)) } 
  $Is(f#0, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R))
     <==> $Is(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R))
       && (forall x0#0: Box, x1#0: Box, x2#0: Box :: 
        $IsBox(x0#0, #$T0) && $IsBox(x1#0, #$T1) && $IsBox(x2#0, #$T2)
           ==> Requires3(#$T0, #$T1, #$T2, #$R, $OneHeap, f#0, x0#0, x1#0, x2#0)));

// _System._#TotalFunc3: subset type $IsAlloc
axiom (forall #$T0: Ty, #$T1: Ty, #$T2: Ty, #$R: Ty, f#0: HandleType, $h: Heap :: 
  { $IsAlloc(f#0, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R), $h) } 
  $IsAlloc(f#0, Tclass._System.___hTotalFunc3(#$T0, #$T1, #$T2, #$R), $h)
     <==> $IsAlloc(f#0, Tclass._System.___hPartialFunc3(#$T0, #$T1, #$T2, #$R), $h));

// Constructor identifier
axiom (forall a#0#0#0: Box, a#0#1#0: Box :: 
  { #_System._tuple#2._#Make2(a#0#0#0, a#0#1#0) } 
  DatatypeCtorId(#_System._tuple#2._#Make2(a#0#0#0, a#0#1#0))
     == ##_System._tuple#2._#Make2);

const unique ##_System._tuple#2._#Make2: DtCtorId;

function _System.Tuple2.___hMake2_q(DatatypeType) : bool;

// Questionmark and identifier
axiom (forall d: DatatypeType :: 
  { _System.Tuple2.___hMake2_q(d) } 
  _System.Tuple2.___hMake2_q(d)
     <==> DatatypeCtorId(d) == ##_System._tuple#2._#Make2);

// Constructor questionmark has arguments
axiom (forall d: DatatypeType :: 
  { _System.Tuple2.___hMake2_q(d) } 
  _System.Tuple2.___hMake2_q(d)
     ==> (exists a#1#0#0: Box, a#1#1#0: Box :: 
      d == #_System._tuple#2._#Make2(a#1#0#0, a#1#1#0)));

const unique Tagclass._System.Tuple2: TyTag;

// Tclass._System.Tuple2 Tag
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty :: 
  { Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1) } 
  Tag(Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
       == Tagclass._System.Tuple2
     && TagFamily(Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
       == tytagFamily$_tuple#2);

function Tclass._System.Tuple2_0(Ty) : Ty;

// Tclass._System.Tuple2 injectivity 0
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty :: 
  { Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1) } 
  Tclass._System.Tuple2_0(Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
     == _System._tuple#2$T0);

function Tclass._System.Tuple2_1(Ty) : Ty;

// Tclass._System.Tuple2 injectivity 1
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty :: 
  { Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1) } 
  Tclass._System.Tuple2_1(Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
     == _System._tuple#2$T1);

// Box/unbox axiom for Tclass._System.Tuple2
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty, bx: Box :: 
  { $IsBox(bx, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1)) } 
  $IsBox(bx, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
     ==> $Box($Unbox(bx): DatatypeType) == bx
       && $Is($Unbox(bx): DatatypeType, 
        Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1)));

// Constructor $Is
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty, a#2#0#0: Box, a#2#1#0: Box :: 
  { $Is(#_System._tuple#2._#Make2(a#2#0#0, a#2#1#0), 
      Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1)) } 
  $Is(#_System._tuple#2._#Make2(a#2#0#0, a#2#1#0), 
      Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
     <==> $IsBox(a#2#0#0, _System._tuple#2$T0) && $IsBox(a#2#1#0, _System._tuple#2$T1));

// Constructor $IsAlloc
axiom (forall _System._tuple#2$T0: Ty, 
    _System._tuple#2$T1: Ty, 
    a#2#0#0: Box, 
    a#2#1#0: Box, 
    $h: Heap :: 
  { $IsAlloc(#_System._tuple#2._#Make2(a#2#0#0, a#2#1#0), 
      Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), 
      $h) } 
  $IsGoodHeap($h)
     ==> ($IsAlloc(#_System._tuple#2._#Make2(a#2#0#0, a#2#1#0), 
        Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), 
        $h)
       <==> $IsAllocBox(a#2#0#0, _System._tuple#2$T0, $h)
         && $IsAllocBox(a#2#1#0, _System._tuple#2$T1, $h)));

// Destructor $IsAlloc
axiom (forall d: DatatypeType, _System._tuple#2$T0: Ty, $h: Heap :: 
  { $IsAllocBox(_System.Tuple2._0(d), _System._tuple#2$T0, $h) } 
  $IsGoodHeap($h)
       && 
      _System.Tuple2.___hMake2_q(d)
       && (exists _System._tuple#2$T1: Ty :: 
        { $IsAlloc(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), $h) } 
        $IsAlloc(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), $h))
     ==> $IsAllocBox(_System.Tuple2._0(d), _System._tuple#2$T0, $h));

// Destructor $IsAlloc
axiom (forall d: DatatypeType, _System._tuple#2$T1: Ty, $h: Heap :: 
  { $IsAllocBox(_System.Tuple2._1(d), _System._tuple#2$T1, $h) } 
  $IsGoodHeap($h)
       && 
      _System.Tuple2.___hMake2_q(d)
       && (exists _System._tuple#2$T0: Ty :: 
        { $IsAlloc(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), $h) } 
        $IsAlloc(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1), $h))
     ==> $IsAllocBox(_System.Tuple2._1(d), _System._tuple#2$T1, $h));

// Constructor literal
axiom (forall a#3#0#0: Box, a#3#1#0: Box :: 
  { #_System._tuple#2._#Make2(Lit(a#3#0#0), Lit(a#3#1#0)) } 
  #_System._tuple#2._#Make2(Lit(a#3#0#0), Lit(a#3#1#0))
     == Lit(#_System._tuple#2._#Make2(a#3#0#0, a#3#1#0)));

// Constructor injectivity
axiom (forall a#4#0#0: Box, a#4#1#0: Box :: 
  { #_System._tuple#2._#Make2(a#4#0#0, a#4#1#0) } 
  _System.Tuple2._0(#_System._tuple#2._#Make2(a#4#0#0, a#4#1#0)) == a#4#0#0);

// Inductive rank
axiom (forall a#5#0#0: Box, a#5#1#0: Box :: 
  { #_System._tuple#2._#Make2(a#5#0#0, a#5#1#0) } 
  BoxRank(a#5#0#0) < DtRank(#_System._tuple#2._#Make2(a#5#0#0, a#5#1#0)));

// Constructor injectivity
axiom (forall a#6#0#0: Box, a#6#1#0: Box :: 
  { #_System._tuple#2._#Make2(a#6#0#0, a#6#1#0) } 
  _System.Tuple2._1(#_System._tuple#2._#Make2(a#6#0#0, a#6#1#0)) == a#6#1#0);

// Inductive rank
axiom (forall a#7#0#0: Box, a#7#1#0: Box :: 
  { #_System._tuple#2._#Make2(a#7#0#0, a#7#1#0) } 
  BoxRank(a#7#1#0) < DtRank(#_System._tuple#2._#Make2(a#7#0#0, a#7#1#0)));

// Depth-one case-split function
function $IsA#_System.Tuple2(DatatypeType) : bool;

// Depth-one case-split axiom
axiom (forall d: DatatypeType :: 
  { $IsA#_System.Tuple2(d) } 
  $IsA#_System.Tuple2(d) ==> _System.Tuple2.___hMake2_q(d));

// Questionmark data type disjunctivity
axiom (forall _System._tuple#2$T0: Ty, _System._tuple#2$T1: Ty, d: DatatypeType :: 
  { _System.Tuple2.___hMake2_q(d), $Is(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1)) } 
  $Is(d, Tclass._System.Tuple2(_System._tuple#2$T0, _System._tuple#2$T1))
     ==> _System.Tuple2.___hMake2_q(d));

// Datatype extensional equality declaration
function _System.Tuple2#Equal(DatatypeType, DatatypeType) : bool;

// Datatype extensional equality definition: #_System._tuple#2._#Make2
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple2#Equal(a, b) } 
  true
     ==> (_System.Tuple2#Equal(a, b)
       <==> _System.Tuple2._0(a) == _System.Tuple2._0(b)
         && _System.Tuple2._1(a) == _System.Tuple2._1(b)));

// Datatype extensionality axiom: _System._tuple#2
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple2#Equal(a, b) } 
  _System.Tuple2#Equal(a, b) <==> a == b);

const unique class._System.Tuple2: ClassName;

// Constructor function declaration
function #_System._tuple#3._#Make3(Box, Box, Box) : DatatypeType;

// Constructor identifier
axiom (forall a#8#0#0: Box, a#8#1#0: Box, a#8#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#8#0#0, a#8#1#0, a#8#2#0) } 
  DatatypeCtorId(#_System._tuple#3._#Make3(a#8#0#0, a#8#1#0, a#8#2#0))
     == ##_System._tuple#3._#Make3);

const unique ##_System._tuple#3._#Make3: DtCtorId;

function _System.Tuple3.___hMake3_q(DatatypeType) : bool;

// Questionmark and identifier
axiom (forall d: DatatypeType :: 
  { _System.Tuple3.___hMake3_q(d) } 
  _System.Tuple3.___hMake3_q(d)
     <==> DatatypeCtorId(d) == ##_System._tuple#3._#Make3);

// Constructor questionmark has arguments
axiom (forall d: DatatypeType :: 
  { _System.Tuple3.___hMake3_q(d) } 
  _System.Tuple3.___hMake3_q(d)
     ==> (exists a#9#0#0: Box, a#9#1#0: Box, a#9#2#0: Box :: 
      d == #_System._tuple#3._#Make3(a#9#0#0, a#9#1#0, a#9#2#0)));

function Tclass._System.Tuple3(Ty, Ty, Ty) : Ty;

const unique Tagclass._System.Tuple3: TyTag;

// Tclass._System.Tuple3 Tag
axiom (forall _System._tuple#3$T0: Ty, _System._tuple#3$T1: Ty, _System._tuple#3$T2: Ty :: 
  { Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2) } 
  Tag(Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
       == Tagclass._System.Tuple3
     && TagFamily(Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
       == tytagFamily$_tuple#3);

function Tclass._System.Tuple3_0(Ty) : Ty;

// Tclass._System.Tuple3 injectivity 0
axiom (forall _System._tuple#3$T0: Ty, _System._tuple#3$T1: Ty, _System._tuple#3$T2: Ty :: 
  { Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2) } 
  Tclass._System.Tuple3_0(Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     == _System._tuple#3$T0);

function Tclass._System.Tuple3_1(Ty) : Ty;

// Tclass._System.Tuple3 injectivity 1
axiom (forall _System._tuple#3$T0: Ty, _System._tuple#3$T1: Ty, _System._tuple#3$T2: Ty :: 
  { Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2) } 
  Tclass._System.Tuple3_1(Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     == _System._tuple#3$T1);

function Tclass._System.Tuple3_2(Ty) : Ty;

// Tclass._System.Tuple3 injectivity 2
axiom (forall _System._tuple#3$T0: Ty, _System._tuple#3$T1: Ty, _System._tuple#3$T2: Ty :: 
  { Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2) } 
  Tclass._System.Tuple3_2(Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     == _System._tuple#3$T2);

// Box/unbox axiom for Tclass._System.Tuple3
axiom (forall _System._tuple#3$T0: Ty, 
    _System._tuple#3$T1: Ty, 
    _System._tuple#3$T2: Ty, 
    bx: Box :: 
  { $IsBox(bx, 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2)) } 
  $IsBox(bx, 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     ==> $Box($Unbox(bx): DatatypeType) == bx
       && $Is($Unbox(bx): DatatypeType, 
        Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2)));

// Constructor $Is
axiom (forall _System._tuple#3$T0: Ty, 
    _System._tuple#3$T1: Ty, 
    _System._tuple#3$T2: Ty, 
    a#10#0#0: Box, 
    a#10#1#0: Box, 
    a#10#2#0: Box :: 
  { $Is(#_System._tuple#3._#Make3(a#10#0#0, a#10#1#0, a#10#2#0), 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2)) } 
  $Is(#_System._tuple#3._#Make3(a#10#0#0, a#10#1#0, a#10#2#0), 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     <==> $IsBox(a#10#0#0, _System._tuple#3$T0)
       && $IsBox(a#10#1#0, _System._tuple#3$T1)
       && $IsBox(a#10#2#0, _System._tuple#3$T2));

// Constructor $IsAlloc
axiom (forall _System._tuple#3$T0: Ty, 
    _System._tuple#3$T1: Ty, 
    _System._tuple#3$T2: Ty, 
    a#10#0#0: Box, 
    a#10#1#0: Box, 
    a#10#2#0: Box, 
    $h: Heap :: 
  { $IsAlloc(#_System._tuple#3._#Make3(a#10#0#0, a#10#1#0, a#10#2#0), 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
      $h) } 
  $IsGoodHeap($h)
     ==> ($IsAlloc(#_System._tuple#3._#Make3(a#10#0#0, a#10#1#0, a#10#2#0), 
        Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
        $h)
       <==> $IsAllocBox(a#10#0#0, _System._tuple#3$T0, $h)
         && $IsAllocBox(a#10#1#0, _System._tuple#3$T1, $h)
         && $IsAllocBox(a#10#2#0, _System._tuple#3$T2, $h)));

// Destructor $IsAlloc
axiom (forall d: DatatypeType, _System._tuple#3$T0: Ty, $h: Heap :: 
  { $IsAllocBox(_System.Tuple3._0(d), _System._tuple#3$T0, $h) } 
  $IsGoodHeap($h)
       && 
      _System.Tuple3.___hMake3_q(d)
       && (exists _System._tuple#3$T1: Ty, _System._tuple#3$T2: Ty :: 
        { $IsAlloc(d, 
            Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
            $h) } 
        $IsAlloc(d, 
          Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
          $h))
     ==> $IsAllocBox(_System.Tuple3._0(d), _System._tuple#3$T0, $h));

// Destructor $IsAlloc
axiom (forall d: DatatypeType, _System._tuple#3$T1: Ty, $h: Heap :: 
  { $IsAllocBox(_System.Tuple3._1(d), _System._tuple#3$T1, $h) } 
  $IsGoodHeap($h)
       && 
      _System.Tuple3.___hMake3_q(d)
       && (exists _System._tuple#3$T0: Ty, _System._tuple#3$T2: Ty :: 
        { $IsAlloc(d, 
            Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
            $h) } 
        $IsAlloc(d, 
          Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
          $h))
     ==> $IsAllocBox(_System.Tuple3._1(d), _System._tuple#3$T1, $h));

// Destructor $IsAlloc
axiom (forall d: DatatypeType, _System._tuple#3$T2: Ty, $h: Heap :: 
  { $IsAllocBox(_System.Tuple3._2(d), _System._tuple#3$T2, $h) } 
  $IsGoodHeap($h)
       && 
      _System.Tuple3.___hMake3_q(d)
       && (exists _System._tuple#3$T0: Ty, _System._tuple#3$T1: Ty :: 
        { $IsAlloc(d, 
            Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
            $h) } 
        $IsAlloc(d, 
          Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2), 
          $h))
     ==> $IsAllocBox(_System.Tuple3._2(d), _System._tuple#3$T2, $h));

// Constructor literal
axiom (forall a#11#0#0: Box, a#11#1#0: Box, a#11#2#0: Box :: 
  { #_System._tuple#3._#Make3(Lit(a#11#0#0), Lit(a#11#1#0), Lit(a#11#2#0)) } 
  #_System._tuple#3._#Make3(Lit(a#11#0#0), Lit(a#11#1#0), Lit(a#11#2#0))
     == Lit(#_System._tuple#3._#Make3(a#11#0#0, a#11#1#0, a#11#2#0)));

function _System.Tuple3._0(DatatypeType) : Box;

// Constructor injectivity
axiom (forall a#12#0#0: Box, a#12#1#0: Box, a#12#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#12#0#0, a#12#1#0, a#12#2#0) } 
  _System.Tuple3._0(#_System._tuple#3._#Make3(a#12#0#0, a#12#1#0, a#12#2#0))
     == a#12#0#0);

// Inductive rank
axiom (forall a#13#0#0: Box, a#13#1#0: Box, a#13#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#13#0#0, a#13#1#0, a#13#2#0) } 
  BoxRank(a#13#0#0)
     < DtRank(#_System._tuple#3._#Make3(a#13#0#0, a#13#1#0, a#13#2#0)));

function _System.Tuple3._1(DatatypeType) : Box;

// Constructor injectivity
axiom (forall a#14#0#0: Box, a#14#1#0: Box, a#14#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#14#0#0, a#14#1#0, a#14#2#0) } 
  _System.Tuple3._1(#_System._tuple#3._#Make3(a#14#0#0, a#14#1#0, a#14#2#0))
     == a#14#1#0);

// Inductive rank
axiom (forall a#15#0#0: Box, a#15#1#0: Box, a#15#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#15#0#0, a#15#1#0, a#15#2#0) } 
  BoxRank(a#15#1#0)
     < DtRank(#_System._tuple#3._#Make3(a#15#0#0, a#15#1#0, a#15#2#0)));

function _System.Tuple3._2(DatatypeType) : Box;

// Constructor injectivity
axiom (forall a#16#0#0: Box, a#16#1#0: Box, a#16#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#16#0#0, a#16#1#0, a#16#2#0) } 
  _System.Tuple3._2(#_System._tuple#3._#Make3(a#16#0#0, a#16#1#0, a#16#2#0))
     == a#16#2#0);

// Inductive rank
axiom (forall a#17#0#0: Box, a#17#1#0: Box, a#17#2#0: Box :: 
  { #_System._tuple#3._#Make3(a#17#0#0, a#17#1#0, a#17#2#0) } 
  BoxRank(a#17#2#0)
     < DtRank(#_System._tuple#3._#Make3(a#17#0#0, a#17#1#0, a#17#2#0)));

// Depth-one case-split function
function $IsA#_System.Tuple3(DatatypeType) : bool;

// Depth-one case-split axiom
axiom (forall d: DatatypeType :: 
  { $IsA#_System.Tuple3(d) } 
  $IsA#_System.Tuple3(d) ==> _System.Tuple3.___hMake3_q(d));

// Questionmark data type disjunctivity
axiom (forall _System._tuple#3$T0: Ty, 
    _System._tuple#3$T1: Ty, 
    _System._tuple#3$T2: Ty, 
    d: DatatypeType :: 
  { _System.Tuple3.___hMake3_q(d), $Is(d, 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2)) } 
  $Is(d, 
      Tclass._System.Tuple3(_System._tuple#3$T0, _System._tuple#3$T1, _System._tuple#3$T2))
     ==> _System.Tuple3.___hMake3_q(d));

// Datatype extensional equality declaration
function _System.Tuple3#Equal(DatatypeType, DatatypeType) : bool;

// Datatype extensional equality definition: #_System._tuple#3._#Make3
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple3#Equal(a, b) } 
  true
     ==> (_System.Tuple3#Equal(a, b)
       <==> _System.Tuple3._0(a) == _System.Tuple3._0(b)
         && _System.Tuple3._1(a) == _System.Tuple3._1(b)
         && _System.Tuple3._2(a) == _System.Tuple3._2(b)));

// Datatype extensionality axiom: _System._tuple#3
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple3#Equal(a, b) } 
  _System.Tuple3#Equal(a, b) <==> a == b);

const unique class._System.Tuple3: ClassName;

// Constructor function declaration
function #_System._tuple#0._#Make0() : DatatypeType;

// Constructor identifier
axiom DatatypeCtorId(#_System._tuple#0._#Make0()) == ##_System._tuple#0._#Make0;

const unique ##_System._tuple#0._#Make0: DtCtorId;

function _System.Tuple0.___hMake0_q(DatatypeType) : bool;

// Questionmark and identifier
axiom (forall d: DatatypeType :: 
  { _System.Tuple0.___hMake0_q(d) } 
  _System.Tuple0.___hMake0_q(d)
     <==> DatatypeCtorId(d) == ##_System._tuple#0._#Make0);

// Constructor questionmark has arguments
axiom (forall d: DatatypeType :: 
  { _System.Tuple0.___hMake0_q(d) } 
  _System.Tuple0.___hMake0_q(d) ==> d == #_System._tuple#0._#Make0());

function Tclass._System.Tuple0() : Ty;

const unique Tagclass._System.Tuple0: TyTag;

// Tclass._System.Tuple0 Tag
axiom Tag(Tclass._System.Tuple0()) == Tagclass._System.Tuple0
   && TagFamily(Tclass._System.Tuple0()) == tytagFamily$_tuple#0;

// Box/unbox axiom for Tclass._System.Tuple0
axiom (forall bx: Box :: 
  { $IsBox(bx, Tclass._System.Tuple0()) } 
  $IsBox(bx, Tclass._System.Tuple0())
     ==> $Box($Unbox(bx): DatatypeType) == bx
       && $Is($Unbox(bx): DatatypeType, Tclass._System.Tuple0()));

// Constructor $Is
axiom $Is(#_System._tuple#0._#Make0(), Tclass._System.Tuple0());

// Constructor $IsAlloc
axiom (forall $h: Heap :: 
  { $IsAlloc(#_System._tuple#0._#Make0(), Tclass._System.Tuple0(), $h) } 
  $IsGoodHeap($h)
     ==> $IsAlloc(#_System._tuple#0._#Make0(), Tclass._System.Tuple0(), $h));

// Constructor literal
axiom #_System._tuple#0._#Make0() == Lit(#_System._tuple#0._#Make0());

// Depth-one case-split function
function $IsA#_System.Tuple0(DatatypeType) : bool;

// Depth-one case-split axiom
axiom (forall d: DatatypeType :: 
  { $IsA#_System.Tuple0(d) } 
  $IsA#_System.Tuple0(d) ==> _System.Tuple0.___hMake0_q(d));

// Questionmark data type disjunctivity
axiom (forall d: DatatypeType :: 
  { _System.Tuple0.___hMake0_q(d), $Is(d, Tclass._System.Tuple0()) } 
  $Is(d, Tclass._System.Tuple0()) ==> _System.Tuple0.___hMake0_q(d));

// Datatype extensional equality declaration
function _System.Tuple0#Equal(DatatypeType, DatatypeType) : bool;

// Datatype extensional equality definition: #_System._tuple#0._#Make0
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple0#Equal(a, b) } 
  true ==> (_System.Tuple0#Equal(a, b) <==> true));

// Datatype extensionality axiom: _System._tuple#0
axiom (forall a: DatatypeType, b: DatatypeType :: 
  { _System.Tuple0#Equal(a, b) } 
  _System.Tuple0#Equal(a, b) <==> a == b);

const unique class._System.Tuple0: ClassName;

const BaseFuel_Seq._default.ToSet: LayerType;

const StartFuel_Seq._default.ToSet: LayerType;

const StartFuelAssert_Seq._default.ToSet: LayerType;

const BaseFuel_Seq._default.HasNoDuplicates: LayerType;

const StartFuel_Seq._default.HasNoDuplicates: LayerType;

const StartFuelAssert_Seq._default.HasNoDuplicates: LayerType;

const BaseFuel_Seq._default.IndexOf: LayerType;

const StartFuel_Seq._default.IndexOf: LayerType;

const StartFuelAssert_Seq._default.IndexOf: LayerType;

const BaseFuel_Seq._default.IndexOfOption: LayerType;

const StartFuel_Seq._default.IndexOfOption: LayerType;

const StartFuelAssert_Seq._default.IndexOfOption: LayerType;

const BaseFuel_Seq._default.LastIndexOf: LayerType;

const StartFuel_Seq._default.LastIndexOf: LayerType;

const StartFuelAssert_Seq._default.LastIndexOf: LayerType;

const BaseFuel_Seq._default.LastIndexOfOption: LayerType;

const StartFuel_Seq._default.LastIndexOfOption: LayerType;

const StartFuelAssert_Seq._default.LastIndexOfOption: LayerType;

const BaseFuel_Seq._default.Remove: LayerType;

const StartFuel_Seq._default.Remove: LayerType;

const StartFuelAssert_Seq._default.Remove: LayerType;

const BaseFuel_Seq._default.RemoveValue: LayerType;

const StartFuel_Seq._default.RemoveValue: LayerType;

const StartFuelAssert_Seq._default.RemoveValue: LayerType;

const BaseFuel_Seq._default.Insert: LayerType;

const StartFuel_Seq._default.Insert: LayerType;

const StartFuelAssert_Seq._default.Insert: LayerType;

const BaseFuel_Seq._default.Reverse: LayerType;

const StartFuel_Seq._default.Reverse: LayerType;

const StartFuelAssert_Seq._default.Reverse: LayerType;

const BaseFuel_Seq._default.Repeat: LayerType;

const StartFuel_Seq._default.Repeat: LayerType;

const StartFuelAssert_Seq._default.Repeat: LayerType;

const BaseFuel_Seq._default.Unzip: LayerType;

const StartFuel_Seq._default.Unzip: LayerType;

const StartFuelAssert_Seq._default.Unzip: LayerType;

const BaseFuel_Seq._default.Zip: LayerType;

const StartFuel_Seq._default.Zip: LayerType;

const StartFuelAssert_Seq._default.Zip: LayerType;

const BaseFuel_Seq._default.Max: LayerType;

const StartFuel_Seq._default.Max: LayerType;

const StartFuelAssert_Seq._default.Max: LayerType;

const BaseFuel_Seq._default.Min: LayerType;

const StartFuel_Seq._default.Min: LayerType;

const StartFuelAssert_Seq._default.Min: LayerType;

const BaseFuel_Seq._default.Map: LayerType;

const StartFuel_Seq._default.Map: LayerType;

const StartFuelAssert_Seq._default.Map: LayerType;

const BaseFuel_Seq._default.MapWithResult: LayerType;

const StartFuel_Seq._default.MapWithResult: LayerType;

const StartFuelAssert_Seq._default.MapWithResult: LayerType;

const BaseFuel_Seq._default.Filter: LayerType;

const StartFuel_Seq._default.Filter: LayerType;

const StartFuelAssert_Seq._default.Filter: LayerType;

const BaseFuel_Seq._default.FoldLeft: LayerType;

const StartFuel_Seq._default.FoldLeft: LayerType;

const StartFuelAssert_Seq._default.FoldLeft: LayerType;

const BaseFuel_Seq._default.FoldRight: LayerType;

const StartFuel_Seq._default.FoldRight: LayerType;

const StartFuelAssert_Seq._default.FoldRight: LayerType;

const unique class.Seq.__default: ClassName;

function Tclass.Seq.__default() : Ty;

const unique Tagclass.Seq.__default: TyTag;

// Tclass.Seq.__default Tag
axiom Tag(Tclass.Seq.__default()) == Tagclass.Seq.__default
   && TagFamily(Tclass.Seq.__default()) == tytagFamily$_default;

// Box/unbox axiom for Tclass.Seq.__default
axiom (forall bx: Box :: 
  { $IsBox(bx, Tclass.Seq.__default()) } 
  $IsBox(bx, Tclass.Seq.__default())
     ==> $Box($Unbox(bx): ref) == bx && $Is($Unbox(bx): ref, Tclass.Seq.__default()));

// _default: Class $Is
axiom (forall $o: ref :: 
  { $Is($o, Tclass.Seq.__default()) } 
  $Is($o, Tclass.Seq.__default())
     <==> $o == null || dtype($o) == Tclass.Seq.__default());

// _default: Class $IsAlloc
axiom (forall $o: ref, $h: Heap :: 
  { $IsAlloc($o, Tclass.Seq.__default(), $h) } 
  $IsAlloc($o, Tclass.Seq.__default(), $h) <==> $o == null || read($h, $o, alloc));

// function declaration for Seq._default.First
function Seq.__default.First(Seq._default.First$T: Ty, s#0: Seq Box) : Box;

function Seq.__default.First#canCall(Seq._default.First$T: Ty, s#0: Seq Box) : bool;

// consequence axiom for Seq.__default.First
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.First$T: Ty, s#0: Seq Box :: 
    { Seq.__default.First(Seq._default.First$T, s#0) } 
    Seq.__default.First#canCall(Seq._default.First$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.First$T))
           && Seq#Length(s#0) > 0)
       ==> $IsBox(Seq.__default.First(Seq._default.First$T, s#0), Seq._default.First$T));

function Seq.__default.First#requires(Ty, Seq Box) : bool;

// #requires axiom for Seq.__default.First
axiom (forall Seq._default.First$T: Ty, s#0: Seq Box :: 
  { Seq.__default.First#requires(Seq._default.First$T, s#0) } 
  $Is(s#0, TSeq(Seq._default.First$T))
     ==> Seq.__default.First#requires(Seq._default.First$T, s#0) == (Seq#Length(s#0) > 0));

// definition axiom for Seq.__default.First (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.First$T: Ty, s#0: Seq Box :: 
    { Seq.__default.First(Seq._default.First$T, s#0) } 
    Seq.__default.First#canCall(Seq._default.First$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.First$T))
           && Seq#Length(s#0) > 0)
       ==> Seq.__default.First(Seq._default.First$T, s#0) == Seq#Index(s#0, LitInt(0)));

// definition axiom for Seq.__default.First for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.First$T: Ty, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.First(Seq._default.First$T, Lit(s#0)) } 
    Seq.__default.First#canCall(Seq._default.First$T, Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.First$T))
           && Seq#Length(Lit(s#0)) > 0)
       ==> Seq.__default.First(Seq._default.First$T, Lit(s#0))
         == Seq#Index(Lit(s#0), LitInt(0)));

procedure {:verboseName "Seq.First (well-formedness)"} CheckWellformed$$Seq.__default.First(Seq._default.First$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.First$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.First (well-formedness)"} CheckWellformed$$Seq.__default.First(Seq._default.First$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;


    // AddWellformednessCheck for function First
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Length(s#0) > 0;
    if (*)
    {
        assume $IsBox(Seq.__default.First(Seq._default.First$T, s#0), Seq._default.First$T);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
        assume Seq.__default.First(Seq._default.First$T, s#0) == Seq#Index(s#0, LitInt(0));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $IsBox(Seq.__default.First(Seq._default.First$T, s#0), Seq._default.First$T);
    }
}



// function declaration for Seq._default.DropFirst
function Seq.__default.DropFirst(Seq._default.DropFirst$T: Ty, s#0: Seq Box) : Seq Box;

function Seq.__default.DropFirst#canCall(Seq._default.DropFirst$T: Ty, s#0: Seq Box) : bool;

// consequence axiom for Seq.__default.DropFirst
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropFirst$T: Ty, s#0: Seq Box :: 
    { Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0) } 
    Seq.__default.DropFirst#canCall(Seq._default.DropFirst$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropFirst$T))
           && Seq#Length(s#0) > 0)
       ==> $Is(Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0), 
        TSeq(Seq._default.DropFirst$T)));

function Seq.__default.DropFirst#requires(Ty, Seq Box) : bool;

// #requires axiom for Seq.__default.DropFirst
axiom (forall Seq._default.DropFirst$T: Ty, s#0: Seq Box :: 
  { Seq.__default.DropFirst#requires(Seq._default.DropFirst$T, s#0) } 
  $Is(s#0, TSeq(Seq._default.DropFirst$T))
     ==> Seq.__default.DropFirst#requires(Seq._default.DropFirst$T, s#0)
       == (Seq#Length(s#0) > 0));

// definition axiom for Seq.__default.DropFirst (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropFirst$T: Ty, s#0: Seq Box :: 
    { Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0) } 
    Seq.__default.DropFirst#canCall(Seq._default.DropFirst$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropFirst$T))
           && Seq#Length(s#0) > 0)
       ==> Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0)
         == Seq#Drop(s#0, LitInt(1)));

// definition axiom for Seq.__default.DropFirst for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropFirst$T: Ty, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.DropFirst(Seq._default.DropFirst$T, Lit(s#0)) } 
    Seq.__default.DropFirst#canCall(Seq._default.DropFirst$T, Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropFirst$T))
           && Seq#Length(Lit(s#0)) > 0)
       ==> Seq.__default.DropFirst(Seq._default.DropFirst$T, Lit(s#0))
         == Lit(Seq#Drop(Lit(s#0), LitInt(1))));

procedure {:verboseName "Seq.DropFirst (well-formedness)"} CheckWellformed$$Seq.__default.DropFirst(Seq._default.DropFirst$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.DropFirst$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.DropFirst (well-formedness)"} CheckWellformed$$Seq.__default.DropFirst(Seq._default.DropFirst$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;


    // AddWellformednessCheck for function DropFirst
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Length(s#0) > 0;
    if (*)
    {
        assume $Is(Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0), 
          TSeq(Seq._default.DropFirst$T));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
        assume Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0)
           == Seq#Drop(s#0, LitInt(1));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.DropFirst(Seq._default.DropFirst$T, s#0), 
          TSeq(Seq._default.DropFirst$T));
    }
}



// function declaration for Seq._default.Last
function Seq.__default.Last(Seq._default.Last$T: Ty, s#0: Seq Box) : Box;

function Seq.__default.Last#canCall(Seq._default.Last$T: Ty, s#0: Seq Box) : bool;

// consequence axiom for Seq.__default.Last
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Last$T: Ty, s#0: Seq Box :: 
    { Seq.__default.Last(Seq._default.Last$T, s#0) } 
    Seq.__default.Last#canCall(Seq._default.Last$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Last$T))
           && Seq#Length(s#0) > 0)
       ==> $IsBox(Seq.__default.Last(Seq._default.Last$T, s#0), Seq._default.Last$T));

function Seq.__default.Last#requires(Ty, Seq Box) : bool;

// #requires axiom for Seq.__default.Last
axiom (forall Seq._default.Last$T: Ty, s#0: Seq Box :: 
  { Seq.__default.Last#requires(Seq._default.Last$T, s#0) } 
  $Is(s#0, TSeq(Seq._default.Last$T))
     ==> Seq.__default.Last#requires(Seq._default.Last$T, s#0) == (Seq#Length(s#0) > 0));

// definition axiom for Seq.__default.Last (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Last$T: Ty, s#0: Seq Box :: 
    { Seq.__default.Last(Seq._default.Last$T, s#0) } 
    Seq.__default.Last#canCall(Seq._default.Last$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Last$T))
           && Seq#Length(s#0) > 0)
       ==> Seq.__default.Last(Seq._default.Last$T, s#0)
         == Seq#Index(s#0, Seq#Length(s#0) - 1));

// definition axiom for Seq.__default.Last for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Last$T: Ty, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Last(Seq._default.Last$T, Lit(s#0)) } 
    Seq.__default.Last#canCall(Seq._default.Last$T, Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Last$T))
           && Seq#Length(Lit(s#0)) > 0)
       ==> Seq.__default.Last(Seq._default.Last$T, Lit(s#0))
         == Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1));

procedure {:verboseName "Seq.Last (well-formedness)"} CheckWellformed$$Seq.__default.Last(Seq._default.Last$T: Ty, s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Last$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.Last (well-formedness)"} CheckWellformed$$Seq.__default.Last(Seq._default.Last$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;


    // AddWellformednessCheck for function Last
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Length(s#0) > 0;
    if (*)
    {
        assume $IsBox(Seq.__default.Last(Seq._default.Last$T, s#0), Seq._default.Last$T);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 < Seq#Length(s#0);
        assume Seq.__default.Last(Seq._default.Last$T, s#0)
           == Seq#Index(s#0, Seq#Length(s#0) - 1);
        assume true;
        // CheckWellformedWithResult: any expression
        assume $IsBox(Seq.__default.Last(Seq._default.Last$T, s#0), Seq._default.Last$T);
    }
}



// function declaration for Seq._default.DropLast
function Seq.__default.DropLast(Seq._default.DropLast$T: Ty, s#0: Seq Box) : Seq Box;

function Seq.__default.DropLast#canCall(Seq._default.DropLast$T: Ty, s#0: Seq Box) : bool;

// consequence axiom for Seq.__default.DropLast
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropLast$T: Ty, s#0: Seq Box :: 
    { Seq.__default.DropLast(Seq._default.DropLast$T, s#0) } 
    Seq.__default.DropLast#canCall(Seq._default.DropLast$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropLast$T))
           && Seq#Length(s#0) > 0)
       ==> $Is(Seq.__default.DropLast(Seq._default.DropLast$T, s#0), 
        TSeq(Seq._default.DropLast$T)));

function Seq.__default.DropLast#requires(Ty, Seq Box) : bool;

// #requires axiom for Seq.__default.DropLast
axiom (forall Seq._default.DropLast$T: Ty, s#0: Seq Box :: 
  { Seq.__default.DropLast#requires(Seq._default.DropLast$T, s#0) } 
  $Is(s#0, TSeq(Seq._default.DropLast$T))
     ==> Seq.__default.DropLast#requires(Seq._default.DropLast$T, s#0)
       == (Seq#Length(s#0) > 0));

// definition axiom for Seq.__default.DropLast (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropLast$T: Ty, s#0: Seq Box :: 
    { Seq.__default.DropLast(Seq._default.DropLast$T, s#0) } 
    Seq.__default.DropLast#canCall(Seq._default.DropLast$T, s#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropLast$T))
           && Seq#Length(s#0) > 0)
       ==> Seq.__default.DropLast(Seq._default.DropLast$T, s#0)
         == Seq#Take(s#0, Seq#Length(s#0) - 1));

// definition axiom for Seq.__default.DropLast for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.DropLast$T: Ty, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.DropLast(Seq._default.DropLast$T, Lit(s#0)) } 
    Seq.__default.DropLast#canCall(Seq._default.DropLast$T, Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.DropLast$T))
           && Seq#Length(Lit(s#0)) > 0)
       ==> Seq.__default.DropLast(Seq._default.DropLast$T, Lit(s#0))
         == Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1));

procedure {:verboseName "Seq.DropLast (well-formedness)"} CheckWellformed$$Seq.__default.DropLast(Seq._default.DropLast$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.DropLast$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.DropLast (well-formedness)"} CheckWellformed$$Seq.__default.DropLast(Seq._default.DropLast$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;


    // AddWellformednessCheck for function DropLast
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Length(s#0) > 0;
    if (*)
    {
        assume $Is(Seq.__default.DropLast(Seq._default.DropLast$T, s#0), 
          TSeq(Seq._default.DropLast$T));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
        assume Seq.__default.DropLast(Seq._default.DropLast$T, s#0)
           == Seq#Take(s#0, Seq#Length(s#0) - 1);
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.DropLast(Seq._default.DropLast$T, s#0), 
          TSeq(Seq._default.DropLast$T));
    }
}



procedure {:verboseName "Seq.LemmaLast (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaLast(Seq._default.LemmaLast$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaLast$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaLast$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaLast (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaLast(Seq._default.LemmaLast$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;

    // AddMethodImpl: LemmaLast, CheckWellFormed$$Seq.__default.LemmaLast
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    assume Seq#Length(s#0) > 0;
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(Seq._default.LemmaLast$T), $Heap);
    assert {:subsumption 0} Seq#Length(##s#0) > 0;
    assume Seq#Length(##s#0) > 0;
    assume Seq.__default.DropLast#canCall(Seq._default.LemmaLast$T, s#0);
    ##s#1 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(Seq._default.LemmaLast$T), $Heap);
    assert {:subsumption 0} Seq#Length(##s#1) > 0;
    assume Seq#Length(##s#1) > 0;
    assume Seq.__default.Last#canCall(Seq._default.LemmaLast$T, s#0);
    assume Seq#Equal(Seq#Append(Seq.__default.DropLast(Seq._default.LemmaLast$T, s#0), 
        Seq#Build(Seq#Empty(): Seq Box, Seq.__default.Last(Seq._default.LemmaLast$T, s#0))), 
      s#0);
}



procedure {:verboseName "Seq.LemmaLast (call)"} Call$$Seq.__default.LemmaLast(Seq._default.LemmaLast$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaLast$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaLast$T), $Heap));
  // user-defined preconditions
  requires Seq#Length(s#0) > 0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.DropLast#canCall(Seq._default.LemmaLast$T, s#0)
     && Seq.__default.Last#canCall(Seq._default.LemmaLast$T, s#0);
  ensures Seq#Equal(Seq#Append(Seq.__default.DropLast(Seq._default.LemmaLast$T, s#0), 
      Seq#Build(Seq#Empty(): Seq Box, Seq.__default.Last(Seq._default.LemmaLast$T, s#0))), 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaLast (correctness)"} Impl$$Seq.__default.LemmaLast(Seq._default.LemmaLast$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaLast$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaLast$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires Seq#Length(s#0) > 0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.DropLast#canCall(Seq._default.LemmaLast$T, s#0)
     && Seq.__default.Last#canCall(Seq._default.LemmaLast$T, s#0);
  ensures Seq#Equal(Seq#Append(Seq.__default.DropLast(Seq._default.LemmaLast$T, s#0), 
      Seq#Build(Seq#Empty(): Seq Box, Seq.__default.Last(Seq._default.LemmaLast$T, s#0))), 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaLast (correctness)"} Impl$$Seq.__default.LemmaLast(Seq._default.LemmaLast$T: Ty, s#0: Seq Box) returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaLast, Impl$$Seq.__default.LemmaLast
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
}



procedure {:verboseName "Seq.LemmaAppendLast (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaAppendLast(Seq._default.LemmaAppendLast$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaAppendLast (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaAppendLast(Seq._default.LemmaAppendLast$T: Ty, a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;

    // AddMethodImpl: LemmaAppendLast, CheckWellFormed$$Seq.__default.LemmaAppendLast
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    assume 0 < Seq#Length(Seq#Append(a#0, b#0));
    assume 0 < Seq#Length(b#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap);
    assert {:subsumption 0} Seq#Length(##s#0) > 0;
    assume Seq#Length(##s#0) > 0;
    assume Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0));
    ##s#1 := b#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(Seq._default.LemmaAppendLast$T), $Heap);
    assert {:subsumption 0} Seq#Length(##s#1) > 0;
    assume Seq#Length(##s#1) > 0;
    assume Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, b#0);
    assume Seq.__default.Last(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0))
       == Seq.__default.Last(Seq._default.LemmaAppendLast$T, b#0);
}



procedure {:verboseName "Seq.LemmaAppendLast (call)"} Call$$Seq.__default.LemmaAppendLast(Seq._default.LemmaAppendLast$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap));
  // user-defined preconditions
  requires 0 < Seq#Length(Seq#Append(a#0, b#0));
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0))
     && Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, b#0);
  ensures Seq.__default.Last(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0))
     == Seq.__default.Last(Seq._default.LemmaAppendLast$T, b#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaAppendLast (correctness)"} Impl$$Seq.__default.LemmaAppendLast(Seq._default.LemmaAppendLast$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaAppendLast$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaAppendLast$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires 0 < Seq#Length(Seq#Append(a#0, b#0));
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0))
     && Seq.__default.Last#canCall(Seq._default.LemmaAppendLast$T, b#0);
  ensures Seq.__default.Last(Seq._default.LemmaAppendLast$T, Seq#Append(a#0, b#0))
     == Seq.__default.Last(Seq._default.LemmaAppendLast$T, b#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaAppendLast (correctness)"} Impl$$Seq.__default.LemmaAppendLast(Seq._default.LemmaAppendLast$T: Ty, a#0: Seq Box, b#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaAppendLast, Impl$$Seq.__default.LemmaAppendLast
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
}



procedure {:verboseName "Seq.LemmaConcatIsAssociative (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaConcatIsAssociative(Seq._default.LemmaConcatIsAssociative$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    c#0: Seq Box
       where $Is(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaConcatIsAssociative (call)"} Call$$Seq.__default.LemmaConcatIsAssociative(Seq._default.LemmaConcatIsAssociative$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    c#0: Seq Box
       where $Is(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Append(a#0, Seq#Append(b#0, c#0)), Seq#Append(Seq#Append(a#0, b#0), c#0));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaConcatIsAssociative (correctness)"} Impl$$Seq.__default.LemmaConcatIsAssociative(Seq._default.LemmaConcatIsAssociative$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap), 
    c#0: Seq Box
       where $Is(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T))
         && $IsAlloc(c#0, TSeq(Seq._default.LemmaConcatIsAssociative$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Append(a#0, Seq#Append(b#0, c#0)), Seq#Append(Seq#Append(a#0, b#0), c#0));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaConcatIsAssociative (correctness)"} Impl$$Seq.__default.LemmaConcatIsAssociative(Seq._default.LemmaConcatIsAssociative$T: Ty, 
    a#0: Seq Box, 
    b#0: Seq Box, 
    c#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaConcatIsAssociative, Impl$$Seq.__default.LemmaConcatIsAssociative
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
}



// function declaration for Seq._default.IsPrefix
function Seq.__default.IsPrefix(Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box) : bool;

function Seq.__default.IsPrefix#canCall(Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box) : bool;

// consequence axiom for Seq.__default.IsPrefix
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    { Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0) } 
    Seq.__default.IsPrefix#canCall(Seq._default.IsPrefix$T, a#0, b#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsPrefix$T))
           && $Is(b#0, TSeq(Seq._default.IsPrefix$T)))
       ==> 
      Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
       ==> Seq#Length(a#0) <= Seq#Length(b#0)
         && Seq#Equal(a#0, Seq#Take(b#0, Seq#Length(a#0))));

function Seq.__default.IsPrefix#requires(Ty, Seq Box, Seq Box) : bool;

// #requires axiom for Seq.__default.IsPrefix
axiom (forall Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
  { Seq.__default.IsPrefix#requires(Seq._default.IsPrefix$T, a#0, b#0) } 
  $Is(a#0, TSeq(Seq._default.IsPrefix$T))
       && $Is(b#0, TSeq(Seq._default.IsPrefix$T))
     ==> Seq.__default.IsPrefix#requires(Seq._default.IsPrefix$T, a#0, b#0) == true);

// definition axiom for Seq.__default.IsPrefix (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    { Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0) } 
    Seq.__default.IsPrefix#canCall(Seq._default.IsPrefix$T, a#0, b#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsPrefix$T))
           && $Is(b#0, TSeq(Seq._default.IsPrefix$T)))
       ==> Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
         == (Seq#Length(a#0) <= Seq#Length(b#0) && Seq#SameUntil(a#0, b#0, Seq#Length(a#0))));

// definition axiom for Seq.__default.IsPrefix for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    {:weight 3} { Seq.__default.IsPrefix(Seq._default.IsPrefix$T, Lit(a#0), Lit(b#0)) } 
    Seq.__default.IsPrefix#canCall(Seq._default.IsPrefix$T, Lit(a#0), Lit(b#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsPrefix$T))
           && $Is(b#0, TSeq(Seq._default.IsPrefix$T)))
       ==> Seq.__default.IsPrefix(Seq._default.IsPrefix$T, Lit(a#0), Lit(b#0))
         == (Seq#Length(a#0) <= Seq#Length(b#0) && Seq#SameUntil(a#0, b#0, Seq#Length(a#0))));

procedure {:verboseName "Seq.IsPrefix (well-formedness)"} CheckWellformed$$Seq.__default.IsPrefix(Seq._default.IsPrefix$T: Ty, 
    a#0: Seq Box where $Is(a#0, TSeq(Seq._default.IsPrefix$T)), 
    b#0: Seq Box where $Is(b#0, TSeq(Seq._default.IsPrefix$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
     ==> Seq#Length(a#0) <= Seq#Length(b#0);
  ensures Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
     ==> Seq#Equal(a#0, Seq#Take(b#0, Seq#Length(a#0)));



implementation {:verboseName "Seq.IsPrefix (well-formedness)"} CheckWellformed$$Seq.__default.IsPrefix(Seq._default.IsPrefix$T: Ty, a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##a#0: Seq Box;
  var ##b#0: Seq Box;


    // AddWellformednessCheck for function IsPrefix
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        if (*)
        {
            ##a#0 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##a#0, TSeq(Seq._default.IsPrefix$T), $Heap);
            ##b#0 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##b#0, TSeq(Seq._default.IsPrefix$T), $Heap);
            assert (a#0 == a#0 && b#0 == b#0)
               || 
              Seq#Rank(##a#0) < Seq#Rank(a#0)
               || (Seq#Rank(##a#0) == Seq#Rank(a#0) && Seq#Rank(##b#0) < Seq#Rank(b#0));
            assume (a#0 == a#0 && b#0 == b#0)
               || Seq.__default.IsPrefix#canCall(Seq._default.IsPrefix$T, a#0, b#0);
            assume Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0);
            if (Seq#Length(a#0) <= Seq#Length(b#0))
            {
                assert 0 <= Seq#Length(a#0) && Seq#Length(a#0) <= Seq#Length(b#0);
            }

            assume Seq#Length(a#0) <= Seq#Length(b#0)
               && Seq#Equal(a#0, Seq#Take(b#0, Seq#Length(a#0)));
        }
        else
        {
            assume Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
               ==> Seq#Length(a#0) <= Seq#Length(b#0)
                 && Seq#Equal(a#0, Seq#Take(b#0, Seq#Length(a#0)));
        }

        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assume Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0)
           == (Seq#Length(a#0) <= Seq#Length(b#0) && Seq#SameUntil(a#0, b#0, Seq#Length(a#0)));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.IsPrefix(Seq._default.IsPrefix$T, a#0, b#0), TBool);
    }
}



// function declaration for Seq._default.IsSuffix
function Seq.__default.IsSuffix(Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box) : bool;

function Seq.__default.IsSuffix#canCall(Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box) : bool;

// consequence axiom for Seq.__default.IsSuffix
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    { Seq.__default.IsSuffix(Seq._default.IsSuffix$T, a#0, b#0) } 
    Seq.__default.IsSuffix#canCall(Seq._default.IsSuffix$T, a#0, b#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsSuffix$T))
           && $Is(b#0, TSeq(Seq._default.IsSuffix$T)))
       ==> true);

function Seq.__default.IsSuffix#requires(Ty, Seq Box, Seq Box) : bool;

// #requires axiom for Seq.__default.IsSuffix
axiom (forall Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
  { Seq.__default.IsSuffix#requires(Seq._default.IsSuffix$T, a#0, b#0) } 
  $Is(a#0, TSeq(Seq._default.IsSuffix$T))
       && $Is(b#0, TSeq(Seq._default.IsSuffix$T))
     ==> Seq.__default.IsSuffix#requires(Seq._default.IsSuffix$T, a#0, b#0) == true);

// definition axiom for Seq.__default.IsSuffix (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    { Seq.__default.IsSuffix(Seq._default.IsSuffix$T, a#0, b#0) } 
    Seq.__default.IsSuffix#canCall(Seq._default.IsSuffix$T, a#0, b#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsSuffix$T))
           && $Is(b#0, TSeq(Seq._default.IsSuffix$T)))
       ==> Seq.__default.IsSuffix(Seq._default.IsSuffix$T, a#0, b#0)
         == (Seq#Length(a#0) <= Seq#Length(b#0)
           && Seq#Equal(a#0, Seq#Drop(b#0, Seq#Length(b#0) - Seq#Length(a#0)))));

// definition axiom for Seq.__default.IsSuffix for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box :: 
    {:weight 3} { Seq.__default.IsSuffix(Seq._default.IsSuffix$T, Lit(a#0), Lit(b#0)) } 
    Seq.__default.IsSuffix#canCall(Seq._default.IsSuffix$T, Lit(a#0), Lit(b#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.IsSuffix$T))
           && $Is(b#0, TSeq(Seq._default.IsSuffix$T)))
       ==> Seq.__default.IsSuffix(Seq._default.IsSuffix$T, Lit(a#0), Lit(b#0))
         == (Seq#Length(Lit(a#0)) <= Seq#Length(Lit(b#0))
           && Seq#Equal(a#0, Seq#Drop(Lit(b#0), Seq#Length(Lit(b#0)) - Seq#Length(Lit(a#0))))));

procedure {:verboseName "Seq.IsSuffix (well-formedness)"} CheckWellformed$$Seq.__default.IsSuffix(Seq._default.IsSuffix$T: Ty, 
    a#0: Seq Box where $Is(a#0, TSeq(Seq._default.IsSuffix$T)), 
    b#0: Seq Box where $Is(b#0, TSeq(Seq._default.IsSuffix$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.IsSuffix (well-formedness)"} CheckWellformed$$Seq.__default.IsSuffix(Seq._default.IsSuffix$T: Ty, a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;


    // AddWellformednessCheck for function IsSuffix
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(a#0) <= Seq#Length(b#0))
        {
            assert 0 <= Seq#Length(b#0) - Seq#Length(a#0)
               && Seq#Length(b#0) - Seq#Length(a#0) <= Seq#Length(b#0);
        }

        assume Seq.__default.IsSuffix(Seq._default.IsSuffix$T, a#0, b#0)
           == (Seq#Length(a#0) <= Seq#Length(b#0)
             && Seq#Equal(a#0, Seq#Drop(b#0, Seq#Length(b#0) - Seq#Length(a#0))));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.IsSuffix(Seq._default.IsSuffix$T, a#0, b#0), TBool);
    }
}



procedure {:verboseName "Seq.LemmaSplitAt (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaSplitAt(Seq._default.LemmaSplitAt$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSplitAt$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSplitAt$T), $Heap), 
    pos#0: int where LitInt(0) <= pos#0);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaSplitAt (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaSplitAt(Seq._default.LemmaSplitAt$T: Ty, s#0: Seq Box, pos#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaSplitAt, CheckWellFormed$$Seq.__default.LemmaSplitAt
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    assume pos#0 < Seq#Length(s#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    assert 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
    assert 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
    assume Seq#Equal(Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0)), s#0);
}



procedure {:verboseName "Seq.LemmaSplitAt (call)"} Call$$Seq.__default.LemmaSplitAt(Seq._default.LemmaSplitAt$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSplitAt$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSplitAt$T), $Heap), 
    pos#0: int where LitInt(0) <= pos#0);
  // user-defined preconditions
  requires pos#0 < Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0)), s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaSplitAt (correctness)"} Impl$$Seq.__default.LemmaSplitAt(Seq._default.LemmaSplitAt$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSplitAt$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSplitAt$T), $Heap), 
    pos#0: int where LitInt(0) <= pos#0)
   returns ($_reverifyPost: bool);
  free requires 0 == $FunctionContextHeight;
  // user-defined preconditions
  requires pos#0 < Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0)), s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaSplitAt (correctness)"} Impl$$Seq.__default.LemmaSplitAt(Seq._default.LemmaSplitAt$T: Ty, s#0: Seq Box, pos#0: int)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaSplitAt, Impl$$Seq.__default.LemmaSplitAt
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
}



procedure {:verboseName "Seq.LemmaElementFromSlice (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaElementFromSlice(Seq._default.LemmaElementFromSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    s'#0: Seq Box
       where $Is(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    a#0: int, 
    b#0: int, 
    pos#0: int where LitInt(0) <= pos#0);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaElementFromSlice (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaElementFromSlice(Seq._default.LemmaElementFromSlice$T: Ty, 
    s#0: Seq Box, 
    s'#0: Seq Box, 
    a#0: int, 
    b#0: int, 
    pos#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaElementFromSlice, CheckWellFormed$$Seq.__default.LemmaElementFromSlice
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    if (LitInt(0) <= a#0)
    {
    }

    if (LitInt(0) <= a#0 && a#0 <= b#0)
    {
    }

    assume LitInt(0) <= a#0 && a#0 <= b#0 && b#0 <= Seq#Length(s#0);
    assert 0 <= a#0 && a#0 <= Seq#Length(s#0);
    assert a#0 <= b#0 && b#0 <= Seq#Length(s#0);
    assume Seq#Equal(s'#0, Seq#Drop(Seq#Take(s#0, b#0), a#0));
    if (a#0 <= pos#0)
    {
    }

    assume a#0 <= pos#0 && pos#0 < b#0;
    havoc $Heap;
    assume old($Heap) == $Heap;
    assume pos#0 - a#0 < Seq#Length(s'#0);
    assert 0 <= pos#0 - a#0 && pos#0 - a#0 < Seq#Length(s'#0);
    assert 0 <= pos#0 && pos#0 < Seq#Length(s#0);
    assume Seq#Index(s'#0, pos#0 - a#0) == Seq#Index(s#0, pos#0);
}



procedure {:verboseName "Seq.LemmaElementFromSlice (call)"} Call$$Seq.__default.LemmaElementFromSlice(Seq._default.LemmaElementFromSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    s'#0: Seq Box
       where $Is(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    a#0: int, 
    b#0: int, 
    pos#0: int where LitInt(0) <= pos#0);
  // user-defined preconditions
  requires LitInt(0) <= a#0;
  requires a#0 <= b#0;
  requires b#0 <= Seq#Length(s#0);
  requires Seq#Equal(s'#0, Seq#Drop(Seq#Take(s#0, b#0), a#0));
  requires a#0 <= pos#0;
  requires pos#0 < b#0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures pos#0 - a#0 < Seq#Length(s'#0);
  free ensures true;
  ensures Seq#Index(s'#0, pos#0 - a#0) == Seq#Index(s#0, pos#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaElementFromSlice (correctness)"} Impl$$Seq.__default.LemmaElementFromSlice(Seq._default.LemmaElementFromSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    s'#0: Seq Box
       where $Is(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T))
         && $IsAlloc(s'#0, TSeq(Seq._default.LemmaElementFromSlice$T), $Heap), 
    a#0: int, 
    b#0: int, 
    pos#0: int where LitInt(0) <= pos#0)
   returns ($_reverifyPost: bool);
  free requires 0 == $FunctionContextHeight;
  // user-defined preconditions
  requires LitInt(0) <= a#0;
  requires a#0 <= b#0;
  requires b#0 <= Seq#Length(s#0);
  requires Seq#Equal(s'#0, Seq#Drop(Seq#Take(s#0, b#0), a#0));
  requires a#0 <= pos#0;
  requires pos#0 < b#0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures pos#0 - a#0 < Seq#Length(s'#0);
  free ensures true;
  ensures Seq#Index(s'#0, pos#0 - a#0) == Seq#Index(s#0, pos#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaElementFromSlice (correctness)"} Impl$$Seq.__default.LemmaElementFromSlice(Seq._default.LemmaElementFromSlice$T: Ty, 
    s#0: Seq Box, 
    s'#0: Seq Box, 
    a#0: int, 
    b#0: int, 
    pos#0: int)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaElementFromSlice, Impl$$Seq.__default.LemmaElementFromSlice
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
}



procedure {:verboseName "Seq.LemmaSliceOfSlice (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaSliceOfSlice(Seq._default.LemmaSliceOfSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap), 
    s1#0: int, 
    e1#0: int, 
    s2#0: int, 
    e2#0: int);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaSliceOfSlice (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaSliceOfSlice(Seq._default.LemmaSliceOfSlice$T: Ty, 
    s#0: Seq Box, 
    s1#0: int, 
    e1#0: int, 
    s2#0: int, 
    e2#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;

    // AddMethodImpl: LemmaSliceOfSlice, CheckWellFormed$$Seq.__default.LemmaSliceOfSlice
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    if (LitInt(0) <= s1#0)
    {
    }

    if (LitInt(0) <= s1#0 && s1#0 <= e1#0)
    {
    }

    assume LitInt(0) <= s1#0 && s1#0 <= e1#0 && e1#0 <= Seq#Length(s#0);
    if (LitInt(0) <= s2#0)
    {
    }

    if (LitInt(0) <= s2#0 && s2#0 <= e2#0)
    {
    }

    assume LitInt(0) <= s2#0 && s2#0 <= e2#0 && e2#0 <= e1#0 - s1#0;
    havoc $Heap;
    assume old($Heap) == $Heap;
    assert 0 <= s1#0 && s1#0 <= Seq#Length(s#0);
    assert s1#0 <= e1#0 && e1#0 <= Seq#Length(s#0);
    assert 0 <= s2#0 && s2#0 <= Seq#Length(Seq#Drop(Seq#Take(s#0, e1#0), s1#0));
    assert s2#0 <= e2#0 && e2#0 <= Seq#Length(Seq#Drop(Seq#Take(s#0, e1#0), s1#0));
    assert 0 <= s1#0 + s2#0 && s1#0 + s2#0 <= Seq#Length(s#0);
    assert s1#0 + s2#0 <= s1#0 + e2#0 && s1#0 + e2#0 <= Seq#Length(s#0);
    assume Seq#Equal(Seq#Drop(Seq#Take(Seq#Drop(Seq#Take(s#0, e1#0), s1#0), e2#0), s2#0), 
      Seq#Drop(Seq#Take(s#0, s1#0 + e2#0), s1#0 + s2#0));
}



procedure {:verboseName "Seq.LemmaSliceOfSlice (call)"} Call$$Seq.__default.LemmaSliceOfSlice(Seq._default.LemmaSliceOfSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap), 
    s1#0: int, 
    e1#0: int, 
    s2#0: int, 
    e2#0: int);
  // user-defined preconditions
  requires LitInt(0) <= s1#0;
  requires s1#0 <= e1#0;
  requires e1#0 <= Seq#Length(s#0);
  requires LitInt(0) <= s2#0;
  requires s2#0 <= e2#0;
  requires e2#0 <= e1#0 - s1#0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Drop(Seq#Take(Seq#Drop(Seq#Take(s#0, e1#0), s1#0), e2#0), s2#0), 
    Seq#Drop(Seq#Take(s#0, s1#0 + e2#0), s1#0 + s2#0));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaSliceOfSlice (correctness)"} Impl$$Seq.__default.LemmaSliceOfSlice(Seq._default.LemmaSliceOfSlice$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap), 
    s1#0: int, 
    e1#0: int, 
    s2#0: int, 
    e2#0: int)
   returns ($_reverifyPost: bool);
  free requires 0 == $FunctionContextHeight;
  // user-defined preconditions
  requires LitInt(0) <= s1#0;
  requires s1#0 <= e1#0;
  requires e1#0 <= Seq#Length(s#0);
  requires LitInt(0) <= s2#0;
  requires s2#0 <= e2#0;
  requires e2#0 <= e1#0 - s1#0;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures Seq#Equal(Seq#Drop(Seq#Take(Seq#Drop(Seq#Take(s#0, e1#0), s1#0), e2#0), s2#0), 
    Seq#Drop(Seq#Take(s#0, s1#0 + e2#0), s1#0 + s2#0));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaSliceOfSlice (correctness)"} Impl$$Seq.__default.LemmaSliceOfSlice(Seq._default.LemmaSliceOfSlice$T: Ty, 
    s#0: Seq Box, 
    s1#0: int, 
    e1#0: int, 
    s2#0: int, 
    e2#0: int)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var r1#0: Seq Box
     where $Is(r1#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
       && $IsAlloc(r1#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap);
  var r2#0: Seq Box
     where $Is(r2#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
       && $IsAlloc(r2#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap);
  var r3#0: Seq Box
     where $Is(r3#0, TSeq(Seq._default.LemmaSliceOfSlice$T))
       && $IsAlloc(r3#0, TSeq(Seq._default.LemmaSliceOfSlice$T), $Heap);
  var i#0_0: int;

    // AddMethodImpl: LemmaSliceOfSlice, Impl$$Seq.__default.LemmaSliceOfSlice
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(118,12)
    assume true;
    assert 0 <= s1#0 && s1#0 <= Seq#Length(s#0);
    assert s1#0 <= e1#0 && e1#0 <= Seq#Length(s#0);
    assume true;
    r1#0 := Seq#Drop(Seq#Take(s#0, e1#0), s1#0);
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(119,12)
    assume true;
    assert 0 <= s2#0 && s2#0 <= Seq#Length(r1#0);
    assert s2#0 <= e2#0 && e2#0 <= Seq#Length(r1#0);
    assume true;
    r2#0 := Seq#Drop(Seq#Take(r1#0, e2#0), s2#0);
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(120,12)
    assume true;
    assert 0 <= s1#0 + s2#0 && s1#0 + s2#0 <= Seq#Length(s#0);
    assert s1#0 + s2#0 <= s1#0 + e2#0 && s1#0 + e2#0 <= Seq#Length(s#0);
    assume true;
    r3#0 := Seq#Drop(Seq#Take(s#0, s1#0 + e2#0), s1#0 + s2#0);
    // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(121,5)
    assume true;
    assert Seq#Length(r2#0) == Seq#Length(r3#0);
    // ----- forall statement (proof) ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(122,5)
    if (*)
    {
        // Assume Fuel Constant
        havoc i#0_0;
        assume true;
        if (LitInt(0) <= i#0_0)
        {
        }

        assume true;
        assume LitInt(0) <= i#0_0 && i#0_0 < Seq#Length(r2#0);
        if (*)
        {
            assert {:subsumption 0} 0 <= i#0_0 && i#0_0 < Seq#Length(r2#0);
            assert {:subsumption 0} 0 <= i#0_0 && i#0_0 < Seq#Length(r3#0);
            assume true;
            assume Seq#Index(r2#0, i#0_0) == Seq#Index(r3#0, i#0_0);
            assume false;
        }

        assert Seq#Index(r2#0, i#0_0) == Seq#Index(r3#0, i#0_0);
        assume false;
    }
    else
    {
        assume (forall i#0_1: int :: 
          { Seq#Index(r2#0, i#0_1), Seq#Index(r3#0, i#0_1) } 
          LitInt(0) <= i#0_1 && i#0_1 < Seq#Length(r2#0)
             ==> Seq#Index(r2#0, i#0_1) == Seq#Index(r3#0, i#0_1));
    }
}



procedure {:verboseName "Seq.ToArray (well-formedness)"} CheckWellFormed$$Seq.__default.ToArray(Seq._default.ToArray$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.ToArray$T))
         && $IsAlloc(s#0, TSeq(Seq._default.ToArray$T), $Heap))
   returns (a#0: ref
       where $Is(a#0, Tclass._System.array(Seq._default.ToArray$T))
         && $IsAlloc(a#0, Tclass._System.array(Seq._default.ToArray$T), $Heap));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.ToArray (well-formedness)"} CheckWellFormed$$Seq.__default.ToArray(Seq._default.ToArray$T: Ty, s#0: Seq Box) returns (a#0: ref)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#0: int;

    // AddMethodImpl: ToArray, CheckWellFormed$$Seq.__default.ToArray
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    havoc $Heap;
    assume (forall $o: ref :: 
      { $Heap[$o] } 
      $o != null && read(old($Heap), $o, alloc) ==> $Heap[$o] == old($Heap)[$o]);
    assume $HeapSucc(old($Heap), $Heap);
    havoc a#0;
    assume a#0 != null && !read(old($Heap), a#0, alloc);
    assert a#0 != null;
    assume _System.array.Length(a#0) == Seq#Length(s#0);
    havoc i#0;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#0)
        {
        }

        assume LitInt(0) <= i#0 && i#0 < Seq#Length(s#0);
        assert a#0 != null;
        assert 0 <= i#0 && i#0 < _System.array.Length(a#0);
        assert 0 <= i#0 && i#0 < Seq#Length(s#0);
        assume read($Heap, a#0, IndexField(i#0)) == Seq#Index(s#0, i#0);
    }
    else
    {
        assume LitInt(0) <= i#0 && i#0 < Seq#Length(s#0)
           ==> read($Heap, a#0, IndexField(i#0)) == Seq#Index(s#0, i#0);
    }

    assume (forall i#1: int :: 
      { Seq#Index(s#0, i#1) } { read($Heap, a#0, IndexField(i#1)) } 
      true
         ==> 
        LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
         ==> read($Heap, a#0, IndexField(i#1)) == Seq#Index(s#0, i#1));
}



procedure {:verboseName "Seq.ToArray (call)"} Call$$Seq.__default.ToArray(Seq._default.ToArray$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.ToArray$T))
         && $IsAlloc(s#0, TSeq(Seq._default.ToArray$T), $Heap))
   returns (a#0: ref
       where $Is(a#0, Tclass._System.array(Seq._default.ToArray$T))
         && $IsAlloc(a#0, Tclass._System.array(Seq._default.ToArray$T), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures a#0 != null && !read(old($Heap), a#0, alloc);
  free ensures true;
  ensures _System.array.Length(a#0) == Seq#Length(s#0);
  free ensures true;
  ensures (forall i#1: int :: 
    { Seq#Index(s#0, i#1) } { read($Heap, a#0, IndexField(i#1)) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> read($Heap, a#0, IndexField(i#1)) == Seq#Index(s#0, i#1));
  // frame condition: object granularity
  free ensures (forall $o: ref :: 
    { $Heap[$o] } 
    $o != null && read(old($Heap), $o, alloc) ==> $Heap[$o] == old($Heap)[$o]);
  // boilerplate
  free ensures $HeapSucc(old($Heap), $Heap);



procedure {:verboseName "Seq.ToArray (correctness)"} Impl$$Seq.__default.ToArray(Seq._default.ToArray$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.ToArray$T))
         && $IsAlloc(s#0, TSeq(Seq._default.ToArray$T), $Heap))
   returns (a#0: ref
       where $Is(a#0, Tclass._System.array(Seq._default.ToArray$T))
         && $IsAlloc(a#0, Tclass._System.array(Seq._default.ToArray$T), $Heap), 
    $_reverifyPost: bool);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures a#0 != null && !read(old($Heap), a#0, alloc);
  free ensures true;
  ensures _System.array.Length(a#0) == Seq#Length(s#0);
  free ensures true;
  ensures (forall i#1: int :: 
    { Seq#Index(s#0, i#1) } { read($Heap, a#0, IndexField(i#1)) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> read($Heap, a#0, IndexField(i#1)) == Seq#Index(s#0, i#1));
  // frame condition: object granularity
  free ensures (forall $o: ref :: 
    { $Heap[$o] } 
    $o != null && read(old($Heap), $o, alloc) ==> $Heap[$o] == old($Heap)[$o]);
  // boilerplate
  free ensures $HeapSucc(old($Heap), $Heap);



implementation {:verboseName "Seq.ToArray (correctness)"} Impl$$Seq.__default.ToArray(Seq._default.ToArray$T: Ty, s#0: Seq Box)
   returns (a#0: ref, $_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $lambdaHeap#0: Heap;
  var i#2: int;
  var $_Frame#l0: <beta>[ref,Field beta]bool;
  var lambdaResult#0: Box;
  var $nw: ref;

    // AddMethodImpl: ToArray, Impl$$Seq.__default.ToArray
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(133,7)
    assume true;
    assert 0 <= Seq#Length(s#0);
    // Begin Comprehension WF check
    if (*)
    {
        havoc $lambdaHeap#0;
        assume $IsGoodHeap($lambdaHeap#0);
        assume $Heap == $lambdaHeap#0 || $HeapSucc($Heap, $lambdaHeap#0);
        havoc i#2;
        if (true)
        {
            $_Frame#l0 := (lambda<alpha> $o: ref, $f: Field alpha :: 
              $o != null && read($lambdaHeap#0, $o, alloc) ==> false);
            if (LitInt(0) <= i#2)
            {
            }

            if (LitInt(0) <= i#2 && i#2 < Seq#Length(s#0))
            {
                assert 0 <= i#2 && i#2 < Seq#Length(s#0);
                assume lambdaResult#0 == Seq#Index(s#0, i#2);
                assume true;
                // CheckWellformedWithResult: any expression
                assume $IsBox(lambdaResult#0, Seq._default.ToArray$T);
            }
        }

        assume false;
    }

    // End Comprehension WF check
    havoc $nw;
    assume $nw != null && dtype($nw) == Tclass._System.array?(Seq._default.ToArray$T);
    assume !read($Heap, $nw, alloc);
    assume _System.array.Length($nw) == Seq#Length(s#0);
    assert {:subsumption 0} (forall arrayinit#0#i0#0: int :: 
      0 <= arrayinit#0#i0#0 && arrayinit#0#i0#0 < Seq#Length(s#0)
         ==> Requires1(TInt, 
          Seq._default.ToArray$T, 
          $Heap, 
          Lit(AtLayer((lambda $l#0#ly#0: LayerType :: 
                Handle1((lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                    Seq#Index(s#0, $Unbox($l#0#i#0): int)), 
                  (lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                    $IsBox($l#0#i#0, TInt)
                       && 
                      LitInt(0) <= $Unbox($l#0#i#0): int
                       && $Unbox($l#0#i#0): int < Seq#Length(s#0)), 
                  (lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                    SetRef_to_SetBox((lambda $l#0#o#0: ref :: false))))), 
              $LS($LZ))), 
          $Box(arrayinit#0#i0#0)));
    assume (forall arrayinit#0#i0#0: int :: 
      { read($Heap, $nw, IndexField(arrayinit#0#i0#0)) } 
      0 <= arrayinit#0#i0#0 && arrayinit#0#i0#0 < Seq#Length(s#0)
         ==> read($Heap, $nw, IndexField(arrayinit#0#i0#0))
           == Apply1(TInt, 
            Seq._default.ToArray$T, 
            $Heap, 
            Lit(AtLayer((lambda $l#0#ly#0: LayerType :: 
                  Handle1((lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                      Seq#Index(s#0, $Unbox($l#0#i#0): int)), 
                    (lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                      $IsBox($l#0#i#0, TInt)
                         && 
                        LitInt(0) <= $Unbox($l#0#i#0): int
                         && $Unbox($l#0#i#0): int < Seq#Length(s#0)), 
                    (lambda $l#0#heap#0: Heap, $l#0#i#0: Box :: 
                      SetRef_to_SetBox((lambda $l#0#o#0: ref :: false))))), 
                $LS($LZ))), 
            $Box(arrayinit#0#i0#0)));
    $Heap := update($Heap, $nw, alloc, true);
    assume $IsGoodHeap($Heap);
    assume $IsHeapAnchor($Heap);
    a#0 := $nw;
}



// function declaration for Seq._default.ToSet
function Seq.__default.ToSet(Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box) : Set Box;

function Seq.__default.ToSet#canCall(Seq._default.ToSet$T: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), s#0) } 
  Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), s#0)
     == Seq.__default.ToSet(Seq._default.ToSet$T, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.ToSet(Seq._default.ToSet$T, AsFuelBottom($ly), s#0) } 
  Seq.__default.ToSet(Seq._default.ToSet$T, $ly, s#0)
     == Seq.__default.ToSet(Seq._default.ToSet$T, $LZ, s#0));

// consequence axiom for Seq.__default.ToSet
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.ToSet(Seq._default.ToSet$T, $ly, s#0) } 
    Seq.__default.ToSet#canCall(Seq._default.ToSet$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.ToSet$T)))
       ==> $Is(Seq.__default.ToSet(Seq._default.ToSet$T, $ly, s#0), TSet(Seq._default.ToSet$T)));

function Seq.__default.ToSet#requires(Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.ToSet
axiom (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.ToSet#requires(Seq._default.ToSet$T, $ly, s#0) } 
  $Is(s#0, TSeq(Seq._default.ToSet$T))
     ==> Seq.__default.ToSet#requires(Seq._default.ToSet$T, $ly, s#0) == true);

// definition axiom for Seq.__default.ToSet (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), s#0) } 
    Seq.__default.ToSet#canCall(Seq._default.ToSet$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.ToSet$T)))
       ==> Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), s#0)
         == (lambda $y#0: Box :: 
          $IsBox($y#0, Seq._default.ToSet$T) && Seq#Contains(s#0, $y#0)));

// definition axiom for Seq.__default.ToSet for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.ToSet$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), Lit(s#0)) } 
    Seq.__default.ToSet#canCall(Seq._default.ToSet$T, Lit(s#0))
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.ToSet$T)))
       ==> Seq.__default.ToSet(Seq._default.ToSet$T, $LS($ly), Lit(s#0))
         == (lambda $y#1: Box :: 
          $IsBox($y#1, Seq._default.ToSet$T) && Seq#Contains(s#0, $y#1)));

procedure {:verboseName "Seq.ToSet (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.ToSet(Seq._default.ToSet$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.ToSet$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaCardinalityOfSet (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaCardinalityOfSet (call)"} Call$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, StartFuelAssert_Seq._default.ToSet, s#0))
     <= Seq#Length(s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaCardinalityOfSet (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, StartFuelAssert_Seq._default.ToSet, s#0))
     <= Seq#Length(s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaCardinalityOfSet (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaCardinalityOfSet$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#1_0: Seq Box;
  var ##s#1_1: Seq Box;
  var ##s#1_2: Seq Box;
  var ##s#1_3: Seq Box;
  var s##1_0: Seq Box;
  var ##s#1_4: Seq Box;

    // AddMethodImpl: LemmaCardinalityOfSet, Impl$$Seq.__default.LemmaCardinalityOfSet
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(147,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(147,17)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__ToSet();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(148,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(150,7)
        ##s#1_0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_0, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        ##s#1_1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_1, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_1) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        ##s#1_2 := Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_2, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, 
          Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0));
        ##s#1_3 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_3, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_3) > 0;
        assume Seq.__default.Last#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0)
           && 
          Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0)
           && Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSet$T, 
            Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0))
           && Seq.__default.Last#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        assert {:subsumption 0} Set#Equal(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, StartFuelAssert_Seq._default.ToSet, s#0), 
          Set#Union(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, 
              StartFuelAssert_Seq._default.ToSet, 
              Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0)), 
            Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.Last(Seq._default.LemmaCardinalityOfSet$T, s#0))));
        assume Set#Equal(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, StartFuel_Seq._default.ToSet, s#0), 
          Set#Union(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSet$T, 
              StartFuel_Seq._default.ToSet, 
              Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0)), 
            Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.Last(Seq._default.LemmaCardinalityOfSet$T, s#0))));
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(151,28)
        // TrCallStmt: Before ProcessCallStmt
        ##s#1_4 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_4, TSeq(Seq._default.LemmaCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_4) > 0;
        assume Seq#Length(##s#1_4) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSet$T, s#0);
        // ProcessCallStmt: CheckSubrange
        s##1_0 := Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSet$T, s#0);
        assert Seq#Rank(s##1_0) < Seq#Rank(s#0);
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaCardinalityOfSet$T, s##1_0);
        // TrCallStmt: After ProcessCallStmt
    }
}



procedure {:verboseName "Seq.LemmaCardinalityOfEmptySetIs0 (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaCardinalityOfEmptySetIs0(Seq._default.LemmaCardinalityOfEmptySetIs0$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaCardinalityOfEmptySetIs0 (call)"} Call$$Seq.__default.LemmaCardinalityOfEmptySetIs0(Seq._default.LemmaCardinalityOfEmptySetIs0$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfEmptySetIs0$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfEmptySetIs0$T, 
          StartFuelAssert_Seq._default.ToSet, 
          s#0))
       == LitInt(0)
     <==> Seq#Length(s#0) == LitInt(0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaCardinalityOfEmptySetIs0 (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfEmptySetIs0(Seq._default.LemmaCardinalityOfEmptySetIs0$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfEmptySetIs0$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfEmptySetIs0$T, 
          StartFuelAssert_Seq._default.ToSet, 
          s#0))
       == LitInt(0)
     <==> Seq#Length(s#0) == LitInt(0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaCardinalityOfEmptySetIs0 (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfEmptySetIs0(Seq._default.LemmaCardinalityOfEmptySetIs0$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0_0: Seq Box;

    // AddMethodImpl: LemmaCardinalityOfEmptySetIs0, Impl$$Seq.__default.LemmaCardinalityOfEmptySetIs0
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(159,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(159,17)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__ToSet();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(160,5)
    assume true;
    if (Seq#Length(s#0) != 0)
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(161,7)
        assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
        ##s#0_0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#0_0, TSeq(Seq._default.LemmaCardinalityOfEmptySetIs0$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfEmptySetIs0$T, s#0);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfEmptySetIs0$T, s#0);
        assert {:subsumption 0} Seq.__default.ToSet(Seq._default.LemmaCardinalityOfEmptySetIs0$T, 
          StartFuelAssert_Seq._default.ToSet, 
          s#0)[Seq#Index(s#0, LitInt(0))];
        assume Seq.__default.ToSet(Seq._default.LemmaCardinalityOfEmptySetIs0$T, StartFuel_Seq._default.ToSet, s#0)[Seq#Index(s#0, LitInt(0))];
    }
    else
    {
    }
}



// function declaration for Seq._default.HasNoDuplicates
function Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box) : bool;

function Seq.__default.HasNoDuplicates#canCall(Seq._default.HasNoDuplicates$T: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), s#0) } 
  Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), s#0)
     == Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, AsFuelBottom($ly), s#0) } 
  Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $ly, s#0)
     == Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LZ, s#0));

// consequence axiom for Seq.__default.HasNoDuplicates
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $ly, s#0) } 
    Seq.__default.HasNoDuplicates#canCall(Seq._default.HasNoDuplicates$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.HasNoDuplicates$T)))
       ==> true);

function Seq.__default.HasNoDuplicates#requires(Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.HasNoDuplicates
axiom (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.HasNoDuplicates#requires(Seq._default.HasNoDuplicates$T, $ly, s#0) } 
  $Is(s#0, TSeq(Seq._default.HasNoDuplicates$T))
     ==> Seq.__default.HasNoDuplicates#requires(Seq._default.HasNoDuplicates$T, $ly, s#0)
       == true);

// definition axiom for Seq.__default.HasNoDuplicates (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), s#0) } 
    Seq.__default.HasNoDuplicates#canCall(Seq._default.HasNoDuplicates$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.HasNoDuplicates$T)))
       ==> Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), s#0)
         == (forall i#0: int, j#0: int :: 
          { Seq#Index(s#0, i#0), Seq#Index(s#0, j#0) } 
          true
             ==> 
            LitInt(0) <= i#0
               && i#0 < Seq#Length(s#0)
               && 
              LitInt(0) <= j#0
               && j#0 < Seq#Length(s#0)
               && i#0 != j#0
             ==> Seq#Index(s#0, i#0) != Seq#Index(s#0, j#0)));

// definition axiom for Seq.__default.HasNoDuplicates for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.HasNoDuplicates$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), Lit(s#0)) } 
    Seq.__default.HasNoDuplicates#canCall(Seq._default.HasNoDuplicates$T, Lit(s#0))
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.HasNoDuplicates$T)))
       ==> Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, $LS($ly), Lit(s#0))
         == (forall i#1: int, j#1: int :: 
          { Seq#Index(s#0, i#1), Seq#Index(s#0, j#1) } 
          true
             ==> 
            LitInt(0) <= i#1
               && i#1 < Seq#Length(Lit(s#0))
               && 
              LitInt(0) <= j#1
               && j#1 < Seq#Length(Lit(s#0))
               && i#1 != j#1
             ==> Seq#Index(Lit(s#0), i#1) != Seq#Index(Lit(s#0), j#1)));

procedure {:verboseName "Seq.HasNoDuplicates (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.HasNoDuplicates$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.HasNoDuplicates (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#2: int;
  var j#2: int;


    // AddWellformednessCheck for function HasNoDuplicates
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        // Begin Comprehension WF check
        havoc i#2;
        havoc j#2;
        if (true)
        {
            if (LitInt(0) <= i#2)
            {
            }

            if (LitInt(0) <= i#2 && i#2 < Seq#Length(s#0))
            {
                if (LitInt(0) <= j#2)
                {
                }
            }

            if (LitInt(0) <= i#2
               && i#2 < Seq#Length(s#0)
               && 
              LitInt(0) <= j#2
               && j#2 < Seq#Length(s#0))
            {
            }

            if (LitInt(0) <= i#2
               && i#2 < Seq#Length(s#0)
               && 
              LitInt(0) <= j#2
               && j#2 < Seq#Length(s#0)
               && i#2 != j#2)
            {
                assert 0 <= i#2 && i#2 < Seq#Length(s#0);
                assert 0 <= j#2 && j#2 < Seq#Length(s#0);
            }
        }

        // End Comprehension WF check
        assume Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, StartFuel_Seq._default.HasNoDuplicates, s#0)
           == (forall i#3: int, j#3: int :: 
            { Seq#Index(s#0, i#3), Seq#Index(s#0, j#3) } 
            true
               ==> 
              LitInt(0) <= i#3
                 && i#3 < Seq#Length(s#0)
                 && 
                LitInt(0) <= j#3
                 && j#3 < Seq#Length(s#0)
                 && i#3 != j#3
               ==> Seq#Index(s#0, i#3) != Seq#Index(s#0, j#3));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.HasNoDuplicates(Seq._default.HasNoDuplicates$T, StartFuel_Seq._default.HasNoDuplicates, s#0), 
          TBool);
    }
}



procedure {:verboseName "Seq.LemmaNoDuplicatesInConcat (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaNoDuplicatesInConcat(Seq._default.LemmaNoDuplicatesInConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaNoDuplicatesInConcat (call)"} Call$$Seq.__default.LemmaNoDuplicatesInConcat(Seq._default.LemmaNoDuplicatesInConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap));
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    a#0);
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    b#0);
  requires MultiSet#Disjoint(MultiSet#FromSeq(a#0), MultiSet#FromSeq(b#0));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaNoDuplicatesInConcat$T, Seq#Append(a#0, b#0));
  ensures Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    Seq#Append(a#0, b#0));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaNoDuplicatesInConcat (correctness)"} Impl$$Seq.__default.LemmaNoDuplicatesInConcat(Seq._default.LemmaNoDuplicatesInConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    a#0);
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    b#0);
  requires MultiSet#Disjoint(MultiSet#FromSeq(a#0), MultiSet#FromSeq(b#0));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaNoDuplicatesInConcat$T, Seq#Append(a#0, b#0));
  ensures Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesInConcat$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    Seq#Append(a#0, b#0));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaNoDuplicatesInConcat (correctness)"} Impl$$Seq.__default.LemmaNoDuplicatesInConcat(Seq._default.LemmaNoDuplicatesInConcat$T: Ty, a#0: Seq Box, b#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var c#0: Seq Box
     where $Is(c#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T))
       && $IsAlloc(c#0, TSeq(Seq._default.LemmaNoDuplicatesInConcat$T), $Heap);
  var i#0_0: int;
  var j#0_0: int;
  var i#0_2: int;
  var j#0_2: int;

    // AddMethodImpl: LemmaNoDuplicatesInConcat, Impl$$Seq.__default.LemmaNoDuplicatesInConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(180,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(180,27)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__HasNoDuplicates();
    // TrCallStmt: After ProcessCallStmt
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(181,11)
    assume true;
    assume true;
    c#0 := Seq#Append(a#0, b#0);
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(182,5)
    assume true;
    if (Seq#Length(c#0) > 1)
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(183,7)
        // Begin Comprehension WF check
        havoc i#0_0;
        if (true)
        {
            if (LitInt(0) <= i#0_0)
            {
            }

            if (LitInt(0) <= i#0_0 && i#0_0 < Seq#Length(a#0))
            {
                assert {:subsumption 0} 0 <= i#0_0 && i#0_0 < Seq#Length(c#0);
            }
        }

        // End Comprehension WF check
        assume true;
        assert (forall i#0_1: int :: 
          { Seq#Index(c#0, i#0_1) } 
          true
             ==> 
            LitInt(0) <= i#0_1 && i#0_1 < Seq#Length(a#0)
             ==> MultiSet#FromSeq(a#0)[Seq#Index(c#0, i#0_1)] > 0);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(185,7)
        // Begin Comprehension WF check
        havoc j#0_0;
        if (true)
        {
            if (Seq#Length(a#0) <= j#0_0)
            {
            }

            if (Seq#Length(a#0) <= j#0_0 && j#0_0 < Seq#Length(c#0))
            {
                assert {:subsumption 0} 0 <= j#0_0 && j#0_0 < Seq#Length(c#0);
            }
        }

        // End Comprehension WF check
        assume true;
        assert (forall j#0_1: int :: 
          { Seq#Index(c#0, j#0_1) } 
          true
             ==> 
            Seq#Length(a#0) <= j#0_1 && j#0_1 < Seq#Length(c#0)
             ==> MultiSet#FromSeq(b#0)[Seq#Index(c#0, j#0_1)] > 0);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(187,7)
        // Begin Comprehension WF check
        havoc i#0_2;
        havoc j#0_2;
        if (true)
        {
            if (i#0_2 != j#0_2)
            {
                if (LitInt(0) <= i#0_2)
                {
                }
            }

            if (i#0_2 != j#0_2 && LitInt(0) <= i#0_2 && i#0_2 < Seq#Length(a#0))
            {
                if (Seq#Length(a#0) <= j#0_2)
                {
                }
            }

            if (i#0_2 != j#0_2
               && 
              LitInt(0) <= i#0_2
               && i#0_2 < Seq#Length(a#0)
               && 
              Seq#Length(a#0) <= j#0_2
               && j#0_2 < Seq#Length(c#0))
            {
                assert {:subsumption 0} 0 <= i#0_2 && i#0_2 < Seq#Length(c#0);
                assert {:subsumption 0} 0 <= j#0_2 && j#0_2 < Seq#Length(c#0);
            }
        }

        // End Comprehension WF check
        assume true;
        assert (forall i#0_3: int, j#0_3: int :: 
          { Seq#Index(c#0, i#0_3), Seq#Index(c#0, j#0_3) } 
          true
             ==> 
            i#0_3 != j#0_3
               && 
              LitInt(0) <= i#0_3
               && i#0_3 < Seq#Length(a#0)
               && 
              Seq#Length(a#0) <= j#0_3
               && j#0_3 < Seq#Length(c#0)
             ==> Seq#Index(c#0, i#0_3) != Seq#Index(c#0, j#0_3));
    }
    else
    {
    }
}



procedure {:verboseName "Seq.LemmaCardinalityOfSetNoDuplicates (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaCardinalityOfSetNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaCardinalityOfSetNoDuplicates (call)"} Call$$Seq.__default.LemmaCardinalityOfSetNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap));
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
        StartFuelAssert_Seq._default.ToSet, 
        s#0))
     == Seq#Length(s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaCardinalityOfSetNoDuplicates (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfSetNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
  ensures Set#Card(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
        StartFuelAssert_Seq._default.ToSet, 
        s#0))
     == Seq#Length(s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaCardinalityOfSetNoDuplicates (correctness)"} Impl$$Seq.__default.LemmaCardinalityOfSetNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var s##1_0: Seq Box;
  var ##s#1_0: Seq Box;
  var ##s#1_1: Seq Box;
  var ##s#1_2: Seq Box;
  var ##s#1_3: Seq Box;
  var ##s#1_4: Seq Box;

    // AddMethodImpl: LemmaCardinalityOfSetNoDuplicates, Impl$$Seq.__default.LemmaCardinalityOfSetNoDuplicates
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(197,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(197,27)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__HasNoDuplicates();
    // TrCallStmt: After ProcessCallStmt
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(198,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(198,17)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__ToSet();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(199,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(201,40)
        // TrCallStmt: Before ProcessCallStmt
        ##s#1_0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_0, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_0) > 0;
        assume Seq#Length(##s#1_0) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        // ProcessCallStmt: CheckSubrange
        s##1_0 := Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        assert Seq#Rank(s##1_0) < Seq#Rank(s#0);
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaCardinalityOfSetNoDuplicates(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s##1_0);
        // TrCallStmt: After ProcessCallStmt
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(202,7)
        ##s#1_1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_1, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        ##s#1_2 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_2, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_2) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        ##s#1_3 := Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_3, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
          Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0));
        ##s#1_4 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_4, TSeq(Seq._default.LemmaCardinalityOfSetNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_4) > 0;
        assume Seq.__default.Last#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0)
           && 
          Seq.__default.DropLast#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0)
           && Seq.__default.ToSet#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
            Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0))
           && Seq.__default.Last#canCall(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0);
        assert {:subsumption 0} Set#Equal(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
            StartFuelAssert_Seq._default.ToSet, 
            s#0), 
          Set#Union(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
              StartFuelAssert_Seq._default.ToSet, 
              Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0)), 
            Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.Last(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0))));
        assume Set#Equal(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
            StartFuel_Seq._default.ToSet, 
            s#0), 
          Set#Union(Seq.__default.ToSet(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, 
              StartFuel_Seq._default.ToSet, 
              Seq.__default.DropLast(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0)), 
            Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.Last(Seq._default.LemmaCardinalityOfSetNoDuplicates$T, s#0))));
    }
}



procedure {:verboseName "Seq.LemmaNoDuplicatesCardinalityOfSet (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap));
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaNoDuplicatesCardinalityOfSet (call)"} Call$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap));
  // user-defined preconditions
  requires Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
        StartFuelAssert_Seq._default.ToSet, 
        s#0))
     == Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
  ensures Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaNoDuplicatesCardinalityOfSet (correctness)"} Impl$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 2 == $FunctionContextHeight;
  // user-defined preconditions
  requires Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
        StartFuelAssert_Seq._default.ToSet, 
        s#0))
     == Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
  ensures Seq.__default.HasNoDuplicates(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaNoDuplicatesCardinalityOfSet (correctness)"} Impl$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#1_0: Seq Box;
  var ##s#1_1: Seq Box;
  var ##s#1_2: Seq Box;
  var ##s#1_3: Seq Box;
  var ##s#1_4: Seq Box;
  var ##s#1_5: Seq Box;
  var ##s#1_6: Seq Box;
  var ##s#1_7: Seq Box;
  var ##s#1_0_0: Seq Box;
  var ##s#1_0_1: Seq Box;
  var ##s#1_0_2: Seq Box;
  var s##1_0_0: Seq Box;
  var ##s#1_0_3: Seq Box;
  var ##s#1_0_4: Seq Box;
  var ##s#1_0_5: Seq Box;
  var ##s#1_1_0: Seq Box;
  var ##s#1_1_1: Seq Box;
  var ##s#1_1_2: Seq Box;
  var s##1_1_0: Seq Box;
  var ##s#1_1_3: Seq Box;

    // AddMethodImpl: LemmaNoDuplicatesCardinalityOfSet, Impl$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(211,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(211,27)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__HasNoDuplicates();
    // TrCallStmt: After ProcessCallStmt
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(212,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(212,17)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__ToSet();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(213,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(215,7)
        ##s#1_0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_0) > 0;
        assume Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        ##s#1_1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_1, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_1) > 0;
        assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        assume Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
           && Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        assert Seq#Equal(s#0, 
          Seq#Append(Seq#Build(Seq#Empty(): Seq Box, 
              Seq.__default.First(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)), 
            Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)));
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(216,7)
        ##s#1_2 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_2, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        ##s#1_3 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_3, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_3) > 0;
        assume Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        ##s#1_4 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_4, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_4) > 0;
        assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        ##s#1_5 := Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_5, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
          Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
        assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
           && 
          Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
           && 
          Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
           && Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
            Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
        assert {:subsumption 0} Set#Equal(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
            StartFuelAssert_Seq._default.ToSet, 
            s#0), 
          Set#Union(Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.First(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)), 
            Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
              StartFuelAssert_Seq._default.ToSet, 
              Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0))));
        assume Set#Equal(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
            StartFuel_Seq._default.ToSet, 
            s#0), 
          Set#Union(Set#UnionOne(Set#Empty(): Set Box, 
              Seq.__default.First(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)), 
            Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
              StartFuel_Seq._default.ToSet, 
              Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0))));
        // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(217,7)
        ##s#1_6 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_6, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_6) > 0;
        assume Seq#Length(##s#1_6) > 0;
        assume Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        ##s#1_7 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_7, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_7) > 0;
        assume Seq#Length(##s#1_7) > 0;
        assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        assume Seq.__default.First#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
           && Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
        if (Seq#Contains(Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0), 
          Seq.__default.First(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)))
        {
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(219,9)
            ##s#1_0_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            ##s#1_0_1 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_1) > 0;
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            ##s#1_0_2 := Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
              Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
               && 
              Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
               && Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
            assert {:subsumption 0} Set#Equal(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                StartFuelAssert_Seq._default.ToSet, 
                s#0), 
              Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                StartFuelAssert_Seq._default.ToSet, 
                Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)));
            assume Set#Equal(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                StartFuel_Seq._default.ToSet, 
                s#0), 
              Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                StartFuel_Seq._default.ToSet, 
                Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)));
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(220,30)
            // TrCallStmt: Before ProcessCallStmt
            ##s#1_0_3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_3, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_3) > 0;
            assume Seq#Length(##s#1_0_3) > 0;
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            // ProcessCallStmt: CheckSubrange
            s##1_0_0 := Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.LemmaCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s##1_0_0);
            // TrCallStmt: After ProcessCallStmt
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(221,9)
            ##s#1_0_4 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_4, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            ##s#1_0_5 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_5, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_5) > 0;
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
               && Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            assert {:subsumption 0} Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                  StartFuelAssert_Seq._default.ToSet, 
                  s#0))
               <= Seq#Length(Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
            assume Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                  StartFuel_Seq._default.ToSet, 
                  s#0))
               <= Seq#Length(Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
        }
        else
        {
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(223,9)
            ##s#1_1_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_1_0, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            ##s#1_1_1 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_1_1, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_1_1) > 0;
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            ##s#1_1_2 := Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_1_2, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
              Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
            assume Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
               && 
              Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)
               && Seq.__default.ToSet#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0));
            assert {:subsumption 0} Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                  StartFuelAssert_Seq._default.ToSet, 
                  s#0))
               == 1
                 + Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                    StartFuelAssert_Seq._default.ToSet, 
                    Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)));
            assume Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                  StartFuel_Seq._default.ToSet, 
                  s#0))
               == 1
                 + Set#Card(Seq.__default.ToSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, 
                    StartFuel_Seq._default.ToSet, 
                    Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0)));
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(224,42)
            // TrCallStmt: Before ProcessCallStmt
            ##s#1_1_3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_1_3, TSeq(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_1_3) > 0;
            assume Seq#Length(##s#1_1_3) > 0;
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            assume Seq.__default.DropFirst#canCall(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            // ProcessCallStmt: CheckSubrange
            s##1_1_0 := Seq.__default.DropFirst(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s#0);
            assert Seq#Rank(s##1_1_0) < Seq#Rank(s#0);
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.LemmaNoDuplicatesCardinalityOfSet(Seq._default.LemmaNoDuplicatesCardinalityOfSet$T, s##1_1_0);
            // TrCallStmt: After ProcessCallStmt
        }
    }
}



procedure {:verboseName "Seq.LemmaMultisetHasNoDuplicates (well-formedness)"} CheckWellFormed$$Seq.__default.LemmaMultisetHasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaMultisetHasNoDuplicates (call)"} Call$$Seq.__default.LemmaMultisetHasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap));
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures (forall x#1: Box :: 
    { MultiSet#FromSeq(s#0)[x#1] } 
    $IsBox(x#1, Seq._default.LemmaMultisetHasNoDuplicates$T)
         && MultiSet#FromSeq(s#0)[x#1] > 0
       ==> MultiSet#FromSeq(s#0)[x#1] == LitInt(1));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaMultisetHasNoDuplicates (correctness)"} Impl$$Seq.__default.LemmaMultisetHasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T))
         && $IsAlloc(s#0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires Seq.__default.HasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T, 
    StartFuelAssert_Seq._default.HasNoDuplicates, 
    s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures true;
  ensures (forall x#1: Box :: 
    { MultiSet#FromSeq(s#0)[x#1] } 
    $IsBox(x#1, Seq._default.LemmaMultisetHasNoDuplicates$T)
         && MultiSet#FromSeq(s#0)[x#1] > 0
       ==> MultiSet#FromSeq(s#0)[x#1] == LitInt(1));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaMultisetHasNoDuplicates (correctness)"} Impl$$Seq.__default.LemmaMultisetHasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#1_0: Seq Box;
  var ##s#1_1: Seq Box;
  var ##s#1_2: Seq Box;
  var ##s#1_3: Seq Box;
  var ##s#1_4: Seq Box;
  var ##s#1_5: Seq Box;
  var s##1_0: Seq Box;
  var ##s#1_6: Seq Box;

    // AddMethodImpl: LemmaMultisetHasNoDuplicates, Impl$$Seq.__default.LemmaMultisetHasNoDuplicates
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(234,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(236,7)
        ##s#1_0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_0, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_0) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        ##s#1_1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_1, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_1) > 0;
        assume Seq.__default.Last#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0)
           && Seq.__default.Last#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        assert Seq#Equal(s#0, 
          Seq#Append(Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0), 
            Seq#Build(Seq#Empty(): Seq Box, 
              Seq.__default.Last(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0))));
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(237,7)
        ##s#1_2 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_2, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_2) > 0;
        assume Seq.__default.Last#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        ##s#1_3 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_3, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_3) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        assume Seq.__default.Last#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0)
           && Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        if (*)
        {
            // ----- assert statement proof ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(237,7)
            // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(238,9)
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(238,31)
            // TrCallStmt: Before ProcessCallStmt
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.reveal__HasNoDuplicates();
            // TrCallStmt: After ProcessCallStmt
            assert !Seq#Contains(Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0), 
              Seq.__default.Last(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
            assume false;
        }

        assume !Seq#Contains(Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0), 
          Seq.__default.Last(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(240,7)
        ##s#1_4 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_4, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_4) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        ##s#1_5 := Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_5, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assume Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, 
          Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0)
           && Seq.__default.HasNoDuplicates#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, 
            Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
        if (*)
        {
            // ----- assert statement proof ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(240,7)
            // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(241,9)
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(241,31)
            // TrCallStmt: Before ProcessCallStmt
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.reveal__HasNoDuplicates();
            // TrCallStmt: After ProcessCallStmt
            assert {:subsumption 0} Seq.__default.HasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T, 
              StartFuelAssert_Seq._default.HasNoDuplicates, 
              Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
            assume false;
        }

        assume Seq.__default.HasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T, 
          StartFuelAssert_Seq._default.HasNoDuplicates, 
          Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0));
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(243,35)
        // TrCallStmt: Before ProcessCallStmt
        ##s#1_6 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_6, TSeq(Seq._default.LemmaMultisetHasNoDuplicates$T), $Heap);
        assert {:subsumption 0} Seq#Length(##s#1_6) > 0;
        assume Seq#Length(##s#1_6) > 0;
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        assume Seq.__default.DropLast#canCall(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        // ProcessCallStmt: CheckSubrange
        s##1_0 := Seq.__default.DropLast(Seq._default.LemmaMultisetHasNoDuplicates$T, s#0);
        assert Seq#Rank(s##1_0) < Seq#Rank(s#0);
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaMultisetHasNoDuplicates(Seq._default.LemmaMultisetHasNoDuplicates$T, s##1_0);
        // TrCallStmt: After ProcessCallStmt
    }
}



// function declaration for Seq._default.IndexOf
function Seq.__default.IndexOf(Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box) : int;

function Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T: Ty, s#0: Seq Box, v#0: Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), s#0, v#0) } 
  Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), s#0, v#0)
     == Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0));

// fuel synonym axiom
axiom (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOf(Seq._default.IndexOf$T, AsFuelBottom($ly), s#0, v#0) } 
  Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0)
     == Seq.__default.IndexOf(Seq._default.IndexOf$T, $LZ, s#0, v#0));

// consequence axiom for Seq.__default.IndexOf
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0) } 
    Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOf$T))
           && $IsBox(v#0, Seq._default.IndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0) < Seq#Length(s#0)
         && Seq#Index(s#0, Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0))
           == v#0
         && (forall j#0: int :: 
          { Seq#Index(s#0, j#0) } 
          true
             ==> 
            LitInt(0) <= j#0
               && j#0 < Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0)
             ==> Seq#Index(s#0, j#0) != v#0)
         && LitInt(0) <= Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, s#0, v#0));

function Seq.__default.IndexOf#requires(Ty, LayerType, Seq Box, Box) : bool;

// #requires axiom for Seq.__default.IndexOf
axiom (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOf#requires(Seq._default.IndexOf$T, $ly, s#0, v#0) } 
  $Is(s#0, TSeq(Seq._default.IndexOf$T)) && $IsBox(v#0, Seq._default.IndexOf$T)
     ==> Seq.__default.IndexOf#requires(Seq._default.IndexOf$T, $ly, s#0, v#0)
       == Seq#Contains(s#0, v#0));

// definition axiom for Seq.__default.IndexOf (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), s#0, v#0) } 
    Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOf$T))
           && $IsBox(v#0, Seq._default.IndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(s#0, LitInt(0)) != v#0
           ==> Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Seq#Drop(s#0, LitInt(1)), v#0))
         && Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), s#0, v#0)
           == (if Seq#Index(s#0, LitInt(0)) == v#0
             then 0
             else 1
               + Seq.__default.IndexOf(Seq._default.IndexOf$T, $ly, Seq#Drop(s#0, LitInt(1)), v#0)));

// definition axiom for Seq.__default.IndexOf for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(s#0), v#0) } 
    Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Lit(s#0), v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOf$T))
           && $IsBox(v#0, Seq._default.IndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(Lit(s#0), LitInt(0)) != v#0
           ==> Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Lit(Seq#Drop(Lit(s#0), LitInt(1))), v#0))
         && Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(s#0), v#0)
           == (if Seq#Index(Lit(s#0), LitInt(0)) == v#0
             then 0
             else 1
               + Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1))), v#0)));

// definition axiom for Seq.__default.IndexOf for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(s#0), Lit(v#0)) } 
    Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Lit(s#0), Lit(v#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOf$T))
           && $IsBox(v#0, Seq._default.IndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(Lit(s#0), LitInt(0)) != Lit(v#0)
           ==> Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Lit(Seq#Drop(Lit(s#0), LitInt(1))), Lit(v#0)))
         && Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(s#0), Lit(v#0))
           == (if Seq#Index(Lit(s#0), LitInt(0)) == Lit(v#0)
             then 0
             else 1
               + Seq.__default.IndexOf(Seq._default.IndexOf$T, $LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1))), Lit(v#0))));

procedure {:verboseName "Seq.IndexOf (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.IndexOf(Seq._default.IndexOf$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.IndexOf$T)), 
    v#0: Box where $IsBox(v#0, Seq._default.IndexOf$T))
   returns (i#0: int where LitInt(0) <= i#0);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures i#0 < Seq#Length(s#0);
  ensures Seq#Index(s#0, i#0) == v#0;
  ensures (forall j#1: int :: 
    { Seq#Index(s#0, j#1) } 
    true ==> LitInt(0) <= j#1 && j#1 < i#0 ==> Seq#Index(s#0, j#1) != v#0);



implementation {:verboseName "Seq.IndexOf (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.IndexOf(Seq._default.IndexOf$T: Ty, s#0: Seq Box, v#0: Box) returns (i#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var j#2: int;
  var ##s#0: Seq Box;
  var ##v#0: Box;


    // AddWellformednessCheck for function IndexOf
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Contains(s#0, v#0);
    if (*)
    {
        assume LitInt(0)
           <= Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0);
        assume i#0 < Seq#Length(s#0);
        assert 0 <= i#0 && i#0 < Seq#Length(s#0);
        assume Seq#Index(s#0, i#0) == v#0;
        havoc j#2;
        assume true;
        if (*)
        {
            if (LitInt(0) <= j#2)
            {
            }

            assume LitInt(0) <= j#2 && j#2 < i#0;
            assert 0 <= j#2 && j#2 < Seq#Length(s#0);
            assume Seq#Index(s#0, j#2) != v#0;
        }
        else
        {
            assume LitInt(0) <= j#2 && j#2 < i#0 ==> Seq#Index(s#0, j#2) != v#0;
        }

        assume (forall j#1: int :: 
          { Seq#Index(s#0, j#1) } 
          true ==> LitInt(0) <= j#1 && j#1 < i#0 ==> Seq#Index(s#0, j#1) != v#0);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
        if (Seq#Index(s#0, LitInt(0)) == v#0)
        {
            assert $Is(LitInt(0), Tclass._System.nat());
            assume Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0)
               == LitInt(0);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0), 
              Tclass._System.nat());
        }
        else
        {
            assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
            ##s#0 := Seq#Drop(s#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(Seq._default.IndexOf$T), $Heap);
            ##v#0 := v#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##v#0, Seq._default.IndexOf$T, $Heap);
            assert {:subsumption 0} Seq#Contains(##s#0, ##v#0);
            assume Seq#Contains(##s#0, ##v#0);
            assert Seq#Rank(##s#0) < Seq#Rank(s#0);
            assume Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Seq#Drop(s#0, LitInt(1)), v#0);
            assert $Is(1
                 + Seq.__default.IndexOf(Seq._default.IndexOf$T, 
                  StartFuel_Seq._default.IndexOf, 
                  Seq#Drop(s#0, LitInt(1)), 
                  v#0), 
              Tclass._System.nat());
            assume Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0)
               == 1
                 + Seq.__default.IndexOf(Seq._default.IndexOf$T, 
                  StartFuel_Seq._default.IndexOf, 
                  Seq#Drop(s#0, LitInt(1)), 
                  v#0);
            assume Seq.__default.IndexOf#canCall(Seq._default.IndexOf$T, Seq#Drop(s#0, LitInt(1)), v#0);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0), 
              Tclass._System.nat());
        }

        assume Seq.__default.IndexOf(Seq._default.IndexOf$T, StartFuel_Seq._default.IndexOf, s#0, v#0)
           == i#0;
    }
}



// function declaration for Seq._default.IndexOfOption
function Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box)
   : DatatypeType;

function Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T: Ty, s#0: Seq Box, v#0: Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), s#0, v#0) } 
  Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), s#0, v#0)
     == Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0));

// fuel synonym axiom
axiom (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, AsFuelBottom($ly), s#0, v#0) } 
  Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0)
     == Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LZ, s#0, v#0));

function Tclass.Wrappers.Option(Ty) : Ty;

const unique Tagclass.Wrappers.Option: TyTag;

// Tclass.Wrappers.Option Tag
axiom (forall Wrappers.Option$T: Ty :: 
  { Tclass.Wrappers.Option(Wrappers.Option$T) } 
  Tag(Tclass.Wrappers.Option(Wrappers.Option$T)) == Tagclass.Wrappers.Option
     && TagFamily(Tclass.Wrappers.Option(Wrappers.Option$T)) == tytagFamily$Option);

function Tclass.Wrappers.Option_0(Ty) : Ty;

// Tclass.Wrappers.Option injectivity 0
axiom (forall Wrappers.Option$T: Ty :: 
  { Tclass.Wrappers.Option(Wrappers.Option$T) } 
  Tclass.Wrappers.Option_0(Tclass.Wrappers.Option(Wrappers.Option$T))
     == Wrappers.Option$T);

// Box/unbox axiom for Tclass.Wrappers.Option
axiom (forall Wrappers.Option$T: Ty, bx: Box :: 
  { $IsBox(bx, Tclass.Wrappers.Option(Wrappers.Option$T)) } 
  $IsBox(bx, Tclass.Wrappers.Option(Wrappers.Option$T))
     ==> $Box($Unbox(bx): DatatypeType) == bx
       && $Is($Unbox(bx): DatatypeType, Tclass.Wrappers.Option(Wrappers.Option$T)));

// consequence axiom for Seq.__default.IndexOfOption
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0) } 
    Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOfOption$T))
           && $IsBox(v#0, Seq._default.IndexOfOption$T))
       ==> (if Wrappers.Option.Some_q(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0))
           then $Unbox(Wrappers.Option.value(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0))): int
               < Seq#Length(s#0)
             && Seq#Index(s#0, 
                $Unbox(Wrappers.Option.value(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0))): int)
               == v#0
             && (forall j#0: int :: 
              { Seq#Index(s#0, j#0) } 
              true
                 ==> 
                LitInt(0) <= j#0
                   && j#0
                     < $Unbox(Wrappers.Option.value(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0))): int
                 ==> Seq#Index(s#0, j#0) != v#0)
           else !Seq#Contains(s#0, v#0))
         && $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, s#0, v#0), 
          Tclass.Wrappers.Option(Tclass._System.nat())));

function Seq.__default.IndexOfOption#requires(Ty, LayerType, Seq Box, Box) : bool;

// #requires axiom for Seq.__default.IndexOfOption
axiom (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.IndexOfOption#requires(Seq._default.IndexOfOption$T, $ly, s#0, v#0) } 
  $Is(s#0, TSeq(Seq._default.IndexOfOption$T))
       && $IsBox(v#0, Seq._default.IndexOfOption$T)
     ==> Seq.__default.IndexOfOption#requires(Seq._default.IndexOfOption$T, $ly, s#0, v#0)
       == true);

// definition axiom for Seq.__default.IndexOfOption (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), s#0, v#0) } 
    Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOfOption$T))
           && $IsBox(v#0, Seq._default.IndexOfOption$T))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> 
          Seq#Index(s#0, LitInt(0)) != v#0
           ==> Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Seq#Drop(s#0, LitInt(1)), v#0))
         && Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), s#0, v#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(s#0, LitInt(0)) == v#0
               then #Wrappers.Option.Some($Box(LitInt(0)))
               else (var o'#0 := Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $ly, Seq#Drop(s#0, LitInt(1)), v#0); 
                (if Wrappers.Option.Some_q(o'#0)
                   then #Wrappers.Option.Some($Box($Unbox(Wrappers.Option.value(o'#0)): int + 1))
                   else #Wrappers.Option.None())))));

// definition axiom for Seq.__default.IndexOfOption for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), Lit(s#0), v#0) } 
    Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Lit(s#0), v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOfOption$T))
           && $IsBox(v#0, Seq._default.IndexOfOption$T))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> 
          Seq#Index(Lit(s#0), LitInt(0)) != v#0
           ==> Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Lit(Seq#Drop(Lit(s#0), LitInt(1))), v#0))
         && Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), Lit(s#0), v#0)
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(Lit(s#0), LitInt(0)) == v#0
               then #Wrappers.Option.Some($Box(LitInt(0)))
               else (var o'#1 := Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1))), v#0); 
                (if Wrappers.Option.Some_q(o'#1)
                   then #Wrappers.Option.Some($Box($Unbox(Wrappers.Option.value(o'#1)): int + 1))
                   else #Wrappers.Option.None())))));

// definition axiom for Seq.__default.IndexOfOption for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.IndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), Lit(s#0), Lit(v#0)) } 
    Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Lit(s#0), Lit(v#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.IndexOfOption$T))
           && $IsBox(v#0, Seq._default.IndexOfOption$T))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> 
          Seq#Index(Lit(s#0), LitInt(0)) != Lit(v#0)
           ==> Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Lit(Seq#Drop(Lit(s#0), LitInt(1))), Lit(v#0)))
         && Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, $LS($ly), Lit(s#0), Lit(v#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(Lit(s#0), LitInt(0)) == Lit(v#0)
               then #Wrappers.Option.Some($Box(LitInt(0)))
               else (var o'#2 := Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, 
                    $LS($ly), 
                    Lit(Seq#Drop(Lit(s#0), LitInt(1))), 
                    Lit(v#0)); 
                (if Wrappers.Option.Some_q(o'#2)
                   then #Wrappers.Option.Some($Box($Unbox(Wrappers.Option.value(o'#2)): int + 1))
                   else #Wrappers.Option.None())))));

procedure {:verboseName "Seq.IndexOfOption (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.IndexOfOption$T)), 
    v#0: Box where $IsBox(v#0, Seq._default.IndexOfOption$T))
   returns (o#0: DatatypeType where $Is(o#0, Tclass.Wrappers.Option(Tclass._System.nat())));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Wrappers.Option.Some_q(o#0)
     ==> $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
  ensures Wrappers.Option.Some_q(o#0)
     ==> Seq#Index(s#0, $Unbox(Wrappers.Option.value(o#0)): int) == v#0;
  ensures Wrappers.Option.Some_q(o#0)
     ==> (forall j#1: int :: 
      { Seq#Index(s#0, j#1) } 
      true
         ==> 
        LitInt(0) <= j#1 && j#1 < $Unbox(Wrappers.Option.value(o#0)): int
         ==> Seq#Index(s#0, j#1) != v#0);
  ensures !Wrappers.Option.Some_q(o#0) ==> !Seq#Contains(s#0, v#0);



implementation {:verboseName "Seq.IndexOfOption (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T: Ty, s#0: Seq Box, v#0: Box)
   returns (o#0: DatatypeType)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var j#2: int;
  var o'#Z#0: DatatypeType;
  var let#0#0#0: DatatypeType;
  var ##s#0: Seq Box;
  var ##v#0: Box;


    // AddWellformednessCheck for function IndexOfOption
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0), 
          Tclass.Wrappers.Option(Tclass._System.nat()));
        if (*)
        {
            assume Wrappers.Option.Some_q(o#0);
            assert Wrappers.Option.Some_q(o#0);
            assume $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
            assert Wrappers.Option.Some_q(o#0);
            assert 0 <= $Unbox(Wrappers.Option.value(o#0)): int
               && $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
            assume Seq#Index(s#0, $Unbox(Wrappers.Option.value(o#0)): int) == v#0;
            havoc j#2;
            assume true;
            if (*)
            {
                if (LitInt(0) <= j#2)
                {
                    assert Wrappers.Option.Some_q(o#0);
                }

                assume LitInt(0) <= j#2 && j#2 < $Unbox(Wrappers.Option.value(o#0)): int;
                assert 0 <= j#2 && j#2 < Seq#Length(s#0);
                assume Seq#Index(s#0, j#2) != v#0;
            }
            else
            {
                assume LitInt(0) <= j#2 && j#2 < $Unbox(Wrappers.Option.value(o#0)): int
                   ==> Seq#Index(s#0, j#2) != v#0;
            }

            assume (forall j#1: int :: 
              { Seq#Index(s#0, j#1) } 
              true
                 ==> 
                LitInt(0) <= j#1 && j#1 < $Unbox(Wrappers.Option.value(o#0)): int
                 ==> Seq#Index(s#0, j#1) != v#0);
        }
        else
        {
            assume !Wrappers.Option.Some_q(o#0);
            assume !Seq#Contains(s#0, v#0);
        }

        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(s#0) == LitInt(0))
        {
            assert $Is(Lit(#Wrappers.Option.None()), Tclass.Wrappers.Option(Tclass._System.nat()));
            assume Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0)
               == Lit(#Wrappers.Option.None());
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0), 
              Tclass.Wrappers.Option(Tclass._System.nat()));
        }
        else
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            if (Seq#Index(s#0, LitInt(0)) == v#0)
            {
                assert $Is(Lit(#Wrappers.Option.Some($Box(LitInt(0)))), 
                  Tclass.Wrappers.Option(Tclass._System.nat()));
                assume Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0)
                   == Lit(#Wrappers.Option.Some($Box(LitInt(0))));
                assume true;
                // CheckWellformedWithResult: any expression
                assume $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0), 
                  Tclass.Wrappers.Option(Tclass._System.nat()));
            }
            else
            {
                havoc o'#Z#0;
                assume $Is(o'#Z#0, Tclass.Wrappers.Option(Tclass._System.nat()))
                   && $IsAlloc(o'#Z#0, Tclass.Wrappers.Option(Tclass._System.nat()), $Heap);
                assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
                ##s#0 := Seq#Drop(s#0, LitInt(1));
                // assume allocatedness for argument to function
                assume $IsAlloc(##s#0, TSeq(Seq._default.IndexOfOption$T), $Heap);
                ##v#0 := v#0;
                // assume allocatedness for argument to function
                assume $IsAllocBox(##v#0, Seq._default.IndexOfOption$T, $Heap);
                assert Seq#Rank(##s#0) < Seq#Rank(s#0);
                assume Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Seq#Drop(s#0, LitInt(1)), v#0);
                assume let#0#0#0
                   == Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, 
                    StartFuel_Seq._default.IndexOfOption, 
                    Seq#Drop(s#0, LitInt(1)), 
                    v#0);
                assume Seq.__default.IndexOfOption#canCall(Seq._default.IndexOfOption$T, Seq#Drop(s#0, LitInt(1)), v#0);
                // CheckWellformedWithResult: any expression
                assume $Is(let#0#0#0, Tclass.Wrappers.Option(Tclass._System.nat()));
                assume o'#Z#0 == let#0#0#0;
                if (Wrappers.Option.Some_q(o'#Z#0))
                {
                    assert Wrappers.Option.Some_q(o'#Z#0);
                    assert $Is(#Wrappers.Option.Some($Box($Unbox(Wrappers.Option.value(o'#Z#0)): int + 1)), 
                      Tclass.Wrappers.Option(Tclass._System.nat()));
                    assume Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0)
                       == #Wrappers.Option.Some($Box($Unbox(Wrappers.Option.value(o'#Z#0)): int + 1));
                    assume true;
                    // CheckWellformedWithResult: any expression
                    assume $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0), 
                      Tclass.Wrappers.Option(Tclass._System.nat()));
                }
                else
                {
                    assert $Is(Lit(#Wrappers.Option.None()), Tclass.Wrappers.Option(Tclass._System.nat()));
                    assume Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0)
                       == Lit(#Wrappers.Option.None());
                    assume true;
                    // CheckWellformedWithResult: any expression
                    assume $Is(Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0), 
                      Tclass.Wrappers.Option(Tclass._System.nat()));
                }
            }
        }

        assume Seq.__default.IndexOfOption(Seq._default.IndexOfOption$T, StartFuel_Seq._default.IndexOfOption, s#0, v#0)
           == o#0;
    }
}



// function declaration for Seq._default.LastIndexOf
function Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box) : int;

function Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T: Ty, s#0: Seq Box, v#0: Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), s#0, v#0) } 
  Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), s#0, v#0)
     == Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0));

// fuel synonym axiom
axiom (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, AsFuelBottom($ly), s#0, v#0) } 
  Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0)
     == Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LZ, s#0, v#0));

// consequence axiom for Seq.__default.LastIndexOf
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0) } 
    Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOf$T))
           && $IsBox(v#0, Seq._default.LastIndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0)
           < Seq#Length(s#0)
         && Seq#Index(s#0, Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0))
           == v#0
         && (forall j#0: int :: 
          { Seq#Index(s#0, j#0) } 
          true
             ==> 
            Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0) < j#0
               && j#0 < Seq#Length(s#0)
             ==> Seq#Index(s#0, j#0) != v#0)
         && LitInt(0)
           <= Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, s#0, v#0));

function Seq.__default.LastIndexOf#requires(Ty, LayerType, Seq Box, Box) : bool;

// #requires axiom for Seq.__default.LastIndexOf
axiom (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOf#requires(Seq._default.LastIndexOf$T, $ly, s#0, v#0) } 
  $Is(s#0, TSeq(Seq._default.LastIndexOf$T))
       && $IsBox(v#0, Seq._default.LastIndexOf$T)
     ==> Seq.__default.LastIndexOf#requires(Seq._default.LastIndexOf$T, $ly, s#0, v#0)
       == Seq#Contains(s#0, v#0));

// definition axiom for Seq.__default.LastIndexOf (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), s#0, v#0) } 
    Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOf$T))
           && $IsBox(v#0, Seq._default.LastIndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(s#0, Seq#Length(s#0) - 1) != v#0
           ==> Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0))
         && Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), s#0, v#0)
           == (if Seq#Index(s#0, Seq#Length(s#0) - 1) == v#0
             then Seq#Length(s#0) - 1
             else Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $ly, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0)));

// definition axiom for Seq.__default.LastIndexOf for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), Lit(s#0), v#0) } 
    Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Lit(s#0), v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOf$T))
           && $IsBox(v#0, Seq._default.LastIndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) != v#0
           ==> Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), v#0))
         && Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), Lit(s#0), v#0)
           == (if Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) == v#0
             then Seq#Length(Lit(s#0)) - 1
             else Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, 
              $LS($ly), 
              Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
              v#0)));

// definition axiom for Seq.__default.LastIndexOf for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOf$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), Lit(s#0), Lit(v#0)) } 
    Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Lit(s#0), Lit(v#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOf$T))
           && $IsBox(v#0, Seq._default.LastIndexOf$T)
           && Seq#Contains(s#0, v#0))
       ==> (Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) != Lit(v#0)
           ==> Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, 
            Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
            Lit(v#0)))
         && Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, $LS($ly), Lit(s#0), Lit(v#0))
           == (if Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) == Lit(v#0)
             then Seq#Length(Lit(s#0)) - 1
             else Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, 
              $LS($ly), 
              Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
              Lit(v#0))));

procedure {:verboseName "Seq.LastIndexOf (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.LastIndexOf$T)), 
    v#0: Box where $IsBox(v#0, Seq._default.LastIndexOf$T))
   returns (i#0: int where LitInt(0) <= i#0);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures i#0 < Seq#Length(s#0);
  ensures Seq#Index(s#0, i#0) == v#0;
  ensures (forall j#1: int :: 
    { Seq#Index(s#0, j#1) } 
    true ==> i#0 < j#1 && j#1 < Seq#Length(s#0) ==> Seq#Index(s#0, j#1) != v#0);



implementation {:verboseName "Seq.LastIndexOf (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T: Ty, s#0: Seq Box, v#0: Box) returns (i#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var j#2: int;
  var ##s#0: Seq Box;
  var ##v#0: Box;


    // AddWellformednessCheck for function LastIndexOf
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Contains(s#0, v#0);
    if (*)
    {
        assume LitInt(0)
           <= Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0);
        assume i#0 < Seq#Length(s#0);
        assert 0 <= i#0 && i#0 < Seq#Length(s#0);
        assume Seq#Index(s#0, i#0) == v#0;
        havoc j#2;
        assume true;
        if (*)
        {
            if (i#0 < j#2)
            {
            }

            assume i#0 < j#2 && j#2 < Seq#Length(s#0);
            assert 0 <= j#2 && j#2 < Seq#Length(s#0);
            assume Seq#Index(s#0, j#2) != v#0;
        }
        else
        {
            assume i#0 < j#2 && j#2 < Seq#Length(s#0) ==> Seq#Index(s#0, j#2) != v#0;
        }

        assume (forall j#1: int :: 
          { Seq#Index(s#0, j#1) } 
          true ==> i#0 < j#1 && j#1 < Seq#Length(s#0) ==> Seq#Index(s#0, j#1) != v#0);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 < Seq#Length(s#0);
        if (Seq#Index(s#0, Seq#Length(s#0) - 1) == v#0)
        {
            assert $Is(Seq#Length(s#0) - 1, Tclass._System.nat());
            assume Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0)
               == Seq#Length(s#0) - 1;
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0), 
              Tclass._System.nat());
        }
        else
        {
            assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
            ##s#0 := Seq#Take(s#0, Seq#Length(s#0) - 1);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(Seq._default.LastIndexOf$T), $Heap);
            ##v#0 := v#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##v#0, Seq._default.LastIndexOf$T, $Heap);
            assert {:subsumption 0} Seq#Contains(##s#0, ##v#0);
            assume Seq#Contains(##s#0, ##v#0);
            assert Seq#Rank(##s#0) < Seq#Rank(s#0);
            assume Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0);
            assume Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0)
               == Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, 
                StartFuel_Seq._default.LastIndexOf, 
                Seq#Take(s#0, Seq#Length(s#0) - 1), 
                v#0);
            assume Seq.__default.LastIndexOf#canCall(Seq._default.LastIndexOf$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0), 
              Tclass._System.nat());
        }

        assume Seq.__default.LastIndexOf(Seq._default.LastIndexOf$T, StartFuel_Seq._default.LastIndexOf, s#0, v#0)
           == i#0;
    }
}



// function declaration for Seq._default.LastIndexOfOption
function Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box)
   : DatatypeType;

function Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T: Ty, s#0: Seq Box, v#0: Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), s#0, v#0) } 
  Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), s#0, v#0)
     == Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0));

// fuel synonym axiom
axiom (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, AsFuelBottom($ly), s#0, v#0) } 
  Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0)
     == Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LZ, s#0, v#0));

// consequence axiom for Seq.__default.LastIndexOfOption
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0) } 
    Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T))
           && $IsBox(v#0, Seq._default.LastIndexOfOption$T))
       ==> (if Wrappers.Option.Some_q(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0))
           then $Unbox(Wrappers.Option.value(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0))): int
               < Seq#Length(s#0)
             && Seq#Index(s#0, 
                $Unbox(Wrappers.Option.value(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0))): int)
               == v#0
             && (forall j#0: int :: 
              { Seq#Index(s#0, j#0) } 
              true
                 ==> 
                $Unbox(Wrappers.Option.value(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0))): int
                     < j#0
                   && j#0 < Seq#Length(s#0)
                 ==> Seq#Index(s#0, j#0) != v#0)
           else !Seq#Contains(s#0, v#0))
         && $Is(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0), 
          Tclass.Wrappers.Option(Tclass._System.nat())));

function Seq.__default.LastIndexOfOption#requires(Ty, LayerType, Seq Box, Box) : bool;

// #requires axiom for Seq.__default.LastIndexOfOption
axiom (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.LastIndexOfOption#requires(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0) } 
  $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T))
       && $IsBox(v#0, Seq._default.LastIndexOfOption$T)
     ==> Seq.__default.LastIndexOfOption#requires(Seq._default.LastIndexOfOption$T, $ly, s#0, v#0)
       == true);

// definition axiom for Seq.__default.LastIndexOfOption (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), s#0, v#0) } 
    Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, s#0, v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T))
           && $IsBox(v#0, Seq._default.LastIndexOfOption$T))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> 
          Seq#Index(s#0, Seq#Length(s#0) - 1) != v#0
           ==> Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0))
         && Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), s#0, v#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(s#0, Seq#Length(s#0) - 1) == v#0
               then #Wrappers.Option.Some($Box(Seq#Length(s#0) - 1))
               else Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $ly, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0))));

// definition axiom for Seq.__default.LastIndexOfOption for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), Lit(s#0), v#0) } 
    Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, Lit(s#0), v#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T))
           && $IsBox(v#0, Seq._default.LastIndexOfOption$T))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> 
          Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) != v#0
           ==> Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, 
            Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
            v#0))
         && Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), Lit(s#0), v#0)
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) == v#0
               then #Wrappers.Option.Some($Box(Seq#Length(Lit(s#0)) - 1))
               else Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                $LS($ly), 
                Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
                v#0))));

// definition axiom for Seq.__default.LastIndexOfOption for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.LastIndexOfOption$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), Lit(s#0), Lit(v#0)) } 
    Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, Lit(s#0), Lit(v#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T))
           && $IsBox(v#0, Seq._default.LastIndexOfOption$T))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> 
          Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) != Lit(v#0)
           ==> Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, 
            Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
            Lit(v#0)))
         && Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, $LS($ly), Lit(s#0), Lit(v#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then #Wrappers.Option.None()
             else (if Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1) == Lit(v#0)
               then #Wrappers.Option.Some($Box(Seq#Length(Lit(s#0)) - 1))
               else Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                $LS($ly), 
                Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), 
                Lit(v#0)))));

procedure {:verboseName "Seq.LastIndexOfOption (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.LastIndexOfOption$T)), 
    v#0: Box where $IsBox(v#0, Seq._default.LastIndexOfOption$T))
   returns (o#0: DatatypeType where $Is(o#0, Tclass.Wrappers.Option(Tclass._System.nat())));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Wrappers.Option.Some_q(o#0)
     ==> $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
  ensures Wrappers.Option.Some_q(o#0)
     ==> Seq#Index(s#0, $Unbox(Wrappers.Option.value(o#0)): int) == v#0;
  ensures Wrappers.Option.Some_q(o#0)
     ==> (forall j#1: int :: 
      { Seq#Index(s#0, j#1) } 
      true
         ==> 
        $Unbox(Wrappers.Option.value(o#0)): int < j#1 && j#1 < Seq#Length(s#0)
         ==> Seq#Index(s#0, j#1) != v#0);
  ensures !Wrappers.Option.Some_q(o#0) ==> !Seq#Contains(s#0, v#0);



implementation {:verboseName "Seq.LastIndexOfOption (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T: Ty, s#0: Seq Box, v#0: Box)
   returns (o#0: DatatypeType)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var j#2: int;
  var ##s#0: Seq Box;
  var ##v#0: Box;


    // AddWellformednessCheck for function LastIndexOfOption
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
            StartFuel_Seq._default.LastIndexOfOption, 
            s#0, 
            v#0), 
          Tclass.Wrappers.Option(Tclass._System.nat()));
        if (*)
        {
            assume Wrappers.Option.Some_q(o#0);
            assert Wrappers.Option.Some_q(o#0);
            assume $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
            assert Wrappers.Option.Some_q(o#0);
            assert 0 <= $Unbox(Wrappers.Option.value(o#0)): int
               && $Unbox(Wrappers.Option.value(o#0)): int < Seq#Length(s#0);
            assume Seq#Index(s#0, $Unbox(Wrappers.Option.value(o#0)): int) == v#0;
            havoc j#2;
            assume true;
            if (*)
            {
                assert Wrappers.Option.Some_q(o#0);
                if ($Unbox(Wrappers.Option.value(o#0)): int < j#2)
                {
                }

                assume $Unbox(Wrappers.Option.value(o#0)): int < j#2 && j#2 < Seq#Length(s#0);
                assert 0 <= j#2 && j#2 < Seq#Length(s#0);
                assume Seq#Index(s#0, j#2) != v#0;
            }
            else
            {
                assume $Unbox(Wrappers.Option.value(o#0)): int < j#2 && j#2 < Seq#Length(s#0)
                   ==> Seq#Index(s#0, j#2) != v#0;
            }

            assume (forall j#1: int :: 
              { Seq#Index(s#0, j#1) } 
              true
                 ==> 
                $Unbox(Wrappers.Option.value(o#0)): int < j#1 && j#1 < Seq#Length(s#0)
                 ==> Seq#Index(s#0, j#1) != v#0);
        }
        else
        {
            assume !Wrappers.Option.Some_q(o#0);
            assume !Seq#Contains(s#0, v#0);
        }

        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(s#0) == LitInt(0))
        {
            assert $Is(Lit(#Wrappers.Option.None()), Tclass.Wrappers.Option(Tclass._System.nat()));
            assume Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                StartFuel_Seq._default.LastIndexOfOption, 
                s#0, 
                v#0)
               == Lit(#Wrappers.Option.None());
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                StartFuel_Seq._default.LastIndexOfOption, 
                s#0, 
                v#0), 
              Tclass.Wrappers.Option(Tclass._System.nat()));
        }
        else
        {
            assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 < Seq#Length(s#0);
            if (Seq#Index(s#0, Seq#Length(s#0) - 1) == v#0)
            {
                assert $Is(#Wrappers.Option.Some($Box(Seq#Length(s#0) - 1)), 
                  Tclass.Wrappers.Option(Tclass._System.nat()));
                assume Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                    StartFuel_Seq._default.LastIndexOfOption, 
                    s#0, 
                    v#0)
                   == #Wrappers.Option.Some($Box(Seq#Length(s#0) - 1));
                assume true;
                // CheckWellformedWithResult: any expression
                assume $Is(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                    StartFuel_Seq._default.LastIndexOfOption, 
                    s#0, 
                    v#0), 
                  Tclass.Wrappers.Option(Tclass._System.nat()));
            }
            else
            {
                assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
                ##s#0 := Seq#Take(s#0, Seq#Length(s#0) - 1);
                // assume allocatedness for argument to function
                assume $IsAlloc(##s#0, TSeq(Seq._default.LastIndexOfOption$T), $Heap);
                ##v#0 := v#0;
                // assume allocatedness for argument to function
                assume $IsAllocBox(##v#0, Seq._default.LastIndexOfOption$T, $Heap);
                assert Seq#Rank(##s#0) < Seq#Rank(s#0);
                assume Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0);
                assume Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                    StartFuel_Seq._default.LastIndexOfOption, 
                    s#0, 
                    v#0)
                   == Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                    StartFuel_Seq._default.LastIndexOfOption, 
                    Seq#Take(s#0, Seq#Length(s#0) - 1), 
                    v#0);
                assume Seq.__default.LastIndexOfOption#canCall(Seq._default.LastIndexOfOption$T, Seq#Take(s#0, Seq#Length(s#0) - 1), v#0);
                // CheckWellformedWithResult: any expression
                assume $Is(Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
                    StartFuel_Seq._default.LastIndexOfOption, 
                    s#0, 
                    v#0), 
                  Tclass.Wrappers.Option(Tclass._System.nat()));
            }
        }

        assume Seq.__default.LastIndexOfOption(Seq._default.LastIndexOfOption$T, 
            StartFuel_Seq._default.LastIndexOfOption, 
            s#0, 
            v#0)
           == o#0;
    }
}



// function declaration for Seq._default.Remove
function Seq.__default.Remove(Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int) : Seq Box;

function Seq.__default.Remove#canCall(Seq._default.Remove$T: Ty, s#0: Seq Box, pos#0: int) : bool;

// layer synonym axiom
axiom (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
  { Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), s#0, pos#0) } 
  Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), s#0, pos#0)
     == Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0));

// fuel synonym axiom
axiom (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
  { Seq.__default.Remove(Seq._default.Remove$T, AsFuelBottom($ly), s#0, pos#0) } 
  Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0)
     == Seq.__default.Remove(Seq._default.Remove$T, $LZ, s#0, pos#0));

// consequence axiom for Seq.__default.Remove
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
    { Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0) } 
    Seq.__default.Remove#canCall(Seq._default.Remove$T, s#0, pos#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Remove$T))
           && LitInt(0) <= pos#0
           && pos#0 < Seq#Length(s#0))
       ==> Seq#Length(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0))
           == Seq#Length(s#0) - 1
         && (forall i#0: int :: 
          { Seq#Index(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0), i#0), Seq#Index(s#0, i#0) } 
          LitInt(0) <= i#0 && i#0 < pos#0
             ==> Seq#Index(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0), i#0)
               == Seq#Index(s#0, i#0))
         && (forall i#1: int :: 
          { Seq#Index(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0), i#1) } 
          pos#0 <= i#1 && i#1 < Seq#Length(s#0) - 1
             ==> Seq#Index(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0), i#1)
               == Seq#Index(s#0, i#1 + 1))
         && $Is(Seq.__default.Remove(Seq._default.Remove$T, $ly, s#0, pos#0), 
          TSeq(Seq._default.Remove$T)));

function Seq.__default.Remove#requires(Ty, LayerType, Seq Box, int) : bool;

// #requires axiom for Seq.__default.Remove
axiom (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
  { Seq.__default.Remove#requires(Seq._default.Remove$T, $ly, s#0, pos#0) } 
  $Is(s#0, TSeq(Seq._default.Remove$T)) && LitInt(0) <= pos#0
     ==> Seq.__default.Remove#requires(Seq._default.Remove$T, $ly, s#0, pos#0)
       == (pos#0 < Seq#Length(s#0)));

// definition axiom for Seq.__default.Remove (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
    { Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), s#0, pos#0) } 
    Seq.__default.Remove#canCall(Seq._default.Remove$T, s#0, pos#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Remove$T))
           && LitInt(0) <= pos#0
           && pos#0 < Seq#Length(s#0))
       ==> Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), s#0, pos#0)
         == Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0 + 1)));

// definition axiom for Seq.__default.Remove for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Remove$T: Ty, $ly: LayerType, s#0: Seq Box, pos#0: int :: 
    {:weight 3} { Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), Lit(s#0), LitInt(pos#0)) } 
    Seq.__default.Remove#canCall(Seq._default.Remove$T, Lit(s#0), LitInt(pos#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Remove$T))
           && LitInt(0) <= pos#0
           && pos#0 < Seq#Length(Lit(s#0)))
       ==> Seq.__default.Remove(Seq._default.Remove$T, $LS($ly), Lit(s#0), LitInt(pos#0))
         == Seq#Append(Seq#Take(Lit(s#0), LitInt(pos#0)), Seq#Drop(Lit(s#0), LitInt(pos#0 + 1))));

procedure {:verboseName "Seq.Remove (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Remove(Seq._default.Remove$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Remove$T)), 
    pos#0: int where LitInt(0) <= pos#0)
   returns (s'#0: Seq Box where $Is(s'#0, TSeq(Seq._default.Remove$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(s'#0) == Seq#Length(s#0) - 1;
  ensures (forall i#2: int :: 
    { Seq#Index(s'#0, i#2), Seq#Index(s#0, i#2) } 
    LitInt(0) <= i#2 && i#2 < pos#0 ==> Seq#Index(s'#0, i#2) == Seq#Index(s#0, i#2));
  ensures (forall i#3: int :: 
    { Seq#Index(s'#0, i#3) } 
    pos#0 <= i#3 && i#3 < Seq#Length(s#0) - 1
       ==> Seq#Index(s'#0, i#3) == Seq#Index(s#0, i#3 + 1));



implementation {:verboseName "Seq.Remove (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Remove(Seq._default.Remove$T: Ty, s#0: Seq Box, pos#0: int) returns (s'#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#4: int;
  var i#5: int;


    // AddWellformednessCheck for function Remove
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume pos#0 < Seq#Length(s#0);
    if (*)
    {
        assume $Is(Seq.__default.Remove(Seq._default.Remove$T, StartFuel_Seq._default.Remove, s#0, pos#0), 
          TSeq(Seq._default.Remove$T));
        assume Seq#Length(s'#0) == Seq#Length(s#0) - 1;
        havoc i#4;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#4)
            {
            }

            assume LitInt(0) <= i#4 && i#4 < pos#0;
            assert 0 <= i#4 && i#4 < Seq#Length(s'#0);
            assert 0 <= i#4 && i#4 < Seq#Length(s#0);
            assume Seq#Index(s'#0, i#4) == Seq#Index(s#0, i#4);
        }
        else
        {
            assume LitInt(0) <= i#4 && i#4 < pos#0 ==> Seq#Index(s'#0, i#4) == Seq#Index(s#0, i#4);
        }

        assume (forall i#2: int :: 
          { Seq#Index(s'#0, i#2), Seq#Index(s#0, i#2) } 
          LitInt(0) <= i#2 && i#2 < pos#0 ==> Seq#Index(s'#0, i#2) == Seq#Index(s#0, i#2));
        havoc i#5;
        assume true;
        if (*)
        {
            if (pos#0 <= i#5)
            {
            }

            assume pos#0 <= i#5 && i#5 < Seq#Length(s#0) - 1;
            assert 0 <= i#5 && i#5 < Seq#Length(s'#0);
            assert 0 <= i#5 + 1 && i#5 + 1 < Seq#Length(s#0);
            assume Seq#Index(s'#0, i#5) == Seq#Index(s#0, i#5 + 1);
        }
        else
        {
            assume pos#0 <= i#5 && i#5 < Seq#Length(s#0) - 1
               ==> Seq#Index(s'#0, i#5) == Seq#Index(s#0, i#5 + 1);
        }

        assume (forall i#3: int :: 
          { Seq#Index(s'#0, i#3) } 
          pos#0 <= i#3 && i#3 < Seq#Length(s#0) - 1
             ==> Seq#Index(s'#0, i#3) == Seq#Index(s#0, i#3 + 1));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        assert 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
        assert 0 <= pos#0 + 1 && pos#0 + 1 <= Seq#Length(s#0);
        assume Seq.__default.Remove(Seq._default.Remove$T, StartFuel_Seq._default.Remove, s#0, pos#0)
           == Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0 + 1));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.Remove(Seq._default.Remove$T, StartFuel_Seq._default.Remove, s#0, pos#0), 
          TSeq(Seq._default.Remove$T));
        assume Seq.__default.Remove(Seq._default.Remove$T, StartFuel_Seq._default.Remove, s#0, pos#0)
           == s'#0;
    }
}



// function declaration for Seq._default.RemoveValue
function Seq.__default.RemoveValue(Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box)
   : Seq Box;

function Seq.__default.RemoveValue#canCall(Seq._default.RemoveValue$T: Ty, s#0: Seq Box, v#0: Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), s#0, v#0) } 
  Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), s#0, v#0)
     == Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0));

// fuel synonym axiom
axiom (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, AsFuelBottom($ly), s#0, v#0) } 
  Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0)
     == Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LZ, s#0, v#0));

// consequence axiom for Seq.__default.RemoveValue
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0) } 
    Seq.__default.RemoveValue#canCall(Seq._default.RemoveValue$T, s#0, v#0)
         || (1 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.RemoveValue$T))
           && $IsBox(v#0, Seq._default.RemoveValue$T))
       ==> (!Seq#Contains(s#0, v#0)
           ==> Seq#Equal(s#0, Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0)))
         && (Seq#Contains(s#0, v#0)
           ==> MultiSet#Card(MultiSet#FromSeq(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0)))
             == MultiSet#Card(MultiSet#FromSeq(s#0)) - 1)
         && (Seq#Contains(s#0, v#0)
           ==> MultiSet#FromSeq(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0))[v#0]
             == MultiSet#FromSeq(s#0)[v#0] - 1)
         && (Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s#0)
           ==> Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, 
              StartFuel_Seq._default.HasNoDuplicates, 
              Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0))
             && Set#Equal(Seq.__default.ToSet(Seq._default.RemoveValue$T, 
                StartFuel_Seq._default.ToSet, 
                Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0)), 
              Set#Difference(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuel_Seq._default.ToSet, s#0), 
                Set#UnionOne(Set#Empty(): Set Box, v#0))))
         && $Is(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $ly, s#0, v#0), 
          TSeq(Seq._default.RemoveValue$T)));

function Seq.__default.RemoveValue#requires(Ty, LayerType, Seq Box, Box) : bool;

// #requires axiom for Seq.__default.RemoveValue
axiom (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
  { Seq.__default.RemoveValue#requires(Seq._default.RemoveValue$T, $ly, s#0, v#0) } 
  $Is(s#0, TSeq(Seq._default.RemoveValue$T))
       && $IsBox(v#0, Seq._default.RemoveValue$T)
     ==> Seq.__default.RemoveValue#requires(Seq._default.RemoveValue$T, $ly, s#0, v#0)
       == true);

const MoreFuel_Seq._default.HasNoDuplicates0: LayerType;

const MoreFuel_Seq._default.HasNoDuplicates1: LayerType;

// definition axiom for Seq.__default.RemoveValue (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), s#0, v#0) } 
    Seq.__default.RemoveValue#canCall(Seq._default.RemoveValue$T, s#0, v#0)
         || (1 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.RemoveValue$T))
           && $IsBox(v#0, Seq._default.RemoveValue$T))
       ==> (Seq#Contains(s#0, v#0)
           ==> Seq.__default.IndexOf#canCall(Seq._default.RemoveValue$T, s#0, v#0))
         && 
        StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates0)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates0))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates0)
           == MoreFuel_Seq._default.HasNoDuplicates0
         && StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates1)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates1))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates1)
           == MoreFuel_Seq._default.HasNoDuplicates1
         && Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), s#0, v#0)
           == (if !Seq#Contains(s#0, v#0)
             then s#0
             else (var i#0 := Seq.__default.IndexOf(Seq._default.RemoveValue$T, StartFuel_Seq._default.IndexOf, s#0, v#0); 
              Seq#Append(Seq#Take(s#0, i#0), Seq#Drop(s#0, i#0 + 1)))));

const MoreFuel_Seq._default.HasNoDuplicates2: LayerType;

const MoreFuel_Seq._default.HasNoDuplicates3: LayerType;

// definition axiom for Seq.__default.RemoveValue for decreasing-related literals (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), Lit(s#0), v#0) } 
    Seq.__default.RemoveValue#canCall(Seq._default.RemoveValue$T, Lit(s#0), v#0)
         || (1 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.RemoveValue$T))
           && $IsBox(v#0, Seq._default.RemoveValue$T))
       ==> (Seq#Contains(s#0, v#0)
           ==> Seq.__default.IndexOf#canCall(Seq._default.RemoveValue$T, Lit(s#0), v#0))
         && 
        StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates2)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates2))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates2)
           == MoreFuel_Seq._default.HasNoDuplicates2
         && StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates3)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates3))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates3)
           == MoreFuel_Seq._default.HasNoDuplicates3
         && Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), Lit(s#0), v#0)
           == (if !Seq#Contains(s#0, v#0)
             then s#0
             else (var i#1 := Seq.__default.IndexOf(Seq._default.RemoveValue$T, StartFuel_Seq._default.IndexOf, Lit(s#0), v#0); 
              Seq#Append(Seq#Take(Lit(s#0), i#1), Seq#Drop(Lit(s#0), i#1 + 1)))));

const MoreFuel_Seq._default.HasNoDuplicates4: LayerType;

const MoreFuel_Seq._default.HasNoDuplicates5: LayerType;

// definition axiom for Seq.__default.RemoveValue for all literals (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.RemoveValue$T: Ty, $ly: LayerType, s#0: Seq Box, v#0: Box :: 
    {:weight 3} { Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), Lit(s#0), Lit(v#0)) } 
    Seq.__default.RemoveValue#canCall(Seq._default.RemoveValue$T, Lit(s#0), Lit(v#0))
         || (1 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.RemoveValue$T))
           && $IsBox(v#0, Seq._default.RemoveValue$T))
       ==> (Seq#Contains(s#0, v#0)
           ==> Seq.__default.IndexOf#canCall(Seq._default.RemoveValue$T, Lit(s#0), Lit(v#0)))
         && 
        StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates4)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates4))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates4)
           == MoreFuel_Seq._default.HasNoDuplicates4
         && StartFuel_Seq._default.HasNoDuplicates
           == $LS(MoreFuel_Seq._default.HasNoDuplicates5)
         && StartFuelAssert_Seq._default.HasNoDuplicates
           == $LS($LS(MoreFuel_Seq._default.HasNoDuplicates5))
         && AsFuelBottom(MoreFuel_Seq._default.HasNoDuplicates5)
           == MoreFuel_Seq._default.HasNoDuplicates5
         && Seq.__default.RemoveValue(Seq._default.RemoveValue$T, $LS($ly), Lit(s#0), Lit(v#0))
           == (if !Seq#Contains(s#0, v#0)
             then s#0
             else (var i#2 := Seq.__default.IndexOf(Seq._default.RemoveValue$T, StartFuel_Seq._default.IndexOf, Lit(s#0), Lit(v#0)); 
              Seq#Append(Seq#Take(Lit(s#0), i#2), Seq#Drop(Lit(s#0), i#2 + 1)))));

procedure {:verboseName "Seq.RemoveValue (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.RemoveValue(Seq._default.RemoveValue$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.RemoveValue$T)), 
    v#0: Box where $IsBox(v#0, Seq._default.RemoveValue$T))
   returns (s'#0: Seq Box where $Is(s'#0, TSeq(Seq._default.RemoveValue$T)));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures !Seq#Contains(s#0, v#0) ==> Seq#Equal(s#0, s'#0);
  ensures Seq#Contains(s#0, v#0)
     ==> MultiSet#Card(MultiSet#FromSeq(s'#0))
       == MultiSet#Card(MultiSet#FromSeq(s#0)) - 1;
  ensures Seq#Contains(s#0, v#0)
     ==> MultiSet#FromSeq(s'#0)[v#0] == MultiSet#FromSeq(s#0)[v#0] - 1;
  ensures Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s#0)
     ==> Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuelAssert_Seq._default.HasNoDuplicates, s'#0);
  ensures Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s#0)
     ==> Set#Equal(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuelAssert_Seq._default.ToSet, s'#0), 
      Set#Difference(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuelAssert_Seq._default.ToSet, s#0), 
        Set#UnionOne(Set#Empty(): Set Box, v#0)));



implementation {:verboseName "Seq.RemoveValue (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.RemoveValue(Seq._default.RemoveValue$T: Ty, s#0: Seq Box, v#0: Box) returns (s'#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var newtype$check#0: int;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var i#Z#0: int;
  var let#0#0#0: int;
  var ##s#4: Seq Box;
  var ##v#0: Box;


    // AddWellformednessCheck for function RemoveValue
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0), 
          TSeq(Seq._default.RemoveValue$T));
        if (*)
        {
            assume !Seq#Contains(s#0, v#0);
            assume Seq#Equal(s#0, s'#0);
        }
        else
        {
            assume !Seq#Contains(s#0, v#0) ==> Seq#Equal(s#0, s'#0);
        }

        if (*)
        {
            assume Seq#Contains(s#0, v#0);
            assume MultiSet#Card(MultiSet#FromSeq(s'#0))
               == MultiSet#Card(MultiSet#FromSeq(s#0)) - 1;
        }
        else
        {
            assume Seq#Contains(s#0, v#0)
               ==> MultiSet#Card(MultiSet#FromSeq(s'#0))
                 == MultiSet#Card(MultiSet#FromSeq(s#0)) - 1;
        }

        if (*)
        {
            assume Seq#Contains(s#0, v#0);
            newtype$check#0 := MultiSet#FromSeq(s#0)[v#0] - 1;
            assert LitInt(0) <= newtype$check#0;
            assume MultiSet#FromSeq(s'#0)[v#0] == MultiSet#FromSeq(s#0)[v#0] - 1;
        }
        else
        {
            assume Seq#Contains(s#0, v#0)
               ==> MultiSet#FromSeq(s'#0)[v#0] == MultiSet#FromSeq(s#0)[v#0] - 1;
        }

        if (*)
        {
            ##s#0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(Seq._default.RemoveValue$T), $Heap);
            assume Seq.__default.HasNoDuplicates#canCall(Seq._default.RemoveValue$T, s#0);
            assume Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s#0);
            ##s#1 := s'#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1, TSeq(Seq._default.RemoveValue$T), $Heap);
            assume Seq.__default.HasNoDuplicates#canCall(Seq._default.RemoveValue$T, s'#0);
            assume Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s'#0);
            ##s#2 := s'#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(Seq._default.RemoveValue$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.RemoveValue$T, s'#0);
            ##s#3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#3, TSeq(Seq._default.RemoveValue$T), $Heap);
            assume Seq.__default.ToSet#canCall(Seq._default.RemoveValue$T, s#0);
            assume Set#Equal(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuel_Seq._default.ToSet, s'#0), 
              Set#Difference(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuel_Seq._default.ToSet, s#0), 
                Set#UnionOne(Set#Empty(): Set Box, v#0)));
        }
        else
        {
            assume Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s#0)
               ==> Seq.__default.HasNoDuplicates(Seq._default.RemoveValue$T, StartFuel_Seq._default.HasNoDuplicates, s'#0)
                 && Set#Equal(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuel_Seq._default.ToSet, s'#0), 
                  Set#Difference(Seq.__default.ToSet(Seq._default.RemoveValue$T, StartFuel_Seq._default.ToSet, s#0), 
                    Set#UnionOne(Set#Empty(): Set Box, v#0)));
        }

        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(308,5)
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(308,27)
        // TrCallStmt: Before ProcessCallStmt
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.reveal__HasNoDuplicates();
        // TrCallStmt: After ProcessCallStmt
        // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(309,5)
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(309,17)
        // TrCallStmt: Before ProcessCallStmt
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.reveal__ToSet();
        // TrCallStmt: After ProcessCallStmt
        if (!Seq#Contains(s#0, v#0))
        {
            assume Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0)
               == s#0;
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0), 
              TSeq(Seq._default.RemoveValue$T));
        }
        else
        {
            havoc i#Z#0;
            assume LitInt(0) <= i#Z#0;
            ##s#4 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#4, TSeq(Seq._default.RemoveValue$T), $Heap);
            ##v#0 := v#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##v#0, Seq._default.RemoveValue$T, $Heap);
            assert {:subsumption 0} Seq#Contains(##s#4, ##v#0);
            assume Seq#Contains(##s#4, ##v#0);
            assume Seq.__default.IndexOf#canCall(Seq._default.RemoveValue$T, s#0, v#0);
            assume let#0#0#0
               == Seq.__default.IndexOf(Seq._default.RemoveValue$T, StartFuel_Seq._default.IndexOf, s#0, v#0);
            assume Seq.__default.IndexOf#canCall(Seq._default.RemoveValue$T, s#0, v#0);
            // CheckWellformedWithResult: any expression
            assume $Is(let#0#0#0, Tclass._System.nat());
            assume i#Z#0 == let#0#0#0;
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(313,7)
            assert {:subsumption 0} 0 <= i#Z#0 && i#Z#0 <= Seq#Length(s#0);
            assert {:subsumption 0} 0 <= i#Z#0 + 1 && i#Z#0 + 1 <= Seq#Length(s#0);
            assume true;
            assert Seq#Equal(s#0, 
              Seq#Append(Seq#Append(Seq#Take(s#0, i#Z#0), Seq#Build(Seq#Empty(): Seq Box, v#0)), 
                Seq#Drop(s#0, i#Z#0 + 1)));
            assert 0 <= i#Z#0 && i#Z#0 <= Seq#Length(s#0);
            assert 0 <= i#Z#0 + 1 && i#Z#0 + 1 <= Seq#Length(s#0);
            assume Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0)
               == Seq#Append(Seq#Take(s#0, i#Z#0), Seq#Drop(s#0, i#Z#0 + 1));
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0), 
              TSeq(Seq._default.RemoveValue$T));
        }

        assume Seq.__default.RemoveValue(Seq._default.RemoveValue$T, StartFuel_Seq._default.RemoveValue, s#0, v#0)
           == s'#0;
    }
}



// function declaration for Seq._default.Insert
function Seq.__default.Insert(Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int)
   : Seq Box;

function Seq.__default.Insert#canCall(Seq._default.Insert$T: Ty, s#0: Seq Box, a#0: Box, pos#0: int) : bool;

// layer synonym axiom
axiom (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
  { Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), s#0, a#0, pos#0) } 
  Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), s#0, a#0, pos#0)
     == Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0));

// fuel synonym axiom
axiom (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
  { Seq.__default.Insert(Seq._default.Insert$T, AsFuelBottom($ly), s#0, a#0, pos#0) } 
  Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0)
     == Seq.__default.Insert(Seq._default.Insert$T, $LZ, s#0, a#0, pos#0));

// consequence axiom for Seq.__default.Insert
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
    { Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0) } 
    Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Insert$T))
           && $IsBox(a#0, Seq._default.Insert$T)
           && LitInt(0) <= pos#0
           && pos#0 <= Seq#Length(s#0))
       ==> Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0))
           == Seq#Length(s#0) + 1
         && (forall i#0: int :: 
          { Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0), i#0), Seq#Index(s#0, i#0) } 
          true
             ==> 
            LitInt(0) <= i#0 && i#0 < pos#0
             ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0), i#0)
               == Seq#Index(s#0, i#0))
         && (forall i#1: int :: 
          { Seq#Index(s#0, i#1) } 
          true
             ==> 
            pos#0 <= i#1 && i#1 < Seq#Length(s#0)
             ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0), i#1 + 1)
               == Seq#Index(s#0, i#1))
         && Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0), pos#0)
           == a#0
         && MultiSet#Equal(MultiSet#FromSeq(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0)), 
          MultiSet#Union(MultiSet#FromSeq(s#0), MultiSet#UnionOne(MultiSet#Empty(): MultiSet Box, a#0)))
         && $Is(Seq.__default.Insert(Seq._default.Insert$T, $ly, s#0, a#0, pos#0), 
          TSeq(Seq._default.Insert$T)));

function Seq.__default.Insert#requires(Ty, LayerType, Seq Box, Box, int) : bool;

// #requires axiom for Seq.__default.Insert
axiom (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
  { Seq.__default.Insert#requires(Seq._default.Insert$T, $ly, s#0, a#0, pos#0) } 
  $Is(s#0, TSeq(Seq._default.Insert$T))
       && $IsBox(a#0, Seq._default.Insert$T)
       && LitInt(0) <= pos#0
     ==> Seq.__default.Insert#requires(Seq._default.Insert$T, $ly, s#0, a#0, pos#0)
       == (pos#0 <= Seq#Length(s#0)));

// definition axiom for Seq.__default.Insert (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
    { Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), s#0, a#0, pos#0) } 
    Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0)
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Insert$T))
           && $IsBox(a#0, Seq._default.Insert$T)
           && LitInt(0) <= pos#0
           && pos#0 <= Seq#Length(s#0))
       ==> Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), s#0, a#0, pos#0)
         == Seq#Append(Seq#Append(Seq#Take(s#0, pos#0), Seq#Build(Seq#Empty(): Seq Box, a#0)), 
          Seq#Drop(s#0, pos#0)));

// definition axiom for Seq.__default.Insert for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
    {:weight 3} { Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), Lit(s#0), a#0, LitInt(pos#0)) } 
    Seq.__default.Insert#canCall(Seq._default.Insert$T, Lit(s#0), a#0, LitInt(pos#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Insert$T))
           && $IsBox(a#0, Seq._default.Insert$T)
           && LitInt(0) <= pos#0
           && LitInt(pos#0) <= Seq#Length(Lit(s#0)))
       ==> Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), Lit(s#0), a#0, LitInt(pos#0))
         == Seq#Append(Seq#Append(Seq#Take(Lit(s#0), LitInt(pos#0)), Seq#Build(Seq#Empty(): Seq Box, a#0)), 
          Seq#Drop(Lit(s#0), LitInt(pos#0))));

// definition axiom for Seq.__default.Insert for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Insert$T: Ty, $ly: LayerType, s#0: Seq Box, a#0: Box, pos#0: int :: 
    {:weight 3} { Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), Lit(s#0), Lit(a#0), LitInt(pos#0)) } 
    Seq.__default.Insert#canCall(Seq._default.Insert$T, Lit(s#0), Lit(a#0), LitInt(pos#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(Seq._default.Insert$T))
           && $IsBox(a#0, Seq._default.Insert$T)
           && LitInt(0) <= pos#0
           && LitInt(pos#0) <= Seq#Length(Lit(s#0)))
       ==> Seq.__default.Insert(Seq._default.Insert$T, $LS($ly), Lit(s#0), Lit(a#0), LitInt(pos#0))
         == Seq#Append(Seq#Append(Seq#Take(Lit(s#0), LitInt(pos#0)), Seq#Build(Seq#Empty(): Seq Box, Lit(a#0))), 
          Seq#Drop(Lit(s#0), LitInt(pos#0))));

procedure {:verboseName "Seq.Insert (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Insert(Seq._default.Insert$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Insert$T)), 
    a#0: Box where $IsBox(a#0, Seq._default.Insert$T), 
    pos#0: int where LitInt(0) <= pos#0);
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0))
     == Seq#Length(s#0) + 1;
  ensures (forall i#2: int :: 
    { Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0), 
        i#2), Seq#Index(s#0, i#2) } 
    true
       ==> 
      LitInt(0) <= i#2 && i#2 < pos#0
       ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0), 
          i#2)
         == Seq#Index(s#0, i#2));
  ensures (forall i#3: int :: 
    { Seq#Index(s#0, i#3) } 
    true
       ==> 
      pos#0 <= i#3 && i#3 < Seq#Length(s#0)
       ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0), 
          i#3 + 1)
         == Seq#Index(s#0, i#3));
  ensures Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0), 
      pos#0)
     == a#0;
  ensures MultiSet#Equal(MultiSet#FromSeq(Seq.__default.Insert(Seq._default.Insert$T, StartFuelAssert_Seq._default.Insert, s#0, a#0, pos#0)), 
    MultiSet#Union(MultiSet#FromSeq(s#0), MultiSet#UnionOne(MultiSet#Empty(): MultiSet Box, a#0)));



implementation {:verboseName "Seq.Insert (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Insert(Seq._default.Insert$T: Ty, s#0: Seq Box, a#0: Box, pos#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##a#0: Box;
  var ##pos#0: int;
  var i#4: int;
  var ##s#1: Seq Box;
  var ##a#1: Box;
  var ##pos#1: int;
  var i#5: int;
  var ##s#2: Seq Box;
  var ##a#2: Box;
  var ##pos#2: int;
  var ##s#3: Seq Box;
  var ##a#3: Box;
  var ##pos#3: int;
  var ##s#4: Seq Box;
  var ##a#4: Box;
  var ##pos#4: int;


    // AddWellformednessCheck for function Insert
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume pos#0 <= Seq#Length(s#0);
    if (*)
    {
        assume $Is(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
          TSeq(Seq._default.Insert$T));
        ##s#0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#0, TSeq(Seq._default.Insert$T), $Heap);
        ##a#0 := a#0;
        // assume allocatedness for argument to function
        assume $IsAllocBox(##a#0, Seq._default.Insert$T, $Heap);
        ##pos#0 := pos#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##pos#0, Tclass._System.nat(), $Heap);
        assert {:subsumption 0} ##pos#0 <= Seq#Length(##s#0);
        assume ##pos#0 <= Seq#Length(##s#0);
        assert 0 <= pos#0 || Seq#Rank(##s#0) < Seq#Rank(s#0) || ##pos#0 == pos#0;
        assert (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || 
          Seq#Rank(##s#0) < Seq#Rank(s#0)
           || (Seq#Rank(##s#0) == Seq#Rank(s#0) && ##pos#0 < pos#0);
        assume (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0);
        assume Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0))
           == Seq#Length(s#0) + 1;
        havoc i#4;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#4)
            {
            }

            assume LitInt(0) <= i#4 && i#4 < pos#0;
            ##s#1 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1, TSeq(Seq._default.Insert$T), $Heap);
            ##a#1 := a#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##a#1, Seq._default.Insert$T, $Heap);
            ##pos#1 := pos#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##pos#1, Tclass._System.nat(), $Heap);
            assert {:subsumption 0} ##pos#1 <= Seq#Length(##s#1);
            assume ##pos#1 <= Seq#Length(##s#1);
            assert 0 <= pos#0 || Seq#Rank(##s#1) < Seq#Rank(s#0) || ##pos#1 == pos#0;
            assert (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
               || 
              Seq#Rank(##s#1) < Seq#Rank(s#0)
               || (Seq#Rank(##s#1) == Seq#Rank(s#0) && ##pos#1 < pos#0);
            assume (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
               || Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0);
            assert 0 <= i#4
               && i#4
                 < Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0));
            assert 0 <= i#4 && i#4 < Seq#Length(s#0);
            assume Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                i#4)
               == Seq#Index(s#0, i#4);
        }
        else
        {
            assume LitInt(0) <= i#4 && i#4 < pos#0
               ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                  i#4)
                 == Seq#Index(s#0, i#4);
        }

        assume (forall i#2: int :: 
          { Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
              i#2), Seq#Index(s#0, i#2) } 
          true
             ==> 
            LitInt(0) <= i#2 && i#2 < pos#0
             ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                i#2)
               == Seq#Index(s#0, i#2));
        havoc i#5;
        assume true;
        if (*)
        {
            if (pos#0 <= i#5)
            {
            }

            assume pos#0 <= i#5 && i#5 < Seq#Length(s#0);
            ##s#2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(Seq._default.Insert$T), $Heap);
            ##a#2 := a#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##a#2, Seq._default.Insert$T, $Heap);
            ##pos#2 := pos#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##pos#2, Tclass._System.nat(), $Heap);
            assert {:subsumption 0} ##pos#2 <= Seq#Length(##s#2);
            assume ##pos#2 <= Seq#Length(##s#2);
            assert 0 <= pos#0 || Seq#Rank(##s#2) < Seq#Rank(s#0) || ##pos#2 == pos#0;
            assert (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
               || 
              Seq#Rank(##s#2) < Seq#Rank(s#0)
               || (Seq#Rank(##s#2) == Seq#Rank(s#0) && ##pos#2 < pos#0);
            assume (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
               || Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0);
            assert 0 <= i#5 + 1
               && i#5 + 1
                 < Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0));
            assert 0 <= i#5 && i#5 < Seq#Length(s#0);
            assume Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                i#5 + 1)
               == Seq#Index(s#0, i#5);
        }
        else
        {
            assume pos#0 <= i#5 && i#5 < Seq#Length(s#0)
               ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                  i#5 + 1)
                 == Seq#Index(s#0, i#5);
        }

        assume (forall i#3: int :: 
          { Seq#Index(s#0, i#3) } 
          true
             ==> 
            pos#0 <= i#3 && i#3 < Seq#Length(s#0)
             ==> Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
                i#3 + 1)
               == Seq#Index(s#0, i#3));
        ##s#3 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#3, TSeq(Seq._default.Insert$T), $Heap);
        ##a#3 := a#0;
        // assume allocatedness for argument to function
        assume $IsAllocBox(##a#3, Seq._default.Insert$T, $Heap);
        ##pos#3 := pos#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##pos#3, Tclass._System.nat(), $Heap);
        assert {:subsumption 0} ##pos#3 <= Seq#Length(##s#3);
        assume ##pos#3 <= Seq#Length(##s#3);
        assert 0 <= pos#0 || Seq#Rank(##s#3) < Seq#Rank(s#0) || ##pos#3 == pos#0;
        assert (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || 
          Seq#Rank(##s#3) < Seq#Rank(s#0)
           || (Seq#Rank(##s#3) == Seq#Rank(s#0) && ##pos#3 < pos#0);
        assume (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0);
        assert 0 <= pos#0
           && pos#0
             < Seq#Length(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0));
        assume Seq#Index(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
            pos#0)
           == a#0;
        ##s#4 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#4, TSeq(Seq._default.Insert$T), $Heap);
        ##a#4 := a#0;
        // assume allocatedness for argument to function
        assume $IsAllocBox(##a#4, Seq._default.Insert$T, $Heap);
        ##pos#4 := pos#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##pos#4, Tclass._System.nat(), $Heap);
        assert {:subsumption 0} ##pos#4 <= Seq#Length(##s#4);
        assume ##pos#4 <= Seq#Length(##s#4);
        assert 0 <= pos#0 || Seq#Rank(##s#4) < Seq#Rank(s#0) || ##pos#4 == pos#0;
        assert (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || 
          Seq#Rank(##s#4) < Seq#Rank(s#0)
           || (Seq#Rank(##s#4) == Seq#Rank(s#0) && ##pos#4 < pos#0);
        assume (s#0 == s#0 && a#0 == a#0 && pos#0 == pos#0)
           || Seq.__default.Insert#canCall(Seq._default.Insert$T, s#0, a#0, pos#0);
        assume MultiSet#Equal(MultiSet#FromSeq(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0)), 
          MultiSet#Union(MultiSet#FromSeq(s#0), MultiSet#UnionOne(MultiSet#Empty(): MultiSet Box, a#0)));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(326,5)
        assert {:subsumption 0} 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
        assert {:subsumption 0} 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
        assume true;
        assert Seq#Equal(s#0, Seq#Append(Seq#Take(s#0, pos#0), Seq#Drop(s#0, pos#0)));
        assert 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
        assert 0 <= pos#0 && pos#0 <= Seq#Length(s#0);
        assume Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0)
           == Seq#Append(Seq#Append(Seq#Take(s#0, pos#0), Seq#Build(Seq#Empty(): Seq Box, a#0)), 
            Seq#Drop(s#0, pos#0));
        assume true;
        // CheckWellformedWithResult: any expression
        assume $Is(Seq.__default.Insert(Seq._default.Insert$T, StartFuel_Seq._default.Insert, s#0, a#0, pos#0), 
          TSeq(Seq._default.Insert$T));
    }
}



// function declaration for Seq._default.Reverse
function Seq.__default.Reverse(Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box) : Seq Box;

function Seq.__default.Reverse#canCall(Seq._default.Reverse$T: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), s#0) } 
  Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), s#0)
     == Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Reverse(Seq._default.Reverse$T, AsFuelBottom($ly), s#0) } 
  Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0)
     == Seq.__default.Reverse(Seq._default.Reverse$T, $LZ, s#0));

// consequence axiom for Seq.__default.Reverse
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0) } 
    Seq.__default.Reverse#canCall(Seq._default.Reverse$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.Reverse$T)))
       ==> Seq#Length(Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0))
           == Seq#Length(s#0)
         && (forall i#0: int :: 
          { Seq#Index(Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0), i#0) } 
            { Seq#Index(s#0, Seq#Length(s#0) - i#0 - 1) } 
          true
             ==> 
            LitInt(0) <= i#0 && i#0 < Seq#Length(s#0)
             ==> Seq#Index(Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0), i#0)
               == Seq#Index(s#0, Seq#Length(s#0) - i#0 - 1))
         && $Is(Seq.__default.Reverse(Seq._default.Reverse$T, $ly, s#0), 
          TSeq(Seq._default.Reverse$T)));

function Seq.__default.Reverse#requires(Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.Reverse
axiom (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Reverse#requires(Seq._default.Reverse$T, $ly, s#0) } 
  $Is(s#0, TSeq(Seq._default.Reverse$T))
     ==> Seq.__default.Reverse#requires(Seq._default.Reverse$T, $ly, s#0) == true);

// definition axiom for Seq.__default.Reverse (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), s#0) } 
    Seq.__default.Reverse#canCall(Seq._default.Reverse$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.Reverse$T)))
       ==> (!Seq#Equal(s#0, Seq#Empty(): Seq Box)
           ==> Seq.__default.Reverse#canCall(Seq._default.Reverse$T, Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0))))
         && Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), s#0)
           == (if Seq#Equal(s#0, Seq#Empty(): Seq Box)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(s#0, Seq#Length(s#0) - 1)), 
              Seq.__default.Reverse(Seq._default.Reverse$T, 
                $ly, 
                Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0))))));

// definition axiom for Seq.__default.Reverse for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Reverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), Lit(s#0)) } 
    Seq.__default.Reverse#canCall(Seq._default.Reverse$T, Lit(s#0))
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(Seq._default.Reverse$T)))
       ==> (!Seq#Equal(s#0, Seq#Empty(): Seq Box)
           ==> Seq.__default.Reverse#canCall(Seq._default.Reverse$T, 
            Seq#Drop(Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), LitInt(0))))
         && Seq.__default.Reverse(Seq._default.Reverse$T, $LS($ly), Lit(s#0))
           == (if Seq#Equal(s#0, Seq#Empty(): Seq Box)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(Lit(s#0), Seq#Length(Lit(s#0)) - 1)), 
              Seq.__default.Reverse(Seq._default.Reverse$T, 
                $LS($ly), 
                Seq#Drop(Seq#Take(Lit(s#0), Seq#Length(Lit(s#0)) - 1), LitInt(0))))));

procedure {:verboseName "Seq.Reverse (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Reverse(Seq._default.Reverse$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Reverse$T)))
   returns (s'#0: Seq Box where $Is(s'#0, TSeq(Seq._default.Reverse$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(s'#0) == Seq#Length(s#0);
  ensures (forall i#1: int :: 
    { Seq#Index(s'#0, i#1) } { Seq#Index(s#0, Seq#Length(s#0) - i#1 - 1) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> Seq#Index(s'#0, i#1) == Seq#Index(s#0, Seq#Length(s#0) - i#1 - 1));



implementation {:verboseName "Seq.Reverse (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Reverse(Seq._default.Reverse$T: Ty, s#0: Seq Box) returns (s'#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#2: int;
  var ##s#0: Seq Box;


    // AddWellformednessCheck for function Reverse
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0), 
          TSeq(Seq._default.Reverse$T));
        assume Seq#Length(s'#0) == Seq#Length(s#0);
        havoc i#2;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#2)
            {
            }

            assume LitInt(0) <= i#2 && i#2 < Seq#Length(s#0);
            assert 0 <= i#2 && i#2 < Seq#Length(s'#0);
            assert 0 <= Seq#Length(s#0) - i#2 - 1 && Seq#Length(s#0) - i#2 - 1 < Seq#Length(s#0);
            assume Seq#Index(s'#0, i#2) == Seq#Index(s#0, Seq#Length(s#0) - i#2 - 1);
        }
        else
        {
            assume LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
               ==> Seq#Index(s'#0, i#2) == Seq#Index(s#0, Seq#Length(s#0) - i#2 - 1);
        }

        assume (forall i#1: int :: 
          { Seq#Index(s'#0, i#1) } { Seq#Index(s#0, Seq#Length(s#0) - i#1 - 1) } 
          true
             ==> 
            LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
             ==> Seq#Index(s'#0, i#1) == Seq#Index(s#0, Seq#Length(s#0) - i#1 - 1));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Equal(s#0, Seq#Empty(): Seq Box))
        {
            assume Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0), 
              TSeq(Seq._default.Reverse$T));
        }
        else
        {
            assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 < Seq#Length(s#0);
            assert 0 <= LitInt(0) && LitInt(0) <= Seq#Length(s#0);
            assert LitInt(0) <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
            ##s#0 := Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(Seq._default.Reverse$T), $Heap);
            assert Seq#Rank(##s#0) < Seq#Rank(s#0);
            assume Seq.__default.Reverse#canCall(Seq._default.Reverse$T, Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0)));
            assume Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0)
               == Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(s#0, Seq#Length(s#0) - 1)), 
                Seq.__default.Reverse(Seq._default.Reverse$T, 
                  StartFuel_Seq._default.Reverse, 
                  Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0))));
            assume Seq.__default.Reverse#canCall(Seq._default.Reverse$T, Seq#Drop(Seq#Take(s#0, Seq#Length(s#0) - 1), LitInt(0)));
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0), 
              TSeq(Seq._default.Reverse$T));
        }

        assume Seq.__default.Reverse(Seq._default.Reverse$T, StartFuel_Seq._default.Reverse, s#0)
           == s'#0;
    }
}



// function declaration for Seq._default.Repeat
function Seq.__default.Repeat(Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int) : Seq Box;

function Seq.__default.Repeat#canCall(Seq._default.Repeat$T: Ty, v#0: Box, length#0: int) : bool;

// layer synonym axiom
axiom (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
  { Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, length#0) } 
  Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, length#0)
     == Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0));

// fuel synonym axiom
axiom (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
  { Seq.__default.Repeat(Seq._default.Repeat$T, AsFuelBottom($ly), v#0, length#0) } 
  Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0)
     == Seq.__default.Repeat(Seq._default.Repeat$T, $LZ, v#0, length#0));

// consequence axiom for Seq.__default.Repeat
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
    { Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0) } 
    Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, length#0)
         || (0 != $FunctionContextHeight
           && 
          $IsBox(v#0, Seq._default.Repeat$T)
           && LitInt(0) <= length#0)
       ==> Seq#Length(Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0))
           == length#0
         && (forall i#0: int :: 
          { Seq#Index(Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0), i#0) } 
          LitInt(0) <= i#0
               && i#0
                 < Seq#Length(Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0))
             ==> Seq#Index(Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0), i#0)
               == v#0)
         && $Is(Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0), 
          TSeq(Seq._default.Repeat$T)));

function Seq.__default.Repeat#requires(Ty, LayerType, Box, int) : bool;

// #requires axiom for Seq.__default.Repeat
axiom (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
  { Seq.__default.Repeat#requires(Seq._default.Repeat$T, $ly, v#0, length#0) } 
  $IsBox(v#0, Seq._default.Repeat$T) && LitInt(0) <= length#0
     ==> Seq.__default.Repeat#requires(Seq._default.Repeat$T, $ly, v#0, length#0) == true);

// definition axiom for Seq.__default.Repeat (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
    { Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, length#0) } 
    Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, length#0)
         || (0 != $FunctionContextHeight
           && 
          $IsBox(v#0, Seq._default.Repeat$T)
           && LitInt(0) <= length#0)
       ==> (length#0 != LitInt(0)
           ==> Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, length#0 - 1))
         && Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, length#0)
           == (if length#0 == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, v#0), 
              Seq.__default.Repeat(Seq._default.Repeat$T, $ly, v#0, length#0 - 1))));

// definition axiom for Seq.__default.Repeat for decreasing-related literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
    {:weight 3} { Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, LitInt(length#0)) } 
    Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, LitInt(length#0))
         || (0 != $FunctionContextHeight
           && 
          $IsBox(v#0, Seq._default.Repeat$T)
           && LitInt(0) <= length#0)
       ==> (LitInt(length#0) != LitInt(0)
           ==> Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, LitInt(length#0 - 1)))
         && Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, LitInt(length#0))
           == (if LitInt(length#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, v#0), 
              Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), v#0, LitInt(length#0 - 1)))));

// definition axiom for Seq.__default.Repeat for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Repeat$T: Ty, $ly: LayerType, v#0: Box, length#0: int :: 
    {:weight 3} { Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), Lit(v#0), LitInt(length#0)) } 
    Seq.__default.Repeat#canCall(Seq._default.Repeat$T, Lit(v#0), LitInt(length#0))
         || (0 != $FunctionContextHeight
           && 
          $IsBox(v#0, Seq._default.Repeat$T)
           && LitInt(0) <= length#0)
       ==> (LitInt(length#0) != LitInt(0)
           ==> Seq.__default.Repeat#canCall(Seq._default.Repeat$T, Lit(v#0), LitInt(length#0 - 1)))
         && Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), Lit(v#0), LitInt(length#0))
           == (if LitInt(length#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Lit(v#0)), 
              Seq.__default.Repeat(Seq._default.Repeat$T, $LS($ly), Lit(v#0), LitInt(length#0 - 1)))));

procedure {:verboseName "Seq.Repeat (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Repeat(Seq._default.Repeat$T: Ty, 
    v#0: Box where $IsBox(v#0, Seq._default.Repeat$T), 
    length#0: int where LitInt(0) <= length#0)
   returns (s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Repeat$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(s#0) == length#0;
  ensures (forall i#1: int :: 
    { Seq#Index(s#0, i#1) } 
    LitInt(0) <= i#1 && i#1 < Seq#Length(s#0) ==> Seq#Index(s#0, i#1) == v#0);



implementation {:verboseName "Seq.Repeat (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Repeat(Seq._default.Repeat$T: Ty, v#0: Box, length#0: int) returns (s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#2: int;
  var ##v#0: Box;
  var ##length#0: int;


    // AddWellformednessCheck for function Repeat
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0), 
          TSeq(Seq._default.Repeat$T));
        assume Seq#Length(s#0) == length#0;
        havoc i#2;
        assume LitInt(0) <= i#2;
        if (*)
        {
            assume i#2 < Seq#Length(s#0);
            assert 0 <= i#2 && i#2 < Seq#Length(s#0);
            assume Seq#Index(s#0, i#2) == v#0;
        }
        else
        {
            assume i#2 < Seq#Length(s#0) ==> Seq#Index(s#0, i#2) == v#0;
        }

        assume (forall i#1: int :: 
          { Seq#Index(s#0, i#1) } 
          LitInt(0) <= i#1 && i#1 < Seq#Length(s#0) ==> Seq#Index(s#0, i#1) == v#0);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (length#0 == LitInt(0))
        {
            assume Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0), 
              TSeq(Seq._default.Repeat$T));
        }
        else
        {
            ##v#0 := v#0;
            // assume allocatedness for argument to function
            assume $IsAllocBox(##v#0, Seq._default.Repeat$T, $Heap);
            assert $Is(length#0 - 1, Tclass._System.nat());
            ##length#0 := length#0 - 1;
            // assume allocatedness for argument to function
            assume $IsAlloc(##length#0, Tclass._System.nat(), $Heap);
            assert 0 <= length#0 || ##length#0 == length#0;
            assert ##length#0 < length#0;
            assume Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, length#0 - 1);
            assume Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0)
               == Seq#Append(Seq#Build(Seq#Empty(): Seq Box, v#0), 
                Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0 - 1));
            assume Seq.__default.Repeat#canCall(Seq._default.Repeat$T, v#0, length#0 - 1);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0), 
              TSeq(Seq._default.Repeat$T));
        }

        assume Seq.__default.Repeat(Seq._default.Repeat$T, StartFuel_Seq._default.Repeat, v#0, length#0)
           == s#0;
    }
}



// function declaration for Seq._default.Unzip
function Seq.__default.Unzip(Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box)
   : DatatypeType;

function Seq.__default.Unzip#canCall(Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), s#0) } 
  Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), s#0)
     == Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, AsFuelBottom($ly), s#0) } 
  Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0)
     == Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LZ, s#0));

// consequence axiom for Seq.__default.Unzip
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0) } 
    Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0)
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B))))
       ==> Seq#Length($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box)
           == Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box)
         && Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box)
           == Seq#Length(s#0)
         && (forall i#0: int :: 
          { Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box, 
              i#0) } 
            { Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box, 
              i#0) } 
          true
             ==> 
            LitInt(0) <= i#0 && i#0 < Seq#Length(s#0)
             ==> _System.Tuple2#Equal(#_System._tuple#2._#Make2(Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box, 
                  i#0), 
                Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0))): Seq Box, 
                  i#0)), 
              $Unbox(Seq#Index(s#0, i#0)): DatatypeType))
         && $Is(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0), 
          Tclass._System.Tuple2(TSeq(Seq._default.Unzip$A), TSeq(Seq._default.Unzip$B))));

function Seq.__default.Unzip#requires(Ty, Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.Unzip
axiom (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Unzip#requires(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0) } 
  $Is(s#0, TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)))
     ==> Seq.__default.Unzip#requires(Seq._default.Unzip$A, Seq._default.Unzip$B, $ly, s#0)
       == true);

// definition axiom for Seq.__default.Unzip (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), s#0) } 
    Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0)
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
             && Seq.__default.Unzip#canCall(Seq._default.Unzip$A, 
              Seq._default.Unzip$B, 
              Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0))
             && 
            Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
             && _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType)
             && 
            Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
             && _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType))
         && Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then #_System._tuple#2._#Make2($Box(Lit(Seq#Empty(): Seq Box)), $Box(Lit(Seq#Empty(): Seq Box)))
             else (var a#0, b#0 := $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, 
                      Seq._default.Unzip$B, 
                      $ly, 
                      Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)))): Seq Box, 
                $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
                      Seq._default.Unzip$B, 
                      $ly, 
                      Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)))): Seq Box; 
              #_System._tuple#2._#Make2($Box(Seq#Append(a#0, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      _System.Tuple2._0($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType)))), 
                $Box(Seq#Append(b#0, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      _System.Tuple2._1($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType))))))));

// definition axiom for Seq.__default.Unzip for all literals (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), Lit(s#0)) } 
    Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, Lit(s#0))
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B))))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))
             && Seq.__default.Unzip#canCall(Seq._default.Unzip$A, 
              Seq._default.Unzip$B, 
              Lit(Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))))
             && 
            Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))
             && _System.Tuple2.___hMake2_q(Lit($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))): DatatypeType))
             && 
            Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))
             && _System.Tuple2.___hMake2_q(Lit($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))): DatatypeType)))
         && Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, $LS($ly), Lit(s#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then #_System._tuple#2._#Make2($Box(Lit(Seq#Empty(): Seq Box)), $Box(Lit(Seq#Empty(): Seq Box)))
             else (var a#1, b#1 := $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, 
                      Seq._default.Unzip$B, 
                      $LS($ly), 
                      Lit(Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0)))))): Seq Box, 
                $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
                      Seq._default.Unzip$B, 
                      $LS($ly), 
                      Lit(Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0)))))): Seq Box; 
              #_System._tuple#2._#Make2($Box(Seq#Append(a#1, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      Lit(_System.Tuple2._0(Lit($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))): DatatypeType)))))), 
                $Box(Seq#Append(b#1, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      Lit(_System.Tuple2._1(Lit($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), Lit(s#0))): DatatypeType))))))))));

procedure {:verboseName "Seq.Unzip (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Unzip(Seq._default.Unzip$A: Ty, 
    Seq._default.Unzip$B: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B))));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, 
            Seq._default.Unzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box)
     == Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
            Seq._default.Unzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box);
  ensures Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
            Seq._default.Unzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box)
     == Seq#Length(s#0);
  ensures (forall i#1: int :: 
    { Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, 
              Seq._default.Unzip$B, 
              StartFuelAssert_Seq._default.Unzip, 
              s#0))): Seq Box, 
        i#1) } 
      { Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
              Seq._default.Unzip$B, 
              StartFuelAssert_Seq._default.Unzip, 
              s#0))): Seq Box, 
        i#1) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> _System.Tuple2#Equal(#_System._tuple#2._#Make2(Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, 
                  Seq._default.Unzip$B, 
                  StartFuelAssert_Seq._default.Unzip, 
                  s#0))): Seq Box, 
            i#1), 
          Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, 
                  Seq._default.Unzip$B, 
                  StartFuelAssert_Seq._default.Unzip, 
                  s#0))): Seq Box, 
            i#1)), 
        $Unbox(Seq#Index(s#0, i#1)): DatatypeType));



implementation {:verboseName "Seq.Unzip (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Unzip(Seq._default.Unzip$A: Ty, Seq._default.Unzip$B: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var i#2: int;
  var ##s#3: Seq Box;
  var ##s#4: Seq Box;
  var a#Z#0: Seq Box;
  var b#Z#0: Seq Box;
  var let#0#0#0: DatatypeType;
  var ##s#5: Seq Box;
  var ##s#6: Seq Box;
  var ##s#7: Seq Box;
  var ##s#8: Seq Box;


    // AddWellformednessCheck for function Unzip
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0), 
          Tclass._System.Tuple2(TSeq(Seq._default.Unzip$A), TSeq(Seq._default.Unzip$B)));
        ##s#0 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
          $Heap);
        assert s#0 == s#0 || Seq#Rank(##s#0) < Seq#Rank(s#0);
        assume s#0 == s#0
           || Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0);
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
        ##s#1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1, 
          TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
          $Heap);
        assert s#0 == s#0 || Seq#Rank(##s#1) < Seq#Rank(s#0);
        assume s#0 == s#0
           || Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0);
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
        if (Seq#Length($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box)
           == Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box))
        {
            ##s#2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert s#0 == s#0 || Seq#Rank(##s#2) < Seq#Rank(s#0);
            assume s#0 == s#0
               || Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0);
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
        }

        assume Seq#Length($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box)
             == Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box)
           && Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box)
             == Seq#Length(s#0);
        havoc i#2;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#2)
            {
            }

            assume LitInt(0) <= i#2 && i#2 < Seq#Length(s#0);
            ##s#3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#3, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert s#0 == s#0 || Seq#Rank(##s#3) < Seq#Rank(s#0);
            assume s#0 == s#0
               || Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0);
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
            assert 0 <= i#2
               && i#2
                 < Seq#Length($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box);
            ##s#4 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#4, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert s#0 == s#0 || Seq#Rank(##s#4) < Seq#Rank(s#0);
            assume s#0 == s#0
               || Seq.__default.Unzip#canCall(Seq._default.Unzip$A, Seq._default.Unzip$B, s#0);
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0));
            assert 0 <= i#2
               && i#2
                 < Seq#Length($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box);
            assert 0 <= i#2 && i#2 < Seq#Length(s#0);
            assume _System.Tuple2#Equal(#_System._tuple#2._#Make2(Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                  i#2), 
                Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                  i#2)), 
              $Unbox(Seq#Index(s#0, i#2)): DatatypeType);
        }
        else
        {
            assume LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
               ==> _System.Tuple2#Equal(#_System._tuple#2._#Make2(Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                    i#2), 
                  Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                    i#2)), 
                $Unbox(Seq#Index(s#0, i#2)): DatatypeType);
        }

        assume (forall i#1: int :: 
          { Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
              i#1) } 
            { Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
              i#1) } 
          true
             ==> 
            LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
             ==> _System.Tuple2#Equal(#_System._tuple#2._#Make2(Seq#Index($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                  i#1), 
                Seq#Index($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0))): Seq Box, 
                  i#1)), 
              $Unbox(Seq#Index(s#0, i#1)): DatatypeType));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(s#0) == LitInt(0))
        {
            assume Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0)
               == Lit(#_System._tuple#2._#Make2($Box(Lit(Seq#Empty(): Seq Box)), $Box(Lit(Seq#Empty(): Seq Box))));
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0), 
              Tclass._System.Tuple2(TSeq(Seq._default.Unzip$A), TSeq(Seq._default.Unzip$B)));
        }
        else
        {
            havoc a#Z#0;
            havoc b#Z#0;
            assume $Is(a#Z#0, TSeq(Seq._default.Unzip$A))
               && $IsAlloc(a#Z#0, TSeq(Seq._default.Unzip$A), $Heap)
               && 
              $Is(b#Z#0, TSeq(Seq._default.Unzip$B))
               && $IsAlloc(b#Z#0, TSeq(Seq._default.Unzip$B), $Heap);
            ##s#5 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#5, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#5) > 0;
            assume Seq#Length(##s#5) > 0;
            assume Seq.__default.DropLast#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0);
            ##s#6 := Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#6, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert Seq#Rank(##s#6) < Seq#Rank(s#0);
            assume Seq.__default.Unzip#canCall(Seq._default.Unzip$A, 
              Seq._default.Unzip$B, 
              Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0));
            assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Unzip$A, 
                Seq._default.Unzip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)));
            assume let#0#0#0
               == Seq.__default.Unzip(Seq._default.Unzip$A, 
                Seq._default.Unzip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0));
            assume Seq.__default.DropLast#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
               && Seq.__default.Unzip#canCall(Seq._default.Unzip$A, 
                Seq._default.Unzip$B, 
                Seq.__default.DropLast(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0));
            // CheckWellformedWithResult: any expression
            assume $Is(let#0#0#0, 
              Tclass._System.Tuple2(TSeq(Seq._default.Unzip$A), TSeq(Seq._default.Unzip$B)));
            assume _System.Tuple2.___hMake2_q(let#0#0#0);
            assume #_System._tuple#2._#Make2($Box(a#Z#0), $Box(b#Z#0)) == let#0#0#0;
            ##s#7 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#7, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#7) > 0;
            assume Seq#Length(##s#7) > 0;
            assume Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0);
            assume _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType);
            assume _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType);
            ##s#8 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#8, 
              TSeq(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#8) > 0;
            assume Seq#Length(##s#8) > 0;
            assume Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0);
            assume _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType);
            assume _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType);
            assume Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0)
               == #_System._tuple#2._#Make2($Box(Seq#Append(a#Z#0, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      _System.Tuple2._0($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType)))), 
                $Box(Seq#Append(b#Z#0, 
                    Seq#Build(Seq#Empty(): Seq Box, 
                      _System.Tuple2._1($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType)))));
            assume Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
               && _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType)
               && 
              Seq.__default.Last#canCall(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)
               && _System.Tuple2.___hMake2_q($Unbox(Seq.__default.Last(Tclass._System.Tuple2(Seq._default.Unzip$A, Seq._default.Unzip$B), s#0)): DatatypeType);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Unzip(Seq._default.Unzip$A, Seq._default.Unzip$B, StartFuel_Seq._default.Unzip, s#0), 
              Tclass._System.Tuple2(TSeq(Seq._default.Unzip$A), TSeq(Seq._default.Unzip$B)));
        }
    }
}



// function declaration for Seq._default.Zip
function Seq.__default.Zip(Seq._default.Zip$A: Ty, 
    Seq._default.Zip$B: Ty, 
    $ly: LayerType, 
    a#0: Seq Box, 
    b#0: Seq Box)
   : Seq Box;

function Seq.__default.Zip#canCall(Seq._default.Zip$A: Ty, Seq._default.Zip$B: Ty, a#0: Seq Box, b#0: Seq Box)
   : bool;

// layer synonym axiom
axiom (forall Seq._default.Zip$A: Ty, 
    Seq._default.Zip$B: Ty, 
    $ly: LayerType, 
    a#0: Seq Box, 
    b#0: Seq Box :: 
  { Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), a#0, b#0) } 
  Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), a#0, b#0)
     == Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0));

// fuel synonym axiom
axiom (forall Seq._default.Zip$A: Ty, 
    Seq._default.Zip$B: Ty, 
    $ly: LayerType, 
    a#0: Seq Box, 
    b#0: Seq Box :: 
  { Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, AsFuelBottom($ly), a#0, b#0) } 
  Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0)
     == Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LZ, a#0, b#0));

// consequence axiom for Seq.__default.Zip
axiom 2 <= $FunctionContextHeight
   ==> (forall Seq._default.Zip$A: Ty, 
      Seq._default.Zip$B: Ty, 
      $ly: LayerType, 
      a#0: Seq Box, 
      b#0: Seq Box :: 
    { Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0) } 
    Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0)
         || (2 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.Zip$A))
           && $Is(b#0, TSeq(Seq._default.Zip$B))
           && Seq#Length(a#0) == Seq#Length(b#0))
       ==> Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0))
           == Seq#Length(a#0)
         && (forall i#0: int :: 
          { $Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0), i#0)): DatatypeType } 
          true
             ==> 
            LitInt(0) <= i#0
               && i#0
                 < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0))
             ==> _System.Tuple2#Equal($Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0), i#0)): DatatypeType, 
              #_System._tuple#2._#Make2(Seq#Index(a#0, i#0), Seq#Index(b#0, i#0))))
         && Seq#Equal($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0)))): Seq Box, 
          a#0)
         && Seq#Equal($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0)))): Seq Box, 
          b#0)
         && $Is(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0), 
          TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B))));

function Seq.__default.Zip#requires(Ty, Ty, LayerType, Seq Box, Seq Box) : bool;

// #requires axiom for Seq.__default.Zip
axiom (forall Seq._default.Zip$A: Ty, 
    Seq._default.Zip$B: Ty, 
    $ly: LayerType, 
    a#0: Seq Box, 
    b#0: Seq Box :: 
  { Seq.__default.Zip#requires(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0) } 
  $Is(a#0, TSeq(Seq._default.Zip$A)) && $Is(b#0, TSeq(Seq._default.Zip$B))
     ==> Seq.__default.Zip#requires(Seq._default.Zip$A, Seq._default.Zip$B, $ly, a#0, b#0)
       == 
      (Seq#Length(a#0)
       == Seq#Length(b#0)));

// definition axiom for Seq.__default.Zip (revealed)
axiom 2 <= $FunctionContextHeight
   ==> (forall Seq._default.Zip$A: Ty, 
      Seq._default.Zip$B: Ty, 
      $ly: LayerType, 
      a#0: Seq Box, 
      b#0: Seq Box :: 
    { Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), a#0, b#0) } 
    Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0)
         || (2 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.Zip$A))
           && $Is(b#0, TSeq(Seq._default.Zip$B))
           && Seq#Length(a#0) == Seq#Length(b#0))
       ==> (Seq#Length(a#0) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(Seq._default.Zip$A, a#0)
             && Seq.__default.DropLast#canCall(Seq._default.Zip$B, b#0)
             && Seq.__default.Zip#canCall(Seq._default.Zip$A, 
              Seq._default.Zip$B, 
              Seq.__default.DropLast(Seq._default.Zip$A, a#0), 
              Seq.__default.DropLast(Seq._default.Zip$B, b#0))
             && 
            Seq.__default.Last#canCall(Seq._default.Zip$A, a#0)
             && Seq.__default.Last#canCall(Seq._default.Zip$B, b#0))
         && Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), a#0, b#0)
           == (if Seq#Length(a#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq.__default.Zip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                $ly, 
                Seq.__default.DropLast(Seq._default.Zip$A, a#0), 
                Seq.__default.DropLast(Seq._default.Zip$B, b#0)), 
              Seq#Build(Seq#Empty(): Seq Box, 
                $Box(#_System._tuple#2._#Make2(Seq.__default.Last(Seq._default.Zip$A, a#0), 
                    Seq.__default.Last(Seq._default.Zip$B, b#0)))))));

// definition axiom for Seq.__default.Zip for all literals (revealed)
axiom 2 <= $FunctionContextHeight
   ==> (forall Seq._default.Zip$A: Ty, 
      Seq._default.Zip$B: Ty, 
      $ly: LayerType, 
      a#0: Seq Box, 
      b#0: Seq Box :: 
    {:weight 3} { Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), Lit(a#0), Lit(b#0)) } 
    Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, Lit(a#0), Lit(b#0))
         || (2 != $FunctionContextHeight
           && 
          $Is(a#0, TSeq(Seq._default.Zip$A))
           && $Is(b#0, TSeq(Seq._default.Zip$B))
           && Seq#Length(Lit(a#0)) == Seq#Length(Lit(b#0)))
       ==> (Seq#Length(Lit(a#0)) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(Seq._default.Zip$A, Lit(a#0))
             && Seq.__default.DropLast#canCall(Seq._default.Zip$B, Lit(b#0))
             && Seq.__default.Zip#canCall(Seq._default.Zip$A, 
              Seq._default.Zip$B, 
              Lit(Seq.__default.DropLast(Seq._default.Zip$A, Lit(a#0))), 
              Lit(Seq.__default.DropLast(Seq._default.Zip$B, Lit(b#0))))
             && 
            Seq.__default.Last#canCall(Seq._default.Zip$A, Lit(a#0))
             && Seq.__default.Last#canCall(Seq._default.Zip$B, Lit(b#0)))
         && Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, $LS($ly), Lit(a#0), Lit(b#0))
           == (if Seq#Length(Lit(a#0)) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq.__default.Zip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                $LS($ly), 
                Lit(Seq.__default.DropLast(Seq._default.Zip$A, Lit(a#0))), 
                Lit(Seq.__default.DropLast(Seq._default.Zip$B, Lit(b#0)))), 
              Seq#Build(Seq#Empty(): Seq Box, 
                $Box(Lit(#_System._tuple#2._#Make2(Lit(Seq.__default.Last(Seq._default.Zip$A, Lit(a#0))), 
                      Lit(Seq.__default.Last(Seq._default.Zip$B, Lit(b#0))))))))));

procedure {:verboseName "Seq.Zip (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Zip(Seq._default.Zip$A: Ty, 
    Seq._default.Zip$B: Ty, 
    a#0: Seq Box where $Is(a#0, TSeq(Seq._default.Zip$A)), 
    b#0: Seq Box where $Is(b#0, TSeq(Seq._default.Zip$B)));
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, 
        Seq._default.Zip$B, 
        StartFuelAssert_Seq._default.Zip, 
        a#0, 
        b#0))
     == Seq#Length(a#0);
  ensures (forall i#1: int :: 
    { $Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuelAssert_Seq._default.Zip, 
            a#0, 
            b#0), 
          i#1)): DatatypeType } 
    true
       ==> 
      LitInt(0) <= i#1
         && i#1
           < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, 
              Seq._default.Zip$B, 
              StartFuelAssert_Seq._default.Zip, 
              a#0, 
              b#0))
       ==> _System.Tuple2#Equal($Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, 
              Seq._default.Zip$B, 
              StartFuelAssert_Seq._default.Zip, 
              a#0, 
              b#0), 
            i#1)): DatatypeType, 
        #_System._tuple#2._#Make2(Seq#Index(a#0, i#1), Seq#Index(b#0, i#1))));
  ensures Seq#Equal($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Zip$A, 
          Seq._default.Zip$B, 
          StartFuelAssert_Seq._default.Unzip, 
          Seq.__default.Zip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuelAssert_Seq._default.Zip, 
            a#0, 
            b#0)))): Seq Box, 
    a#0);
  ensures Seq#Equal($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Zip$A, 
          Seq._default.Zip$B, 
          StartFuelAssert_Seq._default.Unzip, 
          Seq.__default.Zip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuelAssert_Seq._default.Zip, 
            a#0, 
            b#0)))): Seq Box, 
    b#0);



implementation {:verboseName "Seq.Zip (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Zip(Seq._default.Zip$A: Ty, Seq._default.Zip$B: Ty, a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##a#0: Seq Box;
  var ##b#0: Seq Box;
  var i#2: int;
  var ##a#1: Seq Box;
  var ##b#1: Seq Box;
  var ##a#2: Seq Box;
  var ##b#2: Seq Box;
  var ##a#3: Seq Box;
  var ##b#3: Seq Box;
  var ##s#0: Seq Box;
  var ##a#4: Seq Box;
  var ##b#4: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var ##a#5: Seq Box;
  var ##b#5: Seq Box;
  var ##s#4: Seq Box;
  var ##s#5: Seq Box;


    // AddWellformednessCheck for function Zip
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume Seq#Length(a#0) == Seq#Length(b#0);
    if (*)
    {
        assume $Is(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
          TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B)));
        ##a#0 := a#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##a#0, TSeq(Seq._default.Zip$A), $Heap);
        ##b#0 := b#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##b#0, TSeq(Seq._default.Zip$B), $Heap);
        assert {:subsumption 0} Seq#Length(##a#0) == Seq#Length(##b#0);
        assume Seq#Length(##a#0) == Seq#Length(##b#0);
        assert (a#0 == a#0 && b#0 == b#0)
           || 
          Seq#Rank(##a#0) < Seq#Rank(a#0)
           || (Seq#Rank(##a#0) == Seq#Rank(a#0) && Seq#Rank(##b#0) < Seq#Rank(b#0));
        assume (a#0 == a#0 && b#0 == b#0)
           || Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0);
        assume Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0))
           == Seq#Length(a#0);
        havoc i#2;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#2)
            {
                ##a#1 := a#0;
                // assume allocatedness for argument to function
                assume $IsAlloc(##a#1, TSeq(Seq._default.Zip$A), $Heap);
                ##b#1 := b#0;
                // assume allocatedness for argument to function
                assume $IsAlloc(##b#1, TSeq(Seq._default.Zip$B), $Heap);
                assert {:subsumption 0} Seq#Length(##a#1) == Seq#Length(##b#1);
                assume Seq#Length(##a#1) == Seq#Length(##b#1);
                assert (a#0 == a#0 && b#0 == b#0)
                   || 
                  Seq#Rank(##a#1) < Seq#Rank(a#0)
                   || (Seq#Rank(##a#1) == Seq#Rank(a#0) && Seq#Rank(##b#1) < Seq#Rank(b#0));
                assume (a#0 == a#0 && b#0 == b#0)
                   || Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0);
            }

            assume LitInt(0) <= i#2
               && i#2
                 < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0));
            ##a#2 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##a#2, TSeq(Seq._default.Zip$A), $Heap);
            ##b#2 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##b#2, TSeq(Seq._default.Zip$B), $Heap);
            assert {:subsumption 0} Seq#Length(##a#2) == Seq#Length(##b#2);
            assume Seq#Length(##a#2) == Seq#Length(##b#2);
            assert (a#0 == a#0 && b#0 == b#0)
               || 
              Seq#Rank(##a#2) < Seq#Rank(a#0)
               || (Seq#Rank(##a#2) == Seq#Rank(a#0) && Seq#Rank(##b#2) < Seq#Rank(b#0));
            assume (a#0 == a#0 && b#0 == b#0)
               || Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0);
            assert 0 <= i#2
               && i#2
                 < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0));
            assert 0 <= i#2 && i#2 < Seq#Length(a#0);
            assert 0 <= i#2 && i#2 < Seq#Length(b#0);
            assume _System.Tuple2#Equal($Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
                  i#2)): DatatypeType, 
              #_System._tuple#2._#Make2(Seq#Index(a#0, i#2), Seq#Index(b#0, i#2)));
        }
        else
        {
            assume LitInt(0) <= i#2
                 && i#2
                   < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0))
               ==> _System.Tuple2#Equal($Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
                    i#2)): DatatypeType, 
                #_System._tuple#2._#Make2(Seq#Index(a#0, i#2), Seq#Index(b#0, i#2)));
        }

        assume (forall i#1: int :: 
          { $Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
                i#1)): DatatypeType } 
          true
             ==> 
            LitInt(0) <= i#1
               && i#1
                 < Seq#Length(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0))
             ==> _System.Tuple2#Equal($Unbox(Seq#Index(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
                  i#1)): DatatypeType, 
              #_System._tuple#2._#Make2(Seq#Index(a#0, i#1), Seq#Index(b#0, i#1))));
        ##a#3 := a#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##a#3, TSeq(Seq._default.Zip$A), $Heap);
        ##b#3 := b#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##b#3, TSeq(Seq._default.Zip$B), $Heap);
        assert {:subsumption 0} Seq#Length(##a#3) == Seq#Length(##b#3);
        assume Seq#Length(##a#3) == Seq#Length(##b#3);
        assert (a#0 == a#0 && b#0 == b#0)
           || 
          Seq#Rank(##a#3) < Seq#Rank(a#0)
           || (Seq#Rank(##a#3) == Seq#Rank(a#0) && Seq#Rank(##b#3) < Seq#Rank(b#0));
        assume (a#0 == a#0 && b#0 == b#0)
           || Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0);
        ##s#0 := Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B)), 
          $Heap);
        assume Seq.__default.Unzip#canCall(Seq._default.Zip$A, 
          Seq._default.Zip$B, 
          Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuel_Seq._default.Unzip, 
            Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuel_Seq._default.Unzip, 
            Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)));
        assume Seq#Equal($Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)))): Seq Box, 
          a#0);
        ##a#4 := a#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##a#4, TSeq(Seq._default.Zip$A), $Heap);
        ##b#4 := b#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##b#4, TSeq(Seq._default.Zip$B), $Heap);
        assert {:subsumption 0} Seq#Length(##a#4) == Seq#Length(##b#4);
        assume Seq#Length(##a#4) == Seq#Length(##b#4);
        assert (a#0 == a#0 && b#0 == b#0)
           || 
          Seq#Rank(##a#4) < Seq#Rank(a#0)
           || (Seq#Rank(##a#4) == Seq#Rank(a#0) && Seq#Rank(##b#4) < Seq#Rank(b#0));
        assume (a#0 == a#0 && b#0 == b#0)
           || Seq.__default.Zip#canCall(Seq._default.Zip$A, Seq._default.Zip$B, a#0, b#0);
        ##s#1 := Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1, 
          TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B)), 
          $Heap);
        assume Seq.__default.Unzip#canCall(Seq._default.Zip$A, 
          Seq._default.Zip$B, 
          Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuel_Seq._default.Unzip, 
            Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)));
        assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.Zip$A, 
            Seq._default.Zip$B, 
            StartFuel_Seq._default.Unzip, 
            Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)));
        assume Seq#Equal($Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                StartFuel_Seq._default.Unzip, 
                Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)))): Seq Box, 
          b#0);
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(a#0) == LitInt(0))
        {
            assume Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
              TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B)));
        }
        else
        {
            ##s#2 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(Seq._default.Zip$A), $Heap);
            assert {:subsumption 0} Seq#Length(##s#2) > 0;
            assume Seq#Length(##s#2) > 0;
            assume Seq.__default.DropLast#canCall(Seq._default.Zip$A, a#0);
            ##s#3 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#3, TSeq(Seq._default.Zip$B), $Heap);
            assert {:subsumption 0} Seq#Length(##s#3) > 0;
            assume Seq#Length(##s#3) > 0;
            assume Seq.__default.DropLast#canCall(Seq._default.Zip$B, b#0);
            ##a#5 := Seq.__default.DropLast(Seq._default.Zip$A, a#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##a#5, TSeq(Seq._default.Zip$A), $Heap);
            ##b#5 := Seq.__default.DropLast(Seq._default.Zip$B, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##b#5, TSeq(Seq._default.Zip$B), $Heap);
            assert {:subsumption 0} Seq#Length(##a#5) == Seq#Length(##b#5);
            assume Seq#Length(##a#5) == Seq#Length(##b#5);
            assert Seq#Rank(##a#5) < Seq#Rank(a#0)
               || (Seq#Rank(##a#5) == Seq#Rank(a#0) && Seq#Rank(##b#5) < Seq#Rank(b#0));
            assume Seq.__default.Zip#canCall(Seq._default.Zip$A, 
              Seq._default.Zip$B, 
              Seq.__default.DropLast(Seq._default.Zip$A, a#0), 
              Seq.__default.DropLast(Seq._default.Zip$B, b#0));
            ##s#4 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#4, TSeq(Seq._default.Zip$A), $Heap);
            assert {:subsumption 0} Seq#Length(##s#4) > 0;
            assume Seq#Length(##s#4) > 0;
            assume Seq.__default.Last#canCall(Seq._default.Zip$A, a#0);
            ##s#5 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#5, TSeq(Seq._default.Zip$B), $Heap);
            assert {:subsumption 0} Seq#Length(##s#5) > 0;
            assume Seq#Length(##s#5) > 0;
            assume Seq.__default.Last#canCall(Seq._default.Zip$B, b#0);
            assume Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0)
               == Seq#Append(Seq.__default.Zip(Seq._default.Zip$A, 
                  Seq._default.Zip$B, 
                  StartFuel_Seq._default.Zip, 
                  Seq.__default.DropLast(Seq._default.Zip$A, a#0), 
                  Seq.__default.DropLast(Seq._default.Zip$B, b#0)), 
                Seq#Build(Seq#Empty(): Seq Box, 
                  $Box(#_System._tuple#2._#Make2(Seq.__default.Last(Seq._default.Zip$A, a#0), 
                      Seq.__default.Last(Seq._default.Zip$B, b#0)))));
            assume Seq.__default.DropLast#canCall(Seq._default.Zip$A, a#0)
               && Seq.__default.DropLast#canCall(Seq._default.Zip$B, b#0)
               && Seq.__default.Zip#canCall(Seq._default.Zip$A, 
                Seq._default.Zip$B, 
                Seq.__default.DropLast(Seq._default.Zip$A, a#0), 
                Seq.__default.DropLast(Seq._default.Zip$B, b#0))
               && 
              Seq.__default.Last#canCall(Seq._default.Zip$A, a#0)
               && Seq.__default.Last#canCall(Seq._default.Zip$B, b#0);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Zip(Seq._default.Zip$A, Seq._default.Zip$B, StartFuel_Seq._default.Zip, a#0, b#0), 
              TSeq(Tclass._System.Tuple2(Seq._default.Zip$A, Seq._default.Zip$B)));
        }
    }
}



procedure {:verboseName "Seq.LemmaZipOfUnzip (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaZipOfUnzip(Seq._default.LemmaZipOfUnzip$A: Ty, 
    Seq._default.LemmaZipOfUnzip$B: Ty, 
    s#0: Seq Box
       where $Is(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)))
         && $IsAlloc(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)), 
          $Heap));
  free requires 3 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaZipOfUnzip (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaZipOfUnzip(Seq._default.LemmaZipOfUnzip$A: Ty, 
    Seq._default.LemmaZipOfUnzip$B: Ty, 
    s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##a#0: Seq Box;
  var ##b#0: Seq Box;

    // AddMethodImpl: LemmaZipOfUnzip, CheckWellFormed$$Seq.__default.LemmaZipOfUnzip
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, 
      TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)), 
      $Heap);
    assume Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0);
    assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0));
    assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0));
    ##s#1 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, 
      TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)), 
      $Heap);
    assume Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0);
    assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0));
    assume _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0));
    ##a#0 := $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
          Seq._default.LemmaZipOfUnzip$B, 
          StartFuel_Seq._default.Unzip, 
          s#0))): Seq Box;
    // assume allocatedness for argument to function
    assume $IsAlloc(##a#0, TSeq(Seq._default.LemmaZipOfUnzip$A), $Heap);
    ##b#0 := $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
          Seq._default.LemmaZipOfUnzip$B, 
          StartFuel_Seq._default.Unzip, 
          s#0))): Seq Box;
    // assume allocatedness for argument to function
    assume $IsAlloc(##b#0, TSeq(Seq._default.LemmaZipOfUnzip$B), $Heap);
    assert {:subsumption 0} Seq#Length(##a#0) == Seq#Length(##b#0);
    assume Seq#Length(##a#0) == Seq#Length(##b#0);
    assume Seq.__default.Zip#canCall(Seq._default.LemmaZipOfUnzip$A, 
      Seq._default.LemmaZipOfUnzip$B, 
      $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box, 
      $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box);
    assume Seq#Equal(Seq.__default.Zip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Zip, 
        $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
              Seq._default.LemmaZipOfUnzip$B, 
              StartFuel_Seq._default.Unzip, 
              s#0))): Seq Box, 
        $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
              Seq._default.LemmaZipOfUnzip$B, 
              StartFuel_Seq._default.Unzip, 
              s#0))): Seq Box), 
      s#0);
}



procedure {:verboseName "Seq.LemmaZipOfUnzip (call)"} {:_induction s#0} Call$$Seq.__default.LemmaZipOfUnzip(Seq._default.LemmaZipOfUnzip$A: Ty, 
    Seq._default.LemmaZipOfUnzip$B: Ty, 
    s#0: Seq Box
       where $Is(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)))
         && $IsAlloc(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)), 
          $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0)
     && _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0))
     && 
    Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0)
     && _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0))
     && Seq.__default.Zip#canCall(Seq._default.LemmaZipOfUnzip$A, 
      Seq._default.LemmaZipOfUnzip$B, 
      $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box, 
      $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box);
  ensures Seq#Equal(Seq.__default.Zip(Seq._default.LemmaZipOfUnzip$A, 
      Seq._default.LemmaZipOfUnzip$B, 
      StartFuelAssert_Seq._default.Zip, 
      $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box, 
      $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box), 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaZipOfUnzip (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaZipOfUnzip(Seq._default.LemmaZipOfUnzip$A: Ty, 
    Seq._default.LemmaZipOfUnzip$B: Ty, 
    s#0: Seq Box
       where $Is(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)))
         && $IsAlloc(s#0, 
          TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)), 
          $Heap))
   returns ($_reverifyPost: bool);
  free requires 3 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0)
     && _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0))
     && 
    Seq.__default.Unzip#canCall(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B, s#0)
     && _System.Tuple2.___hMake2_q(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
        Seq._default.LemmaZipOfUnzip$B, 
        StartFuel_Seq._default.Unzip, 
        s#0))
     && Seq.__default.Zip#canCall(Seq._default.LemmaZipOfUnzip$A, 
      Seq._default.LemmaZipOfUnzip$B, 
      $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box, 
      $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Unzip, 
            s#0))): Seq Box);
  ensures Seq#Equal(Seq.__default.Zip(Seq._default.LemmaZipOfUnzip$A, 
      Seq._default.LemmaZipOfUnzip$B, 
      StartFuelAssert_Seq._default.Zip, 
      $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box, 
      $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuelAssert_Seq._default.Unzip, 
            s#0))): Seq Box), 
    s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaZipOfUnzip (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaZipOfUnzip(Seq._default.LemmaZipOfUnzip$A: Ty, 
    Seq._default.LemmaZipOfUnzip$B: Ty, 
    s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;

    // AddMethodImpl: LemmaZipOfUnzip, Impl$$Seq.__default.LemmaZipOfUnzip
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, 
            TSeq(Tclass._System.Tuple2(Seq._default.LemmaZipOfUnzip$A, Seq._default.LemmaZipOfUnzip$B)))
           && Lit(true)
           && Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
         ==> Seq#Equal(Seq.__default.Zip(Seq._default.LemmaZipOfUnzip$A, 
            Seq._default.LemmaZipOfUnzip$B, 
            StartFuel_Seq._default.Zip, 
            $Unbox(_System.Tuple2._0(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
                  Seq._default.LemmaZipOfUnzip$B, 
                  StartFuel_Seq._default.Unzip, 
                  $ih#s0#0))): Seq Box, 
            $Unbox(_System.Tuple2._1(Seq.__default.Unzip(Seq._default.LemmaZipOfUnzip$A, 
                  Seq._default.LemmaZipOfUnzip$B, 
                  StartFuel_Seq._default.Unzip, 
                  $ih#s0#0))): Seq Box), 
          $ih#s0#0));
    $_reverifyPost := false;
}



// function declaration for Seq._default.Max
function Seq.__default.Max($ly: LayerType, s#0: Seq Box) : int;

function Seq.__default.Max#canCall(s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Max($LS($ly), s#0) } 
  Seq.__default.Max($LS($ly), s#0) == Seq.__default.Max($ly, s#0));

// fuel synonym axiom
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Max(AsFuelBottom($ly), s#0) } 
  Seq.__default.Max($ly, s#0) == Seq.__default.Max($LZ, s#0));

// consequence axiom for Seq.__default.Max
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Max($ly, s#0) } 
    Seq.__default.Max#canCall(s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TInt)) && 0 < Seq#Length(s#0))
       ==> (forall k#0: int :: 
          { Seq#Contains(s#0, $Box(k#0)) } 
          true ==> Seq#Contains(s#0, $Box(k#0)) ==> Seq.__default.Max($ly, s#0) >= k#0)
         && Seq#Contains(s#0, $Box(Seq.__default.Max($ly, s#0))));

function Seq.__default.Max#requires(LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.Max
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Max#requires($ly, s#0) } 
  $Is(s#0, TSeq(TInt))
     ==> Seq.__default.Max#requires($ly, s#0) == (0 < Seq#Length(s#0)));

// definition axiom for Seq.__default.Max (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Max($LS($ly), s#0) } 
    Seq.__default.Max#canCall(s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TInt)) && 0 < Seq#Length(s#0))
       ==> (Seq#Length(s#0) != LitInt(1)
           ==> Seq.__default.Max#canCall(Seq#Drop(s#0, LitInt(1)))
             && Math.__default.Max#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Max($ly, Seq#Drop(s#0, LitInt(1)))))
         && Seq.__default.Max($LS($ly), s#0)
           == (if Seq#Length(s#0) == LitInt(1)
             then $Unbox(Seq#Index(s#0, LitInt(0))): int
             else Math.__default.Max($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Max($ly, Seq#Drop(s#0, LitInt(1))))));

// definition axiom for Seq.__default.Max for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Max($LS($ly), Lit(s#0)) } 
    Seq.__default.Max#canCall(Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(TInt))
           && 0 < Seq#Length(Lit(s#0)))
       ==> (Seq#Length(Lit(s#0)) != LitInt(1)
           ==> Seq.__default.Max#canCall(Lit(Seq#Drop(Lit(s#0), LitInt(1))))
             && Math.__default.Max#canCall($Unbox(Seq#Index(Lit(s#0), LitInt(0))): int, 
              Seq.__default.Max($LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1))))))
         && Seq.__default.Max($LS($ly), Lit(s#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(1)
             then $Unbox(Seq#Index(Lit(s#0), LitInt(0))): int
             else Math.__default.Max($Unbox(Seq#Index(Lit(s#0), LitInt(0))): int, 
              Seq.__default.Max($LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1)))))));

procedure {:verboseName "Seq.Max (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Max(s#0: Seq Box where $Is(s#0, TSeq(TInt)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures (forall k#1: int :: 
    { Seq#Contains(s#0, $Box(k#1)) } 
    true
       ==> 
      Seq#Contains(s#0, $Box(k#1))
       ==> Seq.__default.Max(StartFuelAssert_Seq._default.Max, s#0) >= k#1);
  ensures Seq#Contains(s#0, $Box(Seq.__default.Max(StartFuelAssert_Seq._default.Max, s#0)));



implementation {:verboseName "Seq.Max (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Max(s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var k#2: int;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##a#0: int;
  var ##b#0: int;


    // AddWellformednessCheck for function Max
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume 0 < Seq#Length(s#0);
    if (*)
    {
        havoc k#2;
        assume true;
        if (*)
        {
            assume Seq#Contains(s#0, $Box(k#2));
            ##s#0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
            assert {:subsumption 0} 0 < Seq#Length(##s#0);
            assume 0 < Seq#Length(##s#0);
            assert s#0 == s#0 || Seq#Rank(##s#0) < Seq#Rank(s#0);
            assume s#0 == s#0 || Seq.__default.Max#canCall(s#0);
            assume Seq.__default.Max(StartFuel_Seq._default.Max, s#0) >= k#2;
        }
        else
        {
            assume Seq#Contains(s#0, $Box(k#2))
               ==> Seq.__default.Max(StartFuel_Seq._default.Max, s#0) >= k#2;
        }

        assume (forall k#1: int :: 
          { Seq#Contains(s#0, $Box(k#1)) } 
          true
             ==> 
            Seq#Contains(s#0, $Box(k#1))
             ==> Seq.__default.Max(StartFuel_Seq._default.Max, s#0) >= k#1);
        ##s#1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
        assert {:subsumption 0} 0 < Seq#Length(##s#1);
        assume 0 < Seq#Length(##s#1);
        assert s#0 == s#0 || Seq#Rank(##s#1) < Seq#Rank(s#0);
        assume s#0 == s#0 || Seq.__default.Max#canCall(s#0);
        assume Seq#Contains(s#0, $Box(Seq.__default.Max(StartFuel_Seq._default.Max, s#0)));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(390,5)
        assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
        assume true;
        assert Seq#Equal(s#0, 
          Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(s#0, LitInt(0))), 
            Seq#Drop(s#0, LitInt(1))));
        if (Seq#Length(s#0) == LitInt(1))
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assume Seq.__default.Max(StartFuel_Seq._default.Max, s#0)
               == $Unbox(Seq#Index(s#0, LitInt(0))): int;
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Max(StartFuel_Seq._default.Max, s#0), TInt);
        }
        else
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
            ##s#2 := Seq#Drop(s#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
            assert {:subsumption 0} 0 < Seq#Length(##s#2);
            assume 0 < Seq#Length(##s#2);
            assert Seq#Rank(##s#2) < Seq#Rank(s#0);
            assume Seq.__default.Max#canCall(Seq#Drop(s#0, LitInt(1)));
            ##a#0 := $Unbox(Seq#Index(s#0, LitInt(0))): int;
            // assume allocatedness for argument to function
            assume $IsAlloc(##a#0, TInt, $Heap);
            ##b#0 := Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(s#0, LitInt(1)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##b#0, TInt, $Heap);
            assume Math.__default.Max#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Max(StartFuel_Seq._default.Max, s#0)
               == Math.__default.Max($Unbox(Seq#Index(s#0, LitInt(0))): int, 
                Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Max#canCall(Seq#Drop(s#0, LitInt(1)))
               && Math.__default.Max#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
                Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(s#0, LitInt(1))));
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Max(StartFuel_Seq._default.Max, s#0), TInt);
        }
    }
}



procedure {:verboseName "Seq.LemmaMaxOfConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMaxOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaMaxOfConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMaxOfConcat(a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var i#0: int;
  var ##s#4: Seq Box;

    // AddMethodImpl: LemmaMaxOfConcat, CheckWellFormed$$Seq.__default.LemmaMaxOfConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    assume 0 < Seq#Length(a#0);
    assume 0 < Seq#Length(b#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#0);
    assume 0 < Seq#Length(##s#0);
    assume Seq.__default.Max#canCall(Seq#Append(a#0, b#0));
    ##s#1 := a#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#1);
    assume 0 < Seq#Length(##s#1);
    assume Seq.__default.Max#canCall(a#0);
    assume Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0))
       >= Seq.__default.Max(StartFuel_Seq._default.Max, a#0);
    ##s#2 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#2);
    assume 0 < Seq#Length(##s#2);
    assume Seq.__default.Max#canCall(Seq#Append(a#0, b#0));
    ##s#3 := b#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#3, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#3);
    assume 0 < Seq#Length(##s#3);
    assume Seq.__default.Max#canCall(b#0);
    assume Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0))
       >= Seq.__default.Max(StartFuel_Seq._default.Max, b#0);
    havoc i#0;
    assume true;
    if (*)
    {
        assume Seq#Contains(Seq#Append(a#0, b#0), $Box(i#0));
        ##s#4 := Seq#Append(a#0, b#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#4, TSeq(TInt), $Heap);
        assert {:subsumption 0} 0 < Seq#Length(##s#4);
        assume 0 < Seq#Length(##s#4);
        assume Seq.__default.Max#canCall(Seq#Append(a#0, b#0));
        assume Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)) >= i#0;
    }
    else
    {
        assume Seq#Contains(Seq#Append(a#0, b#0), $Box(i#0))
           ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)) >= i#0;
    }

    assume (forall i#1: int :: 
      { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
            $Box(Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)))), 
          $Box(i#1)) } 
      true
         ==> 
        Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
         ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)) >= i#1);
}



procedure {:verboseName "Seq.LemmaMaxOfConcat (call)"} {:_induction a#0, b#0} Call$$Seq.__default.LemmaMaxOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap));
  // user-defined preconditions
  requires 0 < Seq#Length(a#0);
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Max#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Max#canCall(a#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0))
     >= Seq.__default.Max(StartFuelAssert_Seq._default.Max, a#0);
  free ensures Seq.__default.Max#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Max#canCall(b#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0))
     >= Seq.__default.Max(StartFuelAssert_Seq._default.Max, b#0);
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
          $Box(Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)))), 
        $Box(i#1)) } 
    Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Max#canCall(Seq#Append(a#0, b#0)));
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
          $Box(Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)))), 
        $Box(i#1)) } 
    true
       ==> 
      Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)) >= i#1);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaMaxOfConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaMaxOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires 0 < Seq#Length(a#0);
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Max#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Max#canCall(a#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0))
     >= Seq.__default.Max(StartFuelAssert_Seq._default.Max, a#0);
  free ensures Seq.__default.Max#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Max#canCall(b#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0))
     >= Seq.__default.Max(StartFuelAssert_Seq._default.Max, b#0);
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
          $Box(Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append(a#0, b#0)))), 
        $Box(i#1)) } 
    Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Max#canCall(Seq#Append(a#0, b#0)));
  ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
          $Box(Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0)))), 
        $Box(i#1)) } 
    true
       ==> 
      Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Append(a#0, b#0)) >= i#1);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaMaxOfConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaMaxOfConcat(a#0: Seq Box, b#0: Seq Box) returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var a##1_0: Seq Box;
  var b##1_0: Seq Box;

    // AddMethodImpl: LemmaMaxOfConcat, Impl$$Seq.__default.LemmaMaxOfConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#a0#0: Seq Box, $ih#b0#0: Seq Box :: 
      $Is($ih#a0#0, TSeq(TInt))
           && $Is($ih#b0#0, TSeq(TInt))
           && 
          0 < Seq#Length($ih#a0#0)
           && 0 < Seq#Length($ih#b0#0)
           && (Seq#Rank($ih#a0#0) < Seq#Rank(a#0)
             || (Seq#Rank($ih#a0#0) == Seq#Rank(a#0) && Seq#Rank($ih#b0#0) < Seq#Rank(b#0)))
         ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append($ih#a0#0, $ih#b0#0))
             >= Seq.__default.Max(StartFuel_Seq._default.Max, $ih#a0#0)
           && Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append($ih#a0#0, $ih#b0#0))
             >= Seq.__default.Max(StartFuel_Seq._default.Max, $ih#b0#0)
           && (forall i#2: int :: 
            { Seq#Contains(Seq#Build(Seq#Empty(): Seq Box, 
                  $Box(Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append($ih#a0#0, $ih#b0#0)))), 
                $Box(i#2)) } 
            true
               ==> 
              Seq#Contains(Seq#Append($ih#a0#0, $ih#b0#0), $Box(i#2))
               ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Append($ih#a0#0, $ih#b0#0))
                 >= i#2));
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(402,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(402,15)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__Max();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(403,5)
    assume true;
    if (Seq#Length(a#0) == LitInt(1))
    {
    }
    else
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(405,7)
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(Seq#Append(a#0, b#0));
        assume true;
        assert Seq#Equal(Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0), 
          Seq#Drop(Seq#Append(a#0, b#0), LitInt(1)));
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(406,23)
        // TrCallStmt: Before ProcessCallStmt
        assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
        assume true;
        // ProcessCallStmt: CheckSubrange
        a##1_0 := Seq#Drop(a#0, LitInt(1));
        assume true;
        // ProcessCallStmt: CheckSubrange
        b##1_0 := b#0;
        assert Seq#Rank(a##1_0) < Seq#Rank(a#0)
           || (Seq#Rank(a##1_0) == Seq#Rank(a#0) && Seq#Rank(b##1_0) < Seq#Rank(b#0));
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaMaxOfConcat(a##1_0, b##1_0);
        // TrCallStmt: After ProcessCallStmt
    }
}



// function declaration for Seq._default.Min
function Seq.__default.Min($ly: LayerType, s#0: Seq Box) : int;

function Seq.__default.Min#canCall(s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Min($LS($ly), s#0) } 
  Seq.__default.Min($LS($ly), s#0) == Seq.__default.Min($ly, s#0));

// fuel synonym axiom
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Min(AsFuelBottom($ly), s#0) } 
  Seq.__default.Min($ly, s#0) == Seq.__default.Min($LZ, s#0));

// consequence axiom for Seq.__default.Min
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Min($ly, s#0) } 
    Seq.__default.Min#canCall(s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TInt)) && 0 < Seq#Length(s#0))
       ==> (forall k#0: int :: 
          { Seq#Contains(s#0, $Box(k#0)) } 
          true ==> Seq#Contains(s#0, $Box(k#0)) ==> Seq.__default.Min($ly, s#0) <= k#0)
         && Seq#Contains(s#0, $Box(Seq.__default.Min($ly, s#0))));

function Seq.__default.Min#requires(LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.Min
axiom (forall $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Min#requires($ly, s#0) } 
  $Is(s#0, TSeq(TInt))
     ==> Seq.__default.Min#requires($ly, s#0) == (0 < Seq#Length(s#0)));

// definition axiom for Seq.__default.Min (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Min($LS($ly), s#0) } 
    Seq.__default.Min#canCall(s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TInt)) && 0 < Seq#Length(s#0))
       ==> (Seq#Length(s#0) != LitInt(1)
           ==> Seq.__default.Min#canCall(Seq#Drop(s#0, LitInt(1)))
             && Math.__default.Min#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Min($ly, Seq#Drop(s#0, LitInt(1)))))
         && Seq.__default.Min($LS($ly), s#0)
           == (if Seq#Length(s#0) == LitInt(1)
             then $Unbox(Seq#Index(s#0, LitInt(0))): int
             else Math.__default.Min($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Min($ly, Seq#Drop(s#0, LitInt(1))))));

// definition axiom for Seq.__default.Min for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Min($LS($ly), Lit(s#0)) } 
    Seq.__default.Min#canCall(Lit(s#0))
         || (0 != $FunctionContextHeight
           && 
          $Is(s#0, TSeq(TInt))
           && 0 < Seq#Length(Lit(s#0)))
       ==> (Seq#Length(Lit(s#0)) != LitInt(1)
           ==> Seq.__default.Min#canCall(Lit(Seq#Drop(Lit(s#0), LitInt(1))))
             && Math.__default.Min#canCall($Unbox(Seq#Index(Lit(s#0), LitInt(0))): int, 
              Seq.__default.Min($LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1))))))
         && Seq.__default.Min($LS($ly), Lit(s#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(1)
             then $Unbox(Seq#Index(Lit(s#0), LitInt(0))): int
             else Math.__default.Min($Unbox(Seq#Index(Lit(s#0), LitInt(0))): int, 
              Seq.__default.Min($LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1)))))));

procedure {:verboseName "Seq.Min (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Min(s#0: Seq Box where $Is(s#0, TSeq(TInt)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures (forall k#1: int :: 
    { Seq#Contains(s#0, $Box(k#1)) } 
    true
       ==> 
      Seq#Contains(s#0, $Box(k#1))
       ==> Seq.__default.Min(StartFuelAssert_Seq._default.Min, s#0) <= k#1);
  ensures Seq#Contains(s#0, $Box(Seq.__default.Min(StartFuelAssert_Seq._default.Min, s#0)));



implementation {:verboseName "Seq.Min (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Min(s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var k#2: int;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##a#0: int;
  var ##b#0: int;


    // AddWellformednessCheck for function Min
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    assume 0 < Seq#Length(s#0);
    if (*)
    {
        havoc k#2;
        assume true;
        if (*)
        {
            assume Seq#Contains(s#0, $Box(k#2));
            ##s#0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
            assert {:subsumption 0} 0 < Seq#Length(##s#0);
            assume 0 < Seq#Length(##s#0);
            assert s#0 == s#0 || Seq#Rank(##s#0) < Seq#Rank(s#0);
            assume s#0 == s#0 || Seq.__default.Min#canCall(s#0);
            assume Seq.__default.Min(StartFuel_Seq._default.Min, s#0) <= k#2;
        }
        else
        {
            assume Seq#Contains(s#0, $Box(k#2))
               ==> Seq.__default.Min(StartFuel_Seq._default.Min, s#0) <= k#2;
        }

        assume (forall k#1: int :: 
          { Seq#Contains(s#0, $Box(k#1)) } 
          true
             ==> 
            Seq#Contains(s#0, $Box(k#1))
             ==> Seq.__default.Min(StartFuel_Seq._default.Min, s#0) <= k#1);
        ##s#1 := s#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
        assert {:subsumption 0} 0 < Seq#Length(##s#1);
        assume 0 < Seq#Length(##s#1);
        assert s#0 == s#0 || Seq#Rank(##s#1) < Seq#Rank(s#0);
        assume s#0 == s#0 || Seq.__default.Min#canCall(s#0);
        assume Seq#Contains(s#0, $Box(Seq.__default.Min(StartFuel_Seq._default.Min, s#0)));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(416,5)
        assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
        assume true;
        assert Seq#Equal(s#0, 
          Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(s#0, LitInt(0))), 
            Seq#Drop(s#0, LitInt(1))));
        if (Seq#Length(s#0) == LitInt(1))
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assume Seq.__default.Min(StartFuel_Seq._default.Min, s#0)
               == $Unbox(Seq#Index(s#0, LitInt(0))): int;
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Min(StartFuel_Seq._default.Min, s#0), TInt);
        }
        else
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
            ##s#2 := Seq#Drop(s#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
            assert {:subsumption 0} 0 < Seq#Length(##s#2);
            assume 0 < Seq#Length(##s#2);
            assert Seq#Rank(##s#2) < Seq#Rank(s#0);
            assume Seq.__default.Min#canCall(Seq#Drop(s#0, LitInt(1)));
            ##a#0 := $Unbox(Seq#Index(s#0, LitInt(0))): int;
            // assume allocatedness for argument to function
            assume $IsAlloc(##a#0, TInt, $Heap);
            ##b#0 := Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(s#0, LitInt(1)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##b#0, TInt, $Heap);
            assume Math.__default.Min#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
              Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Min(StartFuel_Seq._default.Min, s#0)
               == Math.__default.Min($Unbox(Seq#Index(s#0, LitInt(0))): int, 
                Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Min#canCall(Seq#Drop(s#0, LitInt(1)))
               && Math.__default.Min#canCall($Unbox(Seq#Index(s#0, LitInt(0))): int, 
                Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(s#0, LitInt(1))));
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Min(StartFuel_Seq._default.Min, s#0), TInt);
        }
    }
}



procedure {:verboseName "Seq.LemmaMinOfConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMinOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaMinOfConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMinOfConcat(a#0: Seq Box, b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var i#0: int;
  var ##s#4: Seq Box;

    // AddMethodImpl: LemmaMinOfConcat, CheckWellFormed$$Seq.__default.LemmaMinOfConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    assume 0 < Seq#Length(a#0);
    assume 0 < Seq#Length(b#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#0);
    assume 0 < Seq#Length(##s#0);
    assume Seq.__default.Min#canCall(Seq#Append(a#0, b#0));
    ##s#1 := a#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#1);
    assume 0 < Seq#Length(##s#1);
    assume Seq.__default.Min#canCall(a#0);
    assume Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0))
       <= Seq.__default.Min(StartFuel_Seq._default.Min, a#0);
    ##s#2 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#2);
    assume 0 < Seq#Length(##s#2);
    assume Seq.__default.Min#canCall(Seq#Append(a#0, b#0));
    ##s#3 := b#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#3, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#3);
    assume 0 < Seq#Length(##s#3);
    assume Seq.__default.Min#canCall(b#0);
    assume Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0))
       <= Seq.__default.Min(StartFuel_Seq._default.Min, b#0);
    havoc i#0;
    assume true;
    if (*)
    {
        assume Seq#Contains(Seq#Append(a#0, b#0), $Box(i#0));
        ##s#4 := Seq#Append(a#0, b#0);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#4, TSeq(TInt), $Heap);
        assert {:subsumption 0} 0 < Seq#Length(##s#4);
        assume 0 < Seq#Length(##s#4);
        assume Seq.__default.Min#canCall(Seq#Append(a#0, b#0));
        assume Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0)) <= i#0;
    }
    else
    {
        assume Seq#Contains(Seq#Append(a#0, b#0), $Box(i#0))
           ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0)) <= i#0;
    }

    assume (forall i#1: int :: 
      { Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1)) } 
      true
         ==> 
        Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
         ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0)) <= i#1);
}



procedure {:verboseName "Seq.LemmaMinOfConcat (call)"} {:_induction a#0, b#0} Call$$Seq.__default.LemmaMinOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap));
  // user-defined preconditions
  requires 0 < Seq#Length(a#0);
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Min#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Min#canCall(a#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Append(a#0, b#0))
     <= Seq.__default.Min(StartFuelAssert_Seq._default.Min, a#0);
  free ensures Seq.__default.Min#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Min#canCall(b#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Append(a#0, b#0))
     <= Seq.__default.Min(StartFuelAssert_Seq._default.Min, b#0);
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1)) } 
    Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Min#canCall(Seq#Append(a#0, b#0)));
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1)) } 
    true
       ==> 
      Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append(a#0, b#0)) <= i#1);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaMinOfConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaMinOfConcat(a#0: Seq Box where $Is(a#0, TSeq(TInt)) && $IsAlloc(a#0, TSeq(TInt), $Heap), 
    b#0: Seq Box where $Is(b#0, TSeq(TInt)) && $IsAlloc(b#0, TSeq(TInt), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires 0 < Seq#Length(a#0);
  requires 0 < Seq#Length(b#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Min#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Min#canCall(a#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Append(a#0, b#0))
     <= Seq.__default.Min(StartFuelAssert_Seq._default.Min, a#0);
  free ensures Seq.__default.Min#canCall(Seq#Append(a#0, b#0))
     && Seq.__default.Min#canCall(b#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Append(a#0, b#0))
     <= Seq.__default.Min(StartFuelAssert_Seq._default.Min, b#0);
  free ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1)) } 
    Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Min#canCall(Seq#Append(a#0, b#0)));
  ensures (forall i#1: int :: 
    { Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1)) } 
    true
       ==> 
      Seq#Contains(Seq#Append(a#0, b#0), $Box(i#1))
       ==> Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Append(a#0, b#0)) <= i#1);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaMinOfConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaMinOfConcat(a#0: Seq Box, b#0: Seq Box) returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var a##1_0: Seq Box;
  var b##1_0: Seq Box;

    // AddMethodImpl: LemmaMinOfConcat, Impl$$Seq.__default.LemmaMinOfConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#a0#0: Seq Box, $ih#b0#0: Seq Box :: 
      $Is($ih#a0#0, TSeq(TInt))
           && $Is($ih#b0#0, TSeq(TInt))
           && 
          0 < Seq#Length($ih#a0#0)
           && 0 < Seq#Length($ih#b0#0)
           && (Seq#Rank($ih#a0#0) < Seq#Rank(a#0)
             || (Seq#Rank($ih#a0#0) == Seq#Rank(a#0) && Seq#Rank($ih#b0#0) < Seq#Rank(b#0)))
         ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append($ih#a0#0, $ih#b0#0))
             <= Seq.__default.Min(StartFuel_Seq._default.Min, $ih#a0#0)
           && Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append($ih#a0#0, $ih#b0#0))
             <= Seq.__default.Min(StartFuel_Seq._default.Min, $ih#b0#0)
           && (forall i#2: int :: 
            { Seq#Contains(Seq#Append($ih#a0#0, $ih#b0#0), $Box(i#2)) } 
            true
               ==> 
              Seq#Contains(Seq#Append($ih#a0#0, $ih#b0#0), $Box(i#2))
               ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Append($ih#a0#0, $ih#b0#0))
                 <= i#2));
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(428,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(428,15)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__Min();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(429,5)
    assume true;
    if (Seq#Length(a#0) == LitInt(1))
    {
    }
    else
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(431,7)
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
        assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(Seq#Append(a#0, b#0));
        assume true;
        assert Seq#Equal(Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0), 
          Seq#Drop(Seq#Append(a#0, b#0), LitInt(1)));
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(432,23)
        // TrCallStmt: Before ProcessCallStmt
        assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
        assume true;
        // ProcessCallStmt: CheckSubrange
        a##1_0 := Seq#Drop(a#0, LitInt(1));
        assume true;
        // ProcessCallStmt: CheckSubrange
        b##1_0 := b#0;
        assert Seq#Rank(a##1_0) < Seq#Rank(a#0)
           || (Seq#Rank(a##1_0) == Seq#Rank(a#0) && Seq#Rank(b##1_0) < Seq#Rank(b#0));
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaMinOfConcat(a##1_0, b##1_0);
        // TrCallStmt: After ProcessCallStmt
    }
}



procedure {:verboseName "Seq.LemmaSubseqMax (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaSubseqMax(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0);
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaSubseqMax (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaSubseqMax(s#0: Seq Box, from#0: int, to#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;

    // AddMethodImpl: LemmaSubseqMax, CheckWellFormed$$Seq.__default.LemmaSubseqMax
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    if (from#0 < to#0)
    {
    }

    assume from#0 < to#0 && to#0 <= Seq#Length(s#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    assert 0 <= from#0 && from#0 <= Seq#Length(s#0);
    assert from#0 <= to#0 && to#0 <= Seq#Length(s#0);
    ##s#0 := Seq#Drop(Seq#Take(s#0, to#0), from#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#0);
    assume 0 < Seq#Length(##s#0);
    assume Seq.__default.Max#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0));
    ##s#1 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#1);
    assume 0 < Seq#Length(##s#1);
    assume Seq.__default.Max#canCall(s#0);
    assume Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(Seq#Take(s#0, to#0), from#0))
       <= Seq.__default.Max(StartFuel_Seq._default.Max, s#0);
}



procedure {:verboseName "Seq.LemmaSubseqMax (call)"} {:_induction s#0} Call$$Seq.__default.LemmaSubseqMax(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0);
  // user-defined preconditions
  requires from#0 < to#0;
  requires to#0 <= Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Max#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0))
     && Seq.__default.Max#canCall(s#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Drop(Seq#Take(s#0, to#0), from#0))
     <= Seq.__default.Max(StartFuelAssert_Seq._default.Max, s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaSubseqMax (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaSubseqMax(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0)
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires from#0 < to#0;
  requires to#0 <= Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Max#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0))
     && Seq.__default.Max#canCall(s#0);
  ensures Seq.__default.Max(StartFuelAssert_Seq._default.Max, Seq#Drop(Seq#Take(s#0, to#0), from#0))
     <= Seq.__default.Max(StartFuelAssert_Seq._default.Max, s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaSubseqMax (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaSubseqMax(s#0: Seq Box, from#0: int, to#0: int) returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var subseq#0: Seq Box
     where $Is(subseq#0, TSeq(TInt)) && $IsAlloc(subseq#0, TSeq(TInt), $Heap);
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var k#0_0: int;
  var k#0_1: int;
  var ##s#0_0: Seq Box;
  var $lambdaHeap#0_0: Heap;
  var i#0_0: int;
  var $_Frame#l0_0: <beta>[ref,Field beta]bool;
  var lambdaResult#0_0: int;

    // AddMethodImpl: LemmaSubseqMax, Impl$$Seq.__default.LemmaSubseqMax
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, TSeq(TInt))
           && 
          from#0 < to#0
           && to#0 <= Seq#Length($ih#s0#0)
           && (Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
             || (Seq#Rank($ih#s0#0) == Seq#Rank(s#0)
               && ((0 <= from#0 && from#0 < from#0)
                 || (from#0 == from#0 && 0 <= to#0 && to#0 < to#0))))
         ==> Seq.__default.Max(StartFuel_Seq._default.Max, Seq#Drop(Seq#Take($ih#s0#0, to#0), from#0))
           <= Seq.__default.Max(StartFuel_Seq._default.Max, $ih#s0#0));
    $_reverifyPost := false;
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(442,16)
    assume true;
    assert 0 <= from#0 && from#0 <= Seq#Length(s#0);
    assert from#0 <= to#0 && to#0 <= Seq#Length(s#0);
    assume true;
    subseq#0 := Seq#Drop(Seq#Take(s#0, to#0), from#0);
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(443,5)
    ##s#2 := subseq#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#2);
    assume 0 < Seq#Length(##s#2);
    assume Seq.__default.Max#canCall(subseq#0);
    ##s#3 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#3, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#3);
    assume 0 < Seq#Length(##s#3);
    assume Seq.__default.Max#canCall(s#0);
    assume Seq.__default.Max#canCall(subseq#0) && Seq.__default.Max#canCall(s#0);
    if (Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0)
       > Seq.__default.Max(StartFuel_Seq._default.Max, s#0))
    {
        // ----- assign-such-that statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(444,13)
        havoc k#0_1;
        if (true)
        {
            if (LitInt(0) <= k#0_1)
            {
            }

            if (LitInt(0) <= k#0_1 && k#0_1 < Seq#Length(subseq#0))
            {
                assert {:subsumption 0} 0 <= k#0_1 && k#0_1 < Seq#Length(subseq#0);
                ##s#0_0 := subseq#0;
                // assume allocatedness for argument to function
                assume $IsAlloc(##s#0_0, TSeq(TInt), $Heap);
                assert {:subsumption 0} 0 < Seq#Length(##s#0_0);
                assume Seq.__default.Max#canCall(subseq#0);
            }

            assume LitInt(0) <= k#0_1
               ==> 
              k#0_1 < Seq#Length(subseq#0)
               ==> Seq.__default.Max#canCall(subseq#0);
        }

        assert ($Is(Seq#Length(subseq#0) - 1, TInt)
             && 
            LitInt(0) <= Seq#Length(subseq#0) - 1
             && Seq#Length(subseq#0) - 1 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, Seq#Length(subseq#0) - 1)): int
               == Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0))
           || 
          ($Is(LitInt(0), TInt)
             && 
            LitInt(0) <= LitInt(0)
             && 0 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, LitInt(0))): int
               == Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0))
           || 
          ($Is(LitInt(0), TInt)
             && 
            LitInt(0) <= LitInt(0)
             && 0 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, LitInt(0))): int
               == Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0))
           || (exists $as#k0_0#0_0: int :: 
            LitInt(0) <= $as#k0_0#0_0
               && $as#k0_0#0_0 < Seq#Length(subseq#0)
               && $Unbox(Seq#Index(subseq#0, $as#k0_0#0_0)): int
                 == Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0));
        havoc k#0_0;
        assume LitInt(0) <= k#0_0
           && k#0_0 < Seq#Length(subseq#0)
           && $Unbox(Seq#Index(subseq#0, k#0_0)): int
             == Seq.__default.Max(StartFuel_Seq._default.Max, subseq#0);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(445,7)
        assert 0 <= Seq#Length(subseq#0);
        // Begin Comprehension WF check
        if (*)
        {
            havoc $lambdaHeap#0_0;
            assume $IsGoodHeap($lambdaHeap#0_0);
            assume $Heap == $lambdaHeap#0_0 || $HeapSucc($Heap, $lambdaHeap#0_0);
            havoc i#0_0;
            if (true)
            {
                $_Frame#l0_0 := (lambda<alpha> $o: ref, $f: Field alpha :: 
                  $o != null && read($lambdaHeap#0_0, $o, alloc) ==> false);
                if (LitInt(0) <= i#0_0)
                {
                }

                if (LitInt(0) <= i#0_0 && i#0_0 < Seq#Length(subseq#0))
                {
                    assume lambdaResult#0_0 == i#0_0 + from#0;
                    assume true;
                    // CheckWellformedWithResult: any expression
                    assume $Is(lambdaResult#0_0, TInt);
                }
            }

            assume false;
        }

        // End Comprehension WF check
        assert {:subsumption 0} (forall seqinit#0_0#i0#0: int :: 
          0 <= seqinit#0_0#i0#0 && seqinit#0_0#i0#0 < Seq#Length(subseq#0)
             ==> Requires1(TInt, 
              TInt, 
              $Heap, 
              Lit(AtLayer((lambda $l#0_1#ly#0: LayerType :: 
                    Handle1((lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        $Box($Unbox($l#0_1#i#0): int + from#0)), 
                      (lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        $IsBox($l#0_1#i#0, TInt)
                           && 
                          LitInt(0) <= $Unbox($l#0_1#i#0): int
                           && $Unbox($l#0_1#i#0): int < Seq#Length(subseq#0)), 
                      (lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        SetRef_to_SetBox((lambda $l#0_1#o#0: ref :: false))))), 
                  $LS($LZ))), 
              $Box(seqinit#0_0#i0#0)));
        assert {:subsumption 0} 0 <= k#0_0
           && k#0_0
             < Seq#Length(Seq#Create(TInt, 
                $Heap, 
                Seq#Length(subseq#0), 
                Lit(AtLayer((lambda $l#0_2#ly#0: LayerType :: 
                      Handle1((lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          $Box($Unbox($l#0_2#i#0): int + from#0)), 
                        (lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          $IsBox($l#0_2#i#0, TInt)
                             && 
                            LitInt(0) <= $Unbox($l#0_2#i#0): int
                             && $Unbox($l#0_2#i#0): int < Seq#Length(subseq#0)), 
                        (lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          SetRef_to_SetBox((lambda $l#0_2#o#0: ref :: false))))), 
                    $LS($LZ)))));
        assert {:subsumption 0} 0
             <= $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_0#ly#0: LayerType :: 
                        Handle1((lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $Box($Unbox($l#0_0#i#0): int + from#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $IsBox($l#0_0#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_0#i#0): int
                               && $Unbox($l#0_0#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_0#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int
           && $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_0#ly#0: LayerType :: 
                        Handle1((lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $Box($Unbox($l#0_0#i#0): int + from#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $IsBox($l#0_0#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_0#i#0): int
                               && $Unbox($l#0_0#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_0#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int
             < Seq#Length(s#0);
        assume true;
        assert Seq#Contains(s#0, 
          Seq#Index(s#0, 
            $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_5#ly#0: LayerType :: 
                        Handle1((lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            $Box($Unbox($l#0_5#i#0): int + from#0)), 
                          (lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            $IsBox($l#0_5#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_5#i#0): int
                               && $Unbox($l#0_5#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_5#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int));
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(446,7)
        assume true;
        assert Lit(false);
    }
    else
    {
    }
}



procedure {:verboseName "Seq.LemmaSubseqMin (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaSubseqMin(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0);
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaSubseqMin (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaSubseqMin(s#0: Seq Box, from#0: int, to#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;

    // AddMethodImpl: LemmaSubseqMin, CheckWellFormed$$Seq.__default.LemmaSubseqMin
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    if (from#0 < to#0)
    {
    }

    assume from#0 < to#0 && to#0 <= Seq#Length(s#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    assert 0 <= from#0 && from#0 <= Seq#Length(s#0);
    assert from#0 <= to#0 && to#0 <= Seq#Length(s#0);
    ##s#0 := Seq#Drop(Seq#Take(s#0, to#0), from#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#0);
    assume 0 < Seq#Length(##s#0);
    assume Seq.__default.Min#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0));
    ##s#1 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#1);
    assume 0 < Seq#Length(##s#1);
    assume Seq.__default.Min#canCall(s#0);
    assume Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(Seq#Take(s#0, to#0), from#0))
       >= Seq.__default.Min(StartFuel_Seq._default.Min, s#0);
}



procedure {:verboseName "Seq.LemmaSubseqMin (call)"} {:_induction s#0} Call$$Seq.__default.LemmaSubseqMin(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0);
  // user-defined preconditions
  requires from#0 < to#0;
  requires to#0 <= Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Min#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0))
     && Seq.__default.Min#canCall(s#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Drop(Seq#Take(s#0, to#0), from#0))
     >= Seq.__default.Min(StartFuelAssert_Seq._default.Min, s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaSubseqMin (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaSubseqMin(s#0: Seq Box where $Is(s#0, TSeq(TInt)) && $IsAlloc(s#0, TSeq(TInt), $Heap), 
    from#0: int where LitInt(0) <= from#0, 
    to#0: int where LitInt(0) <= to#0)
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires from#0 < to#0;
  requires to#0 <= Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Min#canCall(Seq#Drop(Seq#Take(s#0, to#0), from#0))
     && Seq.__default.Min#canCall(s#0);
  ensures Seq.__default.Min(StartFuelAssert_Seq._default.Min, Seq#Drop(Seq#Take(s#0, to#0), from#0))
     >= Seq.__default.Min(StartFuelAssert_Seq._default.Min, s#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaSubseqMin (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaSubseqMin(s#0: Seq Box, from#0: int, to#0: int) returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var subseq#0: Seq Box
     where $Is(subseq#0, TSeq(TInt)) && $IsAlloc(subseq#0, TSeq(TInt), $Heap);
  var ##s#2: Seq Box;
  var ##s#3: Seq Box;
  var k#0_0: int;
  var k#0_1: int;
  var ##s#0_0: Seq Box;
  var $lambdaHeap#0_0: Heap;
  var i#0_0: int;
  var $_Frame#l0_0: <beta>[ref,Field beta]bool;
  var lambdaResult#0_0: int;

    // AddMethodImpl: LemmaSubseqMin, Impl$$Seq.__default.LemmaSubseqMin
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, TSeq(TInt))
           && 
          from#0 < to#0
           && to#0 <= Seq#Length($ih#s0#0)
           && (Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
             || (Seq#Rank($ih#s0#0) == Seq#Rank(s#0)
               && ((0 <= from#0 && from#0 < from#0)
                 || (from#0 == from#0 && 0 <= to#0 && to#0 < to#0))))
         ==> Seq.__default.Min(StartFuel_Seq._default.Min, Seq#Drop(Seq#Take($ih#s0#0, to#0), from#0))
           >= Seq.__default.Min(StartFuel_Seq._default.Min, $ih#s0#0));
    $_reverifyPost := false;
    // ----- assignment statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(456,16)
    assume true;
    assert 0 <= from#0 && from#0 <= Seq#Length(s#0);
    assert from#0 <= to#0 && to#0 <= Seq#Length(s#0);
    assume true;
    subseq#0 := Seq#Drop(Seq#Take(s#0, to#0), from#0);
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(457,5)
    ##s#2 := subseq#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#2, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#2);
    assume 0 < Seq#Length(##s#2);
    assume Seq.__default.Min#canCall(subseq#0);
    ##s#3 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#3, TSeq(TInt), $Heap);
    assert {:subsumption 0} 0 < Seq#Length(##s#3);
    assume 0 < Seq#Length(##s#3);
    assume Seq.__default.Min#canCall(s#0);
    assume Seq.__default.Min#canCall(subseq#0) && Seq.__default.Min#canCall(s#0);
    if (Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0)
       < Seq.__default.Min(StartFuel_Seq._default.Min, s#0))
    {
        // ----- assign-such-that statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(458,13)
        havoc k#0_1;
        if (true)
        {
            if (LitInt(0) <= k#0_1)
            {
            }

            if (LitInt(0) <= k#0_1 && k#0_1 < Seq#Length(subseq#0))
            {
                assert {:subsumption 0} 0 <= k#0_1 && k#0_1 < Seq#Length(subseq#0);
                ##s#0_0 := subseq#0;
                // assume allocatedness for argument to function
                assume $IsAlloc(##s#0_0, TSeq(TInt), $Heap);
                assert {:subsumption 0} 0 < Seq#Length(##s#0_0);
                assume Seq.__default.Min#canCall(subseq#0);
            }

            assume LitInt(0) <= k#0_1
               ==> 
              k#0_1 < Seq#Length(subseq#0)
               ==> Seq.__default.Min#canCall(subseq#0);
        }

        assert ($Is(Seq#Length(subseq#0) - 1, TInt)
             && 
            LitInt(0) <= Seq#Length(subseq#0) - 1
             && Seq#Length(subseq#0) - 1 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, Seq#Length(subseq#0) - 1)): int
               == Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0))
           || 
          ($Is(LitInt(0), TInt)
             && 
            LitInt(0) <= LitInt(0)
             && 0 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, LitInt(0))): int
               == Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0))
           || 
          ($Is(LitInt(0), TInt)
             && 
            LitInt(0) <= LitInt(0)
             && 0 < Seq#Length(subseq#0)
             && $Unbox(Seq#Index(subseq#0, LitInt(0))): int
               == Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0))
           || (exists $as#k0_0#0_0: int :: 
            LitInt(0) <= $as#k0_0#0_0
               && $as#k0_0#0_0 < Seq#Length(subseq#0)
               && $Unbox(Seq#Index(subseq#0, $as#k0_0#0_0)): int
                 == Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0));
        havoc k#0_0;
        assume LitInt(0) <= k#0_0
           && k#0_0 < Seq#Length(subseq#0)
           && $Unbox(Seq#Index(subseq#0, k#0_0)): int
             == Seq.__default.Min(StartFuel_Seq._default.Min, subseq#0);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(459,7)
        assert 0 <= Seq#Length(subseq#0);
        // Begin Comprehension WF check
        if (*)
        {
            havoc $lambdaHeap#0_0;
            assume $IsGoodHeap($lambdaHeap#0_0);
            assume $Heap == $lambdaHeap#0_0 || $HeapSucc($Heap, $lambdaHeap#0_0);
            havoc i#0_0;
            if (true)
            {
                $_Frame#l0_0 := (lambda<alpha> $o: ref, $f: Field alpha :: 
                  $o != null && read($lambdaHeap#0_0, $o, alloc) ==> false);
                if (LitInt(0) <= i#0_0)
                {
                }

                if (LitInt(0) <= i#0_0 && i#0_0 < Seq#Length(subseq#0))
                {
                    assume lambdaResult#0_0 == i#0_0 + from#0;
                    assume true;
                    // CheckWellformedWithResult: any expression
                    assume $Is(lambdaResult#0_0, TInt);
                }
            }

            assume false;
        }

        // End Comprehension WF check
        assert {:subsumption 0} (forall seqinit#0_0#i0#0: int :: 
          0 <= seqinit#0_0#i0#0 && seqinit#0_0#i0#0 < Seq#Length(subseq#0)
             ==> Requires1(TInt, 
              TInt, 
              $Heap, 
              Lit(AtLayer((lambda $l#0_1#ly#0: LayerType :: 
                    Handle1((lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        $Box($Unbox($l#0_1#i#0): int + from#0)), 
                      (lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        $IsBox($l#0_1#i#0, TInt)
                           && 
                          LitInt(0) <= $Unbox($l#0_1#i#0): int
                           && $Unbox($l#0_1#i#0): int < Seq#Length(subseq#0)), 
                      (lambda $l#0_1#heap#0: Heap, $l#0_1#i#0: Box :: 
                        SetRef_to_SetBox((lambda $l#0_1#o#0: ref :: false))))), 
                  $LS($LZ))), 
              $Box(seqinit#0_0#i0#0)));
        assert {:subsumption 0} 0 <= k#0_0
           && k#0_0
             < Seq#Length(Seq#Create(TInt, 
                $Heap, 
                Seq#Length(subseq#0), 
                Lit(AtLayer((lambda $l#0_2#ly#0: LayerType :: 
                      Handle1((lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          $Box($Unbox($l#0_2#i#0): int + from#0)), 
                        (lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          $IsBox($l#0_2#i#0, TInt)
                             && 
                            LitInt(0) <= $Unbox($l#0_2#i#0): int
                             && $Unbox($l#0_2#i#0): int < Seq#Length(subseq#0)), 
                        (lambda $l#0_2#heap#0: Heap, $l#0_2#i#0: Box :: 
                          SetRef_to_SetBox((lambda $l#0_2#o#0: ref :: false))))), 
                    $LS($LZ)))));
        assert {:subsumption 0} 0
             <= $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_0#ly#0: LayerType :: 
                        Handle1((lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $Box($Unbox($l#0_0#i#0): int + from#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $IsBox($l#0_0#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_0#i#0): int
                               && $Unbox($l#0_0#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_0#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int
           && $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_0#ly#0: LayerType :: 
                        Handle1((lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $Box($Unbox($l#0_0#i#0): int + from#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            $IsBox($l#0_0#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_0#i#0): int
                               && $Unbox($l#0_0#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_0#heap#0: Heap, $l#0_0#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_0#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int
             < Seq#Length(s#0);
        assume true;
        assert Seq#Contains(s#0, 
          Seq#Index(s#0, 
            $Unbox(Seq#Index(Seq#Create(TInt, 
                  $Heap, 
                  Seq#Length(subseq#0), 
                  Lit(AtLayer((lambda $l#0_5#ly#0: LayerType :: 
                        Handle1((lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            $Box($Unbox($l#0_5#i#0): int + from#0)), 
                          (lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            $IsBox($l#0_5#i#0, TInt)
                               && 
                              LitInt(0) <= $Unbox($l#0_5#i#0): int
                               && $Unbox($l#0_5#i#0): int < Seq#Length(subseq#0)), 
                          (lambda $l#0_5#heap#0: Heap, $l#0_5#i#0: Box :: 
                            SetRef_to_SetBox((lambda $l#0_5#o#0: ref :: false))))), 
                      $LS($LZ)))), 
                k#0_0)): int));
    }
    else
    {
    }
}



// function declaration for Seq._default.Flatten
function Seq.__default.Flatten(Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box) : Seq Box;

function Seq.__default.Flatten#canCall(Seq._default.Flatten$T: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), s#0) } 
  Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), s#0)
     == Seq.__default.Flatten(Seq._default.Flatten$T, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Flatten(Seq._default.Flatten$T, AsFuelBottom($ly), s#0) } 
  Seq.__default.Flatten(Seq._default.Flatten$T, $ly, s#0)
     == Seq.__default.Flatten(Seq._default.Flatten$T, $LZ, s#0));

// consequence axiom for Seq.__default.Flatten
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Flatten(Seq._default.Flatten$T, $ly, s#0) } 
    Seq.__default.Flatten#canCall(Seq._default.Flatten$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TSeq(Seq._default.Flatten$T))))
       ==> $Is(Seq.__default.Flatten(Seq._default.Flatten$T, $ly, s#0), 
        TSeq(Seq._default.Flatten$T)));

function Seq.__default.Flatten#requires(Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.Flatten
axiom (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.Flatten#requires(Seq._default.Flatten$T, $ly, s#0) } 
  $Is(s#0, TSeq(TSeq(Seq._default.Flatten$T)))
     ==> Seq.__default.Flatten#requires(Seq._default.Flatten$T, $ly, s#0) == true);

// definition axiom for Seq.__default.Flatten (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), s#0) } 
    Seq.__default.Flatten#canCall(Seq._default.Flatten$T, s#0)
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TSeq(Seq._default.Flatten$T))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> Seq.__default.Flatten#canCall(Seq._default.Flatten$T, Seq#Drop(s#0, LitInt(1))))
         && Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append($Unbox(Seq#Index(s#0, LitInt(0))): Seq Box, 
              Seq.__default.Flatten(Seq._default.Flatten$T, $ly, Seq#Drop(s#0, LitInt(1))))));

// definition axiom for Seq.__default.Flatten for all literals (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Flatten$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), Lit(s#0)) } 
    Seq.__default.Flatten#canCall(Seq._default.Flatten$T, Lit(s#0))
         || (0 != $FunctionContextHeight && $Is(s#0, TSeq(TSeq(Seq._default.Flatten$T))))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> Seq.__default.Flatten#canCall(Seq._default.Flatten$T, Lit(Seq#Drop(Lit(s#0), LitInt(1)))))
         && Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), Lit(s#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append($Unbox(Seq#Index(Lit(s#0), LitInt(0))): Seq Box, 
              Seq.__default.Flatten(Seq._default.Flatten$T, $LS($ly), Lit(Seq#Drop(Lit(s#0), LitInt(1)))))));

procedure {:verboseName "Seq.Flatten (well-formedness)"} CheckWellformed$$Seq.__default.Flatten(Seq._default.Flatten$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(TSeq(Seq._default.Flatten$T))));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.Flatten (well-formedness)"} CheckWellformed$$Seq.__default.Flatten(Seq._default.Flatten$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;


    // AddWellformednessCheck for function Flatten
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), s#0), 
          TSeq(Seq._default.Flatten$T));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(s#0) == LitInt(0))
        {
            assume Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), s#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), s#0), 
              TSeq(Seq._default.Flatten$T));
        }
        else
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
            ##s#0 := Seq#Drop(s#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(TSeq(Seq._default.Flatten$T)), $Heap);
            assert 0 <= Seq#Length(s#0) || Seq#Length(##s#0) == Seq#Length(s#0);
            assert Seq#Length(##s#0) < Seq#Length(s#0);
            assume Seq.__default.Flatten#canCall(Seq._default.Flatten$T, Seq#Drop(s#0, LitInt(1)));
            assume Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), s#0)
               == Seq#Append($Unbox(Seq#Index(s#0, LitInt(0))): Seq Box, 
                Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Flatten#canCall(Seq._default.Flatten$T, Seq#Drop(s#0, LitInt(1)));
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Flatten(Seq._default.Flatten$T, $LS($LZ), s#0), 
              TSeq(Seq._default.Flatten$T));
        }
    }
}



procedure {:verboseName "Seq.LemmaFlattenConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaFlattenConcat(Seq._default.LemmaFlattenConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaFlattenConcat (call)"} {:_induction a#0, b#0} Call$$Seq.__default.LemmaFlattenConcat(Seq._default.LemmaFlattenConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0))
     && 
    Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, a#0)
     && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
  ensures Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), a#0), 
      Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaFlattenConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaFlattenConcat(Seq._default.LemmaFlattenConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0))
     && 
    Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, a#0)
     && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
  ensures Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), a#0), 
      Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaFlattenConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaFlattenConcat(Seq._default.LemmaFlattenConcat$T: Ty, a#0: Seq Box, b#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var ##s#1_0_0_0: Seq Box;
  var ##s#1_0_0_1: Seq Box;
  var ##s#1_0_0_2: Seq Box;
  var ##s#1_0_0_3: Seq Box;
  var ##s#1_0_1_0: Seq Box;
  var ##s#1_0_1_1: Seq Box;
  var ##s#1_0_1_2: Seq Box;
  var ##s#1_0_2_0: Seq Box;
  var ##s#1_0_2_1: Seq Box;
  var ##s#1_0_0: Seq Box;

    // AddMethodImpl: LemmaFlattenConcat, Impl$$Seq.__default.LemmaFlattenConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#a0#0: Seq Box, $ih#b0#0: Seq Box :: 
      $Is($ih#a0#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
           && $Is($ih#b0#0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)))
           && Lit(true)
           && (Seq#Rank($ih#a0#0) < Seq#Rank(a#0)
             || (Seq#Rank($ih#a0#0) == Seq#Rank(a#0) && Seq#Rank($ih#b0#0) < Seq#Rank(b#0)))
         ==> Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), Seq#Append($ih#a0#0, $ih#b0#0)), 
          Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), $ih#a0#0), 
            Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), $ih#b0#0))));
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(484,5)
    assume true;
    if (Seq#Length(a#0) == LitInt(0))
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(485,7)
        assume true;
        assert Seq#Equal(Seq#Append(a#0, b#0), b#0);
    }
    else
    {
        // ----- calc statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
        // Assume Fuel Constant
        if (*)
        {
            // ----- assert wf[initial] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            ##s#1_0_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0));
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            ##s#1_0_2_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0));
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(a#0, b#0));
            // ----- Hint0 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(489,13)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(Seq#Append(a#0, b#0));
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assume true;
            assert Seq#Equal($Unbox(Seq#Index(Seq#Append(a#0, b#0), LitInt(0))): Seq Box, 
              $Unbox(Seq#Index(a#0, LitInt(0))): Seq Box);
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(489,41)
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(Seq#Append(a#0, b#0));
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            assume true;
            assert Seq#Equal(Seq#Drop(Seq#Append(a#0, b#0), LitInt(1)), 
              Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##s#1_0_2_1 := Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_1, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- assert line0 == line1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assert {:subsumption 0} Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
              Seq#Append($Unbox(Seq#Index(a#0, LitInt(0))): Seq Box, 
                Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, 
                  $LS($LS($LZ)), 
                  Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0))));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assume {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assume {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##s#1_0_1_0 := Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- Hint1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##s#1_0_1_1 := Seq#Drop(a#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_1, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Drop(a#0, LitInt(1)));
            ##s#1_0_1_2 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_2, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Drop(a#0, LitInt(1)))
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            // ----- assert line1 == line2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append($Unbox(Seq#Index(a#0, LitInt(0))): Seq Box, 
                Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, 
                  $LS($LS($LZ)), 
                  Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0))), 
              Seq#Append(Seq#Append($Unbox(Seq#Index(a#0, LitInt(0))): Seq Box, 
                  Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), Seq#Drop(a#0, LitInt(1)))), 
                Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), b#0)));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assume {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assume {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##s#1_0_0_0 := Seq#Drop(a#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_0, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Drop(a#0, LitInt(1)));
            ##s#1_0_0_1 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_1, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, Seq#Drop(a#0, LitInt(1)))
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            // ----- Hint2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            ##s#1_0_0_2 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_2, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, a#0);
            ##s#1_0_0_3 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_3, TSeq(TSeq(Seq._default.LemmaFlattenConcat$T)), $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, a#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenConcat$T, b#0);
            // ----- assert line2 == line3 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(487,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq#Append($Unbox(Seq#Index(a#0, LitInt(0))): Seq Box, 
                  Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), Seq#Drop(a#0, LitInt(1)))), 
                Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), b#0)), 
              Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), a#0), 
                Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LS($LZ)), b#0)));
            assume false;
        }

        assume Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), Seq#Append(a#0, b#0)), 
          Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), a#0), 
            Seq.__default.Flatten(Seq._default.LemmaFlattenConcat$T, $LS($LZ), b#0)));
    }
}



// function declaration for Seq._default.FlattenReverse
function Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box) : Seq Box;

function Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T: Ty, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), s#0) } 
  Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), s#0)
     == Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $ly, s#0));

// fuel synonym axiom
axiom (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, AsFuelBottom($ly), s#0) } 
  Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $ly, s#0)
     == Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LZ, s#0));

// consequence axiom for Seq.__default.FlattenReverse
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $ly, s#0) } 
    Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, s#0)
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(TSeq(Seq._default.FlattenReverse$T))))
       ==> $Is(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $ly, s#0), 
        TSeq(Seq._default.FlattenReverse$T)));

function Seq.__default.FlattenReverse#requires(Ty, LayerType, Seq Box) : bool;

// #requires axiom for Seq.__default.FlattenReverse
axiom (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
  { Seq.__default.FlattenReverse#requires(Seq._default.FlattenReverse$T, $ly, s#0) } 
  $Is(s#0, TSeq(TSeq(Seq._default.FlattenReverse$T)))
     ==> Seq.__default.FlattenReverse#requires(Seq._default.FlattenReverse$T, $ly, s#0)
       == true);

// definition axiom for Seq.__default.FlattenReverse (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    { Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), s#0) } 
    Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, s#0)
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(TSeq(Seq._default.FlattenReverse$T))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(TSeq(Seq._default.FlattenReverse$T), s#0)
             && Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, 
              Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0))
             && Seq.__default.Last#canCall(TSeq(Seq._default.FlattenReverse$T), s#0))
         && Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, 
                $ly, 
                Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0)), 
              $Unbox(Seq.__default.Last(TSeq(Seq._default.FlattenReverse$T), s#0)): Seq Box)));

// definition axiom for Seq.__default.FlattenReverse for all literals (revealed)
axiom 1 <= $FunctionContextHeight
   ==> (forall Seq._default.FlattenReverse$T: Ty, $ly: LayerType, s#0: Seq Box :: 
    {:weight 3} { Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), Lit(s#0)) } 
    Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, Lit(s#0))
         || (1 != $FunctionContextHeight
           && $Is(s#0, TSeq(TSeq(Seq._default.FlattenReverse$T))))
       ==> (Seq#Length(Lit(s#0)) != LitInt(0)
           ==> Seq.__default.DropLast#canCall(TSeq(Seq._default.FlattenReverse$T), Lit(s#0))
             && Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, 
              Lit(Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), Lit(s#0))))
             && Seq.__default.Last#canCall(TSeq(Seq._default.FlattenReverse$T), Lit(s#0)))
         && Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($ly), Lit(s#0))
           == (if Seq#Length(Lit(s#0)) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, 
                $LS($ly), 
                Lit(Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), Lit(s#0)))), 
              $Unbox(Seq.__default.Last(TSeq(Seq._default.FlattenReverse$T), Lit(s#0))): Seq Box)));

procedure {:verboseName "Seq.FlattenReverse (well-formedness)"} CheckWellformed$$Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T: Ty, 
    s#0: Seq Box where $Is(s#0, TSeq(TSeq(Seq._default.FlattenReverse$T))));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.FlattenReverse (well-formedness)"} CheckWellformed$$Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T: Ty, s#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;
  var ##s#1: Seq Box;
  var ##s#2: Seq Box;


    // AddWellformednessCheck for function FlattenReverse
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    if (*)
    {
        assume $Is(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($LZ), s#0), 
          TSeq(Seq._default.FlattenReverse$T));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc) ==> false);
        if (Seq#Length(s#0) == LitInt(0))
        {
            assume Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($LZ), s#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($LZ), s#0), 
              TSeq(Seq._default.FlattenReverse$T));
        }
        else
        {
            ##s#0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(TSeq(Seq._default.FlattenReverse$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#0) > 0;
            assume Seq#Length(##s#0) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.FlattenReverse$T), s#0);
            ##s#1 := Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1, TSeq(TSeq(Seq._default.FlattenReverse$T)), $Heap);
            assert 0 <= Seq#Length(s#0) || Seq#Length(##s#1) == Seq#Length(s#0);
            assert Seq#Length(##s#1) < Seq#Length(s#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, 
              Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0));
            ##s#2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#2, TSeq(TSeq(Seq._default.FlattenReverse$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#2) > 0;
            assume Seq#Length(##s#2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.FlattenReverse$T), s#0);
            assume Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($LZ), s#0)
               == Seq#Append(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, 
                  $LS($LZ), 
                  Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0)), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.FlattenReverse$T), s#0)): Seq Box);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.FlattenReverse$T), s#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.FlattenReverse$T, 
                Seq.__default.DropLast(TSeq(Seq._default.FlattenReverse$T), s#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.FlattenReverse$T), s#0);
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.FlattenReverse(Seq._default.FlattenReverse$T, $LS($LZ), s#0), 
              TSeq(Seq._default.FlattenReverse$T));
        }
    }
}



procedure {:verboseName "Seq.LemmaFlattenReverseConcat (well-formedness)"} {:_induction a#0, b#0} CheckWellFormed$$Seq.__default.LemmaFlattenReverseConcat(Seq._default.LemmaFlattenReverseConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap));
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaFlattenReverseConcat (call)"} {:_induction a#0, b#0} Call$$Seq.__default.LemmaFlattenReverseConcat(Seq._default.LemmaFlattenReverseConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0))
     && 
    Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0)
     && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
  ensures Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), a#0), 
      Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaFlattenReverseConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaFlattenReverseConcat(Seq._default.LemmaFlattenReverseConcat$T: Ty, 
    a#0: Seq Box
       where $Is(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(a#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
         && $IsAlloc(b#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap))
   returns ($_reverifyPost: bool);
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0))
     && 
    Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0)
     && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
  ensures Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), a#0), 
      Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaFlattenReverseConcat (correctness)"} {:_induction a#0, b#0} Impl$$Seq.__default.LemmaFlattenReverseConcat(Seq._default.LemmaFlattenReverseConcat$T: Ty, a#0: Seq Box, b#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var ##s#0_0: Seq Box;
  var ##s#1_0_0_0: Seq Box;
  var ##s#1_0_0_1: Seq Box;
  var ##s#1_0_0_2: Seq Box;
  var ##s#1_0_0_3: Seq Box;
  var ##s#1_0_0_4: Seq Box;
  var ##s#1_0_0_5: Seq Box;
  var ##s#1_0_1_0: Seq Box;
  var ##s#1_0_1_1: Seq Box;
  var ##s#1_0_1_2: Seq Box;
  var ##s#1_0_1_3: Seq Box;
  var ##s#1_0_1_4: Seq Box;
  var ##s#1_0_1_5: Seq Box;
  var ##s#1_0_1_6: Seq Box;
  var ##s#1_0_2_0: Seq Box;
  var ##s#1_0_2_1: Seq Box;
  var ##s#1_0_2_2: Seq Box;
  var ##s#1_0_2_3: Seq Box;
  var ##s#1_0_2_4: Seq Box;
  var ##s#1_0_2_5: Seq Box;
  var ##s#1_0_2_6: Seq Box;
  var ##s#1_0_2_7: Seq Box;
  var ##s#1_0_0: Seq Box;

    // AddMethodImpl: LemmaFlattenReverseConcat, Impl$$Seq.__default.LemmaFlattenReverseConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#a0#0: Seq Box, $ih#b0#0: Seq Box :: 
      $Is($ih#a0#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
           && $Is($ih#b0#0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)))
           && Lit(true)
           && (Seq#Rank($ih#a0#0) < Seq#Rank(a#0)
             || (Seq#Rank($ih#a0#0) == Seq#Rank(a#0) && Seq#Rank($ih#b0#0) < Seq#Rank(b#0)))
         ==> Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, 
            $LS($LZ), 
            Seq#Append($ih#a0#0, $ih#b0#0)), 
          Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), $ih#a0#0), 
            Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), $ih#b0#0))));
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(511,5)
    assume true;
    if (Seq#Length(b#0) == LitInt(0))
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(512,7)
        ##s#0_0 := b#0;
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#0_0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
        assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
        assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
        assert {:subsumption 0} Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), b#0), 
          Seq#Empty(): Seq Box);
        assume Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), b#0), 
          Seq#Empty(): Seq Box);
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(513,7)
        assume true;
        assert Seq#Equal(Seq#Append(a#0, b#0), a#0);
    }
    else
    {
        // ----- calc statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
        // Assume Fuel Constant
        if (*)
        {
            // ----- assert wf[initial] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0));
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_2_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0));
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, Seq#Append(a#0, b#0));
            // ----- Hint0 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(517,13)
            ##s#1_0_2_1 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_1, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_1) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0));
            ##s#1_0_2_2 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_2, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assert Seq#Equal($Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0))): Seq Box, 
              $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)): Seq Box);
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(517,45)
            ##s#1_0_2_3 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_3, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_3) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0));
            ##s#1_0_2_4 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_4, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_4) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0))
               && Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assert Seq#Equal(Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), Seq#Append(a#0, b#0)), 
              Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)));
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_2_5 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_5, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_5) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            ##s#1_0_2_6 := Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_6, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
              Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)));
            ##s#1_0_2_7 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_7, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_7) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
                Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // ----- assert line0 == line1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            assert {:subsumption 0} Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), Seq#Append(a#0, b#0)), 
              Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, 
                  $LS($LS($LZ)), 
                  Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)): Seq Box));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_1_0 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_1_0) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            ##s#1_0_1_1 := Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_1, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
              Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)));
            ##s#1_0_1_2 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_2, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_1_2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
                Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // ----- Hint1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_1_3 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_3, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0);
            ##s#1_0_1_4 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_4, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_1_4) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            ##s#1_0_1_5 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_5, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0));
            ##s#1_0_1_6 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_6, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_1_6) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0)
               && 
              Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // ----- assert line1 == line2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, 
                  $LS($LS($LZ)), 
                  Seq#Append(a#0, Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)): Seq Box), 
              Seq#Append(Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), a#0), 
                  Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, 
                    $LS($LS($LZ)), 
                    Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)): Seq Box));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_0_0 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_0, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0);
            ##s#1_0_0_1 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_1, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_0_1) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            ##s#1_0_0_2 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_2, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0));
            ##s#1_0_0_3 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_3, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_0_3) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0)
               && 
              Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0);
            // ----- Hint2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            ##s#1_0_0_4 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_4, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0);
            ##s#1_0_0_5 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_5, TSeq(TSeq(Seq._default.LemmaFlattenReverseConcat$T)), $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, a#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenReverseConcat$T, b#0);
            // ----- assert line2 == line3 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(515,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), a#0), 
                  Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, 
                    $LS($LS($LZ)), 
                    Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0))), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenReverseConcat$T), b#0)): Seq Box), 
              Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), a#0), 
                Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LS($LZ)), b#0)));
            assume false;
        }

        assume Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), Seq#Append(a#0, b#0)), 
          Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), a#0), 
            Seq.__default.FlattenReverse(Seq._default.LemmaFlattenReverseConcat$T, $LS($LZ), b#0)));
    }
}



procedure {:verboseName "Seq.LemmaFlattenAndFlattenReverseAreEquivalent (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)))
         && $IsAlloc(s#0, 
          TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
          $Heap));
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;



procedure {:verboseName "Seq.LemmaFlattenAndFlattenReverseAreEquivalent (call)"} {:_induction s#0} Call$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)))
         && $IsAlloc(s#0, 
          TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
          $Heap));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0)
     && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
  ensures Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0), 
    Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaFlattenAndFlattenReverseAreEquivalent (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)))
         && $IsAlloc(s#0, 
          TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
          $Heap))
   returns ($_reverifyPost: bool);
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0)
     && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
  ensures Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0), 
    Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaFlattenAndFlattenReverseAreEquivalent (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T: Ty, s#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var ##s#1_0_0_0: Seq Box;
  var ##s#1_0_0_1: Seq Box;
  var ##s#1_0_0_2: Seq Box;
  var ##s#1_0_0_3: Seq Box;
  var a##1_0_0_0: Seq Box;
  var ##s#1_0_0_4: Seq Box;
  var b##1_0_0_0: Seq Box;
  var ##s#1_0_0_5: Seq Box;
  var ##s#1_0_0_6: Seq Box;
  var ##s#1_0_0_7: Seq Box;
  var ##s#1_0_0_8: Seq Box;
  var ##s#1_0_1_0: Seq Box;
  var ##s#1_0_1_1: Seq Box;
  var ##s#1_0_1_2: Seq Box;
  var ##s#1_0_1_3: Seq Box;
  var ##s#1_0_1_4: Seq Box;
  var ##s#1_0_1_5: Seq Box;
  var ##s#1_0_1_6: Seq Box;
  var ##s#1_0_2_0: Seq Box;
  var ##s#1_0_2_1: Seq Box;
  var ##s#1_0_2_2: Seq Box;
  var s##1_0_2_0: Seq Box;
  var ##s#1_0_2_3: Seq Box;
  var ##s#1_0_2_4: Seq Box;
  var ##s#1_0_2_5: Seq Box;
  var ##s#1_0_2_6: Seq Box;
  var ##s#1_0_3_0: Seq Box;
  var ##s#1_0_3_1: Seq Box;
  var ##s#1_0_3_2: Seq Box;
  var ##s#1_0_3_3: Seq Box;
  var ##s#1_0_0: Seq Box;

    // AddMethodImpl: LemmaFlattenAndFlattenReverseAreEquivalent, Impl$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)))
           && Lit(true)
           && Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
         ==> Seq#Equal(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LZ), $ih#s0#0), 
          Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LZ), $ih#s0#0)));
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(530,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- calc statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
        // Assume Fuel Constant
        if (*)
        {
            // ----- assert wf[initial] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_3_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_3_0, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            // ----- Hint0 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_3_1 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_3_1, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_3_1) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_3_2 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_3_2, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_3_3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_3_3, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_3_3) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ----- assert line0 == line1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            assert {:subsumption 0} Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0), 
              Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)): Seq Box));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_2_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_0, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_2_0) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_2_1 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_1, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_2_2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_2, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_2_2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ----- Hint1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(535,55)
            // TrCallStmt: Before ProcessCallStmt
            ##s#1_0_2_3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_3, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_3) > 0;
            assume Seq#Length(##s#1_0_2_3) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ProcessCallStmt: CheckSubrange
            s##1_0_2_0 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assert Seq#Rank(s##1_0_2_0) < Seq#Rank(s#0);
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.LemmaFlattenAndFlattenReverseAreEquivalent(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s##1_0_2_0);
            // TrCallStmt: After ProcessCallStmt
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_2_4 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_4, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_4) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_2_5 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_5, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_2_6 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_6, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_2_6) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ----- assert line1 == line2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)): Seq Box), 
              Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)): Seq Box));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_1_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_0, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_1_0) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_1_1 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_1, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_1_2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_2, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_1_2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ----- Hint2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_1_3 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_3, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_1_3) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_1_4 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_4, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_1_5 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_5, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_1_5) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_1_6 := Seq#Build(Seq#Empty(): Seq Box, 
              Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_6, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq#Build(Seq#Empty(): Seq Box, 
                Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)));
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && 
              Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq#Build(Seq#Empty(): Seq Box, 
                  Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)));
            // ----- assert line2 == line3 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                $Unbox(Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)): Seq Box), 
              Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq#Build(Seq#Empty(): Seq Box, 
                    Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)))));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_0_0 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_0, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_0_0) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_0_1 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_1, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            ##s#1_0_0_2 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_2, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume {:subsumption 0} Seq#Length(##s#1_0_0_2) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_0_3 := Seq#Build(Seq#Empty(): Seq Box, 
              Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_3, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
              Seq#Build(Seq#Empty(): Seq Box, 
                Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)));
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))
               && 
              Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                Seq#Build(Seq#Empty(): Seq Box, 
                  Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)));
            // ----- Hint3 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(538,31)
            // TrCallStmt: Before ProcessCallStmt
            ##s#1_0_0_4 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_4, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_0_4) > 0;
            assume Seq#Length(##s#1_0_0_4) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ProcessCallStmt: CheckSubrange
            a##1_0_0_0 := Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_0_5 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_5, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_0_5) > 0;
            assume Seq#Length(##s#1_0_0_5) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            // ProcessCallStmt: CheckSubrange
            b##1_0_0_0 := Seq#Build(Seq#Empty(): Seq Box, 
              Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0));
            // ProcessCallStmt: Make the call
            call Call$$Seq.__default.LemmaFlattenConcat(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, a##1_0_0_0, b##1_0_0_0);
            // TrCallStmt: After ProcessCallStmt
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(539,9)
            ##s#1_0_0_6 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_6, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_0_6) > 0;
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            ##s#1_0_0_7 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_7, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assert {:subsumption 0} Seq#Length(##s#1_0_0_7) > 0;
            assume Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assume Seq.__default.DropLast#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)
               && Seq.__default.Last#canCall(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0);
            assert Seq#Equal(s#0, 
              Seq#Append(Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0), 
                Seq#Build(Seq#Empty(): Seq Box, 
                  Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0))));
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            ##s#1_0_0_8 := s#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_8, 
              TSeq(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T)), 
              $Heap);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            assume Seq.__default.Flatten#canCall(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, s#0);
            // ----- assert line3 == line4 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(532,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq.__default.DropLast(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)), 
                Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, 
                  $LS($LS($LZ)), 
                  Seq#Build(Seq#Empty(): Seq Box, 
                    Seq.__default.Last(TSeq(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T), s#0)))), 
              Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LS($LZ)), s#0));
            assume false;
        }

        assume Seq#Equal(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LZ), s#0), 
          Seq.__default.Flatten(Seq._default.LemmaFlattenAndFlattenReverseAreEquivalent$T, $LS($LZ), s#0));
    }
}



procedure {:verboseName "Seq.LemmaFlattenLengthGeSingleElementLength (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)), $Heap), 
    i#0: int);
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaFlattenLengthGeSingleElementLength (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T: Ty, 
    s#0: Seq Box, 
    i#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var ##s#0: Seq Box;

    // AddMethodImpl: LemmaFlattenLengthGeSingleElementLength, CheckWellFormed$$Seq.__default.LemmaFlattenLengthGeSingleElementLength
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    if (LitInt(0) <= i#0)
    {
    }

    assume LitInt(0) <= i#0 && i#0 < Seq#Length(s#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)), $Heap);
    assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, s#0);
    assert 0 <= i#0 && i#0 < Seq#Length(s#0);
    assume Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, $LS($LZ), s#0))
       >= Seq#Length($Unbox(Seq#Index(s#0, i#0)): Seq Box);
}



procedure {:verboseName "Seq.LemmaFlattenLengthGeSingleElementLength (call)"} {:_induction s#0} Call$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)), $Heap), 
    i#0: int);
  // user-defined preconditions
  requires LitInt(0) <= i#0;
  requires i#0 < Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, s#0);
  ensures Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, $LS($LS($LZ)), s#0))
     >= Seq#Length($Unbox(Seq#Index(s#0, i#0)): Seq Box);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaFlattenLengthGeSingleElementLength (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)), $Heap), 
    i#0: int)
   returns ($_reverifyPost: bool);
  free requires 2 == $FunctionContextHeight;
  // user-defined preconditions
  requires LitInt(0) <= i#0;
  requires i#0 < Seq#Length(s#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, s#0);
  ensures Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, $LS($LS($LZ)), s#0))
     >= Seq#Length($Unbox(Seq#Index(s#0, i#0)): Seq Box);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaFlattenLengthGeSingleElementLength (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T: Ty, 
    s#0: Seq Box, 
    i#0: int)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var s##0_0: Seq Box;
  var i##0_0: int;

    // AddMethodImpl: LemmaFlattenLengthGeSingleElementLength, Impl$$Seq.__default.LemmaFlattenLengthGeSingleElementLength
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthGeSingleElementLength$T)))
           && 
          LitInt(0) <= i#0
           && i#0 < Seq#Length($ih#s0#0)
           && (Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
             || (Seq#Rank($ih#s0#0) == Seq#Rank(s#0) && 0 <= i#0 && i#0 < i#0))
         ==> Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, $LS($LZ), $ih#s0#0))
           >= Seq#Length($Unbox(Seq#Index($ih#s0#0, i#0)): Seq Box));
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(551,5)
    assume true;
    if (i#0 < Seq#Length(s#0) - 1)
    {
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(552,46)
        // TrCallStmt: Before ProcessCallStmt
        assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
        assume true;
        // ProcessCallStmt: CheckSubrange
        s##0_0 := Seq#Take(s#0, Seq#Length(s#0) - 1);
        assume true;
        // ProcessCallStmt: CheckSubrange
        i##0_0 := i#0;
        assert 0 <= i#0 || Seq#Rank(s##0_0) < Seq#Rank(s#0) || i##0_0 == i#0;
        assert Seq#Rank(s##0_0) < Seq#Rank(s#0)
           || (Seq#Rank(s##0_0) == Seq#Rank(s#0) && i##0_0 < i#0);
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaFlattenLengthGeSingleElementLength(Seq._default.LemmaFlattenLengthGeSingleElementLength$T, s##0_0, i##0_0);
        // TrCallStmt: After ProcessCallStmt
    }
    else
    {
    }
}



procedure {:verboseName "Seq.LemmaFlattenLengthLeMul (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)), $Heap), 
    j#0: int);
  free requires 2 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaFlattenLengthLeMul (well-formedness)"} {:_induction s#0} CheckWellFormed$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T: Ty, s#0: Seq Box, j#0: int)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#0: int;
  var ##s#0: Seq Box;

    // AddMethodImpl: LemmaFlattenLengthLeMul, CheckWellFormed$$Seq.__default.LemmaFlattenLengthLeMul
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    havoc i#0;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#0)
        {
        }

        assume LitInt(0) <= i#0 && i#0 < Seq#Length(s#0);
        assert 0 <= i#0 && i#0 < Seq#Length(s#0);
        assume Seq#Length($Unbox(Seq#Index(s#0, i#0)): Seq Box) <= j#0;
    }
    else
    {
        assume LitInt(0) <= i#0 && i#0 < Seq#Length(s#0)
           ==> Seq#Length($Unbox(Seq#Index(s#0, i#0)): Seq Box) <= j#0;
    }

    assume (forall i#1: int :: 
      { $Unbox(Seq#Index(s#0, i#1)): Seq Box } 
      LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
         ==> Seq#Length($Unbox(Seq#Index(s#0, i#1)): Seq Box) <= j#0);
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##s#0 := s#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)), $Heap);
    assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthLeMul$T, s#0);
    assume Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, $LS($LZ), s#0))
       <= Mul(Seq#Length(s#0), j#0);
}



procedure {:verboseName "Seq.LemmaFlattenLengthLeMul (call)"} {:_induction s#0} Call$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)), $Heap), 
    j#0: int);
  // user-defined preconditions
  requires (forall i#1: int :: 
    { $Unbox(Seq#Index(s#0, i#1)): Seq Box } 
    LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> Seq#Length($Unbox(Seq#Index(s#0, i#1)): Seq Box) <= j#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthLeMul$T, s#0);
  ensures Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, $LS($LS($LZ)), s#0))
     <= Mul(Seq#Length(s#0), j#0);
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaFlattenLengthLeMul (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T: Ty, 
    s#0: Seq Box
       where $Is(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)))
         && $IsAlloc(s#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)), $Heap), 
    j#0: int)
   returns ($_reverifyPost: bool);
  free requires 2 == $FunctionContextHeight;
  // user-defined preconditions
  requires (forall i#1: int :: 
    { $Unbox(Seq#Index(s#0, i#1)): Seq Box } 
    LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
       ==> Seq#Length($Unbox(Seq#Index(s#0, i#1)): Seq Box) <= j#0);
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthLeMul$T, s#0);
  ensures Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, $LS($LS($LZ)), s#0))
     <= Mul(Seq#Length(s#0), j#0);
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaFlattenLengthLeMul (correctness)"} {:_induction s#0} Impl$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T: Ty, s#0: Seq Box, j#0: int)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var s##1_0: Seq Box;
  var j##1_0: int;
  var ##s#1_0: Seq Box;

    // AddMethodImpl: LemmaFlattenLengthLeMul, Impl$$Seq.__default.LemmaFlattenLengthLeMul
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#s0#0: Seq Box :: 
      $Is($ih#s0#0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)))
           && (forall i#2: int :: 
            { $Unbox(Seq#Index($ih#s0#0, i#2)): Seq Box } 
            LitInt(0) <= i#2 && i#2 < Seq#Length($ih#s0#0)
               ==> Seq#Length($Unbox(Seq#Index($ih#s0#0, i#2)): Seq Box) <= j#0)
           && (Seq#Rank($ih#s0#0) < Seq#Rank(s#0)
             || (Seq#Rank($ih#s0#0) == Seq#Rank(s#0) && 0 <= j#0 && j#0 < j#0))
         ==> Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, $LS($LZ), $ih#s0#0))
           <= Mul(Seq#Length($ih#s0#0), j#0));
    $_reverifyPost := false;
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(563,5)
    assume true;
    if (Seq#Length(s#0) == LitInt(0))
    {
    }
    else
    {
        // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(565,30)
        // TrCallStmt: Before ProcessCallStmt
        assert 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
        assume true;
        // ProcessCallStmt: CheckSubrange
        s##1_0 := Seq#Take(s#0, Seq#Length(s#0) - 1);
        assume true;
        // ProcessCallStmt: CheckSubrange
        j##1_0 := j#0;
        assert 0 <= j#0 || Seq#Rank(s##1_0) < Seq#Rank(s#0) || j##1_0 == j#0;
        assert Seq#Rank(s##1_0) < Seq#Rank(s#0)
           || (Seq#Rank(s##1_0) == Seq#Rank(s#0) && j##1_0 < j#0);
        // ProcessCallStmt: Make the call
        call Call$$Seq.__default.LemmaFlattenLengthLeMul(Seq._default.LemmaFlattenLengthLeMul$T, s##1_0, j##1_0);
        // TrCallStmt: After ProcessCallStmt
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(566,7)
        assert {:subsumption 0} 0 <= Seq#Length(s#0) - 1 && Seq#Length(s#0) - 1 <= Seq#Length(s#0);
        ##s#1_0 := Seq#Take(s#0, Seq#Length(s#0) - 1);
        // assume allocatedness for argument to function
        assume $IsAlloc(##s#1_0, TSeq(TSeq(Seq._default.LemmaFlattenLengthLeMul$T)), $Heap);
        assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthLeMul$T, Seq#Take(s#0, Seq#Length(s#0) - 1));
        assume Seq.__default.FlattenReverse#canCall(Seq._default.LemmaFlattenLengthLeMul$T, Seq#Take(s#0, Seq#Length(s#0) - 1));
        assert {:subsumption 0} {:split_here} Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, 
              $LS($LS($LZ)), 
              Seq#Take(s#0, Seq#Length(s#0) - 1)))
           <= Mul(Seq#Length(s#0) - 1, j#0);
        assume Seq#Length(Seq.__default.FlattenReverse(Seq._default.LemmaFlattenLengthLeMul$T, 
              $LS($LZ), 
              Seq#Take(s#0, Seq#Length(s#0) - 1)))
           <= Mul(Seq#Length(s#0) - 1, j#0);
    }
}



// function declaration for Seq._default.Map
function Seq.__default.Map(Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $ly: LayerType, 
    $heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box)
   : Seq Box;

function Seq.__default.Map#canCall(Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box)
   : bool;

// layer synonym axiom
axiom (forall Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $LS($ly), $Heap, f#0, s#0) } 
  Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $LS($ly), $Heap, f#0, s#0)
     == Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0));

// fuel synonym axiom
axiom (forall Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, AsFuelBottom($ly), $Heap, f#0, s#0) } 
  Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0)
     == Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $LZ, $Heap, f#0, s#0));

// frame axiom for Seq.__default.Map
axiom (forall Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $ly: LayerType, 
    $h0: Heap, 
    $h1: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { $IsHeapAnchor($h0), $HeapSucc($h0, $h1), Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $h1, f#0, s#0) } 
  $IsGoodHeap($h0)
       && $IsGoodHeap($h1)
       && (Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $h0, f#0, s#0)
         || ($Is(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R))
           && $Is(s#0, TSeq(Seq._default.Map$T))))
       && 
      $IsHeapAnchor($h0)
       && $HeapSucc($h0, $h1)
     ==> 
    (forall<alpha> $o: ref, $f: Field alpha :: 
      $o != null
           && (exists i#0: int, o#0: ref :: 
            { Reads1(Seq._default.Map$T, Seq._default.Map$R, $h0, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
            $Is(o#0, Tclass._System.object?())
               && 
              LitInt(0) <= i#0
               && i#0 < Seq#Length(s#0)
               && Reads1(Seq._default.Map$T, Seq._default.Map$R, $h0, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
               && $Box($o) == $Box(o#0))
         ==> read($h0, $o, $f) == read($h1, $o, $f))
     ==> Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $h0, f#0, s#0)
       == Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $h1, f#0, s#0));

// consequence axiom for Seq.__default.Map
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Map$T: Ty, 
      Seq._default.Map$R: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0) } 
    Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R))
           && $Is(s#0, TSeq(Seq._default.Map$T))
           && (forall i#1: int :: 
            { Seq#Index(s#0, i#1) } 
            true
               ==> 
              LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
               ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#1))))
       ==> Seq#Length(Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0))
           == Seq#Length(s#0)
         && (forall i#2: int :: 
          { Seq#Index(Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0), 
              i#2) } 
          true
             ==> 
            LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
             ==> Seq#Index(Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0), 
                i#2)
               == Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#2)))
         && $Is(Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0), 
          TSeq(Seq._default.Map$R)));

function Seq.__default.Map#requires(Ty, Ty, LayerType, Heap, HandleType, Seq Box) : bool;

// #requires axiom for Seq.__default.Map
axiom (forall Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Map#requires(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0), $IsGoodHeap($Heap) } 
  $IsGoodHeap($Heap)
       && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R))
       && $Is(s#0, TSeq(Seq._default.Map$T))
     ==> Seq.__default.Map#requires(Seq._default.Map$T, Seq._default.Map$R, $ly, $Heap, f#0, s#0)
       == (forall i#3: int :: 
        { Seq#Index(s#0, i#3) } 
        true
           ==> 
          LitInt(0) <= i#3 && i#3 < Seq#Length(s#0)
           ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#3))));

// definition axiom for Seq.__default.Map (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Map$T: Ty, 
      Seq._default.Map$R: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $LS($ly), $Heap, f#0, s#0), $IsGoodHeap($Heap) } 
    Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R))
           && $Is(s#0, TSeq(Seq._default.Map$T))
           && (forall i#3: int :: 
            { Seq#Index(s#0, i#3) } 
            true
               ==> 
              LitInt(0) <= i#3 && i#3 < Seq#Length(s#0)
               ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#3))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Drop(s#0, LitInt(1))))
         && Seq.__default.Map(Seq._default.Map$T, Seq._default.Map$R, $LS($ly), $Heap, f#0, s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append(Seq#Build(Seq#Empty(): Seq Box, 
                Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, LitInt(0)))), 
              Seq.__default.Map(Seq._default.Map$T, 
                Seq._default.Map$R, 
                $ly, 
                $Heap, 
                f#0, 
                Seq#Drop(s#0, LitInt(1))))));

procedure {:verboseName "Seq.Map (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Map(Seq._default.Map$T: Ty, 
    Seq._default.Map$R: Ty, 
    f#0: HandleType
       where $Is(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R)), 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Map$T)))
   returns (result#0: Seq Box where $Is(result#0, TSeq(Seq._default.Map$R)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(result#0) == Seq#Length(s#0);
  ensures (forall i#4: int :: 
    { Seq#Index(result#0, i#4) } 
    true
       ==> 
      LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
       ==> Seq#Index(result#0, i#4)
         == Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#4)));



implementation {:verboseName "Seq.Map (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Map(Seq._default.Map$T: Ty, Seq._default.Map$R: Ty, f#0: HandleType, s#0: Seq Box)
   returns (result#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#5: int;
  var ##x0#0: Box;
  var b$reqreads#0: bool;
  var i#7: int;
  var o#1: ref;
  var ##x0#1: Box;
  var b$reqreads#1: bool;
  var i#8: int;
  var o#2: ref;
  var ##x0#2: Box;
  var i#9: int;
  var ##f#0: HandleType;
  var ##s#0: Seq Box;
  var b$reqreads#2: bool;
  var b$reqreads#3: bool;

    b$reqreads#0 := true;
    b$reqreads#1 := true;
    b$reqreads#2 := true;
    b$reqreads#3 := true;

    // AddWellformednessCheck for function Map
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc)
         ==> (exists i#0: int, o#0: ref :: 
          { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
          $Is(o#0, Tclass._System.object?())
             && 
            LitInt(0) <= i#0
             && i#0 < Seq#Length(s#0)
             && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
             && $Box($o) == $Box(o#0)));
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    havoc i#5;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#5)
        {
        }

        assume LitInt(0) <= i#5 && i#5 < Seq#Length(s#0);
        // assume allocatedness for receiver argument to function
        assume $IsAlloc(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R), $Heap);
        assert 0 <= i#5 && i#5 < Seq#Length(s#0);
        ##x0#0 := Seq#Index(s#0, i#5);
        // assume allocatedness for argument to function
        assume $IsAllocBox(##x0#0, Seq._default.Map$T, $Heap);
        b$reqreads#0 := (forall<alpha> $o: ref, $f: Field alpha :: 
          $o != null
               && read($Heap, $o, alloc)
               && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, ##x0#0)[$Box($o)]
             ==> $_Frame[$o, $f]);
        assume Requires1#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#5));
        assume Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#5));
    }
    else
    {
        assume LitInt(0) <= i#5 && i#5 < Seq#Length(s#0)
           ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#5));
    }

    assume (forall i#6: int :: 
      { Seq#Index(s#0, i#6) } 
      true
         ==> 
        LitInt(0) <= i#6 && i#6 < Seq#Length(s#0)
         ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#6)));
    assert b$reqreads#0;
    // Begin Comprehension WF check
    havoc i#7;
    havoc o#1;
    if ($Is(o#1, Tclass._System.object?())
       && $IsAlloc(o#1, Tclass._System.object?(), $Heap))
    {
        if (LitInt(0) <= i#7)
        {
        }

        if (LitInt(0) <= i#7 && i#7 < Seq#Length(s#0))
        {
            // assume allocatedness for receiver argument to function
            assume $IsAlloc(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R), $Heap);
            assert 0 <= i#7 && i#7 < Seq#Length(s#0);
            ##x0#1 := Seq#Index(s#0, i#7);
            // assume allocatedness for argument to function
            assume $IsAllocBox(##x0#1, Seq._default.Map$T, $Heap);
            b$reqreads#1 := (forall<alpha> $o: ref, $f: Field alpha :: 
              $o != null
                   && read($Heap, $o, alloc)
                   && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, ##x0#1)[$Box($o)]
                 ==> $_Frame[$o, $f]);
            assume Reads1#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#7));
        }

        if (LitInt(0) <= i#7
           && i#7 < Seq#Length(s#0)
           && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#7))[$Box(o#1)])
        {
        }
    }

    // End Comprehension WF check
    assert b$reqreads#1;
    // Begin Comprehension WF check
    havoc i#8;
    havoc o#2;
    if ($Is(o#2, Tclass._System.object?())
       && $IsAlloc(o#2, Tclass._System.object?(), $Heap))
    {
        if (LitInt(0) <= i#8)
        {
        }

        if (LitInt(0) <= i#8 && i#8 < Seq#Length(s#0))
        {
            // assume allocatedness for receiver argument to function
            assume $IsAlloc(f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R), $Heap);
            assert 0 <= i#8 && i#8 < Seq#Length(s#0);
            ##x0#2 := Seq#Index(s#0, i#8);
            // assume allocatedness for argument to function
            assume $IsAllocBox(##x0#2, Seq._default.Map$T, $Heap);
            assume Reads1#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#8));
        }

        if (LitInt(0) <= i#8
           && i#8 < Seq#Length(s#0)
           && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#8))[$Box(o#2)])
        {
        }
    }

    // End Comprehension WF check
    if (*)
    {
        assume $Is(Seq.__default.Map(Seq._default.Map$T, 
            Seq._default.Map$R, 
            StartFuel_Seq._default.Map, 
            $Heap, 
            f#0, 
            s#0), 
          TSeq(Seq._default.Map$R));
        assume Seq#Length(result#0) == Seq#Length(s#0);
        havoc i#9;
        assume true;
        if (*)
        {
            if (LitInt(0) <= i#9)
            {
            }

            assume LitInt(0) <= i#9 && i#9 < Seq#Length(s#0);
            assert 0 <= i#9 && i#9 < Seq#Length(result#0);
            assert 0 <= i#9 && i#9 < Seq#Length(s#0);
            assert Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#9));
            assume Seq#Index(result#0, i#9)
               == Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#9));
        }
        else
        {
            assume LitInt(0) <= i#9 && i#9 < Seq#Length(s#0)
               ==> Seq#Index(result#0, i#9)
                 == Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#9));
        }

        assume (forall i#4: int :: 
          { Seq#Index(result#0, i#4) } 
          true
             ==> 
            LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
             ==> Seq#Index(result#0, i#4)
               == Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#4)));
        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc)
             ==> (exists i#0: int, o#0: ref :: 
              { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
              $Is(o#0, Tclass._System.object?())
                 && 
                LitInt(0) <= i#0
                 && i#0 < Seq#Length(s#0)
                 && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
                 && $Box($o) == $Box(o#0)));
        if (Seq#Length(s#0) == LitInt(0))
        {
            assume Seq.__default.Map(Seq._default.Map$T, 
                Seq._default.Map$R, 
                StartFuel_Seq._default.Map, 
                $Heap, 
                f#0, 
                s#0)
               == Lit(Seq#Empty(): Seq Box);
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Map(Seq._default.Map$T, 
                Seq._default.Map$R, 
                StartFuel_Seq._default.Map, 
                $Heap, 
                f#0, 
                s#0), 
              TSeq(Seq._default.Map$R));
        }
        else
        {
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assert Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, LitInt(0)));
            b$reqreads#2 := (forall<alpha> $o: ref, $f: Field alpha :: 
              $o != null
                   && read($Heap, $o, alloc)
                   && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, LitInt(0)))[$Box($o)]
                 ==> $_Frame[$o, $f]);
            assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
            ##f#0 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#0, Tclass._System.___hFunc1(Seq._default.Map$T, Seq._default.Map$R), $Heap);
            ##s#0 := Seq#Drop(s#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#0, TSeq(Seq._default.Map$T), $Heap);
            assert {:subsumption 0} (forall i#10: int :: 
              { Seq#Index(##s#0, i#10) } 
              true
                 ==> 
                LitInt(0) <= i#10 && i#10 < Seq#Length(##s#0)
                 ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#10)));
            assume (forall i#10: int :: 
              { Seq#Index(##s#0, i#10) } 
              true
                 ==> 
                LitInt(0) <= i#10 && i#10 < Seq#Length(##s#0)
                 ==> Requires1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#10)));
            b$reqreads#3 := (forall<alpha> $o: ref, $f: Field alpha :: 
              $o != null
                   && read($Heap, $o, alloc)
                   && (exists i#11: int, o#3: ref :: 
                    { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#11))[$Box(o#3)] } 
                    $Is(o#3, Tclass._System.object?())
                       && 
                      LitInt(0) <= i#11
                       && i#11 < Seq#Length(##s#0)
                       && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#11))[$Box(o#3)]
                       && $Box($o) == $Box(o#3))
                 ==> $_Frame[$o, $f]);
            assert (Set#Subset((lambda $y#0: Box :: 
                    (exists i#12: int, o#4: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                      $Is(o#4, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#12
                         && i#12 < Seq#Length(##s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)]
                         && $y#0 == $Box(o#4))), 
                  (lambda $y#1: Box :: 
                    (exists i#0: int, o#0: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
                      $Is(o#0, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#0
                         && i#0 < Seq#Length(s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
                         && $y#1 == $Box(o#0))))
                 && !Set#Subset((lambda $y#1: Box :: 
                    (exists i#0: int, o#0: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
                      $Is(o#0, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#0
                         && i#0 < Seq#Length(s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
                         && $y#1 == $Box(o#0))), 
                  (lambda $y#0: Box :: 
                    (exists i#12: int, o#4: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                      $Is(o#4, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#12
                         && i#12 < Seq#Length(##s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)]
                         && $y#0 == $Box(o#4)))))
               || (Set#Equal((lambda $y#0: Box :: 
                    (exists i#12: int, o#4: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                      $Is(o#4, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#12
                         && i#12 < Seq#Length(##s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, ##f#0, Seq#Index(##s#0, i#12))[$Box(o#4)]
                         && $y#0 == $Box(o#4))), 
                  (lambda $y#1: Box :: 
                    (exists i#0: int, o#0: ref :: 
                      { Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)] } 
                      $Is(o#0, Tclass._System.object?())
                         && 
                        LitInt(0) <= i#0
                         && i#0 < Seq#Length(s#0)
                         && Reads1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, i#0))[$Box(o#0)]
                         && $y#1 == $Box(o#0))))
                 && Seq#Rank(##s#0) < Seq#Rank(s#0));
            assume Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Drop(s#0, LitInt(1)));
            assume Seq.__default.Map(Seq._default.Map$T, 
                Seq._default.Map$R, 
                StartFuel_Seq._default.Map, 
                $Heap, 
                f#0, 
                s#0)
               == Seq#Append(Seq#Build(Seq#Empty(): Seq Box, 
                  Apply1(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Index(s#0, LitInt(0)))), 
                Seq.__default.Map(Seq._default.Map$T, 
                  Seq._default.Map$R, 
                  StartFuel_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  Seq#Drop(s#0, LitInt(1))));
            assume Seq.__default.Map#canCall(Seq._default.Map$T, Seq._default.Map$R, $Heap, f#0, Seq#Drop(s#0, LitInt(1)));
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.Map(Seq._default.Map$T, 
                Seq._default.Map$R, 
                StartFuel_Seq._default.Map, 
                $Heap, 
                f#0, 
                s#0), 
              TSeq(Seq._default.Map$R));
        }

        assume Seq.__default.Map(Seq._default.Map$T, 
            Seq._default.Map$R, 
            StartFuel_Seq._default.Map, 
            $Heap, 
            f#0, 
            s#0)
           == result#0;
        assert b$reqreads#2;
        assert b$reqreads#3;
    }
}



// function declaration for Seq._default.MapWithResult
function Seq.__default.MapWithResult(Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $ly: LayerType, 
    $heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box)
   : DatatypeType;

function Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box)
   : bool;

// layer synonym axiom
axiom (forall Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $LS($ly), 
      $Heap, 
      f#0, 
      s#0) } 
  Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $LS($ly), 
      $Heap, 
      f#0, 
      s#0)
     == Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $ly, 
      $Heap, 
      f#0, 
      s#0));

// fuel synonym axiom
axiom (forall Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      AsFuelBottom($ly), 
      $Heap, 
      f#0, 
      s#0) } 
  Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $ly, 
      $Heap, 
      f#0, 
      s#0)
     == Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $LZ, 
      $Heap, 
      f#0, 
      s#0));

function Tclass.Wrappers.Result(Ty, Ty) : Ty;

const unique Tagclass.Wrappers.Result: TyTag;

// Tclass.Wrappers.Result Tag
axiom (forall Wrappers.Result$T: Ty, Wrappers.Result$R: Ty :: 
  { Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R) } 
  Tag(Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R))
       == Tagclass.Wrappers.Result
     && TagFamily(Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R))
       == tytagFamily$Result);

function Tclass.Wrappers.Result_0(Ty) : Ty;

// Tclass.Wrappers.Result injectivity 0
axiom (forall Wrappers.Result$T: Ty, Wrappers.Result$R: Ty :: 
  { Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R) } 
  Tclass.Wrappers.Result_0(Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R))
     == Wrappers.Result$T);

function Tclass.Wrappers.Result_1(Ty) : Ty;

// Tclass.Wrappers.Result injectivity 1
axiom (forall Wrappers.Result$T: Ty, Wrappers.Result$R: Ty :: 
  { Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R) } 
  Tclass.Wrappers.Result_1(Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R))
     == Wrappers.Result$R);

// Box/unbox axiom for Tclass.Wrappers.Result
axiom (forall Wrappers.Result$T: Ty, Wrappers.Result$R: Ty, bx: Box :: 
  { $IsBox(bx, Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R)) } 
  $IsBox(bx, Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R))
     ==> $Box($Unbox(bx): DatatypeType) == bx
       && $Is($Unbox(bx): DatatypeType, 
        Tclass.Wrappers.Result(Wrappers.Result$T, Wrappers.Result$R)));

// frame axiom for Seq.__default.MapWithResult
axiom (forall Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $ly: LayerType, 
    $h0: Heap, 
    $h1: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { $IsHeapAnchor($h0), $HeapSucc($h0, $h1), Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $ly, 
      $h1, 
      f#0, 
      s#0) } 
  $IsGoodHeap($h0)
       && $IsGoodHeap($h1)
       && (Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
          Seq._default.MapWithResult$R, 
          Seq._default.MapWithResult$E, 
          $h0, 
          f#0, 
          s#0)
         || ($Is(f#0, 
            Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)))
           && $Is(s#0, TSeq(Seq._default.MapWithResult$T))))
       && 
      $IsHeapAnchor($h0)
       && $HeapSucc($h0, $h1)
     ==> 
    (forall<alpha> $o: ref, $f: Field alpha :: 
      $o != null
           && (exists i#0: int, o#0: ref :: 
            { Reads1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $h0, 
                f#0, 
                Seq#Index(s#0, i#0))[$Box(o#0)] } 
            $Is(o#0, Tclass._System.object?())
               && 
              LitInt(0) <= i#0
               && i#0 < Seq#Length(s#0)
               && Reads1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $h0, 
                f#0, 
                Seq#Index(s#0, i#0))[$Box(o#0)]
               && $Box($o) == $Box(o#0))
         ==> read($h0, $o, $f) == read($h1, $o, $f))
     ==> Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
        Seq._default.MapWithResult$R, 
        Seq._default.MapWithResult$E, 
        $ly, 
        $h0, 
        f#0, 
        s#0)
       == Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
        Seq._default.MapWithResult$R, 
        Seq._default.MapWithResult$E, 
        $ly, 
        $h1, 
        f#0, 
        s#0));

// consequence axiom for Seq.__default.MapWithResult
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.MapWithResult$T: Ty, 
      Seq._default.MapWithResult$R: Ty, 
      Seq._default.MapWithResult$E: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
        Seq._default.MapWithResult$R, 
        Seq._default.MapWithResult$E, 
        $ly, 
        $Heap, 
        f#0, 
        s#0) } 
    Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
          Seq._default.MapWithResult$R, 
          Seq._default.MapWithResult$E, 
          $Heap, 
          f#0, 
          s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, 
            Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)))
           && $Is(s#0, TSeq(Seq._default.MapWithResult$T))
           && (forall i#1: int :: 
            { Seq#Index(s#0, i#1) } 
            true
               ==> 
              LitInt(0) <= i#1 && i#1 < Seq#Length(s#0)
               ==> Requires1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $Heap, 
                f#0, 
                Seq#Index(s#0, i#1))))
       ==> (Wrappers.Result.Success_q(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
              Seq._default.MapWithResult$R, 
              Seq._default.MapWithResult$E, 
              $ly, 
              $Heap, 
              f#0, 
              s#0))
           ==> Seq#Length($Unbox(Wrappers.Result.value(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                      Seq._default.MapWithResult$R, 
                      Seq._default.MapWithResult$E, 
                      $ly, 
                      $Heap, 
                      f#0, 
                      s#0))): Seq Box)
               == Seq#Length(s#0)
             && (forall i#2: int :: 
              { Seq#Index($Unbox(Wrappers.Result.value(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        $ly, 
                        $Heap, 
                        f#0, 
                        s#0))): Seq Box, 
                  i#2) } 
                { Seq#Index(s#0, i#2) } 
              true
                 ==> (LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
                     ==> Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                          $Heap, 
                          f#0, 
                          Seq#Index(s#0, i#2))): DatatypeType))
                   && (LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
                     ==> Seq#Index($Unbox(Wrappers.Result.value(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                              Seq._default.MapWithResult$R, 
                              Seq._default.MapWithResult$E, 
                              $ly, 
                              $Heap, 
                              f#0, 
                              s#0))): Seq Box, 
                        i#2)
                       == Wrappers.Result.value($Unbox(Apply1(Seq._default.MapWithResult$T, 
                            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                            $Heap, 
                            f#0, 
                            Seq#Index(s#0, i#2))): DatatypeType))))
         && $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
            Seq._default.MapWithResult$R, 
            Seq._default.MapWithResult$E, 
            $ly, 
            $Heap, 
            f#0, 
            s#0), 
          Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E)));

function Seq.__default.MapWithResult#requires(Ty, Ty, Ty, LayerType, Heap, HandleType, Seq Box) : bool;

// #requires axiom for Seq.__default.MapWithResult
axiom (forall Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.MapWithResult#requires(Seq._default.MapWithResult$T, 
      Seq._default.MapWithResult$R, 
      Seq._default.MapWithResult$E, 
      $ly, 
      $Heap, 
      f#0, 
      s#0), $IsGoodHeap($Heap) } 
  $IsGoodHeap($Heap)
       && $Is(f#0, 
        Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)))
       && $Is(s#0, TSeq(Seq._default.MapWithResult$T))
     ==> Seq.__default.MapWithResult#requires(Seq._default.MapWithResult$T, 
        Seq._default.MapWithResult$R, 
        Seq._default.MapWithResult$E, 
        $ly, 
        $Heap, 
        f#0, 
        s#0)
       == (forall i#3: int :: 
        { Seq#Index(s#0, i#3) } 
        true
           ==> 
          LitInt(0) <= i#3 && i#3 < Seq#Length(s#0)
           ==> Requires1(Seq._default.MapWithResult$T, 
            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
            $Heap, 
            f#0, 
            Seq#Index(s#0, i#3))));

// definition axiom for Seq.__default.MapWithResult (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.MapWithResult$T: Ty, 
      Seq._default.MapWithResult$R: Ty, 
      Seq._default.MapWithResult$E: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
        Seq._default.MapWithResult$R, 
        Seq._default.MapWithResult$E, 
        $LS($ly), 
        $Heap, 
        f#0, 
        s#0), $IsGoodHeap($Heap) } 
    Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
          Seq._default.MapWithResult$R, 
          Seq._default.MapWithResult$E, 
          $Heap, 
          f#0, 
          s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, 
            Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)))
           && $Is(s#0, TSeq(Seq._default.MapWithResult$T))
           && (forall i#3: int :: 
            { Seq#Index(s#0, i#3) } 
            true
               ==> 
              LitInt(0) <= i#3 && i#3 < Seq#Length(s#0)
               ==> Requires1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $Heap, 
                f#0, 
                Seq#Index(s#0, i#3))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> (var valueOrError0#0 := $Unbox(Apply1(Seq._default.MapWithResult$T, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap, 
                  f#0, 
                  Seq#Index(s#0, LitInt(0)))): DatatypeType; 
            Wrappers.Result.IsFailure#canCall(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0)
               && (Wrappers.Result.IsFailure(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0)
                 ==> Wrappers.Result.PropagateFailure#canCall(Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  TSeq(Seq._default.MapWithResult$R), 
                  valueOrError0#0))
               && (!Wrappers.Result.IsFailure(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0)
                 ==> Wrappers.Result.Extract#canCall(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0)
                   && 
                  Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
                    Seq._default.MapWithResult$R, 
                    Seq._default.MapWithResult$E, 
                    $Heap, 
                    f#0, 
                    Seq#Drop(s#0, LitInt(1)))
                   && (var valueOrError1#0 := Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        $ly, 
                        $Heap, 
                        f#0, 
                        Seq#Drop(s#0, LitInt(1))); 
                    Wrappers.Result.IsFailure#canCall(TSeq(Seq._default.MapWithResult$R), 
                        Seq._default.MapWithResult$E, 
                        valueOrError1#0)
                       && (Wrappers.Result.IsFailure(TSeq(Seq._default.MapWithResult$R), 
                          Seq._default.MapWithResult$E, 
                          valueOrError1#0)
                         ==> Wrappers.Result.PropagateFailure#canCall(TSeq(Seq._default.MapWithResult$R), 
                          Seq._default.MapWithResult$E, 
                          TSeq(Seq._default.MapWithResult$R), 
                          valueOrError1#0))
                       && (!Wrappers.Result.IsFailure(TSeq(Seq._default.MapWithResult$R), 
                          Seq._default.MapWithResult$E, 
                          valueOrError1#0)
                         ==> Wrappers.Result.Extract#canCall(TSeq(Seq._default.MapWithResult$R), 
                          Seq._default.MapWithResult$E, 
                          valueOrError1#0))))))
         && Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
            Seq._default.MapWithResult$R, 
            Seq._default.MapWithResult$E, 
            $LS($ly), 
            $Heap, 
            f#0, 
            s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then #Wrappers.Result.Success($Box(Lit(Seq#Empty(): Seq Box)))
             else (var valueOrError0#0 := $Unbox(Apply1(Seq._default.MapWithResult$T, 
                    Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                    $Heap, 
                    f#0, 
                    Seq#Index(s#0, LitInt(0)))): DatatypeType; 
              (if Wrappers.Result.IsFailure(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0)
                 then Wrappers.Result.PropagateFailure(Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  TSeq(Seq._default.MapWithResult$R), 
                  valueOrError0#0)
                 else (var head#0 := Wrappers.Result.Extract(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#0); 
                  (var valueOrError1#0 := Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        $ly, 
                        $Heap, 
                        f#0, 
                        Seq#Drop(s#0, LitInt(1))); 
                    (if Wrappers.Result.IsFailure(TSeq(Seq._default.MapWithResult$R), 
                        Seq._default.MapWithResult$E, 
                        valueOrError1#0)
                       then Wrappers.Result.PropagateFailure(TSeq(Seq._default.MapWithResult$R), 
                        Seq._default.MapWithResult$E, 
                        TSeq(Seq._default.MapWithResult$R), 
                        valueOrError1#0)
                       else (var tail#0 := $Unbox(Wrappers.Result.Extract(TSeq(Seq._default.MapWithResult$R), 
                              Seq._default.MapWithResult$E, 
                              valueOrError1#0)): Seq Box; 
                        #Wrappers.Result.Success($Box(Seq#Append(Seq#Build(Seq#Empty(): Seq Box, head#0), tail#0)))))))))));

procedure {:verboseName "Seq.MapWithResult (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.MapWithResult(Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    f#0: HandleType
       where $Is(f#0, 
        Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E))), 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.MapWithResult$T)))
   returns (result#0: DatatypeType
       where $Is(result#0, 
        Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Wrappers.Result.Success_q(result#0)
     ==> Seq#Length($Unbox(Wrappers.Result.value(result#0)): Seq Box) == Seq#Length(s#0);
  ensures Wrappers.Result.Success_q(result#0)
     ==> (forall i#4: int :: 
      { Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4) } 
        { Seq#Index(s#0, i#4) } 
      true
         ==> (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
             ==> Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap, 
                  f#0, 
                  Seq#Index(s#0, i#4))): DatatypeType))
           && (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
             ==> Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4)
               == Wrappers.Result.value($Unbox(Apply1(Seq._default.MapWithResult$T, 
                    Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                    $Heap, 
                    f#0, 
                    Seq#Index(s#0, i#4))): DatatypeType)));



implementation {:verboseName "Seq.MapWithResult (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.MapWithResult(Seq._default.MapWithResult$T: Ty, 
    Seq._default.MapWithResult$R: Ty, 
    Seq._default.MapWithResult$E: Ty, 
    f#0: HandleType, 
    s#0: Seq Box)
   returns (result#0: DatatypeType)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#5: int;
  var ##x0#0: Box;
  var b$reqreads#0: bool;
  var i#7: int;
  var o#1: ref;
  var ##x0#1: Box;
  var b$reqreads#1: bool;
  var i#8: int;
  var o#2: ref;
  var ##x0#2: Box;
  var i#9: int;
  var valueOrError0#Z#0: DatatypeType;
  var let#0#0#0: DatatypeType;
  var head#Z#0: Box;
  var let#1#0#0: Box;
  var valueOrError1#Z#0: DatatypeType;
  var let#2#0#0: DatatypeType;
  var ##f#0: HandleType;
  var ##s#0: Seq Box;
  var tail#Z#0: Seq Box;
  var let#3#0#0: Seq Box;
  var b$reqreads#2: bool;
  var b$reqreads#3: bool;

    b$reqreads#0 := true;
    b$reqreads#1 := true;
    b$reqreads#2 := true;
    b$reqreads#3 := true;

    // AddWellformednessCheck for function MapWithResult
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc)
         ==> (exists i#0: int, o#0: ref :: 
          { Reads1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap, 
              f#0, 
              Seq#Index(s#0, i#0))[$Box(o#0)] } 
          $Is(o#0, Tclass._System.object?())
             && 
            LitInt(0) <= i#0
             && i#0 < Seq#Length(s#0)
             && Reads1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap, 
              f#0, 
              Seq#Index(s#0, i#0))[$Box(o#0)]
             && $Box($o) == $Box(o#0)));
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    havoc i#5;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#5)
        {
        }

        assume LitInt(0) <= i#5 && i#5 < Seq#Length(s#0);
        // assume allocatedness for receiver argument to function
        assume $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)), 
          $Heap);
        assert 0 <= i#5 && i#5 < Seq#Length(s#0);
        ##x0#0 := Seq#Index(s#0, i#5);
        // assume allocatedness for argument to function
        assume $IsAllocBox(##x0#0, Seq._default.MapWithResult$T, $Heap);
        b$reqreads#0 := (forall<alpha> $o: ref, $f: Field alpha :: 
          $o != null
               && read($Heap, $o, alloc)
               && Reads1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $Heap, 
                f#0, 
                ##x0#0)[$Box($o)]
             ==> $_Frame[$o, $f]);
        assume Requires1#canCall(Seq._default.MapWithResult$T, 
          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
          $Heap, 
          f#0, 
          Seq#Index(s#0, i#5));
        assume Requires1(Seq._default.MapWithResult$T, 
          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
          $Heap, 
          f#0, 
          Seq#Index(s#0, i#5));
    }
    else
    {
        assume LitInt(0) <= i#5 && i#5 < Seq#Length(s#0)
           ==> Requires1(Seq._default.MapWithResult$T, 
            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
            $Heap, 
            f#0, 
            Seq#Index(s#0, i#5));
    }

    assume (forall i#6: int :: 
      { Seq#Index(s#0, i#6) } 
      true
         ==> 
        LitInt(0) <= i#6 && i#6 < Seq#Length(s#0)
         ==> Requires1(Seq._default.MapWithResult$T, 
          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
          $Heap, 
          f#0, 
          Seq#Index(s#0, i#6)));
    assert b$reqreads#0;
    // Begin Comprehension WF check
    havoc i#7;
    havoc o#1;
    if ($Is(o#1, Tclass._System.object?())
       && $IsAlloc(o#1, Tclass._System.object?(), $Heap))
    {
        if (LitInt(0) <= i#7)
        {
        }

        if (LitInt(0) <= i#7 && i#7 < Seq#Length(s#0))
        {
            // assume allocatedness for receiver argument to function
            assume $IsAlloc(f#0, 
              Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)), 
              $Heap);
            assert 0 <= i#7 && i#7 < Seq#Length(s#0);
            ##x0#1 := Seq#Index(s#0, i#7);
            // assume allocatedness for argument to function
            assume $IsAllocBox(##x0#1, Seq._default.MapWithResult$T, $Heap);
            b$reqreads#1 := (forall<alpha> $o: ref, $f: Field alpha :: 
              $o != null
                   && read($Heap, $o, alloc)
                   && Reads1(Seq._default.MapWithResult$T, 
                    Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                    $Heap, 
                    f#0, 
                    ##x0#1)[$Box($o)]
                 ==> $_Frame[$o, $f]);
            assume Reads1#canCall(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap, 
              f#0, 
              Seq#Index(s#0, i#7));
        }

        if (LitInt(0) <= i#7
           && i#7 < Seq#Length(s#0)
           && Reads1(Seq._default.MapWithResult$T, 
            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
            $Heap, 
            f#0, 
            Seq#Index(s#0, i#7))[$Box(o#1)])
        {
        }
    }

    // End Comprehension WF check
    assert b$reqreads#1;
    // Begin Comprehension WF check
    havoc i#8;
    havoc o#2;
    if ($Is(o#2, Tclass._System.object?())
       && $IsAlloc(o#2, Tclass._System.object?(), $Heap))
    {
        if (LitInt(0) <= i#8)
        {
        }

        if (LitInt(0) <= i#8 && i#8 < Seq#Length(s#0))
        {
            // assume allocatedness for receiver argument to function
            assume $IsAlloc(f#0, 
              Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)), 
              $Heap);
            assert 0 <= i#8 && i#8 < Seq#Length(s#0);
            ##x0#2 := Seq#Index(s#0, i#8);
            // assume allocatedness for argument to function
            assume $IsAllocBox(##x0#2, Seq._default.MapWithResult$T, $Heap);
            assume Reads1#canCall(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap, 
              f#0, 
              Seq#Index(s#0, i#8));
        }

        if (LitInt(0) <= i#8
           && i#8 < Seq#Length(s#0)
           && Reads1(Seq._default.MapWithResult$T, 
            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
            $Heap, 
            f#0, 
            Seq#Index(s#0, i#8))[$Box(o#2)])
        {
        }
    }

    // End Comprehension WF check
    if (*)
    {
        assume $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
            Seq._default.MapWithResult$R, 
            Seq._default.MapWithResult$E, 
            StartFuel_Seq._default.MapWithResult, 
            $Heap, 
            f#0, 
            s#0), 
          Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
        if (*)
        {
            assume Wrappers.Result.Success_q(result#0);
            assert Wrappers.Result.Success_q(result#0);
            assume Seq#Length($Unbox(Wrappers.Result.value(result#0)): Seq Box) == Seq#Length(s#0);
            // Begin Comprehension WF check
            havoc i#9;
            if (true)
            {
                if (LitInt(0) <= i#9)
                {
                }

                if (LitInt(0) <= i#9 && i#9 < Seq#Length(s#0))
                {
                    assert 0 <= i#9 && i#9 < Seq#Length(s#0);
                    assert Requires1(Seq._default.MapWithResult$T, 
                      Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                      $Heap, 
                      f#0, 
                      Seq#Index(s#0, i#9));
                    if (Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                          $Heap, 
                          f#0, 
                          Seq#Index(s#0, i#9))): DatatypeType))
                    {
                        assert Wrappers.Result.Success_q(result#0);
                        assert 0 <= i#9 && i#9 < Seq#Length($Unbox(Wrappers.Result.value(result#0)): Seq Box);
                        assert 0 <= i#9 && i#9 < Seq#Length(s#0);
                        assert Requires1(Seq._default.MapWithResult$T, 
                          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                          $Heap, 
                          f#0, 
                          Seq#Index(s#0, i#9));
                        assert Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#9))): DatatypeType);
                    }
                }
            }

            // End Comprehension WF check
            assume (forall i#4: int :: 
              { Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4) } 
                { Seq#Index(s#0, i#4) } 
              true
                 ==> (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
                     ==> Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                          Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                          $Heap, 
                          f#0, 
                          Seq#Index(s#0, i#4))): DatatypeType))
                   && (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
                     ==> Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4)
                       == Wrappers.Result.value($Unbox(Apply1(Seq._default.MapWithResult$T, 
                            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                            $Heap, 
                            f#0, 
                            Seq#Index(s#0, i#4))): DatatypeType)));
        }
        else
        {
            assume Wrappers.Result.Success_q(result#0)
               ==> Seq#Length($Unbox(Wrappers.Result.value(result#0)): Seq Box) == Seq#Length(s#0)
                 && (forall i#4: int :: 
                  { Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4) } 
                    { Seq#Index(s#0, i#4) } 
                  true
                     ==> (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
                         ==> Wrappers.Result.Success_q($Unbox(Apply1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#4))): DatatypeType))
                       && (LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
                         ==> Seq#Index($Unbox(Wrappers.Result.value(result#0)): Seq Box, i#4)
                           == Wrappers.Result.value($Unbox(Apply1(Seq._default.MapWithResult$T, 
                                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                                $Heap, 
                                f#0, 
                                Seq#Index(s#0, i#4))): DatatypeType)));
        }

        assume false;
    }
    else
    {
        $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
          $o != null && read($Heap, $o, alloc)
             ==> (exists i#0: int, o#0: ref :: 
              { Reads1(Seq._default.MapWithResult$T, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap, 
                  f#0, 
                  Seq#Index(s#0, i#0))[$Box(o#0)] } 
              $Is(o#0, Tclass._System.object?())
                 && 
                LitInt(0) <= i#0
                 && i#0 < Seq#Length(s#0)
                 && Reads1(Seq._default.MapWithResult$T, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap, 
                  f#0, 
                  Seq#Index(s#0, i#0))[$Box(o#0)]
                 && $Box($o) == $Box(o#0)));
        if (Seq#Length(s#0) == LitInt(0))
        {
            assume Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                Seq._default.MapWithResult$R, 
                Seq._default.MapWithResult$E, 
                StartFuel_Seq._default.MapWithResult, 
                $Heap, 
                f#0, 
                s#0)
               == Lit(#Wrappers.Result.Success($Box(Lit(Seq#Empty(): Seq Box))));
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                Seq._default.MapWithResult$R, 
                Seq._default.MapWithResult$E, 
                StartFuel_Seq._default.MapWithResult, 
                $Heap, 
                f#0, 
                s#0), 
              Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
        }
        else
        {
            havoc valueOrError0#Z#0;
            assume $Is(valueOrError0#Z#0, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E))
               && $IsAlloc(valueOrError0#Z#0, 
                Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                $Heap);
            assert 0 <= LitInt(0) && LitInt(0) < Seq#Length(s#0);
            assert Requires1(Seq._default.MapWithResult$T, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap, 
              f#0, 
              Seq#Index(s#0, LitInt(0)));
            b$reqreads#2 := (forall<alpha> $o: ref, $f: Field alpha :: 
              $o != null
                   && read($Heap, $o, alloc)
                   && Reads1(Seq._default.MapWithResult$T, 
                    Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                    $Heap, 
                    f#0, 
                    Seq#Index(s#0, LitInt(0)))[$Box($o)]
                 ==> $_Frame[$o, $f]);
            assume let#0#0#0
               == $Unbox(Apply1(Seq._default.MapWithResult$T, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap, 
                  f#0, 
                  Seq#Index(s#0, LitInt(0)))): DatatypeType;
            assume true;
            // CheckWellformedWithResult: any expression
            assume $Is(let#0#0#0, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E));
            assume valueOrError0#Z#0 == let#0#0#0;
            // assume allocatedness for receiver argument to function
            assume $IsAlloc(valueOrError0#Z#0, 
              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
              $Heap);
            assume Wrappers.Result.IsFailure#canCall(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#Z#0);
            if (Wrappers.Result.IsFailure(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#Z#0))
            {
                // assume allocatedness for receiver argument to function
                assume $IsAlloc(valueOrError0#Z#0, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap);
                assert {:subsumption 0} Wrappers.Result.Failure_q(valueOrError0#Z#0);
                assume Wrappers.Result.Failure_q(valueOrError0#Z#0);
                assume Wrappers.Result.PropagateFailure#canCall(Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  TSeq(Seq._default.MapWithResult$R), 
                  valueOrError0#Z#0);
                assume Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                    Seq._default.MapWithResult$R, 
                    Seq._default.MapWithResult$E, 
                    StartFuel_Seq._default.MapWithResult, 
                    $Heap, 
                    f#0, 
                    s#0)
                   == Wrappers.Result.PropagateFailure(Seq._default.MapWithResult$R, 
                    Seq._default.MapWithResult$E, 
                    TSeq(Seq._default.MapWithResult$R), 
                    valueOrError0#Z#0);
                assume Wrappers.Result.PropagateFailure#canCall(Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  TSeq(Seq._default.MapWithResult$R), 
                  valueOrError0#Z#0);
                // CheckWellformedWithResult: any expression
                assume $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                    Seq._default.MapWithResult$R, 
                    Seq._default.MapWithResult$E, 
                    StartFuel_Seq._default.MapWithResult, 
                    $Heap, 
                    f#0, 
                    s#0), 
                  Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
            }
            else
            {
                havoc head#Z#0;
                assume $IsBox(head#Z#0, Seq._default.MapWithResult$R)
                   && $IsAllocBox(head#Z#0, Seq._default.MapWithResult$R, $Heap);
                // assume allocatedness for receiver argument to function
                assume $IsAlloc(valueOrError0#Z#0, 
                  Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                  $Heap);
                assert {:subsumption 0} Wrappers.Result.Success_q(valueOrError0#Z#0);
                assume Wrappers.Result.Success_q(valueOrError0#Z#0);
                assume Wrappers.Result.Extract#canCall(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#Z#0);
                assume let#1#0#0
                   == Wrappers.Result.Extract(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#Z#0);
                assume Wrappers.Result.Extract#canCall(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E, valueOrError0#Z#0);
                // CheckWellformedWithResult: any expression
                assume $IsBox(let#1#0#0, Seq._default.MapWithResult$R);
                assume head#Z#0 == let#1#0#0;
                havoc valueOrError1#Z#0;
                assume $Is(valueOrError1#Z#0, 
                    Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E))
                   && $IsAlloc(valueOrError1#Z#0, 
                    Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E), 
                    $Heap);
                assert 0 <= LitInt(1) && LitInt(1) <= Seq#Length(s#0);
                ##f#0 := f#0;
                // assume allocatedness for argument to function
                assume $IsAlloc(##f#0, 
                  Tclass._System.___hFunc1(Seq._default.MapWithResult$T, 
                    Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E)), 
                  $Heap);
                ##s#0 := Seq#Drop(s#0, LitInt(1));
                // assume allocatedness for argument to function
                assume $IsAlloc(##s#0, TSeq(Seq._default.MapWithResult$T), $Heap);
                assert {:subsumption 0} (forall i#10: int :: 
                  { Seq#Index(##s#0, i#10) } 
                  true
                     ==> 
                    LitInt(0) <= i#10 && i#10 < Seq#Length(##s#0)
                     ==> Requires1(Seq._default.MapWithResult$T, 
                      Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                      $Heap, 
                      ##f#0, 
                      Seq#Index(##s#0, i#10)));
                assume (forall i#10: int :: 
                  { Seq#Index(##s#0, i#10) } 
                  true
                     ==> 
                    LitInt(0) <= i#10 && i#10 < Seq#Length(##s#0)
                     ==> Requires1(Seq._default.MapWithResult$T, 
                      Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                      $Heap, 
                      ##f#0, 
                      Seq#Index(##s#0, i#10)));
                b$reqreads#3 := (forall<alpha> $o: ref, $f: Field alpha :: 
                  $o != null
                       && read($Heap, $o, alloc)
                       && (exists i#11: int, o#3: ref :: 
                        { Reads1(Seq._default.MapWithResult$T, 
                            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                            $Heap, 
                            ##f#0, 
                            Seq#Index(##s#0, i#11))[$Box(o#3)] } 
                        $Is(o#3, Tclass._System.object?())
                           && 
                          LitInt(0) <= i#11
                           && i#11 < Seq#Length(##s#0)
                           && Reads1(Seq._default.MapWithResult$T, 
                            Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                            $Heap, 
                            ##f#0, 
                            Seq#Index(##s#0, i#11))[$Box(o#3)]
                           && $Box($o) == $Box(o#3))
                     ==> $_Frame[$o, $f]);
                assert (Set#Subset((lambda $y#0: Box :: 
                        (exists i#12: int, o#4: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                          $Is(o#4, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#12
                             && i#12 < Seq#Length(##s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)]
                             && $y#0 == $Box(o#4))), 
                      (lambda $y#1: Box :: 
                        (exists i#0: int, o#0: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)] } 
                          $Is(o#0, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#0
                             && i#0 < Seq#Length(s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)]
                             && $y#1 == $Box(o#0))))
                     && !Set#Subset((lambda $y#1: Box :: 
                        (exists i#0: int, o#0: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)] } 
                          $Is(o#0, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#0
                             && i#0 < Seq#Length(s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)]
                             && $y#1 == $Box(o#0))), 
                      (lambda $y#0: Box :: 
                        (exists i#12: int, o#4: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                          $Is(o#4, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#12
                             && i#12 < Seq#Length(##s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)]
                             && $y#0 == $Box(o#4)))))
                   || (Set#Equal((lambda $y#0: Box :: 
                        (exists i#12: int, o#4: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)] } 
                          $Is(o#4, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#12
                             && i#12 < Seq#Length(##s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              ##f#0, 
                              Seq#Index(##s#0, i#12))[$Box(o#4)]
                             && $y#0 == $Box(o#4))), 
                      (lambda $y#1: Box :: 
                        (exists i#0: int, o#0: ref :: 
                          { Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)] } 
                          $Is(o#0, Tclass._System.object?())
                             && 
                            LitInt(0) <= i#0
                             && i#0 < Seq#Length(s#0)
                             && Reads1(Seq._default.MapWithResult$T, 
                              Tclass.Wrappers.Result(Seq._default.MapWithResult$R, Seq._default.MapWithResult$E), 
                              $Heap, 
                              f#0, 
                              Seq#Index(s#0, i#0))[$Box(o#0)]
                             && $y#1 == $Box(o#0))))
                     && Seq#Rank(##s#0) < Seq#Rank(s#0));
                assume Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
                  Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  $Heap, 
                  f#0, 
                  Seq#Drop(s#0, LitInt(1)));
                assume let#2#0#0
                   == Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                    Seq._default.MapWithResult$R, 
                    Seq._default.MapWithResult$E, 
                    StartFuel_Seq._default.MapWithResult, 
                    $Heap, 
                    f#0, 
                    Seq#Drop(s#0, LitInt(1)));
                assume Seq.__default.MapWithResult#canCall(Seq._default.MapWithResult$T, 
                  Seq._default.MapWithResult$R, 
                  Seq._default.MapWithResult$E, 
                  $Heap, 
                  f#0, 
                  Seq#Drop(s#0, LitInt(1)));
                // CheckWellformedWithResult: any expression
                assume $Is(let#2#0#0, 
                  Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
                assume valueOrError1#Z#0 == let#2#0#0;
                // assume allocatedness for receiver argument to function
                assume $IsAlloc(valueOrError1#Z#0, 
                  Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E), 
                  $Heap);
                assume Wrappers.Result.IsFailure#canCall(TSeq(Seq._default.MapWithResult$R), 
                  Seq._default.MapWithResult$E, 
                  valueOrError1#Z#0);
                if (Wrappers.Result.IsFailure(TSeq(Seq._default.MapWithResult$R), 
                  Seq._default.MapWithResult$E, 
                  valueOrError1#Z#0))
                {
                    // assume allocatedness for receiver argument to function
                    assume $IsAlloc(valueOrError1#Z#0, 
                      Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E), 
                      $Heap);
                    assert {:subsumption 0} Wrappers.Result.Failure_q(valueOrError1#Z#0);
                    assume Wrappers.Result.Failure_q(valueOrError1#Z#0);
                    assume Wrappers.Result.PropagateFailure#canCall(TSeq(Seq._default.MapWithResult$R), 
                      Seq._default.MapWithResult$E, 
                      TSeq(Seq._default.MapWithResult$R), 
                      valueOrError1#Z#0);
                    assume Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        StartFuel_Seq._default.MapWithResult, 
                        $Heap, 
                        f#0, 
                        s#0)
                       == Wrappers.Result.PropagateFailure(TSeq(Seq._default.MapWithResult$R), 
                        Seq._default.MapWithResult$E, 
                        TSeq(Seq._default.MapWithResult$R), 
                        valueOrError1#Z#0);
                    assume Wrappers.Result.PropagateFailure#canCall(TSeq(Seq._default.MapWithResult$R), 
                      Seq._default.MapWithResult$E, 
                      TSeq(Seq._default.MapWithResult$R), 
                      valueOrError1#Z#0);
                    // CheckWellformedWithResult: any expression
                    assume $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        StartFuel_Seq._default.MapWithResult, 
                        $Heap, 
                        f#0, 
                        s#0), 
                      Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
                }
                else
                {
                    havoc tail#Z#0;
                    assume $Is(tail#Z#0, TSeq(Seq._default.MapWithResult$R))
                       && $IsAlloc(tail#Z#0, TSeq(Seq._default.MapWithResult$R), $Heap);
                    // assume allocatedness for receiver argument to function
                    assume $IsAlloc(valueOrError1#Z#0, 
                      Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E), 
                      $Heap);
                    assert {:subsumption 0} Wrappers.Result.Success_q(valueOrError1#Z#0);
                    assume Wrappers.Result.Success_q(valueOrError1#Z#0);
                    assume Wrappers.Result.Extract#canCall(TSeq(Seq._default.MapWithResult$R), 
                      Seq._default.MapWithResult$E, 
                      valueOrError1#Z#0);
                    assume let#3#0#0
                       == $Unbox(Wrappers.Result.Extract(TSeq(Seq._default.MapWithResult$R), 
                          Seq._default.MapWithResult$E, 
                          valueOrError1#Z#0)): Seq Box;
                    assume Wrappers.Result.Extract#canCall(TSeq(Seq._default.MapWithResult$R), 
                      Seq._default.MapWithResult$E, 
                      valueOrError1#Z#0);
                    // CheckWellformedWithResult: any expression
                    assume $Is(let#3#0#0, TSeq(Seq._default.MapWithResult$R));
                    assume tail#Z#0 == let#3#0#0;
                    assume Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        StartFuel_Seq._default.MapWithResult, 
                        $Heap, 
                        f#0, 
                        s#0)
                       == #Wrappers.Result.Success($Box(Seq#Append(Seq#Build(Seq#Empty(): Seq Box, head#Z#0), tail#Z#0)));
                    assume true;
                    // CheckWellformedWithResult: any expression
                    assume $Is(Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
                        Seq._default.MapWithResult$R, 
                        Seq._default.MapWithResult$E, 
                        StartFuel_Seq._default.MapWithResult, 
                        $Heap, 
                        f#0, 
                        s#0), 
                      Tclass.Wrappers.Result(TSeq(Seq._default.MapWithResult$R), Seq._default.MapWithResult$E));
                }
            }
        }

        assume Seq.__default.MapWithResult(Seq._default.MapWithResult$T, 
            Seq._default.MapWithResult$R, 
            Seq._default.MapWithResult$E, 
            StartFuel_Seq._default.MapWithResult, 
            $Heap, 
            f#0, 
            s#0)
           == result#0;
        assert b$reqreads#2;
        assert b$reqreads#3;
    }
}



procedure {:verboseName "Seq.LemmaMapDistributesOverConcat (well-formedness)"} {:opaque} {:_induction f#0, a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMapDistributesOverConcat(Seq._default.LemmaMapDistributesOverConcat$T: Ty, 
    Seq._default.LemmaMapDistributesOverConcat$R: Ty, 
    f#0: HandleType
       where $Is(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R))
         && $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R), 
          $Heap), 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap));
  free requires 1 == $FunctionContextHeight;
  modifies $Heap, $Tick;



implementation {:verboseName "Seq.LemmaMapDistributesOverConcat (well-formedness)"} {:opaque} {:_induction f#0, a#0, b#0} CheckWellFormed$$Seq.__default.LemmaMapDistributesOverConcat(Seq._default.LemmaMapDistributesOverConcat$T: Ty, 
    Seq._default.LemmaMapDistributesOverConcat$R: Ty, 
    f#0: HandleType, 
    a#0: Seq Box, 
    b#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#0: int;
  var ##x0#0: Box;
  var j#0: int;
  var ##x0#1: Box;
  var ##f#0: HandleType;
  var ##s#0: Seq Box;
  var ##f#1: HandleType;
  var ##s#1: Seq Box;
  var ##f#2: HandleType;
  var ##s#2: Seq Box;

    // AddMethodImpl: LemmaMapDistributesOverConcat, CheckWellFormed$$Seq.__default.LemmaMapDistributesOverConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    havoc i#0;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#0)
        {
        }

        assume LitInt(0) <= i#0 && i#0 < Seq#Length(a#0);
        // assume allocatedness for receiver argument to function
        assume $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R), 
          $Heap);
        assert 0 <= i#0 && i#0 < Seq#Length(a#0);
        ##x0#0 := Seq#Index(a#0, i#0);
        // assume allocatedness for argument to function
        assume $IsAllocBox(##x0#0, Seq._default.LemmaMapDistributesOverConcat$T, $Heap);
        assume Requires1#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(a#0, i#0));
        assume Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(a#0, i#0));
    }
    else
    {
        assume LitInt(0) <= i#0 && i#0 < Seq#Length(a#0)
           ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R, 
            $Heap, 
            f#0, 
            Seq#Index(a#0, i#0));
    }

    assume (forall i#1: int :: 
      { Seq#Index(a#0, i#1) } 
      true
         ==> 
        LitInt(0) <= i#1 && i#1 < Seq#Length(a#0)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(a#0, i#1)));
    havoc j#0;
    assume true;
    if (*)
    {
        if (LitInt(0) <= j#0)
        {
        }

        assume LitInt(0) <= j#0 && j#0 < Seq#Length(b#0);
        // assume allocatedness for receiver argument to function
        assume $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R), 
          $Heap);
        assert 0 <= j#0 && j#0 < Seq#Length(b#0);
        ##x0#1 := Seq#Index(b#0, j#0);
        // assume allocatedness for argument to function
        assume $IsAllocBox(##x0#1, Seq._default.LemmaMapDistributesOverConcat$T, $Heap);
        assume Requires1#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(b#0, j#0));
        assume Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(b#0, j#0));
    }
    else
    {
        assume LitInt(0) <= j#0 && j#0 < Seq#Length(b#0)
           ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R, 
            $Heap, 
            f#0, 
            Seq#Index(b#0, j#0));
    }

    assume (forall j#1: int :: 
      { Seq#Index(b#0, j#1) } 
      true
         ==> 
        LitInt(0) <= j#1 && j#1 < Seq#Length(b#0)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          f#0, 
          Seq#Index(b#0, j#1)));
    havoc $Heap;
    assume old($Heap) == $Heap;
    ##f#0 := f#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##f#0, 
      Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R), 
      $Heap);
    ##s#0 := Seq#Append(a#0, b#0);
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
    assert {:subsumption 0} (forall i#2: int :: 
      { Seq#Index(##s#0, i#2) } 
      true
         ==> 
        LitInt(0) <= i#2 && i#2 < Seq#Length(##s#0)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#0, 
          Seq#Index(##s#0, i#2)));
    assume (forall i#2: int :: 
      { Seq#Index(##s#0, i#2) } 
      true
         ==> 
        LitInt(0) <= i#2 && i#2 < Seq#Length(##s#0)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#0, 
          Seq#Index(##s#0, i#2)));
    assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      Seq#Append(a#0, b#0));
    ##f#1 := f#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##f#1, 
      Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R), 
      $Heap);
    ##s#1 := a#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#1, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
    assert {:subsumption 0} (forall i#3: int :: 
      { Seq#Index(##s#1, i#3) } 
      true
         ==> 
        LitInt(0) <= i#3 && i#3 < Seq#Length(##s#1)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#1, 
          Seq#Index(##s#1, i#3)));
    assume (forall i#3: int :: 
      { Seq#Index(##s#1, i#3) } 
      true
         ==> 
        LitInt(0) <= i#3 && i#3 < Seq#Length(##s#1)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#1, 
          Seq#Index(##s#1, i#3)));
    assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      a#0);
    ##f#2 := f#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##f#2, 
      Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R), 
      $Heap);
    ##s#2 := b#0;
    // assume allocatedness for argument to function
    assume $IsAlloc(##s#2, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
    assert {:subsumption 0} (forall i#4: int :: 
      { Seq#Index(##s#2, i#4) } 
      true
         ==> 
        LitInt(0) <= i#4 && i#4 < Seq#Length(##s#2)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#2, 
          Seq#Index(##s#2, i#4)));
    assume (forall i#4: int :: 
      { Seq#Index(##s#2, i#4) } 
      true
         ==> 
        LitInt(0) <= i#4 && i#4 < Seq#Length(##s#2)
         ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          $Heap, 
          ##f#2, 
          Seq#Index(##s#2, i#4)));
    assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      b#0);
    assume Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        StartFuel_Seq._default.Map, 
        $Heap, 
        f#0, 
        Seq#Append(a#0, b#0)), 
      Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          StartFuel_Seq._default.Map, 
          $Heap, 
          f#0, 
          a#0), 
        Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
          Seq._default.LemmaMapDistributesOverConcat$R, 
          StartFuel_Seq._default.Map, 
          $Heap, 
          f#0, 
          b#0)));
}



procedure {:verboseName "Seq.LemmaMapDistributesOverConcat (call)"} {:opaque} {:_induction f#0, a#0, b#0} Call$$Seq.__default.LemmaMapDistributesOverConcat(Seq._default.LemmaMapDistributesOverConcat$T: Ty, 
    Seq._default.LemmaMapDistributesOverConcat$R: Ty, 
    f#0: HandleType
       where $Is(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R))
         && $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R), 
          $Heap), 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap));
  // user-defined preconditions
  requires (forall i#1: int :: 
    { Seq#Index(a#0, i#1) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(a#0)
       ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        $Heap, 
        f#0, 
        Seq#Index(a#0, i#1)));
  requires (forall j#1: int :: 
    { Seq#Index(b#0, j#1) } 
    true
       ==> 
      LitInt(0) <= j#1 && j#1 < Seq#Length(b#0)
       ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        $Heap, 
        f#0, 
        Seq#Index(b#0, j#1)));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      Seq#Append(a#0, b#0))
     && 
    Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      a#0)
     && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      b#0);
  ensures Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      StartFuelAssert_Seq._default.Map, 
      $Heap, 
      f#0, 
      Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        StartFuelAssert_Seq._default.Map, 
        $Heap, 
        f#0, 
        a#0), 
      Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        StartFuelAssert_Seq._default.Map, 
        $Heap, 
        f#0, 
        b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



procedure {:verboseName "Seq.LemmaMapDistributesOverConcat (correctness)"} {:opaque} {:_induction f#0, a#0, b#0} Impl$$Seq.__default.LemmaMapDistributesOverConcat(Seq._default.LemmaMapDistributesOverConcat$T: Ty, 
    Seq._default.LemmaMapDistributesOverConcat$R: Ty, 
    f#0: HandleType
       where $Is(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R))
         && $IsAlloc(f#0, 
          Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R), 
          $Heap), 
    a#0: Seq Box
       where $Is(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(a#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap), 
    b#0: Seq Box
       where $Is(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
         && $IsAlloc(b#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap))
   returns ($_reverifyPost: bool);
  free requires 1 == $FunctionContextHeight;
  // user-defined preconditions
  requires (forall i#1: int :: 
    { Seq#Index(a#0, i#1) } 
    true
       ==> 
      LitInt(0) <= i#1 && i#1 < Seq#Length(a#0)
       ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        $Heap, 
        f#0, 
        Seq#Index(a#0, i#1)));
  requires (forall j#1: int :: 
    { Seq#Index(b#0, j#1) } 
    true
       ==> 
      LitInt(0) <= j#1 && j#1 < Seq#Length(b#0)
       ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        $Heap, 
        f#0, 
        Seq#Index(b#0, j#1)));
  modifies $Heap, $Tick;
  // user-defined postconditions
  free ensures Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      Seq#Append(a#0, b#0))
     && 
    Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      a#0)
     && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      $Heap, 
      f#0, 
      b#0);
  ensures Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
      Seq._default.LemmaMapDistributesOverConcat$R, 
      StartFuelAssert_Seq._default.Map, 
      $Heap, 
      f#0, 
      Seq#Append(a#0, b#0)), 
    Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        StartFuelAssert_Seq._default.Map, 
        $Heap, 
        f#0, 
        a#0), 
      Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
        Seq._default.LemmaMapDistributesOverConcat$R, 
        StartFuelAssert_Seq._default.Map, 
        $Heap, 
        f#0, 
        b#0)));
  // frame condition
  free ensures old($Heap) == $Heap;



implementation {:verboseName "Seq.LemmaMapDistributesOverConcat (correctness)"} {:opaque} {:_induction f#0, a#0, b#0} Impl$$Seq.__default.LemmaMapDistributesOverConcat(Seq._default.LemmaMapDistributesOverConcat$T: Ty, 
    Seq._default.LemmaMapDistributesOverConcat$R: Ty, 
    f#0: HandleType, 
    a#0: Seq Box, 
    b#0: Seq Box)
   returns ($_reverifyPost: bool)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var $initHeapForallStmt#0: Heap;
  var ##f#1_0_0_0: HandleType;
  var ##s#1_0_0_0: Seq Box;
  var ##f#1_0_0_1: HandleType;
  var ##s#1_0_0_1: Seq Box;
  var ##f#1_0_0_2: HandleType;
  var ##s#1_0_0_2: Seq Box;
  var ##f#1_0_0_3: HandleType;
  var ##s#1_0_0_3: Seq Box;
  var ##f#1_0_0_4: HandleType;
  var ##s#1_0_0_4: Seq Box;
  var ##f#1_0_1_0: HandleType;
  var ##s#1_0_1_0: Seq Box;
  var ##f#1_0_1_1: HandleType;
  var ##s#1_0_1_1: Seq Box;
  var ##f#1_0_1_2: HandleType;
  var ##s#1_0_1_2: Seq Box;
  var ##f#1_0_1_3: HandleType;
  var ##s#1_0_1_3: Seq Box;
  var ##f#1_0_1_4: HandleType;
  var ##s#1_0_1_4: Seq Box;
  var ##f#1_0_2_0: HandleType;
  var ##s#1_0_2_0: Seq Box;
  var ##f#1_0_2_1: HandleType;
  var ##s#1_0_2_1: Seq Box;
  var ##f#1_0_2_2: HandleType;
  var ##s#1_0_2_2: Seq Box;
  var ##f#1_0_0: HandleType;
  var ##s#1_0_0: Seq Box;

    // AddMethodImpl: LemmaMapDistributesOverConcat, Impl$$Seq.__default.LemmaMapDistributesOverConcat
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc) ==> false);
    $initHeapForallStmt#0 := $Heap;
    havoc $Heap, $Tick;
    assume $initHeapForallStmt#0 == $Heap;
    assume (forall $ih#f0#0: HandleType, $ih#a0#0: Seq Box, $ih#b0#0: Seq Box :: 
      $Is($ih#f0#0, 
            Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R))
           && $Is($ih#a0#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
           && $Is($ih#b0#0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T))
           && 
          (forall i#5: int :: 
            { Seq#Index($ih#a0#0, i#5) } 
            true
               ==> 
              LitInt(0) <= i#5 && i#5 < Seq#Length($ih#a0#0)
               ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $initHeapForallStmt#0, 
                $ih#f0#0, 
                Seq#Index($ih#a0#0, i#5)))
           && (forall j#2: int :: 
            { Seq#Index($ih#b0#0, j#2) } 
            true
               ==> 
              LitInt(0) <= j#2 && j#2 < Seq#Length($ih#b0#0)
               ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $initHeapForallStmt#0, 
                $ih#f0#0, 
                Seq#Index($ih#b0#0, j#2)))
           && (Seq#Rank($ih#a0#0) < Seq#Rank(a#0)
             || (Seq#Rank($ih#a0#0) == Seq#Rank(a#0) && Seq#Rank($ih#b0#0) < Seq#Rank(b#0)))
         ==> Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R, 
            StartFuel_Seq._default.Map, 
            $Heap, 
            $ih#f0#0, 
            Seq#Append($ih#a0#0, $ih#b0#0)), 
          Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              StartFuel_Seq._default.Map, 
              $Heap, 
              $ih#f0#0, 
              $ih#a0#0), 
            Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              StartFuel_Seq._default.Map, 
              $Heap, 
              $ih#f0#0, 
              $ih#b0#0))));
    $_reverifyPost := false;
    // ----- reveal statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(613,5)
    // ----- call statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(613,15)
    // TrCallStmt: Before ProcessCallStmt
    // ProcessCallStmt: Make the call
    call Call$$Seq.__default.reveal__Map();
    // TrCallStmt: After ProcessCallStmt
    // ----- if statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(614,5)
    assume true;
    if (Seq#Length(a#0) == LitInt(0))
    {
        // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(615,7)
        assume true;
        assert Seq#Equal(Seq#Append(a#0, b#0), b#0);
    }
    else
    {
        // ----- calc statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
        // Assume Fuel Constant
        if (*)
        {
            // ----- assert wf[initial] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            ##f#1_0_0 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_0: int :: 
              { Seq#Index(##s#1_0_0, i#1_0_0) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0 && i#1_0_0 < Seq#Length(##s#1_0_0)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0, 
                  Seq#Index(##s#1_0_0, i#1_0_0)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(a#0, b#0));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(a#0, b#0));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            ##f#1_0_2_0 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_2_0, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_2_0 := Seq#Append(a#0, b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_2_0: int :: 
              { Seq#Index(##s#1_0_2_0, i#1_0_2_0) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_2_0 && i#1_0_2_0 < Seq#Length(##s#1_0_2_0)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_2_0, 
                  Seq#Index(##s#1_0_2_0, i#1_0_2_0)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(a#0, b#0));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(a#0, b#0));
            // ----- Hint0 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(619,13)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(Seq#Append(a#0, b#0));
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            assume true;
            assert Seq#Index(Seq#Append(a#0, b#0), LitInt(0)) == Seq#Index(a#0, LitInt(0));
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(619,40)
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(Seq#Append(a#0, b#0));
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            assume true;
            assert Seq#Equal(Seq#Drop(Seq#Append(a#0, b#0), LitInt(1)), 
              Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            ##f#1_0_2_1 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_2_1, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_2_1 := Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_1, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_2_1: int :: 
              { Seq#Index(##s#1_0_2_1, i#1_0_2_1) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_2_1 && i#1_0_2_1 < Seq#Length(##s#1_0_2_1)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_2_1, 
                  Seq#Index(##s#1_0_2_1, i#1_0_2_1)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))));
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##f#1_0_2_2 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_2_2, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_2_2 := Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_2_2, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_2_2: int :: 
              { Seq#Index(##s#1_0_2_2, i#1_0_2_2) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_2_2 && i#1_0_2_2 < Seq#Length(##s#1_0_2_2)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_2_2, 
                  Seq#Index(##s#1_0_2_2, i#1_0_2_2)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- assert line0 == line1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assert {:subsumption 0} Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                StartFuelAssert_Seq._default.Map, 
                $Heap, 
                f#0, 
                Seq#Append(a#0, b#0)), 
              Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)))), 
                Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0))));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assume {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            ##f#1_0_1_0 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_1_0, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_1_0 := Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_1_0: int :: 
              { Seq#Index(##s#1_0_1_0, i#1_0_1_0) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_1_0 && i#1_0_1_0 < Seq#Length(##s#1_0_1_0)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_1_0, 
                  Seq#Index(##s#1_0_1_0, i#1_0_1_0)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))));
            assume {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##f#1_0_1_1 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_1_1, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_1_1 := Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0);
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_1, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_1_1: int :: 
              { Seq#Index(##s#1_0_1_1, i#1_0_1_1) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_1_1 && i#1_0_1_1 < Seq#Length(##s#1_0_1_1)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_1_1, 
                  Seq#Index(##s#1_0_1_1, i#1_0_1_1)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0));
            // ----- Hint1 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            ##f#1_0_1_2 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_1_2, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_1_2 := Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_2, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_1_2: int :: 
              { Seq#Index(##s#1_0_1_2, i#1_0_1_2) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_1_2 && i#1_0_1_2 < Seq#Length(##s#1_0_1_2)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_1_2, 
                  Seq#Index(##s#1_0_1_2, i#1_0_1_2)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))));
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##f#1_0_1_3 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_1_3, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_1_3 := Seq#Drop(a#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_3, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_1_3: int :: 
              { Seq#Index(##s#1_0_1_3, i#1_0_1_3) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_1_3 && i#1_0_1_3 < Seq#Length(##s#1_0_1_3)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_1_3, 
                  Seq#Index(##s#1_0_1_3, i#1_0_1_3)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Drop(a#0, LitInt(1)));
            ##f#1_0_1_4 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_1_4, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_1_4 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_1_4, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_1_4: int :: 
              { Seq#Index(##s#1_0_1_4, i#1_0_1_4) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_1_4 && i#1_0_1_4 < Seq#Length(##s#1_0_1_4)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_1_4, 
                  Seq#Index(##s#1_0_1_4, i#1_0_1_4)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              b#0);
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Drop(a#0, LitInt(1)))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                b#0);
            // ----- assert line1 == line2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)))), 
                Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  Seq#Append(Seq#Drop(a#0, LitInt(1)), b#0))), 
              Seq#Append(Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                    Seq._default.LemmaMapDistributesOverConcat$R, 
                    StartFuelAssert_Seq._default.Map, 
                    $Heap, 
                    f#0, 
                    Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)))), 
                  Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                    Seq._default.LemmaMapDistributesOverConcat$R, 
                    StartFuelAssert_Seq._default.Map, 
                    $Heap, 
                    f#0, 
                    Seq#Drop(a#0, LitInt(1)))), 
                Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  b#0)));
            assume false;
        }
        else if (*)
        {
            // ----- assume wf[lhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assume {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(a#0);
            ##f#1_0_0_0 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0_0, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0_0 := Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_0, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_0_0: int :: 
              { Seq#Index(##s#1_0_0_0, i#1_0_0_0) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0_0 && i#1_0_0_0 < Seq#Length(##s#1_0_0_0)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0_0, 
                  Seq#Index(##s#1_0_0_0, i#1_0_0_0)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))));
            assume {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            ##f#1_0_0_1 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0_1, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0_1 := Seq#Drop(a#0, LitInt(1));
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_1, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_0_1: int :: 
              { Seq#Index(##s#1_0_0_1, i#1_0_0_1) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0_1 && i#1_0_0_1 < Seq#Length(##s#1_0_0_1)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0_1, 
                  Seq#Index(##s#1_0_0_1, i#1_0_0_1)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              Seq#Drop(a#0, LitInt(1)));
            ##f#1_0_0_2 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0_2, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0_2 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_2, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assume {:subsumption 0} (forall i#1_0_0_2: int :: 
              { Seq#Index(##s#1_0_0_2, i#1_0_0_2) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0_2 && i#1_0_0_2 < Seq#Length(##s#1_0_0_2)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0_2, 
                  Seq#Index(##s#1_0_0_2, i#1_0_0_2)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              b#0);
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0))))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                Seq#Drop(a#0, LitInt(1)))
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                b#0);
            // ----- Hint2 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            // ----- assert statement ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(622,12)
            assert {:subsumption 0} 0 <= LitInt(0) && LitInt(0) < Seq#Length(Seq#Append(a#0, b#0));
            assert {:subsumption 0} 0 <= LitInt(1) && LitInt(1) <= Seq#Length(a#0);
            assume true;
            assert Seq#Equal(Seq#Append(Seq#Append(Seq#Build(Seq#Empty(): Seq Box, Seq#Index(Seq#Append(a#0, b#0), LitInt(0))), 
                  Seq#Drop(a#0, LitInt(1))), 
                b#0), 
              Seq#Append(a#0, b#0));
            // ----- assert wf[rhs] ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            ##f#1_0_0_3 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0_3, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0_3 := a#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_3, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_0_3: int :: 
              { Seq#Index(##s#1_0_0_3, i#1_0_0_3) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0_3 && i#1_0_0_3 < Seq#Length(##s#1_0_0_3)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0_3, 
                  Seq#Index(##s#1_0_0_3, i#1_0_0_3)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              a#0);
            ##f#1_0_0_4 := f#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##f#1_0_0_4, 
              Tclass._System.___hFunc1(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R), 
              $Heap);
            ##s#1_0_0_4 := b#0;
            // assume allocatedness for argument to function
            assume $IsAlloc(##s#1_0_0_4, TSeq(Seq._default.LemmaMapDistributesOverConcat$T), $Heap);
            assert {:subsumption 0} (forall i#1_0_0_4: int :: 
              { Seq#Index(##s#1_0_0_4, i#1_0_0_4) } 
              true
                 ==> 
                LitInt(0) <= i#1_0_0_4 && i#1_0_0_4 < Seq#Length(##s#1_0_0_4)
                 ==> Requires1(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  $Heap, 
                  ##f#1_0_0_4, 
                  Seq#Index(##s#1_0_0_4, i#1_0_0_4)));
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              $Heap, 
              f#0, 
              b#0);
            assume Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                a#0)
               && Seq.__default.Map#canCall(Seq._default.LemmaMapDistributesOverConcat$T, 
                Seq._default.LemmaMapDistributesOverConcat$R, 
                $Heap, 
                f#0, 
                b#0);
            // ----- assert line2 == line3 ----- /Users/aarotomb/Repositories/libraries/src/Collections/Sequences/Seq.dfy(617,7)
            assert {:subsumption 0} Seq#Equal(Seq#Append(Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                    Seq._default.LemmaMapDistributesOverConcat$R, 
                    StartFuelAssert_Seq._default.Map, 
                    $Heap, 
                    f#0, 
                    Seq#Build(Seq#Empty(): Seq Box, Seq#Index(a#0, LitInt(0)))), 
                  Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                    Seq._default.LemmaMapDistributesOverConcat$R, 
                    StartFuelAssert_Seq._default.Map, 
                    $Heap, 
                    f#0, 
                    Seq#Drop(a#0, LitInt(1)))), 
                Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  b#0)), 
              Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  a#0), 
                Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
                  Seq._default.LemmaMapDistributesOverConcat$R, 
                  StartFuelAssert_Seq._default.Map, 
                  $Heap, 
                  f#0, 
                  b#0)));
            assume false;
        }

        assume Seq#Equal(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
            Seq._default.LemmaMapDistributesOverConcat$R, 
            StartFuel_Seq._default.Map, 
            $Heap, 
            f#0, 
            Seq#Append(a#0, b#0)), 
          Seq#Append(Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              StartFuel_Seq._default.Map, 
              $Heap, 
              f#0, 
              a#0), 
            Seq.__default.Map(Seq._default.LemmaMapDistributesOverConcat$T, 
              Seq._default.LemmaMapDistributesOverConcat$R, 
              StartFuel_Seq._default.Map, 
              $Heap, 
              f#0, 
              b#0)));
    }
}



// function declaration for Seq._default.Filter
function Seq.__default.Filter(Seq._default.Filter$T: Ty, 
    $ly: LayerType, 
    $heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box)
   : Seq Box;

function Seq.__default.Filter#canCall(Seq._default.Filter$T: Ty, $heap: Heap, f#0: HandleType, s#0: Seq Box) : bool;

// layer synonym axiom
axiom (forall Seq._default.Filter$T: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Filter(Seq._default.Filter$T, $LS($ly), $Heap, f#0, s#0) } 
  Seq.__default.Filter(Seq._default.Filter$T, $LS($ly), $Heap, f#0, s#0)
     == Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0));

// fuel synonym axiom
axiom (forall Seq._default.Filter$T: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Filter(Seq._default.Filter$T, AsFuelBottom($ly), $Heap, f#0, s#0) } 
  Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0)
     == Seq.__default.Filter(Seq._default.Filter$T, $LZ, $Heap, f#0, s#0));

// frame axiom for Seq.__default.Filter
axiom (forall Seq._default.Filter$T: Ty, 
    $ly: LayerType, 
    $h0: Heap, 
    $h1: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { $IsHeapAnchor($h0), $HeapSucc($h0, $h1), Seq.__default.Filter(Seq._default.Filter$T, $ly, $h1, f#0, s#0) } 
  $IsGoodHeap($h0)
       && $IsGoodHeap($h1)
       && (Seq.__default.Filter#canCall(Seq._default.Filter$T, $h0, f#0, s#0)
         || ($Is(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool))
           && $Is(s#0, TSeq(Seq._default.Filter$T))))
       && 
      $IsHeapAnchor($h0)
       && $HeapSucc($h0, $h1)
     ==> 
    (forall<alpha> $o: ref, $f: Field alpha :: 
      $o != null
           && (exists _x0#0: Box, _o0#0: ref :: 
            $IsBox(_x0#0, Seq._default.Filter$T)
               && $Is(_o0#0, Tclass._System.object?())
               && Reads1(Seq._default.Filter$T, TBool, $h0, f#0, _x0#0)[$Box(_o0#0)]
               && $Box($o) == $Box(_o0#0))
         ==> read($h0, $o, $f) == read($h1, $o, $f))
     ==> Seq.__default.Filter(Seq._default.Filter$T, $ly, $h0, f#0, s#0)
       == Seq.__default.Filter(Seq._default.Filter$T, $ly, $h1, f#0, s#0));

// consequence axiom for Seq.__default.Filter
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Filter$T: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0) } 
    Seq.__default.Filter#canCall(Seq._default.Filter$T, $Heap, f#0, s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool))
           && $Is(s#0, TSeq(Seq._default.Filter$T))
           && (forall i#0: int :: 
            { Seq#Index(s#0, i#0) } 
            true
               ==> 
              LitInt(0) <= i#0 && i#0 < Seq#Length(s#0)
               ==> Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#0))))
       ==> Seq#Length(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0))
           <= Seq#Length(s#0)
         && (forall i#1: int :: 
          { Seq#Index(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0), i#1) } 
          LitInt(0) <= i#1
             ==> 
            i#1
                 < Seq#Length(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0))
               && Requires1(Seq._default.Filter$T, 
                TBool, 
                $Heap, 
                f#0, 
                Seq#Index(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0), i#1))
             ==> $Unbox(Apply1(Seq._default.Filter$T, 
                TBool, 
                $Heap, 
                f#0, 
                Seq#Index(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0), i#1))): bool)
         && $Is(Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, s#0), 
          TSeq(Seq._default.Filter$T)));

function Seq.__default.Filter#requires(Ty, LayerType, Heap, HandleType, Seq Box) : bool;

// #requires axiom for Seq.__default.Filter
axiom (forall Seq._default.Filter$T: Ty, 
    $ly: LayerType, 
    $Heap: Heap, 
    f#0: HandleType, 
    s#0: Seq Box :: 
  { Seq.__default.Filter#requires(Seq._default.Filter$T, $ly, $Heap, f#0, s#0), $IsGoodHeap($Heap) } 
  $IsGoodHeap($Heap)
       && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool))
       && $Is(s#0, TSeq(Seq._default.Filter$T))
     ==> Seq.__default.Filter#requires(Seq._default.Filter$T, $ly, $Heap, f#0, s#0)
       == (forall i#2: int :: 
        { Seq#Index(s#0, i#2) } 
        true
           ==> 
          LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
           ==> Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#2))));

// definition axiom for Seq.__default.Filter (revealed)
axiom 0 <= $FunctionContextHeight
   ==> (forall Seq._default.Filter$T: Ty, 
      $ly: LayerType, 
      $Heap: Heap, 
      f#0: HandleType, 
      s#0: Seq Box :: 
    { Seq.__default.Filter(Seq._default.Filter$T, $LS($ly), $Heap, f#0, s#0), $IsGoodHeap($Heap) } 
    Seq.__default.Filter#canCall(Seq._default.Filter$T, $Heap, f#0, s#0)
         || (0 != $FunctionContextHeight
           && 
          $IsGoodHeap($Heap)
           && $Is(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool))
           && $Is(s#0, TSeq(Seq._default.Filter$T))
           && (forall i#2: int :: 
            { Seq#Index(s#0, i#2) } 
            true
               ==> 
              LitInt(0) <= i#2 && i#2 < Seq#Length(s#0)
               ==> Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#2))))
       ==> (Seq#Length(s#0) != LitInt(0)
           ==> Seq.__default.Filter#canCall(Seq._default.Filter$T, $Heap, f#0, Seq#Drop(s#0, LitInt(1))))
         && Seq.__default.Filter(Seq._default.Filter$T, $LS($ly), $Heap, f#0, s#0)
           == (if Seq#Length(s#0) == LitInt(0)
             then Seq#Empty(): Seq Box
             else Seq#Append((if $Unbox(Apply1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, LitInt(0)))): bool
                 then Seq#Build(Seq#Empty(): Seq Box, Seq#Index(s#0, LitInt(0)))
                 else Seq#Empty(): Seq Box), 
              Seq.__default.Filter(Seq._default.Filter$T, $ly, $Heap, f#0, Seq#Drop(s#0, LitInt(1))))));

procedure {:verboseName "Seq.Filter (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Filter(Seq._default.Filter$T: Ty, 
    f#0: HandleType
       where $Is(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool)), 
    s#0: Seq Box where $Is(s#0, TSeq(Seq._default.Filter$T)))
   returns (result#0: Seq Box where $Is(result#0, TSeq(Seq._default.Filter$T)));
  free requires 0 == $FunctionContextHeight;
  modifies $Heap, $Tick;
  ensures Seq#Length(result#0) <= Seq#Length(s#0);
  ensures (forall i#3: int :: 
    { Seq#Index(result#0, i#3) } 
    LitInt(0) <= i#3
       ==> 
      i#3 < Seq#Length(result#0)
         && Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(result#0, i#3))
       ==> $Unbox(Apply1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(result#0, i#3))): bool);



function Reads1#Handle(#$T0: Ty, #$R: Ty, $self: HandleType) : HandleType;

axiom (forall #$T0: Ty, #$R: Ty, $self: HandleType, $heap: Heap, $fh$0x#0: Box :: 
  { Apply1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0) } 
  Apply1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0)
     == $Box(Reads1(#$T0, #$R, $heap, $self, $fh$0x#0)));

axiom (forall #$T0: Ty, #$R: Ty, $self: HandleType, $heap: Heap, $fh$0x#0: Box :: 
  { Requires1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0) } 
  Requires1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0)
     == true);

axiom (forall $bx: Box, #$T0: Ty, #$R: Ty, $self: HandleType, $heap: Heap, $fh$0x#0: Box :: 
  { Reads1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0)[$bx] } 
  Reads1(#$T0, 
      TSet(Tclass._System.object?()), 
      $heap, 
      Reads1#Handle(#$T0, #$R, $self), 
      $fh$0x#0)[$bx]
     == Reads1(#$T0, #$R, $heap, $self, $fh$0x#0)[$bx]);

axiom (forall #$T0: Ty, #$R: Ty, $self: HandleType, $heap: Heap, $fh$0x#0: Box :: 
  { Reads1(#$T0, #$R, $heap, $self, $fh$0x#0) } 
  Reads1(#$T0, #$R, $heap, $self, $fh$0x#0)
     == $Unbox(Apply1(#$T0, 
        TSet(Tclass._System.object?()), 
        $heap, 
        Reads1#Handle(#$T0, #$R, $self), 
        $fh$0x#0)): Set Box);

implementation {:verboseName "Seq.Filter (well-formedness)"} {:opaque} CheckWellformed$$Seq.__default.Filter(Seq._default.Filter$T: Ty, f#0: HandleType, s#0: Seq Box)
   returns (result#0: Seq Box)
{
  var $_Frame: <beta>[ref,Field beta]bool;
  var i#4: int;
  var ##x0#0: Box;
  var b$reqreads#0: bool;
  var _x0#1: Box;
  var _o0#1: ref;
  var i#6: int;
  var ##x0#1: Box;
  var ##f#0: HandleType;
  var ##s#0: Seq Box;
  var b$reqreads#1: bool;
  var b$reqreads#2: bool;

    b$reqreads#0 := true;
    b$reqreads#1 := true;
    b$reqreads#2 := true;

    // AddWellformednessCheck for function Filter
    $_Frame := (lambda<alpha> $o: ref, $f: Field alpha :: 
      $o != null && read($Heap, $o, alloc)
         ==> (exists _x1#0: Box, _o1#0: ref :: 
          $IsBox(_x1#0, Seq._default.Filter$T)
             && $Is(_o1#0, Tclass._System.object?())
             && Reads1(Seq._default.Filter$T, TBool, $Heap, f#0, _x1#0)[$Box(_o1#0)]
             && $Box($o) == $Box(_o1#0)));
    // initialize fuel constant
    assume AsFuelBottom(StartFuel_Seq._default.ToSet) == StartFuel_Seq._default.ToSet;
    assume AsFuelBottom(StartFuelAssert_Seq._default.ToSet)
       == StartFuelAssert_Seq._default.ToSet;
    assume AsFuelBottom(StartFuel_Seq._default.HasNoDuplicates)
       == StartFuel_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuelAssert_Seq._default.HasNoDuplicates)
       == StartFuelAssert_Seq._default.HasNoDuplicates;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOf) == StartFuel_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOf)
       == StartFuelAssert_Seq._default.IndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.IndexOfOption)
       == StartFuel_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.IndexOfOption)
       == StartFuelAssert_Seq._default.IndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOf)
       == StartFuel_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOf)
       == StartFuelAssert_Seq._default.LastIndexOf;
    assume AsFuelBottom(StartFuel_Seq._default.LastIndexOfOption)
       == StartFuel_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuelAssert_Seq._default.LastIndexOfOption)
       == StartFuelAssert_Seq._default.LastIndexOfOption;
    assume AsFuelBottom(StartFuel_Seq._default.Remove) == StartFuel_Seq._default.Remove;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Remove)
       == StartFuelAssert_Seq._default.Remove;
    assume AsFuelBottom(StartFuel_Seq._default.RemoveValue)
       == StartFuel_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuelAssert_Seq._default.RemoveValue)
       == StartFuelAssert_Seq._default.RemoveValue;
    assume AsFuelBottom(StartFuel_Seq._default.Insert) == StartFuel_Seq._default.Insert;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Insert)
       == StartFuelAssert_Seq._default.Insert;
    assume AsFuelBottom(StartFuel_Seq._default.Reverse) == StartFuel_Seq._default.Reverse;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Reverse)
       == StartFuelAssert_Seq._default.Reverse;
    assume AsFuelBottom(StartFuel_Seq._default.Repeat) == StartFuel_Seq._default.Repeat;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Repeat)
       == StartFuelAssert_Seq._default.Repeat;
    assume AsFuelBottom(StartFuel_Seq._default.Unzip) == StartFuel_Seq._default.Unzip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Unzip)
       == StartFuelAssert_Seq._default.Unzip;
    assume AsFuelBottom(StartFuel_Seq._default.Zip) == StartFuel_Seq._default.Zip;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Zip)
       == StartFuelAssert_Seq._default.Zip;
    assume AsFuelBottom(StartFuel_Seq._default.Max) == StartFuel_Seq._default.Max;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Max)
       == StartFuelAssert_Seq._default.Max;
    assume AsFuelBottom(StartFuel_Seq._default.Min) == StartFuel_Seq._default.Min;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Min)
       == StartFuelAssert_Seq._default.Min;
    assume AsFuelBottom(StartFuel_Seq._default.Map) == StartFuel_Seq._default.Map;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Map)
       == StartFuelAssert_Seq._default.Map;
    assume AsFuelBottom(StartFuel_Seq._default.MapWithResult)
       == StartFuel_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuelAssert_Seq._default.MapWithResult)
       == StartFuelAssert_Seq._default.MapWithResult;
    assume AsFuelBottom(StartFuel_Seq._default.Filter) == StartFuel_Seq._default.Filter;
    assume AsFuelBottom(StartFuelAssert_Seq._default.Filter)
       == StartFuelAssert_Seq._default.Filter;
    assume AsFuelBottom(StartFuel_Seq._default.FoldLeft) == StartFuel_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldLeft)
       == StartFuelAssert_Seq._default.FoldLeft;
    assume AsFuelBottom(StartFuel_Seq._default.FoldRight)
       == StartFuel_Seq._default.FoldRight;
    assume AsFuelBottom(StartFuelAssert_Seq._default.FoldRight)
       == StartFuelAssert_Seq._default.FoldRight;
    havoc i#4;
    assume true;
    if (*)
    {
        if (LitInt(0) <= i#4)
        {
        }

        assume LitInt(0) <= i#4 && i#4 < Seq#Length(s#0);
        // assume allocatedness for receiver argument to function
        assume $IsAlloc(f#0, Tclass._System.___hFunc1(Seq._default.Filter$T, TBool), $Heap);
        assert 0 <= i#4 && i#4 < Seq#Length(s#0);
        ##x0#0 := Seq#Index(s#0, i#4);
        // assume allocatedness for argument to function
        assume $IsAllocBox(##x0#0, Seq._default.Filter$T, $Heap);
        b$reqreads#0 := (forall<alpha> $o: ref, $f: Field alpha :: 
          $o != null
               && read($Heap, $o, alloc)
               && Reads1(Seq._default.Filter$T, TBool, $Heap, f#0, ##x0#0)[$Box($o)]
             ==> $_Frame[$o, $f]);
        assume Requires1#canCall(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#4));
        assume Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#4));
    }
    else
    {
        assume LitInt(0) <= i#4 && i#4 < Seq#Length(s#0)
           ==> Requires1(Seq._default.Filter$T, TBool, $Heap, f#0, Seq#Index(s#0, i#4));
    }

    assume (forall i#5: int :: 
      { Seq#Index(s#0, i#5) } 
      true
         ==> 
        LitInt(0) <= i#5 && i#5 < Seq#Length(s#0)
         ==> Req