/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.pass.Pass;
import proguard.preverify.CodeSubroutineInliner;

public class SubroutineInliner
implements Pass {
    private static final Logger logger = LogManager.getLogger(SubroutineInliner.class);
    private final Configuration configuration;

    public SubroutineInliner(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) {
        logger.info("Inlining subroutines...");
        appView.programClassPool.classesAccept(new ClassCleaner());
        ClassVisitor inliner = new AllMethodVisitor(new AllAttributeVisitor(new CodeSubroutineInliner()));
        if (!this.configuration.microEdition && !this.configuration.android) {
            inliner = new ClassVersionFilter(0x320000, inliner);
        }
        appView.programClassPool.classesAccept(inliner);
    }
}

