/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.visitor.KotlinAnnotationArgumentVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.Processable;
import proguard.util.SimpleProcessable;

public class KotlinAnnotationArgument
extends SimpleProcessable
implements Processable {
    public String name;
    public Clazz referencedAnnotationMethodClass;
    public Method referencedAnnotationMethod;
    private final Value value;

    public KotlinAnnotationArgument(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgumentVisitor visitor) {
        this.value.accept(clazz, annotatable, annotation, this, visitor);
    }

    public void referencedMethodAccept(MemberVisitor methodVisitor) {
        if (this.referencedAnnotationMethod != null) {
            this.referencedAnnotationMethod.accept(this.referencedAnnotationMethodClass, methodVisitor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KotlinAnnotationArgument that = (KotlinAnnotationArgument)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return this.name + " = " + this.value;
    }

    public static final class ArrayValue
    implements Value {
        public List<? extends Value> elements;

        public ArrayValue(List<? extends Value> elements) {
            this.elements = elements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayValue that = (ArrayValue)o;
            return this.elements.equals(that.elements);
        }

        public int hashCode() {
            return Objects.hash(this.elements);
        }

        public String toString() {
            return this.elements.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitArrayArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }

        public void elementsAccept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            this.elements.forEach(element -> element.accept(clazz, annotatable, kotlinAnnotation, argument, visitor));
        }
    }

    public static final class AnnotationValue
    implements Value {
        public KotlinAnnotation kotlinMetadataAnnotation;

        public AnnotationValue(KotlinAnnotation kotlinMetadataAnnotation) {
            this.kotlinMetadataAnnotation = kotlinMetadataAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationValue that = (AnnotationValue)o;
            return this.kotlinMetadataAnnotation.equals(that.kotlinMetadataAnnotation);
        }

        public int hashCode() {
            return Objects.hash(this.kotlinMetadataAnnotation);
        }

        public String toString() {
            return this.kotlinMetadataAnnotation.toString();
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitAnnotationArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }

        public void annotationAccept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotationVisitor visitor) {
            this.kotlinMetadataAnnotation.accept(clazz, annotatable, visitor);
        }
    }

    public static final class EnumValue
    implements Value {
        public String className;
        public Clazz referencedClass;
        public String enumEntryName;

        public EnumValue(String className, String enumEntryName) {
            this.className = className;
            this.enumEntryName = enumEntryName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnumValue enumValue = (EnumValue)o;
            return this.className.equals(enumValue.className) && this.enumEntryName.equals(enumValue.enumEntryName);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.enumEntryName);
        }

        public String toString() {
            return ClassUtil.externalClassName(this.className) + "." + this.enumEntryName;
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitEnumArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }

        public void referencedClassAccept(ClassVisitor visitor) {
            if (this.referencedClass != null) {
                this.referencedClass.accept(visitor);
            }
        }
    }

    public static final class ClassValue
    implements Value {
        public String className;
        public Clazz referencedClass;
        public int arrayDimensionsCount;

        public ClassValue(String className) {
            this(className, 0);
        }

        public ClassValue(String className, int arrayDimensionsCount) {
            this.className = className;
            this.arrayDimensionsCount = arrayDimensionsCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassValue that = (ClassValue)o;
            return this.arrayDimensionsCount == that.arrayDimensionsCount && this.className.equals(that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.arrayDimensionsCount);
        }

        public String toString() {
            return String.join((CharSequence)"", Collections.nCopies(this.arrayDimensionsCount, "[")) + ClassUtil.externalClassName(this.className);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitClassArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }

        public void referencedClassAccept(ClassVisitor visitor) {
            if (this.referencedClass != null) {
                this.referencedClass.accept(visitor);
            }
        }
    }

    public static final class StringValue
    extends LiteralValue<String> {
        public StringValue(String value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitStringArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class ULongValue
    extends LiteralValue<Long> {
        public ULongValue(long value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitULongArgument(clazz, annotatable, annotation, argument, this);
        }
    }

    public static final class UIntValue
    extends LiteralValue<Integer> {
        public UIntValue(int value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitUIntArgument(clazz, annotatable, annotation, argument, this);
        }
    }

    public static final class UShortValue
    extends LiteralValue<Short> {
        public UShortValue(short value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitUShortArgument(clazz, annotatable, annotation, argument, this);
        }
    }

    public static final class UByteValue
    extends LiteralValue<Byte> {
        public UByteValue(byte value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitUByteArgument(clazz, annotatable, annotation, argument, this);
        }
    }

    public static final class BooleanValue
    extends LiteralValue<Boolean> {
        public BooleanValue(boolean value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitBooleanArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class DoubleValue
    extends LiteralValue<Double> {
        public DoubleValue(double value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitDoubleArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class FloatValue
    extends LiteralValue<Float> {
        public FloatValue(float value) {
            super(Float.valueOf(value));
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitFloatArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class LongValue
    extends LiteralValue<Long> {
        public LongValue(long value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitLongArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class IntValue
    extends LiteralValue<Integer> {
        public IntValue(int value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitIntArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class ShortValue
    extends LiteralValue<Short> {
        public ShortValue(short value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitShortArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class CharValue
    extends LiteralValue<Character> {
        public CharValue(char value) {
            super(Character.valueOf(value));
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitCharArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static final class ByteValue
    extends LiteralValue<Byte> {
        public ByteValue(byte value) {
            super(value);
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation kotlinMetadataAnnotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitByteArgument(clazz, annotatable, kotlinMetadataAnnotation, argument, this);
        }
    }

    public static class LiteralValue<T>
    implements Value {
        public final T value;

        public LiteralValue(T value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LiteralValue that = (LiteralValue)o;
            return this.value.equals(that.value);
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgumentVisitor visitor) {
            visitor.visitAnyLiteralArgument(clazz, annotatable, annotation, argument, this);
        }
    }

    public static interface Value {
        public void accept(Clazz var1, KotlinAnnotatable var2, KotlinAnnotation var3, KotlinAnnotationArgument var4, KotlinAnnotationArgumentVisitor var5);
    }
}

