/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public interface TraceExtractor<AbstractStateT extends LatticeAbstractState<AbstractStateT>> {
    default public Set<List<JvmMemoryLocation>> extractLinearTraces() {
        HashSet<List<JvmMemoryLocation>> result = new HashSet<List<JvmMemoryLocation>>();
        for (JvmMemoryLocation l : this.getEndPoints()) {
            ArrayList<JvmMemoryLocation> trace = new ArrayList<JvmMemoryLocation>();
            trace.add(l);
            this.traceExtractionIteration(result, trace);
        }
        return result.stream().map(this::removeDuplicateProgramLocations).collect(Collectors.toSet());
    }

    public Collection<JvmMemoryLocation> getEndPoints();

    public ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, JvmMemoryLocationAbstractState, MethodSignature> getOutputReachedSet();

    default public void traceExtractionIteration(Set<List<JvmMemoryLocation>> result, List<JvmMemoryLocation> currentTrace) {
        JvmMemoryLocation currentNode = currentTrace.get(currentTrace.size() - 1);
        ArrayList<JvmMemoryLocationAbstractState> currentStates = new ArrayList<JvmMemoryLocationAbstractState>();
        for (AbstractState s : this.getOutputReachedSet().getReached((JvmCfaNode)currentNode.getProgramLocation())) {
            if (!((JvmMemoryLocationAbstractState)s).getMemoryLocation().equals(currentNode)) continue;
            currentStates.add((JvmMemoryLocationAbstractState)s);
        }
        Set<JvmMemoryLocation> sourceLocations = ((JvmMemoryLocationAbstractState)currentStates.get(0)).getSourceLocations();
        if (sourceLocations.size() == 0) {
            result.add(currentTrace);
        }
        for (JvmMemoryLocation l : sourceLocations) {
            if (currentTrace.contains(l)) continue;
            ArrayList<JvmMemoryLocation> trace = new ArrayList<JvmMemoryLocation>(currentTrace);
            trace.add(l);
            this.traceExtractionIteration(result, trace);
        }
    }

    default public List<JvmMemoryLocation> removeDuplicateProgramLocations(List<JvmMemoryLocation> trace) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        result.add(trace.get(0));
        for (int i = 1; i < trace.size(); ++i) {
            if (((JvmCfaNode)trace.get(i).getProgramLocation()).getOffset() < 0 || ((JvmCfaNode)((JvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation()).getOffset() == ((JvmCfaNode)trace.get(i).getProgramLocation()).getOffset() && Objects.equals(((JvmCfaNode)((JvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation()).getSignature(), ((JvmCfaNode)trace.get(i).getProgramLocation()).getSignature())) continue;
            result.add(trace.get(i));
        }
        return result;
    }
}

