/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.classfile.Signature;

public abstract class Cfa<CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, SignatureT extends Signature> {
    protected final Map<SignatureT, Map<Integer, CfaNodeT>> functionNodes = new HashMap<SignatureT, Map<Integer, CfaNodeT>>();
    protected final transient Set<CfaNodeT> allNodes = new HashSet<CfaNodeT>();

    public boolean isEmpty() {
        return this.functionNodes.isEmpty();
    }

    public Collection<CfaNodeT> getAllNodes() {
        return this.allNodes;
    }

    public Collection<CfaNodeT> getFunctionEntryNodes() {
        return this.functionNodes.keySet().stream().map(x -> this.functionNodes.get(x).getOrDefault(0, null)).filter(x -> x != null).collect(Collectors.toSet());
    }

    public CfaNodeT getFunctionEntryNode(SignatureT signature) {
        return (CfaNodeT)((CfaNode)this.functionNodes.getOrDefault(signature, Collections.emptyMap()).getOrDefault(0, null));
    }

    public Collection<CfaNodeT> getFunctionNodes(SignatureT signature) {
        return this.functionNodes.getOrDefault(signature, Collections.emptyMap()).values();
    }

    public CfaNodeT getFunctionNode(SignatureT signature, int offset) {
        return (CfaNodeT)((CfaNode)this.functionNodes.getOrDefault(signature, Collections.emptyMap()).getOrDefault(offset, null));
    }

    public void addFunctionEntryNode(SignatureT signature, CfaNodeT node) {
        this.addFunctionNode(signature, node, 0);
    }

    public void addFunctionNode(SignatureT signature, CfaNodeT node, int offset) {
        this.functionNodes.computeIfAbsent(signature, x -> new HashMap()).put(offset, node);
        this.allNodes.add(node);
    }
}

