/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.thoughtworks.xstream.converters.extended.ColorConverter;
import com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.FontConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.BaseException;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.core.util.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.ArrayMapper;
import com.thoughtworks.xstream.mapper.CachingMapper;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import com.thoughtworks.xstream.mapper.EnumMapper;
import com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.thoughtworks.xstream.mapper.ImmutableTypesMapper;
import com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.mapper.OuterClassMapper;
import com.thoughtworks.xstream.mapper.XmlFriendlyMapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Map;

public class XStream {
    private ClassAliasingMapper classAliasingMapper;
    private FieldAliasingMapper fieldAliasingMapper;
    private DefaultImplementationsMapper defaultImplementationsMapper;
    private ImmutableTypesMapper immutableTypesMapper;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private ReflectionProvider reflectionProvider;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private MarshallingStrategy marshallingStrategy;
    private ClassLoaderReference classLoaderReference;
    private ClassMapper classMapper;
    private DefaultConverterLookup converterLookup;
    private JVM jvm = new JVM();
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_REFERENCES = 1003;
    private static final int PRIORITY_NORMAL = 0;
    private static final int PRIORITY_LOW = -10;
    private static final int PRIORITY_VERY_LOW = -20;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$Null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$reflect$Constructor;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Map$Entry;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$Converter;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$Mapper;

    public XStream() {
        this(null, null, new XppDriver());
    }

    public XStream(Converter defaultConverter) {
        this(null, null, new XppDriver(), null);
        this.registerConverter(defaultConverter, -20);
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(null, null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, null, new XppDriver());
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver) {
        this(reflectionProvider, classMapper, driver, null);
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver, String classAttributeIdentifier) {
        if (reflectionProvider == null) {
            reflectionProvider = this.jvm.bestReflectionProvider();
        }
        this.reflectionProvider = reflectionProvider;
        this.hierarchicalStreamDriver = driver;
        this.classLoaderReference = new ClassLoaderReference(new CompositeClassLoader());
        this.classMapper = classMapper == null ? this.buildMapper(classAttributeIdentifier) : classMapper;
        this.converterLookup = new DefaultConverterLookup(this.classMapper);
        this.setupAliases();
        this.setupDefaultImplementations();
        this.setupConverters();
        this.setupImmutableTypes();
        this.setMode(1003);
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver, String classAttributeIdentifier, Converter defaultConverter) {
        this(reflectionProvider, classMapper, driver, classAttributeIdentifier);
        this.registerConverter(defaultConverter, -20);
    }

    private ClassMapper buildMapper(String classAttributeIdentifier) {
        MapperWrapper mapper = new DefaultMapper(this.classLoaderReference, classAttributeIdentifier);
        mapper = new XmlFriendlyMapper(mapper);
        mapper = new ClassAliasingMapper(mapper);
        this.classAliasingMapper = (ClassAliasingMapper)mapper;
        mapper = new FieldAliasingMapper(mapper);
        this.fieldAliasingMapper = (FieldAliasingMapper)mapper;
        mapper = new ImplicitCollectionMapper(mapper);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)mapper;
        mapper = new DynamicProxyMapper(mapper);
        if (JVM.is15()) {
            mapper = new EnumMapper(mapper);
        }
        mapper = new OuterClassMapper(mapper);
        mapper = new ArrayMapper(mapper);
        mapper = new DefaultImplementationsMapper(mapper);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)mapper;
        mapper = new ImmutableTypesMapper(mapper);
        this.immutableTypesMapper = (ImmutableTypesMapper)mapper;
        mapper = this.wrapMapper(mapper);
        mapper = new CachingMapper(mapper);
        return mapper;
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return next;
    }

    protected void setupAliases() {
        this.alias("null", class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = XStream.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null);
        this.alias("int", class$java$lang$Integer == null ? (class$java$lang$Integer = XStream.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.alias("float", class$java$lang$Float == null ? (class$java$lang$Float = XStream.class$("java.lang.Float")) : class$java$lang$Float);
        this.alias("double", class$java$lang$Double == null ? (class$java$lang$Double = XStream.class$("java.lang.Double")) : class$java$lang$Double);
        this.alias("long", class$java$lang$Long == null ? (class$java$lang$Long = XStream.class$("java.lang.Long")) : class$java$lang$Long);
        this.alias("short", class$java$lang$Short == null ? (class$java$lang$Short = XStream.class$("java.lang.Short")) : class$java$lang$Short);
        this.alias("char", class$java$lang$Character == null ? (class$java$lang$Character = XStream.class$("java.lang.Character")) : class$java$lang$Character);
        this.alias("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = XStream.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.alias("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XStream.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.alias("number", class$java$lang$Number == null ? (class$java$lang$Number = XStream.class$("java.lang.Number")) : class$java$lang$Number);
        this.alias("object", class$java$lang$Object == null ? (class$java$lang$Object = XStream.class$("java.lang.Object")) : class$java$lang$Object);
        this.alias("big-int", class$java$math$BigInteger == null ? (class$java$math$BigInteger = XStream.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.alias("big-decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XStream.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.alias("string-buffer", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = XStream.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        this.alias("string", class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String);
        this.alias("java-class", class$java$lang$Class == null ? (class$java$lang$Class = XStream.class$("java.lang.Class")) : class$java$lang$Class);
        this.alias("method", class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = XStream.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
        this.alias("constructor", class$java$lang$reflect$Constructor == null ? (class$java$lang$reflect$Constructor = XStream.class$("java.lang.reflect.Constructor")) : class$java$lang$reflect$Constructor);
        this.alias("date", class$java$util$Date == null ? (class$java$util$Date = XStream.class$("java.util.Date")) : class$java$util$Date);
        this.alias("url", class$java$net$URL == null ? (class$java$net$URL = XStream.class$("java.net.URL")) : class$java$net$URL);
        this.alias("bit-set", class$java$util$BitSet == null ? (class$java$util$BitSet = XStream.class$("java.util.BitSet")) : class$java$util$BitSet);
        this.alias("map", class$java$util$Map == null ? (class$java$util$Map = XStream.class$("java.util.Map")) : class$java$util$Map);
        this.alias("entry", class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = XStream.class$("java.util.Map$Entry")) : class$java$util$Map$Entry);
        this.alias("properties", class$java$util$Properties == null ? (class$java$util$Properties = XStream.class$("java.util.Properties")) : class$java$util$Properties);
        this.alias("list", class$java$util$List == null ? (class$java$util$List = XStream.class$("java.util.List")) : class$java$util$List);
        this.alias("set", class$java$util$Set == null ? (class$java$util$Set = XStream.class$("java.util.Set")) : class$java$util$Set);
        this.alias("linked-list", class$java$util$LinkedList == null ? (class$java$util$LinkedList = XStream.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        this.alias("vector", class$java$util$Vector == null ? (class$java$util$Vector = XStream.class$("java.util.Vector")) : class$java$util$Vector);
        this.alias("tree-map", class$java$util$TreeMap == null ? (class$java$util$TreeMap = XStream.class$("java.util.TreeMap")) : class$java$util$TreeMap);
        this.alias("tree-set", class$java$util$TreeSet == null ? (class$java$util$TreeSet = XStream.class$("java.util.TreeSet")) : class$java$util$TreeSet);
        this.alias("hashtable", class$java$util$Hashtable == null ? (class$java$util$Hashtable = XStream.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        this.alias("awt-color", this.jvm.loadClass("java.awt.Color"));
        this.alias("awt-font", this.jvm.loadClass("java.awt.Font"));
        this.alias("sql-timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = XStream.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        this.alias("sql-time", class$java$sql$Time == null ? (class$java$sql$Time = XStream.class$("java.sql.Time")) : class$java$sql$Time);
        this.alias("sql-date", class$java$sql$Date == null ? (class$java$sql$Date = XStream.class$("java.sql.Date")) : class$java$sql$Date);
        this.alias("file", class$java$io$File == null ? (class$java$io$File = XStream.class$("java.io.File")) : class$java$io$File);
        this.alias("locale", class$java$util$Locale == null ? (class$java$util$Locale = XStream.class$("java.util.Locale")) : class$java$util$Locale);
        this.alias("gregorian-calendar", class$java$util$Calendar == null ? (class$java$util$Calendar = XStream.class$("java.util.Calendar")) : class$java$util$Calendar);
        if (JVM.is14()) {
            this.alias("linked-hash-map", this.jvm.loadClass("java.util.LinkedHashMap"));
            this.alias("linked-hash-set", this.jvm.loadClass("java.util.LinkedHashSet"));
            this.alias("trace", this.jvm.loadClass("java.lang.StackTraceElement"));
            this.alias("currency", this.jvm.loadClass("java.util.Currency"));
            this.alias("auth-subject", this.jvm.loadClass("javax.security.auth.Subject"));
        }
        if (JVM.is15()) {
            this.alias("enum-set", this.jvm.loadClass("java.util.EnumSet"));
            this.alias("enum-map", this.jvm.loadClass("java.util.EnumMap"));
        }
    }

    protected void setupDefaultImplementations() {
        this.addDefaultImplementation(class$java$util$HashMap == null ? (class$java$util$HashMap = XStream.class$("java.util.HashMap")) : class$java$util$HashMap, class$java$util$Map == null ? (class$java$util$Map = XStream.class$("java.util.Map")) : class$java$util$Map);
        this.addDefaultImplementation(class$java$util$ArrayList == null ? (class$java$util$ArrayList = XStream.class$("java.util.ArrayList")) : class$java$util$ArrayList, class$java$util$List == null ? (class$java$util$List = XStream.class$("java.util.List")) : class$java$util$List);
        this.addDefaultImplementation(class$java$util$HashSet == null ? (class$java$util$HashSet = XStream.class$("java.util.HashSet")) : class$java$util$HashSet, class$java$util$Set == null ? (class$java$util$Set = XStream.class$("java.util.Set")) : class$java$util$Set);
        this.addDefaultImplementation(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = XStream.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, class$java$util$Calendar == null ? (class$java$util$Calendar = XStream.class$("java.util.Calendar")) : class$java$util$Calendar);
    }

    protected void setupConverters() {
        ReflectionConverter reflectionConverter = new ReflectionConverter(this.classMapper, this.reflectionProvider);
        this.registerConverter(reflectionConverter, -20);
        this.registerConverter(new SerializableConverter(this.classMapper, this.reflectionProvider), -10);
        this.registerConverter(new ExternalizableConverter(this.classMapper), -10);
        this.registerConverter(new IntConverter(), 0);
        this.registerConverter(new FloatConverter(), 0);
        this.registerConverter(new DoubleConverter(), 0);
        this.registerConverter(new LongConverter(), 0);
        this.registerConverter(new ShortConverter(), 0);
        this.registerConverter(new CharConverter(), 0);
        this.registerConverter(new BooleanConverter(), 0);
        this.registerConverter(new ByteConverter(), 0);
        this.registerConverter(new StringConverter(), 0);
        this.registerConverter(new StringBufferConverter(), 0);
        this.registerConverter(new DateConverter(), 0);
        this.registerConverter(new BitSetConverter(), 0);
        this.registerConverter(new URLConverter(), 0);
        this.registerConverter(new BigIntegerConverter(), 0);
        this.registerConverter(new BigDecimalConverter(), 0);
        this.registerConverter(new ArrayConverter(this.classMapper), 0);
        this.registerConverter(new CharArrayConverter(), 0);
        this.registerConverter(new CollectionConverter(this.classMapper), 0);
        this.registerConverter(new MapConverter(this.classMapper), 0);
        this.registerConverter(new TreeMapConverter(this.classMapper), 0);
        this.registerConverter(new TreeSetConverter(this.classMapper), 0);
        this.registerConverter(new PropertiesConverter(), 0);
        this.registerConverter(new EncodedByteArrayConverter(), 0);
        this.registerConverter(new FileConverter(), 0);
        this.registerConverter(new SqlTimestampConverter(), 0);
        this.registerConverter(new SqlTimeConverter(), 0);
        this.registerConverter(new SqlDateConverter(), 0);
        this.registerConverter(new DynamicProxyConverter(this.classMapper, this.classLoaderReference), 0);
        this.registerConverter(new JavaClassConverter(this.classLoaderReference), 0);
        this.registerConverter(new JavaMethodConverter(), 0);
        this.registerConverter(new FontConverter(), 0);
        this.registerConverter(new ColorConverter(), 0);
        this.registerConverter(new LocaleConverter(), 0);
        this.registerConverter(new GregorianCalendarConverter(), 0);
        if (JVM.is14()) {
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.extended.ThrowableConverter", 0, new Class[]{class$com$thoughtworks$xstream$converters$Converter == null ? (class$com$thoughtworks$xstream$converters$Converter = XStream.class$("com.thoughtworks.xstream.converters.Converter")) : class$com$thoughtworks$xstream$converters$Converter}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.extended.StackTraceElementConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.extended.CurrencyConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.extended.RegexPatternConverter", 0, new Class[]{class$com$thoughtworks$xstream$converters$Converter == null ? (class$com$thoughtworks$xstream$converters$Converter = XStream.class$("com.thoughtworks.xstream.converters.Converter")) : class$com$thoughtworks$xstream$converters$Converter}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.extended.SubjectConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.classMapper});
        }
        if (JVM.is15()) {
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.enums.EnumConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.enums.EnumSetConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.classMapper});
            this.dynamicallyRegisterConverter("com.thoughtworks.xstream.converters.enums.EnumMapConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.classMapper});
        }
    }

    private void dynamicallyRegisterConverter(String className, int priority, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            Converter converter = (Converter)constructor.newInstance(constructorParamValues);
            this.registerConverter(converter, priority);
        }
        catch (Exception e) {
            throw new InitializationException("Could not instatiate converter : " + className, e);
        }
    }

    protected void setupImmutableTypes() {
        this.addImmutableType(Boolean.TYPE);
        this.addImmutableType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XStream.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.addImmutableType(Byte.TYPE);
        this.addImmutableType(class$java$lang$Byte == null ? (class$java$lang$Byte = XStream.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.addImmutableType(Character.TYPE);
        this.addImmutableType(class$java$lang$Character == null ? (class$java$lang$Character = XStream.class$("java.lang.Character")) : class$java$lang$Character);
        this.addImmutableType(Double.TYPE);
        this.addImmutableType(class$java$lang$Double == null ? (class$java$lang$Double = XStream.class$("java.lang.Double")) : class$java$lang$Double);
        this.addImmutableType(Float.TYPE);
        this.addImmutableType(class$java$lang$Float == null ? (class$java$lang$Float = XStream.class$("java.lang.Float")) : class$java$lang$Float);
        this.addImmutableType(Integer.TYPE);
        this.addImmutableType(class$java$lang$Integer == null ? (class$java$lang$Integer = XStream.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.addImmutableType(Long.TYPE);
        this.addImmutableType(class$java$lang$Long == null ? (class$java$lang$Long = XStream.class$("java.lang.Long")) : class$java$lang$Long);
        this.addImmutableType(Short.TYPE);
        this.addImmutableType(class$java$lang$Short == null ? (class$java$lang$Short = XStream.class$("java.lang.Short")) : class$java$lang$Short);
        this.addImmutableType(class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = XStream.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null);
        this.addImmutableType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XStream.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.addImmutableType(class$java$math$BigInteger == null ? (class$java$math$BigInteger = XStream.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.addImmutableType(class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String);
        this.addImmutableType(class$java$net$URL == null ? (class$java$net$URL = XStream.class$("java.net.URL")) : class$java$net$URL);
        this.addImmutableType(class$java$io$File == null ? (class$java$io$File = XStream.class$("java.io.File")) : class$java$io$File);
        this.addImmutableType(class$java$lang$Class == null ? (class$java$lang$Class = XStream.class$("java.lang.Class")) : class$java$lang$Class);
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object obj) {
        StringWriter stringWriter = new StringWriter();
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(stringWriter);
        this.marshal(obj, writer);
        writer.flush();
        writer.close();
        return ((Object)stringWriter).toString();
    }

    public void toXML(Object obj, Writer out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        this.marshal(obj, writer);
        writer.flush();
    }

    public void toXML(Object obj, OutputStream out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        this.marshal(obj, writer);
        writer.flush();
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer) {
        this.marshal(obj, writer, null);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(writer, obj, this.converterLookup, this.classMapper, dataHolder);
    }

    public Object fromXML(String xml) {
        return this.fromXML(new StringReader(xml));
    }

    public Object fromXML(Reader xml) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), null);
    }

    public Object fromXML(InputStream input) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(input), null);
    }

    public Object fromXML(String xml, Object root) {
        return this.fromXML(new StringReader(xml), root);
    }

    public Object fromXML(Reader xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object fromXML(InputStream xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object unmarshal(HierarchicalStreamReader reader) {
        return this.unmarshal(reader, null, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root) {
        return this.unmarshal(reader, root, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.converterLookup, this.classMapper);
    }

    public void alias(String name, Class type) {
        this.classAliasingMapper.addClassAlias(name, type);
    }

    public void alias(String name, Class type, Class defaultImplementation) {
        this.alias(name, type);
        this.addDefaultImplementation(defaultImplementation, type);
    }

    public void aliasField(String alias, Class type, String fieldName) {
        this.fieldAliasingMapper.addFieldAlias(alias, type, fieldName);
    }

    public void addDefaultImplementation(Class defaultImplementation, Class ofType) {
        this.defaultImplementationsMapper.addDefaultImplementation(defaultImplementation, ofType);
    }

    public void addImmutableType(Class type) {
        this.immutableTypesMapper.addImmutableType(type);
    }

    public void changeDefaultConverter(Converter defaultConverter) {
        this.registerConverter(defaultConverter, -20);
    }

    public void registerConverter(Converter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(Converter converter, int priority) {
        this.converterLookup.registerConverter(converter, priority);
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
    }

    public void addDefaultCollection(Class ownerType, String fieldName) {
        this.addImplicitCollection(ownerType, fieldName);
    }

    public void addImplicitCollection(Class ownerType, String fieldName) {
        this.implicitCollectionMapper.add(ownerType, fieldName, null, class$java$lang$Object == null ? (class$java$lang$Object = XStream.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, Class itemType) {
        this.implicitCollectionMapper.add(ownerType, fieldName, null, itemType);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, String itemFieldName, Class itemType) {
        this.implicitCollectionMapper.add(ownerType, fieldName, itemFieldName, itemType);
    }

    public DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(new PrettyPrintWriter(writer), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer) throws IOException {
        return this.createObjectOutputStream(writer, "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(new PrettyPrintWriter(writer), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(final HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
        writer.startNode(rootNodeName);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                XStream.this.marshal(object, writer);
            }

            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void flush() {
                writer.flush();
            }

            public void close() {
                writer.endNode();
                writer.close();
            }
        });
    }

    public ObjectInputStream createObjectInputStream(Reader xmlReader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(xmlReader));
    }

    public ObjectInputStream createObjectInputStream(final HierarchicalStreamReader reader) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() throws EOFException {
                if (!reader.hasMoreChildren()) {
                    throw new EOFException();
                }
                reader.moveDown();
                Object result = XStream.this.unmarshal(reader);
                reader.moveUp();
                return result;
            }

            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                throw new NotActiveException("stream inactive");
            }

            public void close() {
                reader.close();
            }
        });
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoaderReference.setReference(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderReference.getReference();
    }

    public void omitField(Class type, String fieldName) {
        this.fieldAliasingMapper.omitField(type, fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InitializationException
    extends BaseException {
        public InitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

