/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] ETC_UTC = new String[] {
               "",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "UTC", ETC_UTC },
            { "IET",
                new String[] {
                    "",
                    "EST",
                    "",
                    "EDT",
                    "",
                    "ET",
                }
            },
            { "UCT",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Zulu",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UCT",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "Etc/Zulu",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/GMT+1",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+2",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+3",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+4",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+5",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+6",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+7",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+8",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+9",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-1",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-2",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-3",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-4",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-5",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-6",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-7",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-8",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-9",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Universal",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Amman",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+10",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+11",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT+12",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-10",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-11",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-12",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-13",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/GMT-14",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Kyiv",
                new String[] {
                    "",
                    "EET",
                    "",
                    "EEST",
                    "",
                    "EET",
                }
            },
            { "Asia/Damascus",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Etc/Universal",
                new String[] {
                    "",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Coyhaique",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "timezone.excity.Africa/Lome", "Lomé" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh" },
            { "timezone.excity.Asia/Urumqi", "Ürümqi" },
            { "timezone.excity.Europe/Kiev", "Kyiv" },
            { "timezone.excity.Indian/Mahe", "Mahé" },
            { "America/Indiana/Indianapolis",
                new String[] {
                    "",
                    "EST",
                    "",
                    "EDT",
                    "",
                    "ET",
                }
            },
            { "timezone.excity.Asia/Rangoon", "Yangon" },
            { "timezone.excity.Pacific/Truk", "Chuuk" },
            { "timezone.excity.Africa/Asmera", "Asmara" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.Asia/Calcutta", "Kolkata" },
            { "timezone.excity.Asia/Katmandu", "Kathmandu" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.America/Bogota", "Bogotá" },
            { "timezone.excity.America/Cancun", "Cancún" },
            { "timezone.excity.America/Cuiaba", "Cuiabá" },
            { "timezone.excity.America/Maceio", "Maceió" },
            { "timezone.excity.America/Merida", "Mérida" },
            { "timezone.excity.Indian/Reunion", "Réunion" },
            { "timezone.excity.Pacific/Noumea", "Nouméa" },
            { "timezone.excity.Pacific/Ponape", "Pohnpei" },
            { "timezone.excity.Pacific/Wallis", "Wallis & Futuna" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiún" },
            { "timezone.excity.Africa/Ndjamena", "N’Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "São Tomé" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.America/Curacao", "Curaçao" },
            { "timezone.excity.America/Godthab", "Nuuk" },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.Atlantic/Canary", "Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Faroe" },
            { "timezone.excity.Europe/Busingen", "Büsingen" },
            { "timezone.excity.Europe/Chisinau", "Chișinău" },
            { "timezone.excity.America/Asuncion", "Asunción" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/Mazatlan", "Mazatlán" },
            { "timezone.excity.America/Miquelon", "Saint-Pierre" },
            { "timezone.excity.America/Santarem", "Santarém" },
            { "timezone.excity.America/St_Johns", "St. John’s" },
            { "timezone.excity.America/St_Kitts", "St. Kitts" },
            { "timezone.excity.America/St_Lucia", "St. Lucia" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.America/Araguaina", "Araguaína" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.America/St_Thomas", "St. Thomas" },
            { "timezone.excity.Pacific/Enderbury", "Canton" },
            { "timezone.excity.Pacific/Galapagos", "Galápagos" },
            { "timezone.excity.America/St_Vincent", "St. Vincent" },
            { "timezone.excity.Atlantic/St_Helena", "St. Helena" },
            { "timezone.excity.America/Mexico_City", "Ciudad de México" },
            { "timezone.excity.America/Indiana/Knox", "Knox, Indiana" },
            { "timezone.excity.America/Scoresbysund", "Ittoqqortoormiit" },
            { "timezone.excity.America/Ciudad_Juarez", "Ciudad Juárez" },
            { "timezone.excity.America/Coral_Harbour", "Atikokan" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay, Indiana" },
            { "timezone.excity.America/Lower_Princes", "Lower Prince’s Quarter" },
            { "timezone.excity.America/St_Barthelemy", "St. Barthélemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahía de Banderas" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indiana" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumán" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City, Indiana" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes, Indiana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont-d’Urville" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello, Kentucky" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, North Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, North Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Río Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, North Dakota" },
        };
        return data;
    }
}
