/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.skeleton;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;

public class SkeletonPropertyTableModel
extends AbstractTableModel {
    private Vector m_props = new Vector();

    public SkeletonPropertyTableModel(SkeletonProperty[] props) {
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            this.m_props.add(props[i]);
        }
    }

    public SkeletonPropertyTableModel() {
        this.m_props.add(new SkeletonProperty());
    }

    public void add(SkeletonProperty prop) {
        this.m_props.addElement(prop);
        this.fireTableRowsInserted(this.m_props.size() - 1, this.m_props.size());
        this.fireTableStructureChanged();
    }

    public void add(SkeletonProperty prop, int row) {
        this.m_props.insertElementAt(prop, row);
        this.fireTableRowsInserted(row, row);
        this.fireTableStructureChanged();
    }

    public void removeRow(int row) {
        this.m_props.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Id";
            }
            case 1: {
                return "GUI Label";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "Default Values";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        return this.m_props.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SkeletonProperty sp = (SkeletonProperty)this.m_props.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return sp.getIdName();
            }
            case 1: {
                return sp.getLabel();
            }
            case 2: {
                return sp.getDescription();
            }
            case 3: {
                return sp.getType();
            }
            case 4: {
                return sp.getValue();
            }
        }
        return "";
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SkeletonProperty sp = (SkeletonProperty)this.m_props.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                sp.setIdName(aValue.toString());
                break;
            }
            case 1: {
                sp.setLabel(aValue.toString());
                break;
            }
            case 2: {
                sp.setDescription(aValue.toString());
                break;
            }
            case 3: {
                sp.setType(aValue.toString());
                break;
            }
            case 4: {
                sp.setValue(aValue.toString());
            }
        }
    }

    public SkeletonProperty[] getProperties() {
        SkeletonProperty[] result = new SkeletonProperty[this.m_props.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (SkeletonProperty)this.m_props.get(i);
        }
        return result;
    }

    public void swapItems(int offset1, int offset2) {
        if (offset1 >= 0 && offset1 < this.m_props.size() && offset2 >= 0 && offset2 < this.m_props.size()) {
            Object o1 = this.m_props.get(offset1);
            Object o2 = this.m_props.get(offset2);
            this.m_props.set(offset1, o2);
            this.m_props.set(offset2, o1);
        }
        this.fireTableRowsUpdated(Math.min(offset1, offset2), Math.max(offset1, offset2));
    }
}

