/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.util.FileSelectionTextField;
import net.charabia.jsmoothgen.application.gui.util.PanelLayout;

public class EmbeddedJar
extends Editor {
    private JCheckBox m_checker = new JCheckBox();
    private FileSelectionTextField m_selector = new FileSelectionTextField();

    public EmbeddedJar() {
        this.setLayout(new PanelLayout());
        this.add(this.m_checker);
        this.add(this.m_selector);
        this.m_checker.setAction(new AbstractAction(Main.local("EMBEDDEDJAR_CHECKBOX")){

            public void actionPerformed(ActionEvent e) {
                EmbeddedJar.this.m_selector.setEnabled(EmbeddedJar.this.m_checker.isSelected());
                EmbeddedJar.this.updateModel();
            }
        });
        this.m_selector.addListener(new FileSelectionTextField.FileSelected(){

            public void fileSelected(String filename) {
                EmbeddedJar.this.updateModel();
            }
        });
    }

    public void dataChanged() {
        this.m_checker.setSelected(this.m_model.getEmbeddedJar());
        this.m_selector.setBaseDir(this.getBaseDir());
        if (this.m_model.getJarLocation() != null) {
            this.m_selector.setFile(new File(this.m_model.getJarLocation()));
        } else {
            this.m_selector.setFile(null);
        }
        if (this.m_checker.isSelected()) {
            this.m_selector.setEnabled(true);
        } else {
            this.m_selector.setEnabled(false);
        }
    }

    public void updateModel() {
        this.m_model.setEmbeddedJar(this.m_checker.isSelected());
        if (this.m_selector.getFile() != null) {
            this.m_model.setJarLocation(this.m_selector.getFile().toString());
        } else {
            this.m_model.setJarLocation(null);
        }
    }

    public String getLabel() {
        return "EMBEDDEDJAR_LABEL";
    }

    public String getDescription() {
        return "EMBEDDEDJAR_HELP";
    }
}

