/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.JavaPropertyPair;

public class JSmoothModelBean {
    private String m_skeletonName;
    private String m_executableName;
    private String m_currentDirectory;
    private String m_iconLocation;
    private boolean m_embedJar = false;
    private String m_jarLocation;
    private String m_mainClassName;
    private String m_arguments;
    private String[] m_classPath;
    private String m_minimumVersion = "";
    private String m_maximumVersion = "";
    private String[] m_jvmSearch = null;
    public int m_maxHeap = -1;
    public int m_initialHeap = -1;
    private String m_noJvmMessage;
    private String m_noJvmURL;
    private String m_bundledJVM = null;
    private JavaPropertyPair[] m_javaprops = new JavaPropertyPair[0];
    private Property[] m_skelproperties;
    transient Vector m_listeners = new Vector();
    transient Vector m_skeletonChangedListener = new Vector();

    public void addListener(Listener l) {
        this.m_listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.m_listeners.remove(l);
    }

    public void addSkeletonChangedListener(SkeletonChangedListener l) {
        this.m_skeletonChangedListener.add(l);
    }

    public void removeSkeletonChangedListener(SkeletonChangedListener l) {
        this.m_skeletonChangedListener.remove(l);
    }

    private void fireChanged() {
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            Listener l = (Listener)i.next();
            l.dataChanged();
        }
    }

    private void fireSkeletonChanged() {
        Iterator i = this.m_skeletonChangedListener.iterator();
        while (i.hasNext()) {
            SkeletonChangedListener l = (SkeletonChangedListener)i.next();
            l.skeletonChanged();
        }
    }

    public void setSkeletonName(String name) {
        if (name != this.m_skeletonName) {
            this.m_skeletonName = name;
            this.fireSkeletonChanged();
            this.fireChanged();
        }
    }

    public String getSkeletonName() {
        return this.m_skeletonName;
    }

    public void setExecutableName(String name) {
        if (name != this.m_executableName) {
            this.m_executableName = name;
            this.fireChanged();
        }
    }

    public void setCurrentDirectory(String curdir) {
        if (curdir != this.m_currentDirectory) {
            this.m_currentDirectory = curdir;
            this.fireChanged();
        }
    }

    public String getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public String getExecutableName() {
        return this.m_executableName;
    }

    public void setIconLocation(String name) {
        if (name != this.m_iconLocation) {
            this.m_iconLocation = name;
            this.fireChanged();
        }
    }

    public String getIconLocation() {
        return this.m_iconLocation;
    }

    public boolean getEmbeddedJar() {
        return this.m_embedJar;
    }

    public void setEmbeddedJar(boolean b) {
        this.m_embedJar = b;
        this.fireChanged();
    }

    public void setJarLocation(String name) {
        if (name != this.m_jarLocation) {
            this.m_jarLocation = name;
            this.fireChanged();
        }
    }

    public String getJarLocation() {
        return this.m_jarLocation;
    }

    public void setMainClassName(String name) {
        if (name != this.m_mainClassName) {
            this.m_mainClassName = name;
            this.fireChanged();
        }
    }

    public String getMainClassName() {
        return this.m_mainClassName;
    }

    public void setArguments(String args) {
        this.m_arguments = args;
        this.fireChanged();
    }

    public String getArguments() {
        return this.m_arguments;
    }

    public void setClassPath(String[] cp) {
        this.m_classPath = cp;
        this.fireChanged();
    }

    public String[] getClassPath() {
        return this.m_classPath;
    }

    public void setMaximumVersion(String version) {
        this.m_maximumVersion = version;
        this.fireChanged();
    }

    public String getMaximumVersion() {
        return this.m_maximumVersion;
    }

    public void setMinimumVersion(String version) {
        this.m_minimumVersion = version;
        this.fireChanged();
    }

    public String getMinimumVersion() {
        return this.m_minimumVersion;
    }

    public void setJVMSearchPath(String[] path) {
        this.m_jvmSearch = path;
        this.fireChanged();
    }

    public String[] getJVMSearchPath() {
        return this.m_jvmSearch;
    }

    public void setSkeletonProperties(Property[] props) {
        this.m_skelproperties = props;
        this.fireChanged();
    }

    public Property[] getSkeletonProperties() {
        return this.m_skelproperties;
    }

    public void setNoJvmMessage(String msg) {
        this.m_noJvmMessage = msg;
        this.fireChanged();
    }

    public String getNoJvmMessage() {
        return this.m_noJvmMessage;
    }

    public void setNoJvmURL(String url) {
        this.m_noJvmURL = url;
        this.fireChanged();
    }

    public String getNoJvmURL() {
        return this.m_noJvmURL;
    }

    public String getBundledJVMPath() {
        return this.m_bundledJVM;
    }

    public void setBundledJVMPath(String path) {
        this.m_bundledJVM = path;
        this.fireChanged();
    }

    public void setJavaProperties(JavaPropertyPair[] pairs) {
        this.m_javaprops = pairs;
    }

    public JavaPropertyPair[] getJavaProperties() {
        return this.m_javaprops;
    }

    public void setMaximumMemoryHeap(int size) {
        this.m_maxHeap = size;
    }

    public int getMaximumMemoryHeap() {
        return this.m_maxHeap;
    }

    public void setInitialMemoryHeap(int size) {
        this.m_initialHeap = size;
    }

    public int getInitialMemoryHeap() {
        return this.m_initialHeap;
    }

    public String[] normalizePaths(File filebase) {
        return this.normalizePaths(filebase, true);
    }

    public String[] normalizePaths(File filebase, boolean toRelativePath) {
        Vector result = new Vector();
        this.m_iconLocation = this.checkRelativePath(filebase, this.m_iconLocation, result, "Icon location", toRelativePath);
        this.m_jarLocation = this.checkRelativePath(filebase, this.m_jarLocation, result, "Jar location", toRelativePath);
        this.m_bundledJVM = this.checkRelativePath(filebase, this.m_bundledJVM, result, "Bundle JVM location", toRelativePath);
        this.m_executableName = this.checkRelativePath(filebase, this.m_executableName, result, "Executable location", toRelativePath);
        if (this.m_executableName != null) {
            File exebase = new File(this.m_executableName);
            if (!exebase.isAbsolute()) {
                exebase = new File(filebase, exebase.toString()).getParentFile();
            }
            if (this.m_currentDirectory != null && this.m_currentDirectory.indexOf("${") >= 0) {
                this.m_currentDirectory = this.checkRelativePath(exebase, this.m_currentDirectory, result, "Current directory", toRelativePath);
            }
        }
        if (this.m_classPath != null) {
            for (int i = 0; i < this.m_classPath.length; ++i) {
                this.m_classPath[i] = this.checkRelativePath(filebase, this.m_classPath[i], result, "Classpath entry (" + i + ")", toRelativePath);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    private String checkRelativePath(File root, String value, Vector errors, String name, boolean toRelativePath) {
        if (value == null) {
            return value;
        }
        if (toRelativePath) {
            File nf = JSmoothModelPersistency.makePathRelativeIfPossible(root, new File(value));
            if (nf.isAbsolute()) {
                errors.add(name);
            }
            return nf.toString();
        }
        File nf = new File(value);
        if (!nf.isAbsolute()) {
            nf = new File(root, value);
            nf = nf.getAbsoluteFile();
            try {
                nf = nf.getCanonicalFile();
                nf = nf.getAbsoluteFile();
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
        return nf.toString();
    }

    public static interface SkeletonChangedListener {
        public void skeletonChanged();
    }

    public static interface Listener {
        public void dataChanged();
    }

    public static class Property {
        public String Key;
        public String Value;

        public void setKey(String key) {
            this.Key = key;
        }

        public String getKey() {
            return this.Key;
        }

        public void setValue(String val) {
            this.Value = val;
        }

        public String getValue() {
            return this.Value;
        }

        public String toString() {
            return this.getKey() + "==" + this.getValue();
        }
    }
}

