/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldTestClassRunner
extends Runner {
    private Test fTest;

    public OldTestClassRunner(Class<?> klass) {
        this(new TestSuite((Class<? extends TestCase>)klass));
    }

    public OldTestClassRunner(Test test) {
        this.fTest = test;
    }

    @Override
    public void run(RunNotifier notifier) {
        TestResult result = new TestResult();
        result.addListener(this.getListener(notifier));
        this.fTest.run(result);
    }

    private TestListener getListener(final RunNotifier notifier) {
        return new TestListener(){

            public void endTest(Test test) {
                notifier.fireTestFinished(this.asDescription(test));
            }

            public void startTest(Test test) {
                notifier.fireTestStarted(this.asDescription(test));
            }

            public void addError(Test test, Throwable t) {
                Failure failure = new Failure(this.asDescription(test), t);
                notifier.fireTestFailure(failure);
            }

            private Description asDescription(Test test) {
                if (test instanceof JUnit4TestCaseFacade) {
                    JUnit4TestCaseFacade facade = (JUnit4TestCaseFacade)test;
                    return facade.getDescription();
                }
                return Description.createTestDescription(test.getClass(), this.getName(test));
            }

            private String getName(Test test) {
                if (test instanceof TestCase) {
                    return ((TestCase)test).getName();
                }
                return test.toString();
            }

            public void addFailure(Test test, AssertionFailedError t) {
                this.addError(test, (Throwable)((Object)t));
            }
        };
    }

    @Override
    public Description getDescription() {
        return this.makeDescription(this.fTest);
    }

    private Description makeDescription(Test test) {
        if (test instanceof TestCase) {
            TestCase tc = (TestCase)test;
            return Description.createTestDescription(tc.getClass(), tc.getName());
        }
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            Description description = Description.createSuiteDescription(ts.getName());
            int n = ts.testCount();
            int i = 0;
            while (i < n) {
                description.addChild(this.makeDescription(ts.testAt(i)));
                ++i;
            }
            return description;
        }
        if (test instanceof JUnit4TestAdapter) {
            JUnit4TestAdapter adapter = (JUnit4TestAdapter)test;
            return adapter.getDescription();
        }
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            return this.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test.getClass());
    }
}

