/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.xml.TestNGContentHandler;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private String m_fileName = null;
    private InputStream m_inputStream = null;
    private boolean m_lookInJar = false;

    public Parser(String fileName) throws ParserConfigurationException, SAXException, IOException {
        this.m_fileName = fileName;
        this.m_inputStream = new FileInputStream(new File(this.m_fileName));
    }

    public Parser(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    public Parser() throws ParserConfigurationException, SAXException, IOException {
    }

    public XmlSuite parse() throws IOException, ParserConfigurationException, SAXException {
        XmlSuite result = null;
        TestNGContentHandler ch = new TestNGContentHandler();
        SAXParserFactory spf = null;
        try {
            spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError ex) {
            try {
                Class<?> cl = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)cl.newInstance();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        spf.setValidating(true);
        SAXParser saxParser = spf.newSAXParser();
        if (this.m_inputStream != null) {
            saxParser.parse(this.m_inputStream, (DefaultHandler)ch);
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream in = classLoader != null ? classLoader.getResourceAsStream(DEFAULT_FILENAME) : this.getClass().getResourceAsStream(DEFAULT_FILENAME);
            if (in == null) {
                throw new IOException("Default property file of testng.xml was not found");
            }
            saxParser.parse(in, (DefaultHandler)ch);
        }
        result = ch.getSuite();
        return result;
    }

    private static void ppp(String s) {
        System.out.println("[Parser] " + s);
    }

    public static void main(String[] argv) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        XmlSuite l = new Parser("c:/eclipse-workspace/testng/test/testng.xml").parse();
        System.out.println(l);
    }
}

