/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.Converter;
import org.testng.internal.annotations.DataProviderAnnotation;
import org.testng.internal.annotations.ExpectedExceptionsAnnotation;
import org.testng.internal.annotations.FactoryAnnotation;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.ParametersAnnotation;
import org.testng.internal.annotations.TestAnnotation;

public class JDK14TagFactory {
    private static Map m_annotationMap = new HashMap();
    public static final String CONFIGURATION = "testng.configuration";
    public static final String FACTORY = "testng.factory";
    public static final String TEST = "testng.test";
    public static final String EXPECTED_EXCEPTIONS = "testng.expected-exceptions";
    public static final String DATA_PROVIDER = "testng.data-provider";
    public static final String PARAMETERS = "testng.parameters";

    public IAnnotation createTag(Class annotationClass, AbstractInheritableJavaEntity entity) {
        IAnnotation result = null;
        String tag = this.getTagName(annotationClass);
        DocletTag dt = entity.getTagByName(tag, false);
        if (dt != null) {
            result = this.createTag(annotationClass, dt);
        }
        return result;
    }

    private String getTagName(Class annotationClass) {
        String result = (String)m_annotationMap.get(annotationClass);
        Assert.assertNotNull(result, "No tag found for " + annotationClass);
        return result;
    }

    private IAnnotation createTag(Class annotationClass, DocletTag dt) {
        IAnnotation result = null;
        if (annotationClass == IConfiguration.class) {
            result = this.createConfigurationTag(dt);
        } else if (annotationClass == IDataProvider.class) {
            result = this.createDataProviderTag(dt);
        } else if (annotationClass == IExpectedExceptions.class) {
            result = this.createExpectedExceptionsTag(dt);
        } else if (annotationClass == IFactory.class) {
            result = this.createFactoryTag(dt);
        } else if (annotationClass == IParameters.class) {
            result = this.createParametersTag(dt);
        } else if (annotationClass == ITest.class) {
            result = this.createTestTag(dt);
        } else {
            JDK14TagFactory.ppp("UNKNOWN ANNOTATION CLASS " + annotationClass);
        }
        return result;
    }

    private IAnnotation createTestTag(DocletTag dt) {
        TestAnnotation result = new TestAnnotation();
        result.setEnabled(Converter.getBoolean(dt.getNamedParameter("enabled"), result.getEnabled()));
        result.setGroups(Converter.getStringArray(dt.getNamedParameter("groups"), result.getGroups()));
        result.setParameters(Converter.getStringArray(dt.getNamedParameter("parameters"), result.getParameters()));
        result.setDependsOnGroups(Converter.getStringArray(dt.getNamedParameter("dependsOnGroups"), result.getDependsOnGroups()));
        result.setDependsOnMethods(Converter.getStringArray(dt.getNamedParameter("dependsOnMethods"), result.getDependsOnMethods()));
        result.setTimeOut(Converter.getLong(dt.getNamedParameter("timeOut"), result.getTimeOut()));
        result.setInvocationCount(Converter.getInt(dt.getNamedParameter("invocationCount"), result.getInvocationCount()));
        result.setThreadPoolSize(Converter.getInt(dt.getNamedParameter("threadPoolSize"), result.getThreadPoolSize()));
        result.setSuccessPercentage(Converter.getInt(dt.getNamedParameter("successPercentage"), result.getSuccessPercentage()));
        result.setDataProvider(Converter.getString(dt.getNamedParameter("dataProvider"), result.getDataProvider()));
        result.setAlwaysRun(Converter.getBoolean(dt.getNamedParameter("alwaysRun"), result.getAlwaysRun()));
        result.setDescription(Converter.getString(dt.getNamedParameter("description"), result.getDescription()));
        return result;
    }

    private IAnnotation createConfigurationTag(DocletTag dt) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        result.setBeforeTestClass(Converter.getBoolean(dt.getNamedParameter("beforeTestClass"), result.getBeforeTestClass()));
        result.setAfterTestClass(Converter.getBoolean(dt.getNamedParameter("afterTestClass"), result.getAfterTestClass()));
        result.setBeforeTestMethod(Converter.getBoolean(dt.getNamedParameter("beforeTestMethod"), result.getBeforeTestMethod()));
        result.setAfterTestMethod(Converter.getBoolean(dt.getNamedParameter("afterTestMethod"), result.getAfterTestMethod()));
        result.setBeforeTest(Converter.getBoolean(dt.getNamedParameter("beforeTest"), result.getBeforeTest()));
        result.setAfterTest(Converter.getBoolean(dt.getNamedParameter("afterTest"), result.getAfterTest()));
        result.setAfterSuite(Converter.getBoolean(dt.getNamedParameter("afterSuite"), result.getAfterSuite()));
        result.setBeforeSuite(Converter.getBoolean(dt.getNamedParameter("beforeSuite"), result.getBeforeSuite()));
        result.setParameters(Converter.getStringArray(dt.getNamedParameter("parameters"), result.getParameters()));
        result.setEnabled(Converter.getBoolean(dt.getNamedParameter("enabled"), result.getEnabled()));
        result.setGroups(Converter.getStringArray(dt.getNamedParameter("groups"), result.getGroups()));
        result.setDependsOnGroups(Converter.getStringArray(dt.getNamedParameter("dependsOnGroups"), result.getDependsOnGroups()));
        result.setDependsOnMethods(Converter.getStringArray(dt.getNamedParameter("dependsOnMethods"), result.getDependsOnMethods()));
        result.setAlwaysRun(Converter.getBoolean(dt.getNamedParameter("alwaysRun"), result.getAlwaysRun()));
        result.setInheritGroups(Converter.getBoolean(dt.getNamedParameter("inheritGroups"), result.getInheritGroups()));
        result.setDescription(Converter.getString(dt.getNamedParameter("description"), result.getDescription()));
        return result;
    }

    private IAnnotation createDataProviderTag(DocletTag dt) {
        DataProviderAnnotation result = new DataProviderAnnotation();
        result.setName(Converter.getString(dt.getNamedParameter("name"), result.getName()));
        return result;
    }

    private IAnnotation createExpectedExceptionsTag(DocletTag dt) {
        ExpectedExceptionsAnnotation result = new ExpectedExceptionsAnnotation();
        result.setValue(Converter.getClassArray(dt.getNamedParameter("value"), result.getValue()));
        return result;
    }

    private IAnnotation createParametersTag(DocletTag dt) {
        ParametersAnnotation result = new ParametersAnnotation();
        result.setValue(Converter.getStringArray(dt.getNamedParameter("value"), result.getValue()));
        return result;
    }

    private IAnnotation createFactoryTag(DocletTag dt) {
        FactoryAnnotation result = new FactoryAnnotation();
        result.setParameters(Converter.getStringArray(dt.getNamedParameter("parameters"), result.getParameters()));
        return result;
    }

    private static void ppp(String s) {
        System.out.println("[TagFactory] " + s);
    }

    static {
        m_annotationMap.put(IConfiguration.class, CONFIGURATION);
        m_annotationMap.put(IDataProvider.class, DATA_PROVIDER);
        m_annotationMap.put(IExpectedExceptions.class, EXPECTED_EXCEPTIONS);
        m_annotationMap.put(IFactory.class, FACTORY);
        m_annotationMap.put(IParameters.class, PARAMETERS);
        m_annotationMap.put(ITest.class, TEST);
    }
}

