/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.testng.IMethodSelector;
import org.testng.TestNGException;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IFactory;
import org.testng.xml.XmlMethodSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    public static Class forName(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(className);
                }
                catch (Exception ex) {
                    clazz = Class.forName(className);
                }
            } else {
                clazz = Class.forName(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static Method findFactoryMethod(Class cls, IAnnotationFinder finder) {
        Method result = null;
        for (Method method : cls.getDeclaredMethods()) {
            IAnnotation f = finder.findAnnotation(method, IFactory.class);
            if (null == f) continue;
            if (null != result) {
                throw new TestNGException(cls.getName() + ":  only one @Factory method allowed");
            }
            result = method;
        }
        return result;
    }

    private static void ppp(String s) {
        System.out.println("[ClassHelper] " + s);
    }

    public static Set<Method> getAvailableMethods(Class clazz) {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        String fqn = clazz.getName();
        for (Class parent = clazz.getSuperclass(); null != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    private static Set<Method> extractMethods(Class childClass, Class clazz, Set<Method> collected) {
        HashSet<Method> methods = new HashSet<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers)) {
                if (ClassHelper.isOverridden(method, collected)) continue;
                methods.add(method);
                continue;
            }
            if (!isSamePackage || Modifier.isPrivate(methodModifiers) || ClassHelper.isOverridden(method, collected)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }
}

