from enum import Enum
from typing import Self

OFFSET_TO_PERIOD_FREQSTR: dict[str, str]

def periods_per_day(reso: int = ...) -> int: ...
def periods_per_second(reso: int) -> int: ...
def abbrev_to_npy_unit(abbrev: str | None) -> int: ...

class PeriodDtypeBase:
    _dtype_code: int  # PeriodDtypeCode
    _n: int

    # actually __cinit__
    def __new__(cls, code: int, n: int) -> Self: ...
    @property
    def _freq_group_code(self) -> int: ...
    @property
    def _resolution_obj(self) -> Resolution: ...
    def _get_to_timestamp_base(self) -> int: ...
    @property
    def _freqstr(self) -> str: ...
    def __hash__(self) -> int: ...
    def _is_tick_like(self) -> bool: ...
    @property
    def _creso(self) -> int: ...
    @property
    def _td64_unit(self) -> str: ...

class FreqGroup(Enum):
    _value_: int
    FR_ANN = ...
    FR_QTR = ...
    FR_MTH = ...
    FR_WK = ...
    FR_BUS = ...
    FR_DAY = ...
    FR_HR = ...
    FR_MIN = ...
    FR_SEC = ...
    FR_MS = ...
    FR_US = ...
    FR_NS = ...
    FR_UND = ...
    @staticmethod
    def from_period_dtype_code(code: int) -> FreqGroup: ...

class Resolution(Enum):
    _value_: int
    RESO_NS = ...
    RESO_US = ...
    RESO_MS = ...
    RESO_SEC = ...
    RESO_MIN = ...
    RESO_HR = ...
    RESO_DAY = ...
    RESO_MTH = ...
    RESO_QTR = ...
    RESO_YR = ...
    def __lt__(self, other: Resolution) -> bool: ...
    def __ge__(self, other: Resolution) -> bool: ...
    @property
    def attrname(self) -> str: ...
    @classmethod
    def from_attrname(cls, attrname: str) -> Resolution: ...
    @classmethod
    def get_reso_from_freqstr(cls, freq: str) -> Resolution: ...
    @property
    def attr_abbrev(self) -> str: ...

class NpyDatetimeUnit(Enum):
    _value_: int
    NPY_FR_Y = ...
    NPY_FR_M = ...
    NPY_FR_W = ...
    NPY_FR_D = ...
    NPY_FR_h = ...
    NPY_FR_m = ...
    NPY_FR_s = ...
    NPY_FR_ms = ...
    NPY_FR_us = ...
    NPY_FR_ns = ...
    NPY_FR_ps = ...
    NPY_FR_fs = ...
    NPY_FR_as = ...
    NPY_FR_GENERIC = ...
