package pwa

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// FileHandlerAccept the following types are the replica of
// https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-FileHandlerAccept
type FileHandlerAccept struct {
	MediaType      string   `json:"mediaType"` // New name of the mimetype according to https://www.iana.org/assignments/media-types/media-types.xhtml
	FileExtensions []string `json:"fileExtensions"`
}

// FileHandler [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-FileHandler
type FileHandler struct {
	Action      string               `json:"action"`
	Accepts     []*FileHandlerAccept `json:"accepts"`
	DisplayName string               `json:"displayName"`
}

// DisplayMode if user prefers opening the app in browser or an app window.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-DisplayMode
type DisplayMode string

// String returns the DisplayMode as string value.
func (t DisplayMode) String() string {
	return string(t)
}

// DisplayMode values.
const (
	DisplayModeStandalone DisplayMode = "standalone"
	DisplayModeBrowser    DisplayMode = "browser"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DisplayMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DisplayMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DisplayMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch DisplayMode(v) {
	case DisplayModeStandalone:
		*t = DisplayModeStandalone
	case DisplayModeBrowser:
		*t = DisplayModeBrowser

	default:
		in.AddError(fmt.Errorf("unknown DisplayMode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DisplayMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
