# World of PADMAN Assets Licenses

This file contains a list of assets that are used in World of PADMAN. It lists the respective path to the file within the wop directory or PK3 files, the associated license or terms of use, the original author, and the source with internet link if available. In addition, the file paths from previous WoP versions are also specified in the last column, which are replaced accordingly by the specified current paths from the first column. Most of the external third party files were modified by PadWorld Entertainment according to their license. If several files from different sources were combined to one file, it is listed several times. This list makes no claim to be complete and is subject to constant change as World of PADMAN continues to develop.

File path | License | Author | Source | Replacement for / outdated path
--------- | ------- | ------ | ------ | ---------
music/credits.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
music/menuloop.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
sound/items/revival/heartbeat.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Woodingp](https://freesound.org/people/Woodingp/) | [freesound.org](https://freesound.org/s/116642/) | sounds/items/revival/heart/wav
sound/padplayer/footsteps/flesh1.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [16H_Panska_Skerl_Jan](https://freesound.org/people/16H_Panska_Skerl_Jan/) | [freesound.org](https://freesound.org/s/499061/)
sound/padplayer/footsteps/flesh2.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [16H_Panska_Skerl_Jan](https://freesound.org/people/16H_Panska_Skerl_Jan/) | [freesound.org](https://freesound.org/s/499061/)
sound/padplayer/footsteps/flesh3.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [16H_Panska_Skerl_Jan](https://freesound.org/people/16H_Panska_Skerl_Jan/) | [freesound.org](https://freesound.org/s/499061/)
sound/padplayer/footsteps/flesh4.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [16H_Panska_Skerl_Jan](https://freesound.org/people/16H_Panska_Skerl_Jan/) | [freesound.org](https://freesound.org/s/499061/)
sound/padplayer/footsteps/splash1.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/splash1.wav
sound/padplayer/footsteps/splash2.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/splash2.wav
sound/padplayer/footsteps/splash3.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/splash3.wav
sound/padplayer/footsteps/splash4.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/splash4.wav
sound/padplayer/footsteps/spurs1.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98816/)
sound/padplayer/footsteps/spurs2.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98816/)
sound/padplayer/footsteps/spurs3.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98816/)
sound/padplayer/footsteps/spurs4.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98816/)
sound/padplayer/footsteps/step1.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/step1.wav
sound/padplayer/footsteps/step2.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/step2.wav
sound/padplayer/footsteps/step3.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/step3.wav
sound/padplayer/footsteps/step4.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/) | sounds/player/footsteps/step4.wav
sound/padplayer/footsteps/wade1.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/)
sound/padplayer/footsteps/wade2.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/)
sound/padplayer/footsteps/wade3.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/)
sound/padplayer/footsteps/wade4.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Nox_Sound](https://freesound.org/people/Nox_Sound/) | [freesound.org](https://freesound.org/s/490951/)
sound/padplayer/fry.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Hannebu](https://freesound.org/people/Hannebu/) | [freesound.org](https://freesound.org/s/194806/) | sounds/player/fry.wav
sound/padplayer/land.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [ceberation](https://freesound.org/people/ceberation/) | [freesound.org](https://freesound.org/s/235521/) | sounds/player/land.wav
sound/padplayer/talk.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Aiyumi](https://freesound.org/people/Aiyumi/) | [freesound.org](https://freesound.org/s/245083/) | sounds/player/talk.wav
sound/padplayer/water_in.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98335/) | sounds/player/water_in.wav
sound/padplayer/water_out.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Juan_Merie_Venter](https://freesound.org/people/Juan_Merie_Venter/) | [freesound.org](https://freesound.org/s/327667/) | sounds/player/water_out.wav
sound/padplayer/water_under.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Perel](https://freesound.org/people/Perel/) | [freesound.org](https://freesound.org/s/173438/) | sounds/player/water_under.wav
sound/world/ambient/car_crash.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [audible-edge](https://freesound.org/people/audible-edge/) | [freesound.org](https://freesound.org/s/76804/) | sound/pad_misc/car_crash01.wav; sounds/maps/ambient/car_crash.ogg
sound/world/ambient/car_crash.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [FatLane](https://freesound.org/people/FatLane/) | [freesound.org](https://freesound.org/s/92019/) | sound/pad_misc/car_crash01.wav; sounds/maps/ambient/car_crash.ogg
sound/world/ambient/chopper_pass.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/helicopt.wav; sounds/maps/ambient/helicopter_pass-by.ogg
sound/world/ambient/city_traffic.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_ambiente/ambie_street.wav; sounds/maps/ambient/city_traffic.ogg
sound/world/ambient/droplet_double.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/cybbath/tropf.wav; sounds/maps/ambient/water_droplet_double.ogg
sound/world/ambient/droplet_echoing.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/drip03.wav; sounds/maps/ambient/water_droplet_echoing.ogg
sound/world/ambient/droplet_single.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | Mike Koenig | [soundbible.com](https://soundbible.com/1126-Water-Drop.html) | sound/pad_ambiente/waterdrop01.wav; sounds/maps/ambient/water_droplet_single.ogg
sound/world/ambient/droplets_echoing.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [vibe_crc](https://freesound.org/people/vibe_crc/) | [freesound.org](https://freesound.org/s/50623/) | sound/pad_ambiente/drip06.wav; sounds/maps/ambient/water_droplets_echoing.ogg
sound/world/ambient/fire_crackling.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/fireloud.wav; sounds/maps/ambient/fire_crackling.ogg
sound/world/ambient/fire_pass.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_misc/car_ambbulance02.wav; sounds/maps/ambient/fire_engine_pass-by.ogg
sound/world/ambient/fire_sizzling.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | ezwa | [soundbible.com](https://soundbible.com/1543-Fireplace.html) | sound/pad_misc/fire1.wav; sounds/maps/ambient/fire_sizzling.ogg
sound/world/ambient/floor_creaking.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sounds/maps/ambient/floor_creaking.ogg
sound/world/ambient/ice_cracking.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_jail/pad_jail2_ice.wav; sounds/maps/ambient/ice_cracking.ogg
sound/world/ambient/mbike_pass.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_misc/motorad.wav; sounds/maps/ambient/motorcycle_pass-by.ogg
sound/world/ambient/metal_creaking.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Timbre](https://freesound.org/people/Timbre/) | [freesound.org](https://freesound.org/s/124122/) | sounds/maps/ambient/metal_creaking.ogg
sound/world/ambient/metal_falling.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Robinhood76](https://freesound.org/people/Robinhood76/) | [freesound.org](https://freesound.org/s/85339/) | sound/pad_effecte/metal_echo01.wav; sounds/maps/ambient/metal_falling.ogg
sound/world/ambient/ocean_waves.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_jail/jail_ocean.wav; sounds/maps/ambient/ocean_waves.ogg
sound/world/ambient/plane_jet.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [digifishmusic](https://freesound.org/people/digifishmusic/) | [freesound.org](https://freesound.org/s/47254/) | sounds/maps/ambient/airplane_jet.ogg
sound/world/ambient/plane_pass.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | Mike Koenig | [soundbible.com](https://soundbible.com/1600-Small-Airplane-Long-Flyby.html) | sound/pad_ambiente/airplane01.wav; sounds/maps/ambient/airplane_pass-by.ogg
sound/world/ambient/police_pass.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | Corsica_S | [soundbible.com](https://soundbible.com/579-Police-Siren.html) | sound/pad_misc/car_police04.wav; sounds/maps/ambient/police_car_pass-by.ogg
sound/world/ambient/shrubbery.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [schademans](https://freesound.org/people/schademans/) | [freesound.org](https://freesound.org/s/2590/) | sound/pad_effecte/bush.wav; sounds/maps/ambient/shrubbery.ogg
sound/world/ambient/slime_bubbling.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Timbre](https://freesound.org/people/Timbre/) | [freesound.org](https://freesound.org/s/98858/) | sounds/maps/ambient/slime_bubbling.ogg
sound/world/ambient/train_intercity.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | Kai Bergmann | Kai Bergmann | sound/pad_ambiente/train_ambient.wav; sounds/maps/ambient/train_intercity.ogg
sound/world/ambient/water_bubble.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Goldy-sama](https://freesound.org/people/Goldy-sama/) | [freesound.org](https://freesound.org/s/4239/) | sound/pad_harm/fishtankbubble_once.wav; sounds/maps/ambient/water_bubble_single.ogg
sound/world/ambient/water_bubbling.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Razzvio](https://freesound.org/people/Razzvio/) | [freesound.org](https://freesound.org/s/79140/) | sound/pad_ambiente/water08.wav; sounds/maps/ambient/water_bubbling_deep.ogg
sound/world/ambient/water_drain.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sounds/maps/ambient/water_drain.ogg
sound/world/ambient/water_drippling.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [vibe_crc](https://freesound.org/people/vibe_crc/) | [freesound.org](https://freesound.org/s/50623/) | sound/pad_ambiente/water01.wav; sounds/maps/ambient/water_drippling.ogg
sound/world/ambient/water_drippling.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_ambiente/water01.wav; sounds/maps/ambient/water_drippling.ogg
sound/world/ambient/water_falling.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_ambiente/water12.wav; sounds/maps/ambient/water_falling.ogg
sound/world/ambient/water_flowing.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/water06.wav; sounds/maps/ambient/water_flowing.ogg
sound/world/ambient/water_rippling.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [roscoetoon](https://freesound.org/people/roscoetoon/) | [freesound.org](https://freesound.org/s/26921/) | sound/pad_ambiente/water09.wav; sounds/maps/ambient/water_rippling.ogg
sound/world/ambient/water_rippling.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/water09.wav; sounds/maps/ambient/water_rippling.ogg
sound/world/ambient/water_shower.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sounds/maps/ambient/water_shower.ogg
sound/world/ambient/wind_icy.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | Mark DiAngelo | [soundbible.com](https://soundbible.com/1810-Wind.html) | sound/pad_jail/pad_jail2_wind.wav; sounds/maps/ambient/wind_icy.ogg
sound/world/ambient/wind_night.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Dynamicell](https://freesound.org/people/Dynamicell/) | [freesound.org](https://freesound.org/s/17553/) | sounds/maps/ambient/wind_night.ogg
sound/world/ambient/wind_stormy.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Anton](https://freesound.org/people/Anton/) | [freesound.org](https://freesound.org/s/2690/) | sound/pad_ambiente/ambie14.wav; sounds/maps/ambient/wind_stormy.ogg
sound/world/animal/bird_blackcap.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [evernaut](https://freesound.org/people/evernaut/) | [freesound.org](https://freesound.org/s/37286/) | sound/pad_animals/bird01.wav; sounds/maps/animal/blackcap_calling.ogg
sound/world/animal/bird_cardinal.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | PsychoBird | [soundbible.com](https://soundbible.com/1475-Best-Cardinal-Bird-Lazy.html) | sound/pad_ambiente/bird05.wav; sound/pad_animals/bird05.wav; sounds/maps/animal/cardinal_calling.ogg
sound/world/animal/bird_crow.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [_nuel](https://freesound.org/people/_nuel/) | [freesound.org](https://freesound.org/s/54973/) | sound/pad_animals/raven.wav; sounds/maps/animal/crow_cawing.ogg
sound/world/animal/bird_eagle.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [foosiemac](https://freesound.org/people/foosiemac/) | [freesound.org](https://freesound.org/s/76797/) | sound/pad_animals/eagle01.wav; sounds/maps/animal/eagle_shouting.ogg
sound/world/animal/bird_gull |  |  |  | sound/pad_jail/jail_gull1.wav; sounds/maps/animal/gull_shouting
sound/world/animal/bird_owl1.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Benboncan](https://freesound.org/people/Benboncan/) | [freesound.org](https://freesound.org/s/64544/) | sound/pad_animals/owl02.wav; sounds/maps/animal/owl_call_single.ogg
sound/world/animal/bird_owl2.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Benboncan](https://freesound.org/people/Benboncan/) | [freesound.org](https://freesound.org/s/64544/) | sound/pad_animals/owl01.wav; sounds/maps/animal/owl_call_double.ogg
sound/world/animal/bird_vireo.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | Mike Koenig | [soundbible.com](https://soundbible.com/1846-Warbling-Vireo.html) | sound/pad_animals/bird06.wav; sounds/maps/animal/warbling_vireo_calling.ogg
sound/world/animal/blackbird.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [reinsamba](https://freesound.org/people/reinsamba/) | [freesound.org](https://freesound.org/s/19999/) | sound/pad_animals/bird02.wav; sounds/maps/animal/common_blackbird_calling.ogg
sound/world/animal/cicada_chirp.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [fotomacc](https://freesound.org/people/fotomacc/) | [freesound.org](https://freesound.org/s/15345/) | sound/pad_animals/cricket02.wav; sounds/maps/animal/cicada_chirp.ogg
sound/world/animal/coyote_howl.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [rogerforeman](https://freesound.org/people/rogerforeman/) | [freesound.org](https://freesound.org/s/68067/) | sound/pad_animals/ambi_animal01.wav; sounds/maps/animal/coyote_howling.ogg
sound/world/animal/cricket_chirp1.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [acclivity](https://freesound.org/people/acclivity/) | [freesound.org](https://freesound.org/s/83931/) | sound/pad_animals/zirpen2.wav; sounds/maps/animal/cricket_chirping.ogg
sound/world/animal/cricket_chirp2.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [soundscalpel.com](https://freesound.org/people/soundscalpel.com/) | [freesound.org](https://freesound.org/s/110613/) | sound/pad_animals/cricket07.wav; sounds/maps/animal/cricket_chirping2.ogg
sound/world/animal/dog_bark1.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [ronfont](https://freesound.org/people/ronfont/) | [freesound.org](https://freesound.org/s/30344/) | sound/pad_animals/dogs01.wav; sounds/maps/animal/dog_barking_long.ogg
sound/world/animal/dog_bark2.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [ronfont](https://freesound.org/people/ronfont/) | [freesound.org](https://freesound.org/s/30344/) | sound/pad_animals/dogs3.wav; sounds/maps/animal/dog_barking_short.ogg
sound/world/animal/dog_bark3.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Tomlija](https://freesound.org/people/Tomlija/) | [freesound.org](https://freesound.org/s/97392/) | sound/pad_misc/dogwuff.wav; sounds/maps/animal/dog_small_barking.ogg
sound/world/animal/fly_crazy.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [dobroide](https://freesound.org/people/dobroide/) | [freesound.org](https://freesound.org/s/7973/) | sound/pad_animals/fly02.wav; sounds/maps/animal/fly_crazy.ogg
sound/world/animal/fly_single.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Benboncan](https://freesound.org/people/Benboncan/) | [freesound.org](https://freesound.org/s/82077/) | sound/pad_animals/fly01.wav; sounds/maps/animal/fly_single.ogg
sound/world/animal/fly_swarm.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [HerbertBoland](https://freesound.org/people/HerbertBoland/) | [freesound.org](https://freesound.org/s/75189/) | sound/pad_animals/fly03.wav; sounds/maps/animal/fly_swarm.ogg
sound/world/animal/horse_gallop.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [dobroide](https://freesound.org/people/dobroide/) | [freesound.org](https://freesound.org/s/41180/) | sound/pad_harm/horse_galloping.wav; sounds/maps/animal/horse_galloping.ogg
sound/world/animal/horse_snort.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [ERH](https://freesound.org/people/ERH/) | [freesound.org](https://freesound.org/s/32043/) | sound/pad_harm/horse_snort_2.wav; sounds/maps/animal/horse_snorting.ogg
sound/world/animal/kitten_meow.ogg | | | http://www.bonessacademy.com | sound/pad_animals/cat01.wav; sounds/maps/animal/kitten_meow.ogg
sound/world/animal/wolf_howl1.ogg | | razor3D | http://www.razor3donline.com | sound/pad_animals/wolf02.wav; sounds/maps/animal/wolf_howling.ogg
sound/world/animal/wolf_howl2.ogg | | Gorgoroth6669 | https://freesound.org | sound/pad_animals/wolf04.wav; sounds/maps/animal/wolf_howling2.ogg
sound/world/human/applause.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/secret_clap.wav; sounds/maps/human/applause.ogg
sound/world/human/footsteps_f.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/footsteps2.wav; sounds/maps/human/footsteps_upstairs_female.ogg
sound/world/human/footsteps_m.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/footsteps1.wav; sounds/maps/human/footsteps_upstairs_male.ogg
sound/world/human/plane_radio.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [833-45](https://freesound.org/people/833-45/) | [freesound.org](https://freesound.org/s/11723/) | sounds/maps/human/airplane_radio.ogg
sound/world/human/snoring.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_misc/snore.wav; sounds/maps/human/snoring.ogg
sound/world/human/spurs.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [CGEffex](https://freesound.org/people/CGEffex/) | [freesound.org](https://freesound.org/s/98816/) | sound/pad_harm/boot_spurs.wav; sounds/maps/human/footsteps_spurs.ogg
sound/world/machine/aircon.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [digitopia](https://freesound.org/people/digitopia/) | [freesound.org](https://freesound.org/s/77008/) | sound/pad_ambiente/aircon02.wav; sounds/maps/machine/air_conditioning.ogg
sound/world/machine/aircon.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_ambiente/aircon02.wav; sounds/maps/machine/air_conditioning.ogg
sound/world/machine/cam_8mm.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Eelke](https://freesound.org/people/Eelke/) | [freesound.org](https://freesound.org/s/105210/) | sound/pad_harm/filmcamera2.wav; sounds/maps/machine/camera_film_8mm.ogg
sound/world/machine/cam_old.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [bjornredtail](https://freesound.org/people/bjornredtail/) | [freesound.org](https://freesound.org/s/13687/) | sound/pad_harm/filmcamera.wav; sounds/maps/machine/camera_film_old.ogg
sound/world/machine/car_onoff.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/car_start03.wav; sounds/maps/machine/car_engine_onoff.ogg
sound/world/machine/clock_alarm.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_jail/pad_jail2_clock_alarm.wav; sounds/maps/machine/clock_alarm.ogg
sound/world/machine/clock_ticking.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_jail/pad_jail_clock_silent.wav; sounds/maps/machine/clock_ticking.ogg
sound/world/machine/coffee_maker.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [pauliep83](https://freesound.org/people/pauliep83/) | [freesound.org](https://freesound.org/s/32991/) | sound/pad_misc/cofmachine.wav; sounds/maps/machine/coffee_maker_dripping.ogg
sound/world/machine/dingdong.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [aaronray](https://freesound.org/people/aaronray/) | [freesound.org](https://freesound.org/s/71996/) | sounds/maps/machine/airplane_dingdong.ogg
sound/world/machine/electric_sizzle.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | [Timbre](https://freesound.org/people/Timbre/) | [freesound.org](https://freesound.org/s/101334/) | sound/pad_effecte/electro01.wav; sounds/maps/machine/electric_sizzle.ogg
sound/world/machine/electric_sparks.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Halleck](https://freesound.org/people/Halleck/) | [freesound.org](https://freesound.org/s/19483/) | sound/pad_effecte/electro02.wav; sounds/maps/machine/electric_sparks.ogg
sound/world/machine/fan_pc.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [earthsounds](https://freesound.org/people/earthsounds/) | [freesound.org](https://freesound.org/s/101397/) | sound/pad_harm/pcfan.wav; sounds/maps/machine/fan_pc.ogg
sound/world/machine/fishtank.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [dobroide](https://freesound.org/people/dobroide/) | [freesound.org](https://freesound.org/s/4247/) | sound/pad_harm/fishtank_loop.wav; sounds/maps/machine/fish_tank_trickle.ogg
sound/world/machine/fog_horn.ogg | | Adam Smith | http://www.shiphorns.com | sound/pad_jail/boat_horn2.wav; sounds/maps/machine/fog_horn.ogg
sound/world/machine/freezer.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_ambiente/freezerhum.wav; sounds/maps/machine/freezer_hum.ogg
sound/world/machine/harddisk.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [cooljoe](https://freesound.org/people/cooljoe/) | [freesound.org](https://freesound.org/s/48400/) | sounds/maps/machine/harddisk_writing.ogg
sound/world/machine/harley_start.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [johnmcd](https://freesound.org/people/johnmcd/) | [freesound.org](https://freesound.org/s/35537/) | sound/pad_misc/harley.wav; sounds/maps/machine/harley_start.ogg
sound/world/machine/jet_idle.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Tomlija](https://freesound.org/people/Tomlija/) | [freesound.org](https://freesound.org/s/101278/) | sound/pad_ambiente/machine14.wav; sounds/maps/machine/jet_idle.ogg
sound/world/machine/mechanics.ogg | [![CC-BY-NC](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc.svg "CC-BY-NC")](https://creativecommons.org/licenses/by-nc/3.0/) | Stephan Schutze | [soundbible.com](https://soundbible.com/1734-Faulty-Mechanics.html) | sound/pad_jail/pad_jail_engine.wav; sounds/maps/machine/faulty_mechanics.ogg
sound/world/machine/portal_idle.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [zimbot](https://freesound.org/people/zimbot/) | [freesound.org](https://freesound.org/s/122987/) | sounds/maps/machine/portal_idle.ogg
sound/world/machine/transformer.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_effecte/electro03.wav; sounds/maps/machine/transformer_hum.ogg
sound/world/machine/truck_start.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [roscoetoon](https://freesound.org/people/roscoetoon/) | [freesound.org](https://freesound.org/s/26814/) | sound/pad_misc/cartruck_start.wav; sounds/maps/machine/truck_start.ogg
sound/world/machine/tv_upstairs.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | Kai Bergmann | Kai Bergmann | sound/pad_ambiente/tv_nextroom.wav; sounds/maps/machine/channel_hopping_upstairs.ogg
sound/world/machine/ventilation.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [Sea Fury](https://freesound.org/people/Sea%20Fury/) | [freesound.org](https://freesound.org/s/54638/) | sound/pad_misc/fannn.wav; sounds/maps/machine/ventilation_system.ogg
sound/world/machine/wind_turbine.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [dommygee](https://freesound.org/people/dommygee/) | [freesound.org](https://freesound.org/s/13160/) | sound/pad_ambiente/fan04.wav; sounds/maps/machine/wind_turbine.ogg
sound/world/misc/air_leakage.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [altemark](https://freesound.org/people/altemark/) | [freesound.org](https://freesound.org/s/43322/) | sound/pad_jail/pad_jail_air.wav; sounds/maps/misc/air_leakage.ogg
sound/world/misc/alarm_buzzer.ogg | | HardPCM | https://freesound.org | sound/pad_effecte/alarm03.wav; sounds/maps/misc/alarm_buzzer.ogg
sound/world/misc/an_eastwood.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | Simon Furkert | Simon Furkert | sound/pad_harm/eastwood.wav; sounds/maps/misc/announcement_eastwood.ogg
sound/world/misc/an_endres.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | Simon Furkert | Simon Furkert | sound/pad_harm/endres_asleep.wav; sounds/maps/misc/announcement_endres.ogg
sound/world/misc/an_session.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | Simon Furkert | Simon Furkert | sound/pad_harm/session_canceled.wav; sounds/maps/misc/announcement_session.ogg
sound/world/misc/bicycle_bell.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [UncleSigmund](https://freesound.org/people/UncleSigmund/) | [freesound.org](https://freesound.org/s/32321/) | sound/pad_misc/bicyclebell.wav | sound/pad_misc/bicyclebell.wav; sounds/maps/misc/bicycle_bell.ogg
sound/world/misc/door_buzzer.ogg | [Terms of use](https://www.pacdv.com/sounds) | [PacDV](https://www.pacdv.com/sounds) | [pacdv.com](https://www.pacdv.com/sounds/) | sound/pad_misc/bell_door.wav; sounds/maps/misc/door_buzzer.ogg
sound/world/misc/evil_laughter.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [teqstudios](https://freesound.org/people/teqstudios/) | [freesound.org](https://freesound.org/s/118703/) | sound/pad_misc/monsterlach.wav; sounds/maps/misc/evil_laughter.ogg
sound/world/misc/fence_hit.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [RHumphries](https://freesound.org/people/RHumphries/) | [freesound.org](https://freesound.org/s/7148/) | sound/pad_jail/jail2_fence.wav; sounds/maps/misc/fence_hit.ogg
sound/world/misc/give_it.ogg | [![CC-BY-NC-SA](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-sa.svg "CC-BY-NC-SA")](https://creativecommons.org/licenses/by-nc-sa/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann | sounds/maps/misc/give_it.ogg
sound/world/misc/mobile_n3.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_effecte/beeb02.wav; sounds/maps/misc/mobile_deal_n3.ogg
sound/world/misc/mobile_n7.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_effecte/beeb03.wav; sounds/maps/misc/mobile_deal_n7.ogg
sound/world/misc/mobile_ring.ogg | [![CC-0](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/cc-zero.svg "CC-0")](https://creativecommons.org/publicdomain/zero/1.0/) | [Tempouser](https://freesound.org/people/Tempouser/) | [freesound.org](https://freesound.org/s/121229/) | sound/pad_misc/phone07.wav; sounds/maps/misc/mobile_ringtone.ogg
sound/world/misc/school_bell.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [John_Sauter](https://freesound.org/people/John_Sauter/) | [freesound.org](https://freesound.org/s/11171/) | sound/pad_misc/bell01.wav; sounds/maps/misc/school_bell.ogg
sound/world/misc/secret_found.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [grunz](https://freesound.org/people/grunz/) | [freesound.org](https://freesound.org/s/109662/) | sound/pad_misc/secret05.wav; sounds/maps/misc/secret_found.ogg
sound/world/misc/shot_long.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [Rock Savage](https://freesound.org/people/Rock%20Savage/) | [freesound.org](https://freesound.org/s/58906/) | sound/pad_harm/westernshot1.wav; sounds/maps/misc/gunshot_long.ogg
sound/world/misc/shot_short.ogg | [![CC-Sampling+](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/sampling-plus.svg "CC-Sampling+")](https://creativecommons.org/licenses/sampling+/1.0/) | [Rock Savage](https://freesound.org/people/Rock%20Savage/) | [freesound.org](https://freesound.org/s/58904/) | sound/pad_harm/westernshot2.wav; sounds/maps/misc/gunshot_short.ogg
sound/world/misc/steam_leakage.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [altemark](https://freesound.org/people/altemark/) | [freesound.org](https://freesound.org/s/43322/) | sound/pad_ambiente/steam01.wav; sounds/maps/misc/steam_leakage.ogg
sound/world/misc/strange_signal.ogg | [![CC-BY](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by.svg "CC-BY")](https://creativecommons.org/licenses/by/3.0/) | [FreqMan](https://freesound.org/people/FreqMan/) | [freesound.org](https://freesound.org/s/24962/) | sounds/maps/misc/strange_signal.ogg
sound/world/misc/toilet_flush.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/toilet01.wav; sounds/maps/misc/toilet_flush.ogg
sound/world/misc/toy_squeeze.ogg | | m_O_m | https://freesound.org | sound/cybbath/quak01.wav; sounds/maps/misc/toy_squeeze.ogg
sound/world/misc/wind_chimes.ogg | [Terms of use](https://www.soundjay.com/tos.html) | [Sound Jay](https://www.soundjay.com) | [soundjay.com](https://www.soundjay.com) | sound/pad_misc/wind_bell.wav; sounds/maps/misc/wind_chimes.ogg
wopmusic/dieselkopf1/01_down the hatch.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/02_padrun.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/03_padtrail.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/04_padrocknroll.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/05_padspace.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/06_padpsychic.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/07_padracer.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/08_padshop.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/09_padmeany.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/10_padkitchen.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf1/11_padmod song.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/01_twisting truth.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/02_walldrive.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/03_gon 2.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/04_skin.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/05_rickys hand.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/06_brain surgery.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/07_liar.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/08_live your life.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/09_sentimantel blur.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/10_sergant blues.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf2/11_final space.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/01_padgallery.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/02_beat under construction.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/03_strangling a ghost.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/04_birth.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/05_padrobot.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/06_hopefully.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/07_padattic.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/08_woohoo.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/09_padcenter.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/10_overture.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/dieselkopf3/11_synthlite.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Dieselkopf](https://www.n1m.com/dieselkopf/) | Ronny Rasmusson
wopmusic/greensun/01_things you see.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/02_angels never cry.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/03_reset the sun.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/04_80 days.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/05_tomorrow.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/06_different (feat tina).ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/07_with a smile.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/08_ever in mind.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/greensun/09_pad-anthem.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | [Green Sun](https://www.facebook.com/GreenSunBand/) | Kai Bergmann
wopmusic/mightypete/01_better luck next time.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/02_clean up isle three.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/03_padlilly serenata.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/04_padgirl serenade.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/05_monster mash.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/06_on our way.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/mightypete/07_voyager.ogg | [![CC-BY-NC-ND](https://mirrors.creativecommons.org/presskit/buttons/80x15/svg/by-nc-nd.svg "CC-BY-NC-ND")](https://creativecommons.org/licenses/by-nc-nd/4.0/) | Mighty Pete | Mighty Pete
wopmusic/neurological1/01_paintfull death.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/02_deadly miniature.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/03_shades of red.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/04_jump high.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/05_pad destroyer.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/06_rise of the killer ducks.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/07_peace and love.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/08_respawn.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological1/09_water horizon.ogg | [Terms of use](https://youtu.be/Ds9KpVl0CFA?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/01_kopov.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/02_alabaster fusion.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/03_mud rock stencil.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/04_guests.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/05_trigger cane.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/06_one last door to close.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological2/07_milton boulevard.ogg | [Terms of use](https://youtu.be/owynEpGZPdI?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/01_addestra cani.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/02_renting barnacles.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/03_the dissociation of gustav.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/04_do you love white people.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/05_vector.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/06_log increase of oven temperature.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
wopmusic/neurological3/07_voyager.ogg | [Terms of use](https://youtu.be/Dtz7gCopFqM?feature=shared) | [Neurological](https://www.youtube.com/@neurological2170) | Nicola Capecci
