<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

July 13, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Troy Sobotka

# **OCIO TSC Meeting Notes**

* CLA, DCO, sign-off, challenge for first contribution and new contributors.
    - New system often has problems for new contributors. People forget to 
      sign-off, sign CLA etc. Can be tough to resolve related issues in PRs.
    - Michael: Could improve CONTRIBUTING.md to further clarify process.
    - Troy: CLA was painless. Sign-off was confusing.
    - Mark: It is confusing. Just need the sign-off line. DCO plugin will try 
      to help, but not always clear or effective solution.
    - Sean: DCO sign-off can mess up commits for PRs with multiple 
      contributors.
    - Patrick: Sometimes these issues require redoing a PR.
    - Troy: This is especially important for documentation work. A road block 
      for small fixes like typos.
    - Sean: Agree. It becomes noise that takes time and effort to solve.
    - **TODO**: Michael will reach out to LF about improving usability of DCO 
      plugin. Perhaps a method for signing off commits within a PR?
    - **TODO**: Look into git mechanism to require sign-off when committing 
      from local machine; method for solving issue before a PR is opened.

* ociodisplay improvements or other ideas for contributors to work on?
    - Patrick: Student eager to contribute. Looking for defects to solve. Any 
      ideas for improvement? GSoC projects could be "revisited" to become GH
      issues (smaller size).
    - Michael: Does ociodisplay support dynamic properties?
    - Patrick: Yes. ociodisplay is in good shape with recent updates, but could 
      be improved further. Would be great to get feedback from production use
      cases.

* GPU CI update:
    - Michael: Need to follow up with LF releng on getting AWS CodeBuild 
      project created. Current DRAFT PR is in-theory read to go, but we'll see
      once the infrastructure is in place.
    - **TODO** Michael will follow up with LF releng on next steps.
    - Patrick: Keep us in loop. The work on headless rendering can be completed 
      once GPU CI is in place.

* SIGGRAPH/OSD/DigiPro update:
    - Michael: Not much new to report, but there is quite a bit of discussion 
      happening around the topic. Will likely be a major point at the next TAC
      meeting. Events are coming up quickly.
    - **TODO**: Waiting to hear details on DigiPro talk recording for Doug.

* Working group meetings:
  - Doug: ACES impl TAC meeting tomorrow, which conflicts with ACES config 
    meeting. Several of us need to be there.
  - Michael: We can cancel. Thomas submitted PR with config discovery work 
    which needs review in the meantime.
  - There are also conflicts for the documentation working group meeting this 
    week. Can cancel that too.
  - **TODO**: Michael will cancel this week's working group meetings.
  - **TODO**: Sean lost write access to OCIO GH account. Michael will reach out 
    to LF about getting that restored.

* Documentation update:
  - Sean: Looking at RTD more. Can't build OCIO through RTD currently, which is 
    problematic. Need to do local build to generate Python API RST. Sphinx will 
    render RST from autodoc signatures. RTD picks that up and renders HTML. 
    Need to add this process to CMake target.
  - Michael: PR needed to update docs?
  - Sean: Yes, but only needed when public API changes. The built RST needs to 
    be added to the main repo, under docs/. Has normal RST and API RST subdir, 
    which only contains autodoc content initially, but is built into RST.
  - Mark: Bad to have build artifacts contributed to repo.
  - Sean: Need to see what Larry is doing in OIIO docs. Another option could be 
    to upload generated HTML from CI to RTD.
  - Mark: Why is build needed to get RST? 
  - Sean: Because of building python bindings, which depend on the OCIO lib, 
    and doxygen too.
  - Michael: pybind11 provides signatures and types etc.
  - Mark: Could make a basic stub version of OCIO lib just for pybind; fast cpp 
    build to trick the system, but would have to maintain the moc lib build. 
    Could even auto-create it.
  - Patrick: Too many steps. Need to be careful not to make development 
    overcomplicated.
  - Sean: Has PR on standby with doxygen header reformatting. Waiting on CMake 
    updates to complete. Also created style guide for how to maintain new 
    header formatting.
  - Doug: The doxygen merge is needed soon to avoid further work.
  - **TODO**: Investigate if RTD can support build step for generating docs.
  - **TODO**: Sean to retry PR to Michael's CMake branch on the new clean 
    branch.
    
* Notes:
    - Patrick is on vacation for the last two weeks of July.
