/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositorySystemLifecycle;

@Singleton
@Named
public class DefaultRepositorySystemLifecycle
implements RepositorySystemLifecycle {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<Runnable> onSystemEndedHandlers = new CopyOnWriteArrayList();

    @Inject
    public DefaultRepositorySystemLifecycle() {
    }

    @Override
    public void addOnSystemEndedHandler(Runnable handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        this.requireNotShutdown();
        this.onSystemEndedHandlers.add(0, handler);
    }

    private void requireNotShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }
}

