// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief  q^2 in D_s+ -> K0 e+ nu_e
  class BESIII_2024_I2802565 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2802565);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::pid==431);
      declare(ufs, "UFS");
      DecayedParticles DS(ufs);
      DS.addStable(PID::PI0);
      DS.addStable(PID::K0S);
      DS.addStable(PID::ETA);
      DS.addStable(PID::ETAPRIME);
      declare(DS, "DS");

      // Book histograms
      book(_h_q2, 1, 1, 1);
      book(_nD,"/TMP/nD");
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      static const map<PdgId,unsigned int> & mode1 = { { 310,1}, {-11,1}, { 12,1}};
      static const map<PdgId,unsigned int> & mode2 = { { 130,1}, {-11,1}, { 12,1}};
      static const map<PdgId,unsigned int> & mode3 = { { 311,1}, {-11,1}, { 12,1}};
      DecayedParticles DS = apply<DecayedParticles>(event, "DS");
      // loop over particles
      for(unsigned int ix=0;ix<DS.decaying().size();++ix) {
        _nD->fill();
        if(DS.modeMatches(ix,3,mode1)) {
          _h_q2->fill((DS.decaying()[ix].momentum()-DS.decayProducts()[ix].at(310)[0].momentum()).mass2());
        }
        else if(DS.modeMatches(ix,3,mode2)) {
          _h_q2->fill((DS.decaying()[ix].momentum()-DS.decayProducts()[ix].at(130)[0].momentum()).mass2());
        }
        else if(DS.modeMatches(ix,3,mode3)) {
          _h_q2->fill((DS.decaying()[ix].momentum()-DS.decayProducts()[ix].at(311)[0].momentum()).mass2());
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      // normalise to width in inverse ns
      scale(_h_q2, 1./0.504e-3/ *_nD);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h_q2;
    CounterPtr _nD;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2802565);

}
