/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class XSLLeafNodeConstructor
extends StyleElement {
    protected Expression select = null;

    protected Expression prepareAttributesNameAndSelect() throws XPathException {
        Expression name = null;
        String nameAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            name = this.makeAttributeValueTemplate(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        return name;
    }

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        if (this.select != null && this.hasChildNodes()) {
            String errorCode = this.getErrorCodeForSelectPlusContent();
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", errorCode);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo first = kids.next();
        if (this.select == null) {
            if (first == null) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING, (Container)this);
                this.select.setContainer(this);
            } else if (kids.next() == null && !this.isExpandingText() && first.getNodeKind() == 3) {
                this.select = new StringLiteral(first.getStringValue(), (Container)this);
                this.select.setContainer(this);
            }
        }
    }

    protected abstract String getErrorCodeForSelectPlusContent();

    protected void compileContent(Compilation exec, ComponentDeclaration decl, SimpleNodeConstructor inst, Expression separator) throws XPathException {
        if (separator == null) {
            separator = new StringLiteral(StringValue.SINGLE_SPACE, (Container)this);
        }
        try {
            if (this.select == null) {
                this.select = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
            }
            this.select = XSLLeafNodeConstructor.makeSimpleContentConstructor(this.select, separator, exec.getConfiguration());
            inst.setSelect(this.select, exec.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public static Expression makeSimpleContentConstructor(Expression select, Expression separator, Configuration config) {
        select = AdjacentTextNodeMerger.makeAdjacentTextNodeMerger(select);
        select = Atomizer.makeAtomizer(select);
        select = new AtomicSequenceConverter(select, BuiltInAtomicType.STRING);
        ((AtomicSequenceConverter)select).allocateConverter(config, false);
        if (select.getCardinality() != 16384) {
            select = SystemFunctionCall.makeSystemFunction("string-join", new Expression[]{select, separator});
        }
        return select;
    }
}

