// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// RouteTableServiceClient is a vpc.RouteTableServiceClient with
// lazy GRPC connection initialization.
type RouteTableServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Create(ctx context.Context, in *vpc.CreateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Delete(ctx context.Context, in *vpc.DeleteRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Get(ctx context.Context, in *vpc.GetRouteTableRequest, opts ...grpc.CallOption) (*vpc.RouteTable, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) List(ctx context.Context, in *vpc.ListRouteTablesRequest, opts ...grpc.CallOption) (*vpc.ListRouteTablesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).List(ctx, in, opts...)
}

type RouteTableIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RouteTableServiceClient
	request *vpc.ListRouteTablesRequest

	items []*vpc.RouteTable
}

func (c *RouteTableServiceClient) RouteTableIterator(ctx context.Context, req *vpc.ListRouteTablesRequest, opts ...grpc.CallOption) *RouteTableIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RouteTableIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RouteTableIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.RouteTables
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RouteTableIterator) Take(size int64) ([]*vpc.RouteTable, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.RouteTable

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RouteTableIterator) TakeAll() ([]*vpc.RouteTable, error) {
	return it.Take(0)
}

func (it *RouteTableIterator) Value() *vpc.RouteTable {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RouteTableIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) ListOperations(ctx context.Context, in *vpc.ListRouteTableOperationsRequest, opts ...grpc.CallOption) (*vpc.ListRouteTableOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).ListOperations(ctx, in, opts...)
}

type RouteTableOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RouteTableServiceClient
	request *vpc.ListRouteTableOperationsRequest

	items []*operation.Operation
}

func (c *RouteTableServiceClient) RouteTableOperationsIterator(ctx context.Context, req *vpc.ListRouteTableOperationsRequest, opts ...grpc.CallOption) *RouteTableOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RouteTableOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RouteTableOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RouteTableOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RouteTableOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *RouteTableOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RouteTableOperationsIterator) Error() error {
	return it.err
}

// Move implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Move(ctx context.Context, in *vpc.MoveRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Update(ctx context.Context, in *vpc.UpdateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Update(ctx, in, opts...)
}
