/*
 * Decompiled with CFR 0.152.
 */
package sjpp;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import sjpp.ContextMode;
import sjpp.Define;
import sjpp.Header;
import sjpp.JavaFile;

public class Context {
    public static final String GENERATED = "// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.";
    private Define define;
    private Header header;
    private final ContextMode mode;
    private final List<JavaFile> files = new ArrayList<JavaFile>();
    private final Collection<String> removedCurrentFolder = new HashSet<String>();
    private final Collection<String> removedfolderAndSubfolders = new HashSet<String>();
    private final Collection<JavaFile> removedFiles = new HashSet<JavaFile>();
    private final Path source;

    public Context(ContextMode mode, Path source) {
        this.source = source;
        this.mode = mode;
    }

    public void addDefine(String id) {
        this.define = new Define(id);
    }

    public void addHeader(List<String> headerLines) throws IOException {
        this.header = new Header(headerLines);
    }

    public Header getHeader() {
        return this.header;
    }

    public boolean doesApplyOn(String s) {
        return this.define.doesApplyOn(s);
    }

    private void addPath(Path path) {
        try {
            this.files.add(new JavaFile(this, path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process(Path destination) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        System.err.println("Starting...");
        Files.walk(this.source, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(this::addPath);
        System.err.println("(" + (System.currentTimeMillis() - start) + " ms) load start");
        for (JavaFile file : this.files) {
            if (!this.isRemoved(file) || this.removedFiles.contains(file)) continue;
            this.removedFiles.add(file);
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        System.err.println("(Using " + availableProcessors + " runners)");
        ExecutorService executorService = Executors.newFixedThreadPool(availableProcessors);
        for (final JavaFile file : this.files) {
            if (this.removedFiles.contains(file)) continue;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    file.process();
                }
            });
        }
        System.err.println("(" + (System.currentTimeMillis() - start) + " ms) load done");
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.HOURS);
        System.err.println("(" + (System.currentTimeMillis() - start) + " ms) process done");
        this.deleteJavaFilesSafe(destination);
        for (final JavaFile file : this.files) {
            if (this.removedFiles.contains(file)) continue;
            Path newPath = file.getNewPath(destination);
            file.save(newPath);
        }
        System.err.println("(" + (System.currentTimeMillis() - start) + " ms) saving done");
    }

    private void deleteJavaFilesSafe(Path out) throws IOException {
        Files.createDirectories(out, new FileAttribute[0]);
        Files.walk(out, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(path -> {
            try {
                String first = Files.readAllLines(path).get(0);
                if (first.startsWith(GENERATED)) {
                    Files.delete(path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void removeCurrentFolder(String packageName) {
        this.removedCurrentFolder.add(packageName);
    }

    public void removeFolderAndSubfolders(String packageName) {
        this.removedfolderAndSubfolders.add(packageName);
    }

    public void removeFile(JavaFile javaFile) {
        this.removedFiles.add(javaFile);
    }

    private boolean isRemoved(JavaFile javaFile) {
        for (String p : this.removedfolderAndSubfolders) {
            if (!javaFile.getPackageName().startsWith(p)) continue;
            return true;
        }
        for (String p : this.removedCurrentFolder) {
            if (!javaFile.getPackageName().equals(p)) continue;
            return true;
        }
        return this.removedFiles.contains(javaFile);
    }

    public boolean removeImportLine(String importName) {
        for (JavaFile file : this.removedFiles) {
            if (!file.isItMe(importName)) continue;
            return true;
        }
        return false;
    }

    public final Path getRoot() {
        return this.source;
    }

    public ContextMode getMode() {
        return this.mode;
    }
}

