package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigHealthCheck invokes the ddoscoo.ConfigHealthCheck API synchronously
func (client *Client) ConfigHealthCheck(request *ConfigHealthCheckRequest) (response *ConfigHealthCheckResponse, err error) {
	response = CreateConfigHealthCheckResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigHealthCheckWithChan invokes the ddoscoo.ConfigHealthCheck API asynchronously
func (client *Client) ConfigHealthCheckWithChan(request *ConfigHealthCheckRequest) (<-chan *ConfigHealthCheckResponse, <-chan error) {
	responseChan := make(chan *ConfigHealthCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigHealthCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigHealthCheckWithCallback invokes the ddoscoo.ConfigHealthCheck API asynchronously
func (client *Client) ConfigHealthCheckWithCallback(request *ConfigHealthCheckRequest, callback func(response *ConfigHealthCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigHealthCheckResponse
		var err error
		defer close(result)
		response, err = client.ConfigHealthCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigHealthCheckRequest is the request struct for api ConfigHealthCheck
type ConfigHealthCheckRequest struct {
	*requests.RpcRequest
	HealthCheck     string           `position:"Query" name:"HealthCheck"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	FrontendPort    requests.Integer `position:"Query" name:"FrontendPort"`
	ForwardProtocol string           `position:"Query" name:"ForwardProtocol"`
}

// ConfigHealthCheckResponse is the response struct for api ConfigHealthCheck
type ConfigHealthCheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigHealthCheckRequest creates a request to invoke ConfigHealthCheck API
func CreateConfigHealthCheckRequest() (request *ConfigHealthCheckRequest) {
	request = &ConfigHealthCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ConfigHealthCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigHealthCheckResponse creates a response to parse from ConfigHealthCheck response
func CreateConfigHealthCheckResponse() (response *ConfigHealthCheckResponse) {
	response = &ConfigHealthCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
