package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyApiGroupVpcWhitelist invokes the cloudapi.ModifyApiGroupVpcWhitelist API synchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyapigroupvpcwhitelist.html
func (client *Client) ModifyApiGroupVpcWhitelist(request *ModifyApiGroupVpcWhitelistRequest) (response *ModifyApiGroupVpcWhitelistResponse, err error) {
	response = CreateModifyApiGroupVpcWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyApiGroupVpcWhitelistWithChan invokes the cloudapi.ModifyApiGroupVpcWhitelist API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyapigroupvpcwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyApiGroupVpcWhitelistWithChan(request *ModifyApiGroupVpcWhitelistRequest) (<-chan *ModifyApiGroupVpcWhitelistResponse, <-chan error) {
	responseChan := make(chan *ModifyApiGroupVpcWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyApiGroupVpcWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyApiGroupVpcWhitelistWithCallback invokes the cloudapi.ModifyApiGroupVpcWhitelist API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyapigroupvpcwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyApiGroupVpcWhitelistWithCallback(request *ModifyApiGroupVpcWhitelistRequest, callback func(response *ModifyApiGroupVpcWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyApiGroupVpcWhitelistResponse
		var err error
		defer close(result)
		response, err = client.ModifyApiGroupVpcWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyApiGroupVpcWhitelistRequest is the request struct for api ModifyApiGroupVpcWhitelist
type ModifyApiGroupVpcWhitelistRequest struct {
	*requests.RpcRequest
	GroupId       string `position:"Query" name:"GroupId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	VpcIds        string `position:"Query" name:"VpcIds"`
}

// ModifyApiGroupVpcWhitelistResponse is the response struct for api ModifyApiGroupVpcWhitelist
type ModifyApiGroupVpcWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyApiGroupVpcWhitelistRequest creates a request to invoke ModifyApiGroupVpcWhitelist API
func CreateModifyApiGroupVpcWhitelistRequest() (request *ModifyApiGroupVpcWhitelistRequest) {
	request = &ModifyApiGroupVpcWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyApiGroupVpcWhitelist", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyApiGroupVpcWhitelistResponse creates a response to parse from ModifyApiGroupVpcWhitelist response
func CreateModifyApiGroupVpcWhitelistResponse() (response *ModifyApiGroupVpcWhitelistResponse) {
	response = &ModifyApiGroupVpcWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
