/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.internal.loader;

import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptFileReference
implements Comparable<ScriptFileReference> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptFileReference.class);
    private final AtomicBoolean queued = new AtomicBoolean();
    private final AtomicBoolean loaded = new AtomicBoolean();
    private final Path scriptFilePath;
    private final String scriptType;
    private final int startLevel;

    public ScriptFileReference(Path scriptFilePath, String scriptType, int startLevel) {
        this.scriptFilePath = scriptFilePath;
        this.scriptType = scriptType;
        this.startLevel = startLevel;
    }

    public String getScriptIdentifier() {
        return ScriptFileReference.getScriptIdentifier(this.scriptFilePath);
    }

    public Path getScriptFilePath() {
        return this.scriptFilePath;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public AtomicBoolean getLoadedStatus() {
        return this.loaded;
    }

    public AtomicBoolean getQueueStatus() {
        return this.queued;
    }

    @Override
    public int compareTo(ScriptFileReference other) {
        int startLevelCompare = Integer.compare(this.startLevel, other.startLevel);
        if (startLevelCompare != 0) {
            return startLevelCompare;
        }
        String name1 = this.scriptFilePath.getFileName().toString();
        LOGGER.trace("o1 [{}], name1 [{}]", (Object)this.scriptFilePath, (Object)name1);
        String name2 = other.scriptFilePath.getFileName().toString();
        LOGGER.trace("o2 [{}], name2 [{}]", (Object)other.scriptFilePath, (Object)name2);
        int nameCompare = name1.compareToIgnoreCase(name2);
        if (nameCompare != 0) {
            return nameCompare;
        }
        return this.scriptFilePath.getParent().toString().compareToIgnoreCase(other.scriptFilePath.getParent().toString());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptFileReference that = (ScriptFileReference)o;
        return this.scriptFilePath.equals(that.scriptFilePath);
    }

    public int hashCode() {
        return Objects.hash(this.scriptFilePath, this.scriptType, this.startLevel);
    }

    public static String getScriptIdentifier(Path scriptFilePath) {
        return scriptFilePath.toString();
    }
}

