/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.Settings;
import org.asamk.signal.manager.api.AccountCheckException;
import org.asamk.signal.manager.api.NotRegisteredException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.ServiceEnvironment;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.internal.AccountFileUpdaterImpl;
import org.asamk.signal.manager.internal.ManagerImpl;
import org.asamk.signal.manager.internal.MultiAccountManagerImpl;
import org.asamk.signal.manager.internal.PathConfig;
import org.asamk.signal.manager.internal.ProvisioningManagerImpl;
import org.asamk.signal.manager.internal.RegistrationManagerImpl;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.accounts.AccountsStore;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.exceptions.DeprecatedVersionException;

public class SignalAccountFiles {
    private static final Logger logger = LoggerFactory.getLogger(MultiAccountManager.class);
    private final PathConfig pathConfig;
    private final ServiceEnvironment serviceEnvironment;
    private final ServiceEnvironmentConfig serviceEnvironmentConfig;
    private final String userAgent;
    private final Settings settings;
    private final AccountsStore accountsStore;

    public SignalAccountFiles(File settingsPath, ServiceEnvironment serviceEnvironment, String userAgent, Settings settings) throws IOException {
        this.pathConfig = PathConfig.createDefault(settingsPath);
        this.serviceEnvironment = serviceEnvironment;
        this.serviceEnvironmentConfig = ServiceConfig.getServiceEnvironmentConfig(this.serviceEnvironment, userAgent);
        this.userAgent = userAgent;
        this.settings = settings;
        this.accountsStore = new AccountsStore(this.pathConfig.dataPath(), serviceEnvironment, accountPath -> {
            if (accountPath == null || !SignalAccount.accountFileExists(this.pathConfig.dataPath(), accountPath)) {
                return null;
            }
            try {
                return SignalAccount.load(this.pathConfig.dataPath(), accountPath, false, settings);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public Set<String> getAllLocalAccountNumbers() throws IOException {
        return this.accountsStore.getAllNumbers();
    }

    public MultiAccountManager initMultiAccountManager() throws IOException, AccountCheckException {
        List<Pair> managerPairs = this.accountsStore.getAllAccounts().parallelStream().map(a -> {
            try {
                return new Pair<Manager, Object>(this.initManager(a.number(), a.path()), null);
            }
            catch (NotRegisteredException e) {
                logger.warn("Ignoring {}: {} ({})", new Object[]{a.number(), e.getMessage(), e.getClass().getSimpleName()});
                return null;
            }
            catch (IOException | AccountCheckException e) {
                logger.error("Failed to load {}: {} ({})", new Object[]{a.number(), e.getMessage(), e.getClass().getSimpleName()});
                return new Pair<Object, Exception>(null, e);
            }
        }).filter(Objects::nonNull).toList();
        for (Pair pair : managerPairs) {
            Object u = pair.second();
            if (u instanceof IOException) {
                IOException e = (IOException)u;
                throw e;
            }
            u = pair.second();
            if (!(u instanceof AccountCheckException)) continue;
            AccountCheckException e = (AccountCheckException)u;
            throw e;
        }
        List<Manager> managers = managerPairs.stream().map(Pair::first).toList();
        return new MultiAccountManagerImpl(managers, this);
    }

    public Manager initManager(String number) throws IOException, NotRegisteredException, AccountCheckException {
        String accountPath = this.accountsStore.getPathByNumber(number);
        return this.initManager(number, accountPath);
    }

    private Manager initManager(String number, String accountPath) throws IOException, NotRegisteredException, AccountCheckException {
        if (accountPath == null) {
            throw new NotRegisteredException();
        }
        if (!SignalAccount.accountFileExists(this.pathConfig.dataPath(), accountPath)) {
            throw new NotRegisteredException();
        }
        SignalAccount account = SignalAccount.load(this.pathConfig.dataPath(), accountPath, true, this.settings);
        if (!number.equals(account.getNumber())) {
            account.close();
            throw new IOException("Number in account file doesn't match expected number: " + account.getNumber());
        }
        if (!account.isRegistered()) {
            account.close();
            throw new NotRegisteredException();
        }
        if (account.getServiceEnvironment() != null && account.getServiceEnvironment() != this.serviceEnvironment) {
            throw new IOException("Account is registered in another environment: " + String.valueOf((Object)account.getServiceEnvironment()));
        }
        account.initDatabase();
        ManagerImpl manager = new ManagerImpl(account, this.pathConfig, new AccountFileUpdaterImpl(this.accountsStore, accountPath), this.serviceEnvironmentConfig, this.userAgent);
        try {
            manager.checkAccountState();
        }
        catch (DeprecatedVersionException e) {
            manager.close();
            throw new AccountCheckException("signal-cli version is too old for the Signal-Server, please update.");
        }
        catch (IOException e) {
            manager.close();
            throw new AccountCheckException("Error while checking account " + number + ": " + e.getMessage(), e);
        }
        if (account.getServiceEnvironment() == null) {
            account.setServiceEnvironment(this.serviceEnvironment);
            this.accountsStore.updateAccount(accountPath, account.getNumber(), account.getAci());
        }
        return manager;
    }

    public ProvisioningManager initProvisioningManager() {
        return this.initProvisioningManager(null);
    }

    public ProvisioningManager initProvisioningManager(Consumer<Manager> newManagerListener) {
        return new ProvisioningManagerImpl(this.pathConfig, this.serviceEnvironmentConfig, this.userAgent, newManagerListener, this.accountsStore);
    }

    public RegistrationManager initRegistrationManager(String number) throws IOException {
        return this.initRegistrationManager(number, null);
    }

    public RegistrationManager initRegistrationManager(String number, Consumer<Manager> newManagerListener) throws IOException {
        String accountPath = this.accountsStore.getPathByNumber(number);
        if (accountPath == null || !SignalAccount.accountFileExists(this.pathConfig.dataPath(), accountPath)) {
            String newAccountPath = accountPath == null ? this.accountsStore.addAccount(number, null) : accountPath;
            IdentityKeyPair aciIdentityKey = KeyUtils.generateIdentityKeyPair();
            IdentityKeyPair pniIdentityKey = KeyUtils.generateIdentityKeyPair();
            ProfileKey profileKey = KeyUtils.createProfileKey();
            SignalAccount account = SignalAccount.create(this.pathConfig.dataPath(), newAccountPath, number, this.serviceEnvironment, aciIdentityKey, pniIdentityKey, profileKey, this.settings);
            account.initDatabase();
            return new RegistrationManagerImpl(account, this.pathConfig, this.serviceEnvironmentConfig, this.userAgent, newManagerListener, new AccountFileUpdaterImpl(this.accountsStore, newAccountPath));
        }
        SignalAccount account = SignalAccount.load(this.pathConfig.dataPath(), accountPath, true, this.settings);
        if (!number.equals(account.getNumber())) {
            account.close();
            throw new IOException("Number in account file doesn't match expected number: " + account.getNumber());
        }
        account.initDatabase();
        return new RegistrationManagerImpl(account, this.pathConfig, this.serviceEnvironmentConfig, this.userAgent, newManagerListener, new AccountFileUpdaterImpl(this.accountsStore, accountPath));
    }
}

