/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jfrog.build.extractor.maven.resolver.ArtifactorySonatypeResolversHelper;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.DefaultMetadataResolver;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.spi.log.Logger;

@Named
@Component(role=ArtifactorySonatypeMetadataResolver.class)
public class ArtifactorySonatypeMetadataResolver
extends DefaultMetadataResolver {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactorySonatypeResolversHelper helper;

    private void enforceResolutionRepositories(RepositorySystemSession session, MetadataRequest request) {
        List<RemoteRepository> repositories = this.helper.getResolutionRepositories(session);
        if (repositories != null && !repositories.isEmpty() && request.getRepository() != null && request.getMetadata() != null) {
            if (request.getMetadata().getNature() == Metadata.Nature.SNAPSHOT) {
                request.setRepository(this.getSnapshotRepository(session));
            } else {
                request.setRepository(this.getReleaseRepository(session));
            }
        }
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        for (MetadataRequest metadataRequest : requests) {
            this.enforceResolutionRepositories(session, metadataRequest);
        }
        return super.resolveMetadata(session, requests);
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        return this.helper.getSnapshotRepository(session);
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        return this.helper.getReleaseRepository(session);
    }
}

